/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.BimServerConfig;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.EmbeddedWebServer;
import org.bimserver.EmbeddedWebServerInterface;
import org.bimserver.LocalDevPluginLoader;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.plugins.OptionsParser;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.shared.LocalDevelopmentResourceFetcher;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDevBimServerStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDevBimServerStarter.class);
    private BimServer bimServer;

    public static void main(String[] args) {
        new LocalDevBimServerStarter().start(-1, "localhost", 8080, 8085, new OptionsParser(args).getPluginDirectories());
    }

    public void start(int id, String address, int port, int pbport, Path[] pluginDirectories) {
        BimServerConfig config = new BimServerConfig();
        config.setHomeDir(Paths.get("home" + (id == -1 ? "" : Integer.valueOf(id)), new String[0]));
        config.setResourceFetcher((ResourceFetcher)new LocalDevelopmentResourceFetcher(Paths.get("../", new String[0])));
        config.setStartEmbeddedWebServer(true);
        config.setClassPath(System.getProperty("java.class.path"));
        config.setLocalDev(true);
        config.setPort(port);
        config.setStartCommandLine(true);
        config.setDevelopmentBaseDir(Paths.get("../BimServer", new String[0]));
        this.bimServer = new BimServer(config);
        this.bimServer.getVersionChecker().getLocalVersion().setDate(new Date());
        this.bimServer.setEmbeddedWebServer((EmbeddedWebServerInterface)new EmbeddedWebServer(this.bimServer, config.getDevelopmentBaseDir(), config.isLocalDev()));
        try {
            this.bimServer.start();
            LocalDevPluginLoader.loadPlugins((PluginManager)this.bimServer.getPluginManager(), (Path[])pluginDirectories);
            try {
                AdminInterface adminInterface = (AdminInterface)this.bimServer.getServiceFactory().get((Authorization)new SystemAuthorization(1, TimeUnit.HOURS), AccessMethod.INTERNAL).get(AdminInterface.class);
                adminInterface.setup("http://localhost:" + port, "My BIMserver", "My Description", "http://localhost:" + port + "/img/bimserver.png", "Administrator", "admin@bimserver.org", "admin");
                SettingsInterface settingsInterface = (SettingsInterface)this.bimServer.getServiceFactory().get((Authorization)new SystemAuthorization(1, TimeUnit.HOURS), AccessMethod.INTERNAL).get(SettingsInterface.class);
                settingsInterface.setCacheOutputFiles(Boolean.valueOf(false));
                settingsInterface.setPluginStrictVersionChecking(Boolean.valueOf(false));
            }
            catch (Exception adminInterface) {
                // empty catch block
            }
            this.bimServer.activateServices();
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (ServiceException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseInitException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseRestartRequiredException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }
}

