/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.bimserver.BimServer;
import org.bimserver.BimServerConfig;
import org.bimserver.EmbeddedWebServer;
import org.bimserver.EmbeddedWebServerInterface;
import org.bimserver.Environment;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.resources.JarResourceFetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarBimServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarBimServer.class);
    private BimServer bimServer;

    public static void main(String[] args) {
        String address = "127.0.0.1";
        String port = "8082";
        String homedir = "home";
        for (String arg : args) {
            if (arg.startsWith("address=")) {
                address = arg.substring(8);
                if (!address.startsWith("\"") || !address.endsWith("\"")) continue;
                address = address.substring(1, address.length() - 1);
                continue;
            }
            if (arg.startsWith("port=")) {
                port = arg.substring(5);
                if (!port.startsWith("\"") || !port.endsWith("\"")) continue;
                port = port.substring(1, port.length() - 1);
                continue;
            }
            if (!arg.startsWith("homedir=") || !(homedir = arg.substring(8)).startsWith("\"") || !homedir.endsWith("\"")) continue;
            homedir = homedir.substring(1, homedir.length() - 1);
        }
        JarBimServer server = new JarBimServer();
        server.start(address, Integer.parseInt(port), homedir, "www");
    }

    public void stop() {
        LOGGER.info("Stopping server...");
        try {
            this.bimServer.stop();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
        LOGGER.info("Server stopped successfully");
    }

    private void fixLogging(BimServerConfig config) throws IOException {
        Path logFolder = config.getHomeDir().resolve("logs");
        if (!Files.isDirectory(logFolder, new LinkOption[0])) {
            Files.createDirectories(logFolder, new FileAttribute[0]);
        }
        Path file = logFolder.resolve("bimserver.log");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        String filename = file.toAbsolutePath().toString();
        if (lc instanceof LoggerContext && !lc.isStarted()) {
            lc.start();
        }
        System.out.println("Logging to " + filename);
        fileAppender.setFile(filename);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        for (ch.qos.logback.classic.Logger log : lc.getLoggerList()) {
            if (log.getLevel() == null) continue;
            log.addAppender((Appender)fileAppender);
        }
    }

    public void start(String address, int port, String homedir, String resourceBase) {
        if (homedir.startsWith("\"") && homedir.endsWith("\"")) {
            homedir = homedir.substring(1, homedir.length() - 2);
        }
        System.setProperty("org.apache.cxf.Logger", "org.apache.cxf.common.logging.Log4jLogger");
        BimServerConfig bimServerConfig = new BimServerConfig();
        bimServerConfig.setHomeDir(Paths.get(homedir, new String[0]));
        bimServerConfig.setResourceFetcher((ResourceFetcher)new JarResourceFetcher());
        bimServerConfig.setStartEmbeddedWebServer(true);
        bimServerConfig.setEnvironment(Environment.JAR);
        bimServerConfig.setPort(port);
        bimServerConfig.setClassPath(System.getProperty("java.class.path"));
        this.bimServer = new BimServer(bimServerConfig);
        try {
            this.fixLogging(bimServerConfig);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            LOGGER.debug("Setting resourcebase to www");
            EmbeddedWebServer embeddedWebServer = new EmbeddedWebServer(this.bimServer, bimServerConfig.getDevelopmentBaseDir(), bimServerConfig.isLocalDev());
            embeddedWebServer.setResourceBase("www");
            this.bimServer.setEmbeddedWebServer((EmbeddedWebServerInterface)embeddedWebServer);
            this.bimServer.start();
            LOGGER.info("Server started successfully");
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

