/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.websocket.DeploymentException;
import javax.websocket.server.ServerContainer;
import org.bimserver.BimServer;
import org.bimserver.EmbeddedWebServerInterface;
import org.bimserver.servlets.RootServlet;
import org.bimserver.servlets.websockets.jsr356.Jsr356Impl;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedWebServer
implements EmbeddedWebServerInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbeddedWebServer.class);
    private WebAppContext context;
    private Server server = new Server();

    public EmbeddedWebServer(BimServer bimServer, Path developmentBaseDir, boolean localDev) {
        ServerConnector socketConnector = new ServerConnector(this.server);
        socketConnector.setPort(bimServer.getConfig().getPort());
        this.server.addConnector((Connector)socketConnector);
        this.context = new WebAppContext((HandlerContainer)this.server, "", "/");
        this.context.setTempDirectory(bimServer.getHomeDir().resolve("jettytmp").toFile());
        try {
            org.eclipse.jetty.websocket.jsr356.server.ServerContainer configureContext = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)this.context);
            Jsr356Impl.setServletContext((ServerContainer)configureContext, (ServletContext)this.context.getServletContext());
            configureContext.addEndpoint(Jsr356Impl.class);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        catch (DeploymentException e) {
            e.printStackTrace();
        }
        if (localDev) {
            // empty if block
        }
        ServletHolder servletHolder = new ServletHolder((Servlet)new RootServlet());
        this.context.addServlet(servletHolder, "/*");
        this.context.getServletContext().setAttribute("bimserver", (Object)bimServer);
        if (this.context.getResourceBase() == null) {
            if (developmentBaseDir == null) {
                this.context.setResourceBase(Paths.get("www", new String[0]).toAbsolutePath().toString());
            } else {
                this.context.setResourceBase(developmentBaseDir.resolve("www").toAbsolutePath().toString());
            }
        }
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public WebAppContext getContext() {
        return this.context;
    }

    public void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void setResourceBase(String resourceBase) {
        this.getContext().setResourceBase(resourceBase);
    }
}

