/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.bimserver.BimServer;
import org.bimserver.BimServerConfig;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.EmbeddedWebServer;
import org.bimserver.EmbeddedWebServerInterface;
import org.bimserver.Environment;
import org.bimserver.LocalDevPluginLoader;
import org.bimserver.StateChangeListener;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.models.log.AccessMethod;
import org.bimserver.models.store.ServerState;
import org.bimserver.plugins.OptionsParser;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.shared.LocalDevelopmentResourceFetcher;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.interfaces.AdminInterface;
import org.bimserver.shared.interfaces.SettingsInterface;
import org.bimserver.webservices.authorization.Authorization;
import org.bimserver.webservices.authorization.SystemAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDevBimServerStarter {
    private BimServer bimServer;

    public static void main(String[] args) {
        OptionsParser optionsParser = new OptionsParser(args);
        new LocalDevBimServerStarter().start(-1, "localhost", "LocalDev BIMserver (8080)", 8080, 8085, optionsParser.getPluginDirectories(), optionsParser.getHome());
    }

    public void start(int id, String address, String name, int port, int pbport, final Path[] pluginDirectories, Path home) {
        block13: {
            BimServerConfig config = new BimServerConfig();
            if (home != null) {
                config.setHomeDir(home);
            } else {
                config.setHomeDir(Paths.get("home" + (id == -1 ? "" : Integer.valueOf(id)), new String[0]));
            }
            config.setResourceFetcher((ResourceFetcher)new LocalDevelopmentResourceFetcher(Paths.get("../", new String[0])));
            config.setStartEmbeddedWebServer(true);
            config.setClassPath(System.getProperty("java.class.path"));
            config.setLocalDev(true);
            config.setEnvironment(Environment.LOCAL_DEV);
            config.setPort(port);
            config.setStartCommandLine(true);
            config.setDevelopmentBaseDir(Paths.get("../BimServer", new String[0]));
            try {
                this.fixLogging(config);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.bimServer = new BimServer(config);
            this.bimServer.getVersionChecker().getLocalVersion().setDate(new Date());
            this.bimServer.setEmbeddedWebServer((EmbeddedWebServerInterface)new EmbeddedWebServer(this.bimServer, config.getDevelopmentBaseDir(), config.isLocalDev()));
            final Logger LOGGER = LoggerFactory.getLogger(LocalDevBimServerStarter.class);
            try {
                this.bimServer.start();
                if (this.bimServer.getServerInfo().getServerState() != ServerState.MIGRATION_REQUIRED) {
                    LocalDevPluginLoader.loadPlugins((PluginManager)this.bimServer.getPluginManager(), (Path[])pluginDirectories);
                    try {
                        AdminInterface adminInterface = (AdminInterface)this.bimServer.getServiceFactory().get((Authorization)new SystemAuthorization(1, TimeUnit.HOURS), AccessMethod.INTERNAL).get(AdminInterface.class);
                        adminInterface.setup("http://localhost:" + port, name, "My Description", "http://localhost:" + port + "/img/bimserver.png", "Administrator", "admin@bimserver.org", "admin");
                        SettingsInterface settingsInterface = (SettingsInterface)this.bimServer.getServiceFactory().get((Authorization)new SystemAuthorization(1, TimeUnit.HOURS), AccessMethod.INTERNAL).get(SettingsInterface.class);
                        settingsInterface.setCacheOutputFiles(Boolean.valueOf(false));
                        settingsInterface.setPluginStrictVersionChecking(Boolean.valueOf(false));
                    }
                    catch (Exception adminInterface) {
                        // empty catch block
                    }
                    this.bimServer.activateServices();
                    break block13;
                }
                this.bimServer.getServerInfoManager().registerStateChangeListener(new StateChangeListener(){

                    public void stateChanged(ServerState oldState, ServerState newState) {
                        if (oldState == ServerState.MIGRATION_REQUIRED && newState == ServerState.RUNNING) {
                            try {
                                LocalDevPluginLoader.loadPlugins((PluginManager)LocalDevBimServerStarter.this.bimServer.getPluginManager(), (Path[])pluginDirectories);
                            }
                            catch (PluginException e) {
                                LOGGER.error("", (Throwable)e);
                            }
                        }
                    }
                });
            }
            catch (PluginException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (ServiceException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (DatabaseInitException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (BimserverDatabaseException e) {
                LOGGER.error("", (Throwable)e);
            }
            catch (DatabaseRestartRequiredException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    private void fixLogging(BimServerConfig config) throws IOException {
        Path logFolder = config.getHomeDir().resolve("logs");
        if (!Files.isDirectory(logFolder, new LinkOption[0])) {
            Files.createDirectories(logFolder, new FileAttribute[0]);
        }
        Path file = logFolder.resolve("bimserver.log");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        String filename = file.toAbsolutePath().toString();
        if (lc instanceof LoggerContext && !lc.isStarted()) {
            lc.start();
        }
        System.out.println("Logging to " + filename);
        fileAppender.setFile(filename);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        for (ch.qos.logback.classic.Logger log : lc.getLoggerList()) {
            if (log.getLevel() == null) continue;
            log.addAppender((Appender)fileAppender);
        }
    }

    public BimServer getBimServer() {
        return this.bimServer;
    }
}

