/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.starter;

import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.lang.management.ManagementFactory;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class JarSettings {
    private File lastFile;
    @XmlElement
    private String jvm = "default";
    @XmlElement
    private String homedir = new File("home").getAbsolutePath();
    @XmlElement
    private String address = "localhost";
    @XmlElement
    private String proxyHost = "";
    @XmlElement
    private boolean useProxy = false;
    @XmlElement
    private int proxyPort = 1080;
    @XmlElement
    private int port = 8082;
    @XmlElement
    private String heapsize = "1024m";
    @XmlElement
    private String stacksize = "1024k";
    @XmlElement
    private boolean forceipv4 = false;

    public JarSettings() {
        OperatingSystemMXBean os = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        long physicalMemorySize = os.getTotalPhysicalMemorySize();
        this.heapsize = Math.min(0x40000000L, physicalMemorySize / 2000000L) + "m";
    }

    public static JarSettings readFromFile() {
        return JarSettings.readFromFile(new File("settings.xml"));
    }

    public static JarSettings readFromFile(File file) {
        if (file.exists()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JarSettings.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                JarSettings unmarshal = (JarSettings)unmarshaller.unmarshal(file);
                unmarshal.setLastFile(file);
                return unmarshal;
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        } else {
            return new JarSettings();
        }
        return null;
    }

    private void setLastFile(File lastFile) {
        this.lastFile = lastFile;
    }

    public void save() {
        if (this.lastFile == null) {
            this.lastFile = new File("settings.xml");
        }
        this.save(this.lastFile);
    }

    public void save(File file) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{JarSettings.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.marshal((Object)this, file);
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHeapsize() {
        return this.heapsize;
    }

    public void setHeapsize(String heapsize) {
        this.heapsize = heapsize;
    }

    public String getStacksize() {
        return this.stacksize;
    }

    public void setStacksize(String stacksize) {
        this.stacksize = stacksize;
    }

    public void setHomedir(String homedir) {
        this.homedir = homedir;
    }

    public String getHomedir() {
        return this.homedir;
    }

    public boolean isForceipv4() {
        return this.forceipv4;
    }

    public void setForceipv4(boolean forceipv4) {
        this.forceipv4 = forceipv4;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }
}

