/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.starter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.bimserver.starter.JarSettings;
import org.bimserver.starter.SpringUtilities;

public class Starter
extends JFrame {
    private static final long serialVersionUID = 5356018168589837130L;
    private Process exec;
    private JarSettings jarSettings = JarSettings.readFromFile();
    private JTextField addressField;
    private JTextField portField;
    private JTextField heapSizeField;
    private JCheckBox forceIpv4Field;
    private JTextField stackSizeField;
    private JButton browserHomeDir;
    private JButton browserJvm;
    private JTextField jvmField;
    private JTextField homeDirField;
    private JCheckBox useProxy;
    private JTextField proxyHost;
    private JTextField proxyPort;
    private JLabel proxyHostLabel;
    private JLabel proxyPortLabel;

    public static void main(String[] args) {
        new Starter().start();
    }

    public void save() {
        try {
            this.jarSettings.setAddress(this.addressField.getText());
            this.jarSettings.setPort(Integer.parseInt(this.portField.getText()));
            this.jarSettings.setJvm(this.jvmField.getText());
            this.jarSettings.setStacksize(this.stackSizeField.getText());
            this.jarSettings.setHeapsize(this.heapSizeField.getText());
            this.jarSettings.setHomedir(this.homeDirField.getText());
            this.jarSettings.setForceipv4(this.forceIpv4Field.isSelected());
            this.jarSettings.setUseProxy(this.useProxy.isSelected());
            this.jarSettings.setProxyHost(this.proxyHost.getText());
            this.jarSettings.setProxyPort(Integer.parseInt(this.proxyPort.getText()));
            this.jarSettings.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void start() {
        final JTextArea logField = new JTextArea();
        final PrintStream systemOut = System.out;
        PrintStream out = new PrintStream(new OutputStream(){

            @Override
            public void write(byte[] bytes, int off, int len) throws IOException {
                String str = new String(bytes, off, len);
                systemOut.append(str);
                logField.append(str);
                logField.setCaretPosition(logField.getDocument().getLength());
            }

            @Override
            public void write(int b) throws IOException {
                String str = new String(new char[]{(char)b});
                systemOut.append(str);
                logField.append(str);
                logField.setCaretPosition(logField.getDocument().getLength());
            }
        });
        System.setOut(out);
        System.setErr(out);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setDefaultCloseOperation(3);
        this.setTitle("BIMserver Starter");
        try {
            this.setIconImage(ImageIO.read(this.getClass().getResource("logo_small.png")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setSize(640, 500);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel fields = new JPanel(new SpringLayout());
        JLabel jvmLabel = new JLabel("JVM");
        fields.add(jvmLabel);
        this.jvmField = new JTextField(this.jarSettings.getJvm());
        this.browserJvm = new JButton("Browse...");
        this.browserJvm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File currentFile = new File(Starter.this.jvmField.getText());
                JFileChooser chooser = new JFileChooser(currentFile.exists() ? currentFile : new File("."));
                chooser.setFileSelectionMode(1);
                int showOpenDialog = chooser.showOpenDialog(Starter.this);
                if (showOpenDialog == 0) {
                    Starter.this.jvmField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JPanel jvmPanel = new JPanel();
        jvmPanel.setLayout(new BorderLayout());
        jvmPanel.add((Component)this.jvmField, "Center");
        jvmPanel.add((Component)this.browserJvm, "East");
        fields.add(jvmPanel);
        JLabel homeDirLabel = new JLabel("Home directory");
        fields.add(homeDirLabel);
        this.homeDirField = new JTextField(this.jarSettings.getHomedir());
        this.browserHomeDir = new JButton("Browse...");
        this.browserHomeDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File currentFile = new File(Starter.this.homeDirField.getText());
                JFileChooser chooser = new JFileChooser(currentFile.exists() ? currentFile : new File("."));
                chooser.setFileSelectionMode(1);
                int showOpenDialog = chooser.showOpenDialog(Starter.this);
                if (showOpenDialog == 0) {
                    Starter.this.homeDirField.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JPanel homeDirPanel = new JPanel();
        homeDirPanel.setLayout(new BorderLayout());
        homeDirPanel.add((Component)this.homeDirField, "Center");
        homeDirPanel.add((Component)this.browserHomeDir, "East");
        fields.add(homeDirPanel);
        JLabel addressLabel = new JLabel("Address");
        fields.add(addressLabel);
        this.addressField = new JTextField(this.jarSettings.getAddress());
        fields.add(this.addressField);
        JLabel portLabel = new JLabel("Port");
        fields.add(portLabel);
        this.portField = new JTextField(this.jarSettings.getPort() + "");
        fields.add(this.portField);
        JLabel heapSizeLabel = new JLabel("Max Heap Size");
        fields.add(heapSizeLabel);
        this.heapSizeField = new JTextField(this.jarSettings.getHeapsize());
        fields.add(this.heapSizeField);
        JLabel stackSizeLabel = new JLabel("Stack Size");
        fields.add(stackSizeLabel);
        this.stackSizeField = new JTextField(this.jarSettings.getStacksize());
        fields.add(this.stackSizeField);
        JLabel forceIpv4Label = new JLabel("Force IPv4");
        fields.add(forceIpv4Label);
        this.forceIpv4Field = new JCheckBox();
        this.forceIpv4Field.setSelected(this.jarSettings.isForceipv4());
        fields.add(this.forceIpv4Field);
        JLabel useProxyLabel = new JLabel("");
        this.useProxy = new JCheckBox("Use proxy server");
        this.useProxy.setSelected(this.jarSettings.isUseProxy());
        fields.add(useProxyLabel);
        fields.add(this.useProxy);
        this.proxyHostLabel = new JLabel("Proxy Host");
        fields.add(this.proxyHostLabel);
        this.proxyHost = new JTextField(this.jarSettings.getProxyHost());
        fields.add(this.proxyHost);
        this.proxyPortLabel = new JLabel("Proxy Port");
        fields.add(this.proxyPortLabel);
        this.proxyPort = new JTextField("" + this.jarSettings.getProxyPort());
        fields.add(this.proxyPort);
        SpringUtilities.makeCompactGrid(fields, 10, 2, 6, 6, 6, 6);
        JPanel buttons = new JPanel(new FlowLayout(4));
        final JButton startStopButton = new JButton("Start");
        startStopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (startStopButton.getText().equals("Start")) {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (Starter.this.jvmField.getText().equalsIgnoreCase("default") || new File(Starter.this.jvmField.getText()).exists()) {
                                Starter.this.setComponentsEnabled(false);
                                File file = Starter.this.expand();
                                startStopButton.setText("Stop");
                                Starter.this.start(file, Starter.this.addressField.getText(), Starter.this.portField.getText(), Starter.this.heapSizeField.getText(), Starter.this.stackSizeField.getText(), Starter.this.jvmField.getText(), Starter.this.homeDirField.getText());
                            } else {
                                JOptionPane.showMessageDialog(Starter.this, "JVM field should contain a valid JVM directory, or 'default' for the default JVM");
                            }
                        }
                    }, "BIMserver Starter Thread").start();
                } else if (startStopButton.getText().equals("Stop") && Starter.this.exec != null) {
                    Starter.this.exec.destroy();
                    System.out.println("Server has been shut down");
                    Starter.this.exec = null;
                    startStopButton.setText("Start");
                    Starter.this.setComponentsEnabled(true);
                }
            }
        });
        DocumentListener documentChangeListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                Starter.this.save();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                Starter.this.save();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                Starter.this.save();
            }
        };
        this.jvmField.getDocument().addDocumentListener(documentChangeListener);
        this.homeDirField.getDocument().addDocumentListener(documentChangeListener);
        this.addressField.getDocument().addDocumentListener(documentChangeListener);
        this.portField.getDocument().addDocumentListener(documentChangeListener);
        this.heapSizeField.getDocument().addDocumentListener(documentChangeListener);
        this.stackSizeField.getDocument().addDocumentListener(documentChangeListener);
        this.useProxy.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Starter.this.updateProxyVisibility();
                Starter.this.save();
            }
        });
        this.proxyHost.getDocument().addDocumentListener(documentChangeListener);
        this.proxyPort.getDocument().addDocumentListener(documentChangeListener);
        this.forceIpv4Field.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Starter.this.save();
            }
        });
        buttons.add(startStopButton);
        JButton launchWebBrowser = new JButton("Launch Webbrowser");
        launchWebBrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://" + Starter.this.addressField.getText() + ":" + Starter.this.portField.getText()));
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        });
        buttons.add(launchWebBrowser);
        logField.setFont(new Font("Monospaced", 0, 12));
        logField.setEditable(true);
        logField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                try {
                    Starter.this.exec.getOutputStream().write(e.getKeyChar());
                    if (e.getKeyCode() == 10) {
                        Starter.this.exec.getOutputStream().flush();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(logField);
        this.getContentPane().add((Component)fields, "North");
        this.getContentPane().add((Component)scrollPane, "Center");
        this.getContentPane().add((Component)buttons, "South");
        this.updateProxyVisibility();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (Starter.this.exec != null) {
                    Starter.this.exec.destroy();
                }
            }
        }, "Thutdown Hook"));
        this.setVisible(true);
    }

    protected void updateProxyVisibility() {
        this.proxyHostLabel.setVisible(this.useProxy.isSelected());
        this.proxyPortLabel.setVisible(this.useProxy.isSelected());
        this.proxyHost.setVisible(this.useProxy.isSelected());
        this.proxyPort.setVisible(this.useProxy.isSelected());
    }

    private void setComponentsEnabled(boolean enabled) {
        this.addressField.setEditable(enabled);
        this.portField.setEditable(enabled);
        this.heapSizeField.setEditable(enabled);
        this.stackSizeField.setEditable(enabled);
        this.jvmField.setEditable(enabled);
        this.homeDirField.setEditable(enabled);
        this.forceIpv4Field.setEnabled(enabled);
        this.browserHomeDir.setEnabled(enabled);
        this.browserJvm.setEnabled(enabled);
        this.proxyHost.setEnabled(enabled);
        this.proxyPort.setEnabled(enabled);
        this.useProxy.setEnabled(enabled);
    }

    /*
     * WARNING - void declaration
     */
    private void start(File destDir, String address, String port, String heapsize, String stacksize, String jvmPath, String homedir) {
        try {
            String os = System.getProperty("os.name");
            boolean isMac = os.toLowerCase().contains("mac");
            System.out.println("OS: " + os);
            this.checkJavaVersion(jvmPath);
            ArrayList<String> commands = new ArrayList<String>();
            if (jvmPath.equalsIgnoreCase("default")) {
                commands.add("java");
            } else {
                File jvm = new File(jvmPath);
                if (jvm.exists()) {
                    void var14_22;
                    void var14_17;
                    File jre = new File(jvm, "jre");
                    if (!jre.exists()) {
                        jre = jvm;
                    }
                    commands.add(new File(jre, "bin" + File.separator + "java").getAbsolutePath());
                    File jreLib = new File(jre, "lib");
                    System.out.println("Using " + jreLib.getAbsolutePath() + " for bootclasspath");
                    String string = "-Xbootclasspath ";
                    File[] fileArray = jreLib.listFiles();
                    int n = fileArray.length;
                    for (int i = 0; i < n; ++i) {
                        File file = fileArray[i];
                        if (!file.getName().endsWith(".jar")) continue;
                        if (file.getAbsolutePath().contains(" ")) {
                            String string2 = (String)var14_17 + "\"" + file.getAbsolutePath() + "\"" + File.pathSeparator;
                            continue;
                        }
                        String string3 = (String)var14_17 + file.getAbsolutePath() + File.pathSeparator;
                    }
                    if (jre != jvm) {
                        File toolsFile = new File(jvm, "lib" + File.separator + "tools.jar");
                        if (toolsFile.getAbsolutePath().contains(" ")) {
                            String string4 = (String)var14_17 + "\"" + toolsFile.getAbsolutePath() + "\"";
                        } else {
                            String string5 = (String)var14_17 + toolsFile.getAbsolutePath();
                        }
                    }
                    commands.add((String)var14_22);
                } else {
                    System.out.println("Not using selected JVM (directory not found), using default JVM");
                }
            }
            commands.add("-Xmx" + heapsize);
            commands.add("-Xss" + stacksize);
            if (this.useProxy.isSelected()) {
                commands.add("-Dhttp.proxyHost=" + this.proxyHost.getText());
                commands.add("-Dhttp.proxyPort=" + this.proxyPort.getText());
            }
            String cp = "." + File.pathSeparator;
            boolean escapeCompletePath = isMac;
            cp = cp + "lib" + File.pathSeparator;
            File dir = new File(destDir + File.separator + "lib");
            for (File lib : dir.listFiles()) {
                if (!lib.isFile()) continue;
                cp = lib.getName().contains(" ") && !escapeCompletePath ? cp + "\"lib" + File.separator + lib.getName() + "\"" + File.pathSeparator : cp + "lib" + File.separator + lib.getName() + File.pathSeparator;
            }
            if (cp.endsWith(File.pathSeparator)) {
                cp = cp.substring(0, cp.length() - 1);
            }
            commands.add("-Dorg.apache.cxf.Logger=org.apache.cxf.common.logging.Slf4jLogger");
            commands.add("-classpath");
            commands.add(cp);
            Enumeration<URL> enumeration = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            String realMainClass = "";
            block4: while (enumeration.hasMoreElements()) {
                URL url = enumeration.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                Attributes mainAttributes = manifest.getMainAttributes();
                for (Object key : mainAttributes.keySet()) {
                    if (!key.toString().equals("Real-Main-Class")) continue;
                    realMainClass = mainAttributes.get(key).toString();
                    continue block4;
                }
            }
            System.out.println("Main class: " + realMainClass);
            commands.add(realMainClass);
            commands.add("address=" + address);
            commands.add("port=" + port);
            commands.add("homedir=" + homedir);
            System.out.println("\nCommands:");
            for (String command : commands) {
                System.out.println(command);
            }
            ProcessBuilder processBuilder = new ProcessBuilder(commands);
            processBuilder.directory(destDir);
            this.exec = processBuilder.start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedInputStream inputStream = new BufferedInputStream(Starter.this.exec.getInputStream());
                    byte[] buffer = new byte[1024];
                    try {
                        int red = inputStream.read(buffer);
                        while (red != -1) {
                            String s = new String(buffer, 0, red);
                            System.out.print(s);
                            red = inputStream.read(buffer);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, "Sysin reader").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedInputStream errorStream = new BufferedInputStream(Starter.this.exec.getErrorStream());
                    byte[] buffer = new byte[1024];
                    try {
                        int red = errorStream.read(buffer);
                        while (red != -1) {
                            String s = new String(buffer, 0, red);
                            System.out.print(s);
                            red = errorStream.read(buffer);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, "Syserr reader").start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkJavaVersion(String jvmPath) {
        ArrayList<String> commands = new ArrayList<String>();
        if (jvmPath.equalsIgnoreCase("default")) {
            commands.add("java");
        } else {
            File jvm = new File(jvmPath);
            if (jvm.exists()) {
                File jre = new File(jvm, "jre");
                if (!jre.exists()) {
                    jre = jvm;
                }
                commands.add(new File(jre, "bin" + File.separator + "java").getAbsolutePath());
                File jreLib = new File(jre, "lib");
                System.out.println("Using " + jreLib.getAbsolutePath() + " for bootclasspath");
                String xbcp = "-Xbootclasspath:";
                for (File file : jreLib.listFiles()) {
                    if (!file.getName().endsWith(".jar")) continue;
                    xbcp = file.getAbsolutePath().contains(" ") ? xbcp + "\"" + file.getAbsolutePath() + "\"" + File.pathSeparator : xbcp + file.getAbsolutePath() + File.pathSeparator;
                }
                if (jre != jvm) {
                    File toolsFile = new File(jvm, "lib" + File.separator + "tools.jar");
                    xbcp = toolsFile.getAbsolutePath().contains(" ") ? xbcp + "\"" + toolsFile.getAbsolutePath() + "\"" : xbcp + toolsFile.getAbsolutePath();
                }
                commands.add(xbcp);
            } else {
                System.out.println("Not using selected JVM (directory not found), using default JVM");
            }
        }
        commands.add("-version");
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        try {
            this.exec = processBuilder.start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedInputStream inputStream = new BufferedInputStream(Starter.this.exec.getInputStream());
                    byte[] buffer = new byte[1024];
                    try {
                        int red = inputStream.read(buffer);
                        while (red != -1) {
                            String s = new String(buffer, 0, red);
                            System.out.print(s);
                            red = inputStream.read(buffer);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, "Sysin reader").start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedInputStream errorStream = new BufferedInputStream(Starter.this.exec.getErrorStream());
                    byte[] buffer = new byte[1024];
                    try {
                        int red = errorStream.read(buffer);
                        while (red != -1) {
                            String s = new String(buffer, 0, red);
                            System.out.print(s);
                            red = errorStream.read(buffer);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }, "Syserr reader").start();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File expand() {
        JarFile jar = null;
        String jarFileName = this.getJarFileNameNew();
        File destDir = new File(jarFileName.substring(0, jarFileName.indexOf(".jar")));
        if (!destDir.isDirectory()) {
            System.out.println("Expanding " + jarFileName);
            try {
                jar = new JarFile(jarFileName);
                Enumeration<JarEntry> enumr = jar.entries();
                while (enumr.hasMoreElements()) {
                    JarEntry file = enumr.nextElement();
                    System.out.println(file.getName());
                    File f = new File(destDir, file.getName());
                    if (file.isDirectory()) {
                        if (!f.getParentFile().exists()) {
                            f.getParentFile().mkdir();
                        }
                        f.mkdir();
                        continue;
                    }
                    InputStream is = jar.getInputStream(file);
                    FileOutputStream fos = new FileOutputStream(f);
                    byte[] buffer = new byte[1024];
                    int red = is.read(buffer);
                    while (red != -1) {
                        fos.write(buffer, 0, red);
                        red = is.read(buffer);
                    }
                    fos.close();
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (jar != null) {
                        jar.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            System.out.println("No expanding necessary");
        }
        return destDir;
    }

    private String getJarFileNameNew() {
        String name = this.getClass().getName().replace(".", "/") + ".class";
        URL urlJar = this.getClass().getClassLoader().getResource(name);
        String urlString = urlJar.getFile();
        urlString = urlString.substring(urlString.indexOf(":") + 1, urlString.indexOf("!"));
        try {
            return URLDecoder.decode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

