/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.web;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.bimserver.BimServer;
import org.bimserver.BimServerConfig;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.database.DatabaseRestartRequiredException;
import org.bimserver.database.berkeley.DatabaseInitException;
import org.bimserver.plugins.ResourceFetcher;
import org.bimserver.resources.WarResourceFetcher;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.utils.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarServerInitializer
implements ServletContextListener {
    private BimServer bimServer;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        String realPath;
        ServletContext servletContext = servletContextEvent.getServletContext();
        Path homeDir = null;
        if (servletContext.getAttribute("homedir") != null) {
            homeDir = Paths.get((String)servletContext.getAttribute("homedir"), new String[0]);
        }
        if (homeDir == null && servletContext.getInitParameter("homedir") != null) {
            homeDir = Paths.get(servletContext.getInitParameter("homedir"), new String[0]);
        }
        boolean autoMigrate = false;
        if (servletContext.getAttribute("autoMigrate") != null) {
            autoMigrate = (Boolean)servletContext.getAttribute("autoMigrate");
        }
        if (!autoMigrate && servletContext.getInitParameter("autoMigrate") != null) {
            autoMigrate = Boolean.valueOf(servletContext.getInitParameter("autoMigrate"));
        }
        if (!(realPath = servletContext.getRealPath("/")).endsWith("/")) {
            realPath = realPath + "/";
        }
        Path baseDir = Paths.get(realPath + "WEB-INF", new String[0]);
        if (homeDir == null) {
            homeDir = baseDir;
        }
        WarResourceFetcher resourceFetcher = new WarResourceFetcher(servletContext, homeDir);
        BimServerConfig config = new BimServerConfig();
        config.setAutoMigrate(autoMigrate);
        config.setHomeDir(homeDir);
        config.setResourceFetcher((ResourceFetcher)resourceFetcher);
        try {
            config.setClassPath(this.makeClassPath(resourceFetcher.getFile("lib")));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        config.setStartEmbeddedWebServer(false);
        this.bimServer = new BimServer(config);
        Logger LOGGER = LoggerFactory.getLogger(WarServerInitializer.class);
        LOGGER.info("Servlet Context Name: " + servletContext.getServletContextName());
        List files = resourceFetcher.getFiles("plugins");
        try {
            for (Path file : files) {
                this.bimServer.getPluginManager().loadAllPluginsFromDirectoryOfJars(file);
            }
            this.bimServer.start();
        }
        catch (ServerException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseInitException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (BimserverDatabaseException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (DatabaseRestartRequiredException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        servletContext.setAttribute("bimserver", (Object)this.bimServer);
    }

    private String makeClassPath(Path file) {
        if (file == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        try {
            for (Path f : PathUtils.list((Path)file)) {
                if (!f.getFileName().toString().toLowerCase().endsWith(".jar")) continue;
                sb.append(f.toString() + File.pathSeparator);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        servletContextEvent.getServletContext().removeAttribute("bimserver");
        if (this.bimServer != null) {
            this.bimServer.stop();
        }
    }
}

