/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import com.google.common.base.Charsets;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.serializers.MessagingSerializer;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.serializers.binarygeometry.Bounds;
import org.bimserver.serializers.binarygeometry.Double3;
import org.eclipse.emf.ecore.EClass;

public class BinaryGeometryMessagingSerializer
implements MessagingSerializer {
    private static final byte FORMAT_VERSION = 6;
    private IfcModelInterface model;
    private Mode mode = Mode.START;
    private Map<Long, Object> concreteGeometrySent;
    private Iterator<IdEObject> iterator;
    private PackageMetaData packageMetaData;
    private long splitCounter = -1L;

    public void init(IfcModelInterface model, ProjectInfo projectInfo, PluginManagerInterface pluginManager, PackageMetaData packageMetaData, boolean normalizeOids) throws SerializerException {
        this.model = model;
        this.packageMetaData = packageMetaData;
    }

    public boolean writeMessage(OutputStream outputStream, ProgressReporter progressReporter) throws IOException {
        switch (this.mode) {
            case START: {
                if (!this.writeStart(outputStream)) {
                    this.mode = Mode.END;
                    return false;
                }
                this.mode = Mode.DATA;
                break;
            }
            case DATA: {
                if (this.writeData(outputStream)) break;
                this.mode = Mode.END;
                return false;
            }
            case END: {
                return false;
            }
        }
        return true;
    }

    private boolean writeStart(OutputStream outputStream) throws IOException {
        LittleEndianDataOutputStream dataOutputStream = new LittleEndianDataOutputStream(outputStream);
        dataOutputStream.writeByte((int)MessageType.INIT.getId());
        dataOutputStream.writeUTF("BGS");
        dataOutputStream.writeByte(6);
        Bounds modelBounds = new Bounds();
        int nrObjects = 0;
        EClass productClass = this.model.getPackageMetaData().getEClass("IfcProduct");
        List products = this.model.getAllWithSubTypes(productClass);
        for (IdEObject ifcProduct : products) {
            GeometryInfo geometryInfo = (GeometryInfo)ifcProduct.eGet(ifcProduct.eClass().getEStructuralFeature("geometry"));
            if (geometryInfo == null || geometryInfo.getTransformation() == null) continue;
            Bounds objectBounds = new Bounds(new Double3(geometryInfo.getMinBounds().getX(), geometryInfo.getMinBounds().getY(), geometryInfo.getMinBounds().getZ()), new Double3(geometryInfo.getMaxBounds().getX(), geometryInfo.getMaxBounds().getY(), geometryInfo.getMaxBounds().getZ()));
            modelBounds.integrate(objectBounds);
            ++nrObjects;
        }
        int skip = 1;
        if (skip != 0 && skip != 4) {
            dataOutputStream.write(new byte[skip]);
        }
        modelBounds.writeTo(dataOutputStream);
        dataOutputStream.writeInt(nrObjects);
        this.concreteGeometrySent = new HashMap<Long, Object>();
        EClass productEClass = this.packageMetaData.getEClass("IfcProduct");
        this.iterator = this.model.getAllWithSubTypes(productEClass).iterator();
        return nrObjects > 0;
    }

    private boolean writeData(OutputStream outputStream) throws IOException {
        IdEObject ifcProduct = this.iterator.next();
        LittleEndianDataOutputStream dataOutputStream = new LittleEndianDataOutputStream(outputStream);
        GeometryInfo geometryInfo = (GeometryInfo)ifcProduct.eGet(ifcProduct.eClass().getEStructuralFeature("geometry"));
        if (geometryInfo != null && geometryInfo.getTransformation() != null) {
            GeometryData geometryData = geometryInfo.getData();
            int totalNrIndices = geometryData.getIndices().length / 4;
            int maxIndexValues = 16389;
            Object reuse = this.concreteGeometrySent.get(geometryData.getOid());
            MessageType messageType = null;
            messageType = reuse == null ? (totalNrIndices > maxIndexValues ? MessageType.GEOMETRY_TRIANGLES_PARTED : MessageType.GEOMETRY_TRIANGLES) : (reuse instanceof List ? MessageType.GEOMETRY_INSTANCE_PARTED : MessageType.GEOMETRY_INSTANCE);
            dataOutputStream.writeByte((int)messageType.getId());
            dataOutputStream.writeUTF(ifcProduct.eClass().getName());
            Long roid = (Long)this.model.getPidRoidMap().get(ifcProduct.getPid());
            dataOutputStream.writeLong(roid.longValue());
            dataOutputStream.writeLong(ifcProduct.getOid());
            int skip = 4 - (3 + ifcProduct.eClass().getName().getBytes(Charsets.UTF_8).length) % 4;
            if (skip != 0 && skip != 4) {
                dataOutputStream.write(new byte[skip]);
            }
            dataOutputStream.write(geometryInfo.getTransformation());
            if (reuse != null && reuse instanceof Long) {
                dataOutputStream.writeLong(geometryData.getOid());
            } else if (reuse != null && reuse instanceof List) {
                List list = (List)reuse;
                dataOutputStream.writeInt(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    long coreId = (Long)iterator.next();
                    dataOutputStream.writeLong(coreId);
                }
            } else if (totalNrIndices > maxIndexValues) {
                int nrParts = (totalNrIndices + maxIndexValues - 1) / maxIndexValues;
                dataOutputStream.writeInt(nrParts);
                Bounds objectBounds = new Bounds(geometryInfo.getMinBounds(), geometryInfo.getMaxBounds());
                objectBounds.writeTo(dataOutputStream);
                ByteBuffer indicesBuffer = ByteBuffer.wrap(geometryData.getIndices());
                indicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
                IntBuffer indicesIntBuffer = indicesBuffer.asIntBuffer();
                ByteBuffer vertexBuffer = ByteBuffer.wrap(geometryData.getVertices());
                vertexBuffer.order(ByteOrder.LITTLE_ENDIAN);
                FloatBuffer verticesFloatBuffer = vertexBuffer.asFloatBuffer();
                ByteBuffer normalsBuffer = ByteBuffer.wrap(geometryData.getNormals());
                normalsBuffer.order(ByteOrder.LITTLE_ENDIAN);
                FloatBuffer normalsFloatBuffer = normalsBuffer.asFloatBuffer();
                for (int part = 0; part < nrParts; ++part) {
                    int oldIndex3;
                    int oldIndex2;
                    int oldIndex1;
                    int i;
                    long splitId;
                    --this.splitCounter;
                    dataOutputStream.writeLong(splitId);
                    int indexCounter = 0;
                    int upto = Math.min((part + 1) * maxIndexValues, totalNrIndices);
                    dataOutputStream.writeInt(upto - part * maxIndexValues);
                    for (i = part * maxIndexValues; i < upto; ++i) {
                        dataOutputStream.writeInt(indexCounter++);
                    }
                    dataOutputStream.writeInt((upto - part * maxIndexValues) * 3);
                    for (i = part * maxIndexValues; i < upto; i += 3) {
                        oldIndex1 = indicesIntBuffer.get(i);
                        oldIndex2 = indicesIntBuffer.get(i + 1);
                        oldIndex3 = indicesIntBuffer.get(i + 2);
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex1 * 3));
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex1 * 3 + 1));
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex1 * 3 + 2));
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex2 * 3));
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex2 * 3 + 1));
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex2 * 3 + 2));
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex3 * 3));
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex3 * 3 + 1));
                        dataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex3 * 3 + 2));
                    }
                    dataOutputStream.writeInt((upto - part * maxIndexValues) * 3);
                    for (i = part * maxIndexValues; i < upto; i += 3) {
                        oldIndex1 = indicesIntBuffer.get(i);
                        oldIndex2 = indicesIntBuffer.get(i + 1);
                        oldIndex3 = indicesIntBuffer.get(i + 2);
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex1 * 3));
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex1 * 3 + 1));
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex1 * 3 + 2));
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex2 * 3));
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex2 * 3 + 1));
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex2 * 3 + 2));
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex3 * 3));
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex3 * 3 + 1));
                        dataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex3 * 3 + 2));
                    }
                    dataOutputStream.writeInt(0);
                }
            } else {
                Bounds objectBounds = new Bounds(geometryInfo.getMinBounds(), geometryInfo.getMaxBounds());
                objectBounds.writeTo(dataOutputStream);
                dataOutputStream.writeLong(geometryData.getOid());
                ByteBuffer indicesBuffer = ByteBuffer.wrap(geometryData.getIndices());
                dataOutputStream.writeInt(indicesBuffer.capacity() / 4);
                dataOutputStream.write(indicesBuffer.array());
                ByteBuffer vertexByteBuffer = ByteBuffer.wrap(geometryData.getVertices());
                dataOutputStream.writeInt(vertexByteBuffer.capacity() / 4);
                dataOutputStream.write(vertexByteBuffer.array());
                ByteBuffer normalsBuffer = ByteBuffer.wrap(geometryData.getNormals());
                dataOutputStream.writeInt(normalsBuffer.capacity() / 4);
                dataOutputStream.write(normalsBuffer.array());
                if (geometryData.getMaterials() != null) {
                    ByteBuffer materialsByteBuffer = ByteBuffer.wrap(geometryData.getMaterials());
                    dataOutputStream.writeInt(materialsByteBuffer.capacity() / 4);
                    dataOutputStream.write(materialsByteBuffer.array());
                } else {
                    dataOutputStream.writeInt(0);
                }
                ArrayList<Long> arrayList = new ArrayList<Long>();
                arrayList.add(geometryData.getOid());
                this.concreteGeometrySent.put(geometryData.getOid(), arrayList);
            }
        }
        return this.iterator.hasNext();
    }

    private static enum MessageType {
        INIT(0),
        GEOMETRY_TRIANGLES(1),
        GEOMETRY_INSTANCE(2),
        GEOMETRY_TRIANGLES_PARTED(3),
        GEOMETRY_INSTANCE_PARTED(4);

        private byte id;

        private MessageType(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }
    }

    private static enum Mode {
        START,
        DATA,
        END;

    }
}

