/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import com.google.common.base.Charsets;
import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.List;
import org.bimserver.emf.IdEObject;
import org.bimserver.models.geometry.GeometryData;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.plugins.serializers.AbstractGeometrySerializer;
import org.bimserver.plugins.serializers.EmfSerializer;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.serializers.binarygeometry.Bounds;
import org.bimserver.serializers.binarygeometry.Double3;
import org.eclipse.emf.ecore.EClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BinaryGeometrySerializer
extends AbstractGeometrySerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryGeometrySerializer.class);
    private static final byte FORMAT_VERSION = 6;
    private static final byte GEOMETRY_TYPE_TRIANGLES = 0;
    private static final byte GEOMETRY_TYPE_INSTANCE = 1;

    protected boolean write(OutputStream outputStream, ProgressReporter progressReporter) throws SerializerException {
        if (this.getMode() == EmfSerializer.Mode.BODY) {
            try {
                this.calculateGeometryExtents();
                this.writeGeometries(outputStream);
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
            this.setMode(EmfSerializer.Mode.FINISHED);
            return true;
        }
        if (this.getMode() == EmfSerializer.Mode.FINISHED) {
            return false;
        }
        return false;
    }

    private void writeGeometries(OutputStream outputStream) throws IOException {
        long start = System.nanoTime();
        LittleEndianDataOutputStream dataOutputStream = new LittleEndianDataOutputStream(outputStream);
        dataOutputStream.writeUTF("BGS");
        dataOutputStream.writeByte(6);
        Bounds modelBounds = new Bounds();
        int nrObjects = 0;
        EClass productClass = this.getModel().getPackageMetaData().getEClass("IfcProduct");
        List products = this.getModel().getAllWithSubTypes(productClass);
        for (IdEObject ifcProduct : products) {
            GeometryInfo geometryInfo = (GeometryInfo)ifcProduct.eGet(ifcProduct.eClass().getEStructuralFeature("geometry"));
            if (geometryInfo == null || geometryInfo.getTransformation() == null) continue;
            Bounds objectBounds = new Bounds(new Double3(geometryInfo.getMinBounds().getX(), geometryInfo.getMinBounds().getY(), geometryInfo.getMinBounds().getZ()), new Double3(geometryInfo.getMaxBounds().getX(), geometryInfo.getMaxBounds().getY(), geometryInfo.getMaxBounds().getZ()));
            modelBounds.integrate(objectBounds);
            ++nrObjects;
        }
        modelBounds.writeTo(dataOutputStream);
        dataOutputStream.writeInt(nrObjects);
        int bytesSaved = 0;
        int bytesTotal = 0;
        HashSet<Long> concreteGeometrySent = new HashSet<Long>();
        dataOutputStream.flush();
        int bytes = 6;
        int counter = 0;
        for (IdEObject ifcProduct : products) {
            GeometryInfo geometryInfo = (GeometryInfo)ifcProduct.eGet(ifcProduct.eClass().getEStructuralFeature("geometry"));
            if (geometryInfo == null || geometryInfo.getTransformation() == null) continue;
            String type = ifcProduct.eClass().getName();
            dataOutputStream.writeUTF(type);
            dataOutputStream.writeLong(ifcProduct.getOid());
            GeometryData geometryData = geometryInfo.getData();
            byte[] vertices = geometryData.getVertices();
            bytesTotal += vertices.length;
            int geometryType = concreteGeometrySent.contains(geometryData.getOid()) ? 1 : 0;
            dataOutputStream.write(geometryType);
            int skip = 4 - (bytes += type.getBytes(Charsets.UTF_8).length + 3) % 4;
            if (skip != 0 && skip != 4) {
                dataOutputStream.write(new byte[skip]);
            }
            bytes = 0;
            dataOutputStream.write(geometryInfo.getTransformation());
            if (concreteGeometrySent.contains(geometryData.getOid())) {
                dataOutputStream.writeLong(geometryData.getOid());
                bytesSaved += vertices.length;
            } else {
                ByteBuffer vertexByteBuffer = ByteBuffer.wrap(vertices);
                dataOutputStream.writeLong(geometryData.getOid());
                Bounds objectBounds = new Bounds(geometryInfo.getMinBounds(), geometryInfo.getMaxBounds());
                objectBounds.writeTo(dataOutputStream);
                ByteBuffer indicesBuffer = ByteBuffer.wrap(geometryData.getIndices());
                dataOutputStream.writeInt(indicesBuffer.capacity() / 4);
                dataOutputStream.write(indicesBuffer.array());
                dataOutputStream.writeInt(vertexByteBuffer.capacity() / 4);
                dataOutputStream.write(vertexByteBuffer.array());
                ByteBuffer normalsBuffer = ByteBuffer.wrap(geometryData.getNormals());
                dataOutputStream.writeInt(normalsBuffer.capacity() / 4);
                dataOutputStream.write(normalsBuffer.array());
                if (geometryData.getMaterials() != null) {
                    ByteBuffer materialsByteBuffer = ByteBuffer.wrap(geometryData.getMaterials());
                    dataOutputStream.writeInt(materialsByteBuffer.capacity() / 4);
                    dataOutputStream.write(materialsByteBuffer.array());
                } else {
                    dataOutputStream.writeInt(0);
                }
                concreteGeometrySent.add(geometryData.getOid());
            }
            if (++counter % 12 != 0) continue;
            dataOutputStream.flush();
        }
        dataOutputStream.flush();
        if (bytesTotal != 0 && bytesSaved != 0) {
            LOGGER.info(100 * bytesSaved / bytesTotal + "% saved");
        }
        long end = System.nanoTime();
        LOGGER.debug((end - start) / 1000000L + " ms");
    }
}

