/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import org.bimserver.models.geometry.Vector3f;
import org.bimserver.serializers.binarygeometry.Double3;

public class Bounds {
    public Double3 min;
    public Double3 max;

    public Bounds(Double3 min, Double3 max) {
        this.min = min;
        this.max = max;
    }

    public Bounds() {
        this.min = new Double3(3.4028234663852886E38, 3.4028234663852886E38, 3.4028234663852886E38);
        this.max = new Double3(-3.4028234663852886E38, -3.4028234663852886E38, -3.4028234663852886E38);
    }

    public Bounds(Vector3f minBounds, Vector3f maxBounds) {
        this.min = new Double3(minBounds.getX(), minBounds.getY(), minBounds.getZ());
        this.max = new Double3(maxBounds.getX(), maxBounds.getY(), maxBounds.getZ());
    }

    public void integrate(Bounds objectBounds) {
        this.min.min(objectBounds.min);
        this.max.max(objectBounds.max);
    }

    public void writeTo(LittleEndianDataOutputStream dataOutputStream) throws IOException {
        this.min.writeTo(dataOutputStream);
        this.max.writeTo(dataOutputStream);
    }
}

