/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import com.google.common.io.LittleEndianDataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.interfaces.objects.SVector3f;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.serializers.MessagingStreamingSerializer;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryGeometryMessagingStreamingSerializer
implements MessagingStreamingSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryGeometryMessagingStreamingSerializer.class);
    private static final byte FORMAT_VERSION = 8;
    private Mode mode = Mode.START;
    private ObjectProvider objectProvider;
    private HashMapVirtualObject next;
    private ProjectInfo projectInfo;
    private LittleEndianDataOutputStream dataOutputStream;

    public void init(ObjectProvider objectProvider, ProjectInfo projectInfo, PluginManagerInterface pluginManager, PackageMetaData packageMetaData) throws SerializerException {
        this.objectProvider = objectProvider;
        this.projectInfo = projectInfo;
    }

    public boolean writeMessage(OutputStream outputStream, ProgressReporter progressReporter) throws IOException, SerializerException {
        this.dataOutputStream = new LittleEndianDataOutputStream(outputStream);
        switch (this.mode) {
            case START: {
                if (!this.writeStart()) {
                    this.mode = Mode.END;
                    return true;
                }
                this.mode = Mode.DATA;
                break;
            }
            case DATA: {
                if (this.writeData()) break;
                this.mode = Mode.END;
                return true;
            }
            case END: {
                this.writeEnd();
                return false;
            }
        }
        return true;
    }

    private boolean writeEnd() throws IOException {
        this.dataOutputStream.write((int)MessageType.END.getId());
        return true;
    }

    private boolean writeStart() throws IOException {
        this.dataOutputStream.writeByte((int)MessageType.INIT.getId());
        this.dataOutputStream.writeUTF("BGS");
        this.dataOutputStream.writeByte(8);
        int skip = 1;
        if (skip != 0 && skip != 4) {
            this.dataOutputStream.write(new byte[skip]);
        }
        SVector3f minBounds = this.projectInfo.getMinBounds();
        this.dataOutputStream.writeDouble(minBounds.getX());
        this.dataOutputStream.writeDouble(minBounds.getY());
        this.dataOutputStream.writeDouble(minBounds.getZ());
        SVector3f maxBounds = this.projectInfo.getMaxBounds();
        this.dataOutputStream.writeDouble(maxBounds.getX());
        this.dataOutputStream.writeDouble(maxBounds.getY());
        this.dataOutputStream.writeDouble(maxBounds.getZ());
        try {
            this.next = this.objectProvider.next();
        }
        catch (BimserverDatabaseException e) {
            e.printStackTrace();
        }
        return this.next != null;
    }

    private boolean writeData() throws IOException, SerializerException {
        if (this.next.eClass() == GeometryPackage.eINSTANCE.getGeometryInfo()) {
            Object transformation = this.next.eGet(this.next.eClass().getEStructuralFeature("transformation"));
            Object data = this.next.eGet(this.next.eClass().getEStructuralFeature("data"));
            this.dataOutputStream.writeByte((int)MessageType.GEOMETRY_INFO.getId());
            this.dataOutputStream.write(new byte[7]);
            this.dataOutputStream.writeLong(this.next.getRoid());
            this.dataOutputStream.writeLong(this.next.getOid());
            HashMapWrappedVirtualObject minBounds = (HashMapWrappedVirtualObject)this.next.eGet(this.next.eClass().getEStructuralFeature("minBounds"));
            HashMapWrappedVirtualObject maxBounds = (HashMapWrappedVirtualObject)this.next.eGet(this.next.eClass().getEStructuralFeature("maxBounds"));
            Double minX = (Double)minBounds.eGet("x");
            Double minY = (Double)minBounds.eGet("y");
            Double minZ = (Double)minBounds.eGet("z");
            Double maxX = (Double)maxBounds.eGet("x");
            Double maxY = (Double)maxBounds.eGet("y");
            Double maxZ = (Double)maxBounds.eGet("z");
            this.dataOutputStream.writeDouble(minX.doubleValue());
            this.dataOutputStream.writeDouble(minY.doubleValue());
            this.dataOutputStream.writeDouble(minZ.doubleValue());
            this.dataOutputStream.writeDouble(maxX.doubleValue());
            this.dataOutputStream.writeDouble(maxY.doubleValue());
            this.dataOutputStream.writeDouble(maxZ.doubleValue());
            this.dataOutputStream.write((byte[])transformation);
            this.dataOutputStream.writeLong(((Long)data).longValue());
        } else if (this.next.eClass() == GeometryPackage.eINSTANCE.getGeometryData()) {
            EStructuralFeature indicesFeature = this.next.eClass().getEStructuralFeature("indices");
            EStructuralFeature verticesFeature = this.next.eClass().getEStructuralFeature("vertices");
            EStructuralFeature normalsFeature = this.next.eClass().getEStructuralFeature("normals");
            EStructuralFeature materialsFeature = this.next.eClass().getEStructuralFeature("materials");
            byte[] indices = (byte[])this.next.eGet(indicesFeature);
            byte[] vertices = (byte[])this.next.eGet(verticesFeature);
            byte[] normals = (byte[])this.next.eGet(normalsFeature);
            byte[] materials = (byte[])this.next.eGet(materialsFeature);
            this.dataOutputStream.write((int)MessageType.GEOMETRY_TRIANGLES.getId());
            this.dataOutputStream.write(new byte[7]);
            this.dataOutputStream.writeLong(this.next.getOid());
            ByteBuffer indicesBuffer = ByteBuffer.wrap(indices);
            indicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.dataOutputStream.writeInt(indicesBuffer.capacity() / 4);
            this.dataOutputStream.write(indicesBuffer.array());
            ByteBuffer vertexByteBuffer = ByteBuffer.wrap(vertices);
            this.dataOutputStream.writeInt(vertexByteBuffer.capacity() / 4);
            this.dataOutputStream.write(vertexByteBuffer.array());
            ByteBuffer normalsBuffer = ByteBuffer.wrap(normals);
            this.dataOutputStream.writeInt(normalsBuffer.capacity() / 4);
            this.dataOutputStream.write(normalsBuffer.array());
            if (materials != null) {
                ByteBuffer materialsByteBuffer = ByteBuffer.wrap(materials);
                this.dataOutputStream.writeInt(materialsByteBuffer.capacity() / 4);
                this.dataOutputStream.write(materialsByteBuffer.array());
            } else {
                this.dataOutputStream.writeInt(0);
            }
        } else {
            LOGGER.info("Ignoring");
        }
        try {
            this.next = this.objectProvider.next();
        }
        catch (BimserverDatabaseException e) {
            throw new SerializerException((Throwable)e);
        }
        return this.next != null;
    }

    private static enum MessageType {
        INIT(0),
        GEOMETRY_TRIANGLES(1),
        GEOMETRY_INFO(5),
        END(6);

        private byte id;

        private MessageType(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }
    }

    private static enum Mode {
        START,
        DATA,
        END;

    }
}

