/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.interfaces.objects.SVector3f;
import org.bimserver.models.geometry.GeometryPackage;
import org.bimserver.plugins.LittleEndianSerializerDataOutputStream;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.SerializerDataOutputStream;
import org.bimserver.plugins.serializers.MessagingStreamingSerializer;
import org.bimserver.plugins.serializers.ObjectProvider;
import org.bimserver.plugins.serializers.ProgressReporter;
import org.bimserver.plugins.serializers.ProjectInfo;
import org.bimserver.plugins.serializers.SerializerException;
import org.bimserver.shared.HashMapVirtualObject;
import org.bimserver.shared.HashMapWrappedVirtualObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryGeometryMessagingStreamingSerializer2
implements MessagingStreamingSerializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BinaryGeometryMessagingStreamingSerializer2.class);
    private static final byte FORMAT_VERSION = 10;
    private Mode mode = Mode.LOAD;
    private long splitCounter = 0L;
    private ObjectProvider objectProvider;
    private ProjectInfo projectInfo;
    private final List<HashMapVirtualObject> infoList = new ArrayList<HashMapVirtualObject>();
    private final Map<Long, HashMapVirtualObject> dataList = new HashMap<Long, HashMapVirtualObject>();
    private Iterator<HashMapVirtualObject> iterator;
    HashMapVirtualObject last = null;
    private SerializerDataOutputStream serializerDataOutputStream;

    public void init(ObjectProvider objectProvider, ProjectInfo projectInfo, PluginManagerInterface pluginManager, PackageMetaData packageMetaData) throws SerializerException {
        this.objectProvider = objectProvider;
        this.projectInfo = projectInfo;
    }

    public boolean writeMessage(OutputStream outputStream, ProgressReporter progressReporter) throws IOException, SerializerException {
        this.serializerDataOutputStream = null;
        this.serializerDataOutputStream = outputStream instanceof SerializerDataOutputStream ? (SerializerDataOutputStream)outputStream : new LittleEndianSerializerDataOutputStream(outputStream);
        switch (this.mode) {
            case LOAD: {
                this.load();
                this.mode = Mode.START;
            }
            case START: {
                this.writeStart();
                this.mode = Mode.DATA;
                break;
            }
            case DATA: {
                if (this.writeData()) break;
                this.mode = Mode.END;
                return true;
            }
            case END: {
                this.writeEnd();
                return false;
            }
        }
        return true;
    }

    private void load() throws SerializerException {
        HashMapVirtualObject next = null;
        try {
            next = this.objectProvider.next();
        }
        catch (BimserverDatabaseException e) {
            throw new SerializerException((Throwable)e);
        }
        while (next != null) {
            if (next.eClass() == GeometryPackage.eINSTANCE.getGeometryInfo()) {
                this.infoList.add(next);
            } else if (next.eClass() == GeometryPackage.eINSTANCE.getGeometryData()) {
                this.dataList.put(next.getOid(), next);
            }
            try {
                next = this.objectProvider.next();
            }
            catch (BimserverDatabaseException e) {
                throw new SerializerException((Throwable)e);
            }
        }
        Collections.sort(this.infoList, new Comparator<HashMapVirtualObject>(){

            @Override
            public int compare(HashMapVirtualObject o1, HashMapVirtualObject o2) {
                return BinaryGeometryMessagingStreamingSerializer2.this.getBoundingBoxVolume(o2) - BinaryGeometryMessagingStreamingSerializer2.this.getBoundingBoxVolume(o1);
            }
        });
        this.iterator = this.infoList.iterator();
    }

    private int getBoundingBoxVolume(HashMapVirtualObject o1) {
        HashMapWrappedVirtualObject minBounds = (HashMapWrappedVirtualObject)o1.eGet(o1.eClass().getEStructuralFeature("minBounds"));
        HashMapWrappedVirtualObject maxBounds = (HashMapWrappedVirtualObject)o1.eGet(o1.eClass().getEStructuralFeature("maxBounds"));
        Double minX = (Double)minBounds.eGet("x");
        Double minY = (Double)minBounds.eGet("y");
        Double minZ = (Double)minBounds.eGet("z");
        Double maxX = (Double)maxBounds.eGet("x");
        Double maxY = (Double)maxBounds.eGet("y");
        Double maxZ = (Double)maxBounds.eGet("z");
        int volume = (int)((maxX - minX) * (maxY - minY) * (maxZ - minZ));
        return volume;
    }

    private boolean writeEnd() throws IOException {
        this.serializerDataOutputStream.write((int)MessageType.END.getId());
        return true;
    }

    private void writeStart() throws IOException {
        this.serializerDataOutputStream.writeByte(MessageType.INIT.getId());
        this.serializerDataOutputStream.writeUTF("BGS");
        this.serializerDataOutputStream.writeByte((byte)10);
        int skip = 1;
        if (skip != 0 && skip != 4) {
            this.serializerDataOutputStream.write(new byte[skip]);
        }
        SVector3f minBounds = this.projectInfo.getMinBounds();
        LOGGER.info(minBounds.getX() + ", " + minBounds.getY() + ", " + minBounds.getZ());
        this.serializerDataOutputStream.writeDouble(minBounds.getX());
        this.serializerDataOutputStream.writeDouble(minBounds.getY());
        this.serializerDataOutputStream.writeDouble(minBounds.getZ());
        SVector3f maxBounds = this.projectInfo.getMaxBounds();
        LOGGER.info(maxBounds.getX() + ", " + maxBounds.getY() + ", " + maxBounds.getZ());
        this.serializerDataOutputStream.writeDouble(maxBounds.getX());
        this.serializerDataOutputStream.writeDouble(maxBounds.getY());
        this.serializerDataOutputStream.writeDouble(maxBounds.getZ());
    }

    private boolean writeData() throws IOException, SerializerException {
        HashMapVirtualObject info = null;
        if (this.last != null) {
            info = this.last;
            this.last = null;
        } else if (this.iterator.hasNext()) {
            info = this.iterator.next();
        } else {
            return false;
        }
        Object transformation = info.eGet(info.eClass().getEStructuralFeature("transformation"));
        Object dataOid = info.eGet(info.eClass().getEStructuralFeature("data"));
        HashMapVirtualObject data = this.dataList.get(dataOid);
        if (data != null) {
            this.last = info;
            EStructuralFeature indicesFeature = data.eClass().getEStructuralFeature("indices");
            EStructuralFeature verticesFeature = data.eClass().getEStructuralFeature("vertices");
            EStructuralFeature normalsFeature = data.eClass().getEStructuralFeature("normals");
            EStructuralFeature materialsFeature = data.eClass().getEStructuralFeature("materials");
            byte[] indices = (byte[])data.eGet(indicesFeature);
            byte[] vertices = (byte[])data.eGet(verticesFeature);
            byte[] normals = (byte[])data.eGet(normalsFeature);
            byte[] materials = (byte[])data.eGet(materialsFeature);
            int totalNrIndices = indices.length / 4;
            int maxIndexValues = 16389;
            if (totalNrIndices > maxIndexValues) {
                this.serializerDataOutputStream.write((int)MessageType.GEOMETRY_TRIANGLES_PARTED.getId());
                this.serializerDataOutputStream.write(new byte[7]);
                this.serializerDataOutputStream.writeLong(data.getOid());
                int nrParts = (totalNrIndices + maxIndexValues - 1) / maxIndexValues;
                this.serializerDataOutputStream.writeInt(nrParts);
                ByteBuffer indicesBuffer = ByteBuffer.wrap(indices);
                indicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
                IntBuffer indicesIntBuffer = indicesBuffer.asIntBuffer();
                ByteBuffer vertexBuffer = ByteBuffer.wrap(vertices);
                vertexBuffer.order(ByteOrder.LITTLE_ENDIAN);
                FloatBuffer verticesFloatBuffer = vertexBuffer.asFloatBuffer();
                ByteBuffer normalsBuffer = ByteBuffer.wrap(normals);
                normalsBuffer.order(ByteOrder.LITTLE_ENDIAN);
                FloatBuffer normalsFloatBuffer = normalsBuffer.asFloatBuffer();
                for (int part = 0; part < nrParts; ++part) {
                    int oldIndex3;
                    int oldIndex2;
                    int oldIndex1;
                    int i;
                    long splitId;
                    ++this.splitCounter;
                    this.serializerDataOutputStream.writeLong(splitId);
                    short indexCounter = 0;
                    int upto = Math.min((part + 1) * maxIndexValues, totalNrIndices);
                    this.serializerDataOutputStream.writeInt(upto - part * maxIndexValues);
                    for (int i2 = part * maxIndexValues; i2 < upto; ++i2) {
                        short s = indexCounter;
                        indexCounter = (short)(indexCounter + 1);
                        this.serializerDataOutputStream.writeShort(s);
                    }
                    if ((upto - part * maxIndexValues) % 2 != 0) {
                        this.serializerDataOutputStream.writeShort((short)0);
                    }
                    int nrVertices = (upto - part * maxIndexValues) * 3;
                    this.serializerDataOutputStream.writeInt(nrVertices);
                    for (i = part * maxIndexValues; i < upto; i += 3) {
                        oldIndex1 = indicesIntBuffer.get(i);
                        oldIndex2 = indicesIntBuffer.get(i + 1);
                        oldIndex3 = indicesIntBuffer.get(i + 2);
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex1 * 3));
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex1 * 3 + 1));
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex1 * 3 + 2));
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex2 * 3));
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex2 * 3 + 1));
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex2 * 3 + 2));
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex3 * 3));
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex3 * 3 + 1));
                        this.serializerDataOutputStream.writeFloat(verticesFloatBuffer.get(oldIndex3 * 3 + 2));
                    }
                    this.serializerDataOutputStream.writeInt(nrVertices);
                    for (i = part * maxIndexValues; i < upto; i += 3) {
                        oldIndex1 = indicesIntBuffer.get(i);
                        oldIndex2 = indicesIntBuffer.get(i + 1);
                        oldIndex3 = indicesIntBuffer.get(i + 2);
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex1 * 3));
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex1 * 3 + 1));
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex1 * 3 + 2));
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex2 * 3));
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex2 * 3 + 1));
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex2 * 3 + 2));
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex3 * 3));
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex3 * 3 + 1));
                        this.serializerDataOutputStream.writeFloat(normalsFloatBuffer.get(oldIndex3 * 3 + 2));
                    }
                    if (materials != null) {
                        ByteBuffer materialsByteBuffer = ByteBuffer.wrap(materials);
                        materialsByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                        FloatBuffer materialsFloatBuffer = materialsByteBuffer.asFloatBuffer();
                        this.serializerDataOutputStream.writeInt(nrVertices * 4 / 3);
                        for (int i3 = part * maxIndexValues; i3 < upto; i3 += 3) {
                            int oldIndex12 = indicesIntBuffer.get(i3);
                            int oldIndex22 = indicesIntBuffer.get(i3 + 1);
                            int oldIndex32 = indicesIntBuffer.get(i3 + 2);
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex12 * 4));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex12 * 4 + 1));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex12 * 4 + 2));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex12 * 4 + 3));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex22 * 4));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex22 * 4 + 1));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex22 * 4 + 2));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex22 * 4 + 3));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex32 * 4));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex32 * 4 + 1));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex32 * 4 + 2));
                            this.serializerDataOutputStream.writeFloat(materialsFloatBuffer.get(oldIndex32 * 4 + 3));
                        }
                        continue;
                    }
                    this.serializerDataOutputStream.writeInt(0);
                }
            } else {
                this.serializerDataOutputStream.write((int)MessageType.GEOMETRY_TRIANGLES.getId());
                this.serializerDataOutputStream.write(new byte[7]);
                this.serializerDataOutputStream.writeLong(data.getOid());
                ByteBuffer indicesBuffer = ByteBuffer.wrap(indices);
                indicesBuffer.order(ByteOrder.LITTLE_ENDIAN);
                this.serializerDataOutputStream.writeInt(indicesBuffer.capacity() / 4);
                IntBuffer intBuffer = indicesBuffer.asIntBuffer();
                for (int i = 0; i < intBuffer.capacity(); ++i) {
                    this.serializerDataOutputStream.writeShort((short)intBuffer.get());
                }
                if (intBuffer.capacity() % 2 != 0) {
                    this.serializerDataOutputStream.writeShort((short)0);
                }
                ByteBuffer vertexByteBuffer = ByteBuffer.wrap(vertices);
                this.serializerDataOutputStream.writeInt(vertexByteBuffer.capacity() / 4);
                this.serializerDataOutputStream.write(vertexByteBuffer.array());
                ByteBuffer normalsBuffer = ByteBuffer.wrap(normals);
                this.serializerDataOutputStream.writeInt(normalsBuffer.capacity() / 4);
                this.serializerDataOutputStream.write(normalsBuffer.array());
                if (materials != null) {
                    ByteBuffer materialsByteBuffer = ByteBuffer.wrap(materials);
                    this.serializerDataOutputStream.writeInt(materialsByteBuffer.capacity() / 4);
                    this.serializerDataOutputStream.write(materialsByteBuffer.array());
                } else {
                    this.serializerDataOutputStream.writeInt(0);
                }
            }
            this.dataList.remove(dataOid);
            return true;
        }
        this.serializerDataOutputStream.writeByte(MessageType.GEOMETRY_INFO.getId());
        this.serializerDataOutputStream.write(new byte[7]);
        this.serializerDataOutputStream.writeLong(info.getRoid());
        this.serializerDataOutputStream.writeLong(info.getOid());
        HashMapWrappedVirtualObject minBounds = (HashMapWrappedVirtualObject)info.eGet(info.eClass().getEStructuralFeature("minBounds"));
        HashMapWrappedVirtualObject maxBounds = (HashMapWrappedVirtualObject)info.eGet(info.eClass().getEStructuralFeature("maxBounds"));
        Double minX = (Double)minBounds.eGet("x");
        Double minY = (Double)minBounds.eGet("y");
        Double minZ = (Double)minBounds.eGet("z");
        Double maxX = (Double)maxBounds.eGet("x");
        Double maxY = (Double)maxBounds.eGet("y");
        Double maxZ = (Double)maxBounds.eGet("z");
        this.serializerDataOutputStream.writeDouble(minX.doubleValue());
        this.serializerDataOutputStream.writeDouble(minY.doubleValue());
        this.serializerDataOutputStream.writeDouble(minZ.doubleValue());
        this.serializerDataOutputStream.writeDouble(maxX.doubleValue());
        this.serializerDataOutputStream.writeDouble(maxY.doubleValue());
        this.serializerDataOutputStream.writeDouble(maxZ.doubleValue());
        this.serializerDataOutputStream.write((byte[])transformation);
        this.serializerDataOutputStream.writeLong(((Long)dataOid).longValue());
        return this.iterator.hasNext();
    }

    private static enum MessageType {
        INIT(0),
        GEOMETRY_TRIANGLES_PARTED(3),
        GEOMETRY_TRIANGLES(1),
        GEOMETRY_INFO(5),
        END(6);

        private byte id;

        private MessageType(byte id) {
            this.id = id;
        }

        public byte getId() {
            return this.id;
        }
    }

    private static enum Mode {
        LOAD,
        START,
        DATA,
        END;

    }
}

