/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers.binarygeometry.clipping;

import org.bimserver.serializers.binarygeometry.clipping.Point;

public class Vector {
    protected double x;
    protected double y;
    protected double z;

    public Vector(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public void setX(double val) {
        this.x = val;
    }

    public void setY(double val) {
        this.y = val;
    }

    public void setZ(double val) {
        this.z = val;
    }

    public Vector add(Vector v) {
        return new Vector(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector sub(Vector v) {
        return new Vector(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector mul(Vector v) {
        return new Vector(this.x * v.x, this.y * v.y, this.z * v.z);
    }

    public Vector div(Vector v) {
        return new Vector(this.x / v.x, this.y / v.y, this.z / v.z);
    }

    public Vector add(double s) {
        return new Vector(this.x + s, this.y + s, this.z + s);
    }

    public Vector sub(double s) {
        return new Vector(this.x - s, this.y - s, this.z - s);
    }

    public Vector mul(double s) {
        return new Vector(this.x * s, this.y * s, this.z * s);
    }

    public Vector div(double s) {
        double inv = 1.0 / s;
        return new Vector(this.x * inv, this.y * inv, this.z * inv);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double length2() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector cross(Vector v) {
        return new Vector(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public double dot(Vector v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public Point toPoint() {
        return new Point(this.x, this.y, this.z);
    }

    public Vector getInverse() {
        return new Vector(1.0 / this.x, 1.0 / this.y, 1.0 / this.z);
    }

    public double normalize() {
        double len = this.length();
        double inv = 1.0 / len;
        this.x *= inv;
        this.y *= inv;
        this.z *= inv;
        return len;
    }

    public double angleBetween(Vector v) {
        Vector v1 = new Vector(this.x, this.y, this.z);
        Vector v2 = new Vector(v.x, v.y, v.z);
        v1.normalize();
        v2.normalize();
        return Math.acos(v1.dot(v2));
    }
}

