/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcebim.ifcanalytics;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.bimserver.bimbots.BimBotContext;
import org.bimserver.bimbots.BimBotsException;
import org.bimserver.bimbots.BimBotsInput;
import org.bimserver.bimbots.BimBotsOutput;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.models.geometry.Bounds;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc2x3tc1.IfcBuilding;
import org.bimserver.models.ifc2x3tc1.IfcBuildingStorey;
import org.bimserver.models.ifc2x3tc1.IfcCalendarDate;
import org.bimserver.models.ifc2x3tc1.IfcClassification;
import org.bimserver.models.ifc2x3tc1.IfcClassificationNotationSelect;
import org.bimserver.models.ifc2x3tc1.IfcClassificationReference;
import org.bimserver.models.ifc2x3tc1.IfcGroup;
import org.bimserver.models.ifc2x3tc1.IfcMaterial;
import org.bimserver.models.ifc2x3tc1.IfcMaterialLayer;
import org.bimserver.models.ifc2x3tc1.IfcMaterialLayerSet;
import org.bimserver.models.ifc2x3tc1.IfcMaterialLayerSetUsage;
import org.bimserver.models.ifc2x3tc1.IfcMaterialSelect;
import org.bimserver.models.ifc2x3tc1.IfcObjectDefinition;
import org.bimserver.models.ifc2x3tc1.IfcPostalAddress;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcRelAssigns;
import org.bimserver.models.ifc2x3tc1.IfcRelAssignsToGroup;
import org.bimserver.models.ifc2x3tc1.IfcRelAssociatesClassification;
import org.bimserver.models.ifc2x3tc1.IfcRelAssociatesMaterial;
import org.bimserver.models.ifc2x3tc1.IfcRelDecomposes;
import org.bimserver.models.ifc2x3tc1.IfcRoot;
import org.bimserver.models.ifc2x3tc1.IfcSpace;
import org.bimserver.models.ifc2x3tc1.IfcZone;
import org.bimserver.models.store.BooleanType;
import org.bimserver.models.store.IfcHeader;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.services.BimBotAbstractService;
import org.bimserver.plugins.services.BimBotClient;
import org.bimserver.plugins.services.BimBotExecutionException;
import org.bimserver.utils.AreaUnit;
import org.bimserver.utils.IfcUtils;
import org.bimserver.utils.LengthUnit;
import org.bimserver.utils.VolumeUnit;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.opensourcebim.ifcanalytics.ObjectDetails;

public class IfcAnalyticsService
extends BimBotAbstractService {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final AreaUnit DEFAULT_AREA_UNIT = AreaUnit.SQUARED_METER;
    private static final VolumeUnit DEFAULT_VOLUME_UNIT = VolumeUnit.CUBIC_METER;
    private AreaUnit modelAreaUnit;
    private VolumeUnit modelVolumeUnit;
    private LengthUnit modelLengthUnit;
    private int cubesNearZero;

    public boolean preloadCompleteModel() {
        return true;
    }

    public ObjectDefinition getSettingsDefinition() {
        ObjectDefinition settingsDefinition = StoreFactory.eINSTANCE.createObjectDefinition();
        PrimitiveDefinition booleanType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        booleanType.setType(PrimitiveEnum.BOOLEAN);
        PrimitiveDefinition stringType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringType.setType(PrimitiveEnum.STRING);
        BooleanType falseValue = StoreFactory.eINSTANCE.createBooleanType();
        falseValue.setValue(false);
        ParameterDefinition clashDetectionEnabled = StoreFactory.eINSTANCE.createParameterDefinition();
        clashDetectionEnabled.setName("Clash detection enabled");
        clashDetectionEnabled.setIdentifier("clashdetectionenabled");
        clashDetectionEnabled.setType((TypeDefinition)booleanType);
        clashDetectionEnabled.setDefaultValue((Type)falseValue);
        settingsDefinition.getParameters().add((Object)clashDetectionEnabled);
        ParameterDefinition clashDetectionToken = StoreFactory.eINSTANCE.createParameterDefinition();
        clashDetectionToken.setName("Clash detection token");
        clashDetectionToken.setIdentifier("clashdetectiontoken");
        clashDetectionToken.setType((TypeDefinition)stringType);
        settingsDefinition.getParameters().add((Object)clashDetectionToken);
        ParameterDefinition clashDetectionUrl = StoreFactory.eINSTANCE.createParameterDefinition();
        clashDetectionUrl.setName("Clash detection url");
        clashDetectionUrl.setIdentifier("clashdetectionurl");
        clashDetectionUrl.setType((TypeDefinition)stringType);
        settingsDefinition.getParameters().add((Object)clashDetectionUrl);
        ParameterDefinition clashDetectionIdentifier = StoreFactory.eINSTANCE.createParameterDefinition();
        clashDetectionIdentifier.setName("Clash detection identifier");
        clashDetectionIdentifier.setIdentifier("clashdetectionidentifier");
        clashDetectionIdentifier.setType((TypeDefinition)stringType);
        settingsDefinition.getParameters().add((Object)clashDetectionIdentifier);
        return settingsDefinition;
    }

    public BimBotsOutput runBimBot(BimBotsInput input, BimBotContext bimBotContext, PluginConfiguration pluginConfiguration) throws BimBotsException {
        IfcModelInterface model = input.getIfcModel();
        this.modelLengthUnit = IfcUtils.getLengthUnit((IfcModelInterface)model);
        this.modelAreaUnit = this.modelLengthUnit.toAreaUnit();
        this.modelVolumeUnit = this.modelLengthUnit.toVolumeUnit();
        ObjectNode result = OBJECT_MAPPER.createObjectNode();
        result.set("header", (JsonNode)this.proccessIfcHeader(model.getModelMetaData().getIfcHeader()));
        result.set("project", this.processProject(model));
        result.set("materials", this.processMaterials(model));
        result.set("classifications", this.processClassification(model));
        result.set("aggregations", this.processAggregations(model));
        result.set("checks", this.processChecks(input, pluginConfiguration));
        BimBotsOutput bimBotsOutput = new BimBotsOutput("IFC_ANALYTICS_JSON_1_0", result.toString().getBytes(Charsets.UTF_8));
        bimBotsOutput.setTitle("Ifc Analytics Results");
        bimBotsOutput.setContentType("application/json");
        return bimBotsOutput;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayNode callClashDetectionService(BimBotsInput input, String url, String token, String identifier) {
        try (BimBotClient bimBotClient = new BimBotClient(url, token);){
            BimBotsOutput bimBotsOutput = bimBotClient.call(identifier, input);
            ArrayNode arrayNode = (ArrayNode)OBJECT_MAPPER.readValue(bimBotsOutput.getData(), ArrayNode.class);
            return arrayNode;
        }
        catch (BimBotExecutionException e) {
            e.printStackTrace();
            return null;
        }
        catch (JsonParseException e) {
            e.printStackTrace();
            return null;
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private JsonNode processChecks(BimBotsInput input, PluginConfiguration pluginConfiguration) {
        ObjectNode checksNode = OBJECT_MAPPER.createObjectNode();
        if (pluginConfiguration.has("clashdetectionenabled") && pluginConfiguration.getBoolean("clashdetectionenabled").booleanValue()) {
            String url = pluginConfiguration.getString("clashdetectionurl");
            String identifier = pluginConfiguration.getString("clashdetectionidentifier");
            String token = pluginConfiguration.getString("clashdetectiontoken");
            checksNode.set("clashes", (JsonNode)this.callClashDetectionService(input, url, token, identifier));
        }
        checksNode.put("hasCubeNearZero", this.cubesNearZero == 1);
        return checksNode;
    }

    private JsonNode processAggregations(IfcModelInterface model) {
        ObjectNode aggregations = OBJECT_MAPPER.createObjectNode();
        ObjectNode perType = OBJECT_MAPPER.createObjectNode();
        aggregations.set("perType", (JsonNode)perType);
        ArrayList<ObjectDetails> objects = new ArrayList<ObjectDetails>();
        double totalSpaceM2 = 0.0;
        double totalSpaceM3 = 0.0;
        int totalNrOfTriangles = 0;
        for (EClass ifcProductClass : model.getPackageMetaData().getAllSubClasses(Ifc2x3tc1Package.eINSTANCE.getIfcProduct())) {
            int totalTypeTriangles = 0;
            List products = model.getAll(ifcProductClass);
            int nrOfObjects = products.size();
            if (nrOfObjects == 0) continue;
            int totalNrOfTypeTriangles = 0;
            int totalNrOfPsets = 0;
            int totalNrOfProperties = 0;
            int totalNrOfRelations = 0;
            for (IdEObject product : products) {
                ObjectDetails objectDetails = new ObjectDetails(product);
                objects.add(objectDetails);
                GeometryInfo geometry = (GeometryInfo)product.eGet(product.eClass().getEStructuralFeature("geometry"));
                if (geometry != null) {
                    totalNrOfTypeTriangles += geometry.getPrimitiveCount().intValue();
                    totalNrOfTriangles += geometry.getPrimitiveCount().intValue();
                    totalTypeTriangles += geometry.getPrimitiveCount().intValue();
                    double volumeM3 = VolumeUnit.CUBIC_METER.convert(geometry.getVolume(), this.modelVolumeUnit);
                    if (volumeM3 > 0.999 && volumeM3 < 1.001 && this.allVerticesWithinOneMeterOfZero(geometry, this.modelLengthUnit)) {
                        ++this.cubesNearZero;
                    }
                    objectDetails.setNrTriangles(geometry.getPrimitiveCount());
                    objectDetails.setVolume(DEFAULT_VOLUME_UNIT.convert(geometry.getVolume(), this.modelVolumeUnit));
                    if (ifcProductClass.getName().equals("IfcSpace")) {
                        totalSpaceM2 += DEFAULT_AREA_UNIT.convert(geometry.getArea(), this.modelAreaUnit);
                        totalSpaceM3 += DEFAULT_VOLUME_UNIT.convert(geometry.getVolume(), this.modelVolumeUnit);
                    }
                }
                totalNrOfPsets += IfcUtils.getNrOfPSets((IdEObject)product, (boolean)true);
                int nrOfProperties = IfcUtils.getNrOfProperties((IdEObject)product);
                totalNrOfProperties += nrOfProperties;
                objectDetails.setNrOfProperties(nrOfProperties);
                totalNrOfRelations += IfcUtils.getNrOfRelations((IdEObject)product);
            }
            ObjectNode productNode = OBJECT_MAPPER.createObjectNode();
            productNode.put("numberOfObjects", nrOfObjects);
            if (totalNrOfTypeTriangles > 0) {
                productNode.put("averageNumberOfTriangles", totalTypeTriangles / nrOfObjects);
            }
            productNode.put("averageNumberOfPsets", totalNrOfPsets / nrOfObjects);
            productNode.put("averageNumberOfProperties", totalNrOfProperties / nrOfObjects);
            productNode.put("averageNumberOfRelations", totalNrOfRelations / nrOfObjects);
            perType.set(ifcProductClass.getName(), (JsonNode)productNode);
        }
        objects.sort(new Comparator<ObjectDetails>(){

            @Override
            public int compare(ObjectDetails o1, ObjectDetails o2) {
                return Float.valueOf(o2.getTrianglesPerVolume()).compareTo(Float.valueOf(o1.getTrianglesPerVolume()));
            }
        });
        ArrayNode topTenMostComplex = OBJECT_MAPPER.createArrayNode();
        for (int i = 0; i < 10 && i < objects.size(); ++i) {
            ObjectDetails objectDetails = (ObjectDetails)objects.get(i);
            ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
            objectNode.put("type", objectDetails.getProduct().eClass().getName());
            this.putNameAndGuid(objectNode, objectDetails.getProduct());
            if (objectDetails.getPrimitiveCount() != 0) {
                objectNode.put("numberOfTriangles", objectDetails.getPrimitiveCount());
            }
            if (objectDetails.getVolume() != 0.0) {
                objectNode.put("volumeM3", objectDetails.getVolume());
            }
            if (!Float.isNaN(objectDetails.getTrianglesPerVolume())) {
                objectNode.put("trianglesPerM3", objectDetails.getTrianglesPerVolume());
            }
            topTenMostComplex.add((JsonNode)objectNode);
        }
        aggregations.set("topTenMostComplexObjects", (JsonNode)topTenMostComplex);
        objects.sort(new Comparator<ObjectDetails>(){

            @Override
            public int compare(ObjectDetails o1, ObjectDetails o2) {
                return o2.getNrOfProperties() - o1.getNrOfProperties();
            }
        });
        ArrayNode topTenMostProperties = OBJECT_MAPPER.createArrayNode();
        for (int i = 0; i < 10 && i < objects.size(); ++i) {
            ObjectDetails objectDetails = (ObjectDetails)objects.get(i);
            ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
            objectNode.put("type", objectDetails.getProduct().eClass().getName());
            this.putNameAndGuid(objectNode, objectDetails.getProduct());
            objectNode.put("numberOfProperties", objectDetails.getNrOfProperties());
            topTenMostProperties.add((JsonNode)objectNode);
        }
        aggregations.set("topTenMostProperties", (JsonNode)topTenMostProperties);
        ObjectNode completeModel = OBJECT_MAPPER.createObjectNode();
        double averagem2 = (double)totalNrOfTriangles / totalSpaceM2;
        double averagem3 = (double)totalNrOfTriangles / totalSpaceM3;
        if (Double.isFinite(averagem2)) {
            completeModel.put("averageAmountOfTrianglesPerM2", averagem2);
        }
        if (Double.isFinite(averagem3)) {
            completeModel.put("averageAmountOfTrianglesPerM3", averagem3);
        }
        aggregations.set("completeModel", (JsonNode)completeModel);
        return aggregations;
    }

    private boolean allVerticesWithinOneMeterOfZero(GeometryInfo geometryInfo, LengthUnit modelLengthUnit) {
        boolean allVerticesWithin1Meter = true;
        if (geometryInfo.getData() != null && geometryInfo.getData().getVertices() != null && geometryInfo.getData().getVertices().getData() != null) {
            FloatBuffer vertices = ByteBuffer.wrap(geometryInfo.getData().getVertices().getData()).asFloatBuffer();
            for (int i = 0; i < vertices.capacity(); ++i) {
                float v = vertices.get(i);
                float meters = LengthUnit.METER.convert(v, modelLengthUnit);
                if (!(meters < -1.0f) && !(meters > 1.0f)) continue;
                allVerticesWithin1Meter = false;
                break;
            }
        } else {
            Bounds bounds = geometryInfo.getBoundsMm();
            double[] d = new double[]{bounds.getMin().getX(), bounds.getMin().getY(), bounds.getMin().getZ(), bounds.getMax().getX(), bounds.getMax().getY(), bounds.getMax().getZ()};
            for (int i = 0; i < 6; ++i) {
                if (!(d[i] < -1000.0) && !(d[i] > 1000.0)) continue;
                allVerticesWithin1Meter = false;
                break;
            }
        }
        return allVerticesWithin1Meter;
    }

    private void putNameAndGuid(ObjectNode objectNode, IdEObject ifcRoot) {
        String guid;
        EStructuralFeature globalIdFeature = ifcRoot.eClass().getEStructuralFeature("GlobalId");
        EStructuralFeature nameFeature = ifcRoot.eClass().getEStructuralFeature("Name");
        String name = (String)ifcRoot.eGet(nameFeature);
        if (name != null) {
            objectNode.put("name", name);
        }
        if (globalIdFeature != null && (guid = (String)ifcRoot.eGet(globalIdFeature)) != null) {
            objectNode.put("guid", guid);
        }
    }

    private JsonNode processClassification(IfcModelInterface model) {
        ObjectNode classificationReferenceNode;
        ArrayNode classificationsNode = OBJECT_MAPPER.createArrayNode();
        HashMap<Long, Object> classificationMap = new HashMap<Long, Object>();
        HashMap<String, Object> classificationMapByString = new HashMap<String, Object>();
        HashMap<String, ObjectNode> classificationReferenceMapByString = new HashMap<String, ObjectNode>();
        for (IfcClassification ifcClassification : model.getAll(IfcClassification.class)) {
            IfcCalendarDate editionDate;
            String canonicalName = ifcClassification.getName() + "_" + ifcClassification.getEdition() + "_" + ifcClassification.getSource();
            Object classificationNode = OBJECT_MAPPER.createObjectNode();
            if (ifcClassification.getName() != null) {
                classificationNode.put("name", ifcClassification.getName());
            }
            if (ifcClassification.getEdition() != null) {
                classificationNode.put("edition", ifcClassification.getEdition());
            }
            if (ifcClassification.getSource() != null) {
                classificationNode.put("source", ifcClassification.getSource());
            }
            if ((editionDate = ifcClassification.getEditionDate()) != null) {
                ObjectNode editionDateNode = OBJECT_MAPPER.createObjectNode();
                editionDateNode.put("yearComponent", editionDate.getYearComponent());
                editionDateNode.put("monthComponent", editionDate.getMonthComponent());
                editionDateNode.put("dayComponent", editionDate.getDayComponent());
                canonicalName = canonicalName + editionDate.getYearComponent() + "_" + editionDate.getMonthComponent() + "_" + editionDate.getDayComponent();
                classificationNode.set("editionDate", (JsonNode)editionDateNode);
            }
            ArrayNode referencesNode = OBJECT_MAPPER.createArrayNode();
            classificationNode.set("references", (JsonNode)referencesNode);
            if (classificationMapByString.containsKey(canonicalName)) {
                classificationNode = (ObjectNode)classificationMapByString.get(canonicalName);
            } else {
                classificationMapByString.put(canonicalName, classificationNode);
                classificationsNode.add((JsonNode)classificationNode);
            }
            classificationMap.put(ifcClassification.getOid(), classificationNode);
        }
        ObjectNode noClassification = OBJECT_MAPPER.createObjectNode();
        noClassification.put("name", "NO_CLASSIFICATION");
        noClassification.set("references", (JsonNode)OBJECT_MAPPER.createArrayNode());
        classificationsNode.add((JsonNode)noClassification);
        ObjectNode noClassificationReference = OBJECT_MAPPER.createObjectNode();
        noClassificationReference.put("name", "NO_CLASSIFICATION_REFERENCE");
        noClassificationReference.put("numberOfObjects", 0);
        ((ArrayNode)noClassification.get("references")).add((JsonNode)noClassificationReference);
        HashMap<Long, ObjectNode> classificationReferences = new HashMap<Long, ObjectNode>();
        for (IfcClassificationReference ifcClassificationReference : model.getAllWithSubTypes(IfcClassificationReference.class)) {
            IfcClassification referencedSource = ifcClassificationReference.getReferencedSource();
            ObjectNode classificationNode = null;
            classificationNode = referencedSource == null ? noClassification : (ObjectNode)classificationMap.get(referencedSource.getOid());
            String canonicalName = ifcClassificationReference.getLocation() + "_" + ifcClassificationReference.getItemReference() + "_" + ifcClassificationReference.getName();
            classificationReferenceNode = null;
            if (classificationReferenceMapByString.containsKey(canonicalName)) {
                classificationReferenceNode = (ObjectNode)classificationReferenceMapByString.get(canonicalName);
            } else {
                classificationReferenceNode = OBJECT_MAPPER.createObjectNode();
                if (ifcClassificationReference.getLocation() != null) {
                    classificationReferenceNode.put("location", ifcClassificationReference.getLocation());
                }
                if (ifcClassificationReference.getItemReference() != null) {
                    classificationReferenceNode.put("itemReference", ifcClassificationReference.getItemReference());
                }
                if (ifcClassificationReference.getName() != null) {
                    classificationReferenceNode.put("name", ifcClassificationReference.getName());
                }
                classificationReferenceNode.put("numberOfObjects", 0);
                classificationReferenceMapByString.put(canonicalName, classificationReferenceNode);
                ((ArrayNode)classificationNode.get("references")).add((JsonNode)classificationReferenceNode);
            }
            classificationReferences.put(ifcClassificationReference.getOid(), classificationReferenceNode);
        }
        HashSet<Long> set = new HashSet<Long>();
        for (IfcRelAssociatesClassification ifcRelAssociatesClassification : model.getAll(IfcRelAssociatesClassification.class)) {
            IfcClassificationNotationSelect relatingClassification = ifcRelAssociatesClassification.getRelatingClassification();
            if (!(relatingClassification instanceof IfcClassificationReference)) continue;
            IfcClassificationReference ifcClassificationReference = (IfcClassificationReference)relatingClassification;
            classificationReferenceNode = (ObjectNode)classificationReferences.get(ifcClassificationReference.getOid());
            ifcRelAssociatesClassification.getRelatedObjects();
            EList relatedObjects = ifcRelAssociatesClassification.getRelatedObjects();
            for (IfcRoot ifcRoot : relatedObjects) {
                set.add(ifcRoot.getOid());
            }
            classificationReferenceNode.put("numberOfObjects", classificationReferenceNode.get("numberOfObjects").asInt() + relatedObjects.size());
        }
        for (IfcProduct ifcProduct : model.getAllWithSubTypes(IfcProduct.class)) {
            if (set.contains(ifcProduct.getOid())) continue;
            noClassificationReference.put("numberOfObjects", noClassificationReference.get("numberOfObjects").asInt() + 1);
        }
        return classificationsNode;
    }

    private JsonNode processMaterials(IfcModelInterface model) {
        ArrayNode materialsNode = OBJECT_MAPPER.createArrayNode();
        HashMap<Long, ObjectNode> materialNodes = new HashMap<Long, ObjectNode>();
        for (Object ifcMaterial : model.getAll(IfcMaterial.class)) {
            ObjectNode materialNode = OBJECT_MAPPER.createObjectNode();
            this.putNameAndGuid(materialNode, (IdEObject)ifcMaterial);
            materialNode.put("nrOfProducts", 0);
            materialNodes.put(ifcMaterial.getOid(), materialNode);
            materialsNode.add((JsonNode)materialNode);
        }
        HashSet<Long> objectsWithMaterial = new HashSet<Long>();
        for (IfcRelAssociatesMaterial ifcRelAssociatesMaterial : model.getAll(IfcRelAssociatesMaterial.class)) {
            EList objects = ifcRelAssociatesMaterial.getRelatedObjects();
            for (IfcRoot object : objects) {
                objectsWithMaterial.add(object.getOid());
            }
            IfcMaterialSelect relatingMaterial = ifcRelAssociatesMaterial.getRelatingMaterial();
            if (relatingMaterial instanceof IfcMaterial) {
                ObjectNode materialNode = (ObjectNode)materialNodes.get(relatingMaterial.getOid());
                materialNode.put("nrOfProducts", materialNode.get("nrOfProducts").asInt() + objects.size());
                continue;
            }
            if (!(relatingMaterial instanceof IfcMaterialLayerSetUsage)) continue;
            IfcMaterialLayerSetUsage ifcMaterialLayerSetUsage = (IfcMaterialLayerSetUsage)relatingMaterial;
            IfcMaterialLayerSet forLayerSet = ifcMaterialLayerSetUsage.getForLayerSet();
            for (IfcMaterialLayer ifcMaterialLayer : forLayerSet.getMaterialLayers()) {
                IfcMaterial ifcMaterial = ifcMaterialLayer.getMaterial();
                ObjectNode materialNode = (ObjectNode)materialNodes.get(ifcMaterial.getOid());
                materialNode.put("nrOfProducts", materialNode.get("nrOfProducts").asInt() + objects.size());
            }
        }
        ObjectNode noMaterialNode = OBJECT_MAPPER.createObjectNode();
        noMaterialNode.put("name", "NO_MATERIAL");
        materialsNode.add((JsonNode)noMaterialNode);
        int objectsWithoutMaterial = 0;
        for (IfcProduct ifcProduct : model.getAllWithSubTypes(IfcProduct.class)) {
            if (objectsWithMaterial.contains(ifcProduct.getOid())) continue;
            ++objectsWithoutMaterial;
        }
        noMaterialNode.put("nrOfProducts", objectsWithoutMaterial);
        return materialsNode;
    }

    private JsonNode processProject(IfcModelInterface model) {
        IdEObject ifcProject = model.getFirst(model.getPackageMetaData().getEClass("IfcProject"));
        if (ifcProject == null) {
            return null;
        }
        ObjectNode projectNode = OBJECT_MAPPER.createObjectNode();
        this.putNameAndGuid(projectNode, ifcProject);
        IdEObject unitInContext = (IdEObject)ifcProject.eGet(ifcProject.eClass().getEStructuralFeature("UnitsInContext"));
        if (unitInContext != null) {
            ArrayNode unitsNode = OBJECT_MAPPER.createArrayNode();
            List units = (List)unitInContext.eGet(unitInContext.eClass().getEStructuralFeature("Units"));
            for (IdEObject unit : units) {
                Object prefix;
                EStructuralFeature prefixFeature;
                Object name;
                EStructuralFeature nameFeature;
                Object unitType;
                ObjectNode unitNode = OBJECT_MAPPER.createObjectNode();
                EStructuralFeature unitTypeFeature = unit.eClass().getEStructuralFeature("UnitType");
                if (unitTypeFeature != null && (unitType = unit.eGet(unitTypeFeature)) != null) {
                    unitNode.put("unitType", unitType.toString());
                }
                if ((nameFeature = unit.eClass().getEStructuralFeature("Name")) != null && (name = unit.eGet(nameFeature)) != null) {
                    unitNode.put("name", name.toString());
                }
                if ((prefixFeature = unit.eClass().getEStructuralFeature("Prefix")) != null && (prefix = unit.eGet(prefixFeature)) != null) {
                    unitNode.put("prefix", prefix.toString());
                }
                unitsNode.add((JsonNode)unitNode);
            }
            projectNode.set("units", (JsonNode)unitsNode);
        }
        List isDecomposedBy = (List)ifcProject.eGet(ifcProject.eClass().getEStructuralFeature("IsDecomposedBy"));
        ArrayNode sitesNode = OBJECT_MAPPER.createArrayNode();
        for (IdEObject ifcRelDecomposes : isDecomposedBy) {
            List sites = (List)ifcRelDecomposes.eGet(ifcRelDecomposes.eClass().getEStructuralFeature("RelatedObjects"));
            for (IdEObject ifcSite : sites) {
                sitesNode.add(this.processSite(model, ifcSite));
            }
        }
        projectNode.set("sites", (JsonNode)sitesNode);
        return projectNode;
    }

    private ObjectNode processBuilding(IfcModelInterface model, IfcBuilding ifcBuilding) {
        IfcPostalAddress buildingAddress = ifcBuilding.getBuildingAddress();
        if (buildingAddress != null) {
            // empty if block
        }
        ObjectNode buildingNode = OBJECT_MAPPER.createObjectNode();
        this.putNameAndGuid(buildingNode, (IdEObject)ifcBuilding);
        ArrayNode storeysNode = OBJECT_MAPPER.createArrayNode();
        buildingNode.set("storeys", (JsonNode)storeysNode);
        for (IfcRelDecomposes ifcRelDecomposes : ifcBuilding.getIsDecomposedBy()) {
            for (IfcObjectDefinition ifcObjectDefinition : ifcRelDecomposes.getRelatedObjects()) {
                if (!(ifcObjectDefinition instanceof IfcBuildingStorey)) continue;
                IfcBuildingStorey ifcBuildingStorey = (IfcBuildingStorey)ifcObjectDefinition;
                int numberOfObjectsInStorey = IfcUtils.countDecomposed((IfcObjectDefinition)ifcBuildingStorey);
                ObjectNode buildingStoreyNode = OBJECT_MAPPER.createObjectNode();
                this.putNameAndGuid(buildingStoreyNode, (IdEObject)ifcBuildingStorey);
                buildingStoreyNode.put("totalNumberOfObjects", numberOfObjectsInStorey);
                ArrayNode spacesNode = OBJECT_MAPPER.createArrayNode();
                for (IfcRelDecomposes ifcRelDecomposes2 : ifcBuildingStorey.getIsDecomposedBy()) {
                    for (IfcObjectDefinition ifcObjectDefinition2 : ifcRelDecomposes2.getRelatedObjects()) {
                        if (!(ifcObjectDefinition2 instanceof IfcSpace)) continue;
                        IfcSpace ifcSpace = (IfcSpace)ifcObjectDefinition2;
                        ObjectNode spaceNode = OBJECT_MAPPER.createObjectNode();
                        this.putNameAndGuid(spaceNode, (IdEObject)ifcSpace);
                        GeometryInfo spaceGeometry = ifcSpace.getGeometry();
                        if (spaceGeometry != null) {
                            spaceNode.put("m2", DEFAULT_AREA_UNIT.convert(spaceGeometry.getArea(), this.modelAreaUnit));
                            spaceNode.put("m3", DEFAULT_VOLUME_UNIT.convert(spaceGeometry.getVolume(), this.modelVolumeUnit));
                        }
                        ArrayNode zonesNode = OBJECT_MAPPER.createArrayNode();
                        for (IfcRelAssigns ifcRelAssigns : ifcSpace.getHasAssignments()) {
                            IfcRelAssignsToGroup ifcRelAssignsToGroup;
                            IfcGroup relatingGroup;
                            if (!(ifcRelAssigns instanceof IfcRelAssignsToGroup) || !((relatingGroup = (ifcRelAssignsToGroup = (IfcRelAssignsToGroup)ifcRelAssigns).getRelatingGroup()) instanceof IfcZone)) continue;
                            IfcZone ifcZone = (IfcZone)relatingGroup;
                            ObjectNode zoneNode = OBJECT_MAPPER.createObjectNode();
                            this.putNameAndGuid(zoneNode, (IdEObject)ifcZone);
                            zonesNode.add((JsonNode)zoneNode);
                        }
                        if (zonesNode.size() > 0) {
                            spaceNode.set("zones", (JsonNode)zonesNode);
                        }
                        spacesNode.add((JsonNode)spaceNode);
                    }
                }
                buildingStoreyNode.set("spaces", (JsonNode)spacesNode);
                storeysNode.add((JsonNode)buildingStoreyNode);
            }
        }
        return buildingNode;
    }

    private JsonNode processSite(IfcModelInterface model, IdEObject ifcSite) {
        ObjectNode siteNode = OBJECT_MAPPER.createObjectNode();
        this.putNameAndGuid(siteNode, ifcSite);
        ArrayNode buildingsNode = OBJECT_MAPPER.createArrayNode();
        List isDecomposedBy = (List)ifcSite.eGet(ifcSite.eClass().getEStructuralFeature("IsDecomposedBy"));
        for (IdEObject ifcRelDecomposes : isDecomposedBy) {
            List relatedObjects = (List)ifcRelDecomposes.eGet(ifcRelDecomposes.eClass().getEStructuralFeature("RelatedObjects"));
            for (IdEObject ifcBuilding : relatedObjects) {
                buildingsNode.add((JsonNode)this.processBuilding(model, (IfcBuilding)ifcBuilding));
            }
        }
        siteNode.set("buildings", (JsonNode)buildingsNode);
        return siteNode;
    }

    private ObjectNode proccessIfcHeader(IfcHeader ifcHeader) {
        ObjectNode headerNode = OBJECT_MAPPER.createObjectNode();
        ArrayNode authorsNode = OBJECT_MAPPER.createArrayNode();
        headerNode.set("author", (JsonNode)authorsNode);
        for (Object author : ifcHeader.getAuthor()) {
            authorsNode.add((String)author);
        }
        headerNode.put("authorization", ifcHeader.getAuthorization());
        ArrayNode descriptionsNode = OBJECT_MAPPER.createArrayNode();
        for (String description : ifcHeader.getDescription()) {
            descriptionsNode.add(description);
        }
        headerNode.set("description", (JsonNode)descriptionsNode);
        headerNode.put("filename", ifcHeader.getFilename());
        headerNode.put("schemaVersion", ifcHeader.getIfcSchemaVersion());
        headerNode.put("implementationLevel", ifcHeader.getImplementationLevel());
        ArrayNode organizationsNode = OBJECT_MAPPER.createArrayNode();
        for (String organization : ifcHeader.getOrganization()) {
            organizationsNode.add(organization);
        }
        headerNode.set("organization", (JsonNode)organizationsNode);
        headerNode.put("originatingSystem", ifcHeader.getOriginatingSystem());
        headerNode.put("preProcessorVersion", ifcHeader.getPreProcessorVersion());
        headerNode.put("timeStamp", ifcHeader.getTimeStamp().getTime());
        return headerNode;
    }

    public String getOutputSchema() {
        return "IFC_ANALYTICS_JSON_1_0";
    }

    public boolean needsRawInput() {
        return true;
    }

    public boolean requiresGeometry() {
        return true;
    }
}

