/*
 * Decompiled with CFR 0.152.
 */
package org.ifcopenshell;

import com.google.common.base.Charsets;
import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Collections;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.shared.exceptions.PluginException;
import org.ifcopenshell.IfcGeomServerClientEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcGeomServerClient
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcGeomServerClient.class);
    private Process process = null;
    private LittleEndianDataInputStream dis = null;
    private LittleEndianDataOutputStream dos = null;
    private boolean hasMore = false;
    private volatile boolean running = true;
    private String executableFilename;
    private static final int HELLO = 65280;
    private static final int IFC_MODEL = 65281;
    private static final int GET = 65282;
    private static final int ENTITY = 65283;
    private static final int MORE = 65284;
    private static final int NEXT = 65285;
    private static final int BYE = 65286;
    private static final int GET_LOG = 65287;
    private static final int LOG = 65288;
    private static final int DEFLECTION = 65289;
    private static final int SETTING = 65290;
    private static String VERSION = "IfcOpenShell-0.6.0a1-0";

    public String getExecutableFilename() {
        return this.executableFilename;
    }

    @Override
    public void close() throws RenderEngineException {
        this.running = false;
        this.terminate();
    }

    private static String getOs() throws PluginException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            return "win";
        }
        if (os.contains("osx") || os.contains("os x") || os.contains("darwin") || os.contains("mac")) {
            return "osx";
        }
        if (os.contains("linux")) {
            return "linux";
        }
        throw new PluginException(String.format("IfcOpenShell is not available on the %s platorm", os));
    }

    private static String getExecutableExtension() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("windows")) {
            return ".exe";
        }
        return "";
    }

    public static Path getExecutablePathFromRepo(Path root) throws PluginException {
        String executableName = "IfcGeomServer" + IfcGeomServerClient.getExecutableExtension();
        String operatingSystem = IfcGeomServerClient.getOs();
        String bitness = operatingSystem.equals("osx") ? "64" : System.getProperty("sun.arch.data.model");
        return root.resolve("exe").resolve(bitness).resolve(operatingSystem).resolve(executableName);
    }

    private Path getSourcePath() throws RenderEngineException {
        String name = this.getClass().getName();
        int lastDot = name.lastIndexOf(".");
        name = name.substring(lastDot + 1) + ".class";
        try {
            return Paths.get(this.getClass().getResource(name).toURI()).getParent().getParent().getParent().getParent().getParent();
        }
        catch (URISyntaxException e) {
            throw new RenderEngineException((Exception)e);
        }
    }

    public IfcGeomServerClient(ExecutableSource source) throws RenderEngineException {
        this.getExecutable(source, Paths.get(System.getProperty("user.home"), new String[0]));
    }

    public IfcGeomServerClient(ExecutableSource source, Path homeDir) throws RenderEngineException {
        this.getExecutable(source, homeDir);
    }

    private void getExecutable(ExecutableSource source, Path homeDir) throws RenderEngineException {
        if (source == ExecutableSource.REPOSITORY) {
            try {
                this.initialize(IfcGeomServerClient.getExecutablePathFromRepo(this.getSourcePath()).toString());
            }
            catch (PluginException e) {
                throw new RenderEngineException((Exception)((Object)e));
            }
        }
        if (source == ExecutableSource.S3) {
            boolean initialized = false;
            String platform = "unknown";
            try {
                URL buildsUrl = new URL("https://s3.amazonaws.com/ifcopenshell-builds/v0.6.0.json");
                JsonArray builds = (JsonArray)new Gson().fromJson((Reader)new InputStreamReader(buildsUrl.openStream()), JsonArray.class);
                String os = IfcGeomServerClient.getOs();
                platform = os == "osx" ? "macOS 64" : Character.toUpperCase(os.charAt(0)) + os.substring(1) + " " + System.getProperty("sun.arch.data.model");
                for (int i = 0; i < builds.size(); ++i) {
                    String platformValue = builds.get(i).getAsJsonObject().get("platform").getAsString();
                    String productValue = builds.get(i).getAsJsonObject().get("product").getAsString();
                    String urlValue = builds.get(i).getAsJsonObject().get("url").getAsString();
                    if (!"IfcGeomServer".equals(productValue) || !platform.equals(platformValue)) continue;
                    String baseName = new File(new URL(urlValue).getPath()).getName();
                    baseName = baseName.substring(0, baseName.length() - 4);
                    File exePath = homeDir.resolve(baseName = baseName + IfcGeomServerClient.getExecutableExtension()).toFile();
                    if (!exePath.exists()) {
                        int len;
                        LOGGER.info(String.format("Downloading from %s", urlValue));
                        File tempZip = File.createTempFile(baseName, ".zip");
                        FileUtils.copyInputStreamToFile((InputStream)new URL(urlValue).openStream(), (File)tempZip);
                        ZipInputStream zis = new ZipInputStream(new FileInputStream(tempZip));
                        zis.getNextEntry();
                        exePath.getParentFile().mkdirs();
                        LOGGER.info(String.format("Unzipping to %s", exePath.toString()));
                        byte[] buffer = new byte[1024];
                        FileOutputStream fos = new FileOutputStream(exePath);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                        zis.closeEntry();
                        zis.close();
                        tempZip.delete();
                        try {
                            Files.setPosixFilePermissions(exePath.toPath(), Collections.singleton(PosixFilePermission.OWNER_EXECUTE));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.initialize(exePath.toString());
                    initialized = true;
                    break;
                }
            }
            catch (JsonIOException | JsonSyntaxException | IOException | PluginException e) {
                throw new RenderEngineException((Exception)e);
            }
            if (!initialized) {
                throw new RenderEngineException("No IfcGeomServer executable found for platform '" + platform + "'");
            }
        }
    }

    public IfcGeomServerClient(String executableFilename) throws RenderEngineException {
        this.initialize(executableFilename);
    }

    private void initialize(String executableFilename) throws RenderEngineException {
        try {
            this.executableFilename = executableFilename;
            this.process = Runtime.getRuntime().exec(executableFilename);
            this.dos = new LittleEndianDataOutputStream(this.process.getOutputStream());
            this.dis = new LittleEndianDataInputStream(this.process.getInputStream());
            if (this.dis.readInt() != 65280) {
                LOGGER.error("Invalid welcome message received");
                this.terminate();
                return;
            }
            Hello h = new Hello();
            h.read(this.dis);
            String reportedVersion = h.getString();
            if (!VERSION.equals(reportedVersion)) {
                this.terminate();
                throw new RenderEngineException(String.format("Version mismatch: Plugin version %s does not match IfcOpenShell version %s", VERSION, reportedVersion));
            }
        }
        catch (IOException e) {
            throw new RenderEngineException((Exception)e);
        }
    }

    public void loadModel(InputStream inputStream) throws RenderEngineException {
        IfcModel m = new IfcModel(inputStream);
        try {
            m.write(this.dos);
            this.askForMore();
        }
        catch (IOException e) {
            this.close();
        }
    }

    public void loadModel(InputStream inputStream, long length) throws RenderEngineException {
        IfcModel m = new IfcModel(inputStream, length);
        try {
            m.write(this.dos);
            this.askForMore();
        }
        catch (IOException e) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() throws RenderEngineException {
        this.hasMore = false;
        if (this.process == null) {
            return;
        }
        try {
            GetLog gl = new GetLog();
            gl.write(this.dos);
            if (this.dis.readInt() != 65288) {
                LOGGER.error("Invalid command sequence encountered");
                throw new IOException();
            }
            Log lg = new Log();
            lg.read(this.dis);
            String log = lg.getString().trim();
            if (log.length() > 0) {
                LOGGER.info("\n" + log);
            }
            Bye b = new Bye();
            b.write(this.dos);
            if (this.dis.readInt() != 65286) {
                LOGGER.error("Invalid command sequence encountered");
                throw new IOException();
            }
            b.read(this.dis);
        }
        catch (Throwable gl) {
            // empty catch block
        }
        try {
            int n = 0;
            while (true) {
                try {
                    if (this.process.exitValue() != 0) {
                        throw new RenderEngineException(String.format("Exited with non-zero exit code: %d", this.process.exitValue()));
                    }
                }
                catch (IllegalThreadStateException e) {
                    if (n++ == 20) {
                        this.process.destroy();
                        LOGGER.error("Forcefully terminated IfcOpenShell process");
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        finally {
            this.process.destroyForcibly();
        }
        this.dis = null;
        this.dos = null;
        this.process = null;
    }

    private void askForMore() throws IOException {
        this.hasMore = false;
        if (this.dis.readInt() != 65284) {
            LOGGER.error("Invalid command sequence encountered");
            throw new IOException();
        }
        More mr = new More();
        mr.read(this.dis);
        this.hasMore = mr.hasMore();
    }

    public IfcGeomServerClientEntity getNext() throws RenderEngineException {
        try {
            Get g = new Get();
            g.write(this.dos);
            if (this.dis.readInt() != 65283) {
                LOGGER.error("Invalid command sequence encountered");
                throw new IOException();
            }
            Entity e = new Entity();
            e.read(this.dis);
            Next n = new Next();
            n.write(this.dos);
            this.askForMore();
            return e.getEntity();
        }
        catch (IOException e) {
            this.terminate();
            return null;
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean hasNext() {
        return this.hasMore;
    }

    public String getVersion() {
        return VERSION;
    }

    static class Setting
    extends Command {
        private int id;
        private int value;

        Setting(SettingId i, boolean b) {
            super(65290);
            this.id = i.getId();
            this.value = b ? 1 : 0;
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) throws IOException {
            s.writeInt(this.id);
            s.writeInt(this.value);
        }

        public static enum SettingId {
            APPLY_LAYERSETS(131072);

            private final int id;

            private SettingId(int id) {
                this.id = id;
            }

            private int getId() {
                return this.id;
            }
        }
    }

    static class Deflection
    extends Command {
        private double deflection;

        Deflection(double deflection) {
            super(65289);
            this.deflection = deflection;
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) throws IOException {
            s.writeDouble(this.deflection);
        }
    }

    static class Log
    extends Command {
        private String string;

        Log() {
            super(65288);
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            this.string = this.readString(s);
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) {
            throw new UnsupportedOperationException();
        }

        public String getString() {
            return this.string;
        }
    }

    static class GetLog
    extends Command {
        GetLog() {
            super(65287);
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) {
        }
    }

    static class Entity
    extends Command {
        private IfcGeomServerClientEntity entity;

        Entity() {
            super(65283);
        }

        @Override
        void read_contents(LittleEndianDataInputStream s0) throws IOException {
            byte[] message = new byte[this.len];
            s0.readFully(message, 0, this.len);
            ByteArrayInputStream bis = new ByteArrayInputStream(message);
            LittleEndianDataInputStream s = new LittleEndianDataInputStream((InputStream)bis);
            this.entity = new IfcGeomServerClientEntity(s.readInt(), this.readString(s), this.readString(s), this.readString(s), s.readInt(), this.readDoubleArray(s), s.readInt(), this.readFloatArray(s), this.readFloatArray(s), this.readIntArray(s), this.readFloatArray(s), this.readIntArray(s), this.readRemainder(bis));
        }

        private String readRemainder(ByteArrayInputStream bis) {
            if (bis.available() == 0) {
                return null;
            }
            byte[] remainder = new byte[bis.available()];
            bis.read(remainder, 0, remainder.length);
            return new String(remainder);
        }

        public IfcGeomServerClientEntity getEntity() {
            return this.entity;
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) {
            throw new UnsupportedOperationException();
        }
    }

    static class Bye
    extends Command {
        Bye() {
            super(65286);
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) {
        }
    }

    static class Next
    extends Command {
        Next() {
            super(65285);
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) {
        }
    }

    static class Get
    extends Command {
        Get() {
            super(65282);
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) {
        }
    }

    static class IfcModel
    extends Command {
        private InputStream ifcInputStream;
        private long length = -1L;

        IfcModel(InputStream ifcInputStream) {
            super(65281);
            this.ifcInputStream = ifcInputStream;
        }

        IfcModel(InputStream ifcInputStream, long length) {
            super(65281);
            this.ifcInputStream = ifcInputStream;
            this.length = length;
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) throws IOException {
            if (this.length == -1L) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)this.ifcInputStream, (OutputStream)baos);
                this.writeStringBinary(s, baos.toByteArray());
            } else {
                this.writeStringBinary(s, this.ifcInputStream, (int)this.length);
            }
        }
    }

    static class More
    extends Command {
        private Boolean more;

        public Boolean hasMore() {
            return this.more;
        }

        More() {
            super(65284);
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            this.more = s.readInt() == 1;
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) {
            throw new UnsupportedOperationException();
        }
    }

    static class Hello
    extends Command {
        private String string;

        public String getString() {
            return this.string;
        }

        Hello() {
            super(65280);
        }

        @Override
        void read_contents(LittleEndianDataInputStream s) throws IOException {
            this.string = this.readString(s);
        }

        @Override
        void write_contents(LittleEndianDataOutputStream s) {
            throw new UnsupportedOperationException();
        }
    }

    static abstract class Command {
        int iden;
        int len;

        abstract void read_contents(LittleEndianDataInputStream var1) throws IOException;

        abstract void write_contents(LittleEndianDataOutputStream var1) throws IOException;

        void read(LittleEndianDataInputStream s) throws IOException {
            this.len = s.readInt();
            this.read_contents(s);
        }

        void write(LittleEndianDataOutputStream s) throws IOException {
            s.writeInt(this.iden);
            ByteArrayOutputStream oss = new ByteArrayOutputStream();
            this.write_contents(new LittleEndianDataOutputStream((OutputStream)oss));
            s.writeInt(oss.size());
            s.write(oss.toByteArray());
            s.flush();
        }

        Command(int iden) {
            this.iden = iden;
        }

        protected String readString(LittleEndianDataInputStream s) throws IOException {
            int len = s.readInt();
            byte[] b = new byte[len];
            s.readFully(b);
            String str = new String(b);
            while (len++ % 4 != 0) {
                s.read();
            }
            return str;
        }

        protected float[] readFloatArray(LittleEndianDataInputStream s) throws IOException {
            int len = s.readInt() / 4;
            float[] fs = new float[len];
            for (int i = 0; i < len; ++i) {
                fs[i] = s.readFloat();
            }
            return fs;
        }

        protected double[] readDoubleArray(LittleEndianDataInputStream s) throws IOException {
            int len = s.readInt() / 8;
            double[] fs = new double[len];
            for (int i = 0; i < len; ++i) {
                fs[i] = s.readDouble();
            }
            return fs;
        }

        protected int[] readIntArray(LittleEndianDataInputStream s) throws IOException {
            int len = s.readInt() / 4;
            int[] is = new int[len];
            for (int i = 0; i < len; ++i) {
                is[i] = s.readInt();
            }
            return is;
        }

        protected void writeString(LittleEndianDataOutputStream s, String str) throws IOException {
            byte[] b = str.getBytes(Charsets.UTF_8);
            int len = b.length;
            s.writeInt(len);
            s.write(b);
            while (len++ % 4 != 0) {
                s.write(0);
            }
        }

        protected void writeStringBinary(LittleEndianDataOutputStream s, byte[] data) throws IOException {
            int len = data.length;
            s.writeInt(len);
            s.write(data);
            while (len++ % 4 != 0) {
                s.write(0);
            }
        }

        protected void writeStringBinary(LittleEndianDataOutputStream s, InputStream inputStream, int length) throws IOException {
            s.writeInt(length);
            IOUtils.copy((InputStream)inputStream, (OutputStream)s);
            while (length++ % 4 != 0) {
                s.write(0);
            }
        }
    }

    public static enum ExecutableSource {
        REPOSITORY,
        S3;

    }
}

