/*
 * Decompiled with CFR 0.152.
 */
package org.ifcopenshell;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import org.bimserver.geometry.Matrix;
import org.bimserver.plugins.renderengine.RenderEngineException;

public class IfcGeomServerClientEntity {
    private int id;
    private String guid;
    private String name;
    private String type;
    private int parentId;
    private double[] matrix;
    private int repId;
    private float[] positions;
    private float[] normals;
    private int[] indices;
    private float[] colors;
    private int[] materialIndices;
    private JsonObject extendedData;

    public IfcGeomServerClientEntity(int id, String guid, String name, String type, int parentId, double[] matrix, int repId, float[] positions, float[] normals, int[] indices, float[] colors, int[] materialIndices, String messageRemainder) {
        this.id = id;
        this.guid = guid;
        this.name = name;
        this.type = type;
        this.parentId = parentId;
        this.matrix = Matrix.changeOrientation((double[])matrix);
        this.repId = repId;
        this.positions = positions;
        this.normals = normals;
        this.indices = indices;
        this.colors = colors;
        this.materialIndices = materialIndices;
        this.extendedData = null;
        if (messageRemainder != null && messageRemainder.length() > 0) {
            this.extendedData = new JsonParser().parse(messageRemainder.trim()).getAsJsonObject();
        }
    }

    public int getId() {
        return this.id;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getParentId() {
        return this.parentId;
    }

    public double[] getMatrix() {
        return this.matrix;
    }

    public int getRepId() {
        return this.repId;
    }

    public float[] getPositions() {
        return this.positions;
    }

    public float[] getNormals() {
        return this.normals;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public float[] getColors() {
        return this.colors;
    }

    public int[] getMaterialIndices() {
        return this.materialIndices;
    }

    public int getNumberOfPrimitives() {
        return this.indices.length / 3;
    }

    public int getNumberOfColors() {
        return this.colors.length / 4;
    }

    public float getExtendedDataAsFloat(String name) throws RenderEngineException {
        if (this.extendedData == null) {
            throw new RenderEngineException("No extended data for Entity " + this.guid);
        }
        JsonElement elem = this.extendedData.get(name);
        if (elem == null) {
            throw new RenderEngineException("No extended data entry found for " + name);
        }
        return elem.getAsFloat();
    }
}

