/*
 * Decompiled with CFR 0.152.
 */
package org.ifcopenshell;

import java.io.IOException;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.shared.exceptions.PluginException;
import org.ifcopenshell.IfcGeomServerClient;
import org.ifcopenshell.IfcOpenShellEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcOpenShellEnginePlugin
implements RenderEnginePlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcOpenShellEnginePlugin.class);
    private String executableFilename;

    public RenderEngine createRenderEngine(PluginConfiguration pluginConfiguration, String schema) throws RenderEngineException {
        try {
            return new IfcOpenShellEngine(this.executableFilename);
        }
        catch (IOException e) {
            throw new RenderEngineException((Exception)e);
        }
    }

    public void init(PluginContext pluginContext) throws PluginException {
        IfcGeomServerClient test = new IfcGeomServerClient(IfcGeomServerClient.ExecutableSource.S3, pluginContext.getTempDir());
        this.executableFilename = test.getExecutableFilename();
        LOGGER.info("Using " + this.executableFilename);
        test.close();
    }

    public ObjectDefinition getSettingsDefinition() {
        return null;
    }
}

