/*
 * Decompiled with CFR 0.152.
 */
package org.ifcopenshell;

import java.io.IOException;
import java.nio.file.Path;
import org.bimserver.models.store.BooleanType;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.renderengine.RenderEngine;
import org.bimserver.plugins.renderengine.RenderEngineException;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.plugins.renderengine.VersionInfo;
import org.bimserver.shared.exceptions.PluginException;
import org.ifcopenshell.IfcGeomServerClient;
import org.ifcopenshell.IfcOpenShellEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IfcOpenShellEnginePlugin
implements RenderEnginePlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcOpenShellEnginePlugin.class);
    public static final String BRANCH = "v0.6.0";
    public static final String DEFAULT_COMMIT_SHA = "b4ce5be";
    private static final String COMMIT_SHA_SETTING = "commitsha";
    private static final String CALCULATE_QUANTITIES_SETTING = "calculatequantities";
    private static final String APPLY_LAYER_SETS = "applylayersets";
    private Path executableFilename;
    private VersionInfo versionInfo;
    private boolean calculateQuantities = true;
    private boolean applyLayerSets = true;

    public RenderEngine createRenderEngine(PluginConfiguration pluginConfiguration, String schema) throws RenderEngineException {
        try {
            return new IfcOpenShellEngine(this.executableFilename, this.calculateQuantities, this.applyLayerSets);
        }
        catch (IOException e) {
            throw new RenderEngineException((Exception)e);
        }
    }

    public void init(PluginContext pluginContext, PluginConfiguration systemSettings) throws PluginException {
        if (systemSettings != null) {
            this.calculateQuantities = systemSettings.getBoolean(CALCULATE_QUANTITIES_SETTING, true);
            this.applyLayerSets = systemSettings.getBoolean(APPLY_LAYER_SETS, true);
        }
        String commitSha = DEFAULT_COMMIT_SHA;
        if (systemSettings != null && systemSettings.getString(COMMIT_SHA_SETTING) != null && !systemSettings.getString(COMMIT_SHA_SETTING).trim().contentEquals("")) {
            commitSha = systemSettings.getString(COMMIT_SHA_SETTING);
            LOGGER.info("Using overruled system setting for commit sha");
        }
        try (IfcGeomServerClient test = new IfcGeomServerClient(IfcGeomServerClient.ExecutableSource.S3, commitSha, pluginContext.getTempDir());){
            this.executableFilename = test.getExecutableFilename();
            this.versionInfo = new VersionInfo(BRANCH, commitSha, test.getVersion(), test.getBuildDateTime(), test.getPlatform());
        }
        LOGGER.info("Using " + this.executableFilename);
    }

    public ObjectDefinition getUserSettingsDefinition() {
        return null;
    }

    public ObjectDefinition getSystemSettingsDefinition() {
        ObjectDefinition settings = StoreFactory.eINSTANCE.createObjectDefinition();
        PrimitiveDefinition stringType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringType.setType(PrimitiveEnum.STRING);
        PrimitiveDefinition booleanType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        booleanType.setType(PrimitiveEnum.BOOLEAN);
        StringType defaultSha = StoreFactory.eINSTANCE.createStringType();
        defaultSha.setValue(DEFAULT_COMMIT_SHA);
        BooleanType defaultTrue = StoreFactory.eINSTANCE.createBooleanType();
        defaultTrue.setValue(true);
        ParameterDefinition commitShaParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        commitShaParameter.setIdentifier(COMMIT_SHA_SETTING);
        commitShaParameter.setName("Commit Sha");
        commitShaParameter.setDescription("Commit sha of IfcOpenShell binary, this overrules the default for the currently installated IfcOpenShell plugin");
        commitShaParameter.setType((TypeDefinition)stringType);
        commitShaParameter.setRequired(false);
        commitShaParameter.setDefaultValue((Type)defaultSha);
        ParameterDefinition calculateQuantities = StoreFactory.eINSTANCE.createParameterDefinition();
        calculateQuantities.setIdentifier(CALCULATE_QUANTITIES_SETTING);
        calculateQuantities.setName("Calculate Quantities");
        calculateQuantities.setDescription("Calculates volumes and areas, Takes a bit more time (about 15%)");
        calculateQuantities.setType((TypeDefinition)booleanType);
        calculateQuantities.setRequired(false);
        calculateQuantities.setDefaultValue((Type)defaultTrue);
        ParameterDefinition applyLayerSets = StoreFactory.eINSTANCE.createParameterDefinition();
        applyLayerSets.setIdentifier(APPLY_LAYER_SETS);
        applyLayerSets.setName("Apply Layer Sets");
        applyLayerSets.setDescription("Splits certain objects into several layers, depending on the model can take about 10x more processing time, and results in more geometry");
        applyLayerSets.setType((TypeDefinition)booleanType);
        applyLayerSets.setRequired(false);
        applyLayerSets.setDefaultValue((Type)defaultTrue);
        settings.getParameters().add((Object)commitShaParameter);
        settings.getParameters().add((Object)calculateQuantities);
        settings.getParameters().add((Object)applyLayerSets);
        return settings;
    }

    public VersionInfo getVersionInfo() {
        return this.versionInfo;
    }
}

