/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.serializers;

import java.util.HashSet;
import java.util.Set;
import org.bimserver.emf.Schema;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.serializers.StreamingSerializer;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.serializers.StreamingJsonSerializer;
import org.bimserver.shared.exceptions.PluginException;

public class JsonStreamingSerializerPlugin
implements StreamingSerializerPlugin {
    public void init(PluginContext pluginContext, PluginConfiguration systemSettings) throws PluginException {
    }

    public ObjectDefinition getUserSettingsDefinition() {
        ObjectDefinition objectDefinition = StoreFactory.eINSTANCE.createObjectDefinition();
        ParameterDefinition extensionParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        extensionParameter.setIdentifier("Extension");
        extensionParameter.setDescription("Extension of the downloaded file");
        PrimitiveDefinition stringType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringType.setType(PrimitiveEnum.STRING);
        extensionParameter.setType((TypeDefinition)stringType);
        StringType defaultExtensionValue = StoreFactory.eINSTANCE.createStringType();
        defaultExtensionValue.setValue("json");
        extensionParameter.setDefaultValue((Type)defaultExtensionValue);
        objectDefinition.getParameters().add((Object)extensionParameter);
        ParameterDefinition contentTypeParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        contentTypeParameter.setIdentifier("ContentType");
        contentTypeParameter.setDescription("Content-Type in the HTTP header of the downloaded file");
        contentTypeParameter.setType((TypeDefinition)stringType);
        StringType defaultContentTypeValue = StoreFactory.eINSTANCE.createStringType();
        defaultContentTypeValue.setValue("application/json");
        contentTypeParameter.setDefaultValue((Type)defaultContentTypeValue);
        objectDefinition.getParameters().add((Object)contentTypeParameter);
        PrimitiveDefinition stringDefinition = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        stringDefinition.setType(PrimitiveEnum.STRING);
        ParameterDefinition zipExtension = StoreFactory.eINSTANCE.createParameterDefinition();
        zipExtension.setIdentifier("ZipExtension");
        zipExtension.setDescription("Extension of the downloaded file when using zip compression");
        zipExtension.setType((TypeDefinition)stringDefinition);
        StringType defaultZipExtensionValue = StoreFactory.eINSTANCE.createStringType();
        defaultZipExtensionValue.setValue("zip");
        zipExtension.setDefaultValue((Type)defaultZipExtensionValue);
        objectDefinition.getParameters().add((Object)zipExtension);
        return objectDefinition;
    }

    public ObjectDefinition getSystemSettingsDefinition() {
        return null;
    }

    public StreamingSerializer createSerializer(PluginConfiguration pluginConfiguration) {
        return new StreamingJsonSerializer(pluginConfiguration);
    }

    public Set<Schema> getSupportedSchemas() {
        HashSet<Schema> schemas = new HashSet<Schema>();
        schemas.add(Schema.IFC2X3TC1);
        schemas.add(Schema.IFC4);
        return schemas;
    }

    public String getOutputFormat(Schema schema) {
        switch (schema) {
            case IFC2X3TC1: {
                return "IFC_JSON_2X3TC1";
            }
            case IFC4: {
                return "IFC_JSON_4";
            }
        }
        return null;
    }
}

