/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.ifcvalidator.checks.ModelCheckerRegistry;
import org.bimserver.interfaces.objects.SObjectType;
import org.bimserver.interfaces.objects.SProject;
import org.bimserver.models.store.BooleanType;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.models.store.ParameterDefinition;
import org.bimserver.models.store.PrimitiveDefinition;
import org.bimserver.models.store.PrimitiveEnum;
import org.bimserver.models.store.StoreFactory;
import org.bimserver.models.store.StringType;
import org.bimserver.models.store.Type;
import org.bimserver.models.store.TypeDefinition;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.services.AbstractAddExtendedDataService;
import org.bimserver.plugins.services.AbstractService;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueContainerSerializer;

public abstract class AbstractIfcValidatorPlugin
extends AbstractAddExtendedDataService {
    private final ModelCheckerRegistry modelCheckerRegistry;
    private boolean generateExtendedDataPerCheck = false;

    public AbstractIfcValidatorPlugin(String namespace, boolean generateExtendedDataPerCheck, ModelCheckerRegistry modelCheckerRegistry) {
        super(namespace);
        this.generateExtendedDataPerCheck = generateExtendedDataPerCheck;
        this.modelCheckerRegistry = modelCheckerRegistry;
    }

    public void init(PluginContext pluginContext) throws PluginException {
        super.init(pluginContext);
    }

    protected abstract IssueContainerSerializer createIssueInterface(CheckerContext var1);

    public void newRevision(AbstractService.RunningService runningService, BimServerClientInterface bimServerClientInterface, long poid, long roid, String userToken, long soid, SObjectType settings) throws Exception {
        runningService.updateProgress(0);
        SProject project = bimServerClientInterface.getServiceInterface().getProjectByPoid(Long.valueOf(poid));
        IfcModelInterface model = bimServerClientInterface.getModel(project, roid, true, false, true);
        PluginConfiguration pluginConfiguration = new PluginConfiguration(settings);
        String language = pluginConfiguration.getString("LANGUAGE");
        String filename = language.toLowerCase() + ".properties";
        Path propertiesFile = this.getPluginContext().getRootPath().resolve(filename);
        Properties properties = new Properties();
        properties.load(Files.newInputStream(propertiesFile, new OpenOption[0]));
        CheckerContext checkerContext = new CheckerContext(filename, properties, this.getPluginContext().getRootPath());
        IssueContainerSerializer issueContainerSerializer = this.createIssueInterface(checkerContext);
        IssueContainer issueContainer = new IssueContainer();
        for (String groupIdentifier : this.modelCheckerRegistry.getGroupIdentifiers()) {
            boolean headerAdded = false;
            for (String identifier : this.modelCheckerRegistry.getIdentifiers(groupIdentifier)) {
                String fullIdentifier = groupIdentifier + "___" + identifier;
                if (!pluginConfiguration.has(fullIdentifier) || !pluginConfiguration.getBoolean(fullIdentifier).booleanValue()) continue;
                ModelCheck modelCheck = this.modelCheckerRegistry.getModelCheck(groupIdentifier, identifier);
                modelCheck.check(model, issueContainer, checkerContext);
            }
            if (!this.generateExtendedDataPerCheck) continue;
            this.addExtendedData(issueContainerSerializer.getBytes(issueContainer), this.getFileName(), groupIdentifier, this.getContentType(), bimServerClientInterface, roid);
            issueContainer = new IssueContainer();
        }
        if (!this.generateExtendedDataPerCheck) {
            this.addExtendedData(issueContainerSerializer.getBytes(issueContainer), this.getFileName(), "IFC Validator", this.getContentType(), bimServerClientInterface, roid);
        }
        runningService.updateProgress(100);
    }

    public abstract String getContentType();

    public abstract String getFileName();

    public ObjectDefinition getSettingsDefinition() {
        ObjectDefinition objectDefinition = StoreFactory.eINSTANCE.createObjectDefinition();
        PrimitiveDefinition booleanType = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        booleanType.setType(PrimitiveEnum.BOOLEAN);
        BooleanType falseValue = StoreFactory.eINSTANCE.createBooleanType();
        falseValue.setValue(false);
        BooleanType trueValue = StoreFactory.eINSTANCE.createBooleanType();
        trueValue.setValue(true);
        PrimitiveDefinition languageValue = StoreFactory.eINSTANCE.createPrimitiveDefinition();
        languageValue.setType(PrimitiveEnum.STRING);
        StringType defaultLanguage = StoreFactory.eINSTANCE.createStringType();
        defaultLanguage.setValue("EN");
        ParameterDefinition languageParameter = StoreFactory.eINSTANCE.createParameterDefinition();
        languageParameter.setIdentifier("LANGUAGE");
        languageParameter.setDescription("Language of the output");
        languageParameter.setName("Language");
        languageParameter.setType((TypeDefinition)languageValue);
        languageParameter.setDefaultValue((Type)defaultLanguage);
        objectDefinition.getParameters().add((Object)languageParameter);
        String filename = "en.properties";
        Path propertiesFile = this.getPluginContext().getRootPath().resolve(filename);
        Properties properties = new Properties();
        try {
            properties.load(Files.newInputStream(propertiesFile, new OpenOption[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CheckerContext checkerContext = new CheckerContext(filename, properties, this.getPluginContext().getRootPath());
        for (String groupIdentifier : this.modelCheckerRegistry.getGroupIdentifiers()) {
            for (String identifier : this.modelCheckerRegistry.getIdentifiers(groupIdentifier)) {
                ModelCheck modelCheck = this.modelCheckerRegistry.getModelCheck(groupIdentifier, identifier);
                ParameterDefinition parameter = StoreFactory.eINSTANCE.createParameterDefinition();
                parameter.setIdentifier(groupIdentifier + "___" + identifier);
                parameter.setName(modelCheck.getName(checkerContext));
                parameter.setType((TypeDefinition)booleanType);
                parameter.setRequired(true);
                parameter.setDefaultValue((Type)(modelCheck.isEnabledByDefault() ? trueValue : falseValue));
                parameter.setDescription(modelCheck.getDescription(checkerContext));
                objectDefinition.getParameters().add((Object)parameter);
            }
        }
        return objectDefinition;
    }
}

