/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import jxl.CellView;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableFont;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.validationreport.Issue;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueContainerSerializer;

public class ExcelIssueInterface
implements IssueContainerSerializer {
    private WritableCellFormat times;
    private WritableCellFormat timesbold;
    private WritableSheet sheet;
    private ByteArrayOutputStream byteArrayOutputStream;
    private WritableWorkbook workbook;
    private int row;
    private WritableCellFormat error;
    private WritableCellFormat ok;
    private CheckerContext translator;
    private WorkbookSettings wbSettings;

    public ExcelIssueInterface(CheckerContext translator) {
        this.translator = translator;
        try {
            this.wbSettings = new WorkbookSettings();
            this.wbSettings.setLocale(new Locale("en", "EN"));
            WritableFont times10pt = new WritableFont(WritableFont.ARIAL, 10);
            this.times = new WritableCellFormat(times10pt);
            WritableFont times10ptbold = new WritableFont(WritableFont.ARIAL, 10);
            times10ptbold.setBoldStyle(WritableFont.BOLD);
            this.timesbold = new WritableCellFormat(times10ptbold);
            this.error = new WritableCellFormat(times10pt);
            this.error.setBackground(Colour.RED);
            this.ok = new WritableCellFormat(times10pt);
            this.ok.setBackground(Colour.LIGHT_GREEN);
            this.init(translator, this.wbSettings);
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void init(CheckerContext translator, WorkbookSettings wbSettings) throws IOException, WriteException, RowsExceededException {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.workbook = Workbook.createWorkbook((OutputStream)this.byteArrayOutputStream, (WorkbookSettings)wbSettings);
        this.sheet = this.workbook.createSheet("Sheet 1", 0);
        this.sheet.addCell((WritableCell)new Label(0, 0, translator.translate("REPORT_HEADER"), (CellFormat)this.timesbold));
        this.sheet.addCell((WritableCell)new Label(1, 0, translator.translate("REPORT_TYPE"), (CellFormat)this.timesbold));
        this.sheet.addCell((WritableCell)new Label(2, 0, translator.translate("REPORT_GUID_OID"), (CellFormat)this.timesbold));
        this.sheet.addCell((WritableCell)new Label(3, 0, translator.translate("REPORT_MESSAGE"), (CellFormat)this.timesbold));
        this.sheet.addCell((WritableCell)new Label(4, 0, translator.translate("REPORT_VALUE_IS"), (CellFormat)this.timesbold));
        this.sheet.addCell((WritableCell)new Label(5, 0, translator.translate("REPORT_VALUE_SHOULD_BE"), (CellFormat)this.timesbold));
        this.row = 1;
    }

    public byte[] getBytes(IssueContainer issueContainer) throws IOException {
        for (Issue issue : issueContainer.list()) {
        }
        for (int x = 0; x < 6; ++x) {
            CellView cell = this.sheet.getColumnView(x);
            cell.setAutosize(true);
            this.sheet.setColumnView(x, cell);
        }
        this.workbook.write();
        try {
            this.workbook.close();
        }
        catch (WriteException e) {
            throw new IOException(e);
        }
        return this.byteArrayOutputStream.toByteArray();
    }
}

