/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.util.Iterator;
import java.util.TreeMap;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.geometry.Vector3f;
import org.bimserver.models.ifc2x3tc1.IfcBuildingStorey;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.utils.IfcUtils;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class BuildingStoreyNamesAndZOrder
extends ModelCheck {
    public BuildingStoreyNamesAndZOrder() {
        super("BUILDINGSTOREYS", "BUILDING_STOREY_NAMES_AND_Z_ORDER");
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        TreeMap<Integer, IfcBuildingStorey> mapped = new TreeMap<Integer, IfcBuildingStorey>();
        for (IfcBuildingStorey ifcBuildingStorey : model.getAll(IfcBuildingStorey.class)) {
            String name = ifcBuildingStorey.getName();
            if (name.contains(" ")) {
                String[] split = name.split(" ");
                String number = split[0];
                try {
                    if (!Character.isDigit(number.charAt(number.length() - 1))) continue;
                    int storeyNumber = Integer.parseInt(number);
                    if (mapped.containsKey(storeyNumber)) {
                        issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcBuildingStorey).message("Duplicate storey name").is((Object)ifcBuildingStorey.getName()).shouldBe((Object)"").add();
                        continue;
                    }
                    mapped.put(storeyNumber, ifcBuildingStorey);
                    issueContainer.builder().type(Type.SUCCESS).object((IdEObject)ifcBuildingStorey).message("Valid building name").is((Object)ifcBuildingStorey.getName()).shouldBe((Object)"").add();
                }
                catch (NumberFormatException e) {
                    issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcBuildingStorey).message("Invalid building name, invalid number " + split[0]).is((Object)ifcBuildingStorey.getName()).shouldBe((Object)"").add();
                }
                continue;
            }
            issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcBuildingStorey).message("Invalid building name, no spaces").is((Object)ifcBuildingStorey.getName()).shouldBe((Object)"").add();
        }
        if (mapped.size() > 1) {
            double lastZ = -1.0;
            boolean increasingWithHeight = true;
            Iterator iterator = mapped.keySet().iterator();
            while (iterator.hasNext()) {
                int number = (Integer)iterator.next();
                IfcBuildingStorey ifcBuildingStorey = (IfcBuildingStorey)mapped.get(number);
                double minZ = Double.MAX_VALUE;
                double maxZ = -1.7976931348623157E308;
                for (IfcProduct ifcProduct : IfcUtils.getDecomposition((IfcBuildingStorey)ifcBuildingStorey)) {
                    GeometryInfo geometry = ifcProduct.getGeometry();
                    if (geometry == null) continue;
                    Vector3f min = geometry.getMinBounds();
                    Vector3f max = geometry.getMaxBounds();
                    if (min.getZ() < minZ) {
                        minZ = min.getZ();
                    }
                    if (!(max.getZ() > maxZ)) continue;
                    maxZ = max.getZ();
                }
                double aabbCenterZ = minZ + (maxZ - minZ) / 2.0;
                IfcBuildingStorey lastStorey = null;
                if (lastZ == -1.0 || aabbCenterZ > lastZ) {
                    lastZ = aabbCenterZ;
                    lastStorey = ifcBuildingStorey;
                    continue;
                }
                increasingWithHeight = false;
                issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcBuildingStorey).message("Building storey " + this.getObjectIdentifier((IfcProduct)ifcBuildingStorey) + " seems to be lower than " + this.getObjectIdentifier((IfcProduct)lastStorey)).is((Object)ifcBuildingStorey.getName()).shouldBe((Object)"").add();
            }
            if (increasingWithHeight) {
                issueContainer.builder().type(Type.SUCCESS).message("Storeys seem to be increasing with z-value and naming").add();
            }
        }
    }
}

