/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.CarparkAccessibilityConfiguration;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcObject;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcSpace;
import org.bimserver.models.ifc2x3tc1.Tristate;
import org.bimserver.utils.IfcTools2D;
import org.bimserver.utils.IfcUtils;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class CarparkAccessability
extends ModelCheck {
    private CarparkAccessibilityConfiguration conf;
    private float scaleToMm;

    public CarparkAccessability(CarparkAccessibilityConfiguration carparkAccessibilityConfiguration) {
        super("ACCESSIBILITY", "CARPARKS");
        this.conf = carparkAccessibilityConfiguration;
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        this.scaleToMm = IfcUtils.getLengthUnitPrefix((IfcModelInterface)model);
        int regularSpaces = 0;
        int handicappedSpaces = 0;
        int unidentifiedCarparks = 0;
        int unidentifiedSpaces = 0;
        int totalCarparks = 0;
        for (IfcSpace ifcSpace : model.getAll(IfcSpace.class)) {
            CarparkVote geometryVote;
            if (ifcSpace.getObjectType() == null || !ifcSpace.getObjectType().equalsIgnoreCase("parking")) continue;
            ++totalCarparks;
            CarparkVote psetVote = this.checkPset(ifcSpace);
            if (psetVote.equals(geometryVote = this.checkGeometry(ifcSpace))) {
                if (psetVote.carparkVoteType == CarparkVoteType.REGULAR_CARPARK) {
                    issueContainer.builder().type(Type.SUCCESS).object((IdEObject)ifcSpace).message("Both pset and geometry agree that this is a regular carpark").add();
                    ++regularSpaces;
                    continue;
                }
                if (psetVote.carparkVoteType == CarparkVoteType.HANDICAPPED_CARPARK) {
                    issueContainer.builder().type(Type.SUCCESS).object((IdEObject)ifcSpace).message("Both pset and geometry agree that this is a handicapped carpark").add();
                    ++handicappedSpaces;
                    continue;
                }
                if (psetVote.carparkVoteType == CarparkVoteType.NOT_A_CARPARK) continue;
                if (psetVote.carparkVoteType == CarparkVoteType.UNIDENTIFIED_CARPARK) {
                    issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcSpace).message("Both pset and geometry check did not lead to identifying the nature of this carpark").add();
                    ++unidentifiedCarparks;
                    continue;
                }
                if (psetVote.carparkVoteType != CarparkVoteType.UNIDENTIFIED_SPACE) continue;
                issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcSpace).message("Both pset and geometry check did not lead to identifying the nature of this space").add();
                ++unidentifiedSpaces;
                continue;
            }
            if (psetVote.carparkVoteType == CarparkVoteType.REGULAR_CARPARK) {
                issueContainer.builder().type(Type.CANNOT_CHECK).object((IdEObject)ifcSpace).message("This is a regular carpark according to " + psetVote.getType() + ", the geometry does not agree").add();
                continue;
            }
            if (psetVote.carparkVoteType == CarparkVoteType.HANDICAPPED_CARPARK) {
                issueContainer.builder().type(Type.CANNOT_CHECK).object((IdEObject)ifcSpace).message("This is a handicapped carpark according to " + psetVote.getType() + ", the geometry does not agree").add();
                continue;
            }
            if (psetVote.carparkVoteType == CarparkVoteType.NOT_A_CARPARK) continue;
            if (psetVote.carparkVoteType == CarparkVoteType.UNIDENTIFIED_CARPARK) {
                issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcSpace).message("The nature of this carpark could not be identified semantically").add();
                ++unidentifiedCarparks;
                continue;
            }
            if (psetVote.carparkVoteType != CarparkVoteType.UNIDENTIFIED_SPACE) continue;
            issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcSpace).message("Both pset and geometry check did not lead to identifying the nature of this space").add();
            ++unidentifiedSpaces;
        }
        if (unidentifiedSpaces > 0) {
            issueContainer.builder().type(Type.ERROR).message("The amount of unidentified spaces is too high").is((Object)unidentifiedSpaces).shouldBe((Object)0).add();
        }
        if (unidentifiedCarparks > 0) {
            issueContainer.builder().type(Type.ERROR).message("The amount of unidentified carparks is too high").is((Object)unidentifiedCarparks).shouldBe((Object)0).add();
        }
        if (regularSpaces > handicappedSpaces * this.conf.getRatioHandicappedToRegularParking()) {
            issueContainer.builder().type(Type.ERROR).message("The amount of handicapped carparks should be higher").is((Object)handicappedSpaces).shouldBe((Object)Math.ceil((double)regularSpaces / (double)this.conf.getRatioHandicappedToRegularParking())).add();
        }
        if (totalCarparks == 0) {
            issueContainer.builder().type(Type.CANNOT_CHECK).message("No carparks found, not checking").is((Object)0).shouldBe((Object)"not 0").add();
        }
    }

    private CarparkVote checkGeometry(IfcSpace ifcSpace) {
        CarparkVote carparkVote = new CarparkVote(CheckType.GEOMETRY);
        Area area = IfcTools2D.get2D((IfcProduct)ifcSpace, (double)this.scaleToMm);
        Rectangle2D bounds2d = area.getBounds2D();
        float xDim = (float)bounds2d.getWidth();
        float yDim = (float)bounds2d.getHeight();
        if (xDim > (float)(this.conf.getHandicappedCarparkWidth() - this.conf.getHandicappedCarparkVariation()) && xDim < (float)(this.conf.getHandicappedCarparkWidth() + this.conf.getHandicappedCarparkVariation()) && yDim > (float)(this.conf.getHandicappedCarparkDepth() - this.conf.getHandicappedCarparkVariation()) && yDim < (float)(this.conf.getHandicappedCarparkDepth() + this.conf.getHandicappedCarparkVariation())) {
            carparkVote.setCarparkVoteType(CarparkVoteType.HANDICAPPED_CARPARK);
        } else if (xDim > (float)(this.conf.getHandicappedCarparkDepth() - this.conf.getHandicappedCarparkVariation()) && xDim < (float)(this.conf.getHandicappedCarparkDepth() + this.conf.getHandicappedCarparkVariation()) && yDim > (float)(this.conf.getHandicappedCarparkWidth() - this.conf.getHandicappedCarparkVariation()) && yDim < (float)(this.conf.getHandicappedCarparkWidth() + this.conf.getHandicappedCarparkVariation())) {
            carparkVote.setCarparkVoteType(CarparkVoteType.HANDICAPPED_CARPARK);
        } else if (xDim > (float)(this.conf.getRegularCarparkDepth() - this.conf.getRegularCarparkVariation()) && xDim < (float)(this.conf.getRegularCarparkDepth() + this.conf.getRegularCarparkVariation()) && yDim > (float)(this.conf.getRegularCarparkWidth() - this.conf.getRegularCarparkVariation()) && yDim < (float)(this.conf.getRegularCarparkWidth() + this.conf.getRegularCarparkVariation())) {
            carparkVote.setCarparkVoteType(CarparkVoteType.REGULAR_CARPARK);
        } else if (xDim > (float)(this.conf.getRegularCarparkWidth() - this.conf.getRegularCarparkVariation()) && xDim < (float)(this.conf.getRegularCarparkWidth() + this.conf.getRegularCarparkVariation()) && yDim > (float)(this.conf.getRegularCarparkDepth() - this.conf.getRegularCarparkVariation()) && yDim < (float)(this.conf.getRegularCarparkDepth() + this.conf.getRegularCarparkVariation())) {
            carparkVote.setCarparkVoteType(CarparkVoteType.REGULAR_CARPARK);
        } else {
            carparkVote.setCarparkVoteType(CarparkVoteType.UNIDENTIFIED_CARPARK);
        }
        if (carparkVote.getCarparkVoteType() == null) {
            carparkVote.setCarparkVoteType(CarparkVoteType.UNIDENTIFIED_SPACE);
        }
        return carparkVote;
    }

    public CarparkVote checkPset(IfcSpace ifcSpace) {
        CarparkVote carparkVote = new CarparkVote(CheckType.PSET);
        if (ifcSpace.getObjectType() != null && ifcSpace.getObjectType().equalsIgnoreCase("parking")) {
            Map properties = IfcUtils.listProperties((IfcObject)ifcSpace, (String)"Pset_SpaceParking");
            if (properties.containsKey("HandicapAccessible")) {
                Object object = properties.get("HandicapAccessible");
                if (object == Boolean.TRUE || object == Tristate.TRUE) {
                    carparkVote.setCarparkVoteType(CarparkVoteType.HANDICAPPED_CARPARK);
                } else {
                    carparkVote.setCarparkVoteType(CarparkVoteType.REGULAR_CARPARK);
                }
            } else {
                carparkVote.setCarparkVoteType(CarparkVoteType.REGULAR_CARPARK);
            }
        } else {
            carparkVote.setCarparkVoteType(CarparkVoteType.UNIDENTIFIED_SPACE);
        }
        return carparkVote;
    }

    private class CarparkVote {
        private CarparkVoteType carparkVoteType;
        private CheckType checkType;

        public CarparkVote(CheckType checkType) {
            this.checkType = checkType;
        }

        public void setCarparkVoteType(CarparkVoteType carparkVoteType) {
            this.carparkVoteType = carparkVoteType;
        }

        public CarparkVoteType getCarparkVoteType() {
            return this.carparkVoteType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.carparkVoteType == null ? 0 : this.carparkVoteType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CarparkVote other = (CarparkVote)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.carparkVoteType == other.carparkVoteType;
        }

        private CarparkAccessability getOuterType() {
            return CarparkAccessability.this;
        }

        public String getType() {
            return this.checkType.toString();
        }
    }

    private static enum CheckType {
        GEOMETRY("Geometry"),
        PSET("Pset_SpaceParking");

        private String humanReadable;

        private CheckType(String humanReadable) {
            this.humanReadable = humanReadable;
        }

        public String toString() {
            return this.humanReadable;
        }
    }

    private static enum CarparkVoteType {
        UNIDENTIFIED_SPACE,
        UNIDENTIFIED_CARPARK,
        NOT_A_CARPARK,
        REGULAR_CARPARK,
        HANDICAPPED_CARPARK;

    }
}

