/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcProject;
import org.bimserver.models.ifc2x3tc1.IfcSIPrefix;
import org.bimserver.models.ifc2x3tc1.IfcSIUnit;
import org.bimserver.models.ifc2x3tc1.IfcSIUnitName;
import org.bimserver.models.ifc2x3tc1.IfcUnit;
import org.bimserver.models.ifc2x3tc1.IfcUnitAssignment;
import org.bimserver.models.ifc2x3tc1.IfcUnitEnum;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class CheckAreaUnit
extends ModelCheck {
    public CheckAreaUnit() {
        super("UNITS", "AREA");
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        for (IfcProject ifcProject : model.getAll(IfcProject.class)) {
            IfcUnitAssignment unitsInContext = ifcProject.getUnitsInContext();
            boolean areaUnitFound = false;
            for (IfcUnit ifcUnit : unitsInContext.getUnits()) {
                IfcSIUnit ifcSIUnit;
                if (!(ifcUnit instanceof IfcSIUnit) || (ifcSIUnit = (IfcSIUnit)ifcUnit).getUnitType() != IfcUnitEnum.AREAUNIT) continue;
                areaUnitFound = true;
                boolean metres = ifcSIUnit.getName() == IfcSIUnitName.SQUARE_METRE;
                boolean rightPrefix = ifcSIUnit.getPrefix() == IfcSIPrefix.NULL;
                issueContainer.builder().type(areaUnitFound ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Area unit definition").is((Object)areaUnitFound).shouldBe((Object)"Found").add();
                issueContainer.builder().type(metres ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Area unit").is((Object)metres).shouldBe((Object)"Metres squared").add();
                issueContainer.builder().type(rightPrefix ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Area unit prefix").is((Object)ifcSIUnit.getPrefix()).shouldBe((Object)"None").add();
            }
            if (areaUnitFound) continue;
            issueContainer.builder().type(areaUnitFound ? Type.SUCCESS : Type.ERROR).message("Area unit definition").is((Object)areaUnitFound).shouldBe((Object)"Found").add();
        }
    }
}

