/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcProject;
import org.bimserver.models.ifc2x3tc1.IfcSIPrefix;
import org.bimserver.models.ifc2x3tc1.IfcSIUnit;
import org.bimserver.models.ifc2x3tc1.IfcSIUnitName;
import org.bimserver.models.ifc2x3tc1.IfcUnit;
import org.bimserver.models.ifc2x3tc1.IfcUnitAssignment;
import org.bimserver.models.ifc2x3tc1.IfcUnitEnum;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class CheckLengthUnit
extends ModelCheck {
    public CheckLengthUnit() {
        super("UNITS", "LENGTH");
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        for (IfcProject ifcProject : model.getAll(IfcProject.class)) {
            IfcUnitAssignment unitsInContext = ifcProject.getUnitsInContext();
            boolean lengthUnitFound = false;
            for (IfcUnit ifcUnit : unitsInContext.getUnits()) {
                IfcSIUnit ifcSIUnit;
                if (!(ifcUnit instanceof IfcSIUnit) || (ifcSIUnit = (IfcSIUnit)ifcUnit).getUnitType() != IfcUnitEnum.LENGTHUNIT) continue;
                lengthUnitFound = true;
                boolean metres = ifcSIUnit.getName() == IfcSIUnitName.METRE;
                boolean rightPrefix = ifcSIUnit.getPrefix() == IfcSIPrefix.MILLI || ifcSIUnit.getPrefix() == IfcSIPrefix.NULL;
                issueContainer.builder().type(lengthUnitFound ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Length unit definition").is((Object)lengthUnitFound).shouldBe((Object)"Found").add();
                issueContainer.builder().type(metres ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Length unit").is((Object)lengthUnitFound).shouldBe((Object)"Metres").add();
                issueContainer.builder().type(rightPrefix ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Length unit prefix").is((Object)lengthUnitFound).shouldBe((Object)"None or millis").add();
            }
            if (lengthUnitFound) continue;
            issueContainer.builder().type(lengthUnitFound ? Type.SUCCESS : Type.ERROR).message("Length unit definition").is((Object)lengthUnitFound).shouldBe((Object)"Found").add();
        }
    }
}

