/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcProject;
import org.bimserver.models.ifc2x3tc1.IfcSIPrefix;
import org.bimserver.models.ifc2x3tc1.IfcSIUnit;
import org.bimserver.models.ifc2x3tc1.IfcSIUnitName;
import org.bimserver.models.ifc2x3tc1.IfcUnit;
import org.bimserver.models.ifc2x3tc1.IfcUnitAssignment;
import org.bimserver.models.ifc2x3tc1.IfcUnitEnum;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class CheckVolumeUnit
extends ModelCheck {
    public CheckVolumeUnit() {
        super("UNITS", "VOLUME");
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        for (IfcProject ifcProject : model.getAll(IfcProject.class)) {
            IfcUnitAssignment unitsInContext = ifcProject.getUnitsInContext();
            boolean volumeUnitFound = false;
            for (IfcUnit ifcUnit : unitsInContext.getUnits()) {
                IfcSIUnit ifcSIUnit;
                if (!(ifcUnit instanceof IfcSIUnit) || (ifcSIUnit = (IfcSIUnit)ifcUnit).getUnitType() != IfcUnitEnum.VOLUMEUNIT) continue;
                volumeUnitFound = true;
                boolean metres = ifcSIUnit.getName() == IfcSIUnitName.CUBIC_METRE;
                boolean rightPrefix = ifcSIUnit.getPrefix() == IfcSIPrefix.NULL;
                issueContainer.builder().type(volumeUnitFound ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Volume unit definition").is((Object)volumeUnitFound).shouldBe((Object)"Found").add();
                issueContainer.builder().type(metres ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Volume unit").is((Object)metres).shouldBe((Object)"Cubic metres").add();
                issueContainer.builder().type(rightPrefix ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcSIUnit).message("Volume unit prefix").is((Object)ifcSIUnit.getPrefix()).shouldBe((Object)"None").add();
            }
            if (volumeUnitFound) continue;
            issueContainer.builder().type(volumeUnitFound ? Type.SUCCESS : Type.ERROR).message("Volume unit definition").is((Object)volumeUnitFound).shouldBe((Object)"Found").add();
        }
    }
}

