/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;

public class Cycle<V extends Comparable<V>> {
    private LinkedHashSet<V> vertices;

    public Cycle() {
        this.vertices = new LinkedHashSet();
    }

    public Cycle(LinkedHashSet<V> path) {
        this.vertices = path;
    }

    public Cycle(V ... vs) {
        this.vertices = new LinkedHashSet();
        for (V v : vs) {
            this.add(v);
        }
    }

    public void add(V v) {
        this.vertices.add(v);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vertices == null ? 0 : this.vertices.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cycle other = (Cycle)obj;
        return !(this.vertices == null ? other.vertices != null : !this.vertices.equals(other.vertices));
    }

    public Cycle<V> getCanonical() {
        boolean reverse;
        Comparable max = null;
        for (Comparable v : this.vertices) {
            if (max != null && v.compareTo(max) >= 0) continue;
            max = v;
        }
        Object[] array = this.vertices.toArray();
        int start = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != max) continue;
            start = i;
            break;
        }
        LinkedHashSet<Comparable> result = new LinkedHashSet<Comparable>();
        result.add((Comparable)array[start]);
        boolean bl = reverse = ((Comparable)array[(start + 1) % array.length]).compareTo((Comparable)array[(start + 2) % array.length]) > 0;
        if (reverse) {
            for (int i = start - 1 + array.length; i > start; --i) {
                result.add((Comparable)array[i % array.length]);
            }
        } else {
            for (int i = start + 1; i < start + array.length; ++i) {
                result.add((Comparable)array[i % array.length]);
            }
        }
        return new Cycle(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Comparable v : this.vertices) {
            sb.append(v.toString() + " ");
        }
        return sb.toString();
    }

    public int size() {
        return this.vertices.size();
    }

    public boolean isPartOf(Cycle<V> cycle) {
        for (Comparable v : this.vertices) {
            if (super.contains(v)) continue;
            return false;
        }
        return true;
    }

    private boolean contains(V v) {
        return this.vertices.contains(v);
    }

    public Set<V> asSet() {
        return this.vertices;
    }

    public static <V extends Comparable<V>> Cycle<V> canonical(Stack<V> path) {
        boolean reverse;
        Comparable max = null;
        int index = 0;
        int maxIndex = 0;
        for (Comparable v : path) {
            if (max == null || v.compareTo(max) < 0) {
                max = v;
                maxIndex = index;
            }
            ++index;
        }
        Object[] array = path.toArray();
        LinkedHashSet<Comparable> result = new LinkedHashSet<Comparable>();
        result.add((Comparable)array[maxIndex]);
        boolean bl = reverse = ((Comparable)array[(maxIndex + 1) % array.length]).compareTo((Comparable)array[(maxIndex + 2) % array.length]) > 0;
        if (reverse) {
            for (int i = maxIndex - 1 + array.length; i > maxIndex; --i) {
                result.add((Comparable)array[i % array.length]);
            }
        } else {
            for (int i = maxIndex + 1; i < maxIndex + array.length; ++i) {
                result.add((Comparable)array[i % array.length]);
            }
        }
        return new Cycle(result);
    }
}

