/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.bimserver.ifcvalidator.checks.Cycle;
import org.jgrapht.graph.Pseudograph;

public class CycleFinder<V extends Comparable<V>, E>
implements Runnable {
    private Pseudograph<V, E> graph;
    private V v;
    private Set<Cycle<V>> cycles;

    public CycleFinder(Pseudograph<V, E> graph, V v, Set<Cycle<V>> cycles) {
        this.graph = graph;
        this.v = v;
        this.cycles = cycles;
    }

    @Override
    public void run() {
        this.branchOut(this.v, this.v, null, new HashSet(), new Stack());
    }

    private void branchOut(V start, V current, E previousEdge, Set<V> done, Stack<V> path) {
        path.push(current);
        done.add(current);
        for (Object e : this.graph.edgesOf(current)) {
            if (e == previousEdge) continue;
            V target = this.getOpposed(current, e);
            if (target == start) {
                Cycle<V> canonical = Cycle.canonical(path);
                this.cycles.add(canonical);
                continue;
            }
            if (done.contains(target)) continue;
            this.branchOut(start, target, e, done, path);
        }
        done.remove(current);
        path.pop();
    }

    private V getOpposed(V from, E e) {
        if (this.graph.getEdgeSource(e) == from) {
            return (V)((Comparable)this.graph.getEdgeTarget(e));
        }
        if (this.graph.getEdgeTarget(e) == from) {
            return (V)((Comparable)this.graph.getEdgeSource(e));
        }
        return null;
    }
}

