/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.List;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.ifcvalidator.checks.WindowSpaceRatioConfiguration;
import org.bimserver.models.geometry.GeometryInfo;
import org.bimserver.models.geometry.Vector3f;
import org.bimserver.models.ifc2x3tc1.IfcBuildingStorey;
import org.bimserver.models.ifc2x3tc1.IfcElement;
import org.bimserver.models.ifc2x3tc1.IfcFeatureElementSubtraction;
import org.bimserver.models.ifc2x3tc1.IfcObject;
import org.bimserver.models.ifc2x3tc1.IfcOpeningElement;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcRelFillsElement;
import org.bimserver.models.ifc2x3tc1.IfcRelSpaceBoundary;
import org.bimserver.models.ifc2x3tc1.IfcRelVoidsElement;
import org.bimserver.models.ifc2x3tc1.IfcSpace;
import org.bimserver.models.ifc2x3tc1.IfcWindow;
import org.bimserver.models.ifc2x3tc1.Tristate;
import org.bimserver.utils.IfcTools2D;
import org.bimserver.utils.IfcUtils;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class ExteriorWindowSizeSpaceRatio
extends ModelCheck {
    private WindowSpaceRatioConfiguration conf;

    public ExteriorWindowSizeSpaceRatio(WindowSpaceRatioConfiguration conf) {
        super("GEOMETRY", "RATIOS");
        this.conf = conf;
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        List spaces = model.getAll(IfcSpace.class);
        for (IfcSpace ifcSpace : model.getAll(IfcSpace.class)) {
            if (ifcSpace.getObjectType() != null && ifcSpace.getObjectType().equalsIgnoreCase("parking")) continue;
            IfcBuildingStorey ifcBuildingStorey = IfcUtils.getIfcBuildingStorey((IfcProduct)ifcSpace);
            double totalWindowArea = 0.0;
            int nrWindowsUsed = 0;
            float lengthUnitPrefix = IfcUtils.getLengthUnitPrefix((IfcModelInterface)model);
            Area space2D = IfcTools2D.get2D((IfcProduct)ifcSpace, (double)lengthUnitPrefix);
            AffineTransform aLittleLarger = new AffineTransform();
            double centerX = space2D.getBounds2D().getCenterX();
            double centerY = space2D.getBounds2D().getCenterY();
            aLittleLarger.translate(centerX, centerY);
            aLittleLarger.scale(1.1f, 1.1f);
            aLittleLarger.translate(-centerX, -centerY);
            space2D.transform(aLittleLarger);
            for (IfcRelSpaceBoundary ifcRelSpaceBoundary : ifcSpace.getBoundedBy()) {
                IfcElement relatedBuildingElement = ifcRelSpaceBoundary.getRelatedBuildingElement();
                if (relatedBuildingElement == null) continue;
                boolean wallExternal = IfcUtils.getBooleanProperty((IfcObject)relatedBuildingElement, (String)"IsExternal") == Tristate.TRUE;
                for (IfcRelVoidsElement ifcRelVoidsElement : relatedBuildingElement.getHasOpenings()) {
                    IfcFeatureElementSubtraction relatedOpeningElement = ifcRelVoidsElement.getRelatedOpeningElement();
                    if (!(relatedOpeningElement instanceof IfcOpeningElement)) continue;
                    IfcOpeningElement ifcOpeningElement = (IfcOpeningElement)relatedOpeningElement;
                    for (IfcRelFillsElement ifcRelFillsElement : ifcOpeningElement.getHasFillings()) {
                        boolean windowExternal;
                        IfcWindow ifcWindow;
                        Area window2D;
                        IfcElement relatedBuildingElement2 = ifcRelFillsElement.getRelatedBuildingElement();
                        if (!(relatedBuildingElement2 instanceof IfcWindow) || !IfcTools2D.containsAllPoints((Area)space2D, (Area)(window2D = IfcTools2D.get2D((IfcProduct)(ifcWindow = (IfcWindow)relatedBuildingElement2), (double)lengthUnitPrefix)))) continue;
                        boolean bl = windowExternal = IfcUtils.getBooleanProperty((IfcObject)ifcWindow, (String)"IsExternal") == Tristate.TRUE;
                        if (!windowExternal && !wallExternal) continue;
                        double semanticArea = ifcWindow.getOverallWidth() * ifcWindow.getOverallHeight() * Math.pow(lengthUnitPrefix, 2.0);
                        GeometryInfo windowGeometry = relatedBuildingElement2.getGeometry();
                        if (windowGeometry == null) continue;
                        double geometricArea = this.getBiggestSingleFaceOfUntranslatedBoundingBox(windowGeometry);
                        if (semanticArea - geometricArea > 0.001) {
                            issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcWindow).message("Semantic window area (OverallWidth*OverallHeight) larger than geometric area").is((Object)String.format("%.2f", semanticArea)).shouldBe((Object)String.format("%.2f", geometricArea)).buildingStorey(ifcBuildingStorey).add();
                            continue;
                        }
                        totalWindowArea += semanticArea;
                        ++nrWindowsUsed;
                    }
                }
            }
            if (nrWindowsUsed == 0) {
                issueContainer.builder().type(Type.CANNOT_CHECK).object((IdEObject)ifcSpace).message("Cannot check window/space ratio because no consistent (exterior) windows found in space \"" + ifcSpace.getName() + "\"").buildingStorey(ifcBuildingStorey).add();
                continue;
            }
            if (ifcSpace.getGeometry() == null) continue;
            if (totalWindowArea * (double)this.conf.getRatio() > ifcSpace.getGeometry().getArea()) {
                issueContainer.builder().type(Type.SUCCESS).object((IdEObject)ifcSpace).message("Window/space area ratio for space \"" + ifcSpace.getName() + "\"").is((Object)String.format("%.2f", totalWindowArea * (double)this.conf.getRatio())).shouldBe((Object)(" > " + String.format("%.2f", ifcSpace.getGeometry().getArea()))).buildingStorey(ifcBuildingStorey).add();
                continue;
            }
            issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcSpace).message("Window/space area ratio for space \"" + ifcSpace.getName() + "\"").is((Object)String.format("%.2f", totalWindowArea * (double)this.conf.getRatio())).shouldBe((Object)(" > " + String.format("%.2f", ifcSpace.getGeometry().getArea()))).buildingStorey(ifcBuildingStorey).add();
        }
        if (spaces.isEmpty()) {
            issueContainer.builder().type(Type.CANNOT_CHECK).message("No IfcSpace objects found in model").add();
        }
    }

    private double getBiggestSingleFaceOfUntranslatedBoundingBox(GeometryInfo geometryInfo) {
        double biggestArea;
        double depth;
        Vector3f max = geometryInfo.getMaxBoundsUntranslated();
        Vector3f min = geometryInfo.getMinBoundsUntranslated();
        double width = max.getX() - min.getX();
        double height = max.getY() - min.getY();
        if (height * (depth = max.getZ() - min.getZ()) > (biggestArea = width * height)) {
            biggestArea = height * depth;
        }
        if (depth * width > biggestArea) {
            biggestArea = depth * width;
        }
        return biggestArea;
    }
}

