/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bimserver.ifcvalidator.checks.Cycle;
import org.bimserver.ifcvalidator.checks.CycleFinder;
import org.jgrapht.graph.Pseudograph;

public class FindAllCyclesAlgo<V extends Comparable<V>, E> {
    private Pseudograph<V, E> graph;
    private Set<Cycle<V>> cycles = new HashSet<Cycle<V>>();
    private ThreadPoolExecutor threadPoolExecutor;

    public FindAllCyclesAlgo(Pseudograph<V, E> graph) {
        this.graph = graph;
    }

    public List<Set<V>> findAllCycles() {
        if (this.graph.vertexSet().size() == 0) {
            return new ArrayList<Set<V>>();
        }
        ArrayList<Set<V>> result = new ArrayList<Set<V>>();
        this.threadPoolExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 1L, TimeUnit.HOURS, new ArrayBlockingQueue<Runnable>(this.graph.vertexSet().size()));
        System.out.println("Looking for cycles in " + this.graph.vertexSet().size() + " vertices, " + this.graph.edgeSet().size() + " edges");
        for (Comparable comparable : this.graph.vertexSet()) {
            this.threadPoolExecutor.submit(new CycleFinder<Comparable, E>(this.graph, comparable, this.cycles));
        }
        this.threadPoolExecutor.shutdown();
        try {
            this.threadPoolExecutor.awaitTermination(1L, TimeUnit.HOURS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("Found " + this.cycles.size() + " cycles");
        for (Cycle cycle : this.cycles) {
            result.add(cycle.asSet());
        }
        return result;
    }
}

