/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import com.google.common.base.Joiner;
import java.util.List;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcDirection;
import org.bimserver.models.ifc2x3tc1.IfcGeometricRepresentationContext;
import org.bimserver.models.ifc2x3tc1.IfcProject;
import org.bimserver.models.ifc2x3tc1.IfcRepresentationContext;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;
import org.eclipse.emf.common.util.EList;

public class HasTrueNorthSet
extends ModelCheck {
    public HasTrueNorthSet() {
        super("REPRESENTATION", "HAS_TRUE_NORTH_SET");
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        List projects = model.getAll(IfcProject.class);
        for (IfcProject ifcProject : projects) {
            EList representationContexts = ifcProject.getRepresentationContexts();
            if (representationContexts.isEmpty()) {
                issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcProject).message(checkerContext.translate("IFC_PROJECT_NUMBER_OF_REPRESENTATION_CONTEXTS")).is((Object)"0").shouldBe((Object)"> 0").add();
                continue;
            }
            IfcDirection trueNorth = null;
            IfcGeometricRepresentationContext context = null;
            for (IfcRepresentationContext ifcRepresentationContext : representationContexts) {
                IfcGeometricRepresentationContext ifcGeometricRepresentationContext;
                if (!(ifcRepresentationContext instanceof IfcGeometricRepresentationContext) || (ifcGeometricRepresentationContext = (IfcGeometricRepresentationContext)ifcRepresentationContext).getTrueNorth() == null) continue;
                trueNorth = ifcGeometricRepresentationContext.getTrueNorth();
                context = ifcGeometricRepresentationContext;
            }
            String stringVersion = "null";
            if (trueNorth != null) {
                Joiner joiner = Joiner.on((String)", ").skipNulls();
                stringVersion = joiner.join((Iterable)trueNorth.getDirectionRatios());
            }
            issueContainer.builder().type(trueNorth != null ? Type.SUCCESS : Type.ERROR).object(context).message(checkerContext.translate("TRUE_NORTH_SET")).is((Object)stringVersion).shouldBe((Object)checkerContext.translate("SET")).add();
        }
    }
}

