/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.util.List;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.ValidationException;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcSite;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class IfcSiteKadastaleAanduiding
extends ModelCheck {
    public IfcSiteKadastaleAanduiding() {
        super("SITE", "KADASTRALE_AANDUIDING");
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        List sites = model.getAll(IfcSite.class);
        for (IfcSite ifcSite : sites) {
            try {
                this.checkKadastraleAanduidingen(ifcSite);
                issueContainer.builder().type(Type.SUCCESS).object((IdEObject)ifcSite).message("Kadastrale aanduiding").is((Object)"Valid").shouldBe((Object)"Valid").add();
            }
            catch (ValidationException e) {
                issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcSite).message(e.getMessage()).is((Object)ifcSite.getName()).shouldBe((Object)"Valid").add();
            }
        }
    }

    private void checkKadastraleAanduidingen(IfcSite ifcSite) throws ValidationException {
        String[] split;
        String name = ifcSite.getName();
        if (name == null) {
            throw new ValidationException("No name");
        }
        for (String part : split = name.split("-")) {
            if (part.contains(" ")) {
                String[] spacesSplit = part.split(" ");
                String number = spacesSplit[spacesSplit.length - 1];
                try {
                    Integer.parseInt(number);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new ValidationException("Kadastrale aanduiding - Perceelsnummer not a number");
                }
            }
            throw new ValidationException("Kadastrale aanduiding - No spaces in name");
        }
    }
}

