/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;

public abstract class ModelCheck {
    private String identifier;
    private String groupIdentifier;

    public abstract void check(IfcModelInterface var1, IssueContainer var2, CheckerContext var3) throws IssueException;

    public String getIdentifier() {
        return this.identifier;
    }

    public ModelCheck(String groupIdentifier, String identifier) {
        this.groupIdentifier = groupIdentifier;
        this.identifier = identifier;
    }

    public String getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public String getObjectIdentifier(IfcProduct ifcProduct) {
        if (ifcProduct == null) {
            return "No object";
        }
        String name = ifcProduct.getName();
        if (name != null && !name.trim().equals("")) {
            return name;
        }
        String guid = ifcProduct.getGlobalId();
        if (guid != null && !guid.trim().equals("")) {
            return guid;
        }
        return ifcProduct.eClass().getName() + " " + ifcProduct.getOid();
    }

    public String getDescription(CheckerContext translator) {
        return translator.translate(this.identifier + "_DESCRIPTION");
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public String getName(CheckerContext translator) {
        return translator.translate(this.identifier + "_NAME");
    }
}

