/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.util.List;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcProject;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class OnlyOneIfcProject
extends ModelCheck {
    public OnlyOneIfcProject() {
        super("PROJECT", "ONLY_ONE_IFC_PROJECT");
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        List projects = model.getAll(IfcProject.class);
        IfcProject ifcProject = projects.size() == 1 ? (IfcProject)projects.get(0) : null;
        issueContainer.builder().type(projects.size() == 1 ? Type.SUCCESS : Type.ERROR).object((IdEObject)ifcProject).message(checkerContext.translate("NUMBER_OF_PROJECTS")).is((Object)(projects.size() + " " + checkerContext.translate(projects.size() == 1 ? "PROJECT" : "PROJECTS"))).shouldBe((Object)checkerContext.translate("EXACTLY_ONE_PROJECT")).add();
    }
}

