/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcBuildingStorey;
import org.bimserver.models.ifc2x3tc1.IfcClassificationNotationSelect;
import org.bimserver.models.ifc2x3tc1.IfcClassificationReference;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcSpace;
import org.bimserver.utils.IfcUtils;
import org.bimserver.validationreport.IssueBuilder;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;

public class UnclassifiedSpaces
extends ModelCheck {
    public UnclassifiedSpaces() {
        super("UNCLASSIFIED_SPACES", "UNCLASSIFIED");
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        HashSet<String> availableClasses = new HashSet<String>();
        try {
            Scanner scanner = new Scanner(checkerContext.getResource("omniclass13.txt"));
            Object object = null;
            try {
                while (scanner.hasNext()) {
                    availableClasses.add(scanner.nextLine());
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (scanner != null) {
                    if (object != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        scanner.close();
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        List spaces = model.getAll(IfcSpace.class);
        for (IfcSpace ifcSpace : spaces) {
            boolean valid = false;
            List classifications = IfcUtils.getClassifications((IfcSpace)ifcSpace, (IfcModelInterface)model);
            for (IfcClassificationNotationSelect ifcClassificationNotationSelect : classifications) {
                if (!(ifcClassificationNotationSelect instanceof IfcClassificationReference)) continue;
                IfcClassificationReference ifcClassificationReference = (IfcClassificationReference)ifcClassificationNotationSelect;
                if (!availableClasses.contains(((IfcClassificationReference)ifcClassificationNotationSelect).getItemReference())) continue;
                valid = true;
                IssueBuilder builder = issueContainer.builder().object((IdEObject)ifcSpace).message("IfcSpace classified with valid OmniClass table 13").type(Type.SUCCESS).is((Object)ifcClassificationReference.getItemReference()).shouldBe((Object)"OmniClass Table 13");
                IfcBuildingStorey ifcBuildingStorey = IfcUtils.getIfcBuildingStorey((IfcProduct)ifcSpace);
                if (ifcBuildingStorey != null) {
                    builder.buildingStorey(ifcBuildingStorey);
                }
                builder.add();
            }
            if (valid) continue;
            IssueBuilder builder = issueContainer.builder().object((IdEObject)ifcSpace).message("IfcSpace not classified with valid OmniClass table 13").type(Type.ERROR).shouldBe((Object)"OmniClass Table 13");
            IfcBuildingStorey ifcBuildingStorey = IfcUtils.getIfcBuildingStorey((IfcProduct)ifcSpace);
            if (ifcBuildingStorey != null) {
                builder.buildingStorey(ifcBuildingStorey);
            }
            builder.add();
        }
        if (spaces.isEmpty()) {
            IssueBuilder builder = issueContainer.builder().message("No IfcSpace objects found").type(Type.CANNOT_CHECK);
            builder.add();
        }
    }
}

