/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifcvalidator.checks;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.ifcvalidator.CheckerContext;
import org.bimserver.ifcvalidator.checks.Concurrent;
import org.bimserver.ifcvalidator.checks.FindAllCyclesAlgo;
import org.bimserver.ifcvalidator.checks.IfcBuildingElementWrapper;
import org.bimserver.ifcvalidator.checks.ModelCheck;
import org.bimserver.models.ifc2x3tc1.IfcBuildingElement;
import org.bimserver.models.ifc2x3tc1.IfcBuildingStorey;
import org.bimserver.models.ifc2x3tc1.IfcCurtainWall;
import org.bimserver.models.ifc2x3tc1.IfcElement;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcRelConnectsElements;
import org.bimserver.models.ifc2x3tc1.IfcRelConnectsPathElements;
import org.bimserver.models.ifc2x3tc1.IfcSpace;
import org.bimserver.models.ifc2x3tc1.IfcWall;
import org.bimserver.utils.Display;
import org.bimserver.utils.IfcTools2D;
import org.bimserver.utils.IfcUtils;
import org.bimserver.validationreport.IssueContainer;
import org.bimserver.validationreport.IssueException;
import org.bimserver.validationreport.Type;
import org.jgrapht.EdgeFactory;
import org.jgrapht.graph.ClassBasedEdgeFactory;
import org.jgrapht.graph.Pseudograph;

public class UnidentifiedSpaces
extends ModelCheck {
    private final Map<IfcProduct, Area> generatedAreas = new HashMap<IfcProduct, Area>();
    private float lengthUnitPrefix;

    public UnidentifiedSpaces() {
        super("SPACES", "UNIDENTIFIED");
    }

    private IfcBuildingElementWrapper getOrCreateWrapper(Map<IfcBuildingElement, IfcBuildingElementWrapper> mapping, IfcBuildingElement ifcBuildingElement) {
        IfcBuildingElementWrapper ifcBuildingElementWrapper = mapping.get(ifcBuildingElement);
        if (ifcBuildingElementWrapper == null) {
            ifcBuildingElementWrapper = new IfcBuildingElementWrapper(ifcBuildingElement);
            mapping.put(ifcBuildingElement, ifcBuildingElementWrapper);
        }
        return ifcBuildingElementWrapper;
    }

    private Area getOrCreateArea(IfcProduct ifcProduct, float multiplierMillimeters) {
        Area area = this.generatedAreas.get(ifcProduct);
        if (area == null) {
            area = IfcTools2D.get2D((IfcProduct)ifcProduct, (double)multiplierMillimeters);
            this.generatedAreas.put(ifcProduct, area);
        }
        if (area != null) {
            return new Area(area);
        }
        return null;
    }

    @Override
    public void check(IfcModelInterface model, IssueContainer issueContainer, CheckerContext checkerContext) throws IssueException {
        boolean debug = false;
        boolean removeAllWalls = true;
        this.lengthUnitPrefix = IfcUtils.getLengthUnitPrefix((IfcModelInterface)model);
        System.out.println(model.getAll(IfcRelConnectsPathElements.class).size() + " IfcRelConnectsPathElements found");
        for (IfcBuildingStorey ifcBuildingStorey : model.getAll(IfcBuildingStorey.class)) {
            Area area;
            BufferedImage image = new BufferedImage(2000, 2000, 2);
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            AffineTransform flip = AffineTransform.getScaleInstance(-1.0, 1.0);
            flip.translate(-image.getWidth(), 0.0);
            graphics.transform(flip);
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, 2000, 2000);
            Area totalArea = new Area();
            for (IfcProduct ifcProduct : IfcUtils.getDecomposition((IfcBuildingStorey)ifcBuildingStorey)) {
                Area area2;
                if (!(ifcProduct instanceof IfcSpace) || (area2 = this.getOrCreateArea(ifcProduct, this.lengthUnitPrefix)) == null) continue;
                totalArea.add(area2);
            }
            ClassBasedEdgeFactory factory = new ClassBasedEdgeFactory(IfcRelConnectsPathElements.class);
            Pseudograph graph = new Pseudograph((EdgeFactory)factory);
            HashMap<IfcBuildingElement, IfcBuildingElementWrapper> mapping = new HashMap<IfcBuildingElement, IfcBuildingElementWrapper>();
            for (IfcProduct ifcProduct : IfcUtils.getContains((IfcBuildingStorey)ifcBuildingStorey)) {
                if (!(ifcProduct instanceof IfcWall) && !(ifcProduct instanceof IfcCurtainWall)) continue;
                IfcBuildingElement ifcBuildingElement = (IfcBuildingElement)ifcProduct;
                graph.addVertex((Object)this.getOrCreateWrapper(mapping, ifcBuildingElement));
                Area area3 = this.getOrCreateArea(ifcProduct, this.lengthUnitPrefix);
                if (area3 == null) continue;
                totalArea.add(area3);
            }
            for (IfcProduct ifcProduct : IfcUtils.getContains((IfcBuildingStorey)ifcBuildingStorey)) {
                if (!(ifcProduct instanceof IfcWall) && !(ifcProduct instanceof IfcCurtainWall)) continue;
                IfcElement ifcWall = (IfcElement)ifcProduct;
                for (IfcRelConnectsElements ifcRelConnectsElements : ifcWall.getConnectedFrom()) {
                    if (!(ifcRelConnectsElements instanceof IfcRelConnectsPathElements)) continue;
                    IfcRelConnectsPathElements ifcRelConnectsPathElements = (IfcRelConnectsPathElements)ifcRelConnectsElements;
                    IfcBuildingElementWrapper wall1 = this.getOrCreateWrapper(mapping, (IfcBuildingElement)ifcRelConnectsPathElements.getRelatedElement());
                    IfcBuildingElementWrapper wall2 = this.getOrCreateWrapper(mapping, (IfcBuildingElement)ifcRelConnectsPathElements.getRelatingElement());
                    if (!graph.containsVertex((Object)wall1)) {
                        graph.addVertex((Object)wall1);
                    }
                    if (!graph.containsVertex((Object)wall2)) {
                        graph.addVertex((Object)wall2);
                    }
                    if (graph.addEdge((Object)wall1, (Object)wall2, (Object)ifcRelConnectsPathElements)) continue;
                    System.out.println("Redundant edge not added");
                }
            }
            for (IfcProduct ifcProduct : IfcUtils.getContains((IfcBuildingStorey)ifcBuildingStorey)) {
                IfcBuildingElementWrapper wrapper;
                if (!(ifcProduct instanceof IfcWall) && !(ifcProduct instanceof IfcCurtainWall) || graph.edgesOf((Object)(wrapper = this.getOrCreateWrapper(mapping, (IfcBuildingElement)ifcProduct))).size() != 1) continue;
                graph.removeVertex((Object)wrapper);
            }
            FindAllCyclesAlgo algorighm = new FindAllCyclesAlgo(graph);
            final List findSimpleCycles = algorighm.findAllCycles();
            double scaleX = 1600.0 / totalArea.getBounds().getWidth();
            double scaleY = 1600.0 / totalArea.getBounds().getHeight();
            double scale = Math.min(scaleX, scaleY);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(1000.0, 1000.0);
            affineTransform.scale(scale, scale);
            affineTransform.translate(-totalArea.getBounds2D().getCenterX(), -totalArea.getBounds2D().getCenterY());
            final ArrayList finalList = new ArrayList();
            Concurrent concurrent = new Concurrent(findSimpleCycles.size());
            for (final Set set : findSimpleCycles) {
                concurrent.run(new Runnable(){

                    @Override
                    public void run() {
                        Area cycleArea = new Area();
                        for (IfcBuildingElementWrapper ifcWallOutside : set) {
                            Area areaOutside = UnidentifiedSpaces.this.getOrCreateArea((IfcProduct)ifcWallOutside.get(), UnidentifiedSpaces.this.lengthUnitPrefix);
                            if (areaOutside == null) continue;
                            cycleArea.add(areaOutside);
                        }
                        Area smallest = IfcTools2D.findSmallest((Area)cycleArea);
                        if (smallest != null) {
                            boolean foundCompleteFitting = false;
                            for (Set insideList : findSimpleCycles) {
                                for (IfcBuildingElementWrapper ifcWallInside : insideList) {
                                    Area areaInside = UnidentifiedSpaces.this.getOrCreateArea((IfcProduct)ifcWallInside.get(), UnidentifiedSpaces.this.lengthUnitPrefix);
                                    if (areaInside == null || !IfcTools2D.containsAllPoints((Area)smallest, (Area)areaInside)) continue;
                                    foundCompleteFitting = true;
                                }
                            }
                            if (!foundCompleteFitting) {
                                finalList.add(set);
                            }
                        }
                    }
                });
            }
            concurrent.await();
            System.out.println("Final list: " + finalList.size());
            Area checkArea = new Area();
            for (Set list3 : finalList) {
                Area cycleArea = new Area();
                for (IfcBuildingElementWrapper ifcWall : list3) {
                    Area area4 = this.getOrCreateArea((IfcProduct)ifcWall.get(), this.lengthUnitPrefix);
                    if (area4 == null) continue;
                    cycleArea.add(area4);
                }
                Area innerCurve = this.getInnerCurve(cycleArea);
                if (innerCurve == null) continue;
                checkArea.add(innerCurve);
            }
            for (IfcProduct ifcProduct : IfcUtils.getDecomposition((IfcBuildingStorey)ifcBuildingStorey)) {
                if (!(ifcProduct instanceof IfcSpace) || (area = this.getOrCreateArea(ifcProduct, this.lengthUnitPrefix)) == null) continue;
                checkArea.subtract(area);
            }
            if (removeAllWalls) {
                for (IfcProduct ifcProduct : IfcUtils.getContains((IfcBuildingStorey)ifcBuildingStorey)) {
                    if (!(ifcProduct instanceof IfcWall) && !(ifcProduct instanceof IfcCurtainWall) || (area = this.getOrCreateArea(ifcProduct, this.lengthUnitPrefix)) == null) continue;
                    checkArea.subtract(area);
                }
            }
            graphics.setColor(Color.decode("#919DFF"));
            for (IfcProduct ifcProduct : IfcUtils.getDecomposition((IfcBuildingStorey)ifcBuildingStorey)) {
                if (!(ifcProduct instanceof IfcSpace) || (area = this.getOrCreateArea(ifcProduct, this.lengthUnitPrefix)) == null) continue;
                area.transform(affineTransform);
                graphics.fill(area);
            }
            graphics.setColor(Color.decode("#A4FF9B"));
            for (IfcProduct ifcProduct : IfcUtils.getContains((IfcBuildingStorey)ifcBuildingStorey)) {
                IfcElement ifcWall;
                Area area5;
                if (!(ifcProduct instanceof IfcWall) && !(ifcProduct instanceof IfcCurtainWall) || (area5 = this.getOrCreateArea((IfcProduct)(ifcWall = (IfcElement)ifcProduct), this.lengthUnitPrefix)) == null) continue;
                area5.transform(affineTransform);
                graphics.fill(area5);
            }
            PathIterator pathIterator = checkArea.getPathIterator(null);
            int nrErrors = 0;
            Path2D.Float newPath = new Path2D.Float();
            while (!pathIterator.isDone()) {
                float[] coords = new float[6];
                int currentSegment = pathIterator.currentSegment(coords);
                if (currentSegment == 4) {
                    newPath.closePath();
                    float area6 = Math.abs(IfcTools2D.getArea((Area)new Area(newPath)));
                    if ((double)area6 > 0.001) {
                        BufferedImage errorImage = this.renderImage(ifcBuildingStorey, totalArea, newPath);
                        issueContainer.builder().type(Type.ERROR).object((IdEObject)ifcBuildingStorey).message("Missing IfcSpace of " + String.format("%.2f", Float.valueOf(area6)) + " m2 on \"" + ifcBuildingStorey.getName() + "\"").image(errorImage).add();
                        ++nrErrors;
                    }
                    newPath = new Path2D.Float();
                } else if (currentSegment == 1) {
                    newPath.lineTo(coords[0], coords[1]);
                } else if (currentSegment == 0) {
                    newPath.moveTo(coords[0], coords[1]);
                } else {
                    System.out.println("Unimplemented segment" + currentSegment);
                }
                pathIterator.next();
            }
            if (nrErrors == 0) {
                BufferedImage errorImage = this.renderImage(ifcBuildingStorey, totalArea, null);
                issueContainer.builder().type(Type.SUCCESS).object((IdEObject)ifcBuildingStorey).buildingStorey(ifcBuildingStorey).message("No unidentified spaces found in building storey \"" + ifcBuildingStorey.getName() + "\"").image(errorImage).add();
            }
            graphics.setColor(Color.RED);
            checkArea.transform(affineTransform);
            graphics.fill(checkArea);
            if (!debug) continue;
            Display display = new Display(ifcBuildingStorey.getName(), 2000, 2000);
            display.setImage(image);
        }
    }

    private void writeToJson(IfcBuildingStorey ifcBuildingStorey, Pseudograph<IfcBuildingElementWrapper, IfcRelConnectsPathElements> graph) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode graphJson = objectMapper.createObjectNode();
        ArrayNode vertices = objectMapper.createArrayNode();
        ArrayNode edges = objectMapper.createArrayNode();
        graphJson.set("vertices", (JsonNode)vertices);
        graphJson.set("edges", (JsonNode)edges);
        for (IfcBuildingElementWrapper ifcBuildingElementWrapper : graph.vertexSet()) {
            vertices.add(ifcBuildingElementWrapper.get().getOid());
        }
        for (IfcRelConnectsPathElements ifcRelConnectsPathElements : graph.edgeSet()) {
            ObjectNode edgeJson = objectMapper.createObjectNode();
            edgeJson.put("id", ifcRelConnectsPathElements.getOid());
            edgeJson.put("from", ifcRelConnectsPathElements.getRelatedElement().getOid());
            edgeJson.put("to", ifcRelConnectsPathElements.getRelatingElement().getOid());
            edges.add((JsonNode)edgeJson);
        }
        try {
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(new File(ifcBuildingStorey.getName() + ".graph.json"), (Object)graphJson);
        }
        catch (JsonGenerationException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private BufferedImage renderImage(IfcBuildingStorey ifcBuildingStorey, Area totalArea, Path2D.Float newPath) {
        BufferedImage bufferedImage = new BufferedImage(800, 600, 2);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        int width = 800;
        int height = 600;
        AffineTransform flip = AffineTransform.getScaleInstance(-1.0, 1.0);
        flip.translate(-width, 0.0);
        graphics.transform(flip);
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, width, height);
        double scaleX = (double)width * 0.9 / totalArea.getBounds().getWidth();
        double scaleY = (double)height * 0.9 / totalArea.getBounds().getHeight();
        double scale = Math.min(scaleX, scaleY);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate((float)width / 2.0f, (float)height / 2.0f);
        affineTransform.scale(scale, scale);
        affineTransform.translate(-totalArea.getBounds2D().getCenterX(), -totalArea.getBounds2D().getCenterY());
        graphics.setColor(Color.decode("#919DFF"));
        for (IfcProduct ifcProduct : IfcUtils.getDecomposition((IfcBuildingStorey)ifcBuildingStorey)) {
            Area area;
            if (!(ifcProduct instanceof IfcSpace) || (area = this.getOrCreateArea(ifcProduct, this.lengthUnitPrefix)) == null) continue;
            area.transform(affineTransform);
            graphics.fill(area);
        }
        graphics.setColor(Color.decode("#A4FF9B"));
        for (IfcProduct ifcProduct : IfcUtils.getContains((IfcBuildingStorey)ifcBuildingStorey)) {
            IfcElement ifcWall;
            Area area;
            if (!(ifcProduct instanceof IfcWall) && !(ifcProduct instanceof IfcCurtainWall) || (area = this.getOrCreateArea((IfcProduct)(ifcWall = (IfcElement)ifcProduct), this.lengthUnitPrefix)) == null) continue;
            area.transform(affineTransform);
            graphics.fill(area);
        }
        if (newPath != null) {
            graphics.setColor(Color.RED);
            Area newArea = new Area(newPath);
            newArea.transform(affineTransform);
            graphics.fill(newArea);
        }
        return bufferedImage;
    }

    private Area getInnerCurve(Area area) {
        PathIterator pathIterator = area.getPathIterator(null);
        if (area.isSingular()) {
            System.out.println("Is singular");
        } else {
            Path2D.Float tmp = new Path2D.Float();
            Path2D.Float smallest = new Path2D.Float();
            Rectangle smallestRectangle = null;
            while (!pathIterator.isDone()) {
                double[] coords = new double[6];
                int type = pathIterator.currentSegment(coords);
                if (type == 0) {
                    tmp.moveTo(coords[0], coords[1]);
                } else if (type == 4) {
                    tmp.closePath();
                    if (smallestRectangle == null || smallestRectangle.contains(tmp.getBounds())) {
                        smallestRectangle = tmp.getBounds();
                        smallest = tmp;
                    }
                    tmp = new Path2D.Float();
                } else if (type == 1) {
                    tmp.lineTo(coords[0], coords[1]);
                }
                pathIterator.next();
            }
            if (smallest != null) {
                Area smallestArea = new Area(smallest);
                return smallestArea;
            }
        }
        return null;
    }

    private Area getOuterCurve(Area area) {
        PathIterator pathIterator = area.getPathIterator(null);
        if (area.isSingular()) {
            System.out.println("Is singular");
        } else {
            Path2D.Float tmp = new Path2D.Float();
            Path2D.Float largest = new Path2D.Float();
            Rectangle largestRectangle = null;
            while (!pathIterator.isDone()) {
                double[] coords = new double[6];
                int type = pathIterator.currentSegment(coords);
                if (type == 0) {
                    tmp.moveTo(coords[0], coords[1]);
                } else if (type == 4) {
                    tmp.closePath();
                    if (largestRectangle == null || tmp.getBounds().contains(largestRectangle)) {
                        largestRectangle = tmp.getBounds();
                        largest = tmp;
                    }
                    tmp = new Path2D.Float();
                } else if (type == 1) {
                    tmp.lineTo(coords[0], coords[1]);
                }
                pathIterator.next();
            }
            if (largest != null) {
                return new Area(largest);
            }
        }
        return null;
    }
}

