/**
 * Copyright (C) 2009-2014 BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.bimserver.models.ifc2x3tc1;

/******************************************************************************
 * Copyright (C) 2009-2018  BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see {@literal<http://www.gnu.org/licenses/>}.
 *****************************************************************************/

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Factory
 * @model kind="package"
 * @generated
 */
public interface Ifc2x3tc1Package extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "ifc2x3tc1";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://buildingsmart.ifc2x3tc1.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "iai";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	Ifc2x3tc1Package eINSTANCE = org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl.init();

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcLayeredItem <em>Ifc Layered Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcLayeredItem
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcLayeredItem()
	 * @generated
	 */
	int IFC_LAYERED_ITEM = 793;

	/**
	 * The number of structural features of the '<em>Ifc Layered Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_LAYERED_ITEM_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcRepresentationItemImpl <em>Ifc Representation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcRepresentationItemImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcRepresentationItem()
	 * @generated
	 */
	int IFC_REPRESENTATION_ITEM = 489;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS = IFC_LAYERED_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_REPRESENTATION_ITEM__STYLED_BY_ITEM = IFC_LAYERED_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Representation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_REPRESENTATION_ITEM_FEATURE_COUNT = IFC_LAYERED_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcGeometricRepresentationItemImpl <em>Ifc Geometric Representation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcGeometricRepresentationItemImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcGeometricRepresentationItem()
	 * @generated
	 */
	int IFC_GEOMETRIC_REPRESENTATION_ITEM = 267;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS = IFC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM = IFC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Geometric Representation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT = IFC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurveImpl <em>Ifc Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurveImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurve()
	 * @generated
	 */
	int IFC_CURVE = 134;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoundedCurveImpl <em>Ifc Bounded Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoundedCurveImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoundedCurve()
	 * @generated
	 */
	int IFC_BOUNDED_CURVE = 49;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_CURVE__LAYER_ASSIGNMENTS = IFC_CURVE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_CURVE__STYLED_BY_ITEM = IFC_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_CURVE__DIM = IFC_CURVE__DIM;

	/**
	 * The number of structural features of the '<em>Ifc Bounded Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_CURVE_FEATURE_COUNT = IFC_CURVE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCompositeCurveImpl <em>Ifc Composite Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCompositeCurveImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCompositeCurve()
	 * @generated
	 */
	int IFC_COMPOSITE_CURVE = 91;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__LAYER_ASSIGNMENTS = IFC_BOUNDED_CURVE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__STYLED_BY_ITEM = IFC_BOUNDED_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__DIM = IFC_BOUNDED_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__SEGMENTS = IFC_BOUNDED_CURVE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__SELF_INTERSECT = IFC_BOUNDED_CURVE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Composite Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_FEATURE_COUNT = IFC_BOUNDED_CURVE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.Ifc2DCompositeCurveImpl <em>Ifc2 DComposite Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2DCompositeCurveImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfc2DCompositeCurve()
	 * @generated
	 */
	int IFC2_DCOMPOSITE_CURVE = 0;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC2_DCOMPOSITE_CURVE__LAYER_ASSIGNMENTS = IFC_COMPOSITE_CURVE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC2_DCOMPOSITE_CURVE__STYLED_BY_ITEM = IFC_COMPOSITE_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC2_DCOMPOSITE_CURVE__DIM = IFC_COMPOSITE_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC2_DCOMPOSITE_CURVE__SEGMENTS = IFC_COMPOSITE_CURVE__SEGMENTS;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC2_DCOMPOSITE_CURVE__SELF_INTERSECT = IFC_COMPOSITE_CURVE__SELF_INTERSECT;

	/**
	 * The number of structural features of the '<em>Ifc2 DComposite Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC2_DCOMPOSITE_CURVE_FEATURE_COUNT = IFC_COMPOSITE_CURVE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcRootImpl <em>Ifc Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcRootImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcRoot()
	 * @generated
	 */
	int IFC_ROOT = 497;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT__GLOBAL_ID = 0;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT__OWNER_HISTORY = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT__NAME = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT__DESCRIPTION = 3;

	/**
	 * The number of structural features of the '<em>Ifc Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcObjectDefinitionImpl <em>Ifc Object Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcObjectDefinitionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcObjectDefinition()
	 * @generated
	 */
	int IFC_OBJECT_DEFINITION = 327;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__GLOBAL_ID = IFC_ROOT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__OWNER_HISTORY = IFC_ROOT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__NAME = IFC_ROOT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__DESCRIPTION = IFC_ROOT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__HAS_ASSIGNMENTS = IFC_ROOT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__IS_DECOMPOSED_BY = IFC_ROOT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__DECOMPOSES = IFC_ROOT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__HAS_ASSOCIATIONS = IFC_ROOT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Object Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION_FEATURE_COUNT = IFC_ROOT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcObjectImpl <em>Ifc Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcObjectImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcObject()
	 * @generated
	 */
	int IFC_OBJECT = 326;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__GLOBAL_ID = IFC_OBJECT_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__OWNER_HISTORY = IFC_OBJECT_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__NAME = IFC_OBJECT_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__DESCRIPTION = IFC_OBJECT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__HAS_ASSIGNMENTS = IFC_OBJECT_DEFINITION__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__IS_DECOMPOSED_BY = IFC_OBJECT_DEFINITION__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__DECOMPOSES = IFC_OBJECT_DEFINITION__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__HAS_ASSOCIATIONS = IFC_OBJECT_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__OBJECT_TYPE = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__IS_DEFINED_BY = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_FEATURE_COUNT = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcControlImpl <em>Ifc Control</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcControlImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcControl()
	 * @generated
	 */
	int IFC_CONTROL = 115;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__CONTROLS = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Control</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcActionRequestImpl <em>Ifc Action Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcActionRequestImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcActionRequest()
	 * @generated
	 */
	int IFC_ACTION_REQUEST = 1;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__GLOBAL_ID = IFC_CONTROL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__OWNER_HISTORY = IFC_CONTROL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__NAME = IFC_CONTROL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__DESCRIPTION = IFC_CONTROL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__HAS_ASSIGNMENTS = IFC_CONTROL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__IS_DECOMPOSED_BY = IFC_CONTROL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__DECOMPOSES = IFC_CONTROL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__HAS_ASSOCIATIONS = IFC_CONTROL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__OBJECT_TYPE = IFC_CONTROL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__IS_DEFINED_BY = IFC_CONTROL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__CONTROLS = IFC_CONTROL__CONTROLS;

	/**
	 * The feature id for the '<em><b>Request ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__REQUEST_ID = IFC_CONTROL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Action Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST_FEATURE_COUNT = IFC_CONTROL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcActorImpl <em>Ifc Actor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcActorImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcActor()
	 * @generated
	 */
	int IFC_ACTOR = 2;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>The Actor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__THE_ACTOR = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Acting Upon</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_ACTING_UPON = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Actor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcActorRoleImpl <em>Ifc Actor Role</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcActorRoleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcActorRole()
	 * @generated
	 */
	int IFC_ACTOR_ROLE = 3;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE__ROLE = 0;

	/**
	 * The feature id for the '<em><b>User Defined Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE__USER_DEFINED_ROLE = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE__DESCRIPTION = 2;

	/**
	 * The number of structural features of the '<em>Ifc Actor Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcTypeObjectImpl <em>Ifc Type Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcTypeObjectImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcTypeObject()
	 * @generated
	 */
	int IFC_TYPE_OBJECT = 625;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__GLOBAL_ID = IFC_OBJECT_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__OWNER_HISTORY = IFC_OBJECT_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__NAME = IFC_OBJECT_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__DESCRIPTION = IFC_OBJECT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__HAS_ASSIGNMENTS = IFC_OBJECT_DEFINITION__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__IS_DECOMPOSED_BY = IFC_OBJECT_DEFINITION__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__DECOMPOSES = IFC_OBJECT_DEFINITION__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__HAS_ASSOCIATIONS = IFC_OBJECT_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__APPLICABLE_OCCURRENCE = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__HAS_PROPERTY_SETS = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__OBJECT_TYPE_OF = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Type Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT_FEATURE_COUNT = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcTypeProductImpl <em>Ifc Type Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcTypeProductImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcTypeProduct()
	 * @generated
	 */
	int IFC_TYPE_PRODUCT = 626;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__GLOBAL_ID = IFC_TYPE_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__OWNER_HISTORY = IFC_TYPE_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__NAME = IFC_TYPE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__DESCRIPTION = IFC_TYPE_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__HAS_ASSIGNMENTS = IFC_TYPE_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__IS_DECOMPOSED_BY = IFC_TYPE_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__DECOMPOSES = IFC_TYPE_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__HAS_ASSOCIATIONS = IFC_TYPE_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__APPLICABLE_OCCURRENCE = IFC_TYPE_OBJECT__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__HAS_PROPERTY_SETS = IFC_TYPE_OBJECT__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__OBJECT_TYPE_OF = IFC_TYPE_OBJECT__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__REPRESENTATION_MAPS = IFC_TYPE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__TAG = IFC_TYPE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Type Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT_FEATURE_COUNT = IFC_TYPE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElementTypeImpl <em>Ifc Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElementTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElementType()
	 * @generated
	 */
	int IFC_ELEMENT_TYPE = 200;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__GLOBAL_ID = IFC_TYPE_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__OWNER_HISTORY = IFC_TYPE_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__NAME = IFC_TYPE_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__DESCRIPTION = IFC_TYPE_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_TYPE_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_TYPE_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__DECOMPOSES = IFC_TYPE_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_TYPE_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_TYPE_PRODUCT__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_TYPE_PRODUCT__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__OBJECT_TYPE_OF = IFC_TYPE_PRODUCT__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_TYPE_PRODUCT__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__TAG = IFC_TYPE_PRODUCT__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__ELEMENT_TYPE = IFC_TYPE_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE_FEATURE_COUNT = IFC_TYPE_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionElementTypeImpl <em>Ifc Distribution Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionElementTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionElementType()
	 * @generated
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE = 161;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__GLOBAL_ID = IFC_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__OWNER_HISTORY = IFC_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__NAME = IFC_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__DESCRIPTION = IFC_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__DECOMPOSES = IFC_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__OBJECT_TYPE_OF = IFC_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__TAG = IFC_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__ELEMENT_TYPE = IFC_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE_FEATURE_COUNT = IFC_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionControlElementTypeImpl <em>Ifc Distribution Control Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionControlElementTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionControlElementType()
	 * @generated
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE = 159;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME = IFC_DISTRIBUTION_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION = IFC_DISTRIBUTION_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES = IFC_DISTRIBUTION_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG = IFC_DISTRIBUTION_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Control Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcActuatorTypeImpl <em>Ifc Actuator Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcActuatorTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcActuatorType()
	 * @generated
	 */
	int IFC_ACTUATOR_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Actuator Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcObjectReferenceSelect <em>Ifc Object Reference Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcObjectReferenceSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcObjectReferenceSelect()
	 * @generated
	 */
	int IFC_OBJECT_REFERENCE_SELECT = 799;

	/**
	 * The number of structural features of the '<em>Ifc Object Reference Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAddressImpl <em>Ifc Address</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAddressImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAddress()
	 * @generated
	 */
	int IFC_ADDRESS = 5;

	/**
	 * The feature id for the '<em><b>Purpose</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__PURPOSE = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__DESCRIPTION = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>User Defined Purpose</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__USER_DEFINED_PURPOSE = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Of Person</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__OF_PERSON = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Of Organization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__OF_ORGANIZATION = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Address</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS_FEATURE_COUNT = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionFlowElementTypeImpl <em>Ifc Distribution Flow Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionFlowElementTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionFlowElementType()
	 * @generated
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE = 163;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME = IFC_DISTRIBUTION_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION = IFC_DISTRIBUTION_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES = IFC_DISTRIBUTION_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG = IFC_DISTRIBUTION_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Flow Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowControllerTypeImpl <em>Ifc Flow Controller Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowControllerTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowControllerType()
	 * @generated
	 */
	int IFC_FLOW_CONTROLLER_TYPE = 240;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Controller Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAirTerminalBoxTypeImpl <em>Ifc Air Terminal Box Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAirTerminalBoxTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAirTerminalBoxType()
	 * @generated
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE = 6;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__GLOBAL_ID = IFC_FLOW_CONTROLLER_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__OWNER_HISTORY = IFC_FLOW_CONTROLLER_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__NAME = IFC_FLOW_CONTROLLER_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__DESCRIPTION = IFC_FLOW_CONTROLLER_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_CONTROLLER_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__DECOMPOSES = IFC_FLOW_CONTROLLER_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_CONTROLLER_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__OBJECT_TYPE_OF = IFC_FLOW_CONTROLLER_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__REPRESENTATION_MAPS = IFC_FLOW_CONTROLLER_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__TAG = IFC_FLOW_CONTROLLER_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__ELEMENT_TYPE = IFC_FLOW_CONTROLLER_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__PREDEFINED_TYPE = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air Terminal Box Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE_FEATURE_COUNT = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowTerminalTypeImpl <em>Ifc Flow Terminal Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowTerminalTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowTerminalType()
	 * @generated
	 */
	int IFC_FLOW_TERMINAL_TYPE = 252;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Terminal Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAirTerminalTypeImpl <em>Ifc Air Terminal Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAirTerminalTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAirTerminalType()
	 * @generated
	 */
	int IFC_AIR_TERMINAL_TYPE = 7;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__GLOBAL_ID = IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__OWNER_HISTORY = IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__NAME = IFC_FLOW_TERMINAL_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__DESCRIPTION = IFC_FLOW_TERMINAL_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__DECOMPOSES = IFC_FLOW_TERMINAL_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__OBJECT_TYPE_OF = IFC_FLOW_TERMINAL_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__TAG = IFC_FLOW_TERMINAL_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__ELEMENT_TYPE = IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air Terminal Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE_FEATURE_COUNT = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEnergyConversionDeviceTypeImpl <em>Ifc Energy Conversion Device Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEnergyConversionDeviceTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEnergyConversionDeviceType()
	 * @generated
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE = 205;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Energy Conversion Device Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAirToAirHeatRecoveryTypeImpl <em>Ifc Air To Air Heat Recovery Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAirToAirHeatRecoveryTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAirToAirHeatRecoveryType()
	 * @generated
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE = 8;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air To Air Heat Recovery Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAlarmTypeImpl <em>Ifc Alarm Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAlarmTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAlarmType()
	 * @generated
	 */
	int IFC_ALARM_TYPE = 9;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Alarm Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingCalloutImpl <em>Ifc Draughting Callout</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingCalloutImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDraughtingCallout()
	 * @generated
	 */
	int IFC_DRAUGHTING_CALLOUT = 173;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Contents</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT__CONTENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Related From Callout</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT__IS_RELATED_FROM_CALLOUT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Related To Callout</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT__IS_RELATED_TO_CALLOUT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Draughting Callout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDimensionCurveDirectedCalloutImpl <em>Ifc Dimension Curve Directed Callout</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDimensionCurveDirectedCalloutImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDimensionCurveDirectedCallout()
	 * @generated
	 */
	int IFC_DIMENSION_CURVE_DIRECTED_CALLOUT = 149;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__LAYER_ASSIGNMENTS = IFC_DRAUGHTING_CALLOUT__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__STYLED_BY_ITEM = IFC_DRAUGHTING_CALLOUT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Contents</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__CONTENTS = IFC_DRAUGHTING_CALLOUT__CONTENTS;

	/**
	 * The feature id for the '<em><b>Is Related From Callout</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__IS_RELATED_FROM_CALLOUT = IFC_DRAUGHTING_CALLOUT__IS_RELATED_FROM_CALLOUT;

	/**
	 * The feature id for the '<em><b>Is Related To Callout</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__IS_RELATED_TO_CALLOUT = IFC_DRAUGHTING_CALLOUT__IS_RELATED_TO_CALLOUT;

	/**
	 * The number of structural features of the '<em>Ifc Dimension Curve Directed Callout</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_DIRECTED_CALLOUT_FEATURE_COUNT = IFC_DRAUGHTING_CALLOUT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAngularDimensionImpl <em>Ifc Angular Dimension</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAngularDimensionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAngularDimension()
	 * @generated
	 */
	int IFC_ANGULAR_DIMENSION = 10;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANGULAR_DIMENSION__LAYER_ASSIGNMENTS = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANGULAR_DIMENSION__STYLED_BY_ITEM = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Contents</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANGULAR_DIMENSION__CONTENTS = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__CONTENTS;

	/**
	 * The feature id for the '<em><b>Is Related From Callout</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANGULAR_DIMENSION__IS_RELATED_FROM_CALLOUT = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__IS_RELATED_FROM_CALLOUT;

	/**
	 * The feature id for the '<em><b>Is Related To Callout</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANGULAR_DIMENSION__IS_RELATED_TO_CALLOUT = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__IS_RELATED_TO_CALLOUT;

	/**
	 * The number of structural features of the '<em>Ifc Angular Dimension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANGULAR_DIMENSION_FEATURE_COUNT = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcProductImpl <em>Ifc Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcProductImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcProduct()
	 * @generated
	 */
	int IFC_PRODUCT = 385;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__OBJECT_PLACEMENT = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__REPRESENTATION = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__REFERENCED_BY = IFC_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__GEOMETRY = IFC_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationImpl <em>Ifc Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotation()
	 * @generated
	 */
	int IFC_ANNOTATION = 11;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__GLOBAL_ID = IFC_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__OWNER_HISTORY = IFC_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__NAME = IFC_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__DESCRIPTION = IFC_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__HAS_ASSIGNMENTS = IFC_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__IS_DECOMPOSED_BY = IFC_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__DECOMPOSES = IFC_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__HAS_ASSOCIATIONS = IFC_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__OBJECT_TYPE = IFC_PRODUCT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__IS_DEFINED_BY = IFC_PRODUCT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__OBJECT_PLACEMENT = IFC_PRODUCT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__REPRESENTATION = IFC_PRODUCT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__REFERENCED_BY = IFC_PRODUCT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__GEOMETRY = IFC_PRODUCT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__CONTAINED_IN_STRUCTURE = IFC_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FEATURE_COUNT = IFC_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcStyledItemImpl <em>Ifc Styled Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcStyledItemImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcStyledItem()
	 * @generated
	 */
	int IFC_STYLED_ITEM = 569;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_STYLED_ITEM__LAYER_ASSIGNMENTS = IFC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_STYLED_ITEM__STYLED_BY_ITEM = IFC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_STYLED_ITEM__ITEM = IFC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_STYLED_ITEM__STYLES = IFC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_STYLED_ITEM__NAME = IFC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Styled Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_STYLED_ITEM_FEATURE_COUNT = IFC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationOccurrenceImpl <em>Ifc Annotation Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationOccurrenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotationOccurrence()
	 * @generated
	 */
	int IFC_ANNOTATION_OCCURRENCE = 15;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_OCCURRENCE__LAYER_ASSIGNMENTS = IFC_STYLED_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_OCCURRENCE__STYLED_BY_ITEM = IFC_STYLED_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_OCCURRENCE__ITEM = IFC_STYLED_ITEM__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_OCCURRENCE__STYLES = IFC_STYLED_ITEM__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_OCCURRENCE__NAME = IFC_STYLED_ITEM__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_OCCURRENCE_FEATURE_COUNT = IFC_STYLED_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationCurveOccurrenceImpl <em>Ifc Annotation Curve Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationCurveOccurrenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotationCurveOccurrence()
	 * @generated
	 */
	int IFC_ANNOTATION_CURVE_OCCURRENCE = 12;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_CURVE_OCCURRENCE__LAYER_ASSIGNMENTS = IFC_ANNOTATION_OCCURRENCE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_CURVE_OCCURRENCE__STYLED_BY_ITEM = IFC_ANNOTATION_OCCURRENCE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_CURVE_OCCURRENCE__ITEM = IFC_ANNOTATION_OCCURRENCE__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_CURVE_OCCURRENCE__STYLES = IFC_ANNOTATION_OCCURRENCE__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_CURVE_OCCURRENCE__NAME = IFC_ANNOTATION_OCCURRENCE__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Curve Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_CURVE_OCCURRENCE_FEATURE_COUNT = IFC_ANNOTATION_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationFillAreaImpl <em>Ifc Annotation Fill Area</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationFillAreaImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotationFillArea()
	 * @generated
	 */
	int IFC_ANNOTATION_FILL_AREA = 13;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Outer Boundary</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA__OUTER_BOUNDARY = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Inner Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA__INNER_BOUNDARIES = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Fill Area</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationFillAreaOccurrenceImpl <em>Ifc Annotation Fill Area Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationFillAreaOccurrenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotationFillAreaOccurrence()
	 * @generated
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE = 14;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE__LAYER_ASSIGNMENTS = IFC_ANNOTATION_OCCURRENCE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE__STYLED_BY_ITEM = IFC_ANNOTATION_OCCURRENCE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE__ITEM = IFC_ANNOTATION_OCCURRENCE__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE__STYLES = IFC_ANNOTATION_OCCURRENCE__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE__NAME = IFC_ANNOTATION_OCCURRENCE__NAME;

	/**
	 * The feature id for the '<em><b>Fill Style Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE__FILL_STYLE_TARGET = IFC_ANNOTATION_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Global Or Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE__GLOBAL_OR_LOCAL = IFC_ANNOTATION_OCCURRENCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Fill Area Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_OCCURRENCE_FEATURE_COUNT = IFC_ANNOTATION_OCCURRENCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationSurfaceImpl <em>Ifc Annotation Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationSurfaceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotationSurface()
	 * @generated
	 */
	int IFC_ANNOTATION_SURFACE = 16;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE__ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Texture Coordinates</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE__TEXTURE_COORDINATES = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationSurfaceOccurrenceImpl <em>Ifc Annotation Surface Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationSurfaceOccurrenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotationSurfaceOccurrence()
	 * @generated
	 */
	int IFC_ANNOTATION_SURFACE_OCCURRENCE = 17;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE_OCCURRENCE__LAYER_ASSIGNMENTS = IFC_ANNOTATION_OCCURRENCE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE_OCCURRENCE__STYLED_BY_ITEM = IFC_ANNOTATION_OCCURRENCE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE_OCCURRENCE__ITEM = IFC_ANNOTATION_OCCURRENCE__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE_OCCURRENCE__STYLES = IFC_ANNOTATION_OCCURRENCE__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE_OCCURRENCE__NAME = IFC_ANNOTATION_OCCURRENCE__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Surface Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SURFACE_OCCURRENCE_FEATURE_COUNT = IFC_ANNOTATION_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationSymbolOccurrenceImpl <em>Ifc Annotation Symbol Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationSymbolOccurrenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotationSymbolOccurrence()
	 * @generated
	 */
	int IFC_ANNOTATION_SYMBOL_OCCURRENCE = 18;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SYMBOL_OCCURRENCE__LAYER_ASSIGNMENTS = IFC_ANNOTATION_OCCURRENCE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SYMBOL_OCCURRENCE__STYLED_BY_ITEM = IFC_ANNOTATION_OCCURRENCE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SYMBOL_OCCURRENCE__ITEM = IFC_ANNOTATION_OCCURRENCE__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SYMBOL_OCCURRENCE__STYLES = IFC_ANNOTATION_OCCURRENCE__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SYMBOL_OCCURRENCE__NAME = IFC_ANNOTATION_OCCURRENCE__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Symbol Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_SYMBOL_OCCURRENCE_FEATURE_COUNT = IFC_ANNOTATION_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationTextOccurrenceImpl <em>Ifc Annotation Text Occurrence</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAnnotationTextOccurrenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAnnotationTextOccurrence()
	 * @generated
	 */
	int IFC_ANNOTATION_TEXT_OCCURRENCE = 19;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_TEXT_OCCURRENCE__LAYER_ASSIGNMENTS = IFC_ANNOTATION_OCCURRENCE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_TEXT_OCCURRENCE__STYLED_BY_ITEM = IFC_ANNOTATION_OCCURRENCE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_TEXT_OCCURRENCE__ITEM = IFC_ANNOTATION_OCCURRENCE__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_TEXT_OCCURRENCE__STYLES = IFC_ANNOTATION_OCCURRENCE__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_TEXT_OCCURRENCE__NAME = IFC_ANNOTATION_OCCURRENCE__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Text Occurrence</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_TEXT_OCCURRENCE_FEATURE_COUNT = IFC_ANNOTATION_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcApplicationImpl <em>Ifc Application</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcApplicationImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcApplication()
	 * @generated
	 */
	int IFC_APPLICATION = 20;

	/**
	 * The feature id for the '<em><b>Application Developer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION__APPLICATION_DEVELOPER = 0;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION__VERSION = 1;

	/**
	 * The feature id for the '<em><b>Application Full Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION__APPLICATION_FULL_NAME = 2;

	/**
	 * The feature id for the '<em><b>Application Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION__APPLICATION_IDENTIFIER = 3;

	/**
	 * The number of structural features of the '<em>Ifc Application</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAppliedValueImpl <em>Ifc Applied Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAppliedValueImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAppliedValue()
	 * @generated
	 */
	int IFC_APPLIED_VALUE = 21;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__NAME = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__DESCRIPTION = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Applied Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__APPLIED_VALUE = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Unit Basis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__UNIT_BASIS = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Applicable Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__APPLICABLE_DATE = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Fixed Until Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__FIXED_UNTIL_DATE = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Values Referenced</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__VALUES_REFERENCED = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Value Of Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__VALUE_OF_COMPONENTS = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Is Component In</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__IS_COMPONENT_IN = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Ifc Applied Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE_FEATURE_COUNT = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAppliedValueRelationshipImpl <em>Ifc Applied Value Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAppliedValueRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAppliedValueRelationship()
	 * @generated
	 */
	int IFC_APPLIED_VALUE_RELATIONSHIP = 22;

	/**
	 * The feature id for the '<em><b>Component Of Total</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE_RELATIONSHIP__COMPONENT_OF_TOTAL = 0;

	/**
	 * The feature id for the '<em><b>Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE_RELATIONSHIP__COMPONENTS = 1;

	/**
	 * The feature id for the '<em><b>Arithmetic Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE_RELATIONSHIP__ARITHMETIC_OPERATOR = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE_RELATIONSHIP__NAME = 3;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE_RELATIONSHIP__DESCRIPTION = 4;

	/**
	 * The number of structural features of the '<em>Ifc Applied Value Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE_RELATIONSHIP_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcApprovalImpl <em>Ifc Approval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcApprovalImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcApproval()
	 * @generated
	 */
	int IFC_APPROVAL = 23;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__DESCRIPTION = 0;

	/**
	 * The feature id for the '<em><b>Approval Date Time</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__APPROVAL_DATE_TIME = 1;

	/**
	 * The feature id for the '<em><b>Approval Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__APPROVAL_STATUS = 2;

	/**
	 * The feature id for the '<em><b>Approval Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__APPROVAL_LEVEL = 3;

	/**
	 * The feature id for the '<em><b>Approval Qualifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__APPROVAL_QUALIFIER = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__NAME = 5;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__IDENTIFIER = 6;

	/**
	 * The feature id for the '<em><b>Actors</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__ACTORS = 7;

	/**
	 * The feature id for the '<em><b>Is Related With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__IS_RELATED_WITH = 8;

	/**
	 * The feature id for the '<em><b>Relates</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__RELATES = 9;

	/**
	 * The number of structural features of the '<em>Ifc Approval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_FEATURE_COUNT = 10;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcApprovalActorRelationshipImpl <em>Ifc Approval Actor Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcApprovalActorRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcApprovalActorRelationship()
	 * @generated
	 */
	int IFC_APPROVAL_ACTOR_RELATIONSHIP = 24;

	/**
	 * The feature id for the '<em><b>Actor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_ACTOR_RELATIONSHIP__ACTOR = 0;

	/**
	 * The feature id for the '<em><b>Approval</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_ACTOR_RELATIONSHIP__APPROVAL = 1;

	/**
	 * The feature id for the '<em><b>Role</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_ACTOR_RELATIONSHIP__ROLE = 2;

	/**
	 * The number of structural features of the '<em>Ifc Approval Actor Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_ACTOR_RELATIONSHIP_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcApprovalPropertyRelationshipImpl <em>Ifc Approval Property Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcApprovalPropertyRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcApprovalPropertyRelationship()
	 * @generated
	 */
	int IFC_APPROVAL_PROPERTY_RELATIONSHIP = 25;

	/**
	 * The feature id for the '<em><b>Approved Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_PROPERTY_RELATIONSHIP__APPROVED_PROPERTIES = 0;

	/**
	 * The feature id for the '<em><b>Approval</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_PROPERTY_RELATIONSHIP__APPROVAL = 1;

	/**
	 * The number of structural features of the '<em>Ifc Approval Property Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_PROPERTY_RELATIONSHIP_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcApprovalRelationshipImpl <em>Ifc Approval Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcApprovalRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcApprovalRelationship()
	 * @generated
	 */
	int IFC_APPROVAL_RELATIONSHIP = 26;

	/**
	 * The feature id for the '<em><b>Related Approval</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP__RELATED_APPROVAL = 0;

	/**
	 * The feature id for the '<em><b>Relating Approval</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP__RELATING_APPROVAL = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP__DESCRIPTION = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP__NAME = 3;

	/**
	 * The number of structural features of the '<em>Ifc Approval Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcProfileDefImpl <em>Ifc Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcProfileDef()
	 * @generated
	 */
	int IFC_PROFILE_DEF = 389;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROFILE_DEF__PROFILE_TYPE = 0;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROFILE_DEF__PROFILE_NAME = 1;

	/**
	 * The number of structural features of the '<em>Ifc Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROFILE_DEF_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcArbitraryClosedProfileDefImpl <em>Ifc Arbitrary Closed Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcArbitraryClosedProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcArbitraryClosedProfileDef()
	 * @generated
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF = 27;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Outer Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF__OUTER_CURVE = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Arbitrary Closed Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcArbitraryOpenProfileDefImpl <em>Ifc Arbitrary Open Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcArbitraryOpenProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcArbitraryOpenProfileDef()
	 * @generated
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF = 28;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF__CURVE = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Arbitrary Open Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcArbitraryProfileDefWithVoidsImpl <em>Ifc Arbitrary Profile Def With Voids</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcArbitraryProfileDefWithVoidsImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcArbitraryProfileDefWithVoids()
	 * @generated
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS = 29;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__PROFILE_TYPE = IFC_ARBITRARY_CLOSED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__PROFILE_NAME = IFC_ARBITRARY_CLOSED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Outer Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__OUTER_CURVE = IFC_ARBITRARY_CLOSED_PROFILE_DEF__OUTER_CURVE;

	/**
	 * The feature id for the '<em><b>Inner Curves</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__INNER_CURVES = IFC_ARBITRARY_CLOSED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Arbitrary Profile Def With Voids</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS_FEATURE_COUNT = IFC_ARBITRARY_CLOSED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcGroupImpl <em>Ifc Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcGroupImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcGroup()
	 * @generated
	 */
	int IFC_GROUP = 273;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_GROUPED_BY = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAssetImpl <em>Ifc Asset</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAssetImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAsset()
	 * @generated
	 */
	int IFC_ASSET = 30;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__GLOBAL_ID = IFC_GROUP__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__OWNER_HISTORY = IFC_GROUP__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__NAME = IFC_GROUP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__DESCRIPTION = IFC_GROUP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__HAS_ASSIGNMENTS = IFC_GROUP__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_DECOMPOSED_BY = IFC_GROUP__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__DECOMPOSES = IFC_GROUP__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__HAS_ASSOCIATIONS = IFC_GROUP__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__OBJECT_TYPE = IFC_GROUP__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_DEFINED_BY = IFC_GROUP__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_GROUPED_BY = IFC_GROUP__IS_GROUPED_BY;

	/**
	 * The feature id for the '<em><b>Asset ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__ASSET_ID = IFC_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Original Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__ORIGINAL_VALUE = IFC_GROUP_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Current Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__CURRENT_VALUE = IFC_GROUP_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Total Replacement Cost</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__TOTAL_REPLACEMENT_COST = IFC_GROUP_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__OWNER = IFC_GROUP_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>User</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__USER = IFC_GROUP_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Responsible Person</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__RESPONSIBLE_PERSON = IFC_GROUP_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Incorporation Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__INCORPORATION_DATE = IFC_GROUP_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Depreciated Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__DEPRECIATED_VALUE = IFC_GROUP_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Ifc Asset</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET_FEATURE_COUNT = IFC_GROUP_FEATURE_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcParameterizedProfileDefImpl <em>Ifc Parameterized Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcParameterizedProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcParameterizedProfileDef()
	 * @generated
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF = 343;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF__POSITION = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Parameterized Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcIShapeProfileDefImpl <em>Ifc IShape Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcIShapeProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcIShapeProfileDef()
	 * @generated
	 */
	int IFC_ISHAPE_PROFILE_DEF = 278;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Overall Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__OVERALL_WIDTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overall Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__OVERALL_WIDTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Overall Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__OVERALL_DEPTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Overall Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__OVERALL_DEPTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Web Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__WEB_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Web Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__WEB_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Flange Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__FLANGE_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Flange Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__FLANGE_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Fillet Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__FILLET_RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Fillet Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF__FILLET_RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Ifc IShape Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 10;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAsymmetricIShapeProfileDefImpl <em>Ifc Asymmetric IShape Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAsymmetricIShapeProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAsymmetricIShapeProfileDef()
	 * @generated
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF = 31;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__PROFILE_TYPE = IFC_ISHAPE_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__PROFILE_NAME = IFC_ISHAPE_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__POSITION = IFC_ISHAPE_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Overall Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__OVERALL_WIDTH = IFC_ISHAPE_PROFILE_DEF__OVERALL_WIDTH;

	/**
	 * The feature id for the '<em><b>Overall Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__OVERALL_WIDTH_AS_STRING = IFC_ISHAPE_PROFILE_DEF__OVERALL_WIDTH_AS_STRING;

	/**
	 * The feature id for the '<em><b>Overall Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__OVERALL_DEPTH = IFC_ISHAPE_PROFILE_DEF__OVERALL_DEPTH;

	/**
	 * The feature id for the '<em><b>Overall Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__OVERALL_DEPTH_AS_STRING = IFC_ISHAPE_PROFILE_DEF__OVERALL_DEPTH_AS_STRING;

	/**
	 * The feature id for the '<em><b>Web Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__WEB_THICKNESS = IFC_ISHAPE_PROFILE_DEF__WEB_THICKNESS;

	/**
	 * The feature id for the '<em><b>Web Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__WEB_THICKNESS_AS_STRING = IFC_ISHAPE_PROFILE_DEF__WEB_THICKNESS_AS_STRING;

	/**
	 * The feature id for the '<em><b>Flange Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__FLANGE_THICKNESS = IFC_ISHAPE_PROFILE_DEF__FLANGE_THICKNESS;

	/**
	 * The feature id for the '<em><b>Flange Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__FLANGE_THICKNESS_AS_STRING = IFC_ISHAPE_PROFILE_DEF__FLANGE_THICKNESS_AS_STRING;

	/**
	 * The feature id for the '<em><b>Fillet Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__FILLET_RADIUS = IFC_ISHAPE_PROFILE_DEF__FILLET_RADIUS;

	/**
	 * The feature id for the '<em><b>Fillet Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__FILLET_RADIUS_AS_STRING = IFC_ISHAPE_PROFILE_DEF__FILLET_RADIUS_AS_STRING;

	/**
	 * The feature id for the '<em><b>Top Flange Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_WIDTH = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Top Flange Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_WIDTH_AS_STRING = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Top Flange Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_THICKNESS = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Top Flange Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_THICKNESS_AS_STRING = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Top Flange Fillet Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_FILLET_RADIUS = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Top Flange Fillet Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_FILLET_RADIUS_AS_STRING = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Centre Of Gravity In Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__CENTRE_OF_GRAVITY_IN_Y = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Centre Of Gravity In YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__CENTRE_OF_GRAVITY_IN_YAS_STRING = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Ifc Asymmetric IShape Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF_FEATURE_COUNT = IFC_ISHAPE_PROFILE_DEF_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPlacementImpl <em>Ifc Placement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPlacementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPlacement()
	 * @generated
	 */
	int IFC_PLACEMENT = 357;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Location</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT__LOCATION = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Placement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAxis1PlacementImpl <em>Ifc Axis1 Placement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAxis1PlacementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAxis1Placement()
	 * @generated
	 */
	int IFC_AXIS1_PLACEMENT = 32;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__LAYER_ASSIGNMENTS = IFC_PLACEMENT__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__STYLED_BY_ITEM = IFC_PLACEMENT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Location</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__LOCATION = IFC_PLACEMENT__LOCATION;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__DIM = IFC_PLACEMENT__DIM;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__AXIS = IFC_PLACEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Axis1 Placement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT_FEATURE_COUNT = IFC_PLACEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAxis2Placement2DImpl <em>Ifc Axis2 Placement2 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAxis2Placement2DImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAxis2Placement2D()
	 * @generated
	 */
	int IFC_AXIS2_PLACEMENT2_D = 33;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__LAYER_ASSIGNMENTS = IFC_PLACEMENT__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__STYLED_BY_ITEM = IFC_PLACEMENT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Location</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__LOCATION = IFC_PLACEMENT__LOCATION;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__DIM = IFC_PLACEMENT__DIM;

	/**
	 * The feature id for the '<em><b>Ref Direction</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__REF_DIRECTION = IFC_PLACEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Axis2 Placement2 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D_FEATURE_COUNT = IFC_PLACEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcAxis2Placement3DImpl <em>Ifc Axis2 Placement3 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcAxis2Placement3DImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcAxis2Placement3D()
	 * @generated
	 */
	int IFC_AXIS2_PLACEMENT3_D = 34;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__LAYER_ASSIGNMENTS = IFC_PLACEMENT__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__STYLED_BY_ITEM = IFC_PLACEMENT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Location</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__LOCATION = IFC_PLACEMENT__LOCATION;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__DIM = IFC_PLACEMENT__DIM;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__AXIS = IFC_PLACEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ref Direction</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__REF_DIRECTION = IFC_PLACEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Axis2 Placement3 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D_FEATURE_COUNT = IFC_PLACEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBSplineCurveImpl <em>Ifc BSpline Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBSplineCurveImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBSplineCurve()
	 * @generated
	 */
	int IFC_BSPLINE_CURVE = 35;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__LAYER_ASSIGNMENTS = IFC_BOUNDED_CURVE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__STYLED_BY_ITEM = IFC_BOUNDED_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__DIM = IFC_BOUNDED_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Degree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__DEGREE = IFC_BOUNDED_CURVE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Control Points List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__CONTROL_POINTS_LIST = IFC_BOUNDED_CURVE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Curve Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__CURVE_FORM = IFC_BOUNDED_CURVE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Closed Curve</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__CLOSED_CURVE = IFC_BOUNDED_CURVE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__SELF_INTERSECT = IFC_BOUNDED_CURVE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc BSpline Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_FEATURE_COUNT = IFC_BOUNDED_CURVE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElementImpl <em>Ifc Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElement()
	 * @generated
	 */
	int IFC_ELEMENT = 195;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__GLOBAL_ID = IFC_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__OWNER_HISTORY = IFC_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__NAME = IFC_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__DESCRIPTION = IFC_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_ASSIGNMENTS = IFC_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_DECOMPOSED_BY = IFC_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__DECOMPOSES = IFC_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_ASSOCIATIONS = IFC_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__OBJECT_TYPE = IFC_PRODUCT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_DEFINED_BY = IFC_PRODUCT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__OBJECT_PLACEMENT = IFC_PRODUCT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__REPRESENTATION = IFC_PRODUCT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__REFERENCED_BY = IFC_PRODUCT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__GEOMETRY = IFC_PRODUCT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__TAG = IFC_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__FILLS_VOIDS = IFC_PRODUCT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__CONNECTED_TO = IFC_PRODUCT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_COVERINGS = IFC_PRODUCT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_PROJECTIONS = IFC_PRODUCT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_PRODUCT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_PORTS = IFC_PRODUCT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_OPENINGS = IFC_PRODUCT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_CONNECTION_REALIZATION = IFC_PRODUCT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__PROVIDES_BOUNDARIES = IFC_PRODUCT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__CONNECTED_FROM = IFC_PRODUCT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_PRODUCT_FEATURE_COUNT + 12;

	/**
	 * The number of structural features of the '<em>Ifc Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_FEATURE_COUNT = IFC_PRODUCT_FEATURE_COUNT + 13;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementImpl <em>Ifc Building Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBuildingElement()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT = 54;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_COVERINGS = IFC_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_PORTS = IFC_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Building Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBeamImpl <em>Ifc Beam</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBeamImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBeam()
	 * @generated
	 */
	int IFC_BEAM = 36;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_STRUCTURAL_MEMBER = IFC_BUILDING_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_PORTS = IFC_BUILDING_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Beam</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementTypeImpl <em>Ifc Building Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBuildingElementType()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_TYPE = 59;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID = IFC_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY = IFC_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__NAME = IFC_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION = IFC_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES = IFC_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__OBJECT_TYPE_OF = IFC_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__TAG = IFC_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE = IFC_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT = IFC_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBeamTypeImpl <em>Ifc Beam Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBeamTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBeamType()
	 * @generated
	 */
	int IFC_BEAM_TYPE = 37;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__OBJECT_TYPE_OF = IFC_BUILDING_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Beam Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBezierCurveImpl <em>Ifc Bezier Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBezierCurveImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBezierCurve()
	 * @generated
	 */
	int IFC_BEZIER_CURVE = 38;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE__LAYER_ASSIGNMENTS = IFC_BSPLINE_CURVE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE__STYLED_BY_ITEM = IFC_BSPLINE_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE__DIM = IFC_BSPLINE_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Degree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE__DEGREE = IFC_BSPLINE_CURVE__DEGREE;

	/**
	 * The feature id for the '<em><b>Control Points List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE__CONTROL_POINTS_LIST = IFC_BSPLINE_CURVE__CONTROL_POINTS_LIST;

	/**
	 * The feature id for the '<em><b>Curve Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE__CURVE_FORM = IFC_BSPLINE_CURVE__CURVE_FORM;

	/**
	 * The feature id for the '<em><b>Closed Curve</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE__CLOSED_CURVE = IFC_BSPLINE_CURVE__CLOSED_CURVE;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE__SELF_INTERSECT = IFC_BSPLINE_CURVE__SELF_INTERSECT;

	/**
	 * The number of structural features of the '<em>Ifc Bezier Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEZIER_CURVE_FEATURE_COUNT = IFC_BSPLINE_CURVE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcSurfaceTextureImpl <em>Ifc Surface Texture</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcSurfaceTextureImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcSurfaceTexture()
	 * @generated
	 */
	int IFC_SURFACE_TEXTURE = 583;

	/**
	 * The feature id for the '<em><b>Repeat S</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__REPEAT_S = 0;

	/**
	 * The feature id for the '<em><b>Repeat T</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__REPEAT_T = 1;

	/**
	 * The feature id for the '<em><b>Texture Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__TEXTURE_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Texture Transform</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__TEXTURE_TRANSFORM = 3;

	/**
	 * The number of structural features of the '<em>Ifc Surface Texture</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBlobTextureImpl <em>Ifc Blob Texture</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBlobTextureImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBlobTexture()
	 * @generated
	 */
	int IFC_BLOB_TEXTURE = 39;

	/**
	 * The feature id for the '<em><b>Repeat S</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__REPEAT_S = IFC_SURFACE_TEXTURE__REPEAT_S;

	/**
	 * The feature id for the '<em><b>Repeat T</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__REPEAT_T = IFC_SURFACE_TEXTURE__REPEAT_T;

	/**
	 * The feature id for the '<em><b>Texture Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__TEXTURE_TYPE = IFC_SURFACE_TEXTURE__TEXTURE_TYPE;

	/**
	 * The feature id for the '<em><b>Texture Transform</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__TEXTURE_TRANSFORM = IFC_SURFACE_TEXTURE__TEXTURE_TRANSFORM;

	/**
	 * The feature id for the '<em><b>Raster Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__RASTER_FORMAT = IFC_SURFACE_TEXTURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Raster Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__RASTER_CODE = IFC_SURFACE_TEXTURE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Blob Texture</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE_FEATURE_COUNT = IFC_SURFACE_TEXTURE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCsgPrimitive3DImpl <em>Ifc Csg Primitive3 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCsgPrimitive3DImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCsgPrimitive3D()
	 * @generated
	 */
	int IFC_CSG_PRIMITIVE3_D = 129;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D__POSITION = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Csg Primitive3 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBlockImpl <em>Ifc Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBlockImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBlock()
	 * @generated
	 */
	int IFC_BLOCK = 40;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__LAYER_ASSIGNMENTS = IFC_CSG_PRIMITIVE3_D__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__STYLED_BY_ITEM = IFC_CSG_PRIMITIVE3_D__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__POSITION = IFC_CSG_PRIMITIVE3_D__POSITION;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__DIM = IFC_CSG_PRIMITIVE3_D__DIM;

	/**
	 * The feature id for the '<em><b>XLength</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__XLENGTH = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>XLength As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__XLENGTH_AS_STRING = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>YLength</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__YLENGTH = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>YLength As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__YLENGTH_AS_STRING = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>ZLength</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__ZLENGTH = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>ZLength As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__ZLENGTH_AS_STRING = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK_FEATURE_COUNT = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoilerTypeImpl <em>Ifc Boiler Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoilerTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoilerType()
	 * @generated
	 */
	int IFC_BOILER_TYPE = 41;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Boiler Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBooleanResultImpl <em>Ifc Boolean Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBooleanResultImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBooleanResult()
	 * @generated
	 */
	int IFC_BOOLEAN_RESULT = 43;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__OPERATOR = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>First Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__FIRST_OPERAND = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Second Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__SECOND_OPERAND = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Boolean Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBooleanClippingResultImpl <em>Ifc Boolean Clipping Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBooleanClippingResultImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBooleanClippingResult()
	 * @generated
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT = 42;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__LAYER_ASSIGNMENTS = IFC_BOOLEAN_RESULT__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__STYLED_BY_ITEM = IFC_BOOLEAN_RESULT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__OPERATOR = IFC_BOOLEAN_RESULT__OPERATOR;

	/**
	 * The feature id for the '<em><b>First Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__FIRST_OPERAND = IFC_BOOLEAN_RESULT__FIRST_OPERAND;

	/**
	 * The feature id for the '<em><b>Second Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__SECOND_OPERAND = IFC_BOOLEAN_RESULT__SECOND_OPERAND;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__DIM = IFC_BOOLEAN_RESULT__DIM;

	/**
	 * The number of structural features of the '<em>Ifc Boolean Clipping Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT_FEATURE_COUNT = IFC_BOOLEAN_RESULT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryConditionImpl <em>Ifc Boundary Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryConditionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoundaryCondition()
	 * @generated
	 */
	int IFC_BOUNDARY_CONDITION = 44;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CONDITION__NAME = 0;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CONDITION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryEdgeConditionImpl <em>Ifc Boundary Edge Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryEdgeConditionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoundaryEdgeCondition()
	 * @generated
	 */
	int IFC_BOUNDARY_EDGE_CONDITION = 45;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__NAME = IFC_BOUNDARY_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Length X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__LINEAR_STIFFNESS_BY_LENGTH_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Length XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__LINEAR_STIFFNESS_BY_LENGTH_XAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Length Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__LINEAR_STIFFNESS_BY_LENGTH_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Length YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__LINEAR_STIFFNESS_BY_LENGTH_YAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Length Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__LINEAR_STIFFNESS_BY_LENGTH_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Length ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__LINEAR_STIFFNESS_BY_LENGTH_ZAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_XAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_YAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_ZAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Edge Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION_FEATURE_COUNT = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 12;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryFaceConditionImpl <em>Ifc Boundary Face Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryFaceConditionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoundaryFaceCondition()
	 * @generated
	 */
	int IFC_BOUNDARY_FACE_CONDITION = 46;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__NAME = IFC_BOUNDARY_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Area X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__LINEAR_STIFFNESS_BY_AREA_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Area XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__LINEAR_STIFFNESS_BY_AREA_XAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Area Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__LINEAR_STIFFNESS_BY_AREA_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Area YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__LINEAR_STIFFNESS_BY_AREA_YAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Area Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__LINEAR_STIFFNESS_BY_AREA_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Linear Stiffness By Area ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__LINEAR_STIFFNESS_BY_AREA_ZAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Face Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION_FEATURE_COUNT = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryNodeConditionImpl <em>Ifc Boundary Node Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryNodeConditionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoundaryNodeCondition()
	 * @generated
	 */
	int IFC_BOUNDARY_NODE_CONDITION = 47;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__NAME = IFC_BOUNDARY_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Linear Stiffness X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Linear Stiffness XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_XAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Linear Stiffness Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Linear Stiffness YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_YAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Linear Stiffness Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Linear Stiffness ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_ZAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_XAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_YAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_ZAS_STRING = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Node Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_FEATURE_COUNT = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 12;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryNodeConditionWarpingImpl <em>Ifc Boundary Node Condition Warping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoundaryNodeConditionWarpingImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoundaryNodeConditionWarping()
	 * @generated
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING = 48;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__NAME = IFC_BOUNDARY_NODE_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Linear Stiffness X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__LINEAR_STIFFNESS_X = IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_X;

	/**
	 * The feature id for the '<em><b>Linear Stiffness XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__LINEAR_STIFFNESS_XAS_STRING = IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_XAS_STRING;

	/**
	 * The feature id for the '<em><b>Linear Stiffness Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__LINEAR_STIFFNESS_Y = IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_Y;

	/**
	 * The feature id for the '<em><b>Linear Stiffness YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__LINEAR_STIFFNESS_YAS_STRING = IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_YAS_STRING;

	/**
	 * The feature id for the '<em><b>Linear Stiffness Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__LINEAR_STIFFNESS_Z = IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_Z;

	/**
	 * The feature id for the '<em><b>Linear Stiffness ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__LINEAR_STIFFNESS_ZAS_STRING = IFC_BOUNDARY_NODE_CONDITION__LINEAR_STIFFNESS_ZAS_STRING;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_X = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_X;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_XAS_STRING = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_XAS_STRING;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_Y = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_Y;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_YAS_STRING = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_YAS_STRING;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_Z = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_Z;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_ZAS_STRING = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_ZAS_STRING;

	/**
	 * The feature id for the '<em><b>Warping Stiffness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__WARPING_STIFFNESS = IFC_BOUNDARY_NODE_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Warping Stiffness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__WARPING_STIFFNESS_AS_STRING = IFC_BOUNDARY_NODE_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Node Condition Warping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING_FEATURE_COUNT = IFC_BOUNDARY_NODE_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcSurfaceImpl <em>Ifc Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcSurfaceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcSurface()
	 * @generated
	 */
	int IFC_SURFACE = 573;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoundedSurfaceImpl <em>Ifc Bounded Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoundedSurfaceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoundedSurface()
	 * @generated
	 */
	int IFC_BOUNDED_SURFACE = 50;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_SURFACE__LAYER_ASSIGNMENTS = IFC_SURFACE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_SURFACE__STYLED_BY_ITEM = IFC_SURFACE__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Bounded Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_SURFACE_FEATURE_COUNT = IFC_SURFACE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoundingBoxImpl <em>Ifc Bounding Box</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoundingBoxImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoundingBox()
	 * @generated
	 */
	int IFC_BOUNDING_BOX = 51;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Corner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__CORNER = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>XDim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__XDIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>XDim As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__XDIM_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>YDim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__YDIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>YDim As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__YDIM_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>ZDim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__ZDIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>ZDim As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__ZDIM_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Ifc Bounding Box</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcHalfSpaceSolidImpl <em>Ifc Half Space Solid</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcHalfSpaceSolidImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcHalfSpaceSolid()
	 * @generated
	 */
	int IFC_HALF_SPACE_SOLID = 274;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Base Surface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__BASE_SURFACE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Agreement Flag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__AGREEMENT_FLAG = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Half Space Solid</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBoxedHalfSpaceImpl <em>Ifc Boxed Half Space</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBoxedHalfSpaceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBoxedHalfSpace()
	 * @generated
	 */
	int IFC_BOXED_HALF_SPACE = 52;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__LAYER_ASSIGNMENTS = IFC_HALF_SPACE_SOLID__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__STYLED_BY_ITEM = IFC_HALF_SPACE_SOLID__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Base Surface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__BASE_SURFACE = IFC_HALF_SPACE_SOLID__BASE_SURFACE;

	/**
	 * The feature id for the '<em><b>Agreement Flag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__AGREEMENT_FLAG = IFC_HALF_SPACE_SOLID__AGREEMENT_FLAG;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__DIM = IFC_HALF_SPACE_SOLID__DIM;

	/**
	 * The feature id for the '<em><b>Enclosure</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__ENCLOSURE = IFC_HALF_SPACE_SOLID_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Boxed Half Space</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE_FEATURE_COUNT = IFC_HALF_SPACE_SOLID_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcSpatialStructureElementImpl <em>Ifc Spatial Structure Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcSpatialStructureElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcSpatialStructureElement()
	 * @generated
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT = 526;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__GLOBAL_ID = IFC_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__OWNER_HISTORY = IFC_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__NAME = IFC_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__DESCRIPTION = IFC_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSIGNMENTS = IFC_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECOMPOSED_BY = IFC_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__DECOMPOSES = IFC_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSOCIATIONS = IFC_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_TYPE = IFC_PRODUCT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DEFINED_BY = IFC_PRODUCT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_PLACEMENT = IFC_PRODUCT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__REPRESENTATION = IFC_PRODUCT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCED_BY = IFC_PRODUCT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__GEOMETRY = IFC_PRODUCT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Long Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__LONG_NAME = IFC_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Composition Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__COMPOSITION_TYPE = IFC_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>References Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCES_ELEMENTS = IFC_PRODUCT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Serviced By Systems</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__SERVICED_BY_SYSTEMS = IFC_PRODUCT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Contains Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__CONTAINS_ELEMENTS = IFC_PRODUCT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Spatial Structure Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT = IFC_PRODUCT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBuildingImpl <em>Ifc Building</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBuildingImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBuilding()
	 * @generated
	 */
	int IFC_BUILDING = 53;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__GLOBAL_ID = IFC_SPATIAL_STRUCTURE_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__OWNER_HISTORY = IFC_SPATIAL_STRUCTURE_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__NAME = IFC_SPATIAL_STRUCTURE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__DESCRIPTION = IFC_SPATIAL_STRUCTURE_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__HAS_ASSIGNMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__IS_DECOMPOSED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__DECOMPOSES = IFC_SPATIAL_STRUCTURE_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__HAS_ASSOCIATIONS = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__OBJECT_TYPE = IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__IS_DEFINED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__OBJECT_PLACEMENT = IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__REPRESENTATION = IFC_SPATIAL_STRUCTURE_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__REFERENCED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__GEOMETRY = IFC_SPATIAL_STRUCTURE_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Long Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__LONG_NAME = IFC_SPATIAL_STRUCTURE_ELEMENT__LONG_NAME;

	/**
	 * The feature id for the '<em><b>Composition Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__COMPOSITION_TYPE = IFC_SPATIAL_STRUCTURE_ELEMENT__COMPOSITION_TYPE;

	/**
	 * The feature id for the '<em><b>References Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__REFERENCES_ELEMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Serviced By Systems</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__SERVICED_BY_SYSTEMS = IFC_SPATIAL_STRUCTURE_ELEMENT__SERVICED_BY_SYSTEMS;

	/**
	 * The feature id for the '<em><b>Contains Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__CONTAINS_ELEMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__CONTAINS_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Elevation Of Ref Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__ELEVATION_OF_REF_HEIGHT = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Elevation Of Ref Height As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__ELEVATION_OF_REF_HEIGHT_AS_STRING = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Elevation Of Terrain</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__ELEVATION_OF_TERRAIN = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Elevation Of Terrain As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__ELEVATION_OF_TERRAIN_AS_STRING = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Building Address</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__BUILDING_ADDRESS = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Building</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_FEATURE_COUNT = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementComponentImpl <em>Ifc Building Element Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementComponentImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBuildingElementComponent()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT = 55;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__HAS_STRUCTURAL_MEMBER = IFC_BUILDING_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__HAS_PORTS = IFC_BUILDING_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_COMPONENT_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementPartImpl <em>Ifc Building Element Part</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementPartImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBuildingElementPart()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_PART = 56;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__GLOBAL_ID = IFC_BUILDING_ELEMENT_COMPONENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__OWNER_HISTORY = IFC_BUILDING_ELEMENT_COMPONENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__NAME = IFC_BUILDING_ELEMENT_COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__DESCRIPTION = IFC_BUILDING_ELEMENT_COMPONENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_COMPONENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_COMPONENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__DECOMPOSES = IFC_BUILDING_ELEMENT_COMPONENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_COMPONENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__OBJECT_TYPE = IFC_BUILDING_ELEMENT_COMPONENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_DEFINED_BY = IFC_BUILDING_ELEMENT_COMPONENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT_COMPONENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__REPRESENTATION = IFC_BUILDING_ELEMENT_COMPONENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__REFERENCED_BY = IFC_BUILDING_ELEMENT_COMPONENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__GEOMETRY = IFC_BUILDING_ELEMENT_COMPONENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__TAG = IFC_BUILDING_ELEMENT_COMPONENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_STRUCTURAL_MEMBER = IFC_BUILDING_ELEMENT_COMPONENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__FILLS_VOIDS = IFC_BUILDING_ELEMENT_COMPONENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__CONNECTED_TO = IFC_BUILDING_ELEMENT_COMPONENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_COVERINGS = IFC_BUILDING_ELEMENT_COMPONENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT_COMPONENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT_COMPONENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_PORTS = IFC_BUILDING_ELEMENT_COMPONENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_OPENINGS = IFC_BUILDING_ELEMENT_COMPONENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT_COMPONENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT_COMPONENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__CONNECTED_FROM = IFC_BUILDING_ELEMENT_COMPONENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT_COMPONENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Part</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_FEATURE_COUNT = IFC_BUILDING_ELEMENT_COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementProxyImpl <em>Ifc Building Element Proxy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementProxyImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBuildingElementProxy()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_PROXY = 57;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_STRUCTURAL_MEMBER = IFC_BUILDING_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_PORTS = IFC_BUILDING_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Composition Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__COMPOSITION_TYPE = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Proxy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementProxyTypeImpl <em>Ifc Building Element Proxy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBuildingElementProxyTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBuildingElementProxyType()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE = 58;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__OBJECT_TYPE_OF = IFC_BUILDING_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Proxy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcBuildingStoreyImpl <em>Ifc Building Storey</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcBuildingStoreyImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcBuildingStorey()
	 * @generated
	 */
	int IFC_BUILDING_STOREY = 60;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__GLOBAL_ID = IFC_SPATIAL_STRUCTURE_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__OWNER_HISTORY = IFC_SPATIAL_STRUCTURE_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__NAME = IFC_SPATIAL_STRUCTURE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__DESCRIPTION = IFC_SPATIAL_STRUCTURE_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__HAS_ASSIGNMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__IS_DECOMPOSED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__DECOMPOSES = IFC_SPATIAL_STRUCTURE_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__HAS_ASSOCIATIONS = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__OBJECT_TYPE = IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__IS_DEFINED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__OBJECT_PLACEMENT = IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__REPRESENTATION = IFC_SPATIAL_STRUCTURE_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__REFERENCED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__GEOMETRY = IFC_SPATIAL_STRUCTURE_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Long Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__LONG_NAME = IFC_SPATIAL_STRUCTURE_ELEMENT__LONG_NAME;

	/**
	 * The feature id for the '<em><b>Composition Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__COMPOSITION_TYPE = IFC_SPATIAL_STRUCTURE_ELEMENT__COMPOSITION_TYPE;

	/**
	 * The feature id for the '<em><b>References Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__REFERENCES_ELEMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Serviced By Systems</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__SERVICED_BY_SYSTEMS = IFC_SPATIAL_STRUCTURE_ELEMENT__SERVICED_BY_SYSTEMS;

	/**
	 * The feature id for the '<em><b>Contains Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__CONTAINS_ELEMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__CONTAINS_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Elevation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__ELEVATION = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Elevation As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__ELEVATION_AS_STRING = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Building Storey</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY_FEATURE_COUNT = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCShapeProfileDefImpl <em>Ifc CShape Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCShapeProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCShapeProfileDef()
	 * @generated
	 */
	int IFC_CSHAPE_PROFILE_DEF = 61;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__DEPTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__DEPTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__WIDTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__WIDTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Wall Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__WALL_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Wall Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__WALL_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Girth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__GIRTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Girth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__GIRTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Internal Fillet Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__INTERNAL_FILLET_RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Internal Fillet Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__INTERNAL_FILLET_RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Centre Of Gravity In X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__CENTRE_OF_GRAVITY_IN_X = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Centre Of Gravity In XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__CENTRE_OF_GRAVITY_IN_XAS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Ifc CShape Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 12;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowFittingTypeImpl <em>Ifc Flow Fitting Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowFittingTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowFittingType()
	 * @generated
	 */
	int IFC_FLOW_FITTING_TYPE = 242;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Fitting Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCableCarrierFittingTypeImpl <em>Ifc Cable Carrier Fitting Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCableCarrierFittingTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCableCarrierFittingType()
	 * @generated
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE = 62;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__GLOBAL_ID = IFC_FLOW_FITTING_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__OWNER_HISTORY = IFC_FLOW_FITTING_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__NAME = IFC_FLOW_FITTING_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__DESCRIPTION = IFC_FLOW_FITTING_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_FITTING_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_FITTING_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__DECOMPOSES = IFC_FLOW_FITTING_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_FITTING_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_FITTING_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_FITTING_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__OBJECT_TYPE_OF = IFC_FLOW_FITTING_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__REPRESENTATION_MAPS = IFC_FLOW_FITTING_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__TAG = IFC_FLOW_FITTING_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__ELEMENT_TYPE = IFC_FLOW_FITTING_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__PREDEFINED_TYPE = IFC_FLOW_FITTING_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Carrier Fitting Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE_FEATURE_COUNT = IFC_FLOW_FITTING_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowSegmentTypeImpl <em>Ifc Flow Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowSegmentTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowSegmentType()
	 * @generated
	 */
	int IFC_FLOW_SEGMENT_TYPE = 248;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCableCarrierSegmentTypeImpl <em>Ifc Cable Carrier Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCableCarrierSegmentTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCableCarrierSegmentType()
	 * @generated
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE = 63;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__GLOBAL_ID = IFC_FLOW_SEGMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__OWNER_HISTORY = IFC_FLOW_SEGMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__NAME = IFC_FLOW_SEGMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__DESCRIPTION = IFC_FLOW_SEGMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_SEGMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__DECOMPOSES = IFC_FLOW_SEGMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_SEGMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_SEGMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__OBJECT_TYPE_OF = IFC_FLOW_SEGMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__REPRESENTATION_MAPS = IFC_FLOW_SEGMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__TAG = IFC_FLOW_SEGMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__ELEMENT_TYPE = IFC_FLOW_SEGMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__PREDEFINED_TYPE = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Carrier Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE_FEATURE_COUNT = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCableSegmentTypeImpl <em>Ifc Cable Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCableSegmentTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCableSegmentType()
	 * @generated
	 */
	int IFC_CABLE_SEGMENT_TYPE = 64;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__GLOBAL_ID = IFC_FLOW_SEGMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__OWNER_HISTORY = IFC_FLOW_SEGMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__NAME = IFC_FLOW_SEGMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__DESCRIPTION = IFC_FLOW_SEGMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_SEGMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__DECOMPOSES = IFC_FLOW_SEGMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_SEGMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_SEGMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__OBJECT_TYPE_OF = IFC_FLOW_SEGMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__REPRESENTATION_MAPS = IFC_FLOW_SEGMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__TAG = IFC_FLOW_SEGMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__ELEMENT_TYPE = IFC_FLOW_SEGMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__PREDEFINED_TYPE = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE_FEATURE_COUNT = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcMetricValueSelect <em>Ifc Metric Value Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcMetricValueSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcMetricValueSelect()
	 * @generated
	 */
	int IFC_METRIC_VALUE_SELECT = 798;

	/**
	 * The number of structural features of the '<em>Ifc Metric Value Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_METRIC_VALUE_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcDateTimeSelect <em>Ifc Date Time Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcDateTimeSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDateTimeSelect()
	 * @generated
	 */
	int IFC_DATE_TIME_SELECT = 784;

	/**
	 * The number of structural features of the '<em>Ifc Date Time Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DATE_TIME_SELECT_FEATURE_COUNT = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCalendarDateImpl <em>Ifc Calendar Date</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCalendarDateImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCalendarDate()
	 * @generated
	 */
	int IFC_CALENDAR_DATE = 65;

	/**
	 * The feature id for the '<em><b>Day Component</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CALENDAR_DATE__DAY_COMPONENT = IFC_DATE_TIME_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Month Component</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CALENDAR_DATE__MONTH_COMPONENT = IFC_DATE_TIME_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Year Component</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CALENDAR_DATE__YEAR_COMPONENT = IFC_DATE_TIME_SELECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Calendar Date</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CALENDAR_DATE_FEATURE_COUNT = IFC_DATE_TIME_SELECT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPointImpl <em>Ifc Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPointImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPoint()
	 * @generated
	 */
	int IFC_POINT = 363;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_POINT__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_POINT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_POINT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCartesianPointImpl <em>Ifc Cartesian Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCartesianPointImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCartesianPoint()
	 * @generated
	 */
	int IFC_CARTESIAN_POINT = 66;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__LAYER_ASSIGNMENTS = IFC_POINT__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__STYLED_BY_ITEM = IFC_POINT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__COORDINATES = IFC_POINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Coordinates As String</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__COORDINATES_AS_STRING = IFC_POINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__DIM = IFC_POINT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_FEATURE_COUNT = IFC_POINT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperatorImpl <em>Ifc Cartesian Transformation Operator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperatorImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCartesianTransformationOperator()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR = 67;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS1 = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS2 = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LOCAL_ORIGIN = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperator2DImpl <em>Ifc Cartesian Transformation Operator2 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperator2DImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCartesianTransformationOperator2D()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D = 68;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__LAYER_ASSIGNMENTS = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__STYLED_BY_ITEM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__AXIS1 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS1;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__AXIS2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS2;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__LOCAL_ORIGIN = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LOCAL_ORIGIN;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__SCALE = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__SCALE_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE_AS_STRING;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__DIM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__DIM;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator2 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D_FEATURE_COUNT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperator2DnonUniformImpl <em>Ifc Cartesian Transformation Operator2 Dnon Uniform</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperator2DnonUniformImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCartesianTransformationOperator2DnonUniform()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM = 69;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__LAYER_ASSIGNMENTS = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__STYLED_BY_ITEM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__AXIS1 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__AXIS1;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__AXIS2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__AXIS2;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__LOCAL_ORIGIN = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__LOCAL_ORIGIN;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__SCALE = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__SCALE;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__SCALE_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__SCALE_AS_STRING;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__DIM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__DIM;

	/**
	 * The feature id for the '<em><b>Scale2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__SCALE2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scale2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__SCALE2_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator2 Dnon Uniform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM_FEATURE_COUNT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperator3DImpl <em>Ifc Cartesian Transformation Operator3 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperator3DImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCartesianTransformationOperator3D()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D = 70;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__LAYER_ASSIGNMENTS = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__STYLED_BY_ITEM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS1 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS1;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS2;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__LOCAL_ORIGIN = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LOCAL_ORIGIN;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__SCALE = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__SCALE_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE_AS_STRING;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__DIM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__DIM;

	/**
	 * The feature id for the '<em><b>Axis3</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS3 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator3 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperator3DnonUniformImpl <em>Ifc Cartesian Transformation Operator3 Dnon Uniform</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCartesianTransformationOperator3DnonUniformImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCartesianTransformationOperator3DnonUniform()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM = 71;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__LAYER_ASSIGNMENTS = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__STYLED_BY_ITEM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__AXIS1 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS1;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__AXIS2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS2;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__LOCAL_ORIGIN = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__LOCAL_ORIGIN;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__SCALE;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__SCALE_AS_STRING;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__DIM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__DIM;

	/**
	 * The feature id for the '<em><b>Axis3</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__AXIS3 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS3;

	/**
	 * The feature id for the '<em><b>Scale2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scale2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE2_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Scale3</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE3 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Scale3 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE3_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator3 Dnon Uniform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM_FEATURE_COUNT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCenterLineProfileDefImpl <em>Ifc Center Line Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCenterLineProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCenterLineProfileDef()
	 * @generated
	 */
	int IFC_CENTER_LINE_PROFILE_DEF = 72;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__PROFILE_TYPE = IFC_ARBITRARY_OPEN_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__PROFILE_NAME = IFC_ARBITRARY_OPEN_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__CURVE = IFC_ARBITRARY_OPEN_PROFILE_DEF__CURVE;

	/**
	 * The feature id for the '<em><b>Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__THICKNESS = IFC_ARBITRARY_OPEN_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__THICKNESS_AS_STRING = IFC_ARBITRARY_OPEN_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Center Line Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF_FEATURE_COUNT = IFC_ARBITRARY_OPEN_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFeatureElementImpl <em>Ifc Feature Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFeatureElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFeatureElement()
	 * @generated
	 */
	int IFC_FEATURE_ELEMENT = 230;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__HAS_COVERINGS = IFC_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__HAS_PORTS = IFC_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Feature Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFeatureElementSubtractionImpl <em>Ifc Feature Element Subtraction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFeatureElementSubtractionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFeatureElementSubtraction()
	 * @generated
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION = 232;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__GLOBAL_ID = IFC_FEATURE_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__OWNER_HISTORY = IFC_FEATURE_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__NAME = IFC_FEATURE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__DESCRIPTION = IFC_FEATURE_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_ASSIGNMENTS = IFC_FEATURE_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__IS_DECOMPOSED_BY = IFC_FEATURE_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__DECOMPOSES = IFC_FEATURE_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_ASSOCIATIONS = IFC_FEATURE_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__OBJECT_TYPE = IFC_FEATURE_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__IS_DEFINED_BY = IFC_FEATURE_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__OBJECT_PLACEMENT = IFC_FEATURE_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__REPRESENTATION = IFC_FEATURE_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__REFERENCED_BY = IFC_FEATURE_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__GEOMETRY = IFC_FEATURE_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__TAG = IFC_FEATURE_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_STRUCTURAL_MEMBER = IFC_FEATURE_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__FILLS_VOIDS = IFC_FEATURE_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__CONNECTED_TO = IFC_FEATURE_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_COVERINGS = IFC_FEATURE_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_PROJECTIONS = IFC_FEATURE_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__REFERENCED_IN_STRUCTURES = IFC_FEATURE_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_PORTS = IFC_FEATURE_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_OPENINGS = IFC_FEATURE_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__IS_CONNECTION_REALIZATION = IFC_FEATURE_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__PROVIDES_BOUNDARIES = IFC_FEATURE_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__CONNECTED_FROM = IFC_FEATURE_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__CONTAINED_IN_STRUCTURE = IFC_FEATURE_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Voids Elements</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION__VOIDS_ELEMENTS = IFC_FEATURE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Feature Element Subtraction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_SUBTRACTION_FEATURE_COUNT = IFC_FEATURE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEdgeFeatureImpl <em>Ifc Edge Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEdgeFeatureImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEdgeFeature()
	 * @generated
	 */
	int IFC_EDGE_FEATURE = 183;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__GLOBAL_ID = IFC_FEATURE_ELEMENT_SUBTRACTION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__OWNER_HISTORY = IFC_FEATURE_ELEMENT_SUBTRACTION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__NAME = IFC_FEATURE_ELEMENT_SUBTRACTION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__DESCRIPTION = IFC_FEATURE_ELEMENT_SUBTRACTION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__HAS_ASSIGNMENTS = IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__IS_DECOMPOSED_BY = IFC_FEATURE_ELEMENT_SUBTRACTION__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__DECOMPOSES = IFC_FEATURE_ELEMENT_SUBTRACTION__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__HAS_ASSOCIATIONS = IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__OBJECT_TYPE = IFC_FEATURE_ELEMENT_SUBTRACTION__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__IS_DEFINED_BY = IFC_FEATURE_ELEMENT_SUBTRACTION__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__OBJECT_PLACEMENT = IFC_FEATURE_ELEMENT_SUBTRACTION__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__REPRESENTATION = IFC_FEATURE_ELEMENT_SUBTRACTION__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__REFERENCED_BY = IFC_FEATURE_ELEMENT_SUBTRACTION__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__GEOMETRY = IFC_FEATURE_ELEMENT_SUBTRACTION__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__TAG = IFC_FEATURE_ELEMENT_SUBTRACTION__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__HAS_STRUCTURAL_MEMBER = IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__FILLS_VOIDS = IFC_FEATURE_ELEMENT_SUBTRACTION__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__CONNECTED_TO = IFC_FEATURE_ELEMENT_SUBTRACTION__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__HAS_COVERINGS = IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__HAS_PROJECTIONS = IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__REFERENCED_IN_STRUCTURES = IFC_FEATURE_ELEMENT_SUBTRACTION__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__HAS_PORTS = IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__HAS_OPENINGS = IFC_FEATURE_ELEMENT_SUBTRACTION__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__IS_CONNECTION_REALIZATION = IFC_FEATURE_ELEMENT_SUBTRACTION__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__PROVIDES_BOUNDARIES = IFC_FEATURE_ELEMENT_SUBTRACTION__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__CONNECTED_FROM = IFC_FEATURE_ELEMENT_SUBTRACTION__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__CONTAINED_IN_STRUCTURE = IFC_FEATURE_ELEMENT_SUBTRACTION__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Voids Elements</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__VOIDS_ELEMENTS = IFC_FEATURE_ELEMENT_SUBTRACTION__VOIDS_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Feature Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__FEATURE_LENGTH = IFC_FEATURE_ELEMENT_SUBTRACTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Feature Length As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE__FEATURE_LENGTH_AS_STRING = IFC_FEATURE_ELEMENT_SUBTRACTION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Edge Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE_FEATURE_COUNT = IFC_FEATURE_ELEMENT_SUBTRACTION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcChamferEdgeFeatureImpl <em>Ifc Chamfer Edge Feature</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcChamferEdgeFeatureImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcChamferEdgeFeature()
	 * @generated
	 */
	int IFC_CHAMFER_EDGE_FEATURE = 73;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__GLOBAL_ID = IFC_EDGE_FEATURE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__OWNER_HISTORY = IFC_EDGE_FEATURE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__NAME = IFC_EDGE_FEATURE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__DESCRIPTION = IFC_EDGE_FEATURE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HAS_ASSIGNMENTS = IFC_EDGE_FEATURE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__IS_DECOMPOSED_BY = IFC_EDGE_FEATURE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__DECOMPOSES = IFC_EDGE_FEATURE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HAS_ASSOCIATIONS = IFC_EDGE_FEATURE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__OBJECT_TYPE = IFC_EDGE_FEATURE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__IS_DEFINED_BY = IFC_EDGE_FEATURE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__OBJECT_PLACEMENT = IFC_EDGE_FEATURE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__REPRESENTATION = IFC_EDGE_FEATURE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__REFERENCED_BY = IFC_EDGE_FEATURE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__GEOMETRY = IFC_EDGE_FEATURE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__TAG = IFC_EDGE_FEATURE__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HAS_STRUCTURAL_MEMBER = IFC_EDGE_FEATURE__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__FILLS_VOIDS = IFC_EDGE_FEATURE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__CONNECTED_TO = IFC_EDGE_FEATURE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HAS_COVERINGS = IFC_EDGE_FEATURE__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HAS_PROJECTIONS = IFC_EDGE_FEATURE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__REFERENCED_IN_STRUCTURES = IFC_EDGE_FEATURE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HAS_PORTS = IFC_EDGE_FEATURE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HAS_OPENINGS = IFC_EDGE_FEATURE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__IS_CONNECTION_REALIZATION = IFC_EDGE_FEATURE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__PROVIDES_BOUNDARIES = IFC_EDGE_FEATURE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__CONNECTED_FROM = IFC_EDGE_FEATURE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__CONTAINED_IN_STRUCTURE = IFC_EDGE_FEATURE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Voids Elements</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__VOIDS_ELEMENTS = IFC_EDGE_FEATURE__VOIDS_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Feature Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__FEATURE_LENGTH = IFC_EDGE_FEATURE__FEATURE_LENGTH;

	/**
	 * The feature id for the '<em><b>Feature Length As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__FEATURE_LENGTH_AS_STRING = IFC_EDGE_FEATURE__FEATURE_LENGTH_AS_STRING;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__WIDTH = IFC_EDGE_FEATURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__WIDTH_AS_STRING = IFC_EDGE_FEATURE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HEIGHT = IFC_EDGE_FEATURE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Height As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE__HEIGHT_AS_STRING = IFC_EDGE_FEATURE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Chamfer Edge Feature</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHAMFER_EDGE_FEATURE_FEATURE_COUNT = IFC_EDGE_FEATURE_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcChillerTypeImpl <em>Ifc Chiller Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcChillerTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcChillerType()
	 * @generated
	 */
	int IFC_CHILLER_TYPE = 74;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Chiller Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConicImpl <em>Ifc Conic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConicImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConic()
	 * @generated
	 */
	int IFC_CONIC = 98;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC__LAYER_ASSIGNMENTS = IFC_CURVE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC__STYLED_BY_ITEM = IFC_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC__DIM = IFC_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC__POSITION = IFC_CURVE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Conic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC_FEATURE_COUNT = IFC_CURVE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCircleImpl <em>Ifc Circle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCircleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCircle()
	 * @generated
	 */
	int IFC_CIRCLE = 75;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__LAYER_ASSIGNMENTS = IFC_CONIC__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__STYLED_BY_ITEM = IFC_CONIC__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__DIM = IFC_CONIC__DIM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__POSITION = IFC_CONIC__POSITION;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__RADIUS = IFC_CONIC_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__RADIUS_AS_STRING = IFC_CONIC_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Circle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_FEATURE_COUNT = IFC_CONIC_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCircleProfileDefImpl <em>Ifc Circle Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCircleProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCircleProfileDef()
	 * @generated
	 */
	int IFC_CIRCLE_PROFILE_DEF = 77;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Circle Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCircleHollowProfileDefImpl <em>Ifc Circle Hollow Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCircleHollowProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCircleHollowProfileDef()
	 * @generated
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF = 76;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__PROFILE_TYPE = IFC_CIRCLE_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__PROFILE_NAME = IFC_CIRCLE_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__POSITION = IFC_CIRCLE_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__RADIUS = IFC_CIRCLE_PROFILE_DEF__RADIUS;

	/**
	 * The feature id for the '<em><b>Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__RADIUS_AS_STRING = IFC_CIRCLE_PROFILE_DEF__RADIUS_AS_STRING;

	/**
	 * The feature id for the '<em><b>Wall Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__WALL_THICKNESS = IFC_CIRCLE_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Wall Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__WALL_THICKNESS_AS_STRING = IFC_CIRCLE_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Circle Hollow Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF_FEATURE_COUNT = IFC_CIRCLE_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcClassificationImpl <em>Ifc Classification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcClassificationImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcClassification()
	 * @generated
	 */
	int IFC_CLASSIFICATION = 78;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__SOURCE = 0;

	/**
	 * The feature id for the '<em><b>Edition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__EDITION = 1;

	/**
	 * The feature id for the '<em><b>Edition Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__EDITION_DATE = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__NAME = 3;

	/**
	 * The feature id for the '<em><b>Contains</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__CONTAINS = 4;

	/**
	 * The number of structural features of the '<em>Ifc Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcClassificationItemImpl <em>Ifc Classification Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcClassificationItemImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcClassificationItem()
	 * @generated
	 */
	int IFC_CLASSIFICATION_ITEM = 79;

	/**
	 * The feature id for the '<em><b>Notation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM__NOTATION = 0;

	/**
	 * The feature id for the '<em><b>Item Of</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM__ITEM_OF = 1;

	/**
	 * The feature id for the '<em><b>Title</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM__TITLE = 2;

	/**
	 * The feature id for the '<em><b>Is Classified Item In</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM__IS_CLASSIFIED_ITEM_IN = 3;

	/**
	 * The feature id for the '<em><b>Is Classifying Item In</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM__IS_CLASSIFYING_ITEM_IN = 4;

	/**
	 * The number of structural features of the '<em>Ifc Classification Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcClassificationItemRelationshipImpl <em>Ifc Classification Item Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcClassificationItemRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcClassificationItemRelationship()
	 * @generated
	 */
	int IFC_CLASSIFICATION_ITEM_RELATIONSHIP = 80;

	/**
	 * The feature id for the '<em><b>Relating Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM_RELATIONSHIP__RELATING_ITEM = 0;

	/**
	 * The feature id for the '<em><b>Related Items</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM_RELATIONSHIP__RELATED_ITEMS = 1;

	/**
	 * The number of structural features of the '<em>Ifc Classification Item Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_ITEM_RELATIONSHIP_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcClassificationNotationSelect <em>Ifc Classification Notation Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcClassificationNotationSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcClassificationNotationSelect()
	 * @generated
	 */
	int IFC_CLASSIFICATION_NOTATION_SELECT = 776;

	/**
	 * The number of structural features of the '<em>Ifc Classification Notation Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_NOTATION_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcClassificationNotationImpl <em>Ifc Classification Notation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcClassificationNotationImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcClassificationNotation()
	 * @generated
	 */
	int IFC_CLASSIFICATION_NOTATION = 81;

	/**
	 * The feature id for the '<em><b>Notation Facets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_NOTATION__NOTATION_FACETS = IFC_CLASSIFICATION_NOTATION_SELECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Classification Notation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_NOTATION_FEATURE_COUNT = IFC_CLASSIFICATION_NOTATION_SELECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcClassificationNotationFacetImpl <em>Ifc Classification Notation Facet</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcClassificationNotationFacetImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcClassificationNotationFacet()
	 * @generated
	 */
	int IFC_CLASSIFICATION_NOTATION_FACET = 82;

	/**
	 * The feature id for the '<em><b>Notation Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_NOTATION_FACET__NOTATION_VALUE = 0;

	/**
	 * The number of structural features of the '<em>Ifc Classification Notation Facet</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_NOTATION_FACET_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcLightDistributionDataSourceSelect <em>Ifc Light Distribution Data Source Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcLightDistributionDataSourceSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcLightDistributionDataSourceSelect()
	 * @generated
	 */
	int IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT = 795;

	/**
	 * The number of structural features of the '<em>Ifc Light Distribution Data Source Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcExternalReferenceImpl <em>Ifc External Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcExternalReferenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcExternalReference()
	 * @generated
	 */
	int IFC_EXTERNAL_REFERENCE = 213;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE__LOCATION = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Item Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE__ITEM_REFERENCE = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE__NAME = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc External Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE_FEATURE_COUNT = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcClassificationReferenceImpl <em>Ifc Classification Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcClassificationReferenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcClassificationReference()
	 * @generated
	 */
	int IFC_CLASSIFICATION_REFERENCE = 83;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__LOCATION = IFC_EXTERNAL_REFERENCE__LOCATION;

	/**
	 * The feature id for the '<em><b>Item Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__ITEM_REFERENCE = IFC_EXTERNAL_REFERENCE__ITEM_REFERENCE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__NAME = IFC_EXTERNAL_REFERENCE__NAME;

	/**
	 * The feature id for the '<em><b>Referenced Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__REFERENCED_SOURCE = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Classification Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE_FEATURE_COUNT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcTopologicalRepresentationItemImpl <em>Ifc Topological Representation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcTopologicalRepresentationItemImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcTopologicalRepresentationItem()
	 * @generated
	 */
	int IFC_TOPOLOGICAL_REPRESENTATION_ITEM = 616;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS = IFC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM = IFC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Topological Representation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT = IFC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConnectedFaceSetImpl <em>Ifc Connected Face Set</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConnectedFaceSetImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConnectedFaceSet()
	 * @generated
	 */
	int IFC_CONNECTED_FACE_SET = 99;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTED_FACE_SET__LAYER_ASSIGNMENTS = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTED_FACE_SET__STYLED_BY_ITEM = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Cfs Faces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTED_FACE_SET__CFS_FACES = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Connected Face Set</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTED_FACE_SET_FEATURE_COUNT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcClosedShellImpl <em>Ifc Closed Shell</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcClosedShellImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcClosedShell()
	 * @generated
	 */
	int IFC_CLOSED_SHELL = 84;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLOSED_SHELL__LAYER_ASSIGNMENTS = IFC_CONNECTED_FACE_SET__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLOSED_SHELL__STYLED_BY_ITEM = IFC_CONNECTED_FACE_SET__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Cfs Faces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLOSED_SHELL__CFS_FACES = IFC_CONNECTED_FACE_SET__CFS_FACES;

	/**
	 * The number of structural features of the '<em>Ifc Closed Shell</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLOSED_SHELL_FEATURE_COUNT = IFC_CONNECTED_FACE_SET_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCoilTypeImpl <em>Ifc Coil Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCoilTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCoilType()
	 * @generated
	 */
	int IFC_COIL_TYPE = 85;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Coil Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcFillStyleSelect <em>Ifc Fill Style Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcFillStyleSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFillStyleSelect()
	 * @generated
	 */
	int IFC_FILL_STYLE_SELECT = 790;

	/**
	 * The number of structural features of the '<em>Ifc Fill Style Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_STYLE_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcColour <em>Ifc Colour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcColour
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcColour()
	 * @generated
	 */
	int IFC_COLOUR = 777;

	/**
	 * The number of structural features of the '<em>Ifc Colour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_FEATURE_COUNT = IFC_FILL_STYLE_SELECT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcColourSpecificationImpl <em>Ifc Colour Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcColourSpecificationImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcColourSpecification()
	 * @generated
	 */
	int IFC_COLOUR_SPECIFICATION = 87;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_SPECIFICATION__NAME = IFC_COLOUR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Colour Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_SPECIFICATION_FEATURE_COUNT = IFC_COLOUR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcColourRgbImpl <em>Ifc Colour Rgb</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcColourRgbImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcColourRgb()
	 * @generated
	 */
	int IFC_COLOUR_RGB = 86;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__NAME = IFC_COLOUR_SPECIFICATION__NAME;

	/**
	 * The feature id for the '<em><b>Red</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__RED = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Red As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__RED_AS_STRING = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Green</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__GREEN = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Green As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__GREEN_AS_STRING = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Blue</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__BLUE = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Blue As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__BLUE_AS_STRING = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Colour Rgb</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB_FEATURE_COUNT = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcColumnImpl <em>Ifc Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcColumnImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcColumn()
	 * @generated
	 */
	int IFC_COLUMN = 88;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_STRUCTURAL_MEMBER = IFC_BUILDING_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_PORTS = IFC_BUILDING_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcColumnTypeImpl <em>Ifc Column Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcColumnTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcColumnType()
	 * @generated
	 */
	int IFC_COLUMN_TYPE = 89;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__OBJECT_TYPE_OF = IFC_BUILDING_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Column Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPropertyImpl <em>Ifc Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPropertyImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcProperty()
	 * @generated
	 */
	int IFC_PROPERTY = 396;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Property For Dependance</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__PROPERTY_FOR_DEPENDANCE = 2;

	/**
	 * The feature id for the '<em><b>Property Depends On</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__PROPERTY_DEPENDS_ON = 3;

	/**
	 * The feature id for the '<em><b>Part Of Complex</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__PART_OF_COMPLEX = 4;

	/**
	 * The number of structural features of the '<em>Ifc Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcComplexPropertyImpl <em>Ifc Complex Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcComplexPropertyImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcComplexProperty()
	 * @generated
	 */
	int IFC_COMPLEX_PROPERTY = 90;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__NAME = IFC_PROPERTY__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__DESCRIPTION = IFC_PROPERTY__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Property For Dependance</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__PROPERTY_FOR_DEPENDANCE = IFC_PROPERTY__PROPERTY_FOR_DEPENDANCE;

	/**
	 * The feature id for the '<em><b>Property Depends On</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__PROPERTY_DEPENDS_ON = IFC_PROPERTY__PROPERTY_DEPENDS_ON;

	/**
	 * The feature id for the '<em><b>Part Of Complex</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__PART_OF_COMPLEX = IFC_PROPERTY__PART_OF_COMPLEX;

	/**
	 * The feature id for the '<em><b>Usage Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__USAGE_NAME = IFC_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__HAS_PROPERTIES = IFC_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Complex Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_FEATURE_COUNT = IFC_PROPERTY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCompositeCurveSegmentImpl <em>Ifc Composite Curve Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCompositeCurveSegmentImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCompositeCurveSegment()
	 * @generated
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT = 92;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Transition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__TRANSITION = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Same Sense</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__SAME_SENSE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parent Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__PARENT_CURVE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Using Curves</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__USING_CURVES = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Composite Curve Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCompositeProfileDefImpl <em>Ifc Composite Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCompositeProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCompositeProfileDef()
	 * @generated
	 */
	int IFC_COMPOSITE_PROFILE_DEF = 93;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Profiles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__PROFILES = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__LABEL = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Composite Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowMovingDeviceTypeImpl <em>Ifc Flow Moving Device Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowMovingDeviceTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowMovingDeviceType()
	 * @generated
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE = 246;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Moving Device Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCompressorTypeImpl <em>Ifc Compressor Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCompressorTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCompressorType()
	 * @generated
	 */
	int IFC_COMPRESSOR_TYPE = 94;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__GLOBAL_ID = IFC_FLOW_MOVING_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__OWNER_HISTORY = IFC_FLOW_MOVING_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__NAME = IFC_FLOW_MOVING_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__DESCRIPTION = IFC_FLOW_MOVING_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_MOVING_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__DECOMPOSES = IFC_FLOW_MOVING_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_MOVING_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__OBJECT_TYPE_OF = IFC_FLOW_MOVING_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__REPRESENTATION_MAPS = IFC_FLOW_MOVING_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__TAG = IFC_FLOW_MOVING_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__ELEMENT_TYPE = IFC_FLOW_MOVING_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__PREDEFINED_TYPE = IFC_FLOW_MOVING_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Compressor Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE_FEATURE_COUNT = IFC_FLOW_MOVING_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCondenserTypeImpl <em>Ifc Condenser Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCondenserTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCondenserType()
	 * @generated
	 */
	int IFC_CONDENSER_TYPE = 95;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Condenser Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConditionImpl <em>Ifc Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConditionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCondition()
	 * @generated
	 */
	int IFC_CONDITION = 96;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__GLOBAL_ID = IFC_GROUP__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__OWNER_HISTORY = IFC_GROUP__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__NAME = IFC_GROUP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__DESCRIPTION = IFC_GROUP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__HAS_ASSIGNMENTS = IFC_GROUP__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__IS_DECOMPOSED_BY = IFC_GROUP__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__DECOMPOSES = IFC_GROUP__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__HAS_ASSOCIATIONS = IFC_GROUP__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__OBJECT_TYPE = IFC_GROUP__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__IS_DEFINED_BY = IFC_GROUP__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION__IS_GROUPED_BY = IFC_GROUP__IS_GROUPED_BY;

	/**
	 * The number of structural features of the '<em>Ifc Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_FEATURE_COUNT = IFC_GROUP_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConditionCriterionImpl <em>Ifc Condition Criterion</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConditionCriterionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConditionCriterion()
	 * @generated
	 */
	int IFC_CONDITION_CRITERION = 97;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__GLOBAL_ID = IFC_CONTROL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__OWNER_HISTORY = IFC_CONTROL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__NAME = IFC_CONTROL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__DESCRIPTION = IFC_CONTROL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__HAS_ASSIGNMENTS = IFC_CONTROL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__IS_DECOMPOSED_BY = IFC_CONTROL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__DECOMPOSES = IFC_CONTROL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__HAS_ASSOCIATIONS = IFC_CONTROL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__OBJECT_TYPE = IFC_CONTROL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__IS_DEFINED_BY = IFC_CONTROL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__CONTROLS = IFC_CONTROL__CONTROLS;

	/**
	 * The feature id for the '<em><b>Criterion</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__CRITERION = IFC_CONTROL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Criterion Date Time</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION__CRITERION_DATE_TIME = IFC_CONTROL_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Condition Criterion</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDITION_CRITERION_FEATURE_COUNT = IFC_CONTROL_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConnectionGeometryImpl <em>Ifc Connection Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConnectionGeometryImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConnectionGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_GEOMETRY = 101;

	/**
	 * The number of structural features of the '<em>Ifc Connection Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_GEOMETRY_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConnectionCurveGeometryImpl <em>Ifc Connection Curve Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConnectionCurveGeometryImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConnectionCurveGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_CURVE_GEOMETRY = 100;

	/**
	 * The feature id for the '<em><b>Curve On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_CURVE_GEOMETRY__CURVE_ON_RELATING_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Curve On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_CURVE_GEOMETRY__CURVE_ON_RELATED_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Connection Curve Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_CURVE_GEOMETRY_FEATURE_COUNT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConnectionPointGeometryImpl <em>Ifc Connection Point Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConnectionPointGeometryImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConnectionPointGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_POINT_GEOMETRY = 103;

	/**
	 * The feature id for the '<em><b>Point On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_GEOMETRY__POINT_ON_RELATING_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Point On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_GEOMETRY__POINT_ON_RELATED_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Connection Point Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConnectionPointEccentricityImpl <em>Ifc Connection Point Eccentricity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConnectionPointEccentricityImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConnectionPointEccentricity()
	 * @generated
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY = 102;

	/**
	 * The feature id for the '<em><b>Point On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__POINT_ON_RELATING_ELEMENT = IFC_CONNECTION_POINT_GEOMETRY__POINT_ON_RELATING_ELEMENT;

	/**
	 * The feature id for the '<em><b>Point On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__POINT_ON_RELATED_ELEMENT = IFC_CONNECTION_POINT_GEOMETRY__POINT_ON_RELATED_ELEMENT;

	/**
	 * The feature id for the '<em><b>Eccentricity In X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_X = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Eccentricity In XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_XAS_STRING = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Eccentricity In Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_Y = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Eccentricity In YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_YAS_STRING = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Eccentricity In Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_Z = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Eccentricity In ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_ZAS_STRING = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Connection Point Eccentricity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY_FEATURE_COUNT = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConnectionPortGeometryImpl <em>Ifc Connection Port Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConnectionPortGeometryImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConnectionPortGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_PORT_GEOMETRY = 104;

	/**
	 * The feature id for the '<em><b>Location At Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_PORT_GEOMETRY__LOCATION_AT_RELATING_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Location At Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_PORT_GEOMETRY__LOCATION_AT_RELATED_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Profile Of Port</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_PORT_GEOMETRY__PROFILE_OF_PORT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Connection Port Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_PORT_GEOMETRY_FEATURE_COUNT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConnectionSurfaceGeometryImpl <em>Ifc Connection Surface Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConnectionSurfaceGeometryImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConnectionSurfaceGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_SURFACE_GEOMETRY = 105;

	/**
	 * The feature id for the '<em><b>Surface On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_SURFACE_GEOMETRY__SURFACE_ON_RELATING_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Surface On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_SURFACE_GEOMETRY__SURFACE_ON_RELATED_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Connection Surface Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_SURFACE_GEOMETRY_FEATURE_COUNT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConstraintImpl <em>Ifc Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConstraintImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConstraint()
	 * @generated
	 */
	int IFC_CONSTRAINT = 106;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Constraint Grade</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CONSTRAINT_GRADE = 2;

	/**
	 * The feature id for the '<em><b>Constraint Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CONSTRAINT_SOURCE = 3;

	/**
	 * The feature id for the '<em><b>Creating Actor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CREATING_ACTOR = 4;

	/**
	 * The feature id for the '<em><b>Creation Time</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CREATION_TIME = 5;

	/**
	 * The feature id for the '<em><b>User Defined Grade</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__USER_DEFINED_GRADE = 6;

	/**
	 * The feature id for the '<em><b>Classified As</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CLASSIFIED_AS = 7;

	/**
	 * The feature id for the '<em><b>Relates Constraints</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__RELATES_CONSTRAINTS = 8;

	/**
	 * The feature id for the '<em><b>Is Related With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__IS_RELATED_WITH = 9;

	/**
	 * The feature id for the '<em><b>Properties For Constraint</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__PROPERTIES_FOR_CONSTRAINT = 10;

	/**
	 * The feature id for the '<em><b>Aggregates</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__AGGREGATES = 11;

	/**
	 * The feature id for the '<em><b>Is Aggregated In</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__IS_AGGREGATED_IN = 12;

	/**
	 * The number of structural features of the '<em>Ifc Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_FEATURE_COUNT = 13;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConstraintAggregationRelationshipImpl <em>Ifc Constraint Aggregation Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConstraintAggregationRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConstraintAggregationRelationship()
	 * @generated
	 */
	int IFC_CONSTRAINT_AGGREGATION_RELATIONSHIP = 107;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_AGGREGATION_RELATIONSHIP__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_AGGREGATION_RELATIONSHIP__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Relating Constraint</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_AGGREGATION_RELATIONSHIP__RELATING_CONSTRAINT = 2;

	/**
	 * The feature id for the '<em><b>Related Constraints</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_AGGREGATION_RELATIONSHIP__RELATED_CONSTRAINTS = 3;

	/**
	 * The feature id for the '<em><b>Logical Aggregator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_AGGREGATION_RELATIONSHIP__LOGICAL_AGGREGATOR = 4;

	/**
	 * The number of structural features of the '<em>Ifc Constraint Aggregation Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_AGGREGATION_RELATIONSHIP_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConstraintClassificationRelationshipImpl <em>Ifc Constraint Classification Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConstraintClassificationRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConstraintClassificationRelationship()
	 * @generated
	 */
	int IFC_CONSTRAINT_CLASSIFICATION_RELATIONSHIP = 108;

	/**
	 * The feature id for the '<em><b>Classified Constraint</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_CLASSIFICATION_RELATIONSHIP__CLASSIFIED_CONSTRAINT = 0;

	/**
	 * The feature id for the '<em><b>Related Classifications</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_CLASSIFICATION_RELATIONSHIP__RELATED_CLASSIFICATIONS = 1;

	/**
	 * The number of structural features of the '<em>Ifc Constraint Classification Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_CLASSIFICATION_RELATIONSHIP_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConstraintRelationshipImpl <em>Ifc Constraint Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConstraintRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConstraintRelationship()
	 * @generated
	 */
	int IFC_CONSTRAINT_RELATIONSHIP = 109;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_RELATIONSHIP__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_RELATIONSHIP__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Relating Constraint</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_RELATIONSHIP__RELATING_CONSTRAINT = 2;

	/**
	 * The feature id for the '<em><b>Related Constraints</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_RELATIONSHIP__RELATED_CONSTRAINTS = 3;

	/**
	 * The number of structural features of the '<em>Ifc Constraint Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_RELATIONSHIP_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcResourceImpl <em>Ifc Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcResourceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcResource()
	 * @generated
	 */
	int IFC_RESOURCE = 491;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__RESOURCE_OF = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConstructionResourceImpl <em>Ifc Construction Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConstructionResourceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConstructionResource()
	 * @generated
	 */
	int IFC_CONSTRUCTION_RESOURCE = 113;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID = IFC_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY = IFC_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__NAME = IFC_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__DESCRIPTION = IFC_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS = IFC_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY = IFC_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__DECOMPOSES = IFC_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS = IFC_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE = IFC_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY = IFC_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF = IFC_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Resource Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__RESOURCE_IDENTIFIER = IFC_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Resource Group</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__RESOURCE_GROUP = IFC_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Resource Consumption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__RESOURCE_CONSUMPTION = IFC_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY = IFC_RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Construction Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT = IFC_RESOURCE_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConstructionEquipmentResourceImpl <em>Ifc Construction Equipment Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConstructionEquipmentResourceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConstructionEquipmentResource()
	 * @generated
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE = 110;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__NAME = IFC_CONSTRUCTION_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__OBJECT_TYPE = IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__IS_DEFINED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Resource Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__RESOURCE_IDENTIFIER = IFC_CONSTRUCTION_RESOURCE__RESOURCE_IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Resource Group</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__RESOURCE_GROUP = IFC_CONSTRUCTION_RESOURCE__RESOURCE_GROUP;

	/**
	 * The feature id for the '<em><b>Resource Consumption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__RESOURCE_CONSUMPTION = IFC_CONSTRUCTION_RESOURCE__RESOURCE_CONSUMPTION;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY;

	/**
	 * The number of structural features of the '<em>Ifc Construction Equipment Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConstructionMaterialResourceImpl <em>Ifc Construction Material Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConstructionMaterialResourceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConstructionMaterialResource()
	 * @generated
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE = 111;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__NAME = IFC_CONSTRUCTION_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__OBJECT_TYPE = IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__IS_DEFINED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Resource Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__RESOURCE_IDENTIFIER = IFC_CONSTRUCTION_RESOURCE__RESOURCE_IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Resource Group</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__RESOURCE_GROUP = IFC_CONSTRUCTION_RESOURCE__RESOURCE_GROUP;

	/**
	 * The feature id for the '<em><b>Resource Consumption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__RESOURCE_CONSUMPTION = IFC_CONSTRUCTION_RESOURCE__RESOURCE_CONSUMPTION;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Suppliers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__SUPPLIERS = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Usage Ratio</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__USAGE_RATIO = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Usage Ratio As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__USAGE_RATIO_AS_STRING = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Construction Material Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConstructionProductResourceImpl <em>Ifc Construction Product Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConstructionProductResourceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConstructionProductResource()
	 * @generated
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE = 112;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__NAME = IFC_CONSTRUCTION_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__OBJECT_TYPE = IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__IS_DEFINED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Resource Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__RESOURCE_IDENTIFIER = IFC_CONSTRUCTION_RESOURCE__RESOURCE_IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Resource Group</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__RESOURCE_GROUP = IFC_CONSTRUCTION_RESOURCE__RESOURCE_GROUP;

	/**
	 * The feature id for the '<em><b>Resource Consumption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__RESOURCE_CONSUMPTION = IFC_CONSTRUCTION_RESOURCE__RESOURCE_CONSUMPTION;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY;

	/**
	 * The number of structural features of the '<em>Ifc Construction Product Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcUnit <em>Ifc Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcUnit
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcUnit()
	 * @generated
	 */
	int IFC_UNIT = 814;

	/**
	 * The number of structural features of the '<em>Ifc Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_UNIT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcNamedUnitImpl <em>Ifc Named Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcNamedUnitImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcNamedUnit()
	 * @generated
	 */
	int IFC_NAMED_UNIT = 325;

	/**
	 * The feature id for the '<em><b>Dimensions</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_NAMED_UNIT__DIMENSIONS = IFC_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_NAMED_UNIT__UNIT_TYPE = IFC_UNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Named Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_NAMED_UNIT_FEATURE_COUNT = IFC_UNIT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcContextDependentUnitImpl <em>Ifc Context Dependent Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcContextDependentUnitImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcContextDependentUnit()
	 * @generated
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT = 114;

	/**
	 * The feature id for the '<em><b>Dimensions</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT__DIMENSIONS = IFC_NAMED_UNIT__DIMENSIONS;

	/**
	 * The feature id for the '<em><b>Unit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT__UNIT_TYPE = IFC_NAMED_UNIT__UNIT_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT__NAME = IFC_NAMED_UNIT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Context Dependent Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT_FEATURE_COUNT = IFC_NAMED_UNIT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcControllerTypeImpl <em>Ifc Controller Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcControllerTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcControllerType()
	 * @generated
	 */
	int IFC_CONTROLLER_TYPE = 116;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Controller Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcConversionBasedUnitImpl <em>Ifc Conversion Based Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcConversionBasedUnitImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcConversionBasedUnit()
	 * @generated
	 */
	int IFC_CONVERSION_BASED_UNIT = 117;

	/**
	 * The feature id for the '<em><b>Dimensions</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__DIMENSIONS = IFC_NAMED_UNIT__DIMENSIONS;

	/**
	 * The feature id for the '<em><b>Unit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__UNIT_TYPE = IFC_NAMED_UNIT__UNIT_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__NAME = IFC_NAMED_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Conversion Factor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__CONVERSION_FACTOR = IFC_NAMED_UNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Conversion Based Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_FEATURE_COUNT = IFC_NAMED_UNIT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCooledBeamTypeImpl <em>Ifc Cooled Beam Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCooledBeamTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCooledBeamType()
	 * @generated
	 */
	int IFC_COOLED_BEAM_TYPE = 118;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cooled Beam Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCoolingTowerTypeImpl <em>Ifc Cooling Tower Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCoolingTowerTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCoolingTowerType()
	 * @generated
	 */
	int IFC_COOLING_TOWER_TYPE = 119;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cooling Tower Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCoordinatedUniversalTimeOffsetImpl <em>Ifc Coordinated Universal Time Offset</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCoordinatedUniversalTimeOffsetImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCoordinatedUniversalTimeOffset()
	 * @generated
	 */
	int IFC_COORDINATED_UNIVERSAL_TIME_OFFSET = 120;

	/**
	 * The feature id for the '<em><b>Hour Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATED_UNIVERSAL_TIME_OFFSET__HOUR_OFFSET = 0;

	/**
	 * The feature id for the '<em><b>Minute Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATED_UNIVERSAL_TIME_OFFSET__MINUTE_OFFSET = 1;

	/**
	 * The feature id for the '<em><b>Sense</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATED_UNIVERSAL_TIME_OFFSET__SENSE = 2;

	/**
	 * The number of structural features of the '<em>Ifc Coordinated Universal Time Offset</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATED_UNIVERSAL_TIME_OFFSET_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCostItemImpl <em>Ifc Cost Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCostItemImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCostItem()
	 * @generated
	 */
	int IFC_COST_ITEM = 121;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__GLOBAL_ID = IFC_CONTROL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__OWNER_HISTORY = IFC_CONTROL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__NAME = IFC_CONTROL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__DESCRIPTION = IFC_CONTROL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__HAS_ASSIGNMENTS = IFC_CONTROL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__IS_DECOMPOSED_BY = IFC_CONTROL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__DECOMPOSES = IFC_CONTROL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__HAS_ASSOCIATIONS = IFC_CONTROL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__OBJECT_TYPE = IFC_CONTROL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__IS_DEFINED_BY = IFC_CONTROL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__CONTROLS = IFC_CONTROL__CONTROLS;

	/**
	 * The number of structural features of the '<em>Ifc Cost Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM_FEATURE_COUNT = IFC_CONTROL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCostScheduleImpl <em>Ifc Cost Schedule</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCostScheduleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCostSchedule()
	 * @generated
	 */
	int IFC_COST_SCHEDULE = 122;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__GLOBAL_ID = IFC_CONTROL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__OWNER_HISTORY = IFC_CONTROL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__NAME = IFC_CONTROL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__DESCRIPTION = IFC_CONTROL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__HAS_ASSIGNMENTS = IFC_CONTROL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__IS_DECOMPOSED_BY = IFC_CONTROL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__DECOMPOSES = IFC_CONTROL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__HAS_ASSOCIATIONS = IFC_CONTROL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__OBJECT_TYPE = IFC_CONTROL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__IS_DEFINED_BY = IFC_CONTROL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__CONTROLS = IFC_CONTROL__CONTROLS;

	/**
	 * The feature id for the '<em><b>Submitted By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__SUBMITTED_BY = IFC_CONTROL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Prepared By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__PREPARED_BY = IFC_CONTROL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Submitted On</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__SUBMITTED_ON = IFC_CONTROL_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__STATUS = IFC_CONTROL_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Target Users</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__TARGET_USERS = IFC_CONTROL_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Update Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__UPDATE_DATE = IFC_CONTROL_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__ID = IFC_CONTROL_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__PREDEFINED_TYPE = IFC_CONTROL_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Ifc Cost Schedule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE_FEATURE_COUNT = IFC_CONTROL_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCostValueImpl <em>Ifc Cost Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCostValueImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCostValue()
	 * @generated
	 */
	int IFC_COST_VALUE = 123;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__NAME = IFC_APPLIED_VALUE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__DESCRIPTION = IFC_APPLIED_VALUE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Applied Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__APPLIED_VALUE = IFC_APPLIED_VALUE__APPLIED_VALUE;

	/**
	 * The feature id for the '<em><b>Unit Basis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__UNIT_BASIS = IFC_APPLIED_VALUE__UNIT_BASIS;

	/**
	 * The feature id for the '<em><b>Applicable Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__APPLICABLE_DATE = IFC_APPLIED_VALUE__APPLICABLE_DATE;

	/**
	 * The feature id for the '<em><b>Fixed Until Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__FIXED_UNTIL_DATE = IFC_APPLIED_VALUE__FIXED_UNTIL_DATE;

	/**
	 * The feature id for the '<em><b>Values Referenced</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__VALUES_REFERENCED = IFC_APPLIED_VALUE__VALUES_REFERENCED;

	/**
	 * The feature id for the '<em><b>Value Of Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__VALUE_OF_COMPONENTS = IFC_APPLIED_VALUE__VALUE_OF_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Is Component In</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__IS_COMPONENT_IN = IFC_APPLIED_VALUE__IS_COMPONENT_IN;

	/**
	 * The feature id for the '<em><b>Cost Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__COST_TYPE = IFC_APPLIED_VALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__CONDITION = IFC_APPLIED_VALUE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Cost Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE_FEATURE_COUNT = IFC_APPLIED_VALUE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCoveringImpl <em>Ifc Covering</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCoveringImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCovering()
	 * @generated
	 */
	int IFC_COVERING = 124;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_STRUCTURAL_MEMBER = IFC_BUILDING_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_PORTS = IFC_BUILDING_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Covers Spaces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__COVERS_SPACES = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Covers</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__COVERS = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Covering</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCoveringTypeImpl <em>Ifc Covering Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCoveringTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCoveringType()
	 * @generated
	 */
	int IFC_COVERING_TYPE = 125;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__OBJECT_TYPE_OF = IFC_BUILDING_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Covering Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCraneRailAShapeProfileDefImpl <em>Ifc Crane Rail AShape Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCraneRailAShapeProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCraneRailAShapeProfileDef()
	 * @generated
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF = 126;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Overall Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__OVERALL_HEIGHT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overall Height As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__OVERALL_HEIGHT_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Base Width2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_WIDTH2 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Base Width2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_WIDTH2_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Head Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__HEAD_WIDTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Head Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__HEAD_WIDTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Head Depth2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__HEAD_DEPTH2 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Head Depth2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__HEAD_DEPTH2_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Head Depth3</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__HEAD_DEPTH3 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Head Depth3 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__HEAD_DEPTH3_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Web Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__WEB_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Web Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__WEB_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Base Width4</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_WIDTH4 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Base Width4 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_WIDTH4_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Base Depth1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_DEPTH1 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Base Depth1 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_DEPTH1_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Base Depth2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_DEPTH2 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Base Depth2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_DEPTH2_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Base Depth3</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_DEPTH3 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Base Depth3 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__BASE_DEPTH3_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Centre Of Gravity In Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__CENTRE_OF_GRAVITY_IN_Y = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Centre Of Gravity In YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF__CENTRE_OF_GRAVITY_IN_YAS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 23;

	/**
	 * The number of structural features of the '<em>Ifc Crane Rail AShape Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_ASHAPE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 24;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCraneRailFShapeProfileDefImpl <em>Ifc Crane Rail FShape Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCraneRailFShapeProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCraneRailFShapeProfileDef()
	 * @generated
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF = 127;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Overall Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__OVERALL_HEIGHT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overall Height As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__OVERALL_HEIGHT_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Head Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__HEAD_WIDTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Head Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__HEAD_WIDTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Head Depth2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__HEAD_DEPTH2 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Head Depth2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__HEAD_DEPTH2_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Head Depth3</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__HEAD_DEPTH3 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Head Depth3 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__HEAD_DEPTH3_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Web Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__WEB_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Web Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__WEB_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Base Depth1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__BASE_DEPTH1 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Base Depth1 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__BASE_DEPTH1_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Base Depth2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__BASE_DEPTH2 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Base Depth2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__BASE_DEPTH2_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Centre Of Gravity In Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__CENTRE_OF_GRAVITY_IN_Y = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Centre Of Gravity In YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF__CENTRE_OF_GRAVITY_IN_YAS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 17;

	/**
	 * The number of structural features of the '<em>Ifc Crane Rail FShape Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CRANE_RAIL_FSHAPE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 18;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCrewResourceImpl <em>Ifc Crew Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCrewResourceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCrewResource()
	 * @generated
	 */
	int IFC_CREW_RESOURCE = 128;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__NAME = IFC_CONSTRUCTION_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__OBJECT_TYPE = IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__IS_DEFINED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Resource Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__RESOURCE_IDENTIFIER = IFC_CONSTRUCTION_RESOURCE__RESOURCE_IDENTIFIER;

	/**
	 * The feature id for the '<em><b>Resource Group</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__RESOURCE_GROUP = IFC_CONSTRUCTION_RESOURCE__RESOURCE_GROUP;

	/**
	 * The feature id for the '<em><b>Resource Consumption</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__RESOURCE_CONSUMPTION = IFC_CONSTRUCTION_RESOURCE__RESOURCE_CONSUMPTION;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY;

	/**
	 * The number of structural features of the '<em>Ifc Crew Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcSolidModelImpl <em>Ifc Solid Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcSolidModelImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcSolidModel()
	 * @generated
	 */
	int IFC_SOLID_MODEL = 518;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SOLID_MODEL__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SOLID_MODEL__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SOLID_MODEL__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Solid Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SOLID_MODEL_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCsgSolidImpl <em>Ifc Csg Solid</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCsgSolidImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCsgSolid()
	 * @generated
	 */
	int IFC_CSG_SOLID = 130;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID__LAYER_ASSIGNMENTS = IFC_SOLID_MODEL__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID__STYLED_BY_ITEM = IFC_SOLID_MODEL__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID__DIM = IFC_SOLID_MODEL__DIM;

	/**
	 * The feature id for the '<em><b>Tree Root Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID__TREE_ROOT_EXPRESSION = IFC_SOLID_MODEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Csg Solid</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID_FEATURE_COUNT = IFC_SOLID_MODEL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurrencyRelationshipImpl <em>Ifc Currency Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurrencyRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurrencyRelationship()
	 * @generated
	 */
	int IFC_CURRENCY_RELATIONSHIP = 131;

	/**
	 * The feature id for the '<em><b>Relating Monetary Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__RELATING_MONETARY_UNIT = 0;

	/**
	 * The feature id for the '<em><b>Related Monetary Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__RELATED_MONETARY_UNIT = 1;

	/**
	 * The feature id for the '<em><b>Exchange Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__EXCHANGE_RATE = 2;

	/**
	 * The feature id for the '<em><b>Exchange Rate As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__EXCHANGE_RATE_AS_STRING = 3;

	/**
	 * The feature id for the '<em><b>Rate Date Time</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__RATE_DATE_TIME = 4;

	/**
	 * The feature id for the '<em><b>Rate Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__RATE_SOURCE = 5;

	/**
	 * The number of structural features of the '<em>Ifc Currency Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurtainWallImpl <em>Ifc Curtain Wall</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurtainWallImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurtainWall()
	 * @generated
	 */
	int IFC_CURTAIN_WALL = 132;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_STRUCTURAL_MEMBER = IFC_BUILDING_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_PORTS = IFC_BUILDING_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Curtain Wall</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurtainWallTypeImpl <em>Ifc Curtain Wall Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurtainWallTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurtainWallType()
	 * @generated
	 */
	int IFC_CURTAIN_WALL_TYPE = 133;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__OBJECT_TYPE_OF = IFC_BUILDING_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Curtain Wall Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurveBoundedPlaneImpl <em>Ifc Curve Bounded Plane</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurveBoundedPlaneImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurveBoundedPlane()
	 * @generated
	 */
	int IFC_CURVE_BOUNDED_PLANE = 135;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_BOUNDED_PLANE__LAYER_ASSIGNMENTS = IFC_BOUNDED_SURFACE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_BOUNDED_PLANE__STYLED_BY_ITEM = IFC_BOUNDED_SURFACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Basis Surface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_BOUNDED_PLANE__BASIS_SURFACE = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Outer Boundary</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_BOUNDED_PLANE__OUTER_BOUNDARY = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Inner Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_BOUNDED_PLANE__INNER_BOUNDARIES = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_BOUNDED_PLANE__DIM = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Curve Bounded Plane</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_BOUNDED_PLANE_FEATURE_COUNT = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPresentationStyleImpl <em>Ifc Presentation Style</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPresentationStyleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPresentationStyle()
	 * @generated
	 */
	int IFC_PRESENTATION_STYLE = 381;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRESENTATION_STYLE__NAME = 0;

	/**
	 * The number of structural features of the '<em>Ifc Presentation Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRESENTATION_STYLE_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurveStyleImpl <em>Ifc Curve Style</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurveStyleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurveStyle()
	 * @generated
	 */
	int IFC_CURVE_STYLE = 136;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE__NAME = IFC_PRESENTATION_STYLE__NAME;

	/**
	 * The feature id for the '<em><b>Curve Font</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE__CURVE_FONT = IFC_PRESENTATION_STYLE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Curve Width</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE__CURVE_WIDTH = IFC_PRESENTATION_STYLE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Curve Colour</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE__CURVE_COLOUR = IFC_PRESENTATION_STYLE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Curve Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FEATURE_COUNT = IFC_PRESENTATION_STYLE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcCurveFontOrScaledCurveFontSelect <em>Ifc Curve Font Or Scaled Curve Font Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcCurveFontOrScaledCurveFontSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurveFontOrScaledCurveFontSelect()
	 * @generated
	 */
	int IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT = 781;

	/**
	 * The number of structural features of the '<em>Ifc Curve Font Or Scaled Curve Font Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcCurveStyleFontSelect <em>Ifc Curve Style Font Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcCurveStyleFontSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurveStyleFontSelect()
	 * @generated
	 */
	int IFC_CURVE_STYLE_FONT_SELECT = 783;

	/**
	 * The number of structural features of the '<em>Ifc Curve Style Font Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_SELECT_FEATURE_COUNT = IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurveStyleFontImpl <em>Ifc Curve Style Font</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurveStyleFontImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurveStyleFont()
	 * @generated
	 */
	int IFC_CURVE_STYLE_FONT = 137;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT__NAME = IFC_CURVE_STYLE_FONT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Pattern List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT__PATTERN_LIST = IFC_CURVE_STYLE_FONT_SELECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Curve Style Font</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_FEATURE_COUNT = IFC_CURVE_STYLE_FONT_SELECT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurveStyleFontAndScalingImpl <em>Ifc Curve Style Font And Scaling</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurveStyleFontAndScalingImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurveStyleFontAndScaling()
	 * @generated
	 */
	int IFC_CURVE_STYLE_FONT_AND_SCALING = 138;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_AND_SCALING__NAME = IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Curve Font</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_AND_SCALING__CURVE_FONT = IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Curve Font Scaling</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_AND_SCALING__CURVE_FONT_SCALING = IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Curve Font Scaling As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_AND_SCALING__CURVE_FONT_SCALING_AS_STRING = IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Curve Style Font And Scaling</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_AND_SCALING_FEATURE_COUNT = IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcCurveStyleFontPatternImpl <em>Ifc Curve Style Font Pattern</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcCurveStyleFontPatternImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcCurveStyleFontPattern()
	 * @generated
	 */
	int IFC_CURVE_STYLE_FONT_PATTERN = 139;

	/**
	 * The feature id for the '<em><b>Visible Segment Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_PATTERN__VISIBLE_SEGMENT_LENGTH = 0;

	/**
	 * The feature id for the '<em><b>Visible Segment Length As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_PATTERN__VISIBLE_SEGMENT_LENGTH_AS_STRING = 1;

	/**
	 * The feature id for the '<em><b>Invisible Segment Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_PATTERN__INVISIBLE_SEGMENT_LENGTH = 2;

	/**
	 * The feature id for the '<em><b>Invisible Segment Length As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_PATTERN__INVISIBLE_SEGMENT_LENGTH_AS_STRING = 3;

	/**
	 * The number of structural features of the '<em>Ifc Curve Style Font Pattern</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_STYLE_FONT_PATTERN_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDamperTypeImpl <em>Ifc Damper Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDamperTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDamperType()
	 * @generated
	 */
	int IFC_DAMPER_TYPE = 140;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__GLOBAL_ID = IFC_FLOW_CONTROLLER_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__OWNER_HISTORY = IFC_FLOW_CONTROLLER_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__NAME = IFC_FLOW_CONTROLLER_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__DESCRIPTION = IFC_FLOW_CONTROLLER_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_CONTROLLER_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__DECOMPOSES = IFC_FLOW_CONTROLLER_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_CONTROLLER_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__OBJECT_TYPE_OF = IFC_FLOW_CONTROLLER_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__REPRESENTATION_MAPS = IFC_FLOW_CONTROLLER_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__TAG = IFC_FLOW_CONTROLLER_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__ELEMENT_TYPE = IFC_FLOW_CONTROLLER_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE__PREDEFINED_TYPE = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Damper Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DAMPER_TYPE_FEATURE_COUNT = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDateAndTimeImpl <em>Ifc Date And Time</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDateAndTimeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDateAndTime()
	 * @generated
	 */
	int IFC_DATE_AND_TIME = 141;

	/**
	 * The feature id for the '<em><b>Date Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DATE_AND_TIME__DATE_COMPONENT = IFC_DATE_TIME_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Time Component</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DATE_AND_TIME__TIME_COMPONENT = IFC_DATE_TIME_SELECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Date And Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DATE_AND_TIME_FEATURE_COUNT = IFC_DATE_TIME_SELECT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDefinedSymbolImpl <em>Ifc Defined Symbol</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDefinedSymbolImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDefinedSymbol()
	 * @generated
	 */
	int IFC_DEFINED_SYMBOL = 142;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DEFINED_SYMBOL__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DEFINED_SYMBOL__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Definition</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DEFINED_SYMBOL__DEFINITION = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Target</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DEFINED_SYMBOL__TARGET = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Defined Symbol</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DEFINED_SYMBOL_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDerivedProfileDefImpl <em>Ifc Derived Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDerivedProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDerivedProfileDef()
	 * @generated
	 */
	int IFC_DERIVED_PROFILE_DEF = 143;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Parent Profile</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_PROFILE_DEF__PARENT_PROFILE = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_PROFILE_DEF__OPERATOR = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_PROFILE_DEF__LABEL = IFC_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Derived Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDerivedUnitImpl <em>Ifc Derived Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDerivedUnitImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDerivedUnit()
	 * @generated
	 */
	int IFC_DERIVED_UNIT = 144;

	/**
	 * The feature id for the '<em><b>Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_UNIT__ELEMENTS = IFC_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_UNIT__UNIT_TYPE = IFC_UNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>User Defined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_UNIT__USER_DEFINED_TYPE = IFC_UNIT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Derived Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_UNIT_FEATURE_COUNT = IFC_UNIT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDerivedUnitElementImpl <em>Ifc Derived Unit Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDerivedUnitElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDerivedUnitElement()
	 * @generated
	 */
	int IFC_DERIVED_UNIT_ELEMENT = 145;

	/**
	 * The feature id for the '<em><b>Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_UNIT_ELEMENT__UNIT = 0;

	/**
	 * The feature id for the '<em><b>Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_UNIT_ELEMENT__EXPONENT = 1;

	/**
	 * The number of structural features of the '<em>Ifc Derived Unit Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DERIVED_UNIT_ELEMENT_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDiameterDimensionImpl <em>Ifc Diameter Dimension</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDiameterDimensionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDiameterDimension()
	 * @generated
	 */
	int IFC_DIAMETER_DIMENSION = 146;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIAMETER_DIMENSION__LAYER_ASSIGNMENTS = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIAMETER_DIMENSION__STYLED_BY_ITEM = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Contents</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIAMETER_DIMENSION__CONTENTS = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__CONTENTS;

	/**
	 * The feature id for the '<em><b>Is Related From Callout</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIAMETER_DIMENSION__IS_RELATED_FROM_CALLOUT = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__IS_RELATED_FROM_CALLOUT;

	/**
	 * The feature id for the '<em><b>Is Related To Callout</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIAMETER_DIMENSION__IS_RELATED_TO_CALLOUT = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT__IS_RELATED_TO_CALLOUT;

	/**
	 * The number of structural features of the '<em>Ifc Diameter Dimension</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIAMETER_DIMENSION_FEATURE_COUNT = IFC_DIMENSION_CURVE_DIRECTED_CALLOUT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingCalloutRelationshipImpl <em>Ifc Draughting Callout Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingCalloutRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDraughtingCalloutRelationship()
	 * @generated
	 */
	int IFC_DRAUGHTING_CALLOUT_RELATIONSHIP = 174;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__DESCRIPTION = 1;

	/**
	 * The feature id for the '<em><b>Relating Draughting Callout</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__RELATING_DRAUGHTING_CALLOUT = 2;

	/**
	 * The feature id for the '<em><b>Related Draughting Callout</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__RELATED_DRAUGHTING_CALLOUT = 3;

	/**
	 * The number of structural features of the '<em>Ifc Draughting Callout Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_CALLOUT_RELATIONSHIP_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDimensionCalloutRelationshipImpl <em>Ifc Dimension Callout Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDimensionCalloutRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDimensionCalloutRelationship()
	 * @generated
	 */
	int IFC_DIMENSION_CALLOUT_RELATIONSHIP = 147;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CALLOUT_RELATIONSHIP__NAME = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CALLOUT_RELATIONSHIP__DESCRIPTION = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Relating Draughting Callout</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CALLOUT_RELATIONSHIP__RELATING_DRAUGHTING_CALLOUT = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__RELATING_DRAUGHTING_CALLOUT;

	/**
	 * The feature id for the '<em><b>Related Draughting Callout</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CALLOUT_RELATIONSHIP__RELATED_DRAUGHTING_CALLOUT = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__RELATED_DRAUGHTING_CALLOUT;

	/**
	 * The number of structural features of the '<em>Ifc Dimension Callout Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CALLOUT_RELATIONSHIP_FEATURE_COUNT = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDimensionCurveImpl <em>Ifc Dimension Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDimensionCurveImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDimensionCurve()
	 * @generated
	 */
	int IFC_DIMENSION_CURVE = 148;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE__LAYER_ASSIGNMENTS = IFC_ANNOTATION_CURVE_OCCURRENCE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE__STYLED_BY_ITEM = IFC_ANNOTATION_CURVE_OCCURRENCE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE__ITEM = IFC_ANNOTATION_CURVE_OCCURRENCE__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE__STYLES = IFC_ANNOTATION_CURVE_OCCURRENCE__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE__NAME = IFC_ANNOTATION_CURVE_OCCURRENCE__NAME;

	/**
	 * The feature id for the '<em><b>Annotated By Symbols</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE__ANNOTATED_BY_SYMBOLS = IFC_ANNOTATION_CURVE_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Dimension Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_FEATURE_COUNT = IFC_ANNOTATION_CURVE_OCCURRENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcTerminatorSymbolImpl <em>Ifc Terminator Symbol</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcTerminatorSymbolImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcTerminatorSymbol()
	 * @generated
	 */
	int IFC_TERMINATOR_SYMBOL = 599;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TERMINATOR_SYMBOL__LAYER_ASSIGNMENTS = IFC_ANNOTATION_SYMBOL_OCCURRENCE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TERMINATOR_SYMBOL__STYLED_BY_ITEM = IFC_ANNOTATION_SYMBOL_OCCURRENCE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TERMINATOR_SYMBOL__ITEM = IFC_ANNOTATION_SYMBOL_OCCURRENCE__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TERMINATOR_SYMBOL__STYLES = IFC_ANNOTATION_SYMBOL_OCCURRENCE__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TERMINATOR_SYMBOL__NAME = IFC_ANNOTATION_SYMBOL_OCCURRENCE__NAME;

	/**
	 * The feature id for the '<em><b>Annotated Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TERMINATOR_SYMBOL__ANNOTATED_CURVE = IFC_ANNOTATION_SYMBOL_OCCURRENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Terminator Symbol</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TERMINATOR_SYMBOL_FEATURE_COUNT = IFC_ANNOTATION_SYMBOL_OCCURRENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDimensionCurveTerminatorImpl <em>Ifc Dimension Curve Terminator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDimensionCurveTerminatorImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDimensionCurveTerminator()
	 * @generated
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR = 150;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR__LAYER_ASSIGNMENTS = IFC_TERMINATOR_SYMBOL__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR__STYLED_BY_ITEM = IFC_TERMINATOR_SYMBOL__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Item</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR__ITEM = IFC_TERMINATOR_SYMBOL__ITEM;

	/**
	 * The feature id for the '<em><b>Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR__STYLES = IFC_TERMINATOR_SYMBOL__STYLES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR__NAME = IFC_TERMINATOR_SYMBOL__NAME;

	/**
	 * The feature id for the '<em><b>Annotated Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR__ANNOTATED_CURVE = IFC_TERMINATOR_SYMBOL__ANNOTATED_CURVE;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR__ROLE = IFC_TERMINATOR_SYMBOL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Dimension Curve Terminator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_CURVE_TERMINATOR_FEATURE_COUNT = IFC_TERMINATOR_SYMBOL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDimensionPairImpl <em>Ifc Dimension Pair</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDimensionPairImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDimensionPair()
	 * @generated
	 */
	int IFC_DIMENSION_PAIR = 151;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_PAIR__NAME = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_PAIR__DESCRIPTION = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Relating Draughting Callout</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_PAIR__RELATING_DRAUGHTING_CALLOUT = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__RELATING_DRAUGHTING_CALLOUT;

	/**
	 * The feature id for the '<em><b>Related Draughting Callout</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_PAIR__RELATED_DRAUGHTING_CALLOUT = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP__RELATED_DRAUGHTING_CALLOUT;

	/**
	 * The number of structural features of the '<em>Ifc Dimension Pair</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSION_PAIR_FEATURE_COUNT = IFC_DRAUGHTING_CALLOUT_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDimensionalExponentsImpl <em>Ifc Dimensional Exponents</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDimensionalExponentsImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDimensionalExponents()
	 * @generated
	 */
	int IFC_DIMENSIONAL_EXPONENTS = 152;

	/**
	 * The feature id for the '<em><b>Length Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSIONAL_EXPONENTS__LENGTH_EXPONENT = 0;

	/**
	 * The feature id for the '<em><b>Mass Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSIONAL_EXPONENTS__MASS_EXPONENT = 1;

	/**
	 * The feature id for the '<em><b>Time Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSIONAL_EXPONENTS__TIME_EXPONENT = 2;

	/**
	 * The feature id for the '<em><b>Electric Current Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSIONAL_EXPONENTS__ELECTRIC_CURRENT_EXPONENT = 3;

	/**
	 * The feature id for the '<em><b>Thermodynamic Temperature Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSIONAL_EXPONENTS__THERMODYNAMIC_TEMPERATURE_EXPONENT = 4;

	/**
	 * The feature id for the '<em><b>Amount Of Substance Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSIONAL_EXPONENTS__AMOUNT_OF_SUBSTANCE_EXPONENT = 5;

	/**
	 * The feature id for the '<em><b>Luminous Intensity Exponent</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSIONAL_EXPONENTS__LUMINOUS_INTENSITY_EXPONENT = 6;

	/**
	 * The number of structural features of the '<em>Ifc Dimensional Exponents</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIMENSIONAL_EXPONENTS_FEATURE_COUNT = 7;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDirectionImpl <em>Ifc Direction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDirectionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDirection()
	 * @generated
	 */
	int IFC_DIRECTION = 153;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIRECTION__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIRECTION__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Direction Ratios</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIRECTION__DIRECTION_RATIOS = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Direction Ratios As String</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIRECTION__DIRECTION_RATIOS_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIRECTION__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Direction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DIRECTION_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElementComponentImpl <em>Ifc Element Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElementComponentImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElementComponent()
	 * @generated
	 */
	int IFC_ELEMENT_COMPONENT = 197;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_COVERINGS = IFC_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_PORTS = IFC_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Element Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDiscreteAccessoryImpl <em>Ifc Discrete Accessory</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDiscreteAccessoryImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDiscreteAccessory()
	 * @generated
	 */
	int IFC_DISCRETE_ACCESSORY = 154;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__GLOBAL_ID = IFC_ELEMENT_COMPONENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__OWNER_HISTORY = IFC_ELEMENT_COMPONENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__NAME = IFC_ELEMENT_COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__DESCRIPTION = IFC_ELEMENT_COMPONENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__HAS_ASSIGNMENTS = IFC_ELEMENT_COMPONENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__IS_DECOMPOSED_BY = IFC_ELEMENT_COMPONENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__DECOMPOSES = IFC_ELEMENT_COMPONENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__HAS_ASSOCIATIONS = IFC_ELEMENT_COMPONENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__OBJECT_TYPE = IFC_ELEMENT_COMPONENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__IS_DEFINED_BY = IFC_ELEMENT_COMPONENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__OBJECT_PLACEMENT = IFC_ELEMENT_COMPONENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__REPRESENTATION = IFC_ELEMENT_COMPONENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__REFERENCED_BY = IFC_ELEMENT_COMPONENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__GEOMETRY = IFC_ELEMENT_COMPONENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__TAG = IFC_ELEMENT_COMPONENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT_COMPONENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__FILLS_VOIDS = IFC_ELEMENT_COMPONENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__CONNECTED_TO = IFC_ELEMENT_COMPONENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__HAS_COVERINGS = IFC_ELEMENT_COMPONENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__HAS_PROJECTIONS = IFC_ELEMENT_COMPONENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__REFERENCED_IN_STRUCTURES = IFC_ELEMENT_COMPONENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__HAS_PORTS = IFC_ELEMENT_COMPONENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__HAS_OPENINGS = IFC_ELEMENT_COMPONENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__IS_CONNECTION_REALIZATION = IFC_ELEMENT_COMPONENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__PROVIDES_BOUNDARIES = IFC_ELEMENT_COMPONENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__CONNECTED_FROM = IFC_ELEMENT_COMPONENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY__CONTAINED_IN_STRUCTURE = IFC_ELEMENT_COMPONENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Discrete Accessory</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_FEATURE_COUNT = IFC_ELEMENT_COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElementComponentTypeImpl <em>Ifc Element Component Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElementComponentTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElementComponentType()
	 * @generated
	 */
	int IFC_ELEMENT_COMPONENT_TYPE = 198;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__GLOBAL_ID = IFC_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__OWNER_HISTORY = IFC_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__NAME = IFC_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__DESCRIPTION = IFC_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__DECOMPOSES = IFC_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__OBJECT_TYPE_OF = IFC_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__TAG = IFC_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__ELEMENT_TYPE = IFC_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Element Component Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE_FEATURE_COUNT = IFC_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDiscreteAccessoryTypeImpl <em>Ifc Discrete Accessory Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDiscreteAccessoryTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDiscreteAccessoryType()
	 * @generated
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE = 155;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__GLOBAL_ID = IFC_ELEMENT_COMPONENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__OWNER_HISTORY = IFC_ELEMENT_COMPONENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__NAME = IFC_ELEMENT_COMPONENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__DESCRIPTION = IFC_ELEMENT_COMPONENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_COMPONENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__DECOMPOSES = IFC_ELEMENT_COMPONENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_COMPONENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_COMPONENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__OBJECT_TYPE_OF = IFC_ELEMENT_COMPONENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_COMPONENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__TAG = IFC_ELEMENT_COMPONENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE__ELEMENT_TYPE = IFC_ELEMENT_COMPONENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Discrete Accessory Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISCRETE_ACCESSORY_TYPE_FEATURE_COUNT = IFC_ELEMENT_COMPONENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionElementImpl <em>Ifc Distribution Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionElement()
	 * @generated
	 */
	int IFC_DISTRIBUTION_ELEMENT = 160;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_COVERINGS = IFC_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_PORTS = IFC_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionFlowElementImpl <em>Ifc Distribution Flow Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionFlowElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionFlowElement()
	 * @generated
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT = 162;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID = IFC_DISTRIBUTION_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY = IFC_DISTRIBUTION_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__NAME = IFC_DISTRIBUTION_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION = IFC_DISTRIBUTION_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES = IFC_DISTRIBUTION_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE = IFC_DISTRIBUTION_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT = IFC_DISTRIBUTION_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION = IFC_DISTRIBUTION_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY = IFC_DISTRIBUTION_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY = IFC_DISTRIBUTION_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__TAG = IFC_DISTRIBUTION_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS = IFC_DISTRIBUTION_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO = IFC_DISTRIBUTION_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS = IFC_DISTRIBUTION_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS = IFC_DISTRIBUTION_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS = IFC_DISTRIBUTION_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS = IFC_DISTRIBUTION_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM = IFC_DISTRIBUTION_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Flow Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionChamberElementImpl <em>Ifc Distribution Chamber Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionChamberElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionChamberElement()
	 * @generated
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT = 156;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__HAS_COVERINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Chamber Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionChamberElementTypeImpl <em>Ifc Distribution Chamber Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionChamberElementTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionChamberElementType()
	 * @generated
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE = 157;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE__PREDEFINED_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Chamber Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionControlElementImpl <em>Ifc Distribution Control Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionControlElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionControlElement()
	 * @generated
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT = 158;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__GLOBAL_ID = IFC_DISTRIBUTION_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__OWNER_HISTORY = IFC_DISTRIBUTION_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__NAME = IFC_DISTRIBUTION_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__DESCRIPTION = IFC_DISTRIBUTION_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__DECOMPOSES = IFC_DISTRIBUTION_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_TYPE = IFC_DISTRIBUTION_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DEFINED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_PLACEMENT = IFC_DISTRIBUTION_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__REPRESENTATION = IFC_DISTRIBUTION_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_BY = IFC_DISTRIBUTION_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__GEOMETRY = IFC_DISTRIBUTION_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__TAG = IFC_DISTRIBUTION_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__FILLS_VOIDS = IFC_DISTRIBUTION_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_TO = IFC_DISTRIBUTION_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_COVERINGS = IFC_DISTRIBUTION_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PROJECTIONS = IFC_DISTRIBUTION_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PORTS = IFC_DISTRIBUTION_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_OPENINGS = IFC_DISTRIBUTION_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_FROM = IFC_DISTRIBUTION_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Control Element Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__CONTROL_ELEMENT_ID = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Assigned To Flow Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__ASSIGNED_TO_FLOW_ELEMENT = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Control Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_FEATURE_COUNT = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPortImpl <em>Ifc Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPortImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPort()
	 * @generated
	 */
	int IFC_PORT = 369;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__GLOBAL_ID = IFC_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__OWNER_HISTORY = IFC_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__NAME = IFC_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__DESCRIPTION = IFC_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__HAS_ASSIGNMENTS = IFC_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__IS_DECOMPOSED_BY = IFC_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__DECOMPOSES = IFC_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__HAS_ASSOCIATIONS = IFC_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__OBJECT_TYPE = IFC_PRODUCT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__IS_DEFINED_BY = IFC_PRODUCT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__OBJECT_PLACEMENT = IFC_PRODUCT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__REPRESENTATION = IFC_PRODUCT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__REFERENCED_BY = IFC_PRODUCT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__GEOMETRY = IFC_PRODUCT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Contained In</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__CONTAINED_IN = IFC_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__CONNECTED_FROM = IFC_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT__CONNECTED_TO = IFC_PRODUCT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PORT_FEATURE_COUNT = IFC_PRODUCT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDistributionPortImpl <em>Ifc Distribution Port</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDistributionPortImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDistributionPort()
	 * @generated
	 */
	int IFC_DISTRIBUTION_PORT = 164;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__GLOBAL_ID = IFC_PORT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__OWNER_HISTORY = IFC_PORT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__NAME = IFC_PORT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__DESCRIPTION = IFC_PORT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__HAS_ASSIGNMENTS = IFC_PORT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__IS_DECOMPOSED_BY = IFC_PORT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__DECOMPOSES = IFC_PORT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__HAS_ASSOCIATIONS = IFC_PORT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__OBJECT_TYPE = IFC_PORT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__IS_DEFINED_BY = IFC_PORT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__OBJECT_PLACEMENT = IFC_PORT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__REPRESENTATION = IFC_PORT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__REFERENCED_BY = IFC_PORT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__GEOMETRY = IFC_PORT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Contained In</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__CONTAINED_IN = IFC_PORT__CONTAINED_IN;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__CONNECTED_FROM = IFC_PORT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__CONNECTED_TO = IFC_PORT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Flow Direction</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT__FLOW_DIRECTION = IFC_PORT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Port</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_PORT_FEATURE_COUNT = IFC_PORT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDocumentElectronicFormatImpl <em>Ifc Document Electronic Format</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDocumentElectronicFormatImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDocumentElectronicFormat()
	 * @generated
	 */
	int IFC_DOCUMENT_ELECTRONIC_FORMAT = 165;

	/**
	 * The feature id for the '<em><b>File Extension</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_ELECTRONIC_FORMAT__FILE_EXTENSION = 0;

	/**
	 * The feature id for the '<em><b>Mime Content Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_ELECTRONIC_FORMAT__MIME_CONTENT_TYPE = 1;

	/**
	 * The feature id for the '<em><b>Mime Subtype</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_ELECTRONIC_FORMAT__MIME_SUBTYPE = 2;

	/**
	 * The number of structural features of the '<em>Ifc Document Electronic Format</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_ELECTRONIC_FORMAT_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.IfcDocumentSelect <em>Ifc Document Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.IfcDocumentSelect
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDocumentSelect()
	 * @generated
	 */
	int IFC_DOCUMENT_SELECT = 787;

	/**
	 * The number of structural features of the '<em>Ifc Document Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDocumentInformationImpl <em>Ifc Document Information</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDocumentInformationImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDocumentInformation()
	 * @generated
	 */
	int IFC_DOCUMENT_INFORMATION = 166;

	/**
	 * The feature id for the '<em><b>Document Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__DOCUMENT_ID = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__NAME = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__DESCRIPTION = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Document References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__DOCUMENT_REFERENCES = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Purpose</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__PURPOSE = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Intended Use</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__INTENDED_USE = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Scope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__SCOPE = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Revision</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__REVISION = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Document Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__DOCUMENT_OWNER = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Editors</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__EDITORS = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Creation Time</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__CREATION_TIME = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Last Revision Time</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__LAST_REVISION_TIME = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Electronic Format</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__ELECTRONIC_FORMAT = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Valid From</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__VALID_FROM = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Valid Until</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__VALID_UNTIL = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Confidentiality</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__CONFIDENTIALITY = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__STATUS = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Is Pointed To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__IS_POINTED_TO = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Is Pointer</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION__IS_POINTER = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 18;

	/**
	 * The number of structural features of the '<em>Ifc Document Information</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION_FEATURE_COUNT = IFC_DOCUMENT_SELECT_FEATURE_COUNT + 19;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDocumentInformationRelationshipImpl <em>Ifc Document Information Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDocumentInformationRelationshipImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDocumentInformationRelationship()
	 * @generated
	 */
	int IFC_DOCUMENT_INFORMATION_RELATIONSHIP = 167;

	/**
	 * The feature id for the '<em><b>Relating Document</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION_RELATIONSHIP__RELATING_DOCUMENT = 0;

	/**
	 * The feature id for the '<em><b>Related Documents</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION_RELATIONSHIP__RELATED_DOCUMENTS = 1;

	/**
	 * The feature id for the '<em><b>Relationship Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION_RELATIONSHIP__RELATIONSHIP_TYPE = 2;

	/**
	 * The number of structural features of the '<em>Ifc Document Information Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_INFORMATION_RELATIONSHIP_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDocumentReferenceImpl <em>Ifc Document Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDocumentReferenceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDocumentReference()
	 * @generated
	 */
	int IFC_DOCUMENT_REFERENCE = 168;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_REFERENCE__LOCATION = IFC_EXTERNAL_REFERENCE__LOCATION;

	/**
	 * The feature id for the '<em><b>Item Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_REFERENCE__ITEM_REFERENCE = IFC_EXTERNAL_REFERENCE__ITEM_REFERENCE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_REFERENCE__NAME = IFC_EXTERNAL_REFERENCE__NAME;

	/**
	 * The feature id for the '<em><b>Reference To Document</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_REFERENCE__REFERENCE_TO_DOCUMENT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Document Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOCUMENT_REFERENCE_FEATURE_COUNT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDoorImpl <em>Ifc Door</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDoorImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDoor()
	 * @generated
	 */
	int IFC_DOOR = 169;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__HAS_STRUCTURAL_MEMBER = IFC_BUILDING_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__HAS_PORTS = IFC_BUILDING_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Overall Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__OVERALL_HEIGHT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overall Height As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__OVERALL_HEIGHT_AS_STRING = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Overall Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__OVERALL_WIDTH = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Overall Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR__OVERALL_WIDTH_AS_STRING = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Door</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPropertyDefinitionImpl <em>Ifc Property Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPropertyDefinitionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPropertyDefinition()
	 * @generated
	 */
	int IFC_PROPERTY_DEFINITION = 399;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__GLOBAL_ID = IFC_ROOT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__OWNER_HISTORY = IFC_ROOT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__NAME = IFC_ROOT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__DESCRIPTION = IFC_ROOT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__HAS_ASSOCIATIONS = IFC_ROOT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Property Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION_FEATURE_COUNT = IFC_ROOT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPropertySetDefinitionImpl <em>Ifc Property Set Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPropertySetDefinitionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPropertySetDefinition()
	 * @generated
	 */
	int IFC_PROPERTY_SET_DEFINITION = 406;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_SET_DEFINITION__GLOBAL_ID = IFC_PROPERTY_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_SET_DEFINITION__OWNER_HISTORY = IFC_PROPERTY_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_SET_DEFINITION__NAME = IFC_PROPERTY_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_SET_DEFINITION__DESCRIPTION = IFC_PROPERTY_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_SET_DEFINITION__HAS_ASSOCIATIONS = IFC_PROPERTY_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Property Definition Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_SET_DEFINITION__PROPERTY_DEFINITION_OF = IFC_PROPERTY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Defines Type</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_SET_DEFINITION__DEFINES_TYPE = IFC_PROPERTY_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Property Set Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT = IFC_PROPERTY_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDoorLiningPropertiesImpl <em>Ifc Door Lining Properties</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDoorLiningPropertiesImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDoorLiningProperties()
	 * @generated
	 */
	int IFC_DOOR_LINING_PROPERTIES = 170;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__GLOBAL_ID = IFC_PROPERTY_SET_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__OWNER_HISTORY = IFC_PROPERTY_SET_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__NAME = IFC_PROPERTY_SET_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__DESCRIPTION = IFC_PROPERTY_SET_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__HAS_ASSOCIATIONS = IFC_PROPERTY_SET_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Property Definition Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__PROPERTY_DEFINITION_OF = IFC_PROPERTY_SET_DEFINITION__PROPERTY_DEFINITION_OF;

	/**
	 * The feature id for the '<em><b>Defines Type</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__DEFINES_TYPE = IFC_PROPERTY_SET_DEFINITION__DEFINES_TYPE;

	/**
	 * The feature id for the '<em><b>Lining Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__LINING_DEPTH = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Lining Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__LINING_DEPTH_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Lining Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__LINING_THICKNESS = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Lining Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__LINING_THICKNESS_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Threshold Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__THRESHOLD_DEPTH = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Threshold Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__THRESHOLD_DEPTH_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Threshold Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__THRESHOLD_THICKNESS = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Threshold Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__THRESHOLD_THICKNESS_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Transom Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__TRANSOM_THICKNESS = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Transom Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__TRANSOM_THICKNESS_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Transom Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__TRANSOM_OFFSET = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Transom Offset As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__TRANSOM_OFFSET_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Lining Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__LINING_OFFSET = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Lining Offset As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__LINING_OFFSET_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Threshold Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__THRESHOLD_OFFSET = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Threshold Offset As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__THRESHOLD_OFFSET_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Casing Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__CASING_THICKNESS = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Casing Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__CASING_THICKNESS_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Casing Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__CASING_DEPTH = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Casing Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__CASING_DEPTH_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Shape Aspect Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES__SHAPE_ASPECT_STYLE = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 20;

	/**
	 * The number of structural features of the '<em>Ifc Door Lining Properties</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_LINING_PROPERTIES_FEATURE_COUNT = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 21;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDoorPanelPropertiesImpl <em>Ifc Door Panel Properties</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDoorPanelPropertiesImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDoorPanelProperties()
	 * @generated
	 */
	int IFC_DOOR_PANEL_PROPERTIES = 171;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__GLOBAL_ID = IFC_PROPERTY_SET_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__OWNER_HISTORY = IFC_PROPERTY_SET_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__NAME = IFC_PROPERTY_SET_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__DESCRIPTION = IFC_PROPERTY_SET_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__HAS_ASSOCIATIONS = IFC_PROPERTY_SET_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Property Definition Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__PROPERTY_DEFINITION_OF = IFC_PROPERTY_SET_DEFINITION__PROPERTY_DEFINITION_OF;

	/**
	 * The feature id for the '<em><b>Defines Type</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__DEFINES_TYPE = IFC_PROPERTY_SET_DEFINITION__DEFINES_TYPE;

	/**
	 * The feature id for the '<em><b>Panel Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__PANEL_DEPTH = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Panel Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__PANEL_DEPTH_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Panel Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__PANEL_OPERATION = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Panel Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__PANEL_WIDTH = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Panel Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__PANEL_WIDTH_AS_STRING = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Panel Position</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__PANEL_POSITION = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Shape Aspect Style</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES__SHAPE_ASPECT_STYLE = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Ifc Door Panel Properties</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_PANEL_PROPERTIES_FEATURE_COUNT = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDoorStyleImpl <em>Ifc Door Style</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDoorStyleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDoorStyle()
	 * @generated
	 */
	int IFC_DOOR_STYLE = 172;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__GLOBAL_ID = IFC_TYPE_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__OWNER_HISTORY = IFC_TYPE_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__NAME = IFC_TYPE_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__DESCRIPTION = IFC_TYPE_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__HAS_ASSIGNMENTS = IFC_TYPE_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__IS_DECOMPOSED_BY = IFC_TYPE_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__DECOMPOSES = IFC_TYPE_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__HAS_ASSOCIATIONS = IFC_TYPE_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__APPLICABLE_OCCURRENCE = IFC_TYPE_PRODUCT__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__HAS_PROPERTY_SETS = IFC_TYPE_PRODUCT__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__OBJECT_TYPE_OF = IFC_TYPE_PRODUCT__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__REPRESENTATION_MAPS = IFC_TYPE_PRODUCT__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__TAG = IFC_TYPE_PRODUCT__TAG;

	/**
	 * The feature id for the '<em><b>Operation Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__OPERATION_TYPE = IFC_TYPE_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Construction Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__CONSTRUCTION_TYPE = IFC_TYPE_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parameter Takes Precedence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__PARAMETER_TAKES_PRECEDENCE = IFC_TYPE_PRODUCT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Sizeable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE__SIZEABLE = IFC_TYPE_PRODUCT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Door Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DOOR_STYLE_FEATURE_COUNT = IFC_TYPE_PRODUCT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPreDefinedItemImpl <em>Ifc Pre Defined Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPreDefinedItemImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPreDefinedItem()
	 * @generated
	 */
	int IFC_PRE_DEFINED_ITEM = 374;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRE_DEFINED_ITEM__NAME = 0;

	/**
	 * The number of structural features of the '<em>Ifc Pre Defined Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRE_DEFINED_ITEM_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPreDefinedColourImpl <em>Ifc Pre Defined Colour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPreDefinedColourImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPreDefinedColour()
	 * @generated
	 */
	int IFC_PRE_DEFINED_COLOUR = 371;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRE_DEFINED_COLOUR__NAME = IFC_PRE_DEFINED_ITEM__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Pre Defined Colour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRE_DEFINED_COLOUR_FEATURE_COUNT = IFC_PRE_DEFINED_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingPreDefinedColourImpl <em>Ifc Draughting Pre Defined Colour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingPreDefinedColourImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDraughtingPreDefinedColour()
	 * @generated
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_COLOUR = 175;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_COLOUR__NAME = IFC_PRE_DEFINED_COLOUR__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Draughting Pre Defined Colour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_COLOUR_FEATURE_COUNT = IFC_PRE_DEFINED_COLOUR_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPreDefinedCurveFontImpl <em>Ifc Pre Defined Curve Font</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPreDefinedCurveFontImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPreDefinedCurveFont()
	 * @generated
	 */
	int IFC_PRE_DEFINED_CURVE_FONT = 372;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRE_DEFINED_CURVE_FONT__NAME = IFC_PRE_DEFINED_ITEM__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Pre Defined Curve Font</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRE_DEFINED_CURVE_FONT_FEATURE_COUNT = IFC_PRE_DEFINED_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingPreDefinedCurveFontImpl <em>Ifc Draughting Pre Defined Curve Font</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingPreDefinedCurveFontImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDraughtingPreDefinedCurveFont()
	 * @generated
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_CURVE_FONT = 176;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_CURVE_FONT__NAME = IFC_PRE_DEFINED_CURVE_FONT__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Draughting Pre Defined Curve Font</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_CURVE_FONT_FEATURE_COUNT = IFC_PRE_DEFINED_CURVE_FONT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcPreDefinedTextFontImpl <em>Ifc Pre Defined Text Font</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcPreDefinedTextFontImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcPreDefinedTextFont()
	 * @generated
	 */
	int IFC_PRE_DEFINED_TEXT_FONT = 378;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRE_DEFINED_TEXT_FONT__NAME = IFC_PRE_DEFINED_ITEM__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Pre Defined Text Font</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRE_DEFINED_TEXT_FONT_FEATURE_COUNT = IFC_PRE_DEFINED_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingPreDefinedTextFontImpl <em>Ifc Draughting Pre Defined Text Font</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDraughtingPreDefinedTextFontImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDraughtingPreDefinedTextFont()
	 * @generated
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_TEXT_FONT = 177;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_TEXT_FONT__NAME = IFC_PRE_DEFINED_TEXT_FONT__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Draughting Pre Defined Text Font</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DRAUGHTING_PRE_DEFINED_TEXT_FONT_FEATURE_COUNT = IFC_PRE_DEFINED_TEXT_FONT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDuctFittingTypeImpl <em>Ifc Duct Fitting Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDuctFittingTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDuctFittingType()
	 * @generated
	 */
	int IFC_DUCT_FITTING_TYPE = 178;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__GLOBAL_ID = IFC_FLOW_FITTING_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__OWNER_HISTORY = IFC_FLOW_FITTING_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__NAME = IFC_FLOW_FITTING_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__DESCRIPTION = IFC_FLOW_FITTING_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_FITTING_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_FITTING_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__DECOMPOSES = IFC_FLOW_FITTING_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_FITTING_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_FITTING_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_FITTING_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__OBJECT_TYPE_OF = IFC_FLOW_FITTING_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__REPRESENTATION_MAPS = IFC_FLOW_FITTING_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__TAG = IFC_FLOW_FITTING_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__ELEMENT_TYPE = IFC_FLOW_FITTING_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE__PREDEFINED_TYPE = IFC_FLOW_FITTING_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Duct Fitting Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_FITTING_TYPE_FEATURE_COUNT = IFC_FLOW_FITTING_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDuctSegmentTypeImpl <em>Ifc Duct Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDuctSegmentTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDuctSegmentType()
	 * @generated
	 */
	int IFC_DUCT_SEGMENT_TYPE = 179;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__GLOBAL_ID = IFC_FLOW_SEGMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__OWNER_HISTORY = IFC_FLOW_SEGMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__NAME = IFC_FLOW_SEGMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__DESCRIPTION = IFC_FLOW_SEGMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_SEGMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__DECOMPOSES = IFC_FLOW_SEGMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_SEGMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_SEGMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__OBJECT_TYPE_OF = IFC_FLOW_SEGMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__REPRESENTATION_MAPS = IFC_FLOW_SEGMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__TAG = IFC_FLOW_SEGMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__ELEMENT_TYPE = IFC_FLOW_SEGMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE__PREDEFINED_TYPE = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Duct Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SEGMENT_TYPE_FEATURE_COUNT = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowTreatmentDeviceTypeImpl <em>Ifc Flow Treatment Device Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowTreatmentDeviceTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowTreatmentDeviceType()
	 * @generated
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE = 254;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Treatment Device Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcDuctSilencerTypeImpl <em>Ifc Duct Silencer Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcDuctSilencerTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcDuctSilencerType()
	 * @generated
	 */
	int IFC_DUCT_SILENCER_TYPE = 180;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__GLOBAL_ID = IFC_FLOW_TREATMENT_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__OWNER_HISTORY = IFC_FLOW_TREATMENT_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__NAME = IFC_FLOW_TREATMENT_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__DESCRIPTION = IFC_FLOW_TREATMENT_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TREATMENT_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__DECOMPOSES = IFC_FLOW_TREATMENT_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TREATMENT_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__OBJECT_TYPE_OF = IFC_FLOW_TREATMENT_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TREATMENT_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__TAG = IFC_FLOW_TREATMENT_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__ELEMENT_TYPE = IFC_FLOW_TREATMENT_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE__PREDEFINED_TYPE = IFC_FLOW_TREATMENT_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Duct Silencer Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DUCT_SILENCER_TYPE_FEATURE_COUNT = IFC_FLOW_TREATMENT_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEdgeImpl <em>Ifc Edge</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEdgeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEdge()
	 * @generated
	 */
	int IFC_EDGE = 181;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE__LAYER_ASSIGNMENTS = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE__STYLED_BY_ITEM = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Edge Start</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE__EDGE_START = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Edge End</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE__EDGE_END = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Edge</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_FEATURE_COUNT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEdgeCurveImpl <em>Ifc Edge Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEdgeCurveImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEdgeCurve()
	 * @generated
	 */
	int IFC_EDGE_CURVE = 182;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_CURVE__LAYER_ASSIGNMENTS = IFC_EDGE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_CURVE__STYLED_BY_ITEM = IFC_EDGE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Edge Start</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_CURVE__EDGE_START = IFC_EDGE__EDGE_START;

	/**
	 * The feature id for the '<em><b>Edge End</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_CURVE__EDGE_END = IFC_EDGE__EDGE_END;

	/**
	 * The feature id for the '<em><b>Edge Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_CURVE__EDGE_GEOMETRY = IFC_EDGE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Same Sense</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_CURVE__SAME_SENSE = IFC_EDGE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Edge Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_CURVE_FEATURE_COUNT = IFC_EDGE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcLoopImpl <em>Ifc Loop</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcLoopImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcLoop()
	 * @generated
	 */
	int IFC_LOOP = 302;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_LOOP__LAYER_ASSIGNMENTS = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_LOOP__STYLED_BY_ITEM = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Loop</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_LOOP_FEATURE_COUNT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEdgeLoopImpl <em>Ifc Edge Loop</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEdgeLoopImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEdgeLoop()
	 * @generated
	 */
	int IFC_EDGE_LOOP = 184;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_LOOP__LAYER_ASSIGNMENTS = IFC_LOOP__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_LOOP__STYLED_BY_ITEM = IFC_LOOP__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Edge List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_LOOP__EDGE_LIST = IFC_LOOP_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Edge Loop</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EDGE_LOOP_FEATURE_COUNT = IFC_LOOP_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricApplianceTypeImpl <em>Ifc Electric Appliance Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricApplianceTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricApplianceType()
	 * @generated
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE = 185;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__GLOBAL_ID = IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__OWNER_HISTORY = IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__NAME = IFC_FLOW_TERMINAL_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__DESCRIPTION = IFC_FLOW_TERMINAL_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__DECOMPOSES = IFC_FLOW_TERMINAL_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__OBJECT_TYPE_OF = IFC_FLOW_TERMINAL_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__TAG = IFC_FLOW_TERMINAL_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__ELEMENT_TYPE = IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Electric Appliance Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_APPLIANCE_TYPE_FEATURE_COUNT = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowControllerImpl <em>Ifc Flow Controller</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowControllerImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowController()
	 * @generated
	 */
	int IFC_FLOW_CONTROLLER = 239;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_COVERINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Controller</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricDistributionPointImpl <em>Ifc Electric Distribution Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricDistributionPointImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricDistributionPoint()
	 * @generated
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT = 186;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__GLOBAL_ID = IFC_FLOW_CONTROLLER__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__OWNER_HISTORY = IFC_FLOW_CONTROLLER__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__NAME = IFC_FLOW_CONTROLLER__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__DESCRIPTION = IFC_FLOW_CONTROLLER__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__HAS_ASSIGNMENTS = IFC_FLOW_CONTROLLER__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__IS_DECOMPOSED_BY = IFC_FLOW_CONTROLLER__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__DECOMPOSES = IFC_FLOW_CONTROLLER__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__HAS_ASSOCIATIONS = IFC_FLOW_CONTROLLER__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__OBJECT_TYPE = IFC_FLOW_CONTROLLER__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__IS_DEFINED_BY = IFC_FLOW_CONTROLLER__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__OBJECT_PLACEMENT = IFC_FLOW_CONTROLLER__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__REPRESENTATION = IFC_FLOW_CONTROLLER__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__REFERENCED_BY = IFC_FLOW_CONTROLLER__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__GEOMETRY = IFC_FLOW_CONTROLLER__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__TAG = IFC_FLOW_CONTROLLER__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__HAS_STRUCTURAL_MEMBER = IFC_FLOW_CONTROLLER__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__FILLS_VOIDS = IFC_FLOW_CONTROLLER__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__CONNECTED_TO = IFC_FLOW_CONTROLLER__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__HAS_COVERINGS = IFC_FLOW_CONTROLLER__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__HAS_PROJECTIONS = IFC_FLOW_CONTROLLER__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__REFERENCED_IN_STRUCTURES = IFC_FLOW_CONTROLLER__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__HAS_PORTS = IFC_FLOW_CONTROLLER__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__HAS_OPENINGS = IFC_FLOW_CONTROLLER__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__IS_CONNECTION_REALIZATION = IFC_FLOW_CONTROLLER__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__PROVIDES_BOUNDARIES = IFC_FLOW_CONTROLLER__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__CONNECTED_FROM = IFC_FLOW_CONTROLLER__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__CONTAINED_IN_STRUCTURE = IFC_FLOW_CONTROLLER__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__HAS_CONTROL_ELEMENTS = IFC_FLOW_CONTROLLER__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Distribution Point Function</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__DISTRIBUTION_POINT_FUNCTION = IFC_FLOW_CONTROLLER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>User Defined Function</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT__USER_DEFINED_FUNCTION = IFC_FLOW_CONTROLLER_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Electric Distribution Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_DISTRIBUTION_POINT_FEATURE_COUNT = IFC_FLOW_CONTROLLER_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowStorageDeviceTypeImpl <em>Ifc Flow Storage Device Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowStorageDeviceTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowStorageDeviceType()
	 * @generated
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE = 250;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Storage Device Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricFlowStorageDeviceTypeImpl <em>Ifc Electric Flow Storage Device Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricFlowStorageDeviceTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricFlowStorageDeviceType()
	 * @generated
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE = 187;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__GLOBAL_ID = IFC_FLOW_STORAGE_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__OWNER_HISTORY = IFC_FLOW_STORAGE_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__NAME = IFC_FLOW_STORAGE_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__DESCRIPTION = IFC_FLOW_STORAGE_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_STORAGE_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_STORAGE_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__DECOMPOSES = IFC_FLOW_STORAGE_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_STORAGE_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_STORAGE_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_STORAGE_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__OBJECT_TYPE_OF = IFC_FLOW_STORAGE_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__REPRESENTATION_MAPS = IFC_FLOW_STORAGE_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__TAG = IFC_FLOW_STORAGE_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__ELEMENT_TYPE = IFC_FLOW_STORAGE_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE__PREDEFINED_TYPE = IFC_FLOW_STORAGE_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Electric Flow Storage Device Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE_FEATURE_COUNT = IFC_FLOW_STORAGE_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricGeneratorTypeImpl <em>Ifc Electric Generator Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricGeneratorTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricGeneratorType()
	 * @generated
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE = 188;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Electric Generator Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_GENERATOR_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricHeaterTypeImpl <em>Ifc Electric Heater Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricHeaterTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricHeaterType()
	 * @generated
	 */
	int IFC_ELECTRIC_HEATER_TYPE = 189;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__GLOBAL_ID = IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__OWNER_HISTORY = IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__NAME = IFC_FLOW_TERMINAL_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__DESCRIPTION = IFC_FLOW_TERMINAL_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__DECOMPOSES = IFC_FLOW_TERMINAL_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__OBJECT_TYPE_OF = IFC_FLOW_TERMINAL_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__TAG = IFC_FLOW_TERMINAL_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__ELEMENT_TYPE = IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Electric Heater Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_HEATER_TYPE_FEATURE_COUNT = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricMotorTypeImpl <em>Ifc Electric Motor Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricMotorTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricMotorType()
	 * @generated
	 */
	int IFC_ELECTRIC_MOTOR_TYPE = 190;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Electric Motor Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_MOTOR_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricTimeControlTypeImpl <em>Ifc Electric Time Control Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricTimeControlTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricTimeControlType()
	 * @generated
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE = 191;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__GLOBAL_ID = IFC_FLOW_CONTROLLER_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__OWNER_HISTORY = IFC_FLOW_CONTROLLER_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__NAME = IFC_FLOW_CONTROLLER_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__DESCRIPTION = IFC_FLOW_CONTROLLER_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_CONTROLLER_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__DECOMPOSES = IFC_FLOW_CONTROLLER_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_CONTROLLER_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__OBJECT_TYPE_OF = IFC_FLOW_CONTROLLER_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__REPRESENTATION_MAPS = IFC_FLOW_CONTROLLER_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__TAG = IFC_FLOW_CONTROLLER_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__ELEMENT_TYPE = IFC_FLOW_CONTROLLER_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE__PREDEFINED_TYPE = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Electric Time Control Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRIC_TIME_CONTROL_TYPE_FEATURE_COUNT = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEnergyPropertiesImpl <em>Ifc Energy Properties</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEnergyPropertiesImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEnergyProperties()
	 * @generated
	 */
	int IFC_ENERGY_PROPERTIES = 206;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__GLOBAL_ID = IFC_PROPERTY_SET_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__OWNER_HISTORY = IFC_PROPERTY_SET_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__NAME = IFC_PROPERTY_SET_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__DESCRIPTION = IFC_PROPERTY_SET_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__HAS_ASSOCIATIONS = IFC_PROPERTY_SET_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Property Definition Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__PROPERTY_DEFINITION_OF = IFC_PROPERTY_SET_DEFINITION__PROPERTY_DEFINITION_OF;

	/**
	 * The feature id for the '<em><b>Defines Type</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__DEFINES_TYPE = IFC_PROPERTY_SET_DEFINITION__DEFINES_TYPE;

	/**
	 * The feature id for the '<em><b>Energy Sequence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__ENERGY_SEQUENCE = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>User Defined Energy Sequence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES__USER_DEFINED_ENERGY_SEQUENCE = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Energy Properties</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_PROPERTIES_FEATURE_COUNT = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricalBasePropertiesImpl <em>Ifc Electrical Base Properties</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricalBasePropertiesImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricalBaseProperties()
	 * @generated
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES = 192;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__GLOBAL_ID = IFC_ENERGY_PROPERTIES__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__OWNER_HISTORY = IFC_ENERGY_PROPERTIES__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__NAME = IFC_ENERGY_PROPERTIES__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__DESCRIPTION = IFC_ENERGY_PROPERTIES__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__HAS_ASSOCIATIONS = IFC_ENERGY_PROPERTIES__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Property Definition Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__PROPERTY_DEFINITION_OF = IFC_ENERGY_PROPERTIES__PROPERTY_DEFINITION_OF;

	/**
	 * The feature id for the '<em><b>Defines Type</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__DEFINES_TYPE = IFC_ENERGY_PROPERTIES__DEFINES_TYPE;

	/**
	 * The feature id for the '<em><b>Energy Sequence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__ENERGY_SEQUENCE = IFC_ENERGY_PROPERTIES__ENERGY_SEQUENCE;

	/**
	 * The feature id for the '<em><b>User Defined Energy Sequence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__USER_DEFINED_ENERGY_SEQUENCE = IFC_ENERGY_PROPERTIES__USER_DEFINED_ENERGY_SEQUENCE;

	/**
	 * The feature id for the '<em><b>Electric Current Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__ELECTRIC_CURRENT_TYPE = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Input Voltage</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__INPUT_VOLTAGE = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Input Voltage As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__INPUT_VOLTAGE_AS_STRING = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Input Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__INPUT_FREQUENCY = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Input Frequency As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__INPUT_FREQUENCY_AS_STRING = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Full Load Current</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__FULL_LOAD_CURRENT = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Full Load Current As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__FULL_LOAD_CURRENT_AS_STRING = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Minimum Circuit Current</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__MINIMUM_CIRCUIT_CURRENT = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Minimum Circuit Current As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__MINIMUM_CIRCUIT_CURRENT_AS_STRING = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Maximum Power Input</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__MAXIMUM_POWER_INPUT = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Maximum Power Input As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__MAXIMUM_POWER_INPUT_AS_STRING = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Rated Power Input</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__RATED_POWER_INPUT = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Rated Power Input As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__RATED_POWER_INPUT_AS_STRING = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Input Phase</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES__INPUT_PHASE = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>Ifc Electrical Base Properties</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_BASE_PROPERTIES_FEATURE_COUNT = IFC_ENERGY_PROPERTIES_FEATURE_COUNT + 14;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcSystemImpl <em>Ifc System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcSystemImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcSystem()
	 * @generated
	 */
	int IFC_SYSTEM = 589;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__GLOBAL_ID = IFC_GROUP__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__OWNER_HISTORY = IFC_GROUP__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__NAME = IFC_GROUP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__DESCRIPTION = IFC_GROUP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__HAS_ASSIGNMENTS = IFC_GROUP__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_DECOMPOSED_BY = IFC_GROUP__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__DECOMPOSES = IFC_GROUP__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__HAS_ASSOCIATIONS = IFC_GROUP__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__OBJECT_TYPE = IFC_GROUP__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_DEFINED_BY = IFC_GROUP__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_GROUPED_BY = IFC_GROUP__IS_GROUPED_BY;

	/**
	 * The feature id for the '<em><b>Services Buildings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__SERVICES_BUILDINGS = IFC_GROUP_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM_FEATURE_COUNT = IFC_GROUP_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricalCircuitImpl <em>Ifc Electrical Circuit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricalCircuitImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricalCircuit()
	 * @generated
	 */
	int IFC_ELECTRICAL_CIRCUIT = 193;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__GLOBAL_ID = IFC_SYSTEM__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__OWNER_HISTORY = IFC_SYSTEM__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__NAME = IFC_SYSTEM__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__DESCRIPTION = IFC_SYSTEM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__HAS_ASSIGNMENTS = IFC_SYSTEM__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__IS_DECOMPOSED_BY = IFC_SYSTEM__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__DECOMPOSES = IFC_SYSTEM__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__HAS_ASSOCIATIONS = IFC_SYSTEM__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__OBJECT_TYPE = IFC_SYSTEM__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__IS_DEFINED_BY = IFC_SYSTEM__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__IS_GROUPED_BY = IFC_SYSTEM__IS_GROUPED_BY;

	/**
	 * The feature id for the '<em><b>Services Buildings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT__SERVICES_BUILDINGS = IFC_SYSTEM__SERVICES_BUILDINGS;

	/**
	 * The number of structural features of the '<em>Ifc Electrical Circuit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_CIRCUIT_FEATURE_COUNT = IFC_SYSTEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElectricalElementImpl <em>Ifc Electrical Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElectricalElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElectricalElement()
	 * @generated
	 */
	int IFC_ELECTRICAL_ELEMENT = 194;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__HAS_COVERINGS = IFC_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__HAS_PORTS = IFC_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Electrical Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELECTRICAL_ELEMENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElementAssemblyImpl <em>Ifc Element Assembly</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElementAssemblyImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElementAssembly()
	 * @generated
	 */
	int IFC_ELEMENT_ASSEMBLY = 196;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__HAS_COVERINGS = IFC_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__HAS_PORTS = IFC_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Assembly Place</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__ASSEMBLY_PLACE = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY__PREDEFINED_TYPE = IFC_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Element Assembly</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_ASSEMBLY_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElementQuantityImpl <em>Ifc Element Quantity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElementQuantityImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElementQuantity()
	 * @generated
	 */
	int IFC_ELEMENT_QUANTITY = 199;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__GLOBAL_ID = IFC_PROPERTY_SET_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__OWNER_HISTORY = IFC_PROPERTY_SET_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__NAME = IFC_PROPERTY_SET_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__DESCRIPTION = IFC_PROPERTY_SET_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__HAS_ASSOCIATIONS = IFC_PROPERTY_SET_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Property Definition Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__PROPERTY_DEFINITION_OF = IFC_PROPERTY_SET_DEFINITION__PROPERTY_DEFINITION_OF;

	/**
	 * The feature id for the '<em><b>Defines Type</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__DEFINES_TYPE = IFC_PROPERTY_SET_DEFINITION__DEFINES_TYPE;

	/**
	 * The feature id for the '<em><b>Method Of Measurement</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__METHOD_OF_MEASUREMENT = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Quantities</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY__QUANTITIES = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Element Quantity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_QUANTITY_FEATURE_COUNT = IFC_PROPERTY_SET_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcElementarySurfaceImpl <em>Ifc Elementary Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcElementarySurfaceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcElementarySurface()
	 * @generated
	 */
	int IFC_ELEMENTARY_SURFACE = 201;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENTARY_SURFACE__LAYER_ASSIGNMENTS = IFC_SURFACE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENTARY_SURFACE__STYLED_BY_ITEM = IFC_SURFACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENTARY_SURFACE__POSITION = IFC_SURFACE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENTARY_SURFACE__DIM = IFC_SURFACE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Elementary Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENTARY_SURFACE_FEATURE_COUNT = IFC_SURFACE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEllipseImpl <em>Ifc Ellipse</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEllipseImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEllipse()
	 * @generated
	 */
	int IFC_ELLIPSE = 202;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE__LAYER_ASSIGNMENTS = IFC_CONIC__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE__STYLED_BY_ITEM = IFC_CONIC__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE__DIM = IFC_CONIC__DIM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE__POSITION = IFC_CONIC__POSITION;

	/**
	 * The feature id for the '<em><b>Semi Axis1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE__SEMI_AXIS1 = IFC_CONIC_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Semi Axis1 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE__SEMI_AXIS1_AS_STRING = IFC_CONIC_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Semi Axis2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE__SEMI_AXIS2 = IFC_CONIC_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Semi Axis2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE__SEMI_AXIS2_AS_STRING = IFC_CONIC_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Ellipse</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_FEATURE_COUNT = IFC_CONIC_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEllipseProfileDefImpl <em>Ifc Ellipse Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEllipseProfileDefImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEllipseProfileDef()
	 * @generated
	 */
	int IFC_ELLIPSE_PROFILE_DEF = 203;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Semi Axis1</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_PROFILE_DEF__SEMI_AXIS1 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Semi Axis1 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_PROFILE_DEF__SEMI_AXIS1_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Semi Axis2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_PROFILE_DEF__SEMI_AXIS2 = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Semi Axis2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_PROFILE_DEF__SEMI_AXIS2_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Ellipse Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELLIPSE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEnergyConversionDeviceImpl <em>Ifc Energy Conversion Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEnergyConversionDeviceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEnergyConversionDevice()
	 * @generated
	 */
	int IFC_ENERGY_CONVERSION_DEVICE = 204;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_COVERINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Energy Conversion Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEnvironmentalImpactValueImpl <em>Ifc Environmental Impact Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEnvironmentalImpactValueImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEnvironmentalImpactValue()
	 * @generated
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE = 207;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__NAME = IFC_APPLIED_VALUE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__DESCRIPTION = IFC_APPLIED_VALUE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Applied Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__APPLIED_VALUE = IFC_APPLIED_VALUE__APPLIED_VALUE;

	/**
	 * The feature id for the '<em><b>Unit Basis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__UNIT_BASIS = IFC_APPLIED_VALUE__UNIT_BASIS;

	/**
	 * The feature id for the '<em><b>Applicable Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__APPLICABLE_DATE = IFC_APPLIED_VALUE__APPLICABLE_DATE;

	/**
	 * The feature id for the '<em><b>Fixed Until Date</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__FIXED_UNTIL_DATE = IFC_APPLIED_VALUE__FIXED_UNTIL_DATE;

	/**
	 * The feature id for the '<em><b>Values Referenced</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__VALUES_REFERENCED = IFC_APPLIED_VALUE__VALUES_REFERENCED;

	/**
	 * The feature id for the '<em><b>Value Of Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__VALUE_OF_COMPONENTS = IFC_APPLIED_VALUE__VALUE_OF_COMPONENTS;

	/**
	 * The feature id for the '<em><b>Is Component In</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__IS_COMPONENT_IN = IFC_APPLIED_VALUE__IS_COMPONENT_IN;

	/**
	 * The feature id for the '<em><b>Impact Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__IMPACT_TYPE = IFC_APPLIED_VALUE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Category</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__CATEGORY = IFC_APPLIED_VALUE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>User Defined Category</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE__USER_DEFINED_CATEGORY = IFC_APPLIED_VALUE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Environmental Impact Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENVIRONMENTAL_IMPACT_VALUE_FEATURE_COUNT = IFC_APPLIED_VALUE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEquipmentElementImpl <em>Ifc Equipment Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEquipmentElementImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEquipmentElement()
	 * @generated
	 */
	int IFC_EQUIPMENT_ELEMENT = 208;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__HAS_COVERINGS = IFC_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__HAS_PORTS = IFC_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Equipment Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_ELEMENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEquipmentStandardImpl <em>Ifc Equipment Standard</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEquipmentStandardImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEquipmentStandard()
	 * @generated
	 */
	int IFC_EQUIPMENT_STANDARD = 209;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__GLOBAL_ID = IFC_CONTROL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__OWNER_HISTORY = IFC_CONTROL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__NAME = IFC_CONTROL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__DESCRIPTION = IFC_CONTROL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__HAS_ASSIGNMENTS = IFC_CONTROL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__IS_DECOMPOSED_BY = IFC_CONTROL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__DECOMPOSES = IFC_CONTROL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__HAS_ASSOCIATIONS = IFC_CONTROL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__OBJECT_TYPE = IFC_CONTROL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__IS_DEFINED_BY = IFC_CONTROL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD__CONTROLS = IFC_CONTROL__CONTROLS;

	/**
	 * The number of structural features of the '<em>Ifc Equipment Standard</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EQUIPMENT_STANDARD_FEATURE_COUNT = IFC_CONTROL_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEvaporativeCoolerTypeImpl <em>Ifc Evaporative Cooler Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEvaporativeCoolerTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEvaporativeCoolerType()
	 * @generated
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE = 210;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Evaporative Cooler Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATIVE_COOLER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcEvaporatorTypeImpl <em>Ifc Evaporator Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcEvaporatorTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcEvaporatorType()
	 * @generated
	 */
	int IFC_EVAPORATOR_TYPE = 211;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__OBJECT_TYPE_OF = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Evaporator Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EVAPORATOR_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcMaterialPropertiesImpl <em>Ifc Material Properties</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcMaterialPropertiesImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcMaterialProperties()
	 * @generated
	 */
	int IFC_MATERIAL_PROPERTIES = 312;

	/**
	 * The feature id for the '<em><b>Material</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MATERIAL_PROPERTIES__MATERIAL = 0;

	/**
	 * The number of structural features of the '<em>Ifc Material Properties</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MATERIAL_PROPERTIES_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcExtendedMaterialPropertiesImpl <em>Ifc Extended Material Properties</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcExtendedMaterialPropertiesImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcExtendedMaterialProperties()
	 * @generated
	 */
	int IFC_EXTENDED_MATERIAL_PROPERTIES = 212;

	/**
	 * The feature id for the '<em><b>Material</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTENDED_MATERIAL_PROPERTIES__MATERIAL = IFC_MATERIAL_PROPERTIES__MATERIAL;

	/**
	 * The feature id for the '<em><b>Extended Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTENDED_MATERIAL_PROPERTIES__EXTENDED_PROPERTIES = IFC_MATERIAL_PROPERTIES_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTENDED_MATERIAL_PROPERTIES__DESCRIPTION = IFC_MATERIAL_PROPERTIES_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTENDED_MATERIAL_PROPERTIES__NAME = IFC_MATERIAL_PROPERTIES_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Extended Material Properties</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTENDED_MATERIAL_PROPERTIES_FEATURE_COUNT = IFC_MATERIAL_PROPERTIES_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcExternallyDefinedHatchStyleImpl <em>Ifc Externally Defined Hatch Style</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcExternallyDefinedHatchStyleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcExternallyDefinedHatchStyle()
	 * @generated
	 */
	int IFC_EXTERNALLY_DEFINED_HATCH_STYLE = 214;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_HATCH_STYLE__LOCATION = IFC_EXTERNAL_REFERENCE__LOCATION;

	/**
	 * The feature id for the '<em><b>Item Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_HATCH_STYLE__ITEM_REFERENCE = IFC_EXTERNAL_REFERENCE__ITEM_REFERENCE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_HATCH_STYLE__NAME = IFC_EXTERNAL_REFERENCE__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Externally Defined Hatch Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_HATCH_STYLE_FEATURE_COUNT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcExternallyDefinedSurfaceStyleImpl <em>Ifc Externally Defined Surface Style</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcExternallyDefinedSurfaceStyleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcExternallyDefinedSurfaceStyle()
	 * @generated
	 */
	int IFC_EXTERNALLY_DEFINED_SURFACE_STYLE = 215;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_SURFACE_STYLE__LOCATION = IFC_EXTERNAL_REFERENCE__LOCATION;

	/**
	 * The feature id for the '<em><b>Item Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_SURFACE_STYLE__ITEM_REFERENCE = IFC_EXTERNAL_REFERENCE__ITEM_REFERENCE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_SURFACE_STYLE__NAME = IFC_EXTERNAL_REFERENCE__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Externally Defined Surface Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_SURFACE_STYLE_FEATURE_COUNT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcExternallyDefinedSymbolImpl <em>Ifc Externally Defined Symbol</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcExternallyDefinedSymbolImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcExternallyDefinedSymbol()
	 * @generated
	 */
	int IFC_EXTERNALLY_DEFINED_SYMBOL = 216;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_SYMBOL__LOCATION = IFC_EXTERNAL_REFERENCE__LOCATION;

	/**
	 * The feature id for the '<em><b>Item Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_SYMBOL__ITEM_REFERENCE = IFC_EXTERNAL_REFERENCE__ITEM_REFERENCE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_SYMBOL__NAME = IFC_EXTERNAL_REFERENCE__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Externally Defined Symbol</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_SYMBOL_FEATURE_COUNT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcExternallyDefinedTextFontImpl <em>Ifc Externally Defined Text Font</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcExternallyDefinedTextFontImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcExternallyDefinedTextFont()
	 * @generated
	 */
	int IFC_EXTERNALLY_DEFINED_TEXT_FONT = 217;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_TEXT_FONT__LOCATION = IFC_EXTERNAL_REFERENCE__LOCATION;

	/**
	 * The feature id for the '<em><b>Item Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_TEXT_FONT__ITEM_REFERENCE = IFC_EXTERNAL_REFERENCE__ITEM_REFERENCE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_TEXT_FONT__NAME = IFC_EXTERNAL_REFERENCE__NAME;

	/**
	 * The number of structural features of the '<em>Ifc Externally Defined Text Font</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNALLY_DEFINED_TEXT_FONT_FEATURE_COUNT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcSweptAreaSolidImpl <em>Ifc Swept Area Solid</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcSweptAreaSolidImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcSweptAreaSolid()
	 * @generated
	 */
	int IFC_SWEPT_AREA_SOLID = 584;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SWEPT_AREA_SOLID__LAYER_ASSIGNMENTS = IFC_SOLID_MODEL__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SWEPT_AREA_SOLID__STYLED_BY_ITEM = IFC_SOLID_MODEL__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SWEPT_AREA_SOLID__DIM = IFC_SOLID_MODEL__DIM;

	/**
	 * The feature id for the '<em><b>Swept Area</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SWEPT_AREA_SOLID__SWEPT_AREA = IFC_SOLID_MODEL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SWEPT_AREA_SOLID__POSITION = IFC_SOLID_MODEL_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Swept Area Solid</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SWEPT_AREA_SOLID_FEATURE_COUNT = IFC_SOLID_MODEL_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcExtrudedAreaSolidImpl <em>Ifc Extruded Area Solid</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcExtrudedAreaSolidImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcExtrudedAreaSolid()
	 * @generated
	 */
	int IFC_EXTRUDED_AREA_SOLID = 218;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID__LAYER_ASSIGNMENTS = IFC_SWEPT_AREA_SOLID__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID__STYLED_BY_ITEM = IFC_SWEPT_AREA_SOLID__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID__DIM = IFC_SWEPT_AREA_SOLID__DIM;

	/**
	 * The feature id for the '<em><b>Swept Area</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID__SWEPT_AREA = IFC_SWEPT_AREA_SOLID__SWEPT_AREA;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID__POSITION = IFC_SWEPT_AREA_SOLID__POSITION;

	/**
	 * The feature id for the '<em><b>Extruded Direction</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID__EXTRUDED_DIRECTION = IFC_SWEPT_AREA_SOLID_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID__DEPTH = IFC_SWEPT_AREA_SOLID_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID__DEPTH_AS_STRING = IFC_SWEPT_AREA_SOLID_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Extruded Area Solid</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTRUDED_AREA_SOLID_FEATURE_COUNT = IFC_SWEPT_AREA_SOLID_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFaceImpl <em>Ifc Face</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFaceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFace()
	 * @generated
	 */
	int IFC_FACE = 219;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE__LAYER_ASSIGNMENTS = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE__STYLED_BY_ITEM = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE__BOUNDS = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Face</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_FEATURE_COUNT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFaceBasedSurfaceModelImpl <em>Ifc Face Based Surface Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFaceBasedSurfaceModelImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFaceBasedSurfaceModel()
	 * @generated
	 */
	int IFC_FACE_BASED_SURFACE_MODEL = 220;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BASED_SURFACE_MODEL__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BASED_SURFACE_MODEL__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Fbsm Faces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BASED_SURFACE_MODEL__FBSM_FACES = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BASED_SURFACE_MODEL__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Face Based Surface Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BASED_SURFACE_MODEL_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFaceBoundImpl <em>Ifc Face Bound</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFaceBoundImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFaceBound()
	 * @generated
	 */
	int IFC_FACE_BOUND = 221;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BOUND__LAYER_ASSIGNMENTS = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BOUND__STYLED_BY_ITEM = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Bound</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BOUND__BOUND = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Orientation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BOUND__ORIENTATION = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Face Bound</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_BOUND_FEATURE_COUNT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFaceOuterBoundImpl <em>Ifc Face Outer Bound</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFaceOuterBoundImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFaceOuterBound()
	 * @generated
	 */
	int IFC_FACE_OUTER_BOUND = 222;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_OUTER_BOUND__LAYER_ASSIGNMENTS = IFC_FACE_BOUND__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_OUTER_BOUND__STYLED_BY_ITEM = IFC_FACE_BOUND__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Bound</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_OUTER_BOUND__BOUND = IFC_FACE_BOUND__BOUND;

	/**
	 * The feature id for the '<em><b>Orientation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_OUTER_BOUND__ORIENTATION = IFC_FACE_BOUND__ORIENTATION;

	/**
	 * The number of structural features of the '<em>Ifc Face Outer Bound</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_OUTER_BOUND_FEATURE_COUNT = IFC_FACE_BOUND_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFaceSurfaceImpl <em>Ifc Face Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFaceSurfaceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFaceSurface()
	 * @generated
	 */
	int IFC_FACE_SURFACE = 223;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__LAYER_ASSIGNMENTS = IFC_FACE__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__STYLED_BY_ITEM = IFC_FACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__BOUNDS = IFC_FACE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Face Surface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__FACE_SURFACE = IFC_FACE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Same Sense</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__SAME_SENSE = IFC_FACE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Face Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE_FEATURE_COUNT = IFC_FACE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcManifoldSolidBrepImpl <em>Ifc Manifold Solid Brep</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcManifoldSolidBrepImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcManifoldSolidBrep()
	 * @generated
	 */
	int IFC_MANIFOLD_SOLID_BREP = 303;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP__LAYER_ASSIGNMENTS = IFC_SOLID_MODEL__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP__STYLED_BY_ITEM = IFC_SOLID_MODEL__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP__DIM = IFC_SOLID_MODEL__DIM;

	/**
	 * The feature id for the '<em><b>Outer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP__OUTER = IFC_SOLID_MODEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Manifold Solid Brep</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP_FEATURE_COUNT = IFC_SOLID_MODEL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFacetedBrepImpl <em>Ifc Faceted Brep</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFacetedBrepImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFacetedBrep()
	 * @generated
	 */
	int IFC_FACETED_BREP = 224;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP__LAYER_ASSIGNMENTS = IFC_MANIFOLD_SOLID_BREP__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP__STYLED_BY_ITEM = IFC_MANIFOLD_SOLID_BREP__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP__DIM = IFC_MANIFOLD_SOLID_BREP__DIM;

	/**
	 * The feature id for the '<em><b>Outer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP__OUTER = IFC_MANIFOLD_SOLID_BREP__OUTER;

	/**
	 * The number of structural features of the '<em>Ifc Faceted Brep</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP_FEATURE_COUNT = IFC_MANIFOLD_SOLID_BREP_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFacetedBrepWithVoidsImpl <em>Ifc Faceted Brep With Voids</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFacetedBrepWithVoidsImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFacetedBrepWithVoids()
	 * @generated
	 */
	int IFC_FACETED_BREP_WITH_VOIDS = 225;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP_WITH_VOIDS__LAYER_ASSIGNMENTS = IFC_MANIFOLD_SOLID_BREP__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP_WITH_VOIDS__STYLED_BY_ITEM = IFC_MANIFOLD_SOLID_BREP__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP_WITH_VOIDS__DIM = IFC_MANIFOLD_SOLID_BREP__DIM;

	/**
	 * The feature id for the '<em><b>Outer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP_WITH_VOIDS__OUTER = IFC_MANIFOLD_SOLID_BREP__OUTER;

	/**
	 * The feature id for the '<em><b>Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP_WITH_VOIDS__VOIDS = IFC_MANIFOLD_SOLID_BREP_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Faceted Brep With Voids</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACETED_BREP_WITH_VOIDS_FEATURE_COUNT = IFC_MANIFOLD_SOLID_BREP_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcStructuralConnectionConditionImpl <em>Ifc Structural Connection Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcStructuralConnectionConditionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcStructuralConnectionCondition()
	 * @generated
	 */
	int IFC_STRUCTURAL_CONNECTION_CONDITION = 537;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_STRUCTURAL_CONNECTION_CONDITION__NAME = 0;

	/**
	 * The number of structural features of the '<em>Ifc Structural Connection Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFailureConnectionConditionImpl <em>Ifc Failure Connection Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFailureConnectionConditionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFailureConnectionCondition()
	 * @generated
	 */
	int IFC_FAILURE_CONNECTION_CONDITION = 226;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__NAME = IFC_STRUCTURAL_CONNECTION_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Tension Failure X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__TENSION_FAILURE_X = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tension Failure XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__TENSION_FAILURE_XAS_STRING = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Tension Failure Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__TENSION_FAILURE_Y = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Tension Failure YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__TENSION_FAILURE_YAS_STRING = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Tension Failure Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__TENSION_FAILURE_Z = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Tension Failure ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__TENSION_FAILURE_ZAS_STRING = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Compression Failure X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__COMPRESSION_FAILURE_X = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Compression Failure XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__COMPRESSION_FAILURE_XAS_STRING = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Compression Failure Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__COMPRESSION_FAILURE_Y = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Compression Failure YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__COMPRESSION_FAILURE_YAS_STRING = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Compression Failure Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__COMPRESSION_FAILURE_Z = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Compression Failure ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION__COMPRESSION_FAILURE_ZAS_STRING = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Ifc Failure Connection Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAILURE_CONNECTION_CONDITION_FEATURE_COUNT = IFC_STRUCTURAL_CONNECTION_CONDITION_FEATURE_COUNT + 12;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFanTypeImpl <em>Ifc Fan Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFanTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFanType()
	 * @generated
	 */
	int IFC_FAN_TYPE = 227;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__GLOBAL_ID = IFC_FLOW_MOVING_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__OWNER_HISTORY = IFC_FLOW_MOVING_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__NAME = IFC_FLOW_MOVING_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__DESCRIPTION = IFC_FLOW_MOVING_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_MOVING_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__DECOMPOSES = IFC_FLOW_MOVING_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_MOVING_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__OBJECT_TYPE_OF = IFC_FLOW_MOVING_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__REPRESENTATION_MAPS = IFC_FLOW_MOVING_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__TAG = IFC_FLOW_MOVING_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__ELEMENT_TYPE = IFC_FLOW_MOVING_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE__PREDEFINED_TYPE = IFC_FLOW_MOVING_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Fan Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FAN_TYPE_FEATURE_COUNT = IFC_FLOW_MOVING_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFastenerImpl <em>Ifc Fastener</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFastenerImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFastener()
	 * @generated
	 */
	int IFC_FASTENER = 228;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__GLOBAL_ID = IFC_ELEMENT_COMPONENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__OWNER_HISTORY = IFC_ELEMENT_COMPONENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__NAME = IFC_ELEMENT_COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__DESCRIPTION = IFC_ELEMENT_COMPONENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__HAS_ASSIGNMENTS = IFC_ELEMENT_COMPONENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__IS_DECOMPOSED_BY = IFC_ELEMENT_COMPONENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__DECOMPOSES = IFC_ELEMENT_COMPONENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__HAS_ASSOCIATIONS = IFC_ELEMENT_COMPONENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__OBJECT_TYPE = IFC_ELEMENT_COMPONENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__IS_DEFINED_BY = IFC_ELEMENT_COMPONENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__OBJECT_PLACEMENT = IFC_ELEMENT_COMPONENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__REPRESENTATION = IFC_ELEMENT_COMPONENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__REFERENCED_BY = IFC_ELEMENT_COMPONENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__GEOMETRY = IFC_ELEMENT_COMPONENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__TAG = IFC_ELEMENT_COMPONENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__HAS_STRUCTURAL_MEMBER = IFC_ELEMENT_COMPONENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__FILLS_VOIDS = IFC_ELEMENT_COMPONENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__CONNECTED_TO = IFC_ELEMENT_COMPONENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__HAS_COVERINGS = IFC_ELEMENT_COMPONENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__HAS_PROJECTIONS = IFC_ELEMENT_COMPONENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__REFERENCED_IN_STRUCTURES = IFC_ELEMENT_COMPONENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__HAS_PORTS = IFC_ELEMENT_COMPONENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__HAS_OPENINGS = IFC_ELEMENT_COMPONENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__IS_CONNECTION_REALIZATION = IFC_ELEMENT_COMPONENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__PROVIDES_BOUNDARIES = IFC_ELEMENT_COMPONENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__CONNECTED_FROM = IFC_ELEMENT_COMPONENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER__CONTAINED_IN_STRUCTURE = IFC_ELEMENT_COMPONENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Fastener</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_FEATURE_COUNT = IFC_ELEMENT_COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFastenerTypeImpl <em>Ifc Fastener Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFastenerTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFastenerType()
	 * @generated
	 */
	int IFC_FASTENER_TYPE = 229;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__GLOBAL_ID = IFC_ELEMENT_COMPONENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__OWNER_HISTORY = IFC_ELEMENT_COMPONENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__NAME = IFC_ELEMENT_COMPONENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__DESCRIPTION = IFC_ELEMENT_COMPONENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_COMPONENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__DECOMPOSES = IFC_ELEMENT_COMPONENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_COMPONENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_COMPONENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__OBJECT_TYPE_OF = IFC_ELEMENT_COMPONENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_COMPONENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__TAG = IFC_ELEMENT_COMPONENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE__ELEMENT_TYPE = IFC_ELEMENT_COMPONENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Fastener Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FASTENER_TYPE_FEATURE_COUNT = IFC_ELEMENT_COMPONENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFeatureElementAdditionImpl <em>Ifc Feature Element Addition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFeatureElementAdditionImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFeatureElementAddition()
	 * @generated
	 */
	int IFC_FEATURE_ELEMENT_ADDITION = 231;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__GLOBAL_ID = IFC_FEATURE_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__OWNER_HISTORY = IFC_FEATURE_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__NAME = IFC_FEATURE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__DESCRIPTION = IFC_FEATURE_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__HAS_ASSIGNMENTS = IFC_FEATURE_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__IS_DECOMPOSED_BY = IFC_FEATURE_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__DECOMPOSES = IFC_FEATURE_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__HAS_ASSOCIATIONS = IFC_FEATURE_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__OBJECT_TYPE = IFC_FEATURE_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__IS_DEFINED_BY = IFC_FEATURE_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__OBJECT_PLACEMENT = IFC_FEATURE_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__REPRESENTATION = IFC_FEATURE_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__REFERENCED_BY = IFC_FEATURE_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__GEOMETRY = IFC_FEATURE_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__TAG = IFC_FEATURE_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__HAS_STRUCTURAL_MEMBER = IFC_FEATURE_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__FILLS_VOIDS = IFC_FEATURE_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__CONNECTED_TO = IFC_FEATURE_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__HAS_COVERINGS = IFC_FEATURE_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__HAS_PROJECTIONS = IFC_FEATURE_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__REFERENCED_IN_STRUCTURES = IFC_FEATURE_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__HAS_PORTS = IFC_FEATURE_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__HAS_OPENINGS = IFC_FEATURE_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__IS_CONNECTION_REALIZATION = IFC_FEATURE_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__PROVIDES_BOUNDARIES = IFC_FEATURE_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__CONNECTED_FROM = IFC_FEATURE_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__CONTAINED_IN_STRUCTURE = IFC_FEATURE_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Projects Elements</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION__PROJECTS_ELEMENTS = IFC_FEATURE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Feature Element Addition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FEATURE_ELEMENT_ADDITION_FEATURE_COUNT = IFC_FEATURE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFillAreaStyleImpl <em>Ifc Fill Area Style</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFillAreaStyleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFillAreaStyle()
	 * @generated
	 */
	int IFC_FILL_AREA_STYLE = 233;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE__NAME = IFC_PRESENTATION_STYLE__NAME;

	/**
	 * The feature id for the '<em><b>Fill Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE__FILL_STYLES = IFC_PRESENTATION_STYLE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Fill Area Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_FEATURE_COUNT = IFC_PRESENTATION_STYLE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFillAreaStyleHatchingImpl <em>Ifc Fill Area Style Hatching</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFillAreaStyleHatchingImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFillAreaStyleHatching()
	 * @generated
	 */
	int IFC_FILL_AREA_STYLE_HATCHING = 234;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Hatch Line Appearance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING__HATCH_LINE_APPEARANCE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Start Of Next Hatch Line</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING__START_OF_NEXT_HATCH_LINE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Point Of Reference Hatch Line</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING__POINT_OF_REFERENCE_HATCH_LINE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Pattern Start</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING__PATTERN_START = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Hatch Line Angle</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING__HATCH_LINE_ANGLE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Hatch Line Angle As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING__HATCH_LINE_ANGLE_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Fill Area Style Hatching</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_HATCHING_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFillAreaStyleTileSymbolWithStyleImpl <em>Ifc Fill Area Style Tile Symbol With Style</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFillAreaStyleTileSymbolWithStyleImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFillAreaStyleTileSymbolWithStyle()
	 * @generated
	 */
	int IFC_FILL_AREA_STYLE_TILE_SYMBOL_WITH_STYLE = 235;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILE_SYMBOL_WITH_STYLE__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILE_SYMBOL_WITH_STYLE__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Symbol</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILE_SYMBOL_WITH_STYLE__SYMBOL = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Fill Area Style Tile Symbol With Style</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILE_SYMBOL_WITH_STYLE_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFillAreaStyleTilesImpl <em>Ifc Fill Area Style Tiles</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFillAreaStyleTilesImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFillAreaStyleTiles()
	 * @generated
	 */
	int IFC_FILL_AREA_STYLE_TILES = 236;

	/**
	 * The feature id for the '<em><b>Layer Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILES__LAYER_ASSIGNMENTS = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILES__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Tiling Pattern</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILES__TILING_PATTERN = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tiles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILES__TILES = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Tiling Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILES__TILING_SCALE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Tiling Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILES__TILING_SCALE_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Fill Area Style Tiles</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILL_AREA_STYLE_TILES_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFilterTypeImpl <em>Ifc Filter Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFilterTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFilterType()
	 * @generated
	 */
	int IFC_FILTER_TYPE = 237;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__GLOBAL_ID = IFC_FLOW_TREATMENT_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__OWNER_HISTORY = IFC_FLOW_TREATMENT_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__NAME = IFC_FLOW_TREATMENT_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__DESCRIPTION = IFC_FLOW_TREATMENT_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TREATMENT_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__DECOMPOSES = IFC_FLOW_TREATMENT_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TREATMENT_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TREATMENT_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__OBJECT_TYPE_OF = IFC_FLOW_TREATMENT_DEVICE_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TREATMENT_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__TAG = IFC_FLOW_TREATMENT_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__ELEMENT_TYPE = IFC_FLOW_TREATMENT_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE__PREDEFINED_TYPE = IFC_FLOW_TREATMENT_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Filter Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FILTER_TYPE_FEATURE_COUNT = IFC_FLOW_TREATMENT_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFireSuppressionTerminalTypeImpl <em>Ifc Fire Suppression Terminal Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFireSuppressionTerminalTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFireSuppressionTerminalType()
	 * @generated
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE = 238;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__GLOBAL_ID = IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__OWNER_HISTORY = IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__NAME = IFC_FLOW_TERMINAL_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__DESCRIPTION = IFC_FLOW_TERMINAL_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__DECOMPOSES = IFC_FLOW_TERMINAL_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__OBJECT_TYPE_OF = IFC_FLOW_TERMINAL_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__TAG = IFC_FLOW_TERMINAL_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__ELEMENT_TYPE = IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Fire Suppression Terminal Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FIRE_SUPPRESSION_TERMINAL_TYPE_FEATURE_COUNT = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowFittingImpl <em>Ifc Flow Fitting</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowFittingImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowFitting()
	 * @generated
	 */
	int IFC_FLOW_FITTING = 241;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_COVERINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Fitting</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowInstrumentTypeImpl <em>Ifc Flow Instrument Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowInstrumentTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowInstrumentType()
	 * @generated
	 */
	int IFC_FLOW_INSTRUMENT_TYPE = 243;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__OBJECT_TYPE_OF = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Flow Instrument Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_INSTRUMENT_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowMeterTypeImpl <em>Ifc Flow Meter Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowMeterTypeImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowMeterType()
	 * @generated
	 */
	int IFC_FLOW_METER_TYPE = 244;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__GLOBAL_ID = IFC_FLOW_CONTROLLER_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__OWNER_HISTORY = IFC_FLOW_CONTROLLER_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__NAME = IFC_FLOW_CONTROLLER_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__DESCRIPTION = IFC_FLOW_CONTROLLER_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_CONTROLLER_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__DECOMPOSES = IFC_FLOW_CONTROLLER_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_CONTROLLER_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Object Type Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__OBJECT_TYPE_OF = IFC_FLOW_CONTROLLER_TYPE__OBJECT_TYPE_OF;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__REPRESENTATION_MAPS = IFC_FLOW_CONTROLLER_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__TAG = IFC_FLOW_CONTROLLER_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__ELEMENT_TYPE = IFC_FLOW_CONTROLLER_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE__PREDEFINED_TYPE = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Flow Meter Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_METER_TYPE_FEATURE_COUNT = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowMovingDeviceImpl <em>Ifc Flow Moving Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowMovingDeviceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowMovingDevice()
	 * @generated
	 */
	int IFC_FLOW_MOVING_DEVICE = 245;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_COVERINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Moving Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowSegmentImpl <em>Ifc Flow Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowSegmentImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowSegment()
	 * @generated
	 */
	int IFC_FLOW_SEGMENT = 247;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_COVERINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowStorageDeviceImpl <em>Ifc Flow Storage Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowStorageDeviceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowStorageDevice()
	 * @generated
	 */
	int IFC_FLOW_STORAGE_DEVICE = 249;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__HAS_COVERINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Storage Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_STORAGE_DEVICE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowTerminalImpl <em>Ifc Flow Terminal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowTerminalImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowTerminal()
	 * @generated
	 */
	int IFC_FLOW_TERMINAL = 251;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Has Structural Member</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_STRUCTURAL_MEMBER = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_STRUCTURAL_MEMBER;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_COVERINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Terminal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc2x3tc1.impl.IfcFlowTreatmentDeviceImpl <em>Ifc Flow Treatment Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc2x3tc1.impl.IfcFlowTreatmentDeviceImpl
	 * @see org.bimserver.models.ifc2x3tc1.impl.Ifc2x3tc1PackageImpl#getIfcFlowTreatmentDevice()
	 * @generated
	 */
	int IFC_FLOW_TREATMENT_DEVICE = 253;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TREATMENT_DEVICE__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;
