/**
 * Copyright (C) 2009-2014 BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.bimserver.models.ifc4.util;

/******************************************************************************
 * Copyright (C) 2009-2018  BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see {@literal<http://www.gnu.org/licenses/>}.
 *****************************************************************************/

import org.bimserver.models.ifc4.*;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.Switch;

/**
 * <!-- begin-user-doc --> The <b>Switch</b> for the model's inheritance
 * hierarchy. It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object and proceeding up the
 * inheritance hierarchy until a non-null result is returned, which is the
 * result of the switch. <!-- end-user-doc -->
 * @see org.bimserver.models.ifc4.Ifc4Package
 * @generated
 */
public class Ifc4Switch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	protected static Ifc4Package modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public Ifc4Switch() {
		if (modelPackage == null) {
			modelPackage = Ifc4Package.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @param ePackage
	 *            the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	private T doSwitch2(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case Ifc4Package.IFC_ACTION_REQUEST: {
			IfcActionRequest ifcActionRequest = (IfcActionRequest) theEObject;
			T result = caseIfcActionRequest(ifcActionRequest);
			if (result == null)
				result = caseIfcControl(ifcActionRequest);
			if (result == null)
				result = caseIfcObject(ifcActionRequest);
			if (result == null)
				result = caseIfcObjectDefinition(ifcActionRequest);
			if (result == null)
				result = caseIfcRoot(ifcActionRequest);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcActionRequest);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ACTOR: {
			IfcActor ifcActor = (IfcActor) theEObject;
			T result = caseIfcActor(ifcActor);
			if (result == null)
				result = caseIfcObject(ifcActor);
			if (result == null)
				result = caseIfcObjectDefinition(ifcActor);
			if (result == null)
				result = caseIfcRoot(ifcActor);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcActor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ACTOR_ROLE: {
			IfcActorRole ifcActorRole = (IfcActorRole) theEObject;
			T result = caseIfcActorRole(ifcActorRole);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcActorRole);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ACTUATOR: {
			IfcActuator ifcActuator = (IfcActuator) theEObject;
			T result = caseIfcActuator(ifcActuator);
			if (result == null)
				result = caseIfcDistributionControlElement(ifcActuator);
			if (result == null)
				result = caseIfcDistributionElement(ifcActuator);
			if (result == null)
				result = caseIfcElement(ifcActuator);
			if (result == null)
				result = caseIfcProduct(ifcActuator);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcActuator);
			if (result == null)
				result = caseIfcObject(ifcActuator);
			if (result == null)
				result = caseIfcProductSelect(ifcActuator);
			if (result == null)
				result = caseIfcObjectDefinition(ifcActuator);
			if (result == null)
				result = caseIfcRoot(ifcActuator);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcActuator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ACTUATOR_TYPE: {
			IfcActuatorType ifcActuatorType = (IfcActuatorType) theEObject;
			T result = caseIfcActuatorType(ifcActuatorType);
			if (result == null)
				result = caseIfcDistributionControlElementType(ifcActuatorType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcActuatorType);
			if (result == null)
				result = caseIfcElementType(ifcActuatorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcActuatorType);
			if (result == null)
				result = caseIfcTypeObject(ifcActuatorType);
			if (result == null)
				result = caseIfcProductSelect(ifcActuatorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcActuatorType);
			if (result == null)
				result = caseIfcRoot(ifcActuatorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcActuatorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ADDRESS: {
			IfcAddress ifcAddress = (IfcAddress) theEObject;
			T result = caseIfcAddress(ifcAddress);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcAddress);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ADVANCED_BREP: {
			IfcAdvancedBrep ifcAdvancedBrep = (IfcAdvancedBrep) theEObject;
			T result = caseIfcAdvancedBrep(ifcAdvancedBrep);
			if (result == null)
				result = caseIfcManifoldSolidBrep(ifcAdvancedBrep);
			if (result == null)
				result = caseIfcSolidModel(ifcAdvancedBrep);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcAdvancedBrep);
			if (result == null)
				result = caseIfcBooleanOperand(ifcAdvancedBrep);
			if (result == null)
				result = caseIfcSolidOrShell(ifcAdvancedBrep);
			if (result == null)
				result = caseIfcRepresentationItem(ifcAdvancedBrep);
			if (result == null)
				result = caseIfcLayeredItem(ifcAdvancedBrep);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ADVANCED_BREP_WITH_VOIDS: {
			IfcAdvancedBrepWithVoids ifcAdvancedBrepWithVoids = (IfcAdvancedBrepWithVoids) theEObject;
			T result = caseIfcAdvancedBrepWithVoids(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = caseIfcAdvancedBrep(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = caseIfcManifoldSolidBrep(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = caseIfcSolidModel(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = caseIfcBooleanOperand(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = caseIfcSolidOrShell(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = caseIfcRepresentationItem(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = caseIfcLayeredItem(ifcAdvancedBrepWithVoids);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ADVANCED_FACE: {
			IfcAdvancedFace ifcAdvancedFace = (IfcAdvancedFace) theEObject;
			T result = caseIfcAdvancedFace(ifcAdvancedFace);
			if (result == null)
				result = caseIfcFaceSurface(ifcAdvancedFace);
			if (result == null)
				result = caseIfcFace(ifcAdvancedFace);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcAdvancedFace);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcAdvancedFace);
			if (result == null)
				result = caseIfcRepresentationItem(ifcAdvancedFace);
			if (result == null)
				result = caseIfcLayeredItem(ifcAdvancedFace);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AIR_TERMINAL: {
			IfcAirTerminal ifcAirTerminal = (IfcAirTerminal) theEObject;
			T result = caseIfcAirTerminal(ifcAirTerminal);
			if (result == null)
				result = caseIfcFlowTerminal(ifcAirTerminal);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcAirTerminal);
			if (result == null)
				result = caseIfcDistributionElement(ifcAirTerminal);
			if (result == null)
				result = caseIfcElement(ifcAirTerminal);
			if (result == null)
				result = caseIfcProduct(ifcAirTerminal);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcAirTerminal);
			if (result == null)
				result = caseIfcObject(ifcAirTerminal);
			if (result == null)
				result = caseIfcProductSelect(ifcAirTerminal);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAirTerminal);
			if (result == null)
				result = caseIfcRoot(ifcAirTerminal);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAirTerminal);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AIR_TERMINAL_BOX: {
			IfcAirTerminalBox ifcAirTerminalBox = (IfcAirTerminalBox) theEObject;
			T result = caseIfcAirTerminalBox(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcFlowController(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcDistributionElement(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcElement(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcProduct(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcObject(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcProductSelect(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcRoot(ifcAirTerminalBox);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAirTerminalBox);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AIR_TERMINAL_BOX_TYPE: {
			IfcAirTerminalBoxType ifcAirTerminalBoxType = (IfcAirTerminalBoxType) theEObject;
			T result = caseIfcAirTerminalBoxType(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcFlowControllerType(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcElementType(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcTypeProduct(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcTypeObject(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcProductSelect(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcRoot(ifcAirTerminalBoxType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAirTerminalBoxType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AIR_TERMINAL_TYPE: {
			IfcAirTerminalType ifcAirTerminalType = (IfcAirTerminalType) theEObject;
			T result = caseIfcAirTerminalType(ifcAirTerminalType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcAirTerminalType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcAirTerminalType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcAirTerminalType);
			if (result == null)
				result = caseIfcElementType(ifcAirTerminalType);
			if (result == null)
				result = caseIfcTypeProduct(ifcAirTerminalType);
			if (result == null)
				result = caseIfcTypeObject(ifcAirTerminalType);
			if (result == null)
				result = caseIfcProductSelect(ifcAirTerminalType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAirTerminalType);
			if (result == null)
				result = caseIfcRoot(ifcAirTerminalType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAirTerminalType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AIR_TO_AIR_HEAT_RECOVERY: {
			IfcAirToAirHeatRecovery ifcAirToAirHeatRecovery = (IfcAirToAirHeatRecovery) theEObject;
			T result = caseIfcAirToAirHeatRecovery(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcDistributionElement(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcElement(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcProduct(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcObject(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcProductSelect(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcRoot(ifcAirToAirHeatRecovery);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAirToAirHeatRecovery);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE: {
			IfcAirToAirHeatRecoveryType ifcAirToAirHeatRecoveryType = (IfcAirToAirHeatRecoveryType) theEObject;
			T result = caseIfcAirToAirHeatRecoveryType(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcElementType(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcTypeProduct(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcTypeObject(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcProductSelect(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcRoot(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAirToAirHeatRecoveryType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ALARM: {
			IfcAlarm ifcAlarm = (IfcAlarm) theEObject;
			T result = caseIfcAlarm(ifcAlarm);
			if (result == null)
				result = caseIfcDistributionControlElement(ifcAlarm);
			if (result == null)
				result = caseIfcDistributionElement(ifcAlarm);
			if (result == null)
				result = caseIfcElement(ifcAlarm);
			if (result == null)
				result = caseIfcProduct(ifcAlarm);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcAlarm);
			if (result == null)
				result = caseIfcObject(ifcAlarm);
			if (result == null)
				result = caseIfcProductSelect(ifcAlarm);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAlarm);
			if (result == null)
				result = caseIfcRoot(ifcAlarm);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAlarm);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ALARM_TYPE: {
			IfcAlarmType ifcAlarmType = (IfcAlarmType) theEObject;
			T result = caseIfcAlarmType(ifcAlarmType);
			if (result == null)
				result = caseIfcDistributionControlElementType(ifcAlarmType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcAlarmType);
			if (result == null)
				result = caseIfcElementType(ifcAlarmType);
			if (result == null)
				result = caseIfcTypeProduct(ifcAlarmType);
			if (result == null)
				result = caseIfcTypeObject(ifcAlarmType);
			if (result == null)
				result = caseIfcProductSelect(ifcAlarmType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAlarmType);
			if (result == null)
				result = caseIfcRoot(ifcAlarmType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAlarmType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ANNOTATION: {
			IfcAnnotation ifcAnnotation = (IfcAnnotation) theEObject;
			T result = caseIfcAnnotation(ifcAnnotation);
			if (result == null)
				result = caseIfcProduct(ifcAnnotation);
			if (result == null)
				result = caseIfcObject(ifcAnnotation);
			if (result == null)
				result = caseIfcProductSelect(ifcAnnotation);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAnnotation);
			if (result == null)
				result = caseIfcRoot(ifcAnnotation);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAnnotation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ANNOTATION_FILL_AREA: {
			IfcAnnotationFillArea ifcAnnotationFillArea = (IfcAnnotationFillArea) theEObject;
			T result = caseIfcAnnotationFillArea(ifcAnnotationFillArea);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcAnnotationFillArea);
			if (result == null)
				result = caseIfcRepresentationItem(ifcAnnotationFillArea);
			if (result == null)
				result = caseIfcLayeredItem(ifcAnnotationFillArea);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_APPLICATION: {
			IfcApplication ifcApplication = (IfcApplication) theEObject;
			T result = caseIfcApplication(ifcApplication);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_APPLIED_VALUE: {
			IfcAppliedValue ifcAppliedValue = (IfcAppliedValue) theEObject;
			T result = caseIfcAppliedValue(ifcAppliedValue);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcAppliedValue);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcAppliedValue);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcAppliedValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_APPROVAL: {
			IfcApproval ifcApproval = (IfcApproval) theEObject;
			T result = caseIfcApproval(ifcApproval);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcApproval);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_APPROVAL_RELATIONSHIP: {
			IfcApprovalRelationship ifcApprovalRelationship = (IfcApprovalRelationship) theEObject;
			T result = caseIfcApprovalRelationship(ifcApprovalRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcApprovalRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ARBITRARY_CLOSED_PROFILE_DEF: {
			IfcArbitraryClosedProfileDef ifcArbitraryClosedProfileDef = (IfcArbitraryClosedProfileDef) theEObject;
			T result = caseIfcArbitraryClosedProfileDef(ifcArbitraryClosedProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcArbitraryClosedProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcArbitraryClosedProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ARBITRARY_OPEN_PROFILE_DEF: {
			IfcArbitraryOpenProfileDef ifcArbitraryOpenProfileDef = (IfcArbitraryOpenProfileDef) theEObject;
			T result = caseIfcArbitraryOpenProfileDef(ifcArbitraryOpenProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcArbitraryOpenProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcArbitraryOpenProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS: {
			IfcArbitraryProfileDefWithVoids ifcArbitraryProfileDefWithVoids = (IfcArbitraryProfileDefWithVoids) theEObject;
			T result = caseIfcArbitraryProfileDefWithVoids(ifcArbitraryProfileDefWithVoids);
			if (result == null)
				result = caseIfcArbitraryClosedProfileDef(ifcArbitraryProfileDefWithVoids);
			if (result == null)
				result = caseIfcProfileDef(ifcArbitraryProfileDefWithVoids);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcArbitraryProfileDefWithVoids);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ASSET: {
			IfcAsset ifcAsset = (IfcAsset) theEObject;
			T result = caseIfcAsset(ifcAsset);
			if (result == null)
				result = caseIfcGroup(ifcAsset);
			if (result == null)
				result = caseIfcObject(ifcAsset);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAsset);
			if (result == null)
				result = caseIfcRoot(ifcAsset);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAsset);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF: {
			IfcAsymmetricIShapeProfileDef ifcAsymmetricIShapeProfileDef = (IfcAsymmetricIShapeProfileDef) theEObject;
			T result = caseIfcAsymmetricIShapeProfileDef(ifcAsymmetricIShapeProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcAsymmetricIShapeProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcAsymmetricIShapeProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcAsymmetricIShapeProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AUDIO_VISUAL_APPLIANCE: {
			IfcAudioVisualAppliance ifcAudioVisualAppliance = (IfcAudioVisualAppliance) theEObject;
			T result = caseIfcAudioVisualAppliance(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcFlowTerminal(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcDistributionElement(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcElement(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcProduct(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcObject(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcProductSelect(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcRoot(ifcAudioVisualAppliance);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAudioVisualAppliance);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AUDIO_VISUAL_APPLIANCE_TYPE: {
			IfcAudioVisualApplianceType ifcAudioVisualApplianceType = (IfcAudioVisualApplianceType) theEObject;
			T result = caseIfcAudioVisualApplianceType(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcElementType(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcTypeObject(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcProductSelect(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcRoot(ifcAudioVisualApplianceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcAudioVisualApplianceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AXIS1_PLACEMENT: {
			IfcAxis1Placement ifcAxis1Placement = (IfcAxis1Placement) theEObject;
			T result = caseIfcAxis1Placement(ifcAxis1Placement);
			if (result == null)
				result = caseIfcPlacement(ifcAxis1Placement);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcAxis1Placement);
			if (result == null)
				result = caseIfcRepresentationItem(ifcAxis1Placement);
			if (result == null)
				result = caseIfcLayeredItem(ifcAxis1Placement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AXIS2_PLACEMENT2_D: {
			IfcAxis2Placement2D ifcAxis2Placement2D = (IfcAxis2Placement2D) theEObject;
			T result = caseIfcAxis2Placement2D(ifcAxis2Placement2D);
			if (result == null)
				result = caseIfcPlacement(ifcAxis2Placement2D);
			if (result == null)
				result = caseIfcAxis2Placement(ifcAxis2Placement2D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcAxis2Placement2D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcAxis2Placement2D);
			if (result == null)
				result = caseIfcLayeredItem(ifcAxis2Placement2D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AXIS2_PLACEMENT3_D: {
			IfcAxis2Placement3D ifcAxis2Placement3D = (IfcAxis2Placement3D) theEObject;
			T result = caseIfcAxis2Placement3D(ifcAxis2Placement3D);
			if (result == null)
				result = caseIfcPlacement(ifcAxis2Placement3D);
			if (result == null)
				result = caseIfcAxis2Placement(ifcAxis2Placement3D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcAxis2Placement3D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcAxis2Placement3D);
			if (result == null)
				result = caseIfcLayeredItem(ifcAxis2Placement3D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BSPLINE_CURVE: {
			IfcBSplineCurve ifcBSplineCurve = (IfcBSplineCurve) theEObject;
			T result = caseIfcBSplineCurve(ifcBSplineCurve);
			if (result == null)
				result = caseIfcBoundedCurve(ifcBSplineCurve);
			if (result == null)
				result = caseIfcCurve(ifcBSplineCurve);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcBSplineCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBSplineCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcBSplineCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBSplineCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcBSplineCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BSPLINE_CURVE_WITH_KNOTS: {
			IfcBSplineCurveWithKnots ifcBSplineCurveWithKnots = (IfcBSplineCurveWithKnots) theEObject;
			T result = caseIfcBSplineCurveWithKnots(ifcBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcBSplineCurve(ifcBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcBoundedCurve(ifcBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcCurve(ifcBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcLayeredItem(ifcBSplineCurveWithKnots);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BSPLINE_SURFACE: {
			IfcBSplineSurface ifcBSplineSurface = (IfcBSplineSurface) theEObject;
			T result = caseIfcBSplineSurface(ifcBSplineSurface);
			if (result == null)
				result = caseIfcBoundedSurface(ifcBSplineSurface);
			if (result == null)
				result = caseIfcSurface(ifcBSplineSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBSplineSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcBSplineSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcBSplineSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBSplineSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcBSplineSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BSPLINE_SURFACE_WITH_KNOTS: {
			IfcBSplineSurfaceWithKnots ifcBSplineSurfaceWithKnots = (IfcBSplineSurfaceWithKnots) theEObject;
			T result = caseIfcBSplineSurfaceWithKnots(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcBSplineSurface(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcBoundedSurface(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcSurface(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcLayeredItem(ifcBSplineSurfaceWithKnots);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BEAM: {
			IfcBeam ifcBeam = (IfcBeam) theEObject;
			T result = caseIfcBeam(ifcBeam);
			if (result == null)
				result = caseIfcBuildingElement(ifcBeam);
			if (result == null)
				result = caseIfcElement(ifcBeam);
			if (result == null)
				result = caseIfcProduct(ifcBeam);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcBeam);
			if (result == null)
				result = caseIfcObject(ifcBeam);
			if (result == null)
				result = caseIfcProductSelect(ifcBeam);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBeam);
			if (result == null)
				result = caseIfcRoot(ifcBeam);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBeam);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BEAM_STANDARD_CASE: {
			IfcBeamStandardCase ifcBeamStandardCase = (IfcBeamStandardCase) theEObject;
			T result = caseIfcBeamStandardCase(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcBeam(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcElement(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcObject(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcBeamStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBeamStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BEAM_TYPE: {
			IfcBeamType ifcBeamType = (IfcBeamType) theEObject;
			T result = caseIfcBeamType(ifcBeamType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcBeamType);
			if (result == null)
				result = caseIfcElementType(ifcBeamType);
			if (result == null)
				result = caseIfcTypeProduct(ifcBeamType);
			if (result == null)
				result = caseIfcTypeObject(ifcBeamType);
			if (result == null)
				result = caseIfcProductSelect(ifcBeamType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBeamType);
			if (result == null)
				result = caseIfcRoot(ifcBeamType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBeamType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BLOB_TEXTURE: {
			IfcBlobTexture ifcBlobTexture = (IfcBlobTexture) theEObject;
			T result = caseIfcBlobTexture(ifcBlobTexture);
			if (result == null)
				result = caseIfcSurfaceTexture(ifcBlobTexture);
			if (result == null)
				result = caseIfcPresentationItem(ifcBlobTexture);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BLOCK: {
			IfcBlock ifcBlock = (IfcBlock) theEObject;
			T result = caseIfcBlock(ifcBlock);
			if (result == null)
				result = caseIfcCsgPrimitive3D(ifcBlock);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBlock);
			if (result == null)
				result = caseIfcBooleanOperand(ifcBlock);
			if (result == null)
				result = caseIfcCsgSelect(ifcBlock);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBlock);
			if (result == null)
				result = caseIfcLayeredItem(ifcBlock);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOILER: {
			IfcBoiler ifcBoiler = (IfcBoiler) theEObject;
			T result = caseIfcBoiler(ifcBoiler);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcBoiler);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcBoiler);
			if (result == null)
				result = caseIfcDistributionElement(ifcBoiler);
			if (result == null)
				result = caseIfcElement(ifcBoiler);
			if (result == null)
				result = caseIfcProduct(ifcBoiler);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcBoiler);
			if (result == null)
				result = caseIfcObject(ifcBoiler);
			if (result == null)
				result = caseIfcProductSelect(ifcBoiler);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBoiler);
			if (result == null)
				result = caseIfcRoot(ifcBoiler);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBoiler);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOILER_TYPE: {
			IfcBoilerType ifcBoilerType = (IfcBoilerType) theEObject;
			T result = caseIfcBoilerType(ifcBoilerType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcBoilerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcBoilerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcBoilerType);
			if (result == null)
				result = caseIfcElementType(ifcBoilerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcBoilerType);
			if (result == null)
				result = caseIfcTypeObject(ifcBoilerType);
			if (result == null)
				result = caseIfcProductSelect(ifcBoilerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBoilerType);
			if (result == null)
				result = caseIfcRoot(ifcBoilerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBoilerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOOLEAN_CLIPPING_RESULT: {
			IfcBooleanClippingResult ifcBooleanClippingResult = (IfcBooleanClippingResult) theEObject;
			T result = caseIfcBooleanClippingResult(ifcBooleanClippingResult);
			if (result == null)
				result = caseIfcBooleanResult(ifcBooleanClippingResult);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBooleanClippingResult);
			if (result == null)
				result = caseIfcBooleanOperand(ifcBooleanClippingResult);
			if (result == null)
				result = caseIfcCsgSelect(ifcBooleanClippingResult);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBooleanClippingResult);
			if (result == null)
				result = caseIfcLayeredItem(ifcBooleanClippingResult);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOOLEAN_RESULT: {
			IfcBooleanResult ifcBooleanResult = (IfcBooleanResult) theEObject;
			T result = caseIfcBooleanResult(ifcBooleanResult);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBooleanResult);
			if (result == null)
				result = caseIfcBooleanOperand(ifcBooleanResult);
			if (result == null)
				result = caseIfcCsgSelect(ifcBooleanResult);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBooleanResult);
			if (result == null)
				result = caseIfcLayeredItem(ifcBooleanResult);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDARY_CONDITION: {
			IfcBoundaryCondition ifcBoundaryCondition = (IfcBoundaryCondition) theEObject;
			T result = caseIfcBoundaryCondition(ifcBoundaryCondition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDARY_CURVE: {
			IfcBoundaryCurve ifcBoundaryCurve = (IfcBoundaryCurve) theEObject;
			T result = caseIfcBoundaryCurve(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcCompositeCurveOnSurface(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcCompositeCurve(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcCurveOnSurface(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcBoundedCurve(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcCurve(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBoundaryCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcBoundaryCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDARY_EDGE_CONDITION: {
			IfcBoundaryEdgeCondition ifcBoundaryEdgeCondition = (IfcBoundaryEdgeCondition) theEObject;
			T result = caseIfcBoundaryEdgeCondition(ifcBoundaryEdgeCondition);
			if (result == null)
				result = caseIfcBoundaryCondition(ifcBoundaryEdgeCondition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDARY_FACE_CONDITION: {
			IfcBoundaryFaceCondition ifcBoundaryFaceCondition = (IfcBoundaryFaceCondition) theEObject;
			T result = caseIfcBoundaryFaceCondition(ifcBoundaryFaceCondition);
			if (result == null)
				result = caseIfcBoundaryCondition(ifcBoundaryFaceCondition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDARY_NODE_CONDITION: {
			IfcBoundaryNodeCondition ifcBoundaryNodeCondition = (IfcBoundaryNodeCondition) theEObject;
			T result = caseIfcBoundaryNodeCondition(ifcBoundaryNodeCondition);
			if (result == null)
				result = caseIfcBoundaryCondition(ifcBoundaryNodeCondition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDARY_NODE_CONDITION_WARPING: {
			IfcBoundaryNodeConditionWarping ifcBoundaryNodeConditionWarping = (IfcBoundaryNodeConditionWarping) theEObject;
			T result = caseIfcBoundaryNodeConditionWarping(ifcBoundaryNodeConditionWarping);
			if (result == null)
				result = caseIfcBoundaryNodeCondition(ifcBoundaryNodeConditionWarping);
			if (result == null)
				result = caseIfcBoundaryCondition(ifcBoundaryNodeConditionWarping);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDED_CURVE: {
			IfcBoundedCurve ifcBoundedCurve = (IfcBoundedCurve) theEObject;
			T result = caseIfcBoundedCurve(ifcBoundedCurve);
			if (result == null)
				result = caseIfcCurve(ifcBoundedCurve);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcBoundedCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBoundedCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcBoundedCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBoundedCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcBoundedCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDED_SURFACE: {
			IfcBoundedSurface ifcBoundedSurface = (IfcBoundedSurface) theEObject;
			T result = caseIfcBoundedSurface(ifcBoundedSurface);
			if (result == null)
				result = caseIfcSurface(ifcBoundedSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBoundedSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcBoundedSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcBoundedSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBoundedSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcBoundedSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOUNDING_BOX: {
			IfcBoundingBox ifcBoundingBox = (IfcBoundingBox) theEObject;
			T result = caseIfcBoundingBox(ifcBoundingBox);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBoundingBox);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBoundingBox);
			if (result == null)
				result = caseIfcLayeredItem(ifcBoundingBox);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOXED_HALF_SPACE: {
			IfcBoxedHalfSpace ifcBoxedHalfSpace = (IfcBoxedHalfSpace) theEObject;
			T result = caseIfcBoxedHalfSpace(ifcBoxedHalfSpace);
			if (result == null)
				result = caseIfcHalfSpaceSolid(ifcBoxedHalfSpace);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcBoxedHalfSpace);
			if (result == null)
				result = caseIfcBooleanOperand(ifcBoxedHalfSpace);
			if (result == null)
				result = caseIfcRepresentationItem(ifcBoxedHalfSpace);
			if (result == null)
				result = caseIfcLayeredItem(ifcBoxedHalfSpace);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING: {
			IfcBuilding ifcBuilding = (IfcBuilding) theEObject;
			T result = caseIfcBuilding(ifcBuilding);
			if (result == null)
				result = caseIfcSpatialStructureElement(ifcBuilding);
			if (result == null)
				result = caseIfcSpatialElement(ifcBuilding);
			if (result == null)
				result = caseIfcProduct(ifcBuilding);
			if (result == null)
				result = caseIfcObject(ifcBuilding);
			if (result == null)
				result = caseIfcProductSelect(ifcBuilding);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuilding);
			if (result == null)
				result = caseIfcRoot(ifcBuilding);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuilding);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING_ELEMENT: {
			IfcBuildingElement ifcBuildingElement = (IfcBuildingElement) theEObject;
			T result = caseIfcBuildingElement(ifcBuildingElement);
			if (result == null)
				result = caseIfcElement(ifcBuildingElement);
			if (result == null)
				result = caseIfcProduct(ifcBuildingElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcBuildingElement);
			if (result == null)
				result = caseIfcObject(ifcBuildingElement);
			if (result == null)
				result = caseIfcProductSelect(ifcBuildingElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuildingElement);
			if (result == null)
				result = caseIfcRoot(ifcBuildingElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuildingElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING_ELEMENT_PART: {
			IfcBuildingElementPart ifcBuildingElementPart = (IfcBuildingElementPart) theEObject;
			T result = caseIfcBuildingElementPart(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcElementComponent(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcElement(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcProduct(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcObject(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcProductSelect(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcRoot(ifcBuildingElementPart);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuildingElementPart);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING_ELEMENT_PART_TYPE: {
			IfcBuildingElementPartType ifcBuildingElementPartType = (IfcBuildingElementPartType) theEObject;
			T result = caseIfcBuildingElementPartType(ifcBuildingElementPartType);
			if (result == null)
				result = caseIfcElementComponentType(ifcBuildingElementPartType);
			if (result == null)
				result = caseIfcElementType(ifcBuildingElementPartType);
			if (result == null)
				result = caseIfcTypeProduct(ifcBuildingElementPartType);
			if (result == null)
				result = caseIfcTypeObject(ifcBuildingElementPartType);
			if (result == null)
				result = caseIfcProductSelect(ifcBuildingElementPartType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuildingElementPartType);
			if (result == null)
				result = caseIfcRoot(ifcBuildingElementPartType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuildingElementPartType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING_ELEMENT_PROXY: {
			IfcBuildingElementProxy ifcBuildingElementProxy = (IfcBuildingElementProxy) theEObject;
			T result = caseIfcBuildingElementProxy(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcBuildingElement(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcElement(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcProduct(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcObject(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcProductSelect(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcRoot(ifcBuildingElementProxy);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuildingElementProxy);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING_ELEMENT_PROXY_TYPE: {
			IfcBuildingElementProxyType ifcBuildingElementProxyType = (IfcBuildingElementProxyType) theEObject;
			T result = caseIfcBuildingElementProxyType(ifcBuildingElementProxyType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcBuildingElementProxyType);
			if (result == null)
				result = caseIfcElementType(ifcBuildingElementProxyType);
			if (result == null)
				result = caseIfcTypeProduct(ifcBuildingElementProxyType);
			if (result == null)
				result = caseIfcTypeObject(ifcBuildingElementProxyType);
			if (result == null)
				result = caseIfcProductSelect(ifcBuildingElementProxyType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuildingElementProxyType);
			if (result == null)
				result = caseIfcRoot(ifcBuildingElementProxyType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuildingElementProxyType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING_ELEMENT_TYPE: {
			IfcBuildingElementType ifcBuildingElementType = (IfcBuildingElementType) theEObject;
			T result = caseIfcBuildingElementType(ifcBuildingElementType);
			if (result == null)
				result = caseIfcElementType(ifcBuildingElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcBuildingElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcBuildingElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcBuildingElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuildingElementType);
			if (result == null)
				result = caseIfcRoot(ifcBuildingElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuildingElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING_STOREY: {
			IfcBuildingStorey ifcBuildingStorey = (IfcBuildingStorey) theEObject;
			T result = caseIfcBuildingStorey(ifcBuildingStorey);
			if (result == null)
				result = caseIfcSpatialStructureElement(ifcBuildingStorey);
			if (result == null)
				result = caseIfcSpatialElement(ifcBuildingStorey);
			if (result == null)
				result = caseIfcProduct(ifcBuildingStorey);
			if (result == null)
				result = caseIfcObject(ifcBuildingStorey);
			if (result == null)
				result = caseIfcProductSelect(ifcBuildingStorey);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuildingStorey);
			if (result == null)
				result = caseIfcRoot(ifcBuildingStorey);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuildingStorey);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BUILDING_SYSTEM: {
			IfcBuildingSystem ifcBuildingSystem = (IfcBuildingSystem) theEObject;
			T result = caseIfcBuildingSystem(ifcBuildingSystem);
			if (result == null)
				result = caseIfcSystem(ifcBuildingSystem);
			if (result == null)
				result = caseIfcGroup(ifcBuildingSystem);
			if (result == null)
				result = caseIfcObject(ifcBuildingSystem);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBuildingSystem);
			if (result == null)
				result = caseIfcRoot(ifcBuildingSystem);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBuildingSystem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BURNER: {
			IfcBurner ifcBurner = (IfcBurner) theEObject;
			T result = caseIfcBurner(ifcBurner);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcBurner);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcBurner);
			if (result == null)
				result = caseIfcDistributionElement(ifcBurner);
			if (result == null)
				result = caseIfcElement(ifcBurner);
			if (result == null)
				result = caseIfcProduct(ifcBurner);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcBurner);
			if (result == null)
				result = caseIfcObject(ifcBurner);
			if (result == null)
				result = caseIfcProductSelect(ifcBurner);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBurner);
			if (result == null)
				result = caseIfcRoot(ifcBurner);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBurner);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BURNER_TYPE: {
			IfcBurnerType ifcBurnerType = (IfcBurnerType) theEObject;
			T result = caseIfcBurnerType(ifcBurnerType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcBurnerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcBurnerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcBurnerType);
			if (result == null)
				result = caseIfcElementType(ifcBurnerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcBurnerType);
			if (result == null)
				result = caseIfcTypeObject(ifcBurnerType);
			if (result == null)
				result = caseIfcProductSelect(ifcBurnerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcBurnerType);
			if (result == null)
				result = caseIfcRoot(ifcBurnerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcBurnerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CSHAPE_PROFILE_DEF: {
			IfcCShapeProfileDef ifcCShapeProfileDef = (IfcCShapeProfileDef) theEObject;
			T result = caseIfcCShapeProfileDef(ifcCShapeProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcCShapeProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcCShapeProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcCShapeProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CABLE_CARRIER_FITTING: {
			IfcCableCarrierFitting ifcCableCarrierFitting = (IfcCableCarrierFitting) theEObject;
			T result = caseIfcCableCarrierFitting(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcFlowFitting(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcDistributionElement(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcElement(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcProduct(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcObject(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcProductSelect(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcRoot(ifcCableCarrierFitting);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCableCarrierFitting);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CABLE_CARRIER_FITTING_TYPE: {
			IfcCableCarrierFittingType ifcCableCarrierFittingType = (IfcCableCarrierFittingType) theEObject;
			T result = caseIfcCableCarrierFittingType(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcFlowFittingType(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcElementType(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcTypeObject(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcProductSelect(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcRoot(ifcCableCarrierFittingType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCableCarrierFittingType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CABLE_CARRIER_SEGMENT: {
			IfcCableCarrierSegment ifcCableCarrierSegment = (IfcCableCarrierSegment) theEObject;
			T result = caseIfcCableCarrierSegment(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcFlowSegment(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcDistributionElement(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcElement(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcProduct(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcObject(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcProductSelect(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcRoot(ifcCableCarrierSegment);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCableCarrierSegment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CABLE_CARRIER_SEGMENT_TYPE: {
			IfcCableCarrierSegmentType ifcCableCarrierSegmentType = (IfcCableCarrierSegmentType) theEObject;
			T result = caseIfcCableCarrierSegmentType(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcFlowSegmentType(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcElementType(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcTypeObject(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcProductSelect(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcRoot(ifcCableCarrierSegmentType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCableCarrierSegmentType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CABLE_FITTING: {
			IfcCableFitting ifcCableFitting = (IfcCableFitting) theEObject;
			T result = caseIfcCableFitting(ifcCableFitting);
			if (result == null)
				result = caseIfcFlowFitting(ifcCableFitting);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCableFitting);
			if (result == null)
				result = caseIfcDistributionElement(ifcCableFitting);
			if (result == null)
				result = caseIfcElement(ifcCableFitting);
			if (result == null)
				result = caseIfcProduct(ifcCableFitting);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCableFitting);
			if (result == null)
				result = caseIfcObject(ifcCableFitting);
			if (result == null)
				result = caseIfcProductSelect(ifcCableFitting);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCableFitting);
			if (result == null)
				result = caseIfcRoot(ifcCableFitting);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCableFitting);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CABLE_FITTING_TYPE: {
			IfcCableFittingType ifcCableFittingType = (IfcCableFittingType) theEObject;
			T result = caseIfcCableFittingType(ifcCableFittingType);
			if (result == null)
				result = caseIfcFlowFittingType(ifcCableFittingType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCableFittingType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCableFittingType);
			if (result == null)
				result = caseIfcElementType(ifcCableFittingType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCableFittingType);
			if (result == null)
				result = caseIfcTypeObject(ifcCableFittingType);
			if (result == null)
				result = caseIfcProductSelect(ifcCableFittingType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCableFittingType);
			if (result == null)
				result = caseIfcRoot(ifcCableFittingType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCableFittingType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CABLE_SEGMENT: {
			IfcCableSegment ifcCableSegment = (IfcCableSegment) theEObject;
			T result = caseIfcCableSegment(ifcCableSegment);
			if (result == null)
				result = caseIfcFlowSegment(ifcCableSegment);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCableSegment);
			if (result == null)
				result = caseIfcDistributionElement(ifcCableSegment);
			if (result == null)
				result = caseIfcElement(ifcCableSegment);
			if (result == null)
				result = caseIfcProduct(ifcCableSegment);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCableSegment);
			if (result == null)
				result = caseIfcObject(ifcCableSegment);
			if (result == null)
				result = caseIfcProductSelect(ifcCableSegment);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCableSegment);
			if (result == null)
				result = caseIfcRoot(ifcCableSegment);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCableSegment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CABLE_SEGMENT_TYPE: {
			IfcCableSegmentType ifcCableSegmentType = (IfcCableSegmentType) theEObject;
			T result = caseIfcCableSegmentType(ifcCableSegmentType);
			if (result == null)
				result = caseIfcFlowSegmentType(ifcCableSegmentType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCableSegmentType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCableSegmentType);
			if (result == null)
				result = caseIfcElementType(ifcCableSegmentType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCableSegmentType);
			if (result == null)
				result = caseIfcTypeObject(ifcCableSegmentType);
			if (result == null)
				result = caseIfcProductSelect(ifcCableSegmentType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCableSegmentType);
			if (result == null)
				result = caseIfcRoot(ifcCableSegmentType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCableSegmentType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_POINT: {
			IfcCartesianPoint ifcCartesianPoint = (IfcCartesianPoint) theEObject;
			T result = caseIfcCartesianPoint(ifcCartesianPoint);
			if (result == null)
				result = caseIfcPoint(ifcCartesianPoint);
			if (result == null)
				result = caseIfcTrimmingSelect(ifcCartesianPoint);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianPoint);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcCartesianPoint);
			if (result == null)
				result = caseIfcPointOrVertexPoint(ifcCartesianPoint);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianPoint);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianPoint);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_POINT_LIST: {
			IfcCartesianPointList ifcCartesianPointList = (IfcCartesianPointList) theEObject;
			T result = caseIfcCartesianPointList(ifcCartesianPointList);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianPointList);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianPointList);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianPointList);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_POINT_LIST2_D: {
			IfcCartesianPointList2D ifcCartesianPointList2D = (IfcCartesianPointList2D) theEObject;
			T result = caseIfcCartesianPointList2D(ifcCartesianPointList2D);
			if (result == null)
				result = caseIfcCartesianPointList(ifcCartesianPointList2D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianPointList2D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianPointList2D);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianPointList2D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_POINT_LIST3_D: {
			IfcCartesianPointList3D ifcCartesianPointList3D = (IfcCartesianPointList3D) theEObject;
			T result = caseIfcCartesianPointList3D(ifcCartesianPointList3D);
			if (result == null)
				result = caseIfcCartesianPointList(ifcCartesianPointList3D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianPointList3D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianPointList3D);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianPointList3D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_TRANSFORMATION_OPERATOR: {
			IfcCartesianTransformationOperator ifcCartesianTransformationOperator = (IfcCartesianTransformationOperator) theEObject;
			T result = caseIfcCartesianTransformationOperator(ifcCartesianTransformationOperator);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianTransformationOperator);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianTransformationOperator);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianTransformationOperator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D: {
			IfcCartesianTransformationOperator2D ifcCartesianTransformationOperator2D = (IfcCartesianTransformationOperator2D) theEObject;
			T result = caseIfcCartesianTransformationOperator2D(ifcCartesianTransformationOperator2D);
			if (result == null)
				result = caseIfcCartesianTransformationOperator(ifcCartesianTransformationOperator2D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianTransformationOperator2D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianTransformationOperator2D);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianTransformationOperator2D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM: {
			IfcCartesianTransformationOperator2DnonUniform ifcCartesianTransformationOperator2DnonUniform = (IfcCartesianTransformationOperator2DnonUniform) theEObject;
			T result = caseIfcCartesianTransformationOperator2DnonUniform(ifcCartesianTransformationOperator2DnonUniform);
			if (result == null)
				result = caseIfcCartesianTransformationOperator2D(ifcCartesianTransformationOperator2DnonUniform);
			if (result == null)
				result = caseIfcCartesianTransformationOperator(ifcCartesianTransformationOperator2DnonUniform);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianTransformationOperator2DnonUniform);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianTransformationOperator2DnonUniform);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianTransformationOperator2DnonUniform);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D: {
			IfcCartesianTransformationOperator3D ifcCartesianTransformationOperator3D = (IfcCartesianTransformationOperator3D) theEObject;
			T result = caseIfcCartesianTransformationOperator3D(ifcCartesianTransformationOperator3D);
			if (result == null)
				result = caseIfcCartesianTransformationOperator(ifcCartesianTransformationOperator3D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianTransformationOperator3D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianTransformationOperator3D);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianTransformationOperator3D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM: {
			IfcCartesianTransformationOperator3DnonUniform ifcCartesianTransformationOperator3DnonUniform = (IfcCartesianTransformationOperator3DnonUniform) theEObject;
			T result = caseIfcCartesianTransformationOperator3DnonUniform(ifcCartesianTransformationOperator3DnonUniform);
			if (result == null)
				result = caseIfcCartesianTransformationOperator3D(ifcCartesianTransformationOperator3DnonUniform);
			if (result == null)
				result = caseIfcCartesianTransformationOperator(ifcCartesianTransformationOperator3DnonUniform);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCartesianTransformationOperator3DnonUniform);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCartesianTransformationOperator3DnonUniform);
			if (result == null)
				result = caseIfcLayeredItem(ifcCartesianTransformationOperator3DnonUniform);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CENTER_LINE_PROFILE_DEF: {
			IfcCenterLineProfileDef ifcCenterLineProfileDef = (IfcCenterLineProfileDef) theEObject;
			T result = caseIfcCenterLineProfileDef(ifcCenterLineProfileDef);
			if (result == null)
				result = caseIfcArbitraryOpenProfileDef(ifcCenterLineProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcCenterLineProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcCenterLineProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CHILLER: {
			IfcChiller ifcChiller = (IfcChiller) theEObject;
			T result = caseIfcChiller(ifcChiller);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcChiller);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcChiller);
			if (result == null)
				result = caseIfcDistributionElement(ifcChiller);
			if (result == null)
				result = caseIfcElement(ifcChiller);
			if (result == null)
				result = caseIfcProduct(ifcChiller);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcChiller);
			if (result == null)
				result = caseIfcObject(ifcChiller);
			if (result == null)
				result = caseIfcProductSelect(ifcChiller);
			if (result == null)
				result = caseIfcObjectDefinition(ifcChiller);
			if (result == null)
				result = caseIfcRoot(ifcChiller);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcChiller);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CHILLER_TYPE: {
			IfcChillerType ifcChillerType = (IfcChillerType) theEObject;
			T result = caseIfcChillerType(ifcChillerType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcChillerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcChillerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcChillerType);
			if (result == null)
				result = caseIfcElementType(ifcChillerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcChillerType);
			if (result == null)
				result = caseIfcTypeObject(ifcChillerType);
			if (result == null)
				result = caseIfcProductSelect(ifcChillerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcChillerType);
			if (result == null)
				result = caseIfcRoot(ifcChillerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcChillerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CHIMNEY: {
			IfcChimney ifcChimney = (IfcChimney) theEObject;
			T result = caseIfcChimney(ifcChimney);
			if (result == null)
				result = caseIfcBuildingElement(ifcChimney);
			if (result == null)
				result = caseIfcElement(ifcChimney);
			if (result == null)
				result = caseIfcProduct(ifcChimney);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcChimney);
			if (result == null)
				result = caseIfcObject(ifcChimney);
			if (result == null)
				result = caseIfcProductSelect(ifcChimney);
			if (result == null)
				result = caseIfcObjectDefinition(ifcChimney);
			if (result == null)
				result = caseIfcRoot(ifcChimney);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcChimney);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CHIMNEY_TYPE: {
			IfcChimneyType ifcChimneyType = (IfcChimneyType) theEObject;
			T result = caseIfcChimneyType(ifcChimneyType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcChimneyType);
			if (result == null)
				result = caseIfcElementType(ifcChimneyType);
			if (result == null)
				result = caseIfcTypeProduct(ifcChimneyType);
			if (result == null)
				result = caseIfcTypeObject(ifcChimneyType);
			if (result == null)
				result = caseIfcProductSelect(ifcChimneyType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcChimneyType);
			if (result == null)
				result = caseIfcRoot(ifcChimneyType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcChimneyType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CIRCLE: {
			IfcCircle ifcCircle = (IfcCircle) theEObject;
			T result = caseIfcCircle(ifcCircle);
			if (result == null)
				result = caseIfcConic(ifcCircle);
			if (result == null)
				result = caseIfcCurve(ifcCircle);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCircle);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcCircle);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCircle);
			if (result == null)
				result = caseIfcLayeredItem(ifcCircle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CIRCLE_HOLLOW_PROFILE_DEF: {
			IfcCircleHollowProfileDef ifcCircleHollowProfileDef = (IfcCircleHollowProfileDef) theEObject;
			T result = caseIfcCircleHollowProfileDef(ifcCircleHollowProfileDef);
			if (result == null)
				result = caseIfcCircleProfileDef(ifcCircleHollowProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcCircleHollowProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcCircleHollowProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcCircleHollowProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CIRCLE_PROFILE_DEF: {
			IfcCircleProfileDef ifcCircleProfileDef = (IfcCircleProfileDef) theEObject;
			T result = caseIfcCircleProfileDef(ifcCircleProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcCircleProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcCircleProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcCircleProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CIVIL_ELEMENT: {
			IfcCivilElement ifcCivilElement = (IfcCivilElement) theEObject;
			T result = caseIfcCivilElement(ifcCivilElement);
			if (result == null)
				result = caseIfcElement(ifcCivilElement);
			if (result == null)
				result = caseIfcProduct(ifcCivilElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCivilElement);
			if (result == null)
				result = caseIfcObject(ifcCivilElement);
			if (result == null)
				result = caseIfcProductSelect(ifcCivilElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCivilElement);
			if (result == null)
				result = caseIfcRoot(ifcCivilElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCivilElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CIVIL_ELEMENT_TYPE: {
			IfcCivilElementType ifcCivilElementType = (IfcCivilElementType) theEObject;
			T result = caseIfcCivilElementType(ifcCivilElementType);
			if (result == null)
				result = caseIfcElementType(ifcCivilElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCivilElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcCivilElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcCivilElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCivilElementType);
			if (result == null)
				result = caseIfcRoot(ifcCivilElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCivilElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CLASSIFICATION: {
			IfcClassification ifcClassification = (IfcClassification) theEObject;
			T result = caseIfcClassification(ifcClassification);
			if (result == null)
				result = caseIfcExternalInformation(ifcClassification);
			if (result == null)
				result = caseIfcClassificationReferenceSelect(ifcClassification);
			if (result == null)
				result = caseIfcClassificationSelect(ifcClassification);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcClassification);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CLASSIFICATION_REFERENCE: {
			IfcClassificationReference ifcClassificationReference = (IfcClassificationReference) theEObject;
			T result = caseIfcClassificationReference(ifcClassificationReference);
			if (result == null)
				result = caseIfcExternalReference(ifcClassificationReference);
			if (result == null)
				result = caseIfcClassificationReferenceSelect(ifcClassificationReference);
			if (result == null)
				result = caseIfcClassificationSelect(ifcClassificationReference);
			if (result == null)
				result = caseIfcLightDistributionDataSourceSelect(ifcClassificationReference);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcClassificationReference);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcClassificationReference);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CLOSED_SHELL: {
			IfcClosedShell ifcClosedShell = (IfcClosedShell) theEObject;
			T result = caseIfcClosedShell(ifcClosedShell);
			if (result == null)
				result = caseIfcConnectedFaceSet(ifcClosedShell);
			if (result == null)
				result = caseIfcShell(ifcClosedShell);
			if (result == null)
				result = caseIfcSolidOrShell(ifcClosedShell);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcClosedShell);
			if (result == null)
				result = caseIfcRepresentationItem(ifcClosedShell);
			if (result == null)
				result = caseIfcLayeredItem(ifcClosedShell);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COIL: {
			IfcCoil ifcCoil = (IfcCoil) theEObject;
			T result = caseIfcCoil(ifcCoil);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcCoil);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCoil);
			if (result == null)
				result = caseIfcDistributionElement(ifcCoil);
			if (result == null)
				result = caseIfcElement(ifcCoil);
			if (result == null)
				result = caseIfcProduct(ifcCoil);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCoil);
			if (result == null)
				result = caseIfcObject(ifcCoil);
			if (result == null)
				result = caseIfcProductSelect(ifcCoil);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCoil);
			if (result == null)
				result = caseIfcRoot(ifcCoil);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCoil);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COIL_TYPE: {
			IfcCoilType ifcCoilType = (IfcCoilType) theEObject;
			T result = caseIfcCoilType(ifcCoilType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcCoilType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCoilType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCoilType);
			if (result == null)
				result = caseIfcElementType(ifcCoilType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCoilType);
			if (result == null)
				result = caseIfcTypeObject(ifcCoilType);
			if (result == null)
				result = caseIfcProductSelect(ifcCoilType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCoilType);
			if (result == null)
				result = caseIfcRoot(ifcCoilType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCoilType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COLOUR_RGB: {
			IfcColourRgb ifcColourRgb = (IfcColourRgb) theEObject;
			T result = caseIfcColourRgb(ifcColourRgb);
			if (result == null)
				result = caseIfcColourSpecification(ifcColourRgb);
			if (result == null)
				result = caseIfcColourOrFactor(ifcColourRgb);
			if (result == null)
				result = caseIfcPresentationItem(ifcColourRgb);
			if (result == null)
				result = caseIfcColour(ifcColourRgb);
			if (result == null)
				result = caseIfcFillStyleSelect(ifcColourRgb);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COLOUR_RGB_LIST: {
			IfcColourRgbList ifcColourRgbList = (IfcColourRgbList) theEObject;
			T result = caseIfcColourRgbList(ifcColourRgbList);
			if (result == null)
				result = caseIfcPresentationItem(ifcColourRgbList);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COLOUR_SPECIFICATION: {
			IfcColourSpecification ifcColourSpecification = (IfcColourSpecification) theEObject;
			T result = caseIfcColourSpecification(ifcColourSpecification);
			if (result == null)
				result = caseIfcPresentationItem(ifcColourSpecification);
			if (result == null)
				result = caseIfcColour(ifcColourSpecification);
			if (result == null)
				result = caseIfcFillStyleSelect(ifcColourSpecification);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COLUMN: {
			IfcColumn ifcColumn = (IfcColumn) theEObject;
			T result = caseIfcColumn(ifcColumn);
			if (result == null)
				result = caseIfcBuildingElement(ifcColumn);
			if (result == null)
				result = caseIfcElement(ifcColumn);
			if (result == null)
				result = caseIfcProduct(ifcColumn);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcColumn);
			if (result == null)
				result = caseIfcObject(ifcColumn);
			if (result == null)
				result = caseIfcProductSelect(ifcColumn);
			if (result == null)
				result = caseIfcObjectDefinition(ifcColumn);
			if (result == null)
				result = caseIfcRoot(ifcColumn);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcColumn);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COLUMN_STANDARD_CASE: {
			IfcColumnStandardCase ifcColumnStandardCase = (IfcColumnStandardCase) theEObject;
			T result = caseIfcColumnStandardCase(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcColumn(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcElement(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcObject(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcColumnStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcColumnStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COLUMN_TYPE: {
			IfcColumnType ifcColumnType = (IfcColumnType) theEObject;
			T result = caseIfcColumnType(ifcColumnType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcColumnType);
			if (result == null)
				result = caseIfcElementType(ifcColumnType);
			if (result == null)
				result = caseIfcTypeProduct(ifcColumnType);
			if (result == null)
				result = caseIfcTypeObject(ifcColumnType);
			if (result == null)
				result = caseIfcProductSelect(ifcColumnType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcColumnType);
			if (result == null)
				result = caseIfcRoot(ifcColumnType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcColumnType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMMUNICATIONS_APPLIANCE: {
			IfcCommunicationsAppliance ifcCommunicationsAppliance = (IfcCommunicationsAppliance) theEObject;
			T result = caseIfcCommunicationsAppliance(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcFlowTerminal(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcDistributionElement(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcElement(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcProduct(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcObject(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcProductSelect(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcRoot(ifcCommunicationsAppliance);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCommunicationsAppliance);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMMUNICATIONS_APPLIANCE_TYPE: {
			IfcCommunicationsApplianceType ifcCommunicationsApplianceType = (IfcCommunicationsApplianceType) theEObject;
			T result = caseIfcCommunicationsApplianceType(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcElementType(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcTypeObject(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcProductSelect(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcRoot(ifcCommunicationsApplianceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCommunicationsApplianceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPLEX_PROPERTY: {
			IfcComplexProperty ifcComplexProperty = (IfcComplexProperty) theEObject;
			T result = caseIfcComplexProperty(ifcComplexProperty);
			if (result == null)
				result = caseIfcProperty(ifcComplexProperty);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcComplexProperty);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcComplexProperty);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPLEX_PROPERTY_TEMPLATE: {
			IfcComplexPropertyTemplate ifcComplexPropertyTemplate = (IfcComplexPropertyTemplate) theEObject;
			T result = caseIfcComplexPropertyTemplate(ifcComplexPropertyTemplate);
			if (result == null)
				result = caseIfcPropertyTemplate(ifcComplexPropertyTemplate);
			if (result == null)
				result = caseIfcPropertyTemplateDefinition(ifcComplexPropertyTemplate);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcComplexPropertyTemplate);
			if (result == null)
				result = caseIfcRoot(ifcComplexPropertyTemplate);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcComplexPropertyTemplate);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPOSITE_CURVE: {
			IfcCompositeCurve ifcCompositeCurve = (IfcCompositeCurve) theEObject;
			T result = caseIfcCompositeCurve(ifcCompositeCurve);
			if (result == null)
				result = caseIfcBoundedCurve(ifcCompositeCurve);
			if (result == null)
				result = caseIfcCurve(ifcCompositeCurve);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcCompositeCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCompositeCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcCompositeCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCompositeCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcCompositeCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPOSITE_CURVE_ON_SURFACE: {
			IfcCompositeCurveOnSurface ifcCompositeCurveOnSurface = (IfcCompositeCurveOnSurface) theEObject;
			T result = caseIfcCompositeCurveOnSurface(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcCompositeCurve(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcCurveOnSurface(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcBoundedCurve(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcCurve(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCompositeCurveOnSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcCompositeCurveOnSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPOSITE_CURVE_SEGMENT: {
			IfcCompositeCurveSegment ifcCompositeCurveSegment = (IfcCompositeCurveSegment) theEObject;
			T result = caseIfcCompositeCurveSegment(ifcCompositeCurveSegment);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCompositeCurveSegment);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCompositeCurveSegment);
			if (result == null)
				result = caseIfcLayeredItem(ifcCompositeCurveSegment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPOSITE_PROFILE_DEF: {
			IfcCompositeProfileDef ifcCompositeProfileDef = (IfcCompositeProfileDef) theEObject;
			T result = caseIfcCompositeProfileDef(ifcCompositeProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcCompositeProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcCompositeProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPRESSOR: {
			IfcCompressor ifcCompressor = (IfcCompressor) theEObject;
			T result = caseIfcCompressor(ifcCompressor);
			if (result == null)
				result = caseIfcFlowMovingDevice(ifcCompressor);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCompressor);
			if (result == null)
				result = caseIfcDistributionElement(ifcCompressor);
			if (result == null)
				result = caseIfcElement(ifcCompressor);
			if (result == null)
				result = caseIfcProduct(ifcCompressor);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCompressor);
			if (result == null)
				result = caseIfcObject(ifcCompressor);
			if (result == null)
				result = caseIfcProductSelect(ifcCompressor);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCompressor);
			if (result == null)
				result = caseIfcRoot(ifcCompressor);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCompressor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPRESSOR_TYPE: {
			IfcCompressorType ifcCompressorType = (IfcCompressorType) theEObject;
			T result = caseIfcCompressorType(ifcCompressorType);
			if (result == null)
				result = caseIfcFlowMovingDeviceType(ifcCompressorType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCompressorType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCompressorType);
			if (result == null)
				result = caseIfcElementType(ifcCompressorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCompressorType);
			if (result == null)
				result = caseIfcTypeObject(ifcCompressorType);
			if (result == null)
				result = caseIfcProductSelect(ifcCompressorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCompressorType);
			if (result == null)
				result = caseIfcRoot(ifcCompressorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCompressorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONDENSER: {
			IfcCondenser ifcCondenser = (IfcCondenser) theEObject;
			T result = caseIfcCondenser(ifcCondenser);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcCondenser);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCondenser);
			if (result == null)
				result = caseIfcDistributionElement(ifcCondenser);
			if (result == null)
				result = caseIfcElement(ifcCondenser);
			if (result == null)
				result = caseIfcProduct(ifcCondenser);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCondenser);
			if (result == null)
				result = caseIfcObject(ifcCondenser);
			if (result == null)
				result = caseIfcProductSelect(ifcCondenser);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCondenser);
			if (result == null)
				result = caseIfcRoot(ifcCondenser);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCondenser);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONDENSER_TYPE: {
			IfcCondenserType ifcCondenserType = (IfcCondenserType) theEObject;
			T result = caseIfcCondenserType(ifcCondenserType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcCondenserType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCondenserType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCondenserType);
			if (result == null)
				result = caseIfcElementType(ifcCondenserType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCondenserType);
			if (result == null)
				result = caseIfcTypeObject(ifcCondenserType);
			if (result == null)
				result = caseIfcProductSelect(ifcCondenserType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCondenserType);
			if (result == null)
				result = caseIfcRoot(ifcCondenserType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCondenserType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONIC: {
			IfcConic ifcConic = (IfcConic) theEObject;
			T result = caseIfcConic(ifcConic);
			if (result == null)
				result = caseIfcCurve(ifcConic);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcConic);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcConic);
			if (result == null)
				result = caseIfcRepresentationItem(ifcConic);
			if (result == null)
				result = caseIfcLayeredItem(ifcConic);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONNECTED_FACE_SET: {
			IfcConnectedFaceSet ifcConnectedFaceSet = (IfcConnectedFaceSet) theEObject;
			T result = caseIfcConnectedFaceSet(ifcConnectedFaceSet);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcConnectedFaceSet);
			if (result == null)
				result = caseIfcRepresentationItem(ifcConnectedFaceSet);
			if (result == null)
				result = caseIfcLayeredItem(ifcConnectedFaceSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONNECTION_CURVE_GEOMETRY: {
			IfcConnectionCurveGeometry ifcConnectionCurveGeometry = (IfcConnectionCurveGeometry) theEObject;
			T result = caseIfcConnectionCurveGeometry(ifcConnectionCurveGeometry);
			if (result == null)
				result = caseIfcConnectionGeometry(ifcConnectionCurveGeometry);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONNECTION_GEOMETRY: {
			IfcConnectionGeometry ifcConnectionGeometry = (IfcConnectionGeometry) theEObject;
			T result = caseIfcConnectionGeometry(ifcConnectionGeometry);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONNECTION_POINT_ECCENTRICITY: {
			IfcConnectionPointEccentricity ifcConnectionPointEccentricity = (IfcConnectionPointEccentricity) theEObject;
			T result = caseIfcConnectionPointEccentricity(ifcConnectionPointEccentricity);
			if (result == null)
				result = caseIfcConnectionPointGeometry(ifcConnectionPointEccentricity);
			if (result == null)
				result = caseIfcConnectionGeometry(ifcConnectionPointEccentricity);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONNECTION_POINT_GEOMETRY: {
			IfcConnectionPointGeometry ifcConnectionPointGeometry = (IfcConnectionPointGeometry) theEObject;
			T result = caseIfcConnectionPointGeometry(ifcConnectionPointGeometry);
			if (result == null)
				result = caseIfcConnectionGeometry(ifcConnectionPointGeometry);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONNECTION_SURFACE_GEOMETRY: {
			IfcConnectionSurfaceGeometry ifcConnectionSurfaceGeometry = (IfcConnectionSurfaceGeometry) theEObject;
			T result = caseIfcConnectionSurfaceGeometry(ifcConnectionSurfaceGeometry);
			if (result == null)
				result = caseIfcConnectionGeometry(ifcConnectionSurfaceGeometry);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONNECTION_VOLUME_GEOMETRY: {
			IfcConnectionVolumeGeometry ifcConnectionVolumeGeometry = (IfcConnectionVolumeGeometry) theEObject;
			T result = caseIfcConnectionVolumeGeometry(ifcConnectionVolumeGeometry);
			if (result == null)
				result = caseIfcConnectionGeometry(ifcConnectionVolumeGeometry);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRAINT: {
			IfcConstraint ifcConstraint = (IfcConstraint) theEObject;
			T result = caseIfcConstraint(ifcConstraint);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcConstraint);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRUCTION_EQUIPMENT_RESOURCE: {
			IfcConstructionEquipmentResource ifcConstructionEquipmentResource = (IfcConstructionEquipmentResource) theEObject;
			T result = caseIfcConstructionEquipmentResource(ifcConstructionEquipmentResource);
			if (result == null)
				result = caseIfcConstructionResource(ifcConstructionEquipmentResource);
			if (result == null)
				result = caseIfcResource(ifcConstructionEquipmentResource);
			if (result == null)
				result = caseIfcObject(ifcConstructionEquipmentResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcConstructionEquipmentResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcConstructionEquipmentResource);
			if (result == null)
				result = caseIfcRoot(ifcConstructionEquipmentResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcConstructionEquipmentResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE: {
			IfcConstructionEquipmentResourceType ifcConstructionEquipmentResourceType = (IfcConstructionEquipmentResourceType) theEObject;
			T result = caseIfcConstructionEquipmentResourceType(ifcConstructionEquipmentResourceType);
			if (result == null)
				result = caseIfcConstructionResourceType(ifcConstructionEquipmentResourceType);
			if (result == null)
				result = caseIfcTypeResource(ifcConstructionEquipmentResourceType);
			if (result == null)
				result = caseIfcTypeObject(ifcConstructionEquipmentResourceType);
			if (result == null)
				result = caseIfcResourceSelect(ifcConstructionEquipmentResourceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcConstructionEquipmentResourceType);
			if (result == null)
				result = caseIfcRoot(ifcConstructionEquipmentResourceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcConstructionEquipmentResourceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRUCTION_MATERIAL_RESOURCE: {
			IfcConstructionMaterialResource ifcConstructionMaterialResource = (IfcConstructionMaterialResource) theEObject;
			T result = caseIfcConstructionMaterialResource(ifcConstructionMaterialResource);
			if (result == null)
				result = caseIfcConstructionResource(ifcConstructionMaterialResource);
			if (result == null)
				result = caseIfcResource(ifcConstructionMaterialResource);
			if (result == null)
				result = caseIfcObject(ifcConstructionMaterialResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcConstructionMaterialResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcConstructionMaterialResource);
			if (result == null)
				result = caseIfcRoot(ifcConstructionMaterialResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcConstructionMaterialResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE: {
			IfcConstructionMaterialResourceType ifcConstructionMaterialResourceType = (IfcConstructionMaterialResourceType) theEObject;
			T result = caseIfcConstructionMaterialResourceType(ifcConstructionMaterialResourceType);
			if (result == null)
				result = caseIfcConstructionResourceType(ifcConstructionMaterialResourceType);
			if (result == null)
				result = caseIfcTypeResource(ifcConstructionMaterialResourceType);
			if (result == null)
				result = caseIfcTypeObject(ifcConstructionMaterialResourceType);
			if (result == null)
				result = caseIfcResourceSelect(ifcConstructionMaterialResourceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcConstructionMaterialResourceType);
			if (result == null)
				result = caseIfcRoot(ifcConstructionMaterialResourceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcConstructionMaterialResourceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRUCTION_PRODUCT_RESOURCE: {
			IfcConstructionProductResource ifcConstructionProductResource = (IfcConstructionProductResource) theEObject;
			T result = caseIfcConstructionProductResource(ifcConstructionProductResource);
			if (result == null)
				result = caseIfcConstructionResource(ifcConstructionProductResource);
			if (result == null)
				result = caseIfcResource(ifcConstructionProductResource);
			if (result == null)
				result = caseIfcObject(ifcConstructionProductResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcConstructionProductResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcConstructionProductResource);
			if (result == null)
				result = caseIfcRoot(ifcConstructionProductResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcConstructionProductResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE: {
			IfcConstructionProductResourceType ifcConstructionProductResourceType = (IfcConstructionProductResourceType) theEObject;
			T result = caseIfcConstructionProductResourceType(ifcConstructionProductResourceType);
			if (result == null)
				result = caseIfcConstructionResourceType(ifcConstructionProductResourceType);
			if (result == null)
				result = caseIfcTypeResource(ifcConstructionProductResourceType);
			if (result == null)
				result = caseIfcTypeObject(ifcConstructionProductResourceType);
			if (result == null)
				result = caseIfcResourceSelect(ifcConstructionProductResourceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcConstructionProductResourceType);
			if (result == null)
				result = caseIfcRoot(ifcConstructionProductResourceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcConstructionProductResourceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRUCTION_RESOURCE: {
			IfcConstructionResource ifcConstructionResource = (IfcConstructionResource) theEObject;
			T result = caseIfcConstructionResource(ifcConstructionResource);
			if (result == null)
				result = caseIfcResource(ifcConstructionResource);
			if (result == null)
				result = caseIfcObject(ifcConstructionResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcConstructionResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcConstructionResource);
			if (result == null)
				result = caseIfcRoot(ifcConstructionResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcConstructionResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONSTRUCTION_RESOURCE_TYPE: {
			IfcConstructionResourceType ifcConstructionResourceType = (IfcConstructionResourceType) theEObject;
			T result = caseIfcConstructionResourceType(ifcConstructionResourceType);
			if (result == null)
				result = caseIfcTypeResource(ifcConstructionResourceType);
			if (result == null)
				result = caseIfcTypeObject(ifcConstructionResourceType);
			if (result == null)
				result = caseIfcResourceSelect(ifcConstructionResourceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcConstructionResourceType);
			if (result == null)
				result = caseIfcRoot(ifcConstructionResourceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcConstructionResourceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONTEXT: {
			IfcContext ifcContext = (IfcContext) theEObject;
			T result = caseIfcContext(ifcContext);
			if (result == null)
				result = caseIfcObjectDefinition(ifcContext);
			if (result == null)
				result = caseIfcRoot(ifcContext);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcContext);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONTEXT_DEPENDENT_UNIT: {
			IfcContextDependentUnit ifcContextDependentUnit = (IfcContextDependentUnit) theEObject;
			T result = caseIfcContextDependentUnit(ifcContextDependentUnit);
			if (result == null)
				result = caseIfcNamedUnit(ifcContextDependentUnit);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcContextDependentUnit);
			if (result == null)
				result = caseIfcUnit(ifcContextDependentUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONTROL: {
			IfcControl ifcControl = (IfcControl) theEObject;
			T result = caseIfcControl(ifcControl);
			if (result == null)
				result = caseIfcObject(ifcControl);
			if (result == null)
				result = caseIfcObjectDefinition(ifcControl);
			if (result == null)
				result = caseIfcRoot(ifcControl);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcControl);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONTROLLER: {
			IfcController ifcController = (IfcController) theEObject;
			T result = caseIfcController(ifcController);
			if (result == null)
				result = caseIfcDistributionControlElement(ifcController);
			if (result == null)
				result = caseIfcDistributionElement(ifcController);
			if (result == null)
				result = caseIfcElement(ifcController);
			if (result == null)
				result = caseIfcProduct(ifcController);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcController);
			if (result == null)
				result = caseIfcObject(ifcController);
			if (result == null)
				result = caseIfcProductSelect(ifcController);
			if (result == null)
				result = caseIfcObjectDefinition(ifcController);
			if (result == null)
				result = caseIfcRoot(ifcController);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcController);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONTROLLER_TYPE: {
			IfcControllerType ifcControllerType = (IfcControllerType) theEObject;
			T result = caseIfcControllerType(ifcControllerType);
			if (result == null)
				result = caseIfcDistributionControlElementType(ifcControllerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcControllerType);
			if (result == null)
				result = caseIfcElementType(ifcControllerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcControllerType);
			if (result == null)
				result = caseIfcTypeObject(ifcControllerType);
			if (result == null)
				result = caseIfcProductSelect(ifcControllerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcControllerType);
			if (result == null)
				result = caseIfcRoot(ifcControllerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcControllerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONVERSION_BASED_UNIT: {
			IfcConversionBasedUnit ifcConversionBasedUnit = (IfcConversionBasedUnit) theEObject;
			T result = caseIfcConversionBasedUnit(ifcConversionBasedUnit);
			if (result == null)
				result = caseIfcNamedUnit(ifcConversionBasedUnit);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcConversionBasedUnit);
			if (result == null)
				result = caseIfcUnit(ifcConversionBasedUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONVERSION_BASED_UNIT_WITH_OFFSET: {
			IfcConversionBasedUnitWithOffset ifcConversionBasedUnitWithOffset = (IfcConversionBasedUnitWithOffset) theEObject;
			T result = caseIfcConversionBasedUnitWithOffset(ifcConversionBasedUnitWithOffset);
			if (result == null)
				result = caseIfcConversionBasedUnit(ifcConversionBasedUnitWithOffset);
			if (result == null)
				result = caseIfcNamedUnit(ifcConversionBasedUnitWithOffset);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcConversionBasedUnitWithOffset);
			if (result == null)
				result = caseIfcUnit(ifcConversionBasedUnitWithOffset);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COOLED_BEAM: {
			IfcCooledBeam ifcCooledBeam = (IfcCooledBeam) theEObject;
			T result = caseIfcCooledBeam(ifcCooledBeam);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcCooledBeam);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCooledBeam);
			if (result == null)
				result = caseIfcDistributionElement(ifcCooledBeam);
			if (result == null)
				result = caseIfcElement(ifcCooledBeam);
			if (result == null)
				result = caseIfcProduct(ifcCooledBeam);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCooledBeam);
			if (result == null)
				result = caseIfcObject(ifcCooledBeam);
			if (result == null)
				result = caseIfcProductSelect(ifcCooledBeam);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCooledBeam);
			if (result == null)
				result = caseIfcRoot(ifcCooledBeam);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCooledBeam);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COOLED_BEAM_TYPE: {
			IfcCooledBeamType ifcCooledBeamType = (IfcCooledBeamType) theEObject;
			T result = caseIfcCooledBeamType(ifcCooledBeamType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcCooledBeamType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCooledBeamType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCooledBeamType);
			if (result == null)
				result = caseIfcElementType(ifcCooledBeamType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCooledBeamType);
			if (result == null)
				result = caseIfcTypeObject(ifcCooledBeamType);
			if (result == null)
				result = caseIfcProductSelect(ifcCooledBeamType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCooledBeamType);
			if (result == null)
				result = caseIfcRoot(ifcCooledBeamType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCooledBeamType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COOLING_TOWER: {
			IfcCoolingTower ifcCoolingTower = (IfcCoolingTower) theEObject;
			T result = caseIfcCoolingTower(ifcCoolingTower);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcCoolingTower);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcCoolingTower);
			if (result == null)
				result = caseIfcDistributionElement(ifcCoolingTower);
			if (result == null)
				result = caseIfcElement(ifcCoolingTower);
			if (result == null)
				result = caseIfcProduct(ifcCoolingTower);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCoolingTower);
			if (result == null)
				result = caseIfcObject(ifcCoolingTower);
			if (result == null)
				result = caseIfcProductSelect(ifcCoolingTower);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCoolingTower);
			if (result == null)
				result = caseIfcRoot(ifcCoolingTower);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCoolingTower);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COOLING_TOWER_TYPE: {
			IfcCoolingTowerType ifcCoolingTowerType = (IfcCoolingTowerType) theEObject;
			T result = caseIfcCoolingTowerType(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcElementType(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcTypeObject(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcProductSelect(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcRoot(ifcCoolingTowerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCoolingTowerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COORDINATE_OPERATION: {
			IfcCoordinateOperation ifcCoordinateOperation = (IfcCoordinateOperation) theEObject;
			T result = caseIfcCoordinateOperation(ifcCoordinateOperation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COORDINATE_REFERENCE_SYSTEM: {
			IfcCoordinateReferenceSystem ifcCoordinateReferenceSystem = (IfcCoordinateReferenceSystem) theEObject;
			T result = caseIfcCoordinateReferenceSystem(ifcCoordinateReferenceSystem);
			if (result == null)
				result = caseIfcCoordinateReferenceSystemSelect(ifcCoordinateReferenceSystem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COST_ITEM: {
			IfcCostItem ifcCostItem = (IfcCostItem) theEObject;
			T result = caseIfcCostItem(ifcCostItem);
			if (result == null)
				result = caseIfcControl(ifcCostItem);
			if (result == null)
				result = caseIfcObject(ifcCostItem);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCostItem);
			if (result == null)
				result = caseIfcRoot(ifcCostItem);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCostItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COST_SCHEDULE: {
			IfcCostSchedule ifcCostSchedule = (IfcCostSchedule) theEObject;
			T result = caseIfcCostSchedule(ifcCostSchedule);
			if (result == null)
				result = caseIfcControl(ifcCostSchedule);
			if (result == null)
				result = caseIfcObject(ifcCostSchedule);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCostSchedule);
			if (result == null)
				result = caseIfcRoot(ifcCostSchedule);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCostSchedule);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COST_VALUE: {
			IfcCostValue ifcCostValue = (IfcCostValue) theEObject;
			T result = caseIfcCostValue(ifcCostValue);
			if (result == null)
				result = caseIfcAppliedValue(ifcCostValue);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcCostValue);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcCostValue);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcCostValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COVERING: {
			IfcCovering ifcCovering = (IfcCovering) theEObject;
			T result = caseIfcCovering(ifcCovering);
			if (result == null)
				result = caseIfcBuildingElement(ifcCovering);
			if (result == null)
				result = caseIfcElement(ifcCovering);
			if (result == null)
				result = caseIfcProduct(ifcCovering);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCovering);
			if (result == null)
				result = caseIfcObject(ifcCovering);
			if (result == null)
				result = caseIfcProductSelect(ifcCovering);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCovering);
			if (result == null)
				result = caseIfcRoot(ifcCovering);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCovering);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COVERING_TYPE: {
			IfcCoveringType ifcCoveringType = (IfcCoveringType) theEObject;
			T result = caseIfcCoveringType(ifcCoveringType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcCoveringType);
			if (result == null)
				result = caseIfcElementType(ifcCoveringType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCoveringType);
			if (result == null)
				result = caseIfcTypeObject(ifcCoveringType);
			if (result == null)
				result = caseIfcProductSelect(ifcCoveringType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCoveringType);
			if (result == null)
				result = caseIfcRoot(ifcCoveringType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCoveringType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CREW_RESOURCE: {
			IfcCrewResource ifcCrewResource = (IfcCrewResource) theEObject;
			T result = caseIfcCrewResource(ifcCrewResource);
			if (result == null)
				result = caseIfcConstructionResource(ifcCrewResource);
			if (result == null)
				result = caseIfcResource(ifcCrewResource);
			if (result == null)
				result = caseIfcObject(ifcCrewResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcCrewResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCrewResource);
			if (result == null)
				result = caseIfcRoot(ifcCrewResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCrewResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CREW_RESOURCE_TYPE: {
			IfcCrewResourceType ifcCrewResourceType = (IfcCrewResourceType) theEObject;
			T result = caseIfcCrewResourceType(ifcCrewResourceType);
			if (result == null)
				result = caseIfcConstructionResourceType(ifcCrewResourceType);
			if (result == null)
				result = caseIfcTypeResource(ifcCrewResourceType);
			if (result == null)
				result = caseIfcTypeObject(ifcCrewResourceType);
			if (result == null)
				result = caseIfcResourceSelect(ifcCrewResourceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCrewResourceType);
			if (result == null)
				result = caseIfcRoot(ifcCrewResourceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCrewResourceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CSG_PRIMITIVE3_D: {
			IfcCsgPrimitive3D ifcCsgPrimitive3D = (IfcCsgPrimitive3D) theEObject;
			T result = caseIfcCsgPrimitive3D(ifcCsgPrimitive3D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCsgPrimitive3D);
			if (result == null)
				result = caseIfcBooleanOperand(ifcCsgPrimitive3D);
			if (result == null)
				result = caseIfcCsgSelect(ifcCsgPrimitive3D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCsgPrimitive3D);
			if (result == null)
				result = caseIfcLayeredItem(ifcCsgPrimitive3D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CSG_SOLID: {
			IfcCsgSolid ifcCsgSolid = (IfcCsgSolid) theEObject;
			T result = caseIfcCsgSolid(ifcCsgSolid);
			if (result == null)
				result = caseIfcSolidModel(ifcCsgSolid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCsgSolid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcCsgSolid);
			if (result == null)
				result = caseIfcSolidOrShell(ifcCsgSolid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCsgSolid);
			if (result == null)
				result = caseIfcLayeredItem(ifcCsgSolid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURRENCY_RELATIONSHIP: {
			IfcCurrencyRelationship ifcCurrencyRelationship = (IfcCurrencyRelationship) theEObject;
			T result = caseIfcCurrencyRelationship(ifcCurrencyRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcCurrencyRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURTAIN_WALL: {
			IfcCurtainWall ifcCurtainWall = (IfcCurtainWall) theEObject;
			T result = caseIfcCurtainWall(ifcCurtainWall);
			if (result == null)
				result = caseIfcBuildingElement(ifcCurtainWall);
			if (result == null)
				result = caseIfcElement(ifcCurtainWall);
			if (result == null)
				result = caseIfcProduct(ifcCurtainWall);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcCurtainWall);
			if (result == null)
				result = caseIfcObject(ifcCurtainWall);
			if (result == null)
				result = caseIfcProductSelect(ifcCurtainWall);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCurtainWall);
			if (result == null)
				result = caseIfcRoot(ifcCurtainWall);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCurtainWall);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURTAIN_WALL_TYPE: {
			IfcCurtainWallType ifcCurtainWallType = (IfcCurtainWallType) theEObject;
			T result = caseIfcCurtainWallType(ifcCurtainWallType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcCurtainWallType);
			if (result == null)
				result = caseIfcElementType(ifcCurtainWallType);
			if (result == null)
				result = caseIfcTypeProduct(ifcCurtainWallType);
			if (result == null)
				result = caseIfcTypeObject(ifcCurtainWallType);
			if (result == null)
				result = caseIfcProductSelect(ifcCurtainWallType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcCurtainWallType);
			if (result == null)
				result = caseIfcRoot(ifcCurtainWallType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcCurtainWallType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE: {
			IfcCurve ifcCurve = (IfcCurve) theEObject;
			T result = caseIfcCurve(ifcCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_BOUNDED_PLANE: {
			IfcCurveBoundedPlane ifcCurveBoundedPlane = (IfcCurveBoundedPlane) theEObject;
			T result = caseIfcCurveBoundedPlane(ifcCurveBoundedPlane);
			if (result == null)
				result = caseIfcBoundedSurface(ifcCurveBoundedPlane);
			if (result == null)
				result = caseIfcSurface(ifcCurveBoundedPlane);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCurveBoundedPlane);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcCurveBoundedPlane);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcCurveBoundedPlane);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCurveBoundedPlane);
			if (result == null)
				result = caseIfcLayeredItem(ifcCurveBoundedPlane);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_BOUNDED_SURFACE: {
			IfcCurveBoundedSurface ifcCurveBoundedSurface = (IfcCurveBoundedSurface) theEObject;
			T result = caseIfcCurveBoundedSurface(ifcCurveBoundedSurface);
			if (result == null)
				result = caseIfcBoundedSurface(ifcCurveBoundedSurface);
			if (result == null)
				result = caseIfcSurface(ifcCurveBoundedSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCurveBoundedSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcCurveBoundedSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcCurveBoundedSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCurveBoundedSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcCurveBoundedSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_STYLE: {
			IfcCurveStyle ifcCurveStyle = (IfcCurveStyle) theEObject;
			T result = caseIfcCurveStyle(ifcCurveStyle);
			if (result == null)
				result = caseIfcPresentationStyle(ifcCurveStyle);
			if (result == null)
				result = caseIfcPresentationStyleSelect(ifcCurveStyle);
			if (result == null)
				result = caseIfcStyleAssignmentSelect(ifcCurveStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_STYLE_FONT: {
			IfcCurveStyleFont ifcCurveStyleFont = (IfcCurveStyleFont) theEObject;
			T result = caseIfcCurveStyleFont(ifcCurveStyleFont);
			if (result == null)
				result = caseIfcPresentationItem(ifcCurveStyleFont);
			if (result == null)
				result = caseIfcCurveStyleFontSelect(ifcCurveStyleFont);
			if (result == null)
				result = caseIfcCurveFontOrScaledCurveFontSelect(ifcCurveStyleFont);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_STYLE_FONT_AND_SCALING: {
			IfcCurveStyleFontAndScaling ifcCurveStyleFontAndScaling = (IfcCurveStyleFontAndScaling) theEObject;
			T result = caseIfcCurveStyleFontAndScaling(ifcCurveStyleFontAndScaling);
			if (result == null)
				result = caseIfcPresentationItem(ifcCurveStyleFontAndScaling);
			if (result == null)
				result = caseIfcCurveFontOrScaledCurveFontSelect(ifcCurveStyleFontAndScaling);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_STYLE_FONT_PATTERN: {
			IfcCurveStyleFontPattern ifcCurveStyleFontPattern = (IfcCurveStyleFontPattern) theEObject;
			T result = caseIfcCurveStyleFontPattern(ifcCurveStyleFontPattern);
			if (result == null)
				result = caseIfcPresentationItem(ifcCurveStyleFontPattern);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CYLINDRICAL_SURFACE: {
			IfcCylindricalSurface ifcCylindricalSurface = (IfcCylindricalSurface) theEObject;
			T result = caseIfcCylindricalSurface(ifcCylindricalSurface);
			if (result == null)
				result = caseIfcElementarySurface(ifcCylindricalSurface);
			if (result == null)
				result = caseIfcSurface(ifcCylindricalSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcCylindricalSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcCylindricalSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcCylindricalSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcCylindricalSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcCylindricalSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DAMPER: {
			IfcDamper ifcDamper = (IfcDamper) theEObject;
			T result = caseIfcDamper(ifcDamper);
			if (result == null)
				result = caseIfcFlowController(ifcDamper);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcDamper);
			if (result == null)
				result = caseIfcDistributionElement(ifcDamper);
			if (result == null)
				result = caseIfcElement(ifcDamper);
			if (result == null)
				result = caseIfcProduct(ifcDamper);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDamper);
			if (result == null)
				result = caseIfcObject(ifcDamper);
			if (result == null)
				result = caseIfcProductSelect(ifcDamper);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDamper);
			if (result == null)
				result = caseIfcRoot(ifcDamper);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDamper);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DAMPER_TYPE: {
			IfcDamperType ifcDamperType = (IfcDamperType) theEObject;
			T result = caseIfcDamperType(ifcDamperType);
			if (result == null)
				result = caseIfcFlowControllerType(ifcDamperType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcDamperType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcDamperType);
			if (result == null)
				result = caseIfcElementType(ifcDamperType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDamperType);
			if (result == null)
				result = caseIfcTypeObject(ifcDamperType);
			if (result == null)
				result = caseIfcProductSelect(ifcDamperType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDamperType);
			if (result == null)
				result = caseIfcRoot(ifcDamperType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDamperType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DERIVED_PROFILE_DEF: {
			IfcDerivedProfileDef ifcDerivedProfileDef = (IfcDerivedProfileDef) theEObject;
			T result = caseIfcDerivedProfileDef(ifcDerivedProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcDerivedProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcDerivedProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DERIVED_UNIT: {
			IfcDerivedUnit ifcDerivedUnit = (IfcDerivedUnit) theEObject;
			T result = caseIfcDerivedUnit(ifcDerivedUnit);
			if (result == null)
				result = caseIfcUnit(ifcDerivedUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DERIVED_UNIT_ELEMENT: {
			IfcDerivedUnitElement ifcDerivedUnitElement = (IfcDerivedUnitElement) theEObject;
			T result = caseIfcDerivedUnitElement(ifcDerivedUnitElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DIMENSIONAL_EXPONENTS: {
			IfcDimensionalExponents ifcDimensionalExponents = (IfcDimensionalExponents) theEObject;
			T result = caseIfcDimensionalExponents(ifcDimensionalExponents);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DIRECTION: {
			IfcDirection ifcDirection = (IfcDirection) theEObject;
			T result = caseIfcDirection(ifcDirection);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcDirection);
			if (result == null)
				result = caseIfcGridPlacementDirectionSelect(ifcDirection);
			if (result == null)
				result = caseIfcVectorOrDirection(ifcDirection);
			if (result == null)
				result = caseIfcRepresentationItem(ifcDirection);
			if (result == null)
				result = caseIfcLayeredItem(ifcDirection);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISCRETE_ACCESSORY: {
			IfcDiscreteAccessory ifcDiscreteAccessory = (IfcDiscreteAccessory) theEObject;
			T result = caseIfcDiscreteAccessory(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcElementComponent(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcElement(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcProduct(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcObject(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcProductSelect(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcRoot(ifcDiscreteAccessory);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDiscreteAccessory);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISCRETE_ACCESSORY_TYPE: {
			IfcDiscreteAccessoryType ifcDiscreteAccessoryType = (IfcDiscreteAccessoryType) theEObject;
			T result = caseIfcDiscreteAccessoryType(ifcDiscreteAccessoryType);
			if (result == null)
				result = caseIfcElementComponentType(ifcDiscreteAccessoryType);
			if (result == null)
				result = caseIfcElementType(ifcDiscreteAccessoryType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDiscreteAccessoryType);
			if (result == null)
				result = caseIfcTypeObject(ifcDiscreteAccessoryType);
			if (result == null)
				result = caseIfcProductSelect(ifcDiscreteAccessoryType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDiscreteAccessoryType);
			if (result == null)
				result = caseIfcRoot(ifcDiscreteAccessoryType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDiscreteAccessoryType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_CHAMBER_ELEMENT: {
			IfcDistributionChamberElement ifcDistributionChamberElement = (IfcDistributionChamberElement) theEObject;
			T result = caseIfcDistributionChamberElement(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcDistributionElement(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcElement(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcProduct(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcObject(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcRoot(ifcDistributionChamberElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionChamberElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_CHAMBER_ELEMENT_TYPE: {
			IfcDistributionChamberElementType ifcDistributionChamberElementType = (IfcDistributionChamberElementType) theEObject;
			T result = caseIfcDistributionChamberElementType(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcElementType(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcRoot(ifcDistributionChamberElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionChamberElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_CIRCUIT: {
			IfcDistributionCircuit ifcDistributionCircuit = (IfcDistributionCircuit) theEObject;
			T result = caseIfcDistributionCircuit(ifcDistributionCircuit);
			if (result == null)
				result = caseIfcDistributionSystem(ifcDistributionCircuit);
			if (result == null)
				result = caseIfcSystem(ifcDistributionCircuit);
			if (result == null)
				result = caseIfcGroup(ifcDistributionCircuit);
			if (result == null)
				result = caseIfcObject(ifcDistributionCircuit);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionCircuit);
			if (result == null)
				result = caseIfcRoot(ifcDistributionCircuit);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionCircuit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_CONTROL_ELEMENT: {
			IfcDistributionControlElement ifcDistributionControlElement = (IfcDistributionControlElement) theEObject;
			T result = caseIfcDistributionControlElement(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcDistributionElement(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcElement(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcProduct(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcObject(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcRoot(ifcDistributionControlElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionControlElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE: {
			IfcDistributionControlElementType ifcDistributionControlElementType = (IfcDistributionControlElementType) theEObject;
			T result = caseIfcDistributionControlElementType(ifcDistributionControlElementType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcDistributionControlElementType);
			if (result == null)
				result = caseIfcElementType(ifcDistributionControlElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDistributionControlElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcDistributionControlElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionControlElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionControlElementType);
			if (result == null)
				result = caseIfcRoot(ifcDistributionControlElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionControlElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_ELEMENT: {
			IfcDistributionElement ifcDistributionElement = (IfcDistributionElement) theEObject;
			T result = caseIfcDistributionElement(ifcDistributionElement);
			if (result == null)
				result = caseIfcElement(ifcDistributionElement);
			if (result == null)
				result = caseIfcProduct(ifcDistributionElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDistributionElement);
			if (result == null)
				result = caseIfcObject(ifcDistributionElement);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionElement);
			if (result == null)
				result = caseIfcRoot(ifcDistributionElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_ELEMENT_TYPE: {
			IfcDistributionElementType ifcDistributionElementType = (IfcDistributionElementType) theEObject;
			T result = caseIfcDistributionElementType(ifcDistributionElementType);
			if (result == null)
				result = caseIfcElementType(ifcDistributionElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDistributionElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcDistributionElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionElementType);
			if (result == null)
				result = caseIfcRoot(ifcDistributionElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_FLOW_ELEMENT: {
			IfcDistributionFlowElement ifcDistributionFlowElement = (IfcDistributionFlowElement) theEObject;
			T result = caseIfcDistributionFlowElement(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcDistributionElement(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcElement(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcProduct(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcObject(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcRoot(ifcDistributionFlowElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionFlowElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE: {
			IfcDistributionFlowElementType ifcDistributionFlowElementType = (IfcDistributionFlowElementType) theEObject;
			T result = caseIfcDistributionFlowElementType(ifcDistributionFlowElementType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcDistributionFlowElementType);
			if (result == null)
				result = caseIfcElementType(ifcDistributionFlowElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDistributionFlowElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcDistributionFlowElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionFlowElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionFlowElementType);
			if (result == null)
				result = caseIfcRoot(ifcDistributionFlowElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionFlowElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_PORT: {
			IfcDistributionPort ifcDistributionPort = (IfcDistributionPort) theEObject;
			T result = caseIfcDistributionPort(ifcDistributionPort);
			if (result == null)
				result = caseIfcPort(ifcDistributionPort);
			if (result == null)
				result = caseIfcProduct(ifcDistributionPort);
			if (result == null)
				result = caseIfcObject(ifcDistributionPort);
			if (result == null)
				result = caseIfcProductSelect(ifcDistributionPort);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionPort);
			if (result == null)
				result = caseIfcRoot(ifcDistributionPort);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionPort);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DISTRIBUTION_SYSTEM: {
			IfcDistributionSystem ifcDistributionSystem = (IfcDistributionSystem) theEObject;
			T result = caseIfcDistributionSystem(ifcDistributionSystem);
			if (result == null)
				result = caseIfcSystem(ifcDistributionSystem);
			if (result == null)
				result = caseIfcGroup(ifcDistributionSystem);
			if (result == null)
				result = caseIfcObject(ifcDistributionSystem);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDistributionSystem);
			if (result == null)
				result = caseIfcRoot(ifcDistributionSystem);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDistributionSystem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOCUMENT_INFORMATION: {
			IfcDocumentInformation ifcDocumentInformation = (IfcDocumentInformation) theEObject;
			T result = caseIfcDocumentInformation(ifcDocumentInformation);
			if (result == null)
				result = caseIfcExternalInformation(ifcDocumentInformation);
			if (result == null)
				result = caseIfcDocumentSelect(ifcDocumentInformation);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcDocumentInformation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOCUMENT_INFORMATION_RELATIONSHIP: {
			IfcDocumentInformationRelationship ifcDocumentInformationRelationship = (IfcDocumentInformationRelationship) theEObject;
			T result = caseIfcDocumentInformationRelationship(ifcDocumentInformationRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcDocumentInformationRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOCUMENT_REFERENCE: {
			IfcDocumentReference ifcDocumentReference = (IfcDocumentReference) theEObject;
			T result = caseIfcDocumentReference(ifcDocumentReference);
			if (result == null)
				result = caseIfcExternalReference(ifcDocumentReference);
			if (result == null)
				result = caseIfcDocumentSelect(ifcDocumentReference);
			if (result == null)
				result = caseIfcLightDistributionDataSourceSelect(ifcDocumentReference);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcDocumentReference);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcDocumentReference);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOOR: {
			IfcDoor ifcDoor = (IfcDoor) theEObject;
			T result = caseIfcDoor(ifcDoor);
			if (result == null)
				result = caseIfcBuildingElement(ifcDoor);
			if (result == null)
				result = caseIfcElement(ifcDoor);
			if (result == null)
				result = caseIfcProduct(ifcDoor);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDoor);
			if (result == null)
				result = caseIfcObject(ifcDoor);
			if (result == null)
				result = caseIfcProductSelect(ifcDoor);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDoor);
			if (result == null)
				result = caseIfcRoot(ifcDoor);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDoor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOOR_LINING_PROPERTIES: {
			IfcDoorLiningProperties ifcDoorLiningProperties = (IfcDoorLiningProperties) theEObject;
			T result = caseIfcDoorLiningProperties(ifcDoorLiningProperties);
			if (result == null)
				result = caseIfcPreDefinedPropertySet(ifcDoorLiningProperties);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcDoorLiningProperties);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcDoorLiningProperties);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcDoorLiningProperties);
			if (result == null)
				result = caseIfcRoot(ifcDoorLiningProperties);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDoorLiningProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOOR_PANEL_PROPERTIES: {
			IfcDoorPanelProperties ifcDoorPanelProperties = (IfcDoorPanelProperties) theEObject;
			T result = caseIfcDoorPanelProperties(ifcDoorPanelProperties);
			if (result == null)
				result = caseIfcPreDefinedPropertySet(ifcDoorPanelProperties);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcDoorPanelProperties);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcDoorPanelProperties);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcDoorPanelProperties);
			if (result == null)
				result = caseIfcRoot(ifcDoorPanelProperties);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDoorPanelProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOOR_STANDARD_CASE: {
			IfcDoorStandardCase ifcDoorStandardCase = (IfcDoorStandardCase) theEObject;
			T result = caseIfcDoorStandardCase(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcDoor(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcElement(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcObject(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcDoorStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDoorStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOOR_STYLE: {
			IfcDoorStyle ifcDoorStyle = (IfcDoorStyle) theEObject;
			T result = caseIfcDoorStyle(ifcDoorStyle);
			if (result == null)
				result = caseIfcTypeProduct(ifcDoorStyle);
			if (result == null)
				result = caseIfcTypeObject(ifcDoorStyle);
			if (result == null)
				result = caseIfcProductSelect(ifcDoorStyle);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDoorStyle);
			if (result == null)
				result = caseIfcRoot(ifcDoorStyle);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDoorStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOOR_TYPE: {
			IfcDoorType ifcDoorType = (IfcDoorType) theEObject;
			T result = caseIfcDoorType(ifcDoorType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcDoorType);
			if (result == null)
				result = caseIfcElementType(ifcDoorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDoorType);
			if (result == null)
				result = caseIfcTypeObject(ifcDoorType);
			if (result == null)
				result = caseIfcProductSelect(ifcDoorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDoorType);
			if (result == null)
				result = caseIfcRoot(ifcDoorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDoorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DRAUGHTING_PRE_DEFINED_COLOUR: {
			IfcDraughtingPreDefinedColour ifcDraughtingPreDefinedColour = (IfcDraughtingPreDefinedColour) theEObject;
			T result = caseIfcDraughtingPreDefinedColour(ifcDraughtingPreDefinedColour);
			if (result == null)
				result = caseIfcPreDefinedColour(ifcDraughtingPreDefinedColour);
			if (result == null)
				result = caseIfcPreDefinedItem(ifcDraughtingPreDefinedColour);
			if (result == null)
				result = caseIfcColour(ifcDraughtingPreDefinedColour);
			if (result == null)
				result = caseIfcPresentationItem(ifcDraughtingPreDefinedColour);
			if (result == null)
				result = caseIfcFillStyleSelect(ifcDraughtingPreDefinedColour);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DRAUGHTING_PRE_DEFINED_CURVE_FONT: {
			IfcDraughtingPreDefinedCurveFont ifcDraughtingPreDefinedCurveFont = (IfcDraughtingPreDefinedCurveFont) theEObject;
			T result = caseIfcDraughtingPreDefinedCurveFont(ifcDraughtingPreDefinedCurveFont);
			if (result == null)
				result = caseIfcPreDefinedCurveFont(ifcDraughtingPreDefinedCurveFont);
			if (result == null)
				result = caseIfcPreDefinedItem(ifcDraughtingPreDefinedCurveFont);
			if (result == null)
				result = caseIfcCurveStyleFontSelect(ifcDraughtingPreDefinedCurveFont);
			if (result == null)
				result = caseIfcPresentationItem(ifcDraughtingPreDefinedCurveFont);
			if (result == null)
				result = caseIfcCurveFontOrScaledCurveFontSelect(ifcDraughtingPreDefinedCurveFont);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DUCT_FITTING: {
			IfcDuctFitting ifcDuctFitting = (IfcDuctFitting) theEObject;
			T result = caseIfcDuctFitting(ifcDuctFitting);
			if (result == null)
				result = caseIfcFlowFitting(ifcDuctFitting);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcDuctFitting);
			if (result == null)
				result = caseIfcDistributionElement(ifcDuctFitting);
			if (result == null)
				result = caseIfcElement(ifcDuctFitting);
			if (result == null)
				result = caseIfcProduct(ifcDuctFitting);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDuctFitting);
			if (result == null)
				result = caseIfcObject(ifcDuctFitting);
			if (result == null)
				result = caseIfcProductSelect(ifcDuctFitting);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDuctFitting);
			if (result == null)
				result = caseIfcRoot(ifcDuctFitting);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDuctFitting);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DUCT_FITTING_TYPE: {
			IfcDuctFittingType ifcDuctFittingType = (IfcDuctFittingType) theEObject;
			T result = caseIfcDuctFittingType(ifcDuctFittingType);
			if (result == null)
				result = caseIfcFlowFittingType(ifcDuctFittingType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcDuctFittingType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcDuctFittingType);
			if (result == null)
				result = caseIfcElementType(ifcDuctFittingType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDuctFittingType);
			if (result == null)
				result = caseIfcTypeObject(ifcDuctFittingType);
			if (result == null)
				result = caseIfcProductSelect(ifcDuctFittingType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDuctFittingType);
			if (result == null)
				result = caseIfcRoot(ifcDuctFittingType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDuctFittingType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DUCT_SEGMENT: {
			IfcDuctSegment ifcDuctSegment = (IfcDuctSegment) theEObject;
			T result = caseIfcDuctSegment(ifcDuctSegment);
			if (result == null)
				result = caseIfcFlowSegment(ifcDuctSegment);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcDuctSegment);
			if (result == null)
				result = caseIfcDistributionElement(ifcDuctSegment);
			if (result == null)
				result = caseIfcElement(ifcDuctSegment);
			if (result == null)
				result = caseIfcProduct(ifcDuctSegment);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDuctSegment);
			if (result == null)
				result = caseIfcObject(ifcDuctSegment);
			if (result == null)
				result = caseIfcProductSelect(ifcDuctSegment);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDuctSegment);
			if (result == null)
				result = caseIfcRoot(ifcDuctSegment);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDuctSegment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DUCT_SEGMENT_TYPE: {
			IfcDuctSegmentType ifcDuctSegmentType = (IfcDuctSegmentType) theEObject;
			T result = caseIfcDuctSegmentType(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcFlowSegmentType(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcElementType(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcTypeObject(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcProductSelect(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcRoot(ifcDuctSegmentType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDuctSegmentType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DUCT_SILENCER: {
			IfcDuctSilencer ifcDuctSilencer = (IfcDuctSilencer) theEObject;
			T result = caseIfcDuctSilencer(ifcDuctSilencer);
			if (result == null)
				result = caseIfcFlowTreatmentDevice(ifcDuctSilencer);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcDuctSilencer);
			if (result == null)
				result = caseIfcDistributionElement(ifcDuctSilencer);
			if (result == null)
				result = caseIfcElement(ifcDuctSilencer);
			if (result == null)
				result = caseIfcProduct(ifcDuctSilencer);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcDuctSilencer);
			if (result == null)
				result = caseIfcObject(ifcDuctSilencer);
			if (result == null)
				result = caseIfcProductSelect(ifcDuctSilencer);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDuctSilencer);
			if (result == null)
				result = caseIfcRoot(ifcDuctSilencer);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDuctSilencer);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DUCT_SILENCER_TYPE: {
			IfcDuctSilencerType ifcDuctSilencerType = (IfcDuctSilencerType) theEObject;
			T result = caseIfcDuctSilencerType(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcFlowTreatmentDeviceType(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcElementType(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcTypeObject(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcProductSelect(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcRoot(ifcDuctSilencerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcDuctSilencerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EDGE: {
			IfcEdge ifcEdge = (IfcEdge) theEObject;
			T result = caseIfcEdge(ifcEdge);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcEdge);
			if (result == null)
				result = caseIfcRepresentationItem(ifcEdge);
			if (result == null)
				result = caseIfcLayeredItem(ifcEdge);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EDGE_CURVE: {
			IfcEdgeCurve ifcEdgeCurve = (IfcEdgeCurve) theEObject;
			T result = caseIfcEdgeCurve(ifcEdgeCurve);
			if (result == null)
				result = caseIfcEdge(ifcEdgeCurve);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcEdgeCurve);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcEdgeCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcEdgeCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcEdgeCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EDGE_LOOP: {
			IfcEdgeLoop ifcEdgeLoop = (IfcEdgeLoop) theEObject;
			T result = caseIfcEdgeLoop(ifcEdgeLoop);
			if (result == null)
				result = caseIfcLoop(ifcEdgeLoop);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcEdgeLoop);
			if (result == null)
				result = caseIfcRepresentationItem(ifcEdgeLoop);
			if (result == null)
				result = caseIfcLayeredItem(ifcEdgeLoop);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_APPLIANCE: {
			IfcElectricAppliance ifcElectricAppliance = (IfcElectricAppliance) theEObject;
			T result = caseIfcElectricAppliance(ifcElectricAppliance);
			if (result == null)
				result = caseIfcFlowTerminal(ifcElectricAppliance);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcElectricAppliance);
			if (result == null)
				result = caseIfcDistributionElement(ifcElectricAppliance);
			if (result == null)
				result = caseIfcElement(ifcElectricAppliance);
			if (result == null)
				result = caseIfcProduct(ifcElectricAppliance);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElectricAppliance);
			if (result == null)
				result = caseIfcObject(ifcElectricAppliance);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricAppliance);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricAppliance);
			if (result == null)
				result = caseIfcRoot(ifcElectricAppliance);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricAppliance);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_APPLIANCE_TYPE: {
			IfcElectricApplianceType ifcElectricApplianceType = (IfcElectricApplianceType) theEObject;
			T result = caseIfcElectricApplianceType(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcElementType(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcTypeObject(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcRoot(ifcElectricApplianceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricApplianceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_DISTRIBUTION_BOARD: {
			IfcElectricDistributionBoard ifcElectricDistributionBoard = (IfcElectricDistributionBoard) theEObject;
			T result = caseIfcElectricDistributionBoard(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcFlowController(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcDistributionElement(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcElement(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcProduct(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcObject(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcRoot(ifcElectricDistributionBoard);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricDistributionBoard);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_DISTRIBUTION_BOARD_TYPE: {
			IfcElectricDistributionBoardType ifcElectricDistributionBoardType = (IfcElectricDistributionBoardType) theEObject;
			T result = caseIfcElectricDistributionBoardType(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcFlowControllerType(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcElementType(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcTypeObject(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcRoot(ifcElectricDistributionBoardType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricDistributionBoardType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_FLOW_STORAGE_DEVICE: {
			IfcElectricFlowStorageDevice ifcElectricFlowStorageDevice = (IfcElectricFlowStorageDevice) theEObject;
			T result = caseIfcElectricFlowStorageDevice(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcFlowStorageDevice(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcElement(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcProduct(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcObject(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcRoot(ifcElectricFlowStorageDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricFlowStorageDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_FLOW_STORAGE_DEVICE_TYPE: {
			IfcElectricFlowStorageDeviceType ifcElectricFlowStorageDeviceType = (IfcElectricFlowStorageDeviceType) theEObject;
			T result = caseIfcElectricFlowStorageDeviceType(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcFlowStorageDeviceType(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricFlowStorageDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_GENERATOR: {
			IfcElectricGenerator ifcElectricGenerator = (IfcElectricGenerator) theEObject;
			T result = caseIfcElectricGenerator(ifcElectricGenerator);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcElectricGenerator);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcElectricGenerator);
			if (result == null)
				result = caseIfcDistributionElement(ifcElectricGenerator);
			if (result == null)
				result = caseIfcElement(ifcElectricGenerator);
			if (result == null)
				result = caseIfcProduct(ifcElectricGenerator);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElectricGenerator);
			if (result == null)
				result = caseIfcObject(ifcElectricGenerator);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricGenerator);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricGenerator);
			if (result == null)
				result = caseIfcRoot(ifcElectricGenerator);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricGenerator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_GENERATOR_TYPE: {
			IfcElectricGeneratorType ifcElectricGeneratorType = (IfcElectricGeneratorType) theEObject;
			T result = caseIfcElectricGeneratorType(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcElementType(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcTypeObject(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcRoot(ifcElectricGeneratorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricGeneratorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_MOTOR: {
			IfcElectricMotor ifcElectricMotor = (IfcElectricMotor) theEObject;
			T result = caseIfcElectricMotor(ifcElectricMotor);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcElectricMotor);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcElectricMotor);
			if (result == null)
				result = caseIfcDistributionElement(ifcElectricMotor);
			if (result == null)
				result = caseIfcElement(ifcElectricMotor);
			if (result == null)
				result = caseIfcProduct(ifcElectricMotor);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElectricMotor);
			if (result == null)
				result = caseIfcObject(ifcElectricMotor);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricMotor);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricMotor);
			if (result == null)
				result = caseIfcRoot(ifcElectricMotor);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricMotor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_MOTOR_TYPE: {
			IfcElectricMotorType ifcElectricMotorType = (IfcElectricMotorType) theEObject;
			T result = caseIfcElectricMotorType(ifcElectricMotorType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcElectricMotorType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcElectricMotorType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcElectricMotorType);
			if (result == null)
				result = caseIfcElementType(ifcElectricMotorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElectricMotorType);
			if (result == null)
				result = caseIfcTypeObject(ifcElectricMotorType);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricMotorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricMotorType);
			if (result == null)
				result = caseIfcRoot(ifcElectricMotorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricMotorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_TIME_CONTROL: {
			IfcElectricTimeControl ifcElectricTimeControl = (IfcElectricTimeControl) theEObject;
			T result = caseIfcElectricTimeControl(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcFlowController(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcDistributionElement(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcElement(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcProduct(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcObject(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcRoot(ifcElectricTimeControl);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricTimeControl);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_TIME_CONTROL_TYPE: {
			IfcElectricTimeControlType ifcElectricTimeControlType = (IfcElectricTimeControlType) theEObject;
			T result = caseIfcElectricTimeControlType(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcFlowControllerType(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcElementType(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcTypeObject(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcProductSelect(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcRoot(ifcElectricTimeControlType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElectricTimeControlType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELEMENT: {
			IfcElement ifcElement = (IfcElement) theEObject;
			T result = caseIfcElement(ifcElement);
			if (result == null)
				result = caseIfcProduct(ifcElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElement);
			if (result == null)
				result = caseIfcObject(ifcElement);
			if (result == null)
				result = caseIfcProductSelect(ifcElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElement);
			if (result == null)
				result = caseIfcRoot(ifcElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELEMENT_ASSEMBLY: {
			IfcElementAssembly ifcElementAssembly = (IfcElementAssembly) theEObject;
			T result = caseIfcElementAssembly(ifcElementAssembly);
			if (result == null)
				result = caseIfcElement(ifcElementAssembly);
			if (result == null)
				result = caseIfcProduct(ifcElementAssembly);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElementAssembly);
			if (result == null)
				result = caseIfcObject(ifcElementAssembly);
			if (result == null)
				result = caseIfcProductSelect(ifcElementAssembly);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElementAssembly);
			if (result == null)
				result = caseIfcRoot(ifcElementAssembly);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElementAssembly);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELEMENT_ASSEMBLY_TYPE: {
			IfcElementAssemblyType ifcElementAssemblyType = (IfcElementAssemblyType) theEObject;
			T result = caseIfcElementAssemblyType(ifcElementAssemblyType);
			if (result == null)
				result = caseIfcElementType(ifcElementAssemblyType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElementAssemblyType);
			if (result == null)
				result = caseIfcTypeObject(ifcElementAssemblyType);
			if (result == null)
				result = caseIfcProductSelect(ifcElementAssemblyType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElementAssemblyType);
			if (result == null)
				result = caseIfcRoot(ifcElementAssemblyType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElementAssemblyType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELEMENT_COMPONENT: {
			IfcElementComponent ifcElementComponent = (IfcElementComponent) theEObject;
			T result = caseIfcElementComponent(ifcElementComponent);
			if (result == null)
				result = caseIfcElement(ifcElementComponent);
			if (result == null)
				result = caseIfcProduct(ifcElementComponent);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcElementComponent);
			if (result == null)
				result = caseIfcObject(ifcElementComponent);
			if (result == null)
				result = caseIfcProductSelect(ifcElementComponent);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElementComponent);
			if (result == null)
				result = caseIfcRoot(ifcElementComponent);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElementComponent);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELEMENT_COMPONENT_TYPE: {
			IfcElementComponentType ifcElementComponentType = (IfcElementComponentType) theEObject;
			T result = caseIfcElementComponentType(ifcElementComponentType);
			if (result == null)
				result = caseIfcElementType(ifcElementComponentType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElementComponentType);
			if (result == null)
				result = caseIfcTypeObject(ifcElementComponentType);
			if (result == null)
				result = caseIfcProductSelect(ifcElementComponentType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElementComponentType);
			if (result == null)
				result = caseIfcRoot(ifcElementComponentType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElementComponentType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELEMENT_QUANTITY: {
			IfcElementQuantity ifcElementQuantity = (IfcElementQuantity) theEObject;
			T result = caseIfcElementQuantity(ifcElementQuantity);
			if (result == null)
				result = caseIfcQuantitySet(ifcElementQuantity);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcElementQuantity);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcElementQuantity);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcElementQuantity);
			if (result == null)
				result = caseIfcRoot(ifcElementQuantity);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElementQuantity);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELEMENT_TYPE: {
			IfcElementType ifcElementType = (IfcElementType) theEObject;
			T result = caseIfcElementType(ifcElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcElementType);
			if (result == null)
				result = caseIfcRoot(ifcElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELEMENTARY_SURFACE: {
			IfcElementarySurface ifcElementarySurface = (IfcElementarySurface) theEObject;
			T result = caseIfcElementarySurface(ifcElementarySurface);
			if (result == null)
				result = caseIfcSurface(ifcElementarySurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcElementarySurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcElementarySurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcElementarySurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcElementarySurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcElementarySurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELLIPSE: {
			IfcEllipse ifcEllipse = (IfcEllipse) theEObject;
			T result = caseIfcEllipse(ifcEllipse);
			if (result == null)
				result = caseIfcConic(ifcEllipse);
			if (result == null)
				result = caseIfcCurve(ifcEllipse);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcEllipse);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcEllipse);
			if (result == null)
				result = caseIfcRepresentationItem(ifcEllipse);
			if (result == null)
				result = caseIfcLayeredItem(ifcEllipse);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELLIPSE_PROFILE_DEF: {
			IfcEllipseProfileDef ifcEllipseProfileDef = (IfcEllipseProfileDef) theEObject;
			T result = caseIfcEllipseProfileDef(ifcEllipseProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcEllipseProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcEllipseProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcEllipseProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ENERGY_CONVERSION_DEVICE: {
			IfcEnergyConversionDevice ifcEnergyConversionDevice = (IfcEnergyConversionDevice) theEObject;
			T result = caseIfcEnergyConversionDevice(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcElement(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcProduct(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcObject(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcRoot(ifcEnergyConversionDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEnergyConversionDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ENERGY_CONVERSION_DEVICE_TYPE: {
			IfcEnergyConversionDeviceType ifcEnergyConversionDeviceType = (IfcEnergyConversionDeviceType) theEObject;
			T result = caseIfcEnergyConversionDeviceType(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcEnergyConversionDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEnergyConversionDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ENGINE: {
			IfcEngine ifcEngine = (IfcEngine) theEObject;
			T result = caseIfcEngine(ifcEngine);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcEngine);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcEngine);
			if (result == null)
				result = caseIfcDistributionElement(ifcEngine);
			if (result == null)
				result = caseIfcElement(ifcEngine);
			if (result == null)
				result = caseIfcProduct(ifcEngine);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcEngine);
			if (result == null)
				result = caseIfcObject(ifcEngine);
			if (result == null)
				result = caseIfcProductSelect(ifcEngine);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEngine);
			if (result == null)
				result = caseIfcRoot(ifcEngine);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEngine);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ENGINE_TYPE: {
			IfcEngineType ifcEngineType = (IfcEngineType) theEObject;
			T result = caseIfcEngineType(ifcEngineType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcEngineType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcEngineType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcEngineType);
			if (result == null)
				result = caseIfcElementType(ifcEngineType);
			if (result == null)
				result = caseIfcTypeProduct(ifcEngineType);
			if (result == null)
				result = caseIfcTypeObject(ifcEngineType);
			if (result == null)
				result = caseIfcProductSelect(ifcEngineType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEngineType);
			if (result == null)
				result = caseIfcRoot(ifcEngineType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEngineType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EVAPORATIVE_COOLER: {
			IfcEvaporativeCooler ifcEvaporativeCooler = (IfcEvaporativeCooler) theEObject;
			T result = caseIfcEvaporativeCooler(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcDistributionElement(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcElement(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcProduct(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcObject(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcProductSelect(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcRoot(ifcEvaporativeCooler);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEvaporativeCooler);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EVAPORATIVE_COOLER_TYPE: {
			IfcEvaporativeCoolerType ifcEvaporativeCoolerType = (IfcEvaporativeCoolerType) theEObject;
			T result = caseIfcEvaporativeCoolerType(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcElementType(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcTypeObject(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcProductSelect(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcRoot(ifcEvaporativeCoolerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEvaporativeCoolerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EVAPORATOR: {
			IfcEvaporator ifcEvaporator = (IfcEvaporator) theEObject;
			T result = caseIfcEvaporator(ifcEvaporator);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcEvaporator);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcEvaporator);
			if (result == null)
				result = caseIfcDistributionElement(ifcEvaporator);
			if (result == null)
				result = caseIfcElement(ifcEvaporator);
			if (result == null)
				result = caseIfcProduct(ifcEvaporator);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcEvaporator);
			if (result == null)
				result = caseIfcObject(ifcEvaporator);
			if (result == null)
				result = caseIfcProductSelect(ifcEvaporator);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEvaporator);
			if (result == null)
				result = caseIfcRoot(ifcEvaporator);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEvaporator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EVAPORATOR_TYPE: {
			IfcEvaporatorType ifcEvaporatorType = (IfcEvaporatorType) theEObject;
			T result = caseIfcEvaporatorType(ifcEvaporatorType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcEvaporatorType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcEvaporatorType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcEvaporatorType);
			if (result == null)
				result = caseIfcElementType(ifcEvaporatorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcEvaporatorType);
			if (result == null)
				result = caseIfcTypeObject(ifcEvaporatorType);
			if (result == null)
				result = caseIfcProductSelect(ifcEvaporatorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEvaporatorType);
			if (result == null)
				result = caseIfcRoot(ifcEvaporatorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEvaporatorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EVENT: {
			IfcEvent ifcEvent = (IfcEvent) theEObject;
			T result = caseIfcEvent(ifcEvent);
			if (result == null)
				result = caseIfcProcess(ifcEvent);
			if (result == null)
				result = caseIfcObject(ifcEvent);
			if (result == null)
				result = caseIfcProcessSelect(ifcEvent);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEvent);
			if (result == null)
				result = caseIfcRoot(ifcEvent);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEvent);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EVENT_TIME: {
			IfcEventTime ifcEventTime = (IfcEventTime) theEObject;
			T result = caseIfcEventTime(ifcEventTime);
			if (result == null)
				result = caseIfcSchedulingTime(ifcEventTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EVENT_TYPE: {
			IfcEventType ifcEventType = (IfcEventType) theEObject;
			T result = caseIfcEventType(ifcEventType);
			if (result == null)
				result = caseIfcTypeProcess(ifcEventType);
			if (result == null)
				result = caseIfcTypeObject(ifcEventType);
			if (result == null)
				result = caseIfcProcessSelect(ifcEventType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcEventType);
			if (result == null)
				result = caseIfcRoot(ifcEventType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcEventType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTENDED_PROPERTIES: {
			IfcExtendedProperties ifcExtendedProperties = (IfcExtendedProperties) theEObject;
			T result = caseIfcExtendedProperties(ifcExtendedProperties);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcExtendedProperties);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcExtendedProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTERNAL_INFORMATION: {
			IfcExternalInformation ifcExternalInformation = (IfcExternalInformation) theEObject;
			T result = caseIfcExternalInformation(ifcExternalInformation);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcExternalInformation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTERNAL_REFERENCE: {
			IfcExternalReference ifcExternalReference = (IfcExternalReference) theEObject;
			T result = caseIfcExternalReference(ifcExternalReference);
			if (result == null)
				result = caseIfcLightDistributionDataSourceSelect(ifcExternalReference);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcExternalReference);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcExternalReference);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTERNAL_REFERENCE_RELATIONSHIP: {
			IfcExternalReferenceRelationship ifcExternalReferenceRelationship = (IfcExternalReferenceRelationship) theEObject;
			T result = caseIfcExternalReferenceRelationship(ifcExternalReferenceRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcExternalReferenceRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTERNAL_SPATIAL_ELEMENT: {
			IfcExternalSpatialElement ifcExternalSpatialElement = (IfcExternalSpatialElement) theEObject;
			T result = caseIfcExternalSpatialElement(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcExternalSpatialStructureElement(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcSpaceBoundarySelect(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcSpatialElement(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcProduct(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcObject(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcProductSelect(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcRoot(ifcExternalSpatialElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcExternalSpatialElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTERNAL_SPATIAL_STRUCTURE_ELEMENT: {
			IfcExternalSpatialStructureElement ifcExternalSpatialStructureElement = (IfcExternalSpatialStructureElement) theEObject;
			T result = caseIfcExternalSpatialStructureElement(ifcExternalSpatialStructureElement);
			if (result == null)
				result = caseIfcSpatialElement(ifcExternalSpatialStructureElement);
			if (result == null)
				result = caseIfcProduct(ifcExternalSpatialStructureElement);
			if (result == null)
				result = caseIfcObject(ifcExternalSpatialStructureElement);
			if (result == null)
				result = caseIfcProductSelect(ifcExternalSpatialStructureElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcExternalSpatialStructureElement);
			if (result == null)
				result = caseIfcRoot(ifcExternalSpatialStructureElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcExternalSpatialStructureElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTERNALLY_DEFINED_HATCH_STYLE: {
			IfcExternallyDefinedHatchStyle ifcExternallyDefinedHatchStyle = (IfcExternallyDefinedHatchStyle) theEObject;
			T result = caseIfcExternallyDefinedHatchStyle(ifcExternallyDefinedHatchStyle);
			if (result == null)
				result = caseIfcExternalReference(ifcExternallyDefinedHatchStyle);
			if (result == null)
				result = caseIfcFillStyleSelect(ifcExternallyDefinedHatchStyle);
			if (result == null)
				result = caseIfcLightDistributionDataSourceSelect(ifcExternallyDefinedHatchStyle);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcExternallyDefinedHatchStyle);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcExternallyDefinedHatchStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTERNALLY_DEFINED_SURFACE_STYLE: {
			IfcExternallyDefinedSurfaceStyle ifcExternallyDefinedSurfaceStyle = (IfcExternallyDefinedSurfaceStyle) theEObject;
			T result = caseIfcExternallyDefinedSurfaceStyle(ifcExternallyDefinedSurfaceStyle);
			if (result == null)
				result = caseIfcExternalReference(ifcExternallyDefinedSurfaceStyle);
			if (result == null)
				result = caseIfcSurfaceStyleElementSelect(ifcExternallyDefinedSurfaceStyle);
			if (result == null)
				result = caseIfcLightDistributionDataSourceSelect(ifcExternallyDefinedSurfaceStyle);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcExternallyDefinedSurfaceStyle);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcExternallyDefinedSurfaceStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTERNALLY_DEFINED_TEXT_FONT: {
			IfcExternallyDefinedTextFont ifcExternallyDefinedTextFont = (IfcExternallyDefinedTextFont) theEObject;
			T result = caseIfcExternallyDefinedTextFont(ifcExternallyDefinedTextFont);
			if (result == null)
				result = caseIfcExternalReference(ifcExternallyDefinedTextFont);
			if (result == null)
				result = caseIfcTextFontSelect(ifcExternallyDefinedTextFont);
			if (result == null)
				result = caseIfcLightDistributionDataSourceSelect(ifcExternallyDefinedTextFont);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcExternallyDefinedTextFont);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcExternallyDefinedTextFont);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTRUDED_AREA_SOLID: {
			IfcExtrudedAreaSolid ifcExtrudedAreaSolid = (IfcExtrudedAreaSolid) theEObject;
			T result = caseIfcExtrudedAreaSolid(ifcExtrudedAreaSolid);
			if (result == null)
				result = caseIfcSweptAreaSolid(ifcExtrudedAreaSolid);
			if (result == null)
				result = caseIfcSolidModel(ifcExtrudedAreaSolid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcExtrudedAreaSolid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcExtrudedAreaSolid);
			if (result == null)
				result = caseIfcSolidOrShell(ifcExtrudedAreaSolid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcExtrudedAreaSolid);
			if (result == null)
				result = caseIfcLayeredItem(ifcExtrudedAreaSolid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_EXTRUDED_AREA_SOLID_TAPERED: {
			IfcExtrudedAreaSolidTapered ifcExtrudedAreaSolidTapered = (IfcExtrudedAreaSolidTapered) theEObject;
			T result = caseIfcExtrudedAreaSolidTapered(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = caseIfcExtrudedAreaSolid(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = caseIfcSweptAreaSolid(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = caseIfcSolidModel(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = caseIfcBooleanOperand(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = caseIfcSolidOrShell(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = caseIfcRepresentationItem(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = caseIfcLayeredItem(ifcExtrudedAreaSolidTapered);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FACE: {
			IfcFace ifcFace = (IfcFace) theEObject;
			T result = caseIfcFace(ifcFace);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcFace);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFace);
			if (result == null)
				result = caseIfcLayeredItem(ifcFace);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FACE_BASED_SURFACE_MODEL: {
			IfcFaceBasedSurfaceModel ifcFaceBasedSurfaceModel = (IfcFaceBasedSurfaceModel) theEObject;
			T result = caseIfcFaceBasedSurfaceModel(ifcFaceBasedSurfaceModel);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcFaceBasedSurfaceModel);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcFaceBasedSurfaceModel);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFaceBasedSurfaceModel);
			if (result == null)
				result = caseIfcLayeredItem(ifcFaceBasedSurfaceModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FACE_BOUND: {
			IfcFaceBound ifcFaceBound = (IfcFaceBound) theEObject;
			T result = caseIfcFaceBound(ifcFaceBound);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcFaceBound);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFaceBound);
			if (result == null)
				result = caseIfcLayeredItem(ifcFaceBound);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FACE_OUTER_BOUND: {
			IfcFaceOuterBound ifcFaceOuterBound = (IfcFaceOuterBound) theEObject;
			T result = caseIfcFaceOuterBound(ifcFaceOuterBound);
			if (result == null)
				result = caseIfcFaceBound(ifcFaceOuterBound);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcFaceOuterBound);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFaceOuterBound);
			if (result == null)
				result = caseIfcLayeredItem(ifcFaceOuterBound);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FACE_SURFACE: {
			IfcFaceSurface ifcFaceSurface = (IfcFaceSurface) theEObject;
			T result = caseIfcFaceSurface(ifcFaceSurface);
			if (result == null)
				result = caseIfcFace(ifcFaceSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcFaceSurface);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcFaceSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFaceSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcFaceSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FACETED_BREP: {
			IfcFacetedBrep ifcFacetedBrep = (IfcFacetedBrep) theEObject;
			T result = caseIfcFacetedBrep(ifcFacetedBrep);
			if (result == null)
				result = caseIfcManifoldSolidBrep(ifcFacetedBrep);
			if (result == null)
				result = caseIfcSolidModel(ifcFacetedBrep);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcFacetedBrep);
			if (result == null)
				result = caseIfcBooleanOperand(ifcFacetedBrep);
			if (result == null)
				result = caseIfcSolidOrShell(ifcFacetedBrep);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFacetedBrep);
			if (result == null)
				result = caseIfcLayeredItem(ifcFacetedBrep);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FACETED_BREP_WITH_VOIDS: {
			IfcFacetedBrepWithVoids ifcFacetedBrepWithVoids = (IfcFacetedBrepWithVoids) theEObject;
			T result = caseIfcFacetedBrepWithVoids(ifcFacetedBrepWithVoids);
			if (result == null)
				result = caseIfcFacetedBrep(ifcFacetedBrepWithVoids);
			if (result == null)
				result = caseIfcManifoldSolidBrep(ifcFacetedBrepWithVoids);
			if (result == null)
				result = caseIfcSolidModel(ifcFacetedBrepWithVoids);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcFacetedBrepWithVoids);
			if (result == null)
				result = caseIfcBooleanOperand(ifcFacetedBrepWithVoids);
			if (result == null)
				result = caseIfcSolidOrShell(ifcFacetedBrepWithVoids);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFacetedBrepWithVoids);
			if (result == null)
				result = caseIfcLayeredItem(ifcFacetedBrepWithVoids);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FAILURE_CONNECTION_CONDITION: {
			IfcFailureConnectionCondition ifcFailureConnectionCondition = (IfcFailureConnectionCondition) theEObject;
			T result = caseIfcFailureConnectionCondition(ifcFailureConnectionCondition);
			if (result == null)
				result = caseIfcStructuralConnectionCondition(ifcFailureConnectionCondition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FAN: {
			IfcFan ifcFan = (IfcFan) theEObject;
			T result = caseIfcFan(ifcFan);
			if (result == null)
				result = caseIfcFlowMovingDevice(ifcFan);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFan);
			if (result == null)
				result = caseIfcDistributionElement(ifcFan);
			if (result == null)
				result = caseIfcElement(ifcFan);
			if (result == null)
				result = caseIfcProduct(ifcFan);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFan);
			if (result == null)
				result = caseIfcObject(ifcFan);
			if (result == null)
				result = caseIfcProductSelect(ifcFan);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFan);
			if (result == null)
				result = caseIfcRoot(ifcFan);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFan);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FAN_TYPE: {
			IfcFanType ifcFanType = (IfcFanType) theEObject;
			T result = caseIfcFanType(ifcFanType);
			if (result == null)
				result = caseIfcFlowMovingDeviceType(ifcFanType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFanType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFanType);
			if (result == null)
				result = caseIfcElementType(ifcFanType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFanType);
			if (result == null)
				result = caseIfcTypeObject(ifcFanType);
			if (result == null)
				result = caseIfcProductSelect(ifcFanType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFanType);
			if (result == null)
				result = caseIfcRoot(ifcFanType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFanType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FASTENER: {
			IfcFastener ifcFastener = (IfcFastener) theEObject;
			T result = caseIfcFastener(ifcFastener);
			if (result == null)
				result = caseIfcElementComponent(ifcFastener);
			if (result == null)
				result = caseIfcElement(ifcFastener);
			if (result == null)
				result = caseIfcProduct(ifcFastener);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFastener);
			if (result == null)
				result = caseIfcObject(ifcFastener);
			if (result == null)
				result = caseIfcProductSelect(ifcFastener);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFastener);
			if (result == null)
				result = caseIfcRoot(ifcFastener);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFastener);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FASTENER_TYPE: {
			IfcFastenerType ifcFastenerType = (IfcFastenerType) theEObject;
			T result = caseIfcFastenerType(ifcFastenerType);
			if (result == null)
				result = caseIfcElementComponentType(ifcFastenerType);
			if (result == null)
				result = caseIfcElementType(ifcFastenerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFastenerType);
			if (result == null)
				result = caseIfcTypeObject(ifcFastenerType);
			if (result == null)
				result = caseIfcProductSelect(ifcFastenerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFastenerType);
			if (result == null)
				result = caseIfcRoot(ifcFastenerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFastenerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FEATURE_ELEMENT: {
			IfcFeatureElement ifcFeatureElement = (IfcFeatureElement) theEObject;
			T result = caseIfcFeatureElement(ifcFeatureElement);
			if (result == null)
				result = caseIfcElement(ifcFeatureElement);
			if (result == null)
				result = caseIfcProduct(ifcFeatureElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFeatureElement);
			if (result == null)
				result = caseIfcObject(ifcFeatureElement);
			if (result == null)
				result = caseIfcProductSelect(ifcFeatureElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFeatureElement);
			if (result == null)
				result = caseIfcRoot(ifcFeatureElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFeatureElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FEATURE_ELEMENT_ADDITION: {
			IfcFeatureElementAddition ifcFeatureElementAddition = (IfcFeatureElementAddition) theEObject;
			T result = caseIfcFeatureElementAddition(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcFeatureElement(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcElement(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcProduct(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcObject(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcProductSelect(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcRoot(ifcFeatureElementAddition);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFeatureElementAddition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FEATURE_ELEMENT_SUBTRACTION: {
			IfcFeatureElementSubtraction ifcFeatureElementSubtraction = (IfcFeatureElementSubtraction) theEObject;
			T result = caseIfcFeatureElementSubtraction(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcFeatureElement(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcElement(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcProduct(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcObject(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcProductSelect(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcRoot(ifcFeatureElementSubtraction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFeatureElementSubtraction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FILL_AREA_STYLE: {
			IfcFillAreaStyle ifcFillAreaStyle = (IfcFillAreaStyle) theEObject;
			T result = caseIfcFillAreaStyle(ifcFillAreaStyle);
			if (result == null)
				result = caseIfcPresentationStyle(ifcFillAreaStyle);
			if (result == null)
				result = caseIfcPresentationStyleSelect(ifcFillAreaStyle);
			if (result == null)
				result = caseIfcStyleAssignmentSelect(ifcFillAreaStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FILL_AREA_STYLE_HATCHING: {
			IfcFillAreaStyleHatching ifcFillAreaStyleHatching = (IfcFillAreaStyleHatching) theEObject;
			T result = caseIfcFillAreaStyleHatching(ifcFillAreaStyleHatching);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcFillAreaStyleHatching);
			if (result == null)
				result = caseIfcFillStyleSelect(ifcFillAreaStyleHatching);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFillAreaStyleHatching);
			if (result == null)
				result = caseIfcLayeredItem(ifcFillAreaStyleHatching);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FILL_AREA_STYLE_TILES: {
			IfcFillAreaStyleTiles ifcFillAreaStyleTiles = (IfcFillAreaStyleTiles) theEObject;
			T result = caseIfcFillAreaStyleTiles(ifcFillAreaStyleTiles);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcFillAreaStyleTiles);
			if (result == null)
				result = caseIfcFillStyleSelect(ifcFillAreaStyleTiles);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFillAreaStyleTiles);
			if (result == null)
				result = caseIfcLayeredItem(ifcFillAreaStyleTiles);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FILTER: {
			IfcFilter ifcFilter = (IfcFilter) theEObject;
			T result = caseIfcFilter(ifcFilter);
			if (result == null)
				result = caseIfcFlowTreatmentDevice(ifcFilter);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFilter);
			if (result == null)
				result = caseIfcDistributionElement(ifcFilter);
			if (result == null)
				result = caseIfcElement(ifcFilter);
			if (result == null)
				result = caseIfcProduct(ifcFilter);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFilter);
			if (result == null)
				result = caseIfcObject(ifcFilter);
			if (result == null)
				result = caseIfcProductSelect(ifcFilter);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFilter);
			if (result == null)
				result = caseIfcRoot(ifcFilter);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFilter);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FILTER_TYPE: {
			IfcFilterType ifcFilterType = (IfcFilterType) theEObject;
			T result = caseIfcFilterType(ifcFilterType);
			if (result == null)
				result = caseIfcFlowTreatmentDeviceType(ifcFilterType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFilterType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFilterType);
			if (result == null)
				result = caseIfcElementType(ifcFilterType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFilterType);
			if (result == null)
				result = caseIfcTypeObject(ifcFilterType);
			if (result == null)
				result = caseIfcProductSelect(ifcFilterType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFilterType);
			if (result == null)
				result = caseIfcRoot(ifcFilterType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFilterType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FIRE_SUPPRESSION_TERMINAL: {
			IfcFireSuppressionTerminal ifcFireSuppressionTerminal = (IfcFireSuppressionTerminal) theEObject;
			T result = caseIfcFireSuppressionTerminal(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcFlowTerminal(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcDistributionElement(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcElement(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcProduct(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcObject(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcProductSelect(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcRoot(ifcFireSuppressionTerminal);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFireSuppressionTerminal);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FIRE_SUPPRESSION_TERMINAL_TYPE: {
			IfcFireSuppressionTerminalType ifcFireSuppressionTerminalType = (IfcFireSuppressionTerminalType) theEObject;
			T result = caseIfcFireSuppressionTerminalType(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcElementType(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcTypeObject(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcProductSelect(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcRoot(ifcFireSuppressionTerminalType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFireSuppressionTerminalType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FIXED_REFERENCE_SWEPT_AREA_SOLID: {
			IfcFixedReferenceSweptAreaSolid ifcFixedReferenceSweptAreaSolid = (IfcFixedReferenceSweptAreaSolid) theEObject;
			T result = caseIfcFixedReferenceSweptAreaSolid(ifcFixedReferenceSweptAreaSolid);
			if (result == null)
				result = caseIfcSweptAreaSolid(ifcFixedReferenceSweptAreaSolid);
			if (result == null)
				result = caseIfcSolidModel(ifcFixedReferenceSweptAreaSolid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcFixedReferenceSweptAreaSolid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcFixedReferenceSweptAreaSolid);
			if (result == null)
				result = caseIfcSolidOrShell(ifcFixedReferenceSweptAreaSolid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcFixedReferenceSweptAreaSolid);
			if (result == null)
				result = caseIfcLayeredItem(ifcFixedReferenceSweptAreaSolid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_CONTROLLER: {
			IfcFlowController ifcFlowController = (IfcFlowController) theEObject;
			T result = caseIfcFlowController(ifcFlowController);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFlowController);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowController);
			if (result == null)
				result = caseIfcElement(ifcFlowController);
			if (result == null)
				result = caseIfcProduct(ifcFlowController);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowController);
			if (result == null)
				result = caseIfcObject(ifcFlowController);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowController);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowController);
			if (result == null)
				result = caseIfcRoot(ifcFlowController);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowController);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_CONTROLLER_TYPE: {
			IfcFlowControllerType ifcFlowControllerType = (IfcFlowControllerType) theEObject;
			T result = caseIfcFlowControllerType(ifcFlowControllerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFlowControllerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowControllerType);
			if (result == null)
				result = caseIfcElementType(ifcFlowControllerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowControllerType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowControllerType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowControllerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowControllerType);
			if (result == null)
				result = caseIfcRoot(ifcFlowControllerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowControllerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_FITTING: {
			IfcFlowFitting ifcFlowFitting = (IfcFlowFitting) theEObject;
			T result = caseIfcFlowFitting(ifcFlowFitting);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFlowFitting);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowFitting);
			if (result == null)
				result = caseIfcElement(ifcFlowFitting);
			if (result == null)
				result = caseIfcProduct(ifcFlowFitting);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowFitting);
			if (result == null)
				result = caseIfcObject(ifcFlowFitting);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowFitting);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowFitting);
			if (result == null)
				result = caseIfcRoot(ifcFlowFitting);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowFitting);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_FITTING_TYPE: {
			IfcFlowFittingType ifcFlowFittingType = (IfcFlowFittingType) theEObject;
			T result = caseIfcFlowFittingType(ifcFlowFittingType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFlowFittingType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowFittingType);
			if (result == null)
				result = caseIfcElementType(ifcFlowFittingType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowFittingType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowFittingType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowFittingType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowFittingType);
			if (result == null)
				result = caseIfcRoot(ifcFlowFittingType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowFittingType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_INSTRUMENT: {
			IfcFlowInstrument ifcFlowInstrument = (IfcFlowInstrument) theEObject;
			T result = caseIfcFlowInstrument(ifcFlowInstrument);
			if (result == null)
				result = caseIfcDistributionControlElement(ifcFlowInstrument);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowInstrument);
			if (result == null)
				result = caseIfcElement(ifcFlowInstrument);
			if (result == null)
				result = caseIfcProduct(ifcFlowInstrument);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowInstrument);
			if (result == null)
				result = caseIfcObject(ifcFlowInstrument);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowInstrument);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowInstrument);
			if (result == null)
				result = caseIfcRoot(ifcFlowInstrument);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowInstrument);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_INSTRUMENT_TYPE: {
			IfcFlowInstrumentType ifcFlowInstrumentType = (IfcFlowInstrumentType) theEObject;
			T result = caseIfcFlowInstrumentType(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcDistributionControlElementType(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcElementType(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcRoot(ifcFlowInstrumentType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowInstrumentType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_METER: {
			IfcFlowMeter ifcFlowMeter = (IfcFlowMeter) theEObject;
			T result = caseIfcFlowMeter(ifcFlowMeter);
			if (result == null)
				result = caseIfcFlowController(ifcFlowMeter);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFlowMeter);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowMeter);
			if (result == null)
				result = caseIfcElement(ifcFlowMeter);
			if (result == null)
				result = caseIfcProduct(ifcFlowMeter);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowMeter);
			if (result == null)
				result = caseIfcObject(ifcFlowMeter);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowMeter);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowMeter);
			if (result == null)
				result = caseIfcRoot(ifcFlowMeter);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowMeter);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_METER_TYPE: {
			IfcFlowMeterType ifcFlowMeterType = (IfcFlowMeterType) theEObject;
			T result = caseIfcFlowMeterType(ifcFlowMeterType);
			if (result == null)
				result = caseIfcFlowControllerType(ifcFlowMeterType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFlowMeterType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowMeterType);
			if (result == null)
				result = caseIfcElementType(ifcFlowMeterType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowMeterType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowMeterType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowMeterType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowMeterType);
			if (result == null)
				result = caseIfcRoot(ifcFlowMeterType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowMeterType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_MOVING_DEVICE: {
			IfcFlowMovingDevice ifcFlowMovingDevice = (IfcFlowMovingDevice) theEObject;
			T result = caseIfcFlowMovingDevice(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcElement(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcProduct(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcObject(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcRoot(ifcFlowMovingDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowMovingDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_MOVING_DEVICE_TYPE: {
			IfcFlowMovingDeviceType ifcFlowMovingDeviceType = (IfcFlowMovingDeviceType) theEObject;
			T result = caseIfcFlowMovingDeviceType(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcFlowMovingDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowMovingDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_SEGMENT: {
			IfcFlowSegment ifcFlowSegment = (IfcFlowSegment) theEObject;
			T result = caseIfcFlowSegment(ifcFlowSegment);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFlowSegment);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowSegment);
			if (result == null)
				result = caseIfcElement(ifcFlowSegment);
			if (result == null)
				result = caseIfcProduct(ifcFlowSegment);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowSegment);
			if (result == null)
				result = caseIfcObject(ifcFlowSegment);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowSegment);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowSegment);
			if (result == null)
				result = caseIfcRoot(ifcFlowSegment);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowSegment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_SEGMENT_TYPE: {
			IfcFlowSegmentType ifcFlowSegmentType = (IfcFlowSegmentType) theEObject;
			T result = caseIfcFlowSegmentType(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcElementType(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcRoot(ifcFlowSegmentType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowSegmentType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_STORAGE_DEVICE: {
			IfcFlowStorageDevice ifcFlowStorageDevice = (IfcFlowStorageDevice) theEObject;
			T result = caseIfcFlowStorageDevice(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcElement(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcProduct(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcObject(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcRoot(ifcFlowStorageDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowStorageDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_STORAGE_DEVICE_TYPE: {
			IfcFlowStorageDeviceType ifcFlowStorageDeviceType = (IfcFlowStorageDeviceType) theEObject;
			T result = caseIfcFlowStorageDeviceType(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcFlowStorageDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowStorageDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_TERMINAL: {
			IfcFlowTerminal ifcFlowTerminal = (IfcFlowTerminal) theEObject;
			T result = caseIfcFlowTerminal(ifcFlowTerminal);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFlowTerminal);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowTerminal);
			if (result == null)
				result = caseIfcElement(ifcFlowTerminal);
			if (result == null)
				result = caseIfcProduct(ifcFlowTerminal);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowTerminal);
			if (result == null)
				result = caseIfcObject(ifcFlowTerminal);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowTerminal);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowTerminal);
			if (result == null)
				result = caseIfcRoot(ifcFlowTerminal);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowTerminal);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_TERMINAL_TYPE: {
			IfcFlowTerminalType ifcFlowTerminalType = (IfcFlowTerminalType) theEObject;
			T result = caseIfcFlowTerminalType(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcElementType(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcRoot(ifcFlowTerminalType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowTerminalType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_TREATMENT_DEVICE: {
			IfcFlowTreatmentDevice ifcFlowTreatmentDevice = (IfcFlowTreatmentDevice) theEObject;
			T result = caseIfcFlowTreatmentDevice(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcElement(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcProduct(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcObject(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcRoot(ifcFlowTreatmentDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowTreatmentDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FLOW_TREATMENT_DEVICE_TYPE: {
			IfcFlowTreatmentDeviceType ifcFlowTreatmentDeviceType = (IfcFlowTreatmentDeviceType) theEObject;
			T result = caseIfcFlowTreatmentDeviceType(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFlowTreatmentDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FOOTING: {
			IfcFooting ifcFooting = (IfcFooting) theEObject;
			T result = caseIfcFooting(ifcFooting);
			if (result == null)
				result = caseIfcBuildingElement(ifcFooting);
			if (result == null)
				result = caseIfcElement(ifcFooting);
			if (result == null)
				result = caseIfcProduct(ifcFooting);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFooting);
			if (result == null)
				result = caseIfcObject(ifcFooting);
			if (result == null)
				result = caseIfcProductSelect(ifcFooting);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFooting);
			if (result == null)
				result = caseIfcRoot(ifcFooting);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFooting);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FOOTING_TYPE: {
			IfcFootingType ifcFootingType = (IfcFootingType) theEObject;
			T result = caseIfcFootingType(ifcFootingType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcFootingType);
			if (result == null)
				result = caseIfcElementType(ifcFootingType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFootingType);
			if (result == null)
				result = caseIfcTypeObject(ifcFootingType);
			if (result == null)
				result = caseIfcProductSelect(ifcFootingType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFootingType);
			if (result == null)
				result = caseIfcRoot(ifcFootingType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFootingType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FURNISHING_ELEMENT: {
			IfcFurnishingElement ifcFurnishingElement = (IfcFurnishingElement) theEObject;
			T result = caseIfcFurnishingElement(ifcFurnishingElement);
			if (result == null)
				result = caseIfcElement(ifcFurnishingElement);
			if (result == null)
				result = caseIfcProduct(ifcFurnishingElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFurnishingElement);
			if (result == null)
				result = caseIfcObject(ifcFurnishingElement);
			if (result == null)
				result = caseIfcProductSelect(ifcFurnishingElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFurnishingElement);
			if (result == null)
				result = caseIfcRoot(ifcFurnishingElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFurnishingElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FURNISHING_ELEMENT_TYPE: {
			IfcFurnishingElementType ifcFurnishingElementType = (IfcFurnishingElementType) theEObject;
			T result = caseIfcFurnishingElementType(ifcFurnishingElementType);
			if (result == null)
				result = caseIfcElementType(ifcFurnishingElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFurnishingElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcFurnishingElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcFurnishingElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFurnishingElementType);
			if (result == null)
				result = caseIfcRoot(ifcFurnishingElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFurnishingElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FURNITURE: {
			IfcFurniture ifcFurniture = (IfcFurniture) theEObject;
			T result = caseIfcFurniture(ifcFurniture);
			if (result == null)
				result = caseIfcFurnishingElement(ifcFurniture);
			if (result == null)
				result = caseIfcElement(ifcFurniture);
			if (result == null)
				result = caseIfcProduct(ifcFurniture);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcFurniture);
			if (result == null)
				result = caseIfcObject(ifcFurniture);
			if (result == null)
				result = caseIfcProductSelect(ifcFurniture);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFurniture);
			if (result == null)
				result = caseIfcRoot(ifcFurniture);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFurniture);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FURNITURE_TYPE: {
			IfcFurnitureType ifcFurnitureType = (IfcFurnitureType) theEObject;
			T result = caseIfcFurnitureType(ifcFurnitureType);
			if (result == null)
				result = caseIfcFurnishingElementType(ifcFurnitureType);
			if (result == null)
				result = caseIfcElementType(ifcFurnitureType);
			if (result == null)
				result = caseIfcTypeProduct(ifcFurnitureType);
			if (result == null)
				result = caseIfcTypeObject(ifcFurnitureType);
			if (result == null)
				result = caseIfcProductSelect(ifcFurnitureType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcFurnitureType);
			if (result == null)
				result = caseIfcRoot(ifcFurnitureType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcFurnitureType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GEOGRAPHIC_ELEMENT: {
			IfcGeographicElement ifcGeographicElement = (IfcGeographicElement) theEObject;
			T result = caseIfcGeographicElement(ifcGeographicElement);
			if (result == null)
				result = caseIfcElement(ifcGeographicElement);
			if (result == null)
				result = caseIfcProduct(ifcGeographicElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcGeographicElement);
			if (result == null)
				result = caseIfcObject(ifcGeographicElement);
			if (result == null)
				result = caseIfcProductSelect(ifcGeographicElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcGeographicElement);
			if (result == null)
				result = caseIfcRoot(ifcGeographicElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcGeographicElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GEOGRAPHIC_ELEMENT_TYPE: {
			IfcGeographicElementType ifcGeographicElementType = (IfcGeographicElementType) theEObject;
			T result = caseIfcGeographicElementType(ifcGeographicElementType);
			if (result == null)
				result = caseIfcElementType(ifcGeographicElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcGeographicElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcGeographicElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcGeographicElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcGeographicElementType);
			if (result == null)
				result = caseIfcRoot(ifcGeographicElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcGeographicElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GEOMETRIC_CURVE_SET: {
			IfcGeometricCurveSet ifcGeometricCurveSet = (IfcGeometricCurveSet) theEObject;
			T result = caseIfcGeometricCurveSet(ifcGeometricCurveSet);
			if (result == null)
				result = caseIfcGeometricSet(ifcGeometricCurveSet);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcGeometricCurveSet);
			if (result == null)
				result = caseIfcRepresentationItem(ifcGeometricCurveSet);
			if (result == null)
				result = caseIfcLayeredItem(ifcGeometricCurveSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GEOMETRIC_REPRESENTATION_CONTEXT: {
			IfcGeometricRepresentationContext ifcGeometricRepresentationContext = (IfcGeometricRepresentationContext) theEObject;
			T result = caseIfcGeometricRepresentationContext(ifcGeometricRepresentationContext);
			if (result == null)
				result = caseIfcRepresentationContext(ifcGeometricRepresentationContext);
			if (result == null)
				result = caseIfcCoordinateReferenceSystemSelect(ifcGeometricRepresentationContext);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GEOMETRIC_REPRESENTATION_ITEM: {
			IfcGeometricRepresentationItem ifcGeometricRepresentationItem = (IfcGeometricRepresentationItem) theEObject;
			T result = caseIfcGeometricRepresentationItem(ifcGeometricRepresentationItem);
			if (result == null)
				result = caseIfcRepresentationItem(ifcGeometricRepresentationItem);
			if (result == null)
				result = caseIfcLayeredItem(ifcGeometricRepresentationItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GEOMETRIC_REPRESENTATION_SUB_CONTEXT: {
			IfcGeometricRepresentationSubContext ifcGeometricRepresentationSubContext = (IfcGeometricRepresentationSubContext) theEObject;
			T result = caseIfcGeometricRepresentationSubContext(ifcGeometricRepresentationSubContext);
			if (result == null)
				result = caseIfcGeometricRepresentationContext(ifcGeometricRepresentationSubContext);
			if (result == null)
				result = caseIfcRepresentationContext(ifcGeometricRepresentationSubContext);
			if (result == null)
				result = caseIfcCoordinateReferenceSystemSelect(ifcGeometricRepresentationSubContext);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GEOMETRIC_SET: {
			IfcGeometricSet ifcGeometricSet = (IfcGeometricSet) theEObject;
			T result = caseIfcGeometricSet(ifcGeometricSet);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcGeometricSet);
			if (result == null)
				result = caseIfcRepresentationItem(ifcGeometricSet);
			if (result == null)
				result = caseIfcLayeredItem(ifcGeometricSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GRID: {
			IfcGrid ifcGrid = (IfcGrid) theEObject;
			T result = caseIfcGrid(ifcGrid);
			if (result == null)
				result = caseIfcProduct(ifcGrid);
			if (result == null)
				result = caseIfcObject(ifcGrid);
			if (result == null)
				result = caseIfcProductSelect(ifcGrid);
			if (result == null)
				result = caseIfcObjectDefinition(ifcGrid);
			if (result == null)
				result = caseIfcRoot(ifcGrid);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcGrid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GRID_AXIS: {
			IfcGridAxis ifcGridAxis = (IfcGridAxis) theEObject;
			T result = caseIfcGridAxis(ifcGridAxis);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GRID_PLACEMENT: {
			IfcGridPlacement ifcGridPlacement = (IfcGridPlacement) theEObject;
			T result = caseIfcGridPlacement(ifcGridPlacement);
			if (result == null)
				result = caseIfcObjectPlacement(ifcGridPlacement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GROUP: {
			IfcGroup ifcGroup = (IfcGroup) theEObject;
			T result = caseIfcGroup(ifcGroup);
			if (result == null)
				result = caseIfcObject(ifcGroup);
			if (result == null)
				result = caseIfcObjectDefinition(ifcGroup);
			if (result == null)
				result = caseIfcRoot(ifcGroup);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcGroup);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_HALF_SPACE_SOLID: {
			IfcHalfSpaceSolid ifcHalfSpaceSolid = (IfcHalfSpaceSolid) theEObject;
			T result = caseIfcHalfSpaceSolid(ifcHalfSpaceSolid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcHalfSpaceSolid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcHalfSpaceSolid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcHalfSpaceSolid);
			if (result == null)
				result = caseIfcLayeredItem(ifcHalfSpaceSolid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_HEAT_EXCHANGER: {
			IfcHeatExchanger ifcHeatExchanger = (IfcHeatExchanger) theEObject;
			T result = caseIfcHeatExchanger(ifcHeatExchanger);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcHeatExchanger);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcHeatExchanger);
			if (result == null)
				result = caseIfcDistributionElement(ifcHeatExchanger);
			if (result == null)
				result = caseIfcElement(ifcHeatExchanger);
			if (result == null)
				result = caseIfcProduct(ifcHeatExchanger);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcHeatExchanger);
			if (result == null)
				result = caseIfcObject(ifcHeatExchanger);
			if (result == null)
				result = caseIfcProductSelect(ifcHeatExchanger);
			if (result == null)
				result = caseIfcObjectDefinition(ifcHeatExchanger);
			if (result == null)
				result = caseIfcRoot(ifcHeatExchanger);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcHeatExchanger);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_HEAT_EXCHANGER_TYPE: {
			IfcHeatExchangerType ifcHeatExchangerType = (IfcHeatExchangerType) theEObject;
			T result = caseIfcHeatExchangerType(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcElementType(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcTypeObject(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcProductSelect(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcRoot(ifcHeatExchangerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcHeatExchangerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_HUMIDIFIER: {
			IfcHumidifier ifcHumidifier = (IfcHumidifier) theEObject;
			T result = caseIfcHumidifier(ifcHumidifier);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcHumidifier);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcHumidifier);
			if (result == null)
				result = caseIfcDistributionElement(ifcHumidifier);
			if (result == null)
				result = caseIfcElement(ifcHumidifier);
			if (result == null)
				result = caseIfcProduct(ifcHumidifier);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcHumidifier);
			if (result == null)
				result = caseIfcObject(ifcHumidifier);
			if (result == null)
				result = caseIfcProductSelect(ifcHumidifier);
			if (result == null)
				result = caseIfcObjectDefinition(ifcHumidifier);
			if (result == null)
				result = caseIfcRoot(ifcHumidifier);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcHumidifier);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_HUMIDIFIER_TYPE: {
			IfcHumidifierType ifcHumidifierType = (IfcHumidifierType) theEObject;
			T result = caseIfcHumidifierType(ifcHumidifierType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcHumidifierType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcHumidifierType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcHumidifierType);
			if (result == null)
				result = caseIfcElementType(ifcHumidifierType);
			if (result == null)
				result = caseIfcTypeProduct(ifcHumidifierType);
			if (result == null)
				result = caseIfcTypeObject(ifcHumidifierType);
			if (result == null)
				result = caseIfcProductSelect(ifcHumidifierType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcHumidifierType);
			if (result == null)
				result = caseIfcRoot(ifcHumidifierType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcHumidifierType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ISHAPE_PROFILE_DEF: {
			IfcIShapeProfileDef ifcIShapeProfileDef = (IfcIShapeProfileDef) theEObject;
			T result = caseIfcIShapeProfileDef(ifcIShapeProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcIShapeProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcIShapeProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcIShapeProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_IMAGE_TEXTURE: {
			IfcImageTexture ifcImageTexture = (IfcImageTexture) theEObject;
			T result = caseIfcImageTexture(ifcImageTexture);
			if (result == null)
				result = caseIfcSurfaceTexture(ifcImageTexture);
			if (result == null)
				result = caseIfcPresentationItem(ifcImageTexture);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INDEXED_COLOUR_MAP: {
			IfcIndexedColourMap ifcIndexedColourMap = (IfcIndexedColourMap) theEObject;
			T result = caseIfcIndexedColourMap(ifcIndexedColourMap);
			if (result == null)
				result = caseIfcPresentationItem(ifcIndexedColourMap);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INDEXED_POLY_CURVE: {
			IfcIndexedPolyCurve ifcIndexedPolyCurve = (IfcIndexedPolyCurve) theEObject;
			T result = caseIfcIndexedPolyCurve(ifcIndexedPolyCurve);
			if (result == null)
				result = caseIfcBoundedCurve(ifcIndexedPolyCurve);
			if (result == null)
				result = caseIfcCurve(ifcIndexedPolyCurve);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcIndexedPolyCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcIndexedPolyCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcIndexedPolyCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcIndexedPolyCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcIndexedPolyCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INDEXED_POLYGONAL_FACE: {
			IfcIndexedPolygonalFace ifcIndexedPolygonalFace = (IfcIndexedPolygonalFace) theEObject;
			T result = caseIfcIndexedPolygonalFace(ifcIndexedPolygonalFace);
			if (result == null)
				result = caseIfcTessellatedItem(ifcIndexedPolygonalFace);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcIndexedPolygonalFace);
			if (result == null)
				result = caseIfcRepresentationItem(ifcIndexedPolygonalFace);
			if (result == null)
				result = caseIfcLayeredItem(ifcIndexedPolygonalFace);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INDEXED_POLYGONAL_FACE_WITH_VOIDS: {
			IfcIndexedPolygonalFaceWithVoids ifcIndexedPolygonalFaceWithVoids = (IfcIndexedPolygonalFaceWithVoids) theEObject;
			T result = caseIfcIndexedPolygonalFaceWithVoids(ifcIndexedPolygonalFaceWithVoids);
			if (result == null)
				result = caseIfcIndexedPolygonalFace(ifcIndexedPolygonalFaceWithVoids);
			if (result == null)
				result = caseIfcTessellatedItem(ifcIndexedPolygonalFaceWithVoids);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcIndexedPolygonalFaceWithVoids);
			if (result == null)
				result = caseIfcRepresentationItem(ifcIndexedPolygonalFaceWithVoids);
			if (result == null)
				result = caseIfcLayeredItem(ifcIndexedPolygonalFaceWithVoids);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INDEXED_TEXTURE_MAP: {
			IfcIndexedTextureMap ifcIndexedTextureMap = (IfcIndexedTextureMap) theEObject;
			T result = caseIfcIndexedTextureMap(ifcIndexedTextureMap);
			if (result == null)
				result = caseIfcTextureCoordinate(ifcIndexedTextureMap);
			if (result == null)
				result = caseIfcPresentationItem(ifcIndexedTextureMap);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INDEXED_TRIANGLE_TEXTURE_MAP: {
			IfcIndexedTriangleTextureMap ifcIndexedTriangleTextureMap = (IfcIndexedTriangleTextureMap) theEObject;
			T result = caseIfcIndexedTriangleTextureMap(ifcIndexedTriangleTextureMap);
			if (result == null)
				result = caseIfcIndexedTextureMap(ifcIndexedTriangleTextureMap);
			if (result == null)
				result = caseIfcTextureCoordinate(ifcIndexedTriangleTextureMap);
			if (result == null)
				result = caseIfcPresentationItem(ifcIndexedTriangleTextureMap);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INTERCEPTOR: {
			IfcInterceptor ifcInterceptor = (IfcInterceptor) theEObject;
			T result = caseIfcInterceptor(ifcInterceptor);
			if (result == null)
				result = caseIfcFlowTreatmentDevice(ifcInterceptor);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcInterceptor);
			if (result == null)
				result = caseIfcDistributionElement(ifcInterceptor);
			if (result == null)
				result = caseIfcElement(ifcInterceptor);
			if (result == null)
				result = caseIfcProduct(ifcInterceptor);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcInterceptor);
			if (result == null)
				result = caseIfcObject(ifcInterceptor);
			if (result == null)
				result = caseIfcProductSelect(ifcInterceptor);
			if (result == null)
				result = caseIfcObjectDefinition(ifcInterceptor);
			if (result == null)
				result = caseIfcRoot(ifcInterceptor);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcInterceptor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INTERCEPTOR_TYPE: {
			IfcInterceptorType ifcInterceptorType = (IfcInterceptorType) theEObject;
			T result = caseIfcInterceptorType(ifcInterceptorType);
			if (result == null)
				result = caseIfcFlowTreatmentDeviceType(ifcInterceptorType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcInterceptorType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcInterceptorType);
			if (result == null)
				result = caseIfcElementType(ifcInterceptorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcInterceptorType);
			if (result == null)
				result = caseIfcTypeObject(ifcInterceptorType);
			if (result == null)
				result = caseIfcProductSelect(ifcInterceptorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcInterceptorType);
			if (result == null)
				result = caseIfcRoot(ifcInterceptorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcInterceptorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INTERSECTION_CURVE: {
			IfcIntersectionCurve ifcIntersectionCurve = (IfcIntersectionCurve) theEObject;
			T result = caseIfcIntersectionCurve(ifcIntersectionCurve);
			if (result == null)
				result = caseIfcSurfaceCurve(ifcIntersectionCurve);
			if (result == null)
				result = caseIfcCurve(ifcIntersectionCurve);
			if (result == null)
				result = caseIfcCurveOnSurface(ifcIntersectionCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcIntersectionCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcIntersectionCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcIntersectionCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcIntersectionCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INVENTORY: {
			IfcInventory ifcInventory = (IfcInventory) theEObject;
			T result = caseIfcInventory(ifcInventory);
			if (result == null)
				result = caseIfcGroup(ifcInventory);
			if (result == null)
				result = caseIfcObject(ifcInventory);
			if (result == null)
				result = caseIfcObjectDefinition(ifcInventory);
			if (result == null)
				result = caseIfcRoot(ifcInventory);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcInventory);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_IRREGULAR_TIME_SERIES: {
			IfcIrregularTimeSeries ifcIrregularTimeSeries = (IfcIrregularTimeSeries) theEObject;
			T result = caseIfcIrregularTimeSeries(ifcIrregularTimeSeries);
			if (result == null)
				result = caseIfcTimeSeries(ifcIrregularTimeSeries);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcIrregularTimeSeries);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcIrregularTimeSeries);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcIrregularTimeSeries);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_IRREGULAR_TIME_SERIES_VALUE: {
			IfcIrregularTimeSeriesValue ifcIrregularTimeSeriesValue = (IfcIrregularTimeSeriesValue) theEObject;
			T result = caseIfcIrregularTimeSeriesValue(ifcIrregularTimeSeriesValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_JUNCTION_BOX: {
			IfcJunctionBox ifcJunctionBox = (IfcJunctionBox) theEObject;
			T result = caseIfcJunctionBox(ifcJunctionBox);
			if (result == null)
				result = caseIfcFlowFitting(ifcJunctionBox);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcJunctionBox);
			if (result == null)
				result = caseIfcDistributionElement(ifcJunctionBox);
			if (result == null)
				result = caseIfcElement(ifcJunctionBox);
			if (result == null)
				result = caseIfcProduct(ifcJunctionBox);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcJunctionBox);
			if (result == null)
				result = caseIfcObject(ifcJunctionBox);
			if (result == null)
				result = caseIfcProductSelect(ifcJunctionBox);
			if (result == null)
				result = caseIfcObjectDefinition(ifcJunctionBox);
			if (result == null)
				result = caseIfcRoot(ifcJunctionBox);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcJunctionBox);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_JUNCTION_BOX_TYPE: {
			IfcJunctionBoxType ifcJunctionBoxType = (IfcJunctionBoxType) theEObject;
			T result = caseIfcJunctionBoxType(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcFlowFittingType(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcElementType(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcTypeProduct(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcTypeObject(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcProductSelect(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcRoot(ifcJunctionBoxType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcJunctionBoxType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LSHAPE_PROFILE_DEF: {
			IfcLShapeProfileDef ifcLShapeProfileDef = (IfcLShapeProfileDef) theEObject;
			T result = caseIfcLShapeProfileDef(ifcLShapeProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcLShapeProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcLShapeProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcLShapeProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LABOR_RESOURCE: {
			IfcLaborResource ifcLaborResource = (IfcLaborResource) theEObject;
			T result = caseIfcLaborResource(ifcLaborResource);
			if (result == null)
				result = caseIfcConstructionResource(ifcLaborResource);
			if (result == null)
				result = caseIfcResource(ifcLaborResource);
			if (result == null)
				result = caseIfcObject(ifcLaborResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcLaborResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcLaborResource);
			if (result == null)
				result = caseIfcRoot(ifcLaborResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcLaborResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LABOR_RESOURCE_TYPE: {
			IfcLaborResourceType ifcLaborResourceType = (IfcLaborResourceType) theEObject;
			T result = caseIfcLaborResourceType(ifcLaborResourceType);
			if (result == null)
				result = caseIfcConstructionResourceType(ifcLaborResourceType);
			if (result == null)
				result = caseIfcTypeResource(ifcLaborResourceType);
			if (result == null)
				result = caseIfcTypeObject(ifcLaborResourceType);
			if (result == null)
				result = caseIfcResourceSelect(ifcLaborResourceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcLaborResourceType);
			if (result == null)
				result = caseIfcRoot(ifcLaborResourceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcLaborResourceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LAG_TIME: {
			IfcLagTime ifcLagTime = (IfcLagTime) theEObject;
			T result = caseIfcLagTime(ifcLagTime);
			if (result == null)
				result = caseIfcSchedulingTime(ifcLagTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LAMP: {
			IfcLamp ifcLamp = (IfcLamp) theEObject;
			T result = caseIfcLamp(ifcLamp);
			if (result == null)
				result = caseIfcFlowTerminal(ifcLamp);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcLamp);
			if (result == null)
				result = caseIfcDistributionElement(ifcLamp);
			if (result == null)
				result = caseIfcElement(ifcLamp);
			if (result == null)
				result = caseIfcProduct(ifcLamp);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcLamp);
			if (result == null)
				result = caseIfcObject(ifcLamp);
			if (result == null)
				result = caseIfcProductSelect(ifcLamp);
			if (result == null)
				result = caseIfcObjectDefinition(ifcLamp);
			if (result == null)
				result = caseIfcRoot(ifcLamp);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcLamp);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LAMP_TYPE: {
			IfcLampType ifcLampType = (IfcLampType) theEObject;
			T result = caseIfcLampType(ifcLampType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcLampType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcLampType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcLampType);
			if (result == null)
				result = caseIfcElementType(ifcLampType);
			if (result == null)
				result = caseIfcTypeProduct(ifcLampType);
			if (result == null)
				result = caseIfcTypeObject(ifcLampType);
			if (result == null)
				result = caseIfcProductSelect(ifcLampType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcLampType);
			if (result == null)
				result = caseIfcRoot(ifcLampType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcLampType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIBRARY_INFORMATION: {
			IfcLibraryInformation ifcLibraryInformation = (IfcLibraryInformation) theEObject;
			T result = caseIfcLibraryInformation(ifcLibraryInformation);
			if (result == null)
				result = caseIfcExternalInformation(ifcLibraryInformation);
			if (result == null)
				result = caseIfcLibrarySelect(ifcLibraryInformation);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcLibraryInformation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIBRARY_REFERENCE: {
			IfcLibraryReference ifcLibraryReference = (IfcLibraryReference) theEObject;
			T result = caseIfcLibraryReference(ifcLibraryReference);
			if (result == null)
				result = caseIfcExternalReference(ifcLibraryReference);
			if (result == null)
				result = caseIfcLibrarySelect(ifcLibraryReference);
			if (result == null)
				result = caseIfcLightDistributionDataSourceSelect(ifcLibraryReference);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcLibraryReference);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcLibraryReference);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_DISTRIBUTION_DATA: {
			IfcLightDistributionData ifcLightDistributionData = (IfcLightDistributionData) theEObject;
			T result = caseIfcLightDistributionData(ifcLightDistributionData);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_FIXTURE: {
			IfcLightFixture ifcLightFixture = (IfcLightFixture) theEObject;
			T result = caseIfcLightFixture(ifcLightFixture);
			if (result == null)
				result = caseIfcFlowTerminal(ifcLightFixture);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcLightFixture);
			if (result == null)
				result = caseIfcDistributionElement(ifcLightFixture);
			if (result == null)
				result = caseIfcElement(ifcLightFixture);
			if (result == null)
				result = caseIfcProduct(ifcLightFixture);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcLightFixture);
			if (result == null)
				result = caseIfcObject(ifcLightFixture);
			if (result == null)
				result = caseIfcProductSelect(ifcLightFixture);
			if (result == null)
				result = caseIfcObjectDefinition(ifcLightFixture);
			if (result == null)
				result = caseIfcRoot(ifcLightFixture);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcLightFixture);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_FIXTURE_TYPE: {
			IfcLightFixtureType ifcLightFixtureType = (IfcLightFixtureType) theEObject;
			T result = caseIfcLightFixtureType(ifcLightFixtureType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcLightFixtureType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcLightFixtureType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcLightFixtureType);
			if (result == null)
				result = caseIfcElementType(ifcLightFixtureType);
			if (result == null)
				result = caseIfcTypeProduct(ifcLightFixtureType);
			if (result == null)
				result = caseIfcTypeObject(ifcLightFixtureType);
			if (result == null)
				result = caseIfcProductSelect(ifcLightFixtureType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcLightFixtureType);
			if (result == null)
				result = caseIfcRoot(ifcLightFixtureType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcLightFixtureType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_INTENSITY_DISTRIBUTION: {
			IfcLightIntensityDistribution ifcLightIntensityDistribution = (IfcLightIntensityDistribution) theEObject;
			T result = caseIfcLightIntensityDistribution(ifcLightIntensityDistribution);
			if (result == null)
				result = caseIfcLightDistributionDataSourceSelect(ifcLightIntensityDistribution);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_SOURCE: {
			IfcLightSource ifcLightSource = (IfcLightSource) theEObject;
			T result = caseIfcLightSource(ifcLightSource);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcLightSource);
			if (result == null)
				result = caseIfcRepresentationItem(ifcLightSource);
			if (result == null)
				result = caseIfcLayeredItem(ifcLightSource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_SOURCE_AMBIENT: {
			IfcLightSourceAmbient ifcLightSourceAmbient = (IfcLightSourceAmbient) theEObject;
			T result = caseIfcLightSourceAmbient(ifcLightSourceAmbient);
			if (result == null)
				result = caseIfcLightSource(ifcLightSourceAmbient);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcLightSourceAmbient);
			if (result == null)
				result = caseIfcRepresentationItem(ifcLightSourceAmbient);
			if (result == null)
				result = caseIfcLayeredItem(ifcLightSourceAmbient);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_SOURCE_DIRECTIONAL: {
			IfcLightSourceDirectional ifcLightSourceDirectional = (IfcLightSourceDirectional) theEObject;
			T result = caseIfcLightSourceDirectional(ifcLightSourceDirectional);
			if (result == null)
				result = caseIfcLightSource(ifcLightSourceDirectional);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcLightSourceDirectional);
			if (result == null)
				result = caseIfcRepresentationItem(ifcLightSourceDirectional);
			if (result == null)
				result = caseIfcLayeredItem(ifcLightSourceDirectional);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_SOURCE_GONIOMETRIC: {
			IfcLightSourceGoniometric ifcLightSourceGoniometric = (IfcLightSourceGoniometric) theEObject;
			T result = caseIfcLightSourceGoniometric(ifcLightSourceGoniometric);
			if (result == null)
				result = caseIfcLightSource(ifcLightSourceGoniometric);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcLightSourceGoniometric);
			if (result == null)
				result = caseIfcRepresentationItem(ifcLightSourceGoniometric);
			if (result == null)
				result = caseIfcLayeredItem(ifcLightSourceGoniometric);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_SOURCE_POSITIONAL: {
			IfcLightSourcePositional ifcLightSourcePositional = (IfcLightSourcePositional) theEObject;
			T result = caseIfcLightSourcePositional(ifcLightSourcePositional);
			if (result == null)
				result = caseIfcLightSource(ifcLightSourcePositional);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcLightSourcePositional);
			if (result == null)
				result = caseIfcRepresentationItem(ifcLightSourcePositional);
			if (result == null)
				result = caseIfcLayeredItem(ifcLightSourcePositional);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_SOURCE_SPOT: {
			IfcLightSourceSpot ifcLightSourceSpot = (IfcLightSourceSpot) theEObject;
			T result = caseIfcLightSourceSpot(ifcLightSourceSpot);
			if (result == null)
				result = caseIfcLightSourcePositional(ifcLightSourceSpot);
			if (result == null)
				result = caseIfcLightSource(ifcLightSourceSpot);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcLightSourceSpot);
			if (result == null)
				result = caseIfcRepresentationItem(ifcLightSourceSpot);
			if (result == null)
				result = caseIfcLayeredItem(ifcLightSourceSpot);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LINE: {
			IfcLine ifcLine = (IfcLine) theEObject;
			T result = caseIfcLine(ifcLine);
			if (result == null)
				result = caseIfcCurve(ifcLine);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcLine);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcLine);
			if (result == null)
				result = caseIfcRepresentationItem(ifcLine);
			if (result == null)
				result = caseIfcLayeredItem(ifcLine);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LOCAL_PLACEMENT: {
			IfcLocalPlacement ifcLocalPlacement = (IfcLocalPlacement) theEObject;
			T result = caseIfcLocalPlacement(ifcLocalPlacement);
			if (result == null)
				result = caseIfcObjectPlacement(ifcLocalPlacement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LOOP: {
			IfcLoop ifcLoop = (IfcLoop) theEObject;
			T result = caseIfcLoop(ifcLoop);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcLoop);
			if (result == null)
				result = caseIfcRepresentationItem(ifcLoop);
			if (result == null)
				result = caseIfcLayeredItem(ifcLoop);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MANIFOLD_SOLID_BREP: {
			IfcManifoldSolidBrep ifcManifoldSolidBrep = (IfcManifoldSolidBrep) theEObject;
			T result = caseIfcManifoldSolidBrep(ifcManifoldSolidBrep);
			if (result == null)
				result = caseIfcSolidModel(ifcManifoldSolidBrep);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcManifoldSolidBrep);
			if (result == null)
				result = caseIfcBooleanOperand(ifcManifoldSolidBrep);
			if (result == null)
				result = caseIfcSolidOrShell(ifcManifoldSolidBrep);
			if (result == null)
				result = caseIfcRepresentationItem(ifcManifoldSolidBrep);
			if (result == null)
				result = caseIfcLayeredItem(ifcManifoldSolidBrep);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MAP_CONVERSION: {
			IfcMapConversion ifcMapConversion = (IfcMapConversion) theEObject;
			T result = caseIfcMapConversion(ifcMapConversion);
			if (result == null)
				result = caseIfcCoordinateOperation(ifcMapConversion);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MAPPED_ITEM: {
			IfcMappedItem ifcMappedItem = (IfcMappedItem) theEObject;
			T result = caseIfcMappedItem(ifcMappedItem);
			if (result == null)
				result = caseIfcRepresentationItem(ifcMappedItem);
			if (result == null)
				result = caseIfcLayeredItem(ifcMappedItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL: {
			IfcMaterial ifcMaterial = (IfcMaterial) theEObject;
			T result = caseIfcMaterial(ifcMaterial);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterial);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterial);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterial);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterial);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_CLASSIFICATION_RELATIONSHIP: {
			IfcMaterialClassificationRelationship ifcMaterialClassificationRelationship = (IfcMaterialClassificationRelationship) theEObject;
			T result = caseIfcMaterialClassificationRelationship(ifcMaterialClassificationRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_CONSTITUENT: {
			IfcMaterialConstituent ifcMaterialConstituent = (IfcMaterialConstituent) theEObject;
			T result = caseIfcMaterialConstituent(ifcMaterialConstituent);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterialConstituent);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialConstituent);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialConstituent);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialConstituent);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_CONSTITUENT_SET: {
			IfcMaterialConstituentSet ifcMaterialConstituentSet = (IfcMaterialConstituentSet) theEObject;
			T result = caseIfcMaterialConstituentSet(ifcMaterialConstituentSet);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterialConstituentSet);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialConstituentSet);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialConstituentSet);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialConstituentSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_DEFINITION: {
			IfcMaterialDefinition ifcMaterialDefinition = (IfcMaterialDefinition) theEObject;
			T result = caseIfcMaterialDefinition(ifcMaterialDefinition);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialDefinition);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialDefinition);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_DEFINITION_REPRESENTATION: {
			IfcMaterialDefinitionRepresentation ifcMaterialDefinitionRepresentation = (IfcMaterialDefinitionRepresentation) theEObject;
			T result = caseIfcMaterialDefinitionRepresentation(ifcMaterialDefinitionRepresentation);
			if (result == null)
				result = caseIfcProductRepresentation(ifcMaterialDefinitionRepresentation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_LAYER: {
			IfcMaterialLayer ifcMaterialLayer = (IfcMaterialLayer) theEObject;
			T result = caseIfcMaterialLayer(ifcMaterialLayer);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterialLayer);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialLayer);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialLayer);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialLayer);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_LAYER_SET: {
			IfcMaterialLayerSet ifcMaterialLayerSet = (IfcMaterialLayerSet) theEObject;
			T result = caseIfcMaterialLayerSet(ifcMaterialLayerSet);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterialLayerSet);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialLayerSet);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialLayerSet);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialLayerSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_LAYER_SET_USAGE: {
			IfcMaterialLayerSetUsage ifcMaterialLayerSetUsage = (IfcMaterialLayerSetUsage) theEObject;
			T result = caseIfcMaterialLayerSetUsage(ifcMaterialLayerSetUsage);
			if (result == null)
				result = caseIfcMaterialUsageDefinition(ifcMaterialLayerSetUsage);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialLayerSetUsage);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_LAYER_WITH_OFFSETS: {
			IfcMaterialLayerWithOffsets ifcMaterialLayerWithOffsets = (IfcMaterialLayerWithOffsets) theEObject;
			T result = caseIfcMaterialLayerWithOffsets(ifcMaterialLayerWithOffsets);
			if (result == null)
				result = caseIfcMaterialLayer(ifcMaterialLayerWithOffsets);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterialLayerWithOffsets);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialLayerWithOffsets);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialLayerWithOffsets);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialLayerWithOffsets);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_LIST: {
			IfcMaterialList ifcMaterialList = (IfcMaterialList) theEObject;
			T result = caseIfcMaterialList(ifcMaterialList);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialList);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_PROFILE: {
			IfcMaterialProfile ifcMaterialProfile = (IfcMaterialProfile) theEObject;
			T result = caseIfcMaterialProfile(ifcMaterialProfile);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterialProfile);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialProfile);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialProfile);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialProfile);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_PROFILE_SET: {
			IfcMaterialProfileSet ifcMaterialProfileSet = (IfcMaterialProfileSet) theEObject;
			T result = caseIfcMaterialProfileSet(ifcMaterialProfileSet);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterialProfileSet);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialProfileSet);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialProfileSet);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialProfileSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_PROFILE_SET_USAGE: {
			IfcMaterialProfileSetUsage ifcMaterialProfileSetUsage = (IfcMaterialProfileSetUsage) theEObject;
			T result = caseIfcMaterialProfileSetUsage(ifcMaterialProfileSetUsage);
			if (result == null)
				result = caseIfcMaterialUsageDefinition(ifcMaterialProfileSetUsage);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialProfileSetUsage);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_PROFILE_SET_USAGE_TAPERING: {
			IfcMaterialProfileSetUsageTapering ifcMaterialProfileSetUsageTapering = (IfcMaterialProfileSetUsageTapering) theEObject;
			T result = caseIfcMaterialProfileSetUsageTapering(ifcMaterialProfileSetUsageTapering);
			if (result == null)
				result = caseIfcMaterialProfileSetUsage(ifcMaterialProfileSetUsageTapering);
			if (result == null)
				result = caseIfcMaterialUsageDefinition(ifcMaterialProfileSetUsageTapering);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialProfileSetUsageTapering);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_PROFILE_WITH_OFFSETS: {
			IfcMaterialProfileWithOffsets ifcMaterialProfileWithOffsets = (IfcMaterialProfileWithOffsets) theEObject;
			T result = caseIfcMaterialProfileWithOffsets(ifcMaterialProfileWithOffsets);
			if (result == null)
				result = caseIfcMaterialProfile(ifcMaterialProfileWithOffsets);
			if (result == null)
				result = caseIfcMaterialDefinition(ifcMaterialProfileWithOffsets);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialProfileWithOffsets);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcMaterialProfileWithOffsets);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialProfileWithOffsets);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_PROPERTIES: {
			IfcMaterialProperties ifcMaterialProperties = (IfcMaterialProperties) theEObject;
			T result = caseIfcMaterialProperties(ifcMaterialProperties);
			if (result == null)
				result = caseIfcExtendedProperties(ifcMaterialProperties);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcMaterialProperties);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMaterialProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_RELATIONSHIP: {
			IfcMaterialRelationship ifcMaterialRelationship = (IfcMaterialRelationship) theEObject;
			T result = caseIfcMaterialRelationship(ifcMaterialRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcMaterialRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_USAGE_DEFINITION: {
			IfcMaterialUsageDefinition ifcMaterialUsageDefinition = (IfcMaterialUsageDefinition) theEObject;
			T result = caseIfcMaterialUsageDefinition(ifcMaterialUsageDefinition);
			if (result == null)
				result = caseIfcMaterialSelect(ifcMaterialUsageDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MEASURE_WITH_UNIT: {
			IfcMeasureWithUnit ifcMeasureWithUnit = (IfcMeasureWithUnit) theEObject;
			T result = caseIfcMeasureWithUnit(ifcMeasureWithUnit);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMeasureWithUnit);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMeasureWithUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MECHANICAL_FASTENER: {
			IfcMechanicalFastener ifcMechanicalFastener = (IfcMechanicalFastener) theEObject;
			T result = caseIfcMechanicalFastener(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcElementComponent(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcElement(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcProduct(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcObject(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcProductSelect(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcRoot(ifcMechanicalFastener);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMechanicalFastener);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		}
		return null;
	}
	
	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		T t = doSwitch2(classifierID, theEObject);
		if (t != null) {
			return t;
		}
		switch(classifierID) {
		case Ifc4Package.IFC_MECHANICAL_FASTENER_TYPE: {
			IfcMechanicalFastenerType ifcMechanicalFastenerType = (IfcMechanicalFastenerType) theEObject;
			T result = caseIfcMechanicalFastenerType(ifcMechanicalFastenerType);
			if (result == null)
				result = caseIfcElementComponentType(ifcMechanicalFastenerType);
			if (result == null)
				result = caseIfcElementType(ifcMechanicalFastenerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcMechanicalFastenerType);
			if (result == null)
				result = caseIfcTypeObject(ifcMechanicalFastenerType);
			if (result == null)
				result = caseIfcProductSelect(ifcMechanicalFastenerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMechanicalFastenerType);
			if (result == null)
				result = caseIfcRoot(ifcMechanicalFastenerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMechanicalFastenerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MEDICAL_DEVICE: {
			IfcMedicalDevice ifcMedicalDevice = (IfcMedicalDevice) theEObject;
			T result = caseIfcMedicalDevice(ifcMedicalDevice);
			if (result == null)
				result = caseIfcFlowTerminal(ifcMedicalDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcMedicalDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcMedicalDevice);
			if (result == null)
				result = caseIfcElement(ifcMedicalDevice);
			if (result == null)
				result = caseIfcProduct(ifcMedicalDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcMedicalDevice);
			if (result == null)
				result = caseIfcObject(ifcMedicalDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcMedicalDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMedicalDevice);
			if (result == null)
				result = caseIfcRoot(ifcMedicalDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMedicalDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MEDICAL_DEVICE_TYPE: {
			IfcMedicalDeviceType ifcMedicalDeviceType = (IfcMedicalDeviceType) theEObject;
			T result = caseIfcMedicalDeviceType(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcMedicalDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMedicalDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MEMBER: {
			IfcMember ifcMember = (IfcMember) theEObject;
			T result = caseIfcMember(ifcMember);
			if (result == null)
				result = caseIfcBuildingElement(ifcMember);
			if (result == null)
				result = caseIfcElement(ifcMember);
			if (result == null)
				result = caseIfcProduct(ifcMember);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcMember);
			if (result == null)
				result = caseIfcObject(ifcMember);
			if (result == null)
				result = caseIfcProductSelect(ifcMember);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMember);
			if (result == null)
				result = caseIfcRoot(ifcMember);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMember);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MEMBER_STANDARD_CASE: {
			IfcMemberStandardCase ifcMemberStandardCase = (IfcMemberStandardCase) theEObject;
			T result = caseIfcMemberStandardCase(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcMember(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcElement(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcObject(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcMemberStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMemberStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MEMBER_TYPE: {
			IfcMemberType ifcMemberType = (IfcMemberType) theEObject;
			T result = caseIfcMemberType(ifcMemberType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcMemberType);
			if (result == null)
				result = caseIfcElementType(ifcMemberType);
			if (result == null)
				result = caseIfcTypeProduct(ifcMemberType);
			if (result == null)
				result = caseIfcTypeObject(ifcMemberType);
			if (result == null)
				result = caseIfcProductSelect(ifcMemberType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMemberType);
			if (result == null)
				result = caseIfcRoot(ifcMemberType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMemberType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_METRIC: {
			IfcMetric ifcMetric = (IfcMetric) theEObject;
			T result = caseIfcMetric(ifcMetric);
			if (result == null)
				result = caseIfcConstraint(ifcMetric);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMetric);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MIRRORED_PROFILE_DEF: {
			IfcMirroredProfileDef ifcMirroredProfileDef = (IfcMirroredProfileDef) theEObject;
			T result = caseIfcMirroredProfileDef(ifcMirroredProfileDef);
			if (result == null)
				result = caseIfcDerivedProfileDef(ifcMirroredProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcMirroredProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcMirroredProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MONETARY_UNIT: {
			IfcMonetaryUnit ifcMonetaryUnit = (IfcMonetaryUnit) theEObject;
			T result = caseIfcMonetaryUnit(ifcMonetaryUnit);
			if (result == null)
				result = caseIfcUnit(ifcMonetaryUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MOTOR_CONNECTION: {
			IfcMotorConnection ifcMotorConnection = (IfcMotorConnection) theEObject;
			T result = caseIfcMotorConnection(ifcMotorConnection);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcMotorConnection);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcMotorConnection);
			if (result == null)
				result = caseIfcDistributionElement(ifcMotorConnection);
			if (result == null)
				result = caseIfcElement(ifcMotorConnection);
			if (result == null)
				result = caseIfcProduct(ifcMotorConnection);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcMotorConnection);
			if (result == null)
				result = caseIfcObject(ifcMotorConnection);
			if (result == null)
				result = caseIfcProductSelect(ifcMotorConnection);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMotorConnection);
			if (result == null)
				result = caseIfcRoot(ifcMotorConnection);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMotorConnection);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MOTOR_CONNECTION_TYPE: {
			IfcMotorConnectionType ifcMotorConnectionType = (IfcMotorConnectionType) theEObject;
			T result = caseIfcMotorConnectionType(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcElementType(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcTypeProduct(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcTypeObject(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcProductSelect(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcRoot(ifcMotorConnectionType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcMotorConnectionType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_NAMED_UNIT: {
			IfcNamedUnit ifcNamedUnit = (IfcNamedUnit) theEObject;
			T result = caseIfcNamedUnit(ifcNamedUnit);
			if (result == null)
				result = caseIfcUnit(ifcNamedUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OBJECT: {
			IfcObject ifcObject = (IfcObject) theEObject;
			T result = caseIfcObject(ifcObject);
			if (result == null)
				result = caseIfcObjectDefinition(ifcObject);
			if (result == null)
				result = caseIfcRoot(ifcObject);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcObject);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OBJECT_DEFINITION: {
			IfcObjectDefinition ifcObjectDefinition = (IfcObjectDefinition) theEObject;
			T result = caseIfcObjectDefinition(ifcObjectDefinition);
			if (result == null)
				result = caseIfcRoot(ifcObjectDefinition);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcObjectDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OBJECT_PLACEMENT: {
			IfcObjectPlacement ifcObjectPlacement = (IfcObjectPlacement) theEObject;
			T result = caseIfcObjectPlacement(ifcObjectPlacement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OBJECTIVE: {
			IfcObjective ifcObjective = (IfcObjective) theEObject;
			T result = caseIfcObjective(ifcObjective);
			if (result == null)
				result = caseIfcConstraint(ifcObjective);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcObjective);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OCCUPANT: {
			IfcOccupant ifcOccupant = (IfcOccupant) theEObject;
			T result = caseIfcOccupant(ifcOccupant);
			if (result == null)
				result = caseIfcActor(ifcOccupant);
			if (result == null)
				result = caseIfcObject(ifcOccupant);
			if (result == null)
				result = caseIfcObjectDefinition(ifcOccupant);
			if (result == null)
				result = caseIfcRoot(ifcOccupant);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcOccupant);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OFFSET_CURVE2_D: {
			IfcOffsetCurve2D ifcOffsetCurve2D = (IfcOffsetCurve2D) theEObject;
			T result = caseIfcOffsetCurve2D(ifcOffsetCurve2D);
			if (result == null)
				result = caseIfcCurve(ifcOffsetCurve2D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcOffsetCurve2D);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcOffsetCurve2D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcOffsetCurve2D);
			if (result == null)
				result = caseIfcLayeredItem(ifcOffsetCurve2D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OFFSET_CURVE3_D: {
			IfcOffsetCurve3D ifcOffsetCurve3D = (IfcOffsetCurve3D) theEObject;
			T result = caseIfcOffsetCurve3D(ifcOffsetCurve3D);
			if (result == null)
				result = caseIfcCurve(ifcOffsetCurve3D);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcOffsetCurve3D);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcOffsetCurve3D);
			if (result == null)
				result = caseIfcRepresentationItem(ifcOffsetCurve3D);
			if (result == null)
				result = caseIfcLayeredItem(ifcOffsetCurve3D);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OPEN_SHELL: {
			IfcOpenShell ifcOpenShell = (IfcOpenShell) theEObject;
			T result = caseIfcOpenShell(ifcOpenShell);
			if (result == null)
				result = caseIfcConnectedFaceSet(ifcOpenShell);
			if (result == null)
				result = caseIfcShell(ifcOpenShell);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcOpenShell);
			if (result == null)
				result = caseIfcRepresentationItem(ifcOpenShell);
			if (result == null)
				result = caseIfcLayeredItem(ifcOpenShell);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OPENING_ELEMENT: {
			IfcOpeningElement ifcOpeningElement = (IfcOpeningElement) theEObject;
			T result = caseIfcOpeningElement(ifcOpeningElement);
			if (result == null)
				result = caseIfcFeatureElementSubtraction(ifcOpeningElement);
			if (result == null)
				result = caseIfcFeatureElement(ifcOpeningElement);
			if (result == null)
				result = caseIfcElement(ifcOpeningElement);
			if (result == null)
				result = caseIfcProduct(ifcOpeningElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcOpeningElement);
			if (result == null)
				result = caseIfcObject(ifcOpeningElement);
			if (result == null)
				result = caseIfcProductSelect(ifcOpeningElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcOpeningElement);
			if (result == null)
				result = caseIfcRoot(ifcOpeningElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcOpeningElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OPENING_STANDARD_CASE: {
			IfcOpeningStandardCase ifcOpeningStandardCase = (IfcOpeningStandardCase) theEObject;
			T result = caseIfcOpeningStandardCase(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcOpeningElement(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcFeatureElementSubtraction(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcFeatureElement(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcElement(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcObject(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcOpeningStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcOpeningStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ORGANIZATION: {
			IfcOrganization ifcOrganization = (IfcOrganization) theEObject;
			T result = caseIfcOrganization(ifcOrganization);
			if (result == null)
				result = caseIfcActorSelect(ifcOrganization);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcOrganization);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcOrganization);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ORGANIZATION_RELATIONSHIP: {
			IfcOrganizationRelationship ifcOrganizationRelationship = (IfcOrganizationRelationship) theEObject;
			T result = caseIfcOrganizationRelationship(ifcOrganizationRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcOrganizationRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ORIENTED_EDGE: {
			IfcOrientedEdge ifcOrientedEdge = (IfcOrientedEdge) theEObject;
			T result = caseIfcOrientedEdge(ifcOrientedEdge);
			if (result == null)
				result = caseIfcEdge(ifcOrientedEdge);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcOrientedEdge);
			if (result == null)
				result = caseIfcRepresentationItem(ifcOrientedEdge);
			if (result == null)
				result = caseIfcLayeredItem(ifcOrientedEdge);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OUTER_BOUNDARY_CURVE: {
			IfcOuterBoundaryCurve ifcOuterBoundaryCurve = (IfcOuterBoundaryCurve) theEObject;
			T result = caseIfcOuterBoundaryCurve(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcBoundaryCurve(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcCompositeCurveOnSurface(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcCompositeCurve(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcCurveOnSurface(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcBoundedCurve(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcCurve(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcOuterBoundaryCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcOuterBoundaryCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OUTLET: {
			IfcOutlet ifcOutlet = (IfcOutlet) theEObject;
			T result = caseIfcOutlet(ifcOutlet);
			if (result == null)
				result = caseIfcFlowTerminal(ifcOutlet);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcOutlet);
			if (result == null)
				result = caseIfcDistributionElement(ifcOutlet);
			if (result == null)
				result = caseIfcElement(ifcOutlet);
			if (result == null)
				result = caseIfcProduct(ifcOutlet);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcOutlet);
			if (result == null)
				result = caseIfcObject(ifcOutlet);
			if (result == null)
				result = caseIfcProductSelect(ifcOutlet);
			if (result == null)
				result = caseIfcObjectDefinition(ifcOutlet);
			if (result == null)
				result = caseIfcRoot(ifcOutlet);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcOutlet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OUTLET_TYPE: {
			IfcOutletType ifcOutletType = (IfcOutletType) theEObject;
			T result = caseIfcOutletType(ifcOutletType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcOutletType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcOutletType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcOutletType);
			if (result == null)
				result = caseIfcElementType(ifcOutletType);
			if (result == null)
				result = caseIfcTypeProduct(ifcOutletType);
			if (result == null)
				result = caseIfcTypeObject(ifcOutletType);
			if (result == null)
				result = caseIfcProductSelect(ifcOutletType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcOutletType);
			if (result == null)
				result = caseIfcRoot(ifcOutletType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcOutletType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OWNER_HISTORY: {
			IfcOwnerHistory ifcOwnerHistory = (IfcOwnerHistory) theEObject;
			T result = caseIfcOwnerHistory(ifcOwnerHistory);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PARAMETERIZED_PROFILE_DEF: {
			IfcParameterizedProfileDef ifcParameterizedProfileDef = (IfcParameterizedProfileDef) theEObject;
			T result = caseIfcParameterizedProfileDef(ifcParameterizedProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcParameterizedProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcParameterizedProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PATH: {
			IfcPath ifcPath = (IfcPath) theEObject;
			T result = caseIfcPath(ifcPath);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcPath);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPath);
			if (result == null)
				result = caseIfcLayeredItem(ifcPath);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PCURVE: {
			IfcPcurve ifcPcurve = (IfcPcurve) theEObject;
			T result = caseIfcPcurve(ifcPcurve);
			if (result == null)
				result = caseIfcCurve(ifcPcurve);
			if (result == null)
				result = caseIfcCurveOnSurface(ifcPcurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPcurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcPcurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPcurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcPcurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PERFORMANCE_HISTORY: {
			IfcPerformanceHistory ifcPerformanceHistory = (IfcPerformanceHistory) theEObject;
			T result = caseIfcPerformanceHistory(ifcPerformanceHistory);
			if (result == null)
				result = caseIfcControl(ifcPerformanceHistory);
			if (result == null)
				result = caseIfcObject(ifcPerformanceHistory);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPerformanceHistory);
			if (result == null)
				result = caseIfcRoot(ifcPerformanceHistory);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPerformanceHistory);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PERMEABLE_COVERING_PROPERTIES: {
			IfcPermeableCoveringProperties ifcPermeableCoveringProperties = (IfcPermeableCoveringProperties) theEObject;
			T result = caseIfcPermeableCoveringProperties(ifcPermeableCoveringProperties);
			if (result == null)
				result = caseIfcPreDefinedPropertySet(ifcPermeableCoveringProperties);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcPermeableCoveringProperties);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcPermeableCoveringProperties);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcPermeableCoveringProperties);
			if (result == null)
				result = caseIfcRoot(ifcPermeableCoveringProperties);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPermeableCoveringProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PERMIT: {
			IfcPermit ifcPermit = (IfcPermit) theEObject;
			T result = caseIfcPermit(ifcPermit);
			if (result == null)
				result = caseIfcControl(ifcPermit);
			if (result == null)
				result = caseIfcObject(ifcPermit);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPermit);
			if (result == null)
				result = caseIfcRoot(ifcPermit);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPermit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PERSON: {
			IfcPerson ifcPerson = (IfcPerson) theEObject;
			T result = caseIfcPerson(ifcPerson);
			if (result == null)
				result = caseIfcActorSelect(ifcPerson);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcPerson);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPerson);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PERSON_AND_ORGANIZATION: {
			IfcPersonAndOrganization ifcPersonAndOrganization = (IfcPersonAndOrganization) theEObject;
			T result = caseIfcPersonAndOrganization(ifcPersonAndOrganization);
			if (result == null)
				result = caseIfcActorSelect(ifcPersonAndOrganization);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcPersonAndOrganization);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPersonAndOrganization);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PHYSICAL_COMPLEX_QUANTITY: {
			IfcPhysicalComplexQuantity ifcPhysicalComplexQuantity = (IfcPhysicalComplexQuantity) theEObject;
			T result = caseIfcPhysicalComplexQuantity(ifcPhysicalComplexQuantity);
			if (result == null)
				result = caseIfcPhysicalQuantity(ifcPhysicalComplexQuantity);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPhysicalComplexQuantity);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PHYSICAL_QUANTITY: {
			IfcPhysicalQuantity ifcPhysicalQuantity = (IfcPhysicalQuantity) theEObject;
			T result = caseIfcPhysicalQuantity(ifcPhysicalQuantity);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPhysicalQuantity);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PHYSICAL_SIMPLE_QUANTITY: {
			IfcPhysicalSimpleQuantity ifcPhysicalSimpleQuantity = (IfcPhysicalSimpleQuantity) theEObject;
			T result = caseIfcPhysicalSimpleQuantity(ifcPhysicalSimpleQuantity);
			if (result == null)
				result = caseIfcPhysicalQuantity(ifcPhysicalSimpleQuantity);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPhysicalSimpleQuantity);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PILE: {
			IfcPile ifcPile = (IfcPile) theEObject;
			T result = caseIfcPile(ifcPile);
			if (result == null)
				result = caseIfcBuildingElement(ifcPile);
			if (result == null)
				result = caseIfcElement(ifcPile);
			if (result == null)
				result = caseIfcProduct(ifcPile);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcPile);
			if (result == null)
				result = caseIfcObject(ifcPile);
			if (result == null)
				result = caseIfcProductSelect(ifcPile);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPile);
			if (result == null)
				result = caseIfcRoot(ifcPile);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPile);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PILE_TYPE: {
			IfcPileType ifcPileType = (IfcPileType) theEObject;
			T result = caseIfcPileType(ifcPileType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcPileType);
			if (result == null)
				result = caseIfcElementType(ifcPileType);
			if (result == null)
				result = caseIfcTypeProduct(ifcPileType);
			if (result == null)
				result = caseIfcTypeObject(ifcPileType);
			if (result == null)
				result = caseIfcProductSelect(ifcPileType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPileType);
			if (result == null)
				result = caseIfcRoot(ifcPileType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPileType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PIPE_FITTING: {
			IfcPipeFitting ifcPipeFitting = (IfcPipeFitting) theEObject;
			T result = caseIfcPipeFitting(ifcPipeFitting);
			if (result == null)
				result = caseIfcFlowFitting(ifcPipeFitting);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcPipeFitting);
			if (result == null)
				result = caseIfcDistributionElement(ifcPipeFitting);
			if (result == null)
				result = caseIfcElement(ifcPipeFitting);
			if (result == null)
				result = caseIfcProduct(ifcPipeFitting);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcPipeFitting);
			if (result == null)
				result = caseIfcObject(ifcPipeFitting);
			if (result == null)
				result = caseIfcProductSelect(ifcPipeFitting);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPipeFitting);
			if (result == null)
				result = caseIfcRoot(ifcPipeFitting);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPipeFitting);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PIPE_FITTING_TYPE: {
			IfcPipeFittingType ifcPipeFittingType = (IfcPipeFittingType) theEObject;
			T result = caseIfcPipeFittingType(ifcPipeFittingType);
			if (result == null)
				result = caseIfcFlowFittingType(ifcPipeFittingType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcPipeFittingType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcPipeFittingType);
			if (result == null)
				result = caseIfcElementType(ifcPipeFittingType);
			if (result == null)
				result = caseIfcTypeProduct(ifcPipeFittingType);
			if (result == null)
				result = caseIfcTypeObject(ifcPipeFittingType);
			if (result == null)
				result = caseIfcProductSelect(ifcPipeFittingType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPipeFittingType);
			if (result == null)
				result = caseIfcRoot(ifcPipeFittingType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPipeFittingType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PIPE_SEGMENT: {
			IfcPipeSegment ifcPipeSegment = (IfcPipeSegment) theEObject;
			T result = caseIfcPipeSegment(ifcPipeSegment);
			if (result == null)
				result = caseIfcFlowSegment(ifcPipeSegment);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcPipeSegment);
			if (result == null)
				result = caseIfcDistributionElement(ifcPipeSegment);
			if (result == null)
				result = caseIfcElement(ifcPipeSegment);
			if (result == null)
				result = caseIfcProduct(ifcPipeSegment);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcPipeSegment);
			if (result == null)
				result = caseIfcObject(ifcPipeSegment);
			if (result == null)
				result = caseIfcProductSelect(ifcPipeSegment);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPipeSegment);
			if (result == null)
				result = caseIfcRoot(ifcPipeSegment);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPipeSegment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PIPE_SEGMENT_TYPE: {
			IfcPipeSegmentType ifcPipeSegmentType = (IfcPipeSegmentType) theEObject;
			T result = caseIfcPipeSegmentType(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcFlowSegmentType(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcElementType(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcTypeProduct(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcTypeObject(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcProductSelect(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcRoot(ifcPipeSegmentType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPipeSegmentType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PIXEL_TEXTURE: {
			IfcPixelTexture ifcPixelTexture = (IfcPixelTexture) theEObject;
			T result = caseIfcPixelTexture(ifcPixelTexture);
			if (result == null)
				result = caseIfcSurfaceTexture(ifcPixelTexture);
			if (result == null)
				result = caseIfcPresentationItem(ifcPixelTexture);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLACEMENT: {
			IfcPlacement ifcPlacement = (IfcPlacement) theEObject;
			T result = caseIfcPlacement(ifcPlacement);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPlacement);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPlacement);
			if (result == null)
				result = caseIfcLayeredItem(ifcPlacement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLANAR_BOX: {
			IfcPlanarBox ifcPlanarBox = (IfcPlanarBox) theEObject;
			T result = caseIfcPlanarBox(ifcPlanarBox);
			if (result == null)
				result = caseIfcPlanarExtent(ifcPlanarBox);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPlanarBox);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPlanarBox);
			if (result == null)
				result = caseIfcLayeredItem(ifcPlanarBox);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLANAR_EXTENT: {
			IfcPlanarExtent ifcPlanarExtent = (IfcPlanarExtent) theEObject;
			T result = caseIfcPlanarExtent(ifcPlanarExtent);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPlanarExtent);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPlanarExtent);
			if (result == null)
				result = caseIfcLayeredItem(ifcPlanarExtent);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLANE: {
			IfcPlane ifcPlane = (IfcPlane) theEObject;
			T result = caseIfcPlane(ifcPlane);
			if (result == null)
				result = caseIfcElementarySurface(ifcPlane);
			if (result == null)
				result = caseIfcSurface(ifcPlane);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPlane);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcPlane);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcPlane);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPlane);
			if (result == null)
				result = caseIfcLayeredItem(ifcPlane);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLATE: {
			IfcPlate ifcPlate = (IfcPlate) theEObject;
			T result = caseIfcPlate(ifcPlate);
			if (result == null)
				result = caseIfcBuildingElement(ifcPlate);
			if (result == null)
				result = caseIfcElement(ifcPlate);
			if (result == null)
				result = caseIfcProduct(ifcPlate);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcPlate);
			if (result == null)
				result = caseIfcObject(ifcPlate);
			if (result == null)
				result = caseIfcProductSelect(ifcPlate);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPlate);
			if (result == null)
				result = caseIfcRoot(ifcPlate);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPlate);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLATE_STANDARD_CASE: {
			IfcPlateStandardCase ifcPlateStandardCase = (IfcPlateStandardCase) theEObject;
			T result = caseIfcPlateStandardCase(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcPlate(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcElement(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcObject(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcPlateStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPlateStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLATE_TYPE: {
			IfcPlateType ifcPlateType = (IfcPlateType) theEObject;
			T result = caseIfcPlateType(ifcPlateType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcPlateType);
			if (result == null)
				result = caseIfcElementType(ifcPlateType);
			if (result == null)
				result = caseIfcTypeProduct(ifcPlateType);
			if (result == null)
				result = caseIfcTypeObject(ifcPlateType);
			if (result == null)
				result = caseIfcProductSelect(ifcPlateType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPlateType);
			if (result == null)
				result = caseIfcRoot(ifcPlateType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPlateType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POINT: {
			IfcPoint ifcPoint = (IfcPoint) theEObject;
			T result = caseIfcPoint(ifcPoint);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPoint);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcPoint);
			if (result == null)
				result = caseIfcPointOrVertexPoint(ifcPoint);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPoint);
			if (result == null)
				result = caseIfcLayeredItem(ifcPoint);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POINT_ON_CURVE: {
			IfcPointOnCurve ifcPointOnCurve = (IfcPointOnCurve) theEObject;
			T result = caseIfcPointOnCurve(ifcPointOnCurve);
			if (result == null)
				result = caseIfcPoint(ifcPointOnCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPointOnCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcPointOnCurve);
			if (result == null)
				result = caseIfcPointOrVertexPoint(ifcPointOnCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPointOnCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcPointOnCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POINT_ON_SURFACE: {
			IfcPointOnSurface ifcPointOnSurface = (IfcPointOnSurface) theEObject;
			T result = caseIfcPointOnSurface(ifcPointOnSurface);
			if (result == null)
				result = caseIfcPoint(ifcPointOnSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPointOnSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcPointOnSurface);
			if (result == null)
				result = caseIfcPointOrVertexPoint(ifcPointOnSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPointOnSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcPointOnSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POLY_LOOP: {
			IfcPolyLoop ifcPolyLoop = (IfcPolyLoop) theEObject;
			T result = caseIfcPolyLoop(ifcPolyLoop);
			if (result == null)
				result = caseIfcLoop(ifcPolyLoop);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcPolyLoop);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPolyLoop);
			if (result == null)
				result = caseIfcLayeredItem(ifcPolyLoop);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POLYGONAL_BOUNDED_HALF_SPACE: {
			IfcPolygonalBoundedHalfSpace ifcPolygonalBoundedHalfSpace = (IfcPolygonalBoundedHalfSpace) theEObject;
			T result = caseIfcPolygonalBoundedHalfSpace(ifcPolygonalBoundedHalfSpace);
			if (result == null)
				result = caseIfcHalfSpaceSolid(ifcPolygonalBoundedHalfSpace);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPolygonalBoundedHalfSpace);
			if (result == null)
				result = caseIfcBooleanOperand(ifcPolygonalBoundedHalfSpace);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPolygonalBoundedHalfSpace);
			if (result == null)
				result = caseIfcLayeredItem(ifcPolygonalBoundedHalfSpace);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POLYGONAL_FACE_SET: {
			IfcPolygonalFaceSet ifcPolygonalFaceSet = (IfcPolygonalFaceSet) theEObject;
			T result = caseIfcPolygonalFaceSet(ifcPolygonalFaceSet);
			if (result == null)
				result = caseIfcTessellatedFaceSet(ifcPolygonalFaceSet);
			if (result == null)
				result = caseIfcTessellatedItem(ifcPolygonalFaceSet);
			if (result == null)
				result = caseIfcBooleanOperand(ifcPolygonalFaceSet);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPolygonalFaceSet);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPolygonalFaceSet);
			if (result == null)
				result = caseIfcLayeredItem(ifcPolygonalFaceSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POLYLINE: {
			IfcPolyline ifcPolyline = (IfcPolyline) theEObject;
			T result = caseIfcPolyline(ifcPolyline);
			if (result == null)
				result = caseIfcBoundedCurve(ifcPolyline);
			if (result == null)
				result = caseIfcCurve(ifcPolyline);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcPolyline);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcPolyline);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcPolyline);
			if (result == null)
				result = caseIfcRepresentationItem(ifcPolyline);
			if (result == null)
				result = caseIfcLayeredItem(ifcPolyline);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PORT: {
			IfcPort ifcPort = (IfcPort) theEObject;
			T result = caseIfcPort(ifcPort);
			if (result == null)
				result = caseIfcProduct(ifcPort);
			if (result == null)
				result = caseIfcObject(ifcPort);
			if (result == null)
				result = caseIfcProductSelect(ifcPort);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPort);
			if (result == null)
				result = caseIfcRoot(ifcPort);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPort);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POSTAL_ADDRESS: {
			IfcPostalAddress ifcPostalAddress = (IfcPostalAddress) theEObject;
			T result = caseIfcPostalAddress(ifcPostalAddress);
			if (result == null)
				result = caseIfcAddress(ifcPostalAddress);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcPostalAddress);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRE_DEFINED_COLOUR: {
			IfcPreDefinedColour ifcPreDefinedColour = (IfcPreDefinedColour) theEObject;
			T result = caseIfcPreDefinedColour(ifcPreDefinedColour);
			if (result == null)
				result = caseIfcPreDefinedItem(ifcPreDefinedColour);
			if (result == null)
				result = caseIfcColour(ifcPreDefinedColour);
			if (result == null)
				result = caseIfcPresentationItem(ifcPreDefinedColour);
			if (result == null)
				result = caseIfcFillStyleSelect(ifcPreDefinedColour);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRE_DEFINED_CURVE_FONT: {
			IfcPreDefinedCurveFont ifcPreDefinedCurveFont = (IfcPreDefinedCurveFont) theEObject;
			T result = caseIfcPreDefinedCurveFont(ifcPreDefinedCurveFont);
			if (result == null)
				result = caseIfcPreDefinedItem(ifcPreDefinedCurveFont);
			if (result == null)
				result = caseIfcCurveStyleFontSelect(ifcPreDefinedCurveFont);
			if (result == null)
				result = caseIfcPresentationItem(ifcPreDefinedCurveFont);
			if (result == null)
				result = caseIfcCurveFontOrScaledCurveFontSelect(ifcPreDefinedCurveFont);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRE_DEFINED_ITEM: {
			IfcPreDefinedItem ifcPreDefinedItem = (IfcPreDefinedItem) theEObject;
			T result = caseIfcPreDefinedItem(ifcPreDefinedItem);
			if (result == null)
				result = caseIfcPresentationItem(ifcPreDefinedItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRE_DEFINED_PROPERTIES: {
			IfcPreDefinedProperties ifcPreDefinedProperties = (IfcPreDefinedProperties) theEObject;
			T result = caseIfcPreDefinedProperties(ifcPreDefinedProperties);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcPreDefinedProperties);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPreDefinedProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRE_DEFINED_PROPERTY_SET: {
			IfcPreDefinedPropertySet ifcPreDefinedPropertySet = (IfcPreDefinedPropertySet) theEObject;
			T result = caseIfcPreDefinedPropertySet(ifcPreDefinedPropertySet);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcPreDefinedPropertySet);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcPreDefinedPropertySet);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcPreDefinedPropertySet);
			if (result == null)
				result = caseIfcRoot(ifcPreDefinedPropertySet);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPreDefinedPropertySet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRE_DEFINED_TEXT_FONT: {
			IfcPreDefinedTextFont ifcPreDefinedTextFont = (IfcPreDefinedTextFont) theEObject;
			T result = caseIfcPreDefinedTextFont(ifcPreDefinedTextFont);
			if (result == null)
				result = caseIfcPreDefinedItem(ifcPreDefinedTextFont);
			if (result == null)
				result = caseIfcTextFontSelect(ifcPreDefinedTextFont);
			if (result == null)
				result = caseIfcPresentationItem(ifcPreDefinedTextFont);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRESENTATION_ITEM: {
			IfcPresentationItem ifcPresentationItem = (IfcPresentationItem) theEObject;
			T result = caseIfcPresentationItem(ifcPresentationItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRESENTATION_LAYER_ASSIGNMENT: {
			IfcPresentationLayerAssignment ifcPresentationLayerAssignment = (IfcPresentationLayerAssignment) theEObject;
			T result = caseIfcPresentationLayerAssignment(ifcPresentationLayerAssignment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRESENTATION_LAYER_WITH_STYLE: {
			IfcPresentationLayerWithStyle ifcPresentationLayerWithStyle = (IfcPresentationLayerWithStyle) theEObject;
			T result = caseIfcPresentationLayerWithStyle(ifcPresentationLayerWithStyle);
			if (result == null)
				result = caseIfcPresentationLayerAssignment(ifcPresentationLayerWithStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRESENTATION_STYLE: {
			IfcPresentationStyle ifcPresentationStyle = (IfcPresentationStyle) theEObject;
			T result = caseIfcPresentationStyle(ifcPresentationStyle);
			if (result == null)
				result = caseIfcStyleAssignmentSelect(ifcPresentationStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRESENTATION_STYLE_ASSIGNMENT: {
			IfcPresentationStyleAssignment ifcPresentationStyleAssignment = (IfcPresentationStyleAssignment) theEObject;
			T result = caseIfcPresentationStyleAssignment(ifcPresentationStyleAssignment);
			if (result == null)
				result = caseIfcStyleAssignmentSelect(ifcPresentationStyleAssignment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROCEDURE: {
			IfcProcedure ifcProcedure = (IfcProcedure) theEObject;
			T result = caseIfcProcedure(ifcProcedure);
			if (result == null)
				result = caseIfcProcess(ifcProcedure);
			if (result == null)
				result = caseIfcObject(ifcProcedure);
			if (result == null)
				result = caseIfcProcessSelect(ifcProcedure);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProcedure);
			if (result == null)
				result = caseIfcRoot(ifcProcedure);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProcedure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROCEDURE_TYPE: {
			IfcProcedureType ifcProcedureType = (IfcProcedureType) theEObject;
			T result = caseIfcProcedureType(ifcProcedureType);
			if (result == null)
				result = caseIfcTypeProcess(ifcProcedureType);
			if (result == null)
				result = caseIfcTypeObject(ifcProcedureType);
			if (result == null)
				result = caseIfcProcessSelect(ifcProcedureType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProcedureType);
			if (result == null)
				result = caseIfcRoot(ifcProcedureType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProcedureType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROCESS: {
			IfcProcess ifcProcess = (IfcProcess) theEObject;
			T result = caseIfcProcess(ifcProcess);
			if (result == null)
				result = caseIfcObject(ifcProcess);
			if (result == null)
				result = caseIfcProcessSelect(ifcProcess);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProcess);
			if (result == null)
				result = caseIfcRoot(ifcProcess);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProcess);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRODUCT: {
			IfcProduct ifcProduct = (IfcProduct) theEObject;
			T result = caseIfcProduct(ifcProduct);
			if (result == null)
				result = caseIfcObject(ifcProduct);
			if (result == null)
				result = caseIfcProductSelect(ifcProduct);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProduct);
			if (result == null)
				result = caseIfcRoot(ifcProduct);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProduct);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRODUCT_DEFINITION_SHAPE: {
			IfcProductDefinitionShape ifcProductDefinitionShape = (IfcProductDefinitionShape) theEObject;
			T result = caseIfcProductDefinitionShape(ifcProductDefinitionShape);
			if (result == null)
				result = caseIfcProductRepresentation(ifcProductDefinitionShape);
			if (result == null)
				result = caseIfcProductRepresentationSelect(ifcProductDefinitionShape);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRODUCT_REPRESENTATION: {
			IfcProductRepresentation ifcProductRepresentation = (IfcProductRepresentation) theEObject;
			T result = caseIfcProductRepresentation(ifcProductRepresentation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROFILE_DEF: {
			IfcProfileDef ifcProfileDef = (IfcProfileDef) theEObject;
			T result = caseIfcProfileDef(ifcProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROFILE_PROPERTIES: {
			IfcProfileProperties ifcProfileProperties = (IfcProfileProperties) theEObject;
			T result = caseIfcProfileProperties(ifcProfileProperties);
			if (result == null)
				result = caseIfcExtendedProperties(ifcProfileProperties);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcProfileProperties);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcProfileProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROJECT: {
			IfcProject ifcProject = (IfcProject) theEObject;
			T result = caseIfcProject(ifcProject);
			if (result == null)
				result = caseIfcContext(ifcProject);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProject);
			if (result == null)
				result = caseIfcRoot(ifcProject);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProject);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROJECT_LIBRARY: {
			IfcProjectLibrary ifcProjectLibrary = (IfcProjectLibrary) theEObject;
			T result = caseIfcProjectLibrary(ifcProjectLibrary);
			if (result == null)
				result = caseIfcContext(ifcProjectLibrary);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProjectLibrary);
			if (result == null)
				result = caseIfcRoot(ifcProjectLibrary);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProjectLibrary);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROJECT_ORDER: {
			IfcProjectOrder ifcProjectOrder = (IfcProjectOrder) theEObject;
			T result = caseIfcProjectOrder(ifcProjectOrder);
			if (result == null)
				result = caseIfcControl(ifcProjectOrder);
			if (result == null)
				result = caseIfcObject(ifcProjectOrder);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProjectOrder);
			if (result == null)
				result = caseIfcRoot(ifcProjectOrder);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProjectOrder);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROJECTED_CRS: {
			IfcProjectedCRS ifcProjectedCRS = (IfcProjectedCRS) theEObject;
			T result = caseIfcProjectedCRS(ifcProjectedCRS);
			if (result == null)
				result = caseIfcCoordinateReferenceSystem(ifcProjectedCRS);
			if (result == null)
				result = caseIfcCoordinateReferenceSystemSelect(ifcProjectedCRS);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROJECTION_ELEMENT: {
			IfcProjectionElement ifcProjectionElement = (IfcProjectionElement) theEObject;
			T result = caseIfcProjectionElement(ifcProjectionElement);
			if (result == null)
				result = caseIfcFeatureElementAddition(ifcProjectionElement);
			if (result == null)
				result = caseIfcFeatureElement(ifcProjectionElement);
			if (result == null)
				result = caseIfcElement(ifcProjectionElement);
			if (result == null)
				result = caseIfcProduct(ifcProjectionElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcProjectionElement);
			if (result == null)
				result = caseIfcObject(ifcProjectionElement);
			if (result == null)
				result = caseIfcProductSelect(ifcProjectionElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProjectionElement);
			if (result == null)
				result = caseIfcRoot(ifcProjectionElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProjectionElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY: {
			IfcProperty ifcProperty = (IfcProperty) theEObject;
			T result = caseIfcProperty(ifcProperty);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcProperty);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcProperty);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_ABSTRACTION: {
			IfcPropertyAbstraction ifcPropertyAbstraction = (IfcPropertyAbstraction) theEObject;
			T result = caseIfcPropertyAbstraction(ifcPropertyAbstraction);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPropertyAbstraction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_BOUNDED_VALUE: {
			IfcPropertyBoundedValue ifcPropertyBoundedValue = (IfcPropertyBoundedValue) theEObject;
			T result = caseIfcPropertyBoundedValue(ifcPropertyBoundedValue);
			if (result == null)
				result = caseIfcSimpleProperty(ifcPropertyBoundedValue);
			if (result == null)
				result = caseIfcProperty(ifcPropertyBoundedValue);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcPropertyBoundedValue);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPropertyBoundedValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_DEFINITION: {
			IfcPropertyDefinition ifcPropertyDefinition = (IfcPropertyDefinition) theEObject;
			T result = caseIfcPropertyDefinition(ifcPropertyDefinition);
			if (result == null)
				result = caseIfcRoot(ifcPropertyDefinition);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPropertyDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_DEPENDENCY_RELATIONSHIP: {
			IfcPropertyDependencyRelationship ifcPropertyDependencyRelationship = (IfcPropertyDependencyRelationship) theEObject;
			T result = caseIfcPropertyDependencyRelationship(ifcPropertyDependencyRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcPropertyDependencyRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_ENUMERATED_VALUE: {
			IfcPropertyEnumeratedValue ifcPropertyEnumeratedValue = (IfcPropertyEnumeratedValue) theEObject;
			T result = caseIfcPropertyEnumeratedValue(ifcPropertyEnumeratedValue);
			if (result == null)
				result = caseIfcSimpleProperty(ifcPropertyEnumeratedValue);
			if (result == null)
				result = caseIfcProperty(ifcPropertyEnumeratedValue);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcPropertyEnumeratedValue);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPropertyEnumeratedValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_ENUMERATION: {
			IfcPropertyEnumeration ifcPropertyEnumeration = (IfcPropertyEnumeration) theEObject;
			T result = caseIfcPropertyEnumeration(ifcPropertyEnumeration);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcPropertyEnumeration);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPropertyEnumeration);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_LIST_VALUE: {
			IfcPropertyListValue ifcPropertyListValue = (IfcPropertyListValue) theEObject;
			T result = caseIfcPropertyListValue(ifcPropertyListValue);
			if (result == null)
				result = caseIfcSimpleProperty(ifcPropertyListValue);
			if (result == null)
				result = caseIfcProperty(ifcPropertyListValue);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcPropertyListValue);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPropertyListValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_REFERENCE_VALUE: {
			IfcPropertyReferenceValue ifcPropertyReferenceValue = (IfcPropertyReferenceValue) theEObject;
			T result = caseIfcPropertyReferenceValue(ifcPropertyReferenceValue);
			if (result == null)
				result = caseIfcSimpleProperty(ifcPropertyReferenceValue);
			if (result == null)
				result = caseIfcProperty(ifcPropertyReferenceValue);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcPropertyReferenceValue);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPropertyReferenceValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_SET: {
			IfcPropertySet ifcPropertySet = (IfcPropertySet) theEObject;
			T result = caseIfcPropertySet(ifcPropertySet);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcPropertySet);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcPropertySet);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcPropertySet);
			if (result == null)
				result = caseIfcRoot(ifcPropertySet);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPropertySet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_SET_DEFINITION: {
			IfcPropertySetDefinition ifcPropertySetDefinition = (IfcPropertySetDefinition) theEObject;
			T result = caseIfcPropertySetDefinition(ifcPropertySetDefinition);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcPropertySetDefinition);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcPropertySetDefinition);
			if (result == null)
				result = caseIfcRoot(ifcPropertySetDefinition);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPropertySetDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_SET_TEMPLATE: {
			IfcPropertySetTemplate ifcPropertySetTemplate = (IfcPropertySetTemplate) theEObject;
			T result = caseIfcPropertySetTemplate(ifcPropertySetTemplate);
			if (result == null)
				result = caseIfcPropertyTemplateDefinition(ifcPropertySetTemplate);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcPropertySetTemplate);
			if (result == null)
				result = caseIfcRoot(ifcPropertySetTemplate);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPropertySetTemplate);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_SINGLE_VALUE: {
			IfcPropertySingleValue ifcPropertySingleValue = (IfcPropertySingleValue) theEObject;
			T result = caseIfcPropertySingleValue(ifcPropertySingleValue);
			if (result == null)
				result = caseIfcSimpleProperty(ifcPropertySingleValue);
			if (result == null)
				result = caseIfcProperty(ifcPropertySingleValue);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcPropertySingleValue);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPropertySingleValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_TABLE_VALUE: {
			IfcPropertyTableValue ifcPropertyTableValue = (IfcPropertyTableValue) theEObject;
			T result = caseIfcPropertyTableValue(ifcPropertyTableValue);
			if (result == null)
				result = caseIfcSimpleProperty(ifcPropertyTableValue);
			if (result == null)
				result = caseIfcProperty(ifcPropertyTableValue);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcPropertyTableValue);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcPropertyTableValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_TEMPLATE: {
			IfcPropertyTemplate ifcPropertyTemplate = (IfcPropertyTemplate) theEObject;
			T result = caseIfcPropertyTemplate(ifcPropertyTemplate);
			if (result == null)
				result = caseIfcPropertyTemplateDefinition(ifcPropertyTemplate);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcPropertyTemplate);
			if (result == null)
				result = caseIfcRoot(ifcPropertyTemplate);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPropertyTemplate);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_TEMPLATE_DEFINITION: {
			IfcPropertyTemplateDefinition ifcPropertyTemplateDefinition = (IfcPropertyTemplateDefinition) theEObject;
			T result = caseIfcPropertyTemplateDefinition(ifcPropertyTemplateDefinition);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcPropertyTemplateDefinition);
			if (result == null)
				result = caseIfcRoot(ifcPropertyTemplateDefinition);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPropertyTemplateDefinition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROTECTIVE_DEVICE: {
			IfcProtectiveDevice ifcProtectiveDevice = (IfcProtectiveDevice) theEObject;
			T result = caseIfcProtectiveDevice(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcFlowController(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcElement(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcProduct(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcObject(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcRoot(ifcProtectiveDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProtectiveDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROTECTIVE_DEVICE_TRIPPING_UNIT: {
			IfcProtectiveDeviceTrippingUnit ifcProtectiveDeviceTrippingUnit = (IfcProtectiveDeviceTrippingUnit) theEObject;
			T result = caseIfcProtectiveDeviceTrippingUnit(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcDistributionControlElement(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcDistributionElement(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcElement(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcProduct(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcObject(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcProductSelect(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcRoot(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProtectiveDeviceTrippingUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROTECTIVE_DEVICE_TRIPPING_UNIT_TYPE: {
			IfcProtectiveDeviceTrippingUnitType ifcProtectiveDeviceTrippingUnitType = (IfcProtectiveDeviceTrippingUnitType) theEObject;
			T result = caseIfcProtectiveDeviceTrippingUnitType(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcDistributionControlElementType(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcElementType(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcTypeProduct(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcTypeObject(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcProductSelect(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcRoot(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProtectiveDeviceTrippingUnitType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROTECTIVE_DEVICE_TYPE: {
			IfcProtectiveDeviceType ifcProtectiveDeviceType = (IfcProtectiveDeviceType) theEObject;
			T result = caseIfcProtectiveDeviceType(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcFlowControllerType(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcProtectiveDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProtectiveDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROXY: {
			IfcProxy ifcProxy = (IfcProxy) theEObject;
			T result = caseIfcProxy(ifcProxy);
			if (result == null)
				result = caseIfcProduct(ifcProxy);
			if (result == null)
				result = caseIfcObject(ifcProxy);
			if (result == null)
				result = caseIfcProductSelect(ifcProxy);
			if (result == null)
				result = caseIfcObjectDefinition(ifcProxy);
			if (result == null)
				result = caseIfcRoot(ifcProxy);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcProxy);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PUMP: {
			IfcPump ifcPump = (IfcPump) theEObject;
			T result = caseIfcPump(ifcPump);
			if (result == null)
				result = caseIfcFlowMovingDevice(ifcPump);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcPump);
			if (result == null)
				result = caseIfcDistributionElement(ifcPump);
			if (result == null)
				result = caseIfcElement(ifcPump);
			if (result == null)
				result = caseIfcProduct(ifcPump);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcPump);
			if (result == null)
				result = caseIfcObject(ifcPump);
			if (result == null)
				result = caseIfcProductSelect(ifcPump);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPump);
			if (result == null)
				result = caseIfcRoot(ifcPump);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPump);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PUMP_TYPE: {
			IfcPumpType ifcPumpType = (IfcPumpType) theEObject;
			T result = caseIfcPumpType(ifcPumpType);
			if (result == null)
				result = caseIfcFlowMovingDeviceType(ifcPumpType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcPumpType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcPumpType);
			if (result == null)
				result = caseIfcElementType(ifcPumpType);
			if (result == null)
				result = caseIfcTypeProduct(ifcPumpType);
			if (result == null)
				result = caseIfcTypeObject(ifcPumpType);
			if (result == null)
				result = caseIfcProductSelect(ifcPumpType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcPumpType);
			if (result == null)
				result = caseIfcRoot(ifcPumpType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcPumpType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_QUANTITY_AREA: {
			IfcQuantityArea ifcQuantityArea = (IfcQuantityArea) theEObject;
			T result = caseIfcQuantityArea(ifcQuantityArea);
			if (result == null)
				result = caseIfcPhysicalSimpleQuantity(ifcQuantityArea);
			if (result == null)
				result = caseIfcPhysicalQuantity(ifcQuantityArea);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcQuantityArea);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_QUANTITY_COUNT: {
			IfcQuantityCount ifcQuantityCount = (IfcQuantityCount) theEObject;
			T result = caseIfcQuantityCount(ifcQuantityCount);
			if (result == null)
				result = caseIfcPhysicalSimpleQuantity(ifcQuantityCount);
			if (result == null)
				result = caseIfcPhysicalQuantity(ifcQuantityCount);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcQuantityCount);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_QUANTITY_LENGTH: {
			IfcQuantityLength ifcQuantityLength = (IfcQuantityLength) theEObject;
			T result = caseIfcQuantityLength(ifcQuantityLength);
			if (result == null)
				result = caseIfcPhysicalSimpleQuantity(ifcQuantityLength);
			if (result == null)
				result = caseIfcPhysicalQuantity(ifcQuantityLength);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcQuantityLength);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_QUANTITY_SET: {
			IfcQuantitySet ifcQuantitySet = (IfcQuantitySet) theEObject;
			T result = caseIfcQuantitySet(ifcQuantitySet);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcQuantitySet);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcQuantitySet);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcQuantitySet);
			if (result == null)
				result = caseIfcRoot(ifcQuantitySet);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcQuantitySet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_QUANTITY_TIME: {
			IfcQuantityTime ifcQuantityTime = (IfcQuantityTime) theEObject;
			T result = caseIfcQuantityTime(ifcQuantityTime);
			if (result == null)
				result = caseIfcPhysicalSimpleQuantity(ifcQuantityTime);
			if (result == null)
				result = caseIfcPhysicalQuantity(ifcQuantityTime);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcQuantityTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_QUANTITY_VOLUME: {
			IfcQuantityVolume ifcQuantityVolume = (IfcQuantityVolume) theEObject;
			T result = caseIfcQuantityVolume(ifcQuantityVolume);
			if (result == null)
				result = caseIfcPhysicalSimpleQuantity(ifcQuantityVolume);
			if (result == null)
				result = caseIfcPhysicalQuantity(ifcQuantityVolume);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcQuantityVolume);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_QUANTITY_WEIGHT: {
			IfcQuantityWeight ifcQuantityWeight = (IfcQuantityWeight) theEObject;
			T result = caseIfcQuantityWeight(ifcQuantityWeight);
			if (result == null)
				result = caseIfcPhysicalSimpleQuantity(ifcQuantityWeight);
			if (result == null)
				result = caseIfcPhysicalQuantity(ifcQuantityWeight);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcQuantityWeight);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RAILING: {
			IfcRailing ifcRailing = (IfcRailing) theEObject;
			T result = caseIfcRailing(ifcRailing);
			if (result == null)
				result = caseIfcBuildingElement(ifcRailing);
			if (result == null)
				result = caseIfcElement(ifcRailing);
			if (result == null)
				result = caseIfcProduct(ifcRailing);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcRailing);
			if (result == null)
				result = caseIfcObject(ifcRailing);
			if (result == null)
				result = caseIfcProductSelect(ifcRailing);
			if (result == null)
				result = caseIfcObjectDefinition(ifcRailing);
			if (result == null)
				result = caseIfcRoot(ifcRailing);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcRailing);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RAILING_TYPE: {
			IfcRailingType ifcRailingType = (IfcRailingType) theEObject;
			T result = caseIfcRailingType(ifcRailingType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcRailingType);
			if (result == null)
				result = caseIfcElementType(ifcRailingType);
			if (result == null)
				result = caseIfcTypeProduct(ifcRailingType);
			if (result == null)
				result = caseIfcTypeObject(ifcRailingType);
			if (result == null)
				result = caseIfcProductSelect(ifcRailingType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcRailingType);
			if (result == null)
				result = caseIfcRoot(ifcRailingType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcRailingType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RAMP: {
			IfcRamp ifcRamp = (IfcRamp) theEObject;
			T result = caseIfcRamp(ifcRamp);
			if (result == null)
				result = caseIfcBuildingElement(ifcRamp);
			if (result == null)
				result = caseIfcElement(ifcRamp);
			if (result == null)
				result = caseIfcProduct(ifcRamp);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcRamp);
			if (result == null)
				result = caseIfcObject(ifcRamp);
			if (result == null)
				result = caseIfcProductSelect(ifcRamp);
			if (result == null)
				result = caseIfcObjectDefinition(ifcRamp);
			if (result == null)
				result = caseIfcRoot(ifcRamp);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcRamp);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RAMP_FLIGHT: {
			IfcRampFlight ifcRampFlight = (IfcRampFlight) theEObject;
			T result = caseIfcRampFlight(ifcRampFlight);
			if (result == null)
				result = caseIfcBuildingElement(ifcRampFlight);
			if (result == null)
				result = caseIfcElement(ifcRampFlight);
			if (result == null)
				result = caseIfcProduct(ifcRampFlight);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcRampFlight);
			if (result == null)
				result = caseIfcObject(ifcRampFlight);
			if (result == null)
				result = caseIfcProductSelect(ifcRampFlight);
			if (result == null)
				result = caseIfcObjectDefinition(ifcRampFlight);
			if (result == null)
				result = caseIfcRoot(ifcRampFlight);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcRampFlight);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RAMP_FLIGHT_TYPE: {
			IfcRampFlightType ifcRampFlightType = (IfcRampFlightType) theEObject;
			T result = caseIfcRampFlightType(ifcRampFlightType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcRampFlightType);
			if (result == null)
				result = caseIfcElementType(ifcRampFlightType);
			if (result == null)
				result = caseIfcTypeProduct(ifcRampFlightType);
			if (result == null)
				result = caseIfcTypeObject(ifcRampFlightType);
			if (result == null)
				result = caseIfcProductSelect(ifcRampFlightType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcRampFlightType);
			if (result == null)
				result = caseIfcRoot(ifcRampFlightType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcRampFlightType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RAMP_TYPE: {
			IfcRampType ifcRampType = (IfcRampType) theEObject;
			T result = caseIfcRampType(ifcRampType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcRampType);
			if (result == null)
				result = caseIfcElementType(ifcRampType);
			if (result == null)
				result = caseIfcTypeProduct(ifcRampType);
			if (result == null)
				result = caseIfcTypeObject(ifcRampType);
			if (result == null)
				result = caseIfcProductSelect(ifcRampType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcRampType);
			if (result == null)
				result = caseIfcRoot(ifcRampType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcRampType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RATIONAL_BSPLINE_CURVE_WITH_KNOTS: {
			IfcRationalBSplineCurveWithKnots ifcRationalBSplineCurveWithKnots = (IfcRationalBSplineCurveWithKnots) theEObject;
			T result = caseIfcRationalBSplineCurveWithKnots(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcBSplineCurveWithKnots(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcBSplineCurve(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcBoundedCurve(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcCurve(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcRepresentationItem(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = caseIfcLayeredItem(ifcRationalBSplineCurveWithKnots);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RATIONAL_BSPLINE_SURFACE_WITH_KNOTS: {
			IfcRationalBSplineSurfaceWithKnots ifcRationalBSplineSurfaceWithKnots = (IfcRationalBSplineSurfaceWithKnots) theEObject;
			T result = caseIfcRationalBSplineSurfaceWithKnots(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcBSplineSurfaceWithKnots(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcBSplineSurface(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcBoundedSurface(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcSurface(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcRepresentationItem(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = caseIfcLayeredItem(ifcRationalBSplineSurfaceWithKnots);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RECTANGLE_HOLLOW_PROFILE_DEF: {
			IfcRectangleHollowProfileDef ifcRectangleHollowProfileDef = (IfcRectangleHollowProfileDef) theEObject;
			T result = caseIfcRectangleHollowProfileDef(ifcRectangleHollowProfileDef);
			if (result == null)
				result = caseIfcRectangleProfileDef(ifcRectangleHollowProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcRectangleHollowProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcRectangleHollowProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcRectangleHollowProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RECTANGLE_PROFILE_DEF: {
			IfcRectangleProfileDef ifcRectangleProfileDef = (IfcRectangleProfileDef) theEObject;
			T result = caseIfcRectangleProfileDef(ifcRectangleProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcRectangleProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcRectangleProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcRectangleProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RECTANGULAR_PYRAMID: {
			IfcRectangularPyramid ifcRectangularPyramid = (IfcRectangularPyramid) theEObject;
			T result = caseIfcRectangularPyramid(ifcRectangularPyramid);
			if (result == null)
				result = caseIfcCsgPrimitive3D(ifcRectangularPyramid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcRectangularPyramid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcRectangularPyramid);
			if (result == null)
				result = caseIfcCsgSelect(ifcRectangularPyramid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcRectangularPyramid);
			if (result == null)
				result = caseIfcLayeredItem(ifcRectangularPyramid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RECTANGULAR_TRIMMED_SURFACE: {
			IfcRectangularTrimmedSurface ifcRectangularTrimmedSurface = (IfcRectangularTrimmedSurface) theEObject;
			T result = caseIfcRectangularTrimmedSurface(ifcRectangularTrimmedSurface);
			if (result == null)
				result = caseIfcBoundedSurface(ifcRectangularTrimmedSurface);
			if (result == null)
				result = caseIfcSurface(ifcRectangularTrimmedSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcRectangularTrimmedSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcRectangularTrimmedSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcRectangularTrimmedSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcRectangularTrimmedSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcRectangularTrimmedSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RECURRENCE_PATTERN: {
			IfcRecurrencePattern ifcRecurrencePattern = (IfcRecurrencePattern) theEObject;
			T result = caseIfcRecurrencePattern(ifcRecurrencePattern);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REFERENCE: {
			IfcReference ifcReference = (IfcReference) theEObject;
			T result = caseIfcReference(ifcReference);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcReference);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcReference);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REGULAR_TIME_SERIES: {
			IfcRegularTimeSeries ifcRegularTimeSeries = (IfcRegularTimeSeries) theEObject;
			T result = caseIfcRegularTimeSeries(ifcRegularTimeSeries);
			if (result == null)
				result = caseIfcTimeSeries(ifcRegularTimeSeries);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcRegularTimeSeries);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcRegularTimeSeries);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcRegularTimeSeries);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REINFORCEMENT_BAR_PROPERTIES: {
			IfcReinforcementBarProperties ifcReinforcementBarProperties = (IfcReinforcementBarProperties) theEObject;
			T result = caseIfcReinforcementBarProperties(ifcReinforcementBarProperties);
			if (result == null)
				result = caseIfcPreDefinedProperties(ifcReinforcementBarProperties);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcReinforcementBarProperties);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcReinforcementBarProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REINFORCEMENT_DEFINITION_PROPERTIES: {
			IfcReinforcementDefinitionProperties ifcReinforcementDefinitionProperties = (IfcReinforcementDefinitionProperties) theEObject;
			T result = caseIfcReinforcementDefinitionProperties(ifcReinforcementDefinitionProperties);
			if (result == null)
				result = caseIfcPreDefinedPropertySet(ifcReinforcementDefinitionProperties);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcReinforcementDefinitionProperties);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcReinforcementDefinitionProperties);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcReinforcementDefinitionProperties);
			if (result == null)
				result = caseIfcRoot(ifcReinforcementDefinitionProperties);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcReinforcementDefinitionProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REINFORCING_BAR: {
			IfcReinforcingBar ifcReinforcingBar = (IfcReinforcingBar) theEObject;
			T result = caseIfcReinforcingBar(ifcReinforcingBar);
			if (result == null)
				result = caseIfcReinforcingElement(ifcReinforcingBar);
			if (result == null)
				result = caseIfcElementComponent(ifcReinforcingBar);
			if (result == null)
				result = caseIfcElement(ifcReinforcingBar);
			if (result == null)
				result = caseIfcProduct(ifcReinforcingBar);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcReinforcingBar);
			if (result == null)
				result = caseIfcObject(ifcReinforcingBar);
			if (result == null)
				result = caseIfcProductSelect(ifcReinforcingBar);
			if (result == null)
				result = caseIfcObjectDefinition(ifcReinforcingBar);
			if (result == null)
				result = caseIfcRoot(ifcReinforcingBar);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcReinforcingBar);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REINFORCING_BAR_TYPE: {
			IfcReinforcingBarType ifcReinforcingBarType = (IfcReinforcingBarType) theEObject;
			T result = caseIfcReinforcingBarType(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcReinforcingElementType(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcElementComponentType(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcElementType(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcTypeProduct(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcTypeObject(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcProductSelect(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcRoot(ifcReinforcingBarType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcReinforcingBarType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REINFORCING_ELEMENT: {
			IfcReinforcingElement ifcReinforcingElement = (IfcReinforcingElement) theEObject;
			T result = caseIfcReinforcingElement(ifcReinforcingElement);
			if (result == null)
				result = caseIfcElementComponent(ifcReinforcingElement);
			if (result == null)
				result = caseIfcElement(ifcReinforcingElement);
			if (result == null)
				result = caseIfcProduct(ifcReinforcingElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcReinforcingElement);
			if (result == null)
				result = caseIfcObject(ifcReinforcingElement);
			if (result == null)
				result = caseIfcProductSelect(ifcReinforcingElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcReinforcingElement);
			if (result == null)
				result = caseIfcRoot(ifcReinforcingElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcReinforcingElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REINFORCING_ELEMENT_TYPE: {
			IfcReinforcingElementType ifcReinforcingElementType = (IfcReinforcingElementType) theEObject;
			T result = caseIfcReinforcingElementType(ifcReinforcingElementType);
			if (result == null)
				result = caseIfcElementComponentType(ifcReinforcingElementType);
			if (result == null)
				result = caseIfcElementType(ifcReinforcingElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcReinforcingElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcReinforcingElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcReinforcingElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcReinforcingElementType);
			if (result == null)
				result = caseIfcRoot(ifcReinforcingElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcReinforcingElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REINFORCING_MESH: {
			IfcReinforcingMesh ifcReinforcingMesh = (IfcReinforcingMesh) theEObject;
			T result = caseIfcReinforcingMesh(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcReinforcingElement(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcElementComponent(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcElement(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcProduct(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcObject(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcProductSelect(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcObjectDefinition(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcRoot(ifcReinforcingMesh);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcReinforcingMesh);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REINFORCING_MESH_TYPE: {
			IfcReinforcingMeshType ifcReinforcingMeshType = (IfcReinforcingMeshType) theEObject;
			T result = caseIfcReinforcingMeshType(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcReinforcingElementType(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcElementComponentType(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcElementType(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcTypeProduct(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcTypeObject(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcProductSelect(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcRoot(ifcReinforcingMeshType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcReinforcingMeshType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_AGGREGATES: {
			IfcRelAggregates ifcRelAggregates = (IfcRelAggregates) theEObject;
			T result = caseIfcRelAggregates(ifcRelAggregates);
			if (result == null)
				result = caseIfcRelDecomposes(ifcRelAggregates);
			if (result == null)
				result = caseIfcRelationship(ifcRelAggregates);
			if (result == null)
				result = caseIfcRoot(ifcRelAggregates);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSIGNS: {
			IfcRelAssigns ifcRelAssigns = (IfcRelAssigns) theEObject;
			T result = caseIfcRelAssigns(ifcRelAssigns);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssigns);
			if (result == null)
				result = caseIfcRoot(ifcRelAssigns);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSIGNS_TO_ACTOR: {
			IfcRelAssignsToActor ifcRelAssignsToActor = (IfcRelAssignsToActor) theEObject;
			T result = caseIfcRelAssignsToActor(ifcRelAssignsToActor);
			if (result == null)
				result = caseIfcRelAssigns(ifcRelAssignsToActor);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssignsToActor);
			if (result == null)
				result = caseIfcRoot(ifcRelAssignsToActor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSIGNS_TO_CONTROL: {
			IfcRelAssignsToControl ifcRelAssignsToControl = (IfcRelAssignsToControl) theEObject;
			T result = caseIfcRelAssignsToControl(ifcRelAssignsToControl);
			if (result == null)
				result = caseIfcRelAssigns(ifcRelAssignsToControl);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssignsToControl);
			if (result == null)
				result = caseIfcRoot(ifcRelAssignsToControl);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSIGNS_TO_GROUP: {
			IfcRelAssignsToGroup ifcRelAssignsToGroup = (IfcRelAssignsToGroup) theEObject;
			T result = caseIfcRelAssignsToGroup(ifcRelAssignsToGroup);
			if (result == null)
				result = caseIfcRelAssigns(ifcRelAssignsToGroup);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssignsToGroup);
			if (result == null)
				result = caseIfcRoot(ifcRelAssignsToGroup);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSIGNS_TO_GROUP_BY_FACTOR: {
			IfcRelAssignsToGroupByFactor ifcRelAssignsToGroupByFactor = (IfcRelAssignsToGroupByFactor) theEObject;
			T result = caseIfcRelAssignsToGroupByFactor(ifcRelAssignsToGroupByFactor);
			if (result == null)
				result = caseIfcRelAssignsToGroup(ifcRelAssignsToGroupByFactor);
			if (result == null)
				result = caseIfcRelAssigns(ifcRelAssignsToGroupByFactor);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssignsToGroupByFactor);
			if (result == null)
				result = caseIfcRoot(ifcRelAssignsToGroupByFactor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSIGNS_TO_PROCESS: {
			IfcRelAssignsToProcess ifcRelAssignsToProcess = (IfcRelAssignsToProcess) theEObject;
			T result = caseIfcRelAssignsToProcess(ifcRelAssignsToProcess);
			if (result == null)
				result = caseIfcRelAssigns(ifcRelAssignsToProcess);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssignsToProcess);
			if (result == null)
				result = caseIfcRoot(ifcRelAssignsToProcess);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSIGNS_TO_PRODUCT: {
			IfcRelAssignsToProduct ifcRelAssignsToProduct = (IfcRelAssignsToProduct) theEObject;
			T result = caseIfcRelAssignsToProduct(ifcRelAssignsToProduct);
			if (result == null)
				result = caseIfcRelAssigns(ifcRelAssignsToProduct);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssignsToProduct);
			if (result == null)
				result = caseIfcRoot(ifcRelAssignsToProduct);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSIGNS_TO_RESOURCE: {
			IfcRelAssignsToResource ifcRelAssignsToResource = (IfcRelAssignsToResource) theEObject;
			T result = caseIfcRelAssignsToResource(ifcRelAssignsToResource);
			if (result == null)
				result = caseIfcRelAssigns(ifcRelAssignsToResource);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssignsToResource);
			if (result == null)
				result = caseIfcRoot(ifcRelAssignsToResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSOCIATES: {
			IfcRelAssociates ifcRelAssociates = (IfcRelAssociates) theEObject;
			T result = caseIfcRelAssociates(ifcRelAssociates);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssociates);
			if (result == null)
				result = caseIfcRoot(ifcRelAssociates);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSOCIATES_APPROVAL: {
			IfcRelAssociatesApproval ifcRelAssociatesApproval = (IfcRelAssociatesApproval) theEObject;
			T result = caseIfcRelAssociatesApproval(ifcRelAssociatesApproval);
			if (result == null)
				result = caseIfcRelAssociates(ifcRelAssociatesApproval);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssociatesApproval);
			if (result == null)
				result = caseIfcRoot(ifcRelAssociatesApproval);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSOCIATES_CLASSIFICATION: {
			IfcRelAssociatesClassification ifcRelAssociatesClassification = (IfcRelAssociatesClassification) theEObject;
			T result = caseIfcRelAssociatesClassification(ifcRelAssociatesClassification);
			if (result == null)
				result = caseIfcRelAssociates(ifcRelAssociatesClassification);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssociatesClassification);
			if (result == null)
				result = caseIfcRoot(ifcRelAssociatesClassification);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSOCIATES_CONSTRAINT: {
			IfcRelAssociatesConstraint ifcRelAssociatesConstraint = (IfcRelAssociatesConstraint) theEObject;
			T result = caseIfcRelAssociatesConstraint(ifcRelAssociatesConstraint);
			if (result == null)
				result = caseIfcRelAssociates(ifcRelAssociatesConstraint);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssociatesConstraint);
			if (result == null)
				result = caseIfcRoot(ifcRelAssociatesConstraint);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSOCIATES_DOCUMENT: {
			IfcRelAssociatesDocument ifcRelAssociatesDocument = (IfcRelAssociatesDocument) theEObject;
			T result = caseIfcRelAssociatesDocument(ifcRelAssociatesDocument);
			if (result == null)
				result = caseIfcRelAssociates(ifcRelAssociatesDocument);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssociatesDocument);
			if (result == null)
				result = caseIfcRoot(ifcRelAssociatesDocument);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSOCIATES_LIBRARY: {
			IfcRelAssociatesLibrary ifcRelAssociatesLibrary = (IfcRelAssociatesLibrary) theEObject;
			T result = caseIfcRelAssociatesLibrary(ifcRelAssociatesLibrary);
			if (result == null)
				result = caseIfcRelAssociates(ifcRelAssociatesLibrary);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssociatesLibrary);
			if (result == null)
				result = caseIfcRoot(ifcRelAssociatesLibrary);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_ASSOCIATES_MATERIAL: {
			IfcRelAssociatesMaterial ifcRelAssociatesMaterial = (IfcRelAssociatesMaterial) theEObject;
			T result = caseIfcRelAssociatesMaterial(ifcRelAssociatesMaterial);
			if (result == null)
				result = caseIfcRelAssociates(ifcRelAssociatesMaterial);
			if (result == null)
				result = caseIfcRelationship(ifcRelAssociatesMaterial);
			if (result == null)
				result = caseIfcRoot(ifcRelAssociatesMaterial);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS: {
			IfcRelConnects ifcRelConnects = (IfcRelConnects) theEObject;
			T result = caseIfcRelConnects(ifcRelConnects);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnects);
			if (result == null)
				result = caseIfcRoot(ifcRelConnects);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS_ELEMENTS: {
			IfcRelConnectsElements ifcRelConnectsElements = (IfcRelConnectsElements) theEObject;
			T result = caseIfcRelConnectsElements(ifcRelConnectsElements);
			if (result == null)
				result = caseIfcRelConnects(ifcRelConnectsElements);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnectsElements);
			if (result == null)
				result = caseIfcRoot(ifcRelConnectsElements);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS_PATH_ELEMENTS: {
			IfcRelConnectsPathElements ifcRelConnectsPathElements = (IfcRelConnectsPathElements) theEObject;
			T result = caseIfcRelConnectsPathElements(ifcRelConnectsPathElements);
			if (result == null)
				result = caseIfcRelConnectsElements(ifcRelConnectsPathElements);
			if (result == null)
				result = caseIfcRelConnects(ifcRelConnectsPathElements);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnectsPathElements);
			if (result == null)
				result = caseIfcRoot(ifcRelConnectsPathElements);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS_PORT_TO_ELEMENT: {
			IfcRelConnectsPortToElement ifcRelConnectsPortToElement = (IfcRelConnectsPortToElement) theEObject;
			T result = caseIfcRelConnectsPortToElement(ifcRelConnectsPortToElement);
			if (result == null)
				result = caseIfcRelConnects(ifcRelConnectsPortToElement);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnectsPortToElement);
			if (result == null)
				result = caseIfcRoot(ifcRelConnectsPortToElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS_PORTS: {
			IfcRelConnectsPorts ifcRelConnectsPorts = (IfcRelConnectsPorts) theEObject;
			T result = caseIfcRelConnectsPorts(ifcRelConnectsPorts);
			if (result == null)
				result = caseIfcRelConnects(ifcRelConnectsPorts);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnectsPorts);
			if (result == null)
				result = caseIfcRoot(ifcRelConnectsPorts);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS_STRUCTURAL_ACTIVITY: {
			IfcRelConnectsStructuralActivity ifcRelConnectsStructuralActivity = (IfcRelConnectsStructuralActivity) theEObject;
			T result = caseIfcRelConnectsStructuralActivity(ifcRelConnectsStructuralActivity);
			if (result == null)
				result = caseIfcRelConnects(ifcRelConnectsStructuralActivity);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnectsStructuralActivity);
			if (result == null)
				result = caseIfcRoot(ifcRelConnectsStructuralActivity);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS_STRUCTURAL_MEMBER: {
			IfcRelConnectsStructuralMember ifcRelConnectsStructuralMember = (IfcRelConnectsStructuralMember) theEObject;
			T result = caseIfcRelConnectsStructuralMember(ifcRelConnectsStructuralMember);
			if (result == null)
				result = caseIfcRelConnects(ifcRelConnectsStructuralMember);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnectsStructuralMember);
			if (result == null)
				result = caseIfcRoot(ifcRelConnectsStructuralMember);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS_WITH_ECCENTRICITY: {
			IfcRelConnectsWithEccentricity ifcRelConnectsWithEccentricity = (IfcRelConnectsWithEccentricity) theEObject;
			T result = caseIfcRelConnectsWithEccentricity(ifcRelConnectsWithEccentricity);
			if (result == null)
				result = caseIfcRelConnectsStructuralMember(ifcRelConnectsWithEccentricity);
			if (result == null)
				result = caseIfcRelConnects(ifcRelConnectsWithEccentricity);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnectsWithEccentricity);
			if (result == null)
				result = caseIfcRoot(ifcRelConnectsWithEccentricity);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONNECTS_WITH_REALIZING_ELEMENTS: {
			IfcRelConnectsWithRealizingElements ifcRelConnectsWithRealizingElements = (IfcRelConnectsWithRealizingElements) theEObject;
			T result = caseIfcRelConnectsWithRealizingElements(ifcRelConnectsWithRealizingElements);
			if (result == null)
				result = caseIfcRelConnectsElements(ifcRelConnectsWithRealizingElements);
			if (result == null)
				result = caseIfcRelConnects(ifcRelConnectsWithRealizingElements);
			if (result == null)
				result = caseIfcRelationship(ifcRelConnectsWithRealizingElements);
			if (result == null)
				result = caseIfcRoot(ifcRelConnectsWithRealizingElements);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_CONTAINED_IN_SPATIAL_STRUCTURE: {
			IfcRelContainedInSpatialStructure ifcRelContainedInSpatialStructure = (IfcRelContainedInSpatialStructure) theEObject;
			T result = caseIfcRelContainedInSpatialStructure(ifcRelContainedInSpatialStructure);
			if (result == null)
				result = caseIfcRelConnects(ifcRelContainedInSpatialStructure);
			if (result == null)
				result = caseIfcRelationship(ifcRelContainedInSpatialStructure);
			if (result == null)
				result = caseIfcRoot(ifcRelContainedInSpatialStructure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_COVERS_BLDG_ELEMENTS: {
			IfcRelCoversBldgElements ifcRelCoversBldgElements = (IfcRelCoversBldgElements) theEObject;
			T result = caseIfcRelCoversBldgElements(ifcRelCoversBldgElements);
			if (result == null)
				result = caseIfcRelConnects(ifcRelCoversBldgElements);
			if (result == null)
				result = caseIfcRelationship(ifcRelCoversBldgElements);
			if (result == null)
				result = caseIfcRoot(ifcRelCoversBldgElements);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_COVERS_SPACES: {
			IfcRelCoversSpaces ifcRelCoversSpaces = (IfcRelCoversSpaces) theEObject;
			T result = caseIfcRelCoversSpaces(ifcRelCoversSpaces);
			if (result == null)
				result = caseIfcRelConnects(ifcRelCoversSpaces);
			if (result == null)
				result = caseIfcRelationship(ifcRelCoversSpaces);
			if (result == null)
				result = caseIfcRoot(ifcRelCoversSpaces);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_DECLARES: {
			IfcRelDeclares ifcRelDeclares = (IfcRelDeclares) theEObject;
			T result = caseIfcRelDeclares(ifcRelDeclares);
			if (result == null)
				result = caseIfcRelationship(ifcRelDeclares);
			if (result == null)
				result = caseIfcRoot(ifcRelDeclares);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_DECOMPOSES: {
			IfcRelDecomposes ifcRelDecomposes = (IfcRelDecomposes) theEObject;
			T result = caseIfcRelDecomposes(ifcRelDecomposes);
			if (result == null)
				result = caseIfcRelationship(ifcRelDecomposes);
			if (result == null)
				result = caseIfcRoot(ifcRelDecomposes);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_DEFINES: {
			IfcRelDefines ifcRelDefines = (IfcRelDefines) theEObject;
			T result = caseIfcRelDefines(ifcRelDefines);
			if (result == null)
				result = caseIfcRelationship(ifcRelDefines);
			if (result == null)
				result = caseIfcRoot(ifcRelDefines);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_DEFINES_BY_OBJECT: {
			IfcRelDefinesByObject ifcRelDefinesByObject = (IfcRelDefinesByObject) theEObject;
			T result = caseIfcRelDefinesByObject(ifcRelDefinesByObject);
			if (result == null)
				result = caseIfcRelDefines(ifcRelDefinesByObject);
			if (result == null)
				result = caseIfcRelationship(ifcRelDefinesByObject);
			if (result == null)
				result = caseIfcRoot(ifcRelDefinesByObject);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_DEFINES_BY_PROPERTIES: {
			IfcRelDefinesByProperties ifcRelDefinesByProperties = (IfcRelDefinesByProperties) theEObject;
			T result = caseIfcRelDefinesByProperties(ifcRelDefinesByProperties);
			if (result == null)
				result = caseIfcRelDefines(ifcRelDefinesByProperties);
			if (result == null)
				result = caseIfcRelationship(ifcRelDefinesByProperties);
			if (result == null)
				result = caseIfcRoot(ifcRelDefinesByProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_DEFINES_BY_TEMPLATE: {
			IfcRelDefinesByTemplate ifcRelDefinesByTemplate = (IfcRelDefinesByTemplate) theEObject;
			T result = caseIfcRelDefinesByTemplate(ifcRelDefinesByTemplate);
			if (result == null)
				result = caseIfcRelDefines(ifcRelDefinesByTemplate);
			if (result == null)
				result = caseIfcRelationship(ifcRelDefinesByTemplate);
			if (result == null)
				result = caseIfcRoot(ifcRelDefinesByTemplate);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_DEFINES_BY_TYPE: {
			IfcRelDefinesByType ifcRelDefinesByType = (IfcRelDefinesByType) theEObject;
			T result = caseIfcRelDefinesByType(ifcRelDefinesByType);
			if (result == null)
				result = caseIfcRelDefines(ifcRelDefinesByType);
			if (result == null)
				result = caseIfcRelationship(ifcRelDefinesByType);
			if (result == null)
				result = caseIfcRoot(ifcRelDefinesByType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_FILLS_ELEMENT: {
			IfcRelFillsElement ifcRelFillsElement = (IfcRelFillsElement) theEObject;
			T result = caseIfcRelFillsElement(ifcRelFillsElement);
			if (result == null)
				result = caseIfcRelConnects(ifcRelFillsElement);
			if (result == null)
				result = caseIfcRelationship(ifcRelFillsElement);
			if (result == null)
				result = caseIfcRoot(ifcRelFillsElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_FLOW_CONTROL_ELEMENTS: {
			IfcRelFlowControlElements ifcRelFlowControlElements = (IfcRelFlowControlElements) theEObject;
			T result = caseIfcRelFlowControlElements(ifcRelFlowControlElements);
			if (result == null)
				result = caseIfcRelConnects(ifcRelFlowControlElements);
			if (result == null)
				result = caseIfcRelationship(ifcRelFlowControlElements);
			if (result == null)
				result = caseIfcRoot(ifcRelFlowControlElements);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_INTERFERES_ELEMENTS: {
			IfcRelInterferesElements ifcRelInterferesElements = (IfcRelInterferesElements) theEObject;
			T result = caseIfcRelInterferesElements(ifcRelInterferesElements);
			if (result == null)
				result = caseIfcRelConnects(ifcRelInterferesElements);
			if (result == null)
				result = caseIfcRelationship(ifcRelInterferesElements);
			if (result == null)
				result = caseIfcRoot(ifcRelInterferesElements);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_NESTS: {
			IfcRelNests ifcRelNests = (IfcRelNests) theEObject;
			T result = caseIfcRelNests(ifcRelNests);
			if (result == null)
				result = caseIfcRelDecomposes(ifcRelNests);
			if (result == null)
				result = caseIfcRelationship(ifcRelNests);
			if (result == null)
				result = caseIfcRoot(ifcRelNests);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_PROJECTS_ELEMENT: {
			IfcRelProjectsElement ifcRelProjectsElement = (IfcRelProjectsElement) theEObject;
			T result = caseIfcRelProjectsElement(ifcRelProjectsElement);
			if (result == null)
				result = caseIfcRelDecomposes(ifcRelProjectsElement);
			if (result == null)
				result = caseIfcRelationship(ifcRelProjectsElement);
			if (result == null)
				result = caseIfcRoot(ifcRelProjectsElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_REFERENCED_IN_SPATIAL_STRUCTURE: {
			IfcRelReferencedInSpatialStructure ifcRelReferencedInSpatialStructure = (IfcRelReferencedInSpatialStructure) theEObject;
			T result = caseIfcRelReferencedInSpatialStructure(ifcRelReferencedInSpatialStructure);
			if (result == null)
				result = caseIfcRelConnects(ifcRelReferencedInSpatialStructure);
			if (result == null)
				result = caseIfcRelationship(ifcRelReferencedInSpatialStructure);
			if (result == null)
				result = caseIfcRoot(ifcRelReferencedInSpatialStructure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_SEQUENCE: {
			IfcRelSequence ifcRelSequence = (IfcRelSequence) theEObject;
			T result = caseIfcRelSequence(ifcRelSequence);
			if (result == null)
				result = caseIfcRelConnects(ifcRelSequence);
			if (result == null)
				result = caseIfcRelationship(ifcRelSequence);
			if (result == null)
				result = caseIfcRoot(ifcRelSequence);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_SERVICES_BUILDINGS: {
			IfcRelServicesBuildings ifcRelServicesBuildings = (IfcRelServicesBuildings) theEObject;
			T result = caseIfcRelServicesBuildings(ifcRelServicesBuildings);
			if (result == null)
				result = caseIfcRelConnects(ifcRelServicesBuildings);
			if (result == null)
				result = caseIfcRelationship(ifcRelServicesBuildings);
			if (result == null)
				result = caseIfcRoot(ifcRelServicesBuildings);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_SPACE_BOUNDARY: {
			IfcRelSpaceBoundary ifcRelSpaceBoundary = (IfcRelSpaceBoundary) theEObject;
			T result = caseIfcRelSpaceBoundary(ifcRelSpaceBoundary);
			if (result == null)
				result = caseIfcRelConnects(ifcRelSpaceBoundary);
			if (result == null)
				result = caseIfcRelationship(ifcRelSpaceBoundary);
			if (result == null)
				result = caseIfcRoot(ifcRelSpaceBoundary);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_SPACE_BOUNDARY1ST_LEVEL: {
			IfcRelSpaceBoundary1stLevel ifcRelSpaceBoundary1stLevel = (IfcRelSpaceBoundary1stLevel) theEObject;
			T result = caseIfcRelSpaceBoundary1stLevel(ifcRelSpaceBoundary1stLevel);
			if (result == null)
				result = caseIfcRelSpaceBoundary(ifcRelSpaceBoundary1stLevel);
			if (result == null)
				result = caseIfcRelConnects(ifcRelSpaceBoundary1stLevel);
			if (result == null)
				result = caseIfcRelationship(ifcRelSpaceBoundary1stLevel);
			if (result == null)
				result = caseIfcRoot(ifcRelSpaceBoundary1stLevel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_SPACE_BOUNDARY2ND_LEVEL: {
			IfcRelSpaceBoundary2ndLevel ifcRelSpaceBoundary2ndLevel = (IfcRelSpaceBoundary2ndLevel) theEObject;
			T result = caseIfcRelSpaceBoundary2ndLevel(ifcRelSpaceBoundary2ndLevel);
			if (result == null)
				result = caseIfcRelSpaceBoundary1stLevel(ifcRelSpaceBoundary2ndLevel);
			if (result == null)
				result = caseIfcRelSpaceBoundary(ifcRelSpaceBoundary2ndLevel);
			if (result == null)
				result = caseIfcRelConnects(ifcRelSpaceBoundary2ndLevel);
			if (result == null)
				result = caseIfcRelationship(ifcRelSpaceBoundary2ndLevel);
			if (result == null)
				result = caseIfcRoot(ifcRelSpaceBoundary2ndLevel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REL_VOIDS_ELEMENT: {
			IfcRelVoidsElement ifcRelVoidsElement = (IfcRelVoidsElement) theEObject;
			T result = caseIfcRelVoidsElement(ifcRelVoidsElement);
			if (result == null)
				result = caseIfcRelDecomposes(ifcRelVoidsElement);
			if (result == null)
				result = caseIfcRelationship(ifcRelVoidsElement);
			if (result == null)
				result = caseIfcRoot(ifcRelVoidsElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RELATIONSHIP: {
			IfcRelationship ifcRelationship = (IfcRelationship) theEObject;
			T result = caseIfcRelationship(ifcRelationship);
			if (result == null)
				result = caseIfcRoot(ifcRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REPARAMETRISED_COMPOSITE_CURVE_SEGMENT: {
			IfcReparametrisedCompositeCurveSegment ifcReparametrisedCompositeCurveSegment = (IfcReparametrisedCompositeCurveSegment) theEObject;
			T result = caseIfcReparametrisedCompositeCurveSegment(ifcReparametrisedCompositeCurveSegment);
			if (result == null)
				result = caseIfcCompositeCurveSegment(ifcReparametrisedCompositeCurveSegment);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcReparametrisedCompositeCurveSegment);
			if (result == null)
				result = caseIfcRepresentationItem(ifcReparametrisedCompositeCurveSegment);
			if (result == null)
				result = caseIfcLayeredItem(ifcReparametrisedCompositeCurveSegment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REPRESENTATION: {
			IfcRepresentation ifcRepresentation = (IfcRepresentation) theEObject;
			T result = caseIfcRepresentation(ifcRepresentation);
			if (result == null)
				result = caseIfcLayeredItem(ifcRepresentation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REPRESENTATION_CONTEXT: {
			IfcRepresentationContext ifcRepresentationContext = (IfcRepresentationContext) theEObject;
			T result = caseIfcRepresentationContext(ifcRepresentationContext);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REPRESENTATION_ITEM: {
			IfcRepresentationItem ifcRepresentationItem = (IfcRepresentationItem) theEObject;
			T result = caseIfcRepresentationItem(ifcRepresentationItem);
			if (result == null)
				result = caseIfcLayeredItem(ifcRepresentationItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REPRESENTATION_MAP: {
			IfcRepresentationMap ifcRepresentationMap = (IfcRepresentationMap) theEObject;
			T result = caseIfcRepresentationMap(ifcRepresentationMap);
			if (result == null)
				result = caseIfcProductRepresentationSelect(ifcRepresentationMap);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RESOURCE: {
			IfcResource ifcResource = (IfcResource) theEObject;
			T result = caseIfcResource(ifcResource);
			if (result == null)
				result = caseIfcObject(ifcResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcResource);
			if (result == null)
				result = caseIfcRoot(ifcResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RESOURCE_APPROVAL_RELATIONSHIP: {
			IfcResourceApprovalRelationship ifcResourceApprovalRelationship = (IfcResourceApprovalRelationship) theEObject;
			T result = caseIfcResourceApprovalRelationship(ifcResourceApprovalRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcResourceApprovalRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RESOURCE_CONSTRAINT_RELATIONSHIP: {
			IfcResourceConstraintRelationship ifcResourceConstraintRelationship = (IfcResourceConstraintRelationship) theEObject;
			T result = caseIfcResourceConstraintRelationship(ifcResourceConstraintRelationship);
			if (result == null)
				result = caseIfcResourceLevelRelationship(ifcResourceConstraintRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RESOURCE_LEVEL_RELATIONSHIP: {
			IfcResourceLevelRelationship ifcResourceLevelRelationship = (IfcResourceLevelRelationship) theEObject;
			T result = caseIfcResourceLevelRelationship(ifcResourceLevelRelationship);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RESOURCE_TIME: {
			IfcResourceTime ifcResourceTime = (IfcResourceTime) theEObject;
			T result = caseIfcResourceTime(ifcResourceTime);
			if (result == null)
				result = caseIfcSchedulingTime(ifcResourceTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REVOLVED_AREA_SOLID: {
			IfcRevolvedAreaSolid ifcRevolvedAreaSolid = (IfcRevolvedAreaSolid) theEObject;
			T result = caseIfcRevolvedAreaSolid(ifcRevolvedAreaSolid);
			if (result == null)
				result = caseIfcSweptAreaSolid(ifcRevolvedAreaSolid);
			if (result == null)
				result = caseIfcSolidModel(ifcRevolvedAreaSolid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcRevolvedAreaSolid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcRevolvedAreaSolid);
			if (result == null)
				result = caseIfcSolidOrShell(ifcRevolvedAreaSolid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcRevolvedAreaSolid);
			if (result == null)
				result = caseIfcLayeredItem(ifcRevolvedAreaSolid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REVOLVED_AREA_SOLID_TAPERED: {
			IfcRevolvedAreaSolidTapered ifcRevolvedAreaSolidTapered = (IfcRevolvedAreaSolidTapered) theEObject;
			T result = caseIfcRevolvedAreaSolidTapered(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = caseIfcRevolvedAreaSolid(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = caseIfcSweptAreaSolid(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = caseIfcSolidModel(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = caseIfcBooleanOperand(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = caseIfcSolidOrShell(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = caseIfcRepresentationItem(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = caseIfcLayeredItem(ifcRevolvedAreaSolidTapered);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RIGHT_CIRCULAR_CONE: {
			IfcRightCircularCone ifcRightCircularCone = (IfcRightCircularCone) theEObject;
			T result = caseIfcRightCircularCone(ifcRightCircularCone);
			if (result == null)
				result = caseIfcCsgPrimitive3D(ifcRightCircularCone);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcRightCircularCone);
			if (result == null)
				result = caseIfcBooleanOperand(ifcRightCircularCone);
			if (result == null)
				result = caseIfcCsgSelect(ifcRightCircularCone);
			if (result == null)
				result = caseIfcRepresentationItem(ifcRightCircularCone);
			if (result == null)
				result = caseIfcLayeredItem(ifcRightCircularCone);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RIGHT_CIRCULAR_CYLINDER: {
			IfcRightCircularCylinder ifcRightCircularCylinder = (IfcRightCircularCylinder) theEObject;
			T result = caseIfcRightCircularCylinder(ifcRightCircularCylinder);
			if (result == null)
				result = caseIfcCsgPrimitive3D(ifcRightCircularCylinder);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcRightCircularCylinder);
			if (result == null)
				result = caseIfcBooleanOperand(ifcRightCircularCylinder);
			if (result == null)
				result = caseIfcCsgSelect(ifcRightCircularCylinder);
			if (result == null)
				result = caseIfcRepresentationItem(ifcRightCircularCylinder);
			if (result == null)
				result = caseIfcLayeredItem(ifcRightCircularCylinder);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ROOF: {
			IfcRoof ifcRoof = (IfcRoof) theEObject;
			T result = caseIfcRoof(ifcRoof);
			if (result == null)
				result = caseIfcBuildingElement(ifcRoof);
			if (result == null)
				result = caseIfcElement(ifcRoof);
			if (result == null)
				result = caseIfcProduct(ifcRoof);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcRoof);
			if (result == null)
				result = caseIfcObject(ifcRoof);
			if (result == null)
				result = caseIfcProductSelect(ifcRoof);
			if (result == null)
				result = caseIfcObjectDefinition(ifcRoof);
			if (result == null)
				result = caseIfcRoot(ifcRoof);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcRoof);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ROOF_TYPE: {
			IfcRoofType ifcRoofType = (IfcRoofType) theEObject;
			T result = caseIfcRoofType(ifcRoofType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcRoofType);
			if (result == null)
				result = caseIfcElementType(ifcRoofType);
			if (result == null)
				result = caseIfcTypeProduct(ifcRoofType);
			if (result == null)
				result = caseIfcTypeObject(ifcRoofType);
			if (result == null)
				result = caseIfcProductSelect(ifcRoofType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcRoofType);
			if (result == null)
				result = caseIfcRoot(ifcRoofType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcRoofType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ROOT: {
			IfcRoot ifcRoot = (IfcRoot) theEObject;
			T result = caseIfcRoot(ifcRoot);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ROUNDED_RECTANGLE_PROFILE_DEF: {
			IfcRoundedRectangleProfileDef ifcRoundedRectangleProfileDef = (IfcRoundedRectangleProfileDef) theEObject;
			T result = caseIfcRoundedRectangleProfileDef(ifcRoundedRectangleProfileDef);
			if (result == null)
				result = caseIfcRectangleProfileDef(ifcRoundedRectangleProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcRoundedRectangleProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcRoundedRectangleProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcRoundedRectangleProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SI_UNIT: {
			IfcSIUnit ifcSIUnit = (IfcSIUnit) theEObject;
			T result = caseIfcSIUnit(ifcSIUnit);
			if (result == null)
				result = caseIfcNamedUnit(ifcSIUnit);
			if (result == null)
				result = caseIfcUnit(ifcSIUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SANITARY_TERMINAL: {
			IfcSanitaryTerminal ifcSanitaryTerminal = (IfcSanitaryTerminal) theEObject;
			T result = caseIfcSanitaryTerminal(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcFlowTerminal(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcDistributionElement(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcElement(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcProduct(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcObject(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcProductSelect(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcRoot(ifcSanitaryTerminal);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSanitaryTerminal);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SANITARY_TERMINAL_TYPE: {
			IfcSanitaryTerminalType ifcSanitaryTerminalType = (IfcSanitaryTerminalType) theEObject;
			T result = caseIfcSanitaryTerminalType(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcElementType(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcTypeObject(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcProductSelect(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcRoot(ifcSanitaryTerminalType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSanitaryTerminalType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SCHEDULING_TIME: {
			IfcSchedulingTime ifcSchedulingTime = (IfcSchedulingTime) theEObject;
			T result = caseIfcSchedulingTime(ifcSchedulingTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SEAM_CURVE: {
			IfcSeamCurve ifcSeamCurve = (IfcSeamCurve) theEObject;
			T result = caseIfcSeamCurve(ifcSeamCurve);
			if (result == null)
				result = caseIfcSurfaceCurve(ifcSeamCurve);
			if (result == null)
				result = caseIfcCurve(ifcSeamCurve);
			if (result == null)
				result = caseIfcCurveOnSurface(ifcSeamCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSeamCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcSeamCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSeamCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcSeamCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SECTION_PROPERTIES: {
			IfcSectionProperties ifcSectionProperties = (IfcSectionProperties) theEObject;
			T result = caseIfcSectionProperties(ifcSectionProperties);
			if (result == null)
				result = caseIfcPreDefinedProperties(ifcSectionProperties);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcSectionProperties);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcSectionProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SECTION_REINFORCEMENT_PROPERTIES: {
			IfcSectionReinforcementProperties ifcSectionReinforcementProperties = (IfcSectionReinforcementProperties) theEObject;
			T result = caseIfcSectionReinforcementProperties(ifcSectionReinforcementProperties);
			if (result == null)
				result = caseIfcPreDefinedProperties(ifcSectionReinforcementProperties);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcSectionReinforcementProperties);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcSectionReinforcementProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SECTIONED_SPINE: {
			IfcSectionedSpine ifcSectionedSpine = (IfcSectionedSpine) theEObject;
			T result = caseIfcSectionedSpine(ifcSectionedSpine);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSectionedSpine);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSectionedSpine);
			if (result == null)
				result = caseIfcLayeredItem(ifcSectionedSpine);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SENSOR: {
			IfcSensor ifcSensor = (IfcSensor) theEObject;
			T result = caseIfcSensor(ifcSensor);
			if (result == null)
				result = caseIfcDistributionControlElement(ifcSensor);
			if (result == null)
				result = caseIfcDistributionElement(ifcSensor);
			if (result == null)
				result = caseIfcElement(ifcSensor);
			if (result == null)
				result = caseIfcProduct(ifcSensor);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSensor);
			if (result == null)
				result = caseIfcObject(ifcSensor);
			if (result == null)
				result = caseIfcProductSelect(ifcSensor);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSensor);
			if (result == null)
				result = caseIfcRoot(ifcSensor);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSensor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SENSOR_TYPE: {
			IfcSensorType ifcSensorType = (IfcSensorType) theEObject;
			T result = caseIfcSensorType(ifcSensorType);
			if (result == null)
				result = caseIfcDistributionControlElementType(ifcSensorType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcSensorType);
			if (result == null)
				result = caseIfcElementType(ifcSensorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSensorType);
			if (result == null)
				result = caseIfcTypeObject(ifcSensorType);
			if (result == null)
				result = caseIfcProductSelect(ifcSensorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSensorType);
			if (result == null)
				result = caseIfcRoot(ifcSensorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSensorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SHADING_DEVICE: {
			IfcShadingDevice ifcShadingDevice = (IfcShadingDevice) theEObject;
			T result = caseIfcShadingDevice(ifcShadingDevice);
			if (result == null)
				result = caseIfcBuildingElement(ifcShadingDevice);
			if (result == null)
				result = caseIfcElement(ifcShadingDevice);
			if (result == null)
				result = caseIfcProduct(ifcShadingDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcShadingDevice);
			if (result == null)
				result = caseIfcObject(ifcShadingDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcShadingDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcShadingDevice);
			if (result == null)
				result = caseIfcRoot(ifcShadingDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcShadingDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SHADING_DEVICE_TYPE: {
			IfcShadingDeviceType ifcShadingDeviceType = (IfcShadingDeviceType) theEObject;
			T result = caseIfcShadingDeviceType(ifcShadingDeviceType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcShadingDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcShadingDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcShadingDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcShadingDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcShadingDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcShadingDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcShadingDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcShadingDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SHAPE_ASPECT: {
			IfcShapeAspect ifcShapeAspect = (IfcShapeAspect) theEObject;
			T result = caseIfcShapeAspect(ifcShapeAspect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SHAPE_MODEL: {
			IfcShapeModel ifcShapeModel = (IfcShapeModel) theEObject;
			T result = caseIfcShapeModel(ifcShapeModel);
			if (result == null)
				result = caseIfcRepresentation(ifcShapeModel);
			if (result == null)
				result = caseIfcLayeredItem(ifcShapeModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SHAPE_REPRESENTATION: {
			IfcShapeRepresentation ifcShapeRepresentation = (IfcShapeRepresentation) theEObject;
			T result = caseIfcShapeRepresentation(ifcShapeRepresentation);
			if (result == null)
				result = caseIfcShapeModel(ifcShapeRepresentation);
			if (result == null)
				result = caseIfcRepresentation(ifcShapeRepresentation);
			if (result == null)
				result = caseIfcLayeredItem(ifcShapeRepresentation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SHELL_BASED_SURFACE_MODEL: {
			IfcShellBasedSurfaceModel ifcShellBasedSurfaceModel = (IfcShellBasedSurfaceModel) theEObject;
			T result = caseIfcShellBasedSurfaceModel(ifcShellBasedSurfaceModel);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcShellBasedSurfaceModel);
			if (result == null)
				result = caseIfcRepresentationItem(ifcShellBasedSurfaceModel);
			if (result == null)
				result = caseIfcLayeredItem(ifcShellBasedSurfaceModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SIMPLE_PROPERTY: {
			IfcSimpleProperty ifcSimpleProperty = (IfcSimpleProperty) theEObject;
			T result = caseIfcSimpleProperty(ifcSimpleProperty);
			if (result == null)
				result = caseIfcProperty(ifcSimpleProperty);
			if (result == null)
				result = caseIfcPropertyAbstraction(ifcSimpleProperty);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcSimpleProperty);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SIMPLE_PROPERTY_TEMPLATE: {
			IfcSimplePropertyTemplate ifcSimplePropertyTemplate = (IfcSimplePropertyTemplate) theEObject;
			T result = caseIfcSimplePropertyTemplate(ifcSimplePropertyTemplate);
			if (result == null)
				result = caseIfcPropertyTemplate(ifcSimplePropertyTemplate);
			if (result == null)
				result = caseIfcPropertyTemplateDefinition(ifcSimplePropertyTemplate);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcSimplePropertyTemplate);
			if (result == null)
				result = caseIfcRoot(ifcSimplePropertyTemplate);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSimplePropertyTemplate);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SITE: {
			IfcSite ifcSite = (IfcSite) theEObject;
			T result = caseIfcSite(ifcSite);
			if (result == null)
				result = caseIfcSpatialStructureElement(ifcSite);
			if (result == null)
				result = caseIfcSpatialElement(ifcSite);
			if (result == null)
				result = caseIfcProduct(ifcSite);
			if (result == null)
				result = caseIfcObject(ifcSite);
			if (result == null)
				result = caseIfcProductSelect(ifcSite);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSite);
			if (result == null)
				result = caseIfcRoot(ifcSite);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSite);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SLAB: {
			IfcSlab ifcSlab = (IfcSlab) theEObject;
			T result = caseIfcSlab(ifcSlab);
			if (result == null)
				result = caseIfcBuildingElement(ifcSlab);
			if (result == null)
				result = caseIfcElement(ifcSlab);
			if (result == null)
				result = caseIfcProduct(ifcSlab);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSlab);
			if (result == null)
				result = caseIfcObject(ifcSlab);
			if (result == null)
				result = caseIfcProductSelect(ifcSlab);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSlab);
			if (result == null)
				result = caseIfcRoot(ifcSlab);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSlab);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SLAB_ELEMENTED_CASE: {
			IfcSlabElementedCase ifcSlabElementedCase = (IfcSlabElementedCase) theEObject;
			T result = caseIfcSlabElementedCase(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcSlab(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcElement(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcProduct(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcObject(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcProductSelect(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcRoot(ifcSlabElementedCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSlabElementedCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SLAB_STANDARD_CASE: {
			IfcSlabStandardCase ifcSlabStandardCase = (IfcSlabStandardCase) theEObject;
			T result = caseIfcSlabStandardCase(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcSlab(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcElement(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcObject(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcSlabStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSlabStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SLAB_TYPE: {
			IfcSlabType ifcSlabType = (IfcSlabType) theEObject;
			T result = caseIfcSlabType(ifcSlabType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcSlabType);
			if (result == null)
				result = caseIfcElementType(ifcSlabType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSlabType);
			if (result == null)
				result = caseIfcTypeObject(ifcSlabType);
			if (result == null)
				result = caseIfcProductSelect(ifcSlabType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSlabType);
			if (result == null)
				result = caseIfcRoot(ifcSlabType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSlabType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SLIPPAGE_CONNECTION_CONDITION: {
			IfcSlippageConnectionCondition ifcSlippageConnectionCondition = (IfcSlippageConnectionCondition) theEObject;
			T result = caseIfcSlippageConnectionCondition(ifcSlippageConnectionCondition);
			if (result == null)
				result = caseIfcStructuralConnectionCondition(ifcSlippageConnectionCondition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOLAR_DEVICE: {
			IfcSolarDevice ifcSolarDevice = (IfcSolarDevice) theEObject;
			T result = caseIfcSolarDevice(ifcSolarDevice);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcSolarDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcSolarDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcSolarDevice);
			if (result == null)
				result = caseIfcElement(ifcSolarDevice);
			if (result == null)
				result = caseIfcProduct(ifcSolarDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSolarDevice);
			if (result == null)
				result = caseIfcObject(ifcSolarDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcSolarDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSolarDevice);
			if (result == null)
				result = caseIfcRoot(ifcSolarDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSolarDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOLAR_DEVICE_TYPE: {
			IfcSolarDeviceType ifcSolarDeviceType = (IfcSolarDeviceType) theEObject;
			T result = caseIfcSolarDeviceType(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcSolarDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSolarDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOLID_MODEL: {
			IfcSolidModel ifcSolidModel = (IfcSolidModel) theEObject;
			T result = caseIfcSolidModel(ifcSolidModel);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSolidModel);
			if (result == null)
				result = caseIfcBooleanOperand(ifcSolidModel);
			if (result == null)
				result = caseIfcSolidOrShell(ifcSolidModel);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSolidModel);
			if (result == null)
				result = caseIfcLayeredItem(ifcSolidModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPACE: {
			IfcSpace ifcSpace = (IfcSpace) theEObject;
			T result = caseIfcSpace(ifcSpace);
			if (result == null)
				result = caseIfcSpatialStructureElement(ifcSpace);
			if (result == null)
				result = caseIfcSpaceBoundarySelect(ifcSpace);
			if (result == null)
				result = caseIfcSpatialElement(ifcSpace);
			if (result == null)
				result = caseIfcProduct(ifcSpace);
			if (result == null)
				result = caseIfcObject(ifcSpace);
			if (result == null)
				result = caseIfcProductSelect(ifcSpace);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpace);
			if (result == null)
				result = caseIfcRoot(ifcSpace);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpace);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPACE_HEATER: {
			IfcSpaceHeater ifcSpaceHeater = (IfcSpaceHeater) theEObject;
			T result = caseIfcSpaceHeater(ifcSpaceHeater);
			if (result == null)
				result = caseIfcFlowTerminal(ifcSpaceHeater);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcSpaceHeater);
			if (result == null)
				result = caseIfcDistributionElement(ifcSpaceHeater);
			if (result == null)
				result = caseIfcElement(ifcSpaceHeater);
			if (result == null)
				result = caseIfcProduct(ifcSpaceHeater);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSpaceHeater);
			if (result == null)
				result = caseIfcObject(ifcSpaceHeater);
			if (result == null)
				result = caseIfcProductSelect(ifcSpaceHeater);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpaceHeater);
			if (result == null)
				result = caseIfcRoot(ifcSpaceHeater);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpaceHeater);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPACE_HEATER_TYPE: {
			IfcSpaceHeaterType ifcSpaceHeaterType = (IfcSpaceHeaterType) theEObject;
			T result = caseIfcSpaceHeaterType(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcElementType(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcTypeObject(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcProductSelect(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcRoot(ifcSpaceHeaterType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpaceHeaterType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPACE_TYPE: {
			IfcSpaceType ifcSpaceType = (IfcSpaceType) theEObject;
			T result = caseIfcSpaceType(ifcSpaceType);
			if (result == null)
				result = caseIfcSpatialStructureElementType(ifcSpaceType);
			if (result == null)
				result = caseIfcSpatialElementType(ifcSpaceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSpaceType);
			if (result == null)
				result = caseIfcTypeObject(ifcSpaceType);
			if (result == null)
				result = caseIfcProductSelect(ifcSpaceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpaceType);
			if (result == null)
				result = caseIfcRoot(ifcSpaceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpaceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPATIAL_ELEMENT: {
			IfcSpatialElement ifcSpatialElement = (IfcSpatialElement) theEObject;
			T result = caseIfcSpatialElement(ifcSpatialElement);
			if (result == null)
				result = caseIfcProduct(ifcSpatialElement);
			if (result == null)
				result = caseIfcObject(ifcSpatialElement);
			if (result == null)
				result = caseIfcProductSelect(ifcSpatialElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpatialElement);
			if (result == null)
				result = caseIfcRoot(ifcSpatialElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpatialElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPATIAL_ELEMENT_TYPE: {
			IfcSpatialElementType ifcSpatialElementType = (IfcSpatialElementType) theEObject;
			T result = caseIfcSpatialElementType(ifcSpatialElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSpatialElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcSpatialElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcSpatialElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpatialElementType);
			if (result == null)
				result = caseIfcRoot(ifcSpatialElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpatialElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPATIAL_STRUCTURE_ELEMENT: {
			IfcSpatialStructureElement ifcSpatialStructureElement = (IfcSpatialStructureElement) theEObject;
			T result = caseIfcSpatialStructureElement(ifcSpatialStructureElement);
			if (result == null)
				result = caseIfcSpatialElement(ifcSpatialStructureElement);
			if (result == null)
				result = caseIfcProduct(ifcSpatialStructureElement);
			if (result == null)
				result = caseIfcObject(ifcSpatialStructureElement);
			if (result == null)
				result = caseIfcProductSelect(ifcSpatialStructureElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpatialStructureElement);
			if (result == null)
				result = caseIfcRoot(ifcSpatialStructureElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpatialStructureElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPATIAL_STRUCTURE_ELEMENT_TYPE: {
			IfcSpatialStructureElementType ifcSpatialStructureElementType = (IfcSpatialStructureElementType) theEObject;
			T result = caseIfcSpatialStructureElementType(ifcSpatialStructureElementType);
			if (result == null)
				result = caseIfcSpatialElementType(ifcSpatialStructureElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSpatialStructureElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcSpatialStructureElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcSpatialStructureElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpatialStructureElementType);
			if (result == null)
				result = caseIfcRoot(ifcSpatialStructureElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpatialStructureElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPATIAL_ZONE: {
			IfcSpatialZone ifcSpatialZone = (IfcSpatialZone) theEObject;
			T result = caseIfcSpatialZone(ifcSpatialZone);
			if (result == null)
				result = caseIfcSpatialElement(ifcSpatialZone);
			if (result == null)
				result = caseIfcProduct(ifcSpatialZone);
			if (result == null)
				result = caseIfcObject(ifcSpatialZone);
			if (result == null)
				result = caseIfcProductSelect(ifcSpatialZone);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpatialZone);
			if (result == null)
				result = caseIfcRoot(ifcSpatialZone);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpatialZone);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPATIAL_ZONE_TYPE: {
			IfcSpatialZoneType ifcSpatialZoneType = (IfcSpatialZoneType) theEObject;
			T result = caseIfcSpatialZoneType(ifcSpatialZoneType);
			if (result == null)
				result = caseIfcSpatialElementType(ifcSpatialZoneType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSpatialZoneType);
			if (result == null)
				result = caseIfcTypeObject(ifcSpatialZoneType);
			if (result == null)
				result = caseIfcProductSelect(ifcSpatialZoneType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSpatialZoneType);
			if (result == null)
				result = caseIfcRoot(ifcSpatialZoneType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSpatialZoneType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPHERE: {
			IfcSphere ifcSphere = (IfcSphere) theEObject;
			T result = caseIfcSphere(ifcSphere);
			if (result == null)
				result = caseIfcCsgPrimitive3D(ifcSphere);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSphere);
			if (result == null)
				result = caseIfcBooleanOperand(ifcSphere);
			if (result == null)
				result = caseIfcCsgSelect(ifcSphere);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSphere);
			if (result == null)
				result = caseIfcLayeredItem(ifcSphere);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPHERICAL_SURFACE: {
			IfcSphericalSurface ifcSphericalSurface = (IfcSphericalSurface) theEObject;
			T result = caseIfcSphericalSurface(ifcSphericalSurface);
			if (result == null)
				result = caseIfcElementarySurface(ifcSphericalSurface);
			if (result == null)
				result = caseIfcSurface(ifcSphericalSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSphericalSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcSphericalSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcSphericalSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSphericalSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcSphericalSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STACK_TERMINAL: {
			IfcStackTerminal ifcStackTerminal = (IfcStackTerminal) theEObject;
			T result = caseIfcStackTerminal(ifcStackTerminal);
			if (result == null)
				result = caseIfcFlowTerminal(ifcStackTerminal);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcStackTerminal);
			if (result == null)
				result = caseIfcDistributionElement(ifcStackTerminal);
			if (result == null)
				result = caseIfcElement(ifcStackTerminal);
			if (result == null)
				result = caseIfcProduct(ifcStackTerminal);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStackTerminal);
			if (result == null)
				result = caseIfcObject(ifcStackTerminal);
			if (result == null)
				result = caseIfcProductSelect(ifcStackTerminal);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStackTerminal);
			if (result == null)
				result = caseIfcRoot(ifcStackTerminal);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStackTerminal);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STACK_TERMINAL_TYPE: {
			IfcStackTerminalType ifcStackTerminalType = (IfcStackTerminalType) theEObject;
			T result = caseIfcStackTerminalType(ifcStackTerminalType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcStackTerminalType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcStackTerminalType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcStackTerminalType);
			if (result == null)
				result = caseIfcElementType(ifcStackTerminalType);
			if (result == null)
				result = caseIfcTypeProduct(ifcStackTerminalType);
			if (result == null)
				result = caseIfcTypeObject(ifcStackTerminalType);
			if (result == null)
				result = caseIfcProductSelect(ifcStackTerminalType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStackTerminalType);
			if (result == null)
				result = caseIfcRoot(ifcStackTerminalType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStackTerminalType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STAIR: {
			IfcStair ifcStair = (IfcStair) theEObject;
			T result = caseIfcStair(ifcStair);
			if (result == null)
				result = caseIfcBuildingElement(ifcStair);
			if (result == null)
				result = caseIfcElement(ifcStair);
			if (result == null)
				result = caseIfcProduct(ifcStair);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStair);
			if (result == null)
				result = caseIfcObject(ifcStair);
			if (result == null)
				result = caseIfcProductSelect(ifcStair);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStair);
			if (result == null)
				result = caseIfcRoot(ifcStair);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStair);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STAIR_FLIGHT: {
			IfcStairFlight ifcStairFlight = (IfcStairFlight) theEObject;
			T result = caseIfcStairFlight(ifcStairFlight);
			if (result == null)
				result = caseIfcBuildingElement(ifcStairFlight);
			if (result == null)
				result = caseIfcElement(ifcStairFlight);
			if (result == null)
				result = caseIfcProduct(ifcStairFlight);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStairFlight);
			if (result == null)
				result = caseIfcObject(ifcStairFlight);
			if (result == null)
				result = caseIfcProductSelect(ifcStairFlight);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStairFlight);
			if (result == null)
				result = caseIfcRoot(ifcStairFlight);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStairFlight);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STAIR_FLIGHT_TYPE: {
			IfcStairFlightType ifcStairFlightType = (IfcStairFlightType) theEObject;
			T result = caseIfcStairFlightType(ifcStairFlightType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcStairFlightType);
			if (result == null)
				result = caseIfcElementType(ifcStairFlightType);
			if (result == null)
				result = caseIfcTypeProduct(ifcStairFlightType);
			if (result == null)
				result = caseIfcTypeObject(ifcStairFlightType);
			if (result == null)
				result = caseIfcProductSelect(ifcStairFlightType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStairFlightType);
			if (result == null)
				result = caseIfcRoot(ifcStairFlightType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStairFlightType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STAIR_TYPE: {
			IfcStairType ifcStairType = (IfcStairType) theEObject;
			T result = caseIfcStairType(ifcStairType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcStairType);
			if (result == null)
				result = caseIfcElementType(ifcStairType);
			if (result == null)
				result = caseIfcTypeProduct(ifcStairType);
			if (result == null)
				result = caseIfcTypeObject(ifcStairType);
			if (result == null)
				result = caseIfcProductSelect(ifcStairType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStairType);
			if (result == null)
				result = caseIfcRoot(ifcStairType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStairType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_ACTION: {
			IfcStructuralAction ifcStructuralAction = (IfcStructuralAction) theEObject;
			T result = caseIfcStructuralAction(ifcStructuralAction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralAction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralAction);
			if (result == null)
				result = caseIfcObject(ifcStructuralAction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralAction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralAction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralAction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralAction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_ACTIVITY: {
			IfcStructuralActivity ifcStructuralActivity = (IfcStructuralActivity) theEObject;
			T result = caseIfcStructuralActivity(ifcStructuralActivity);
			if (result == null)
				result = caseIfcProduct(ifcStructuralActivity);
			if (result == null)
				result = caseIfcObject(ifcStructuralActivity);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralActivity);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralActivity);
			if (result == null)
				result = caseIfcRoot(ifcStructuralActivity);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralActivity);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_ANALYSIS_MODEL: {
			IfcStructuralAnalysisModel ifcStructuralAnalysisModel = (IfcStructuralAnalysisModel) theEObject;
			T result = caseIfcStructuralAnalysisModel(ifcStructuralAnalysisModel);
			if (result == null)
				result = caseIfcSystem(ifcStructuralAnalysisModel);
			if (result == null)
				result = caseIfcGroup(ifcStructuralAnalysisModel);
			if (result == null)
				result = caseIfcObject(ifcStructuralAnalysisModel);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralAnalysisModel);
			if (result == null)
				result = caseIfcRoot(ifcStructuralAnalysisModel);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralAnalysisModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_CONNECTION: {
			IfcStructuralConnection ifcStructuralConnection = (IfcStructuralConnection) theEObject;
			T result = caseIfcStructuralConnection(ifcStructuralConnection);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralConnection);
			if (result == null)
				result = caseIfcProduct(ifcStructuralConnection);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralConnection);
			if (result == null)
				result = caseIfcObject(ifcStructuralConnection);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralConnection);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralConnection);
			if (result == null)
				result = caseIfcRoot(ifcStructuralConnection);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralConnection);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_CONNECTION_CONDITION: {
			IfcStructuralConnectionCondition ifcStructuralConnectionCondition = (IfcStructuralConnectionCondition) theEObject;
			T result = caseIfcStructuralConnectionCondition(ifcStructuralConnectionCondition);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_CURVE_ACTION: {
			IfcStructuralCurveAction ifcStructuralCurveAction = (IfcStructuralCurveAction) theEObject;
			T result = caseIfcStructuralCurveAction(ifcStructuralCurveAction);
			if (result == null)
				result = caseIfcStructuralAction(ifcStructuralCurveAction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralCurveAction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralCurveAction);
			if (result == null)
				result = caseIfcObject(ifcStructuralCurveAction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralCurveAction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralCurveAction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralCurveAction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralCurveAction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_CURVE_CONNECTION: {
			IfcStructuralCurveConnection ifcStructuralCurveConnection = (IfcStructuralCurveConnection) theEObject;
			T result = caseIfcStructuralCurveConnection(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcStructuralConnection(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcProduct(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcObject(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcRoot(ifcStructuralCurveConnection);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralCurveConnection);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_CURVE_MEMBER: {
			IfcStructuralCurveMember ifcStructuralCurveMember = (IfcStructuralCurveMember) theEObject;
			T result = caseIfcStructuralCurveMember(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcStructuralMember(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcProduct(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcObject(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcRoot(ifcStructuralCurveMember);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralCurveMember);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_CURVE_MEMBER_VARYING: {
			IfcStructuralCurveMemberVarying ifcStructuralCurveMemberVarying = (IfcStructuralCurveMemberVarying) theEObject;
			T result = caseIfcStructuralCurveMemberVarying(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcStructuralCurveMember(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcStructuralMember(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcProduct(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcObject(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcRoot(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralCurveMemberVarying);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_CURVE_REACTION: {
			IfcStructuralCurveReaction ifcStructuralCurveReaction = (IfcStructuralCurveReaction) theEObject;
			T result = caseIfcStructuralCurveReaction(ifcStructuralCurveReaction);
			if (result == null)
				result = caseIfcStructuralReaction(ifcStructuralCurveReaction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralCurveReaction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralCurveReaction);
			if (result == null)
				result = caseIfcObject(ifcStructuralCurveReaction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralCurveReaction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralCurveReaction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralCurveReaction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralCurveReaction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_ITEM: {
			IfcStructuralItem ifcStructuralItem = (IfcStructuralItem) theEObject;
			T result = caseIfcStructuralItem(ifcStructuralItem);
			if (result == null)
				result = caseIfcProduct(ifcStructuralItem);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralItem);
			if (result == null)
				result = caseIfcObject(ifcStructuralItem);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralItem);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralItem);
			if (result == null)
				result = caseIfcRoot(ifcStructuralItem);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LINEAR_ACTION: {
			IfcStructuralLinearAction ifcStructuralLinearAction = (IfcStructuralLinearAction) theEObject;
			T result = caseIfcStructuralLinearAction(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcStructuralCurveAction(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcStructuralAction(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcObject(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralLinearAction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralLinearAction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD: {
			IfcStructuralLoad ifcStructuralLoad = (IfcStructuralLoad) theEObject;
			T result = caseIfcStructuralLoad(ifcStructuralLoad);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_CASE: {
			IfcStructuralLoadCase ifcStructuralLoadCase = (IfcStructuralLoadCase) theEObject;
			T result = caseIfcStructuralLoadCase(ifcStructuralLoadCase);
			if (result == null)
				result = caseIfcStructuralLoadGroup(ifcStructuralLoadCase);
			if (result == null)
				result = caseIfcGroup(ifcStructuralLoadCase);
			if (result == null)
				result = caseIfcObject(ifcStructuralLoadCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralLoadCase);
			if (result == null)
				result = caseIfcRoot(ifcStructuralLoadCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralLoadCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_CONFIGURATION: {
			IfcStructuralLoadConfiguration ifcStructuralLoadConfiguration = (IfcStructuralLoadConfiguration) theEObject;
			T result = caseIfcStructuralLoadConfiguration(ifcStructuralLoadConfiguration);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadConfiguration);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_GROUP: {
			IfcStructuralLoadGroup ifcStructuralLoadGroup = (IfcStructuralLoadGroup) theEObject;
			T result = caseIfcStructuralLoadGroup(ifcStructuralLoadGroup);
			if (result == null)
				result = caseIfcGroup(ifcStructuralLoadGroup);
			if (result == null)
				result = caseIfcObject(ifcStructuralLoadGroup);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralLoadGroup);
			if (result == null)
				result = caseIfcRoot(ifcStructuralLoadGroup);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralLoadGroup);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_LINEAR_FORCE: {
			IfcStructuralLoadLinearForce ifcStructuralLoadLinearForce = (IfcStructuralLoadLinearForce) theEObject;
			T result = caseIfcStructuralLoadLinearForce(ifcStructuralLoadLinearForce);
			if (result == null)
				result = caseIfcStructuralLoadStatic(ifcStructuralLoadLinearForce);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcStructuralLoadLinearForce);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadLinearForce);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_OR_RESULT: {
			IfcStructuralLoadOrResult ifcStructuralLoadOrResult = (IfcStructuralLoadOrResult) theEObject;
			T result = caseIfcStructuralLoadOrResult(ifcStructuralLoadOrResult);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadOrResult);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_PLANAR_FORCE: {
			IfcStructuralLoadPlanarForce ifcStructuralLoadPlanarForce = (IfcStructuralLoadPlanarForce) theEObject;
			T result = caseIfcStructuralLoadPlanarForce(ifcStructuralLoadPlanarForce);
			if (result == null)
				result = caseIfcStructuralLoadStatic(ifcStructuralLoadPlanarForce);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcStructuralLoadPlanarForce);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadPlanarForce);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_SINGLE_DISPLACEMENT: {
			IfcStructuralLoadSingleDisplacement ifcStructuralLoadSingleDisplacement = (IfcStructuralLoadSingleDisplacement) theEObject;
			T result = caseIfcStructuralLoadSingleDisplacement(ifcStructuralLoadSingleDisplacement);
			if (result == null)
				result = caseIfcStructuralLoadStatic(ifcStructuralLoadSingleDisplacement);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcStructuralLoadSingleDisplacement);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadSingleDisplacement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_SINGLE_DISPLACEMENT_DISTORTION: {
			IfcStructuralLoadSingleDisplacementDistortion ifcStructuralLoadSingleDisplacementDistortion = (IfcStructuralLoadSingleDisplacementDistortion) theEObject;
			T result = caseIfcStructuralLoadSingleDisplacementDistortion(ifcStructuralLoadSingleDisplacementDistortion);
			if (result == null)
				result = caseIfcStructuralLoadSingleDisplacement(ifcStructuralLoadSingleDisplacementDistortion);
			if (result == null)
				result = caseIfcStructuralLoadStatic(ifcStructuralLoadSingleDisplacementDistortion);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcStructuralLoadSingleDisplacementDistortion);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadSingleDisplacementDistortion);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_SINGLE_FORCE: {
			IfcStructuralLoadSingleForce ifcStructuralLoadSingleForce = (IfcStructuralLoadSingleForce) theEObject;
			T result = caseIfcStructuralLoadSingleForce(ifcStructuralLoadSingleForce);
			if (result == null)
				result = caseIfcStructuralLoadStatic(ifcStructuralLoadSingleForce);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcStructuralLoadSingleForce);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadSingleForce);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_SINGLE_FORCE_WARPING: {
			IfcStructuralLoadSingleForceWarping ifcStructuralLoadSingleForceWarping = (IfcStructuralLoadSingleForceWarping) theEObject;
			T result = caseIfcStructuralLoadSingleForceWarping(ifcStructuralLoadSingleForceWarping);
			if (result == null)
				result = caseIfcStructuralLoadSingleForce(ifcStructuralLoadSingleForceWarping);
			if (result == null)
				result = caseIfcStructuralLoadStatic(ifcStructuralLoadSingleForceWarping);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcStructuralLoadSingleForceWarping);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadSingleForceWarping);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_STATIC: {
			IfcStructuralLoadStatic ifcStructuralLoadStatic = (IfcStructuralLoadStatic) theEObject;
			T result = caseIfcStructuralLoadStatic(ifcStructuralLoadStatic);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcStructuralLoadStatic);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadStatic);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_LOAD_TEMPERATURE: {
			IfcStructuralLoadTemperature ifcStructuralLoadTemperature = (IfcStructuralLoadTemperature) theEObject;
			T result = caseIfcStructuralLoadTemperature(ifcStructuralLoadTemperature);
			if (result == null)
				result = caseIfcStructuralLoadStatic(ifcStructuralLoadTemperature);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcStructuralLoadTemperature);
			if (result == null)
				result = caseIfcStructuralLoad(ifcStructuralLoadTemperature);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_MEMBER: {
			IfcStructuralMember ifcStructuralMember = (IfcStructuralMember) theEObject;
			T result = caseIfcStructuralMember(ifcStructuralMember);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralMember);
			if (result == null)
				result = caseIfcProduct(ifcStructuralMember);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralMember);
			if (result == null)
				result = caseIfcObject(ifcStructuralMember);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralMember);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralMember);
			if (result == null)
				result = caseIfcRoot(ifcStructuralMember);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralMember);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_PLANAR_ACTION: {
			IfcStructuralPlanarAction ifcStructuralPlanarAction = (IfcStructuralPlanarAction) theEObject;
			T result = caseIfcStructuralPlanarAction(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcStructuralSurfaceAction(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcStructuralAction(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcObject(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralPlanarAction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralPlanarAction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_POINT_ACTION: {
			IfcStructuralPointAction ifcStructuralPointAction = (IfcStructuralPointAction) theEObject;
			T result = caseIfcStructuralPointAction(ifcStructuralPointAction);
			if (result == null)
				result = caseIfcStructuralAction(ifcStructuralPointAction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralPointAction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralPointAction);
			if (result == null)
				result = caseIfcObject(ifcStructuralPointAction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralPointAction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralPointAction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralPointAction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralPointAction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_POINT_CONNECTION: {
			IfcStructuralPointConnection ifcStructuralPointConnection = (IfcStructuralPointConnection) theEObject;
			T result = caseIfcStructuralPointConnection(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcStructuralConnection(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcProduct(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcObject(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcRoot(ifcStructuralPointConnection);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralPointConnection);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_POINT_REACTION: {
			IfcStructuralPointReaction ifcStructuralPointReaction = (IfcStructuralPointReaction) theEObject;
			T result = caseIfcStructuralPointReaction(ifcStructuralPointReaction);
			if (result == null)
				result = caseIfcStructuralReaction(ifcStructuralPointReaction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralPointReaction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralPointReaction);
			if (result == null)
				result = caseIfcObject(ifcStructuralPointReaction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralPointReaction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralPointReaction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralPointReaction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralPointReaction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_REACTION: {
			IfcStructuralReaction ifcStructuralReaction = (IfcStructuralReaction) theEObject;
			T result = caseIfcStructuralReaction(ifcStructuralReaction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralReaction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralReaction);
			if (result == null)
				result = caseIfcObject(ifcStructuralReaction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralReaction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralReaction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralReaction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralReaction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_RESULT_GROUP: {
			IfcStructuralResultGroup ifcStructuralResultGroup = (IfcStructuralResultGroup) theEObject;
			T result = caseIfcStructuralResultGroup(ifcStructuralResultGroup);
			if (result == null)
				result = caseIfcGroup(ifcStructuralResultGroup);
			if (result == null)
				result = caseIfcObject(ifcStructuralResultGroup);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralResultGroup);
			if (result == null)
				result = caseIfcRoot(ifcStructuralResultGroup);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralResultGroup);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_SURFACE_ACTION: {
			IfcStructuralSurfaceAction ifcStructuralSurfaceAction = (IfcStructuralSurfaceAction) theEObject;
			T result = caseIfcStructuralSurfaceAction(ifcStructuralSurfaceAction);
			if (result == null)
				result = caseIfcStructuralAction(ifcStructuralSurfaceAction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralSurfaceAction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralSurfaceAction);
			if (result == null)
				result = caseIfcObject(ifcStructuralSurfaceAction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralSurfaceAction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralSurfaceAction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralSurfaceAction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralSurfaceAction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_SURFACE_CONNECTION: {
			IfcStructuralSurfaceConnection ifcStructuralSurfaceConnection = (IfcStructuralSurfaceConnection) theEObject;
			T result = caseIfcStructuralSurfaceConnection(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcStructuralConnection(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcProduct(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcObject(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcRoot(ifcStructuralSurfaceConnection);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralSurfaceConnection);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_SURFACE_MEMBER: {
			IfcStructuralSurfaceMember ifcStructuralSurfaceMember = (IfcStructuralSurfaceMember) theEObject;
			T result = caseIfcStructuralSurfaceMember(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcStructuralMember(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcProduct(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcObject(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcRoot(ifcStructuralSurfaceMember);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralSurfaceMember);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_SURFACE_MEMBER_VARYING: {
			IfcStructuralSurfaceMemberVarying ifcStructuralSurfaceMemberVarying = (IfcStructuralSurfaceMemberVarying) theEObject;
			T result = caseIfcStructuralSurfaceMemberVarying(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcStructuralSurfaceMember(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcStructuralMember(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcStructuralItem(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcProduct(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcObject(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcRoot(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralSurfaceMemberVarying);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_SURFACE_REACTION: {
			IfcStructuralSurfaceReaction ifcStructuralSurfaceReaction = (IfcStructuralSurfaceReaction) theEObject;
			T result = caseIfcStructuralSurfaceReaction(ifcStructuralSurfaceReaction);
			if (result == null)
				result = caseIfcStructuralReaction(ifcStructuralSurfaceReaction);
			if (result == null)
				result = caseIfcStructuralActivity(ifcStructuralSurfaceReaction);
			if (result == null)
				result = caseIfcProduct(ifcStructuralSurfaceReaction);
			if (result == null)
				result = caseIfcObject(ifcStructuralSurfaceReaction);
			if (result == null)
				result = caseIfcProductSelect(ifcStructuralSurfaceReaction);
			if (result == null)
				result = caseIfcObjectDefinition(ifcStructuralSurfaceReaction);
			if (result == null)
				result = caseIfcRoot(ifcStructuralSurfaceReaction);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcStructuralSurfaceReaction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STYLE_MODEL: {
			IfcStyleModel ifcStyleModel = (IfcStyleModel) theEObject;
			T result = caseIfcStyleModel(ifcStyleModel);
			if (result == null)
				result = caseIfcRepresentation(ifcStyleModel);
			if (result == null)
				result = caseIfcLayeredItem(ifcStyleModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STYLED_ITEM: {
			IfcStyledItem ifcStyledItem = (IfcStyledItem) theEObject;
			T result = caseIfcStyledItem(ifcStyledItem);
			if (result == null)
				result = caseIfcRepresentationItem(ifcStyledItem);
			if (result == null)
				result = caseIfcLayeredItem(ifcStyledItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STYLED_REPRESENTATION: {
			IfcStyledRepresentation ifcStyledRepresentation = (IfcStyledRepresentation) theEObject;
			T result = caseIfcStyledRepresentation(ifcStyledRepresentation);
			if (result == null)
				result = caseIfcStyleModel(ifcStyledRepresentation);
			if (result == null)
				result = caseIfcRepresentation(ifcStyledRepresentation);
			if (result == null)
				result = caseIfcLayeredItem(ifcStyledRepresentation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SUB_CONTRACT_RESOURCE: {
			IfcSubContractResource ifcSubContractResource = (IfcSubContractResource) theEObject;
			T result = caseIfcSubContractResource(ifcSubContractResource);
			if (result == null)
				result = caseIfcConstructionResource(ifcSubContractResource);
			if (result == null)
				result = caseIfcResource(ifcSubContractResource);
			if (result == null)
				result = caseIfcObject(ifcSubContractResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcSubContractResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSubContractResource);
			if (result == null)
				result = caseIfcRoot(ifcSubContractResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSubContractResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SUB_CONTRACT_RESOURCE_TYPE: {
			IfcSubContractResourceType ifcSubContractResourceType = (IfcSubContractResourceType) theEObject;
			T result = caseIfcSubContractResourceType(ifcSubContractResourceType);
			if (result == null)
				result = caseIfcConstructionResourceType(ifcSubContractResourceType);
			if (result == null)
				result = caseIfcTypeResource(ifcSubContractResourceType);
			if (result == null)
				result = caseIfcTypeObject(ifcSubContractResourceType);
			if (result == null)
				result = caseIfcResourceSelect(ifcSubContractResourceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSubContractResourceType);
			if (result == null)
				result = caseIfcRoot(ifcSubContractResourceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSubContractResourceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SUBEDGE: {
			IfcSubedge ifcSubedge = (IfcSubedge) theEObject;
			T result = caseIfcSubedge(ifcSubedge);
			if (result == null)
				result = caseIfcEdge(ifcSubedge);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcSubedge);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSubedge);
			if (result == null)
				result = caseIfcLayeredItem(ifcSubedge);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE: {
			IfcSurface ifcSurface = (IfcSurface) theEObject;
			T result = caseIfcSurface(ifcSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_CURVE: {
			IfcSurfaceCurve ifcSurfaceCurve = (IfcSurfaceCurve) theEObject;
			T result = caseIfcSurfaceCurve(ifcSurfaceCurve);
			if (result == null)
				result = caseIfcCurve(ifcSurfaceCurve);
			if (result == null)
				result = caseIfcCurveOnSurface(ifcSurfaceCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSurfaceCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcSurfaceCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSurfaceCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcSurfaceCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_CURVE_SWEPT_AREA_SOLID: {
			IfcSurfaceCurveSweptAreaSolid ifcSurfaceCurveSweptAreaSolid = (IfcSurfaceCurveSweptAreaSolid) theEObject;
			T result = caseIfcSurfaceCurveSweptAreaSolid(ifcSurfaceCurveSweptAreaSolid);
			if (result == null)
				result = caseIfcSweptAreaSolid(ifcSurfaceCurveSweptAreaSolid);
			if (result == null)
				result = caseIfcSolidModel(ifcSurfaceCurveSweptAreaSolid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSurfaceCurveSweptAreaSolid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcSurfaceCurveSweptAreaSolid);
			if (result == null)
				result = caseIfcSolidOrShell(ifcSurfaceCurveSweptAreaSolid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSurfaceCurveSweptAreaSolid);
			if (result == null)
				result = caseIfcLayeredItem(ifcSurfaceCurveSweptAreaSolid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_FEATURE: {
			IfcSurfaceFeature ifcSurfaceFeature = (IfcSurfaceFeature) theEObject;
			T result = caseIfcSurfaceFeature(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcFeatureElement(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcElement(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcProduct(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcObject(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcProductSelect(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcRoot(ifcSurfaceFeature);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSurfaceFeature);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_OF_LINEAR_EXTRUSION: {
			IfcSurfaceOfLinearExtrusion ifcSurfaceOfLinearExtrusion = (IfcSurfaceOfLinearExtrusion) theEObject;
			T result = caseIfcSurfaceOfLinearExtrusion(ifcSurfaceOfLinearExtrusion);
			if (result == null)
				result = caseIfcSweptSurface(ifcSurfaceOfLinearExtrusion);
			if (result == null)
				result = caseIfcSurface(ifcSurfaceOfLinearExtrusion);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSurfaceOfLinearExtrusion);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcSurfaceOfLinearExtrusion);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcSurfaceOfLinearExtrusion);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSurfaceOfLinearExtrusion);
			if (result == null)
				result = caseIfcLayeredItem(ifcSurfaceOfLinearExtrusion);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_OF_REVOLUTION: {
			IfcSurfaceOfRevolution ifcSurfaceOfRevolution = (IfcSurfaceOfRevolution) theEObject;
			T result = caseIfcSurfaceOfRevolution(ifcSurfaceOfRevolution);
			if (result == null)
				result = caseIfcSweptSurface(ifcSurfaceOfRevolution);
			if (result == null)
				result = caseIfcSurface(ifcSurfaceOfRevolution);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSurfaceOfRevolution);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcSurfaceOfRevolution);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcSurfaceOfRevolution);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSurfaceOfRevolution);
			if (result == null)
				result = caseIfcLayeredItem(ifcSurfaceOfRevolution);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_REINFORCEMENT_AREA: {
			IfcSurfaceReinforcementArea ifcSurfaceReinforcementArea = (IfcSurfaceReinforcementArea) theEObject;
			T result = caseIfcSurfaceReinforcementArea(ifcSurfaceReinforcementArea);
			if (result == null)
				result = caseIfcStructuralLoadOrResult(ifcSurfaceReinforcementArea);
			if (result == null)
				result = caseIfcStructuralLoad(ifcSurfaceReinforcementArea);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_STYLE: {
			IfcSurfaceStyle ifcSurfaceStyle = (IfcSurfaceStyle) theEObject;
			T result = caseIfcSurfaceStyle(ifcSurfaceStyle);
			if (result == null)
				result = caseIfcPresentationStyle(ifcSurfaceStyle);
			if (result == null)
				result = caseIfcPresentationStyleSelect(ifcSurfaceStyle);
			if (result == null)
				result = caseIfcStyleAssignmentSelect(ifcSurfaceStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_STYLE_LIGHTING: {
			IfcSurfaceStyleLighting ifcSurfaceStyleLighting = (IfcSurfaceStyleLighting) theEObject;
			T result = caseIfcSurfaceStyleLighting(ifcSurfaceStyleLighting);
			if (result == null)
				result = caseIfcPresentationItem(ifcSurfaceStyleLighting);
			if (result == null)
				result = caseIfcSurfaceStyleElementSelect(ifcSurfaceStyleLighting);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_STYLE_REFRACTION: {
			IfcSurfaceStyleRefraction ifcSurfaceStyleRefraction = (IfcSurfaceStyleRefraction) theEObject;
			T result = caseIfcSurfaceStyleRefraction(ifcSurfaceStyleRefraction);
			if (result == null)
				result = caseIfcPresentationItem(ifcSurfaceStyleRefraction);
			if (result == null)
				result = caseIfcSurfaceStyleElementSelect(ifcSurfaceStyleRefraction);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_STYLE_RENDERING: {
			IfcSurfaceStyleRendering ifcSurfaceStyleRendering = (IfcSurfaceStyleRendering) theEObject;
			T result = caseIfcSurfaceStyleRendering(ifcSurfaceStyleRendering);
			if (result == null)
				result = caseIfcSurfaceStyleShading(ifcSurfaceStyleRendering);
			if (result == null)
				result = caseIfcPresentationItem(ifcSurfaceStyleRendering);
			if (result == null)
				result = caseIfcSurfaceStyleElementSelect(ifcSurfaceStyleRendering);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_STYLE_SHADING: {
			IfcSurfaceStyleShading ifcSurfaceStyleShading = (IfcSurfaceStyleShading) theEObject;
			T result = caseIfcSurfaceStyleShading(ifcSurfaceStyleShading);
			if (result == null)
				result = caseIfcPresentationItem(ifcSurfaceStyleShading);
			if (result == null)
				result = caseIfcSurfaceStyleElementSelect(ifcSurfaceStyleShading);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_STYLE_WITH_TEXTURES: {
			IfcSurfaceStyleWithTextures ifcSurfaceStyleWithTextures = (IfcSurfaceStyleWithTextures) theEObject;
			T result = caseIfcSurfaceStyleWithTextures(ifcSurfaceStyleWithTextures);
			if (result == null)
				result = caseIfcPresentationItem(ifcSurfaceStyleWithTextures);
			if (result == null)
				result = caseIfcSurfaceStyleElementSelect(ifcSurfaceStyleWithTextures);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_TEXTURE: {
			IfcSurfaceTexture ifcSurfaceTexture = (IfcSurfaceTexture) theEObject;
			T result = caseIfcSurfaceTexture(ifcSurfaceTexture);
			if (result == null)
				result = caseIfcPresentationItem(ifcSurfaceTexture);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SWEPT_AREA_SOLID: {
			IfcSweptAreaSolid ifcSweptAreaSolid = (IfcSweptAreaSolid) theEObject;
			T result = caseIfcSweptAreaSolid(ifcSweptAreaSolid);
			if (result == null)
				result = caseIfcSolidModel(ifcSweptAreaSolid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSweptAreaSolid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcSweptAreaSolid);
			if (result == null)
				result = caseIfcSolidOrShell(ifcSweptAreaSolid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSweptAreaSolid);
			if (result == null)
				result = caseIfcLayeredItem(ifcSweptAreaSolid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SWEPT_DISK_SOLID: {
			IfcSweptDiskSolid ifcSweptDiskSolid = (IfcSweptDiskSolid) theEObject;
			T result = caseIfcSweptDiskSolid(ifcSweptDiskSolid);
			if (result == null)
				result = caseIfcSolidModel(ifcSweptDiskSolid);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSweptDiskSolid);
			if (result == null)
				result = caseIfcBooleanOperand(ifcSweptDiskSolid);
			if (result == null)
				result = caseIfcSolidOrShell(ifcSweptDiskSolid);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSweptDiskSolid);
			if (result == null)
				result = caseIfcLayeredItem(ifcSweptDiskSolid);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SWEPT_DISK_SOLID_POLYGONAL: {
			IfcSweptDiskSolidPolygonal ifcSweptDiskSolidPolygonal = (IfcSweptDiskSolidPolygonal) theEObject;
			T result = caseIfcSweptDiskSolidPolygonal(ifcSweptDiskSolidPolygonal);
			if (result == null)
				result = caseIfcSweptDiskSolid(ifcSweptDiskSolidPolygonal);
			if (result == null)
				result = caseIfcSolidModel(ifcSweptDiskSolidPolygonal);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSweptDiskSolidPolygonal);
			if (result == null)
				result = caseIfcBooleanOperand(ifcSweptDiskSolidPolygonal);
			if (result == null)
				result = caseIfcSolidOrShell(ifcSweptDiskSolidPolygonal);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSweptDiskSolidPolygonal);
			if (result == null)
				result = caseIfcLayeredItem(ifcSweptDiskSolidPolygonal);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SWEPT_SURFACE: {
			IfcSweptSurface ifcSweptSurface = (IfcSweptSurface) theEObject;
			T result = caseIfcSweptSurface(ifcSweptSurface);
			if (result == null)
				result = caseIfcSurface(ifcSweptSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcSweptSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcSweptSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcSweptSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcSweptSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcSweptSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SWITCHING_DEVICE: {
			IfcSwitchingDevice ifcSwitchingDevice = (IfcSwitchingDevice) theEObject;
			T result = caseIfcSwitchingDevice(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcFlowController(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcDistributionElement(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcElement(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcProduct(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcObject(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcProductSelect(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcRoot(ifcSwitchingDevice);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSwitchingDevice);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SWITCHING_DEVICE_TYPE: {
			IfcSwitchingDeviceType ifcSwitchingDeviceType = (IfcSwitchingDeviceType) theEObject;
			T result = caseIfcSwitchingDeviceType(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcFlowControllerType(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcElementType(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcTypeObject(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcProductSelect(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcRoot(ifcSwitchingDeviceType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSwitchingDeviceType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SYSTEM: {
			IfcSystem ifcSystem = (IfcSystem) theEObject;
			T result = caseIfcSystem(ifcSystem);
			if (result == null)
				result = caseIfcGroup(ifcSystem);
			if (result == null)
				result = caseIfcObject(ifcSystem);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSystem);
			if (result == null)
				result = caseIfcRoot(ifcSystem);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSystem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SYSTEM_FURNITURE_ELEMENT: {
			IfcSystemFurnitureElement ifcSystemFurnitureElement = (IfcSystemFurnitureElement) theEObject;
			T result = caseIfcSystemFurnitureElement(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcFurnishingElement(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcElement(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcProduct(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcObject(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcProductSelect(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcRoot(ifcSystemFurnitureElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSystemFurnitureElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SYSTEM_FURNITURE_ELEMENT_TYPE: {
			IfcSystemFurnitureElementType ifcSystemFurnitureElementType = (IfcSystemFurnitureElementType) theEObject;
			T result = caseIfcSystemFurnitureElementType(ifcSystemFurnitureElementType);
			if (result == null)
				result = caseIfcFurnishingElementType(ifcSystemFurnitureElementType);
			if (result == null)
				result = caseIfcElementType(ifcSystemFurnitureElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcSystemFurnitureElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcSystemFurnitureElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcSystemFurnitureElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcSystemFurnitureElementType);
			if (result == null)
				result = caseIfcRoot(ifcSystemFurnitureElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcSystemFurnitureElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TSHAPE_PROFILE_DEF: {
			IfcTShapeProfileDef ifcTShapeProfileDef = (IfcTShapeProfileDef) theEObject;
			T result = caseIfcTShapeProfileDef(ifcTShapeProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcTShapeProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcTShapeProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcTShapeProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TABLE: {
			IfcTable ifcTable = (IfcTable) theEObject;
			T result = caseIfcTable(ifcTable);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcTable);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcTable);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TABLE_COLUMN: {
			IfcTableColumn ifcTableColumn = (IfcTableColumn) theEObject;
			T result = caseIfcTableColumn(ifcTableColumn);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TABLE_ROW: {
			IfcTableRow ifcTableRow = (IfcTableRow) theEObject;
			T result = caseIfcTableRow(ifcTableRow);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TANK: {
			IfcTank ifcTank = (IfcTank) theEObject;
			T result = caseIfcTank(ifcTank);
			if (result == null)
				result = caseIfcFlowStorageDevice(ifcTank);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcTank);
			if (result == null)
				result = caseIfcDistributionElement(ifcTank);
			if (result == null)
				result = caseIfcElement(ifcTank);
			if (result == null)
				result = caseIfcProduct(ifcTank);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcTank);
			if (result == null)
				result = caseIfcObject(ifcTank);
			if (result == null)
				result = caseIfcProductSelect(ifcTank);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTank);
			if (result == null)
				result = caseIfcRoot(ifcTank);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTank);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TANK_TYPE: {
			IfcTankType ifcTankType = (IfcTankType) theEObject;
			T result = caseIfcTankType(ifcTankType);
			if (result == null)
				result = caseIfcFlowStorageDeviceType(ifcTankType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcTankType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcTankType);
			if (result == null)
				result = caseIfcElementType(ifcTankType);
			if (result == null)
				result = caseIfcTypeProduct(ifcTankType);
			if (result == null)
				result = caseIfcTypeObject(ifcTankType);
			if (result == null)
				result = caseIfcProductSelect(ifcTankType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTankType);
			if (result == null)
				result = caseIfcRoot(ifcTankType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTankType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TASK: {
			IfcTask ifcTask = (IfcTask) theEObject;
			T result = caseIfcTask(ifcTask);
			if (result == null)
				result = caseIfcProcess(ifcTask);
			if (result == null)
				result = caseIfcObject(ifcTask);
			if (result == null)
				result = caseIfcProcessSelect(ifcTask);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTask);
			if (result == null)
				result = caseIfcRoot(ifcTask);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTask);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TASK_TIME: {
			IfcTaskTime ifcTaskTime = (IfcTaskTime) theEObject;
			T result = caseIfcTaskTime(ifcTaskTime);
			if (result == null)
				result = caseIfcSchedulingTime(ifcTaskTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TASK_TIME_RECURRING: {
			IfcTaskTimeRecurring ifcTaskTimeRecurring = (IfcTaskTimeRecurring) theEObject;
			T result = caseIfcTaskTimeRecurring(ifcTaskTimeRecurring);
			if (result == null)
				result = caseIfcTaskTime(ifcTaskTimeRecurring);
			if (result == null)
				result = caseIfcSchedulingTime(ifcTaskTimeRecurring);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TASK_TYPE: {
			IfcTaskType ifcTaskType = (IfcTaskType) theEObject;
			T result = caseIfcTaskType(ifcTaskType);
			if (result == null)
				result = caseIfcTypeProcess(ifcTaskType);
			if (result == null)
				result = caseIfcTypeObject(ifcTaskType);
			if (result == null)
				result = caseIfcProcessSelect(ifcTaskType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTaskType);
			if (result == null)
				result = caseIfcRoot(ifcTaskType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTaskType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TELECOM_ADDRESS: {
			IfcTelecomAddress ifcTelecomAddress = (IfcTelecomAddress) theEObject;
			T result = caseIfcTelecomAddress(ifcTelecomAddress);
			if (result == null)
				result = caseIfcAddress(ifcTelecomAddress);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcTelecomAddress);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TENDON: {
			IfcTendon ifcTendon = (IfcTendon) theEObject;
			T result = caseIfcTendon(ifcTendon);
			if (result == null)
				result = caseIfcReinforcingElement(ifcTendon);
			if (result == null)
				result = caseIfcElementComponent(ifcTendon);
			if (result == null)
				result = caseIfcElement(ifcTendon);
			if (result == null)
				result = caseIfcProduct(ifcTendon);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcTendon);
			if (result == null)
				result = caseIfcObject(ifcTendon);
			if (result == null)
				result = caseIfcProductSelect(ifcTendon);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTendon);
			if (result == null)
				result = caseIfcRoot(ifcTendon);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTendon);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TENDON_ANCHOR: {
			IfcTendonAnchor ifcTendonAnchor = (IfcTendonAnchor) theEObject;
			T result = caseIfcTendonAnchor(ifcTendonAnchor);
			if (result == null)
				result = caseIfcReinforcingElement(ifcTendonAnchor);
			if (result == null)
				result = caseIfcElementComponent(ifcTendonAnchor);
			if (result == null)
				result = caseIfcElement(ifcTendonAnchor);
			if (result == null)
				result = caseIfcProduct(ifcTendonAnchor);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcTendonAnchor);
			if (result == null)
				result = caseIfcObject(ifcTendonAnchor);
			if (result == null)
				result = caseIfcProductSelect(ifcTendonAnchor);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTendonAnchor);
			if (result == null)
				result = caseIfcRoot(ifcTendonAnchor);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTendonAnchor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TENDON_ANCHOR_TYPE: {
			IfcTendonAnchorType ifcTendonAnchorType = (IfcTendonAnchorType) theEObject;
			T result = caseIfcTendonAnchorType(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcReinforcingElementType(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcElementComponentType(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcElementType(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcTypeObject(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcProductSelect(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcRoot(ifcTendonAnchorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTendonAnchorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TENDON_TYPE: {
			IfcTendonType ifcTendonType = (IfcTendonType) theEObject;
			T result = caseIfcTendonType(ifcTendonType);
			if (result == null)
				result = caseIfcReinforcingElementType(ifcTendonType);
			if (result == null)
				result = caseIfcElementComponentType(ifcTendonType);
			if (result == null)
				result = caseIfcElementType(ifcTendonType);
			if (result == null)
				result = caseIfcTypeProduct(ifcTendonType);
			if (result == null)
				result = caseIfcTypeObject(ifcTendonType);
			if (result == null)
				result = caseIfcProductSelect(ifcTendonType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTendonType);
			if (result == null)
				result = caseIfcRoot(ifcTendonType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTendonType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TESSELLATED_FACE_SET: {
			IfcTessellatedFaceSet ifcTessellatedFaceSet = (IfcTessellatedFaceSet) theEObject;
			T result = caseIfcTessellatedFaceSet(ifcTessellatedFaceSet);
			if (result == null)
				result = caseIfcTessellatedItem(ifcTessellatedFaceSet);
			if (result == null)
				result = caseIfcBooleanOperand(ifcTessellatedFaceSet);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcTessellatedFaceSet);
			if (result == null)
				result = caseIfcRepresentationItem(ifcTessellatedFaceSet);
			if (result == null)
				result = caseIfcLayeredItem(ifcTessellatedFaceSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TESSELLATED_ITEM: {
			IfcTessellatedItem ifcTessellatedItem = (IfcTessellatedItem) theEObject;
			T result = caseIfcTessellatedItem(ifcTessellatedItem);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcTessellatedItem);
			if (result == null)
				result = caseIfcRepresentationItem(ifcTessellatedItem);
			if (result == null)
				result = caseIfcLayeredItem(ifcTessellatedItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_LITERAL: {
			IfcTextLiteral ifcTextLiteral = (IfcTextLiteral) theEObject;
			T result = caseIfcTextLiteral(ifcTextLiteral);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcTextLiteral);
			if (result == null)
				result = caseIfcRepresentationItem(ifcTextLiteral);
			if (result == null)
				result = caseIfcLayeredItem(ifcTextLiteral);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_LITERAL_WITH_EXTENT: {
			IfcTextLiteralWithExtent ifcTextLiteralWithExtent = (IfcTextLiteralWithExtent) theEObject;
			T result = caseIfcTextLiteralWithExtent(ifcTextLiteralWithExtent);
			if (result == null)
				result = caseIfcTextLiteral(ifcTextLiteralWithExtent);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcTextLiteralWithExtent);
			if (result == null)
				result = caseIfcRepresentationItem(ifcTextLiteralWithExtent);
			if (result == null)
				result = caseIfcLayeredItem(ifcTextLiteralWithExtent);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_STYLE: {
			IfcTextStyle ifcTextStyle = (IfcTextStyle) theEObject;
			T result = caseIfcTextStyle(ifcTextStyle);
			if (result == null)
				result = caseIfcPresentationStyle(ifcTextStyle);
			if (result == null)
				result = caseIfcPresentationStyleSelect(ifcTextStyle);
			if (result == null)
				result = caseIfcStyleAssignmentSelect(ifcTextStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_STYLE_FONT_MODEL: {
			IfcTextStyleFontModel ifcTextStyleFontModel = (IfcTextStyleFontModel) theEObject;
			T result = caseIfcTextStyleFontModel(ifcTextStyleFontModel);
			if (result == null)
				result = caseIfcPreDefinedTextFont(ifcTextStyleFontModel);
			if (result == null)
				result = caseIfcPreDefinedItem(ifcTextStyleFontModel);
			if (result == null)
				result = caseIfcTextFontSelect(ifcTextStyleFontModel);
			if (result == null)
				result = caseIfcPresentationItem(ifcTextStyleFontModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_STYLE_FOR_DEFINED_FONT: {
			IfcTextStyleForDefinedFont ifcTextStyleForDefinedFont = (IfcTextStyleForDefinedFont) theEObject;
			T result = caseIfcTextStyleForDefinedFont(ifcTextStyleForDefinedFont);
			if (result == null)
				result = caseIfcPresentationItem(ifcTextStyleForDefinedFont);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_STYLE_TEXT_MODEL: {
			IfcTextStyleTextModel ifcTextStyleTextModel = (IfcTextStyleTextModel) theEObject;
			T result = caseIfcTextStyleTextModel(ifcTextStyleTextModel);
			if (result == null)
				result = caseIfcPresentationItem(ifcTextStyleTextModel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXTURE_COORDINATE: {
			IfcTextureCoordinate ifcTextureCoordinate = (IfcTextureCoordinate) theEObject;
			T result = caseIfcTextureCoordinate(ifcTextureCoordinate);
			if (result == null)
				result = caseIfcPresentationItem(ifcTextureCoordinate);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXTURE_COORDINATE_GENERATOR: {
			IfcTextureCoordinateGenerator ifcTextureCoordinateGenerator = (IfcTextureCoordinateGenerator) theEObject;
			T result = caseIfcTextureCoordinateGenerator(ifcTextureCoordinateGenerator);
			if (result == null)
				result = caseIfcTextureCoordinate(ifcTextureCoordinateGenerator);
			if (result == null)
				result = caseIfcPresentationItem(ifcTextureCoordinateGenerator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXTURE_MAP: {
			IfcTextureMap ifcTextureMap = (IfcTextureMap) theEObject;
			T result = caseIfcTextureMap(ifcTextureMap);
			if (result == null)
				result = caseIfcTextureCoordinate(ifcTextureMap);
			if (result == null)
				result = caseIfcPresentationItem(ifcTextureMap);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXTURE_VERTEX: {
			IfcTextureVertex ifcTextureVertex = (IfcTextureVertex) theEObject;
			T result = caseIfcTextureVertex(ifcTextureVertex);
			if (result == null)
				result = caseIfcPresentationItem(ifcTextureVertex);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXTURE_VERTEX_LIST: {
			IfcTextureVertexList ifcTextureVertexList = (IfcTextureVertexList) theEObject;
			T result = caseIfcTextureVertexList(ifcTextureVertexList);
			if (result == null)
				result = caseIfcPresentationItem(ifcTextureVertexList);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TIME_PERIOD: {
			IfcTimePeriod ifcTimePeriod = (IfcTimePeriod) theEObject;
			T result = caseIfcTimePeriod(ifcTimePeriod);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TIME_SERIES: {
			IfcTimeSeries ifcTimeSeries = (IfcTimeSeries) theEObject;
			T result = caseIfcTimeSeries(ifcTimeSeries);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcTimeSeries);
			if (result == null)
				result = caseIfcObjectReferenceSelect(ifcTimeSeries);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcTimeSeries);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TIME_SERIES_VALUE: {
			IfcTimeSeriesValue ifcTimeSeriesValue = (IfcTimeSeriesValue) theEObject;
			T result = caseIfcTimeSeriesValue(ifcTimeSeriesValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TOPOLOGICAL_REPRESENTATION_ITEM: {
			IfcTopologicalRepresentationItem ifcTopologicalRepresentationItem = (IfcTopologicalRepresentationItem) theEObject;
			T result = caseIfcTopologicalRepresentationItem(ifcTopologicalRepresentationItem);
			if (result == null)
				result = caseIfcRepresentationItem(ifcTopologicalRepresentationItem);
			if (result == null)
				result = caseIfcLayeredItem(ifcTopologicalRepresentationItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TOPOLOGY_REPRESENTATION: {
			IfcTopologyRepresentation ifcTopologyRepresentation = (IfcTopologyRepresentation) theEObject;
			T result = caseIfcTopologyRepresentation(ifcTopologyRepresentation);
			if (result == null)
				result = caseIfcShapeModel(ifcTopologyRepresentation);
			if (result == null)
				result = caseIfcRepresentation(ifcTopologyRepresentation);
			if (result == null)
				result = caseIfcLayeredItem(ifcTopologyRepresentation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TOROIDAL_SURFACE: {
			IfcToroidalSurface ifcToroidalSurface = (IfcToroidalSurface) theEObject;
			T result = caseIfcToroidalSurface(ifcToroidalSurface);
			if (result == null)
				result = caseIfcElementarySurface(ifcToroidalSurface);
			if (result == null)
				result = caseIfcSurface(ifcToroidalSurface);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcToroidalSurface);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcToroidalSurface);
			if (result == null)
				result = caseIfcSurfaceOrFaceSurface(ifcToroidalSurface);
			if (result == null)
				result = caseIfcRepresentationItem(ifcToroidalSurface);
			if (result == null)
				result = caseIfcLayeredItem(ifcToroidalSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRANSFORMER: {
			IfcTransformer ifcTransformer = (IfcTransformer) theEObject;
			T result = caseIfcTransformer(ifcTransformer);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcTransformer);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcTransformer);
			if (result == null)
				result = caseIfcDistributionElement(ifcTransformer);
			if (result == null)
				result = caseIfcElement(ifcTransformer);
			if (result == null)
				result = caseIfcProduct(ifcTransformer);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcTransformer);
			if (result == null)
				result = caseIfcObject(ifcTransformer);
			if (result == null)
				result = caseIfcProductSelect(ifcTransformer);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTransformer);
			if (result == null)
				result = caseIfcRoot(ifcTransformer);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTransformer);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRANSFORMER_TYPE: {
			IfcTransformerType ifcTransformerType = (IfcTransformerType) theEObject;
			T result = caseIfcTransformerType(ifcTransformerType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcTransformerType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcTransformerType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcTransformerType);
			if (result == null)
				result = caseIfcElementType(ifcTransformerType);
			if (result == null)
				result = caseIfcTypeProduct(ifcTransformerType);
			if (result == null)
				result = caseIfcTypeObject(ifcTransformerType);
			if (result == null)
				result = caseIfcProductSelect(ifcTransformerType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTransformerType);
			if (result == null)
				result = caseIfcRoot(ifcTransformerType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTransformerType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRANSPORT_ELEMENT: {
			IfcTransportElement ifcTransportElement = (IfcTransportElement) theEObject;
			T result = caseIfcTransportElement(ifcTransportElement);
			if (result == null)
				result = caseIfcElement(ifcTransportElement);
			if (result == null)
				result = caseIfcProduct(ifcTransportElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcTransportElement);
			if (result == null)
				result = caseIfcObject(ifcTransportElement);
			if (result == null)
				result = caseIfcProductSelect(ifcTransportElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTransportElement);
			if (result == null)
				result = caseIfcRoot(ifcTransportElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTransportElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRANSPORT_ELEMENT_TYPE: {
			IfcTransportElementType ifcTransportElementType = (IfcTransportElementType) theEObject;
			T result = caseIfcTransportElementType(ifcTransportElementType);
			if (result == null)
				result = caseIfcElementType(ifcTransportElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcTransportElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcTransportElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcTransportElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTransportElementType);
			if (result == null)
				result = caseIfcRoot(ifcTransportElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTransportElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRAPEZIUM_PROFILE_DEF: {
			IfcTrapeziumProfileDef ifcTrapeziumProfileDef = (IfcTrapeziumProfileDef) theEObject;
			T result = caseIfcTrapeziumProfileDef(ifcTrapeziumProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcTrapeziumProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcTrapeziumProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcTrapeziumProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRIANGULATED_FACE_SET: {
			IfcTriangulatedFaceSet ifcTriangulatedFaceSet = (IfcTriangulatedFaceSet) theEObject;
			T result = caseIfcTriangulatedFaceSet(ifcTriangulatedFaceSet);
			if (result == null)
				result = caseIfcTessellatedFaceSet(ifcTriangulatedFaceSet);
			if (result == null)
				result = caseIfcTessellatedItem(ifcTriangulatedFaceSet);
			if (result == null)
				result = caseIfcBooleanOperand(ifcTriangulatedFaceSet);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcTriangulatedFaceSet);
			if (result == null)
				result = caseIfcRepresentationItem(ifcTriangulatedFaceSet);
			if (result == null)
				result = caseIfcLayeredItem(ifcTriangulatedFaceSet);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRIMMED_CURVE: {
			IfcTrimmedCurve ifcTrimmedCurve = (IfcTrimmedCurve) theEObject;
			T result = caseIfcTrimmedCurve(ifcTrimmedCurve);
			if (result == null)
				result = caseIfcBoundedCurve(ifcTrimmedCurve);
			if (result == null)
				result = caseIfcCurve(ifcTrimmedCurve);
			if (result == null)
				result = caseIfcCurveOrEdgeCurve(ifcTrimmedCurve);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcTrimmedCurve);
			if (result == null)
				result = caseIfcGeometricSetSelect(ifcTrimmedCurve);
			if (result == null)
				result = caseIfcRepresentationItem(ifcTrimmedCurve);
			if (result == null)
				result = caseIfcLayeredItem(ifcTrimmedCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TUBE_BUNDLE: {
			IfcTubeBundle ifcTubeBundle = (IfcTubeBundle) theEObject;
			T result = caseIfcTubeBundle(ifcTubeBundle);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcTubeBundle);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcTubeBundle);
			if (result == null)
				result = caseIfcDistributionElement(ifcTubeBundle);
			if (result == null)
				result = caseIfcElement(ifcTubeBundle);
			if (result == null)
				result = caseIfcProduct(ifcTubeBundle);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcTubeBundle);
			if (result == null)
				result = caseIfcObject(ifcTubeBundle);
			if (result == null)
				result = caseIfcProductSelect(ifcTubeBundle);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTubeBundle);
			if (result == null)
				result = caseIfcRoot(ifcTubeBundle);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTubeBundle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TUBE_BUNDLE_TYPE: {
			IfcTubeBundleType ifcTubeBundleType = (IfcTubeBundleType) theEObject;
			T result = caseIfcTubeBundleType(ifcTubeBundleType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcTubeBundleType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcTubeBundleType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcTubeBundleType);
			if (result == null)
				result = caseIfcElementType(ifcTubeBundleType);
			if (result == null)
				result = caseIfcTypeProduct(ifcTubeBundleType);
			if (result == null)
				result = caseIfcTypeObject(ifcTubeBundleType);
			if (result == null)
				result = caseIfcProductSelect(ifcTubeBundleType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTubeBundleType);
			if (result == null)
				result = caseIfcRoot(ifcTubeBundleType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTubeBundleType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TYPE_OBJECT: {
			IfcTypeObject ifcTypeObject = (IfcTypeObject) theEObject;
			T result = caseIfcTypeObject(ifcTypeObject);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTypeObject);
			if (result == null)
				result = caseIfcRoot(ifcTypeObject);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTypeObject);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TYPE_PROCESS: {
			IfcTypeProcess ifcTypeProcess = (IfcTypeProcess) theEObject;
			T result = caseIfcTypeProcess(ifcTypeProcess);
			if (result == null)
				result = caseIfcTypeObject(ifcTypeProcess);
			if (result == null)
				result = caseIfcProcessSelect(ifcTypeProcess);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTypeProcess);
			if (result == null)
				result = caseIfcRoot(ifcTypeProcess);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTypeProcess);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TYPE_PRODUCT: {
			IfcTypeProduct ifcTypeProduct = (IfcTypeProduct) theEObject;
			T result = caseIfcTypeProduct(ifcTypeProduct);
			if (result == null)
				result = caseIfcTypeObject(ifcTypeProduct);
			if (result == null)
				result = caseIfcProductSelect(ifcTypeProduct);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTypeProduct);
			if (result == null)
				result = caseIfcRoot(ifcTypeProduct);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTypeProduct);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TYPE_RESOURCE: {
			IfcTypeResource ifcTypeResource = (IfcTypeResource) theEObject;
			T result = caseIfcTypeResource(ifcTypeResource);
			if (result == null)
				result = caseIfcTypeObject(ifcTypeResource);
			if (result == null)
				result = caseIfcResourceSelect(ifcTypeResource);
			if (result == null)
				result = caseIfcObjectDefinition(ifcTypeResource);
			if (result == null)
				result = caseIfcRoot(ifcTypeResource);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcTypeResource);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_USHAPE_PROFILE_DEF: {
			IfcUShapeProfileDef ifcUShapeProfileDef = (IfcUShapeProfileDef) theEObject;
			T result = caseIfcUShapeProfileDef(ifcUShapeProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcUShapeProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcUShapeProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcUShapeProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_UNIT_ASSIGNMENT: {
			IfcUnitAssignment ifcUnitAssignment = (IfcUnitAssignment) theEObject;
			T result = caseIfcUnitAssignment(ifcUnitAssignment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_UNITARY_CONTROL_ELEMENT: {
			IfcUnitaryControlElement ifcUnitaryControlElement = (IfcUnitaryControlElement) theEObject;
			T result = caseIfcUnitaryControlElement(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcDistributionControlElement(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcDistributionElement(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcElement(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcProduct(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcObject(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcProductSelect(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcRoot(ifcUnitaryControlElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcUnitaryControlElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_UNITARY_CONTROL_ELEMENT_TYPE: {
			IfcUnitaryControlElementType ifcUnitaryControlElementType = (IfcUnitaryControlElementType) theEObject;
			T result = caseIfcUnitaryControlElementType(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcDistributionControlElementType(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcElementType(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcTypeProduct(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcTypeObject(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcProductSelect(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcRoot(ifcUnitaryControlElementType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcUnitaryControlElementType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_UNITARY_EQUIPMENT: {
			IfcUnitaryEquipment ifcUnitaryEquipment = (IfcUnitaryEquipment) theEObject;
			T result = caseIfcUnitaryEquipment(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcEnergyConversionDevice(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcDistributionElement(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcElement(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcProduct(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcObject(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcProductSelect(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcObjectDefinition(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcRoot(ifcUnitaryEquipment);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcUnitaryEquipment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_UNITARY_EQUIPMENT_TYPE: {
			IfcUnitaryEquipmentType ifcUnitaryEquipmentType = (IfcUnitaryEquipmentType) theEObject;
			T result = caseIfcUnitaryEquipmentType(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcEnergyConversionDeviceType(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcElementType(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcTypeProduct(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcTypeObject(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcProductSelect(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcRoot(ifcUnitaryEquipmentType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcUnitaryEquipmentType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VALVE: {
			IfcValve ifcValve = (IfcValve) theEObject;
			T result = caseIfcValve(ifcValve);
			if (result == null)
				result = caseIfcFlowController(ifcValve);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcValve);
			if (result == null)
				result = caseIfcDistributionElement(ifcValve);
			if (result == null)
				result = caseIfcElement(ifcValve);
			if (result == null)
				result = caseIfcProduct(ifcValve);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcValve);
			if (result == null)
				result = caseIfcObject(ifcValve);
			if (result == null)
				result = caseIfcProductSelect(ifcValve);
			if (result == null)
				result = caseIfcObjectDefinition(ifcValve);
			if (result == null)
				result = caseIfcRoot(ifcValve);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcValve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VALVE_TYPE: {
			IfcValveType ifcValveType = (IfcValveType) theEObject;
			T result = caseIfcValveType(ifcValveType);
			if (result == null)
				result = caseIfcFlowControllerType(ifcValveType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcValveType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcValveType);
			if (result == null)
				result = caseIfcElementType(ifcValveType);
			if (result == null)
				result = caseIfcTypeProduct(ifcValveType);
			if (result == null)
				result = caseIfcTypeObject(ifcValveType);
			if (result == null)
				result = caseIfcProductSelect(ifcValveType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcValveType);
			if (result == null)
				result = caseIfcRoot(ifcValveType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcValveType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VECTOR: {
			IfcVector ifcVector = (IfcVector) theEObject;
			T result = caseIfcVector(ifcVector);
			if (result == null)
				result = caseIfcGeometricRepresentationItem(ifcVector);
			if (result == null)
				result = caseIfcHatchLineDistanceSelect(ifcVector);
			if (result == null)
				result = caseIfcVectorOrDirection(ifcVector);
			if (result == null)
				result = caseIfcRepresentationItem(ifcVector);
			if (result == null)
				result = caseIfcLayeredItem(ifcVector);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VERTEX: {
			IfcVertex ifcVertex = (IfcVertex) theEObject;
			T result = caseIfcVertex(ifcVertex);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcVertex);
			if (result == null)
				result = caseIfcRepresentationItem(ifcVertex);
			if (result == null)
				result = caseIfcLayeredItem(ifcVertex);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VERTEX_LOOP: {
			IfcVertexLoop ifcVertexLoop = (IfcVertexLoop) theEObject;
			T result = caseIfcVertexLoop(ifcVertexLoop);
			if (result == null)
				result = caseIfcLoop(ifcVertexLoop);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcVertexLoop);
			if (result == null)
				result = caseIfcRepresentationItem(ifcVertexLoop);
			if (result == null)
				result = caseIfcLayeredItem(ifcVertexLoop);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VERTEX_POINT: {
			IfcVertexPoint ifcVertexPoint = (IfcVertexPoint) theEObject;
			T result = caseIfcVertexPoint(ifcVertexPoint);
			if (result == null)
				result = caseIfcVertex(ifcVertexPoint);
			if (result == null)
				result = caseIfcPointOrVertexPoint(ifcVertexPoint);
			if (result == null)
				result = caseIfcTopologicalRepresentationItem(ifcVertexPoint);
			if (result == null)
				result = caseIfcRepresentationItem(ifcVertexPoint);
			if (result == null)
				result = caseIfcLayeredItem(ifcVertexPoint);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VIBRATION_ISOLATOR: {
			IfcVibrationIsolator ifcVibrationIsolator = (IfcVibrationIsolator) theEObject;
			T result = caseIfcVibrationIsolator(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcElementComponent(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcElement(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcProduct(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcObject(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcProductSelect(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcObjectDefinition(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcRoot(ifcVibrationIsolator);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcVibrationIsolator);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VIBRATION_ISOLATOR_TYPE: {
			IfcVibrationIsolatorType ifcVibrationIsolatorType = (IfcVibrationIsolatorType) theEObject;
			T result = caseIfcVibrationIsolatorType(ifcVibrationIsolatorType);
			if (result == null)
				result = caseIfcElementComponentType(ifcVibrationIsolatorType);
			if (result == null)
				result = caseIfcElementType(ifcVibrationIsolatorType);
			if (result == null)
				result = caseIfcTypeProduct(ifcVibrationIsolatorType);
			if (result == null)
				result = caseIfcTypeObject(ifcVibrationIsolatorType);
			if (result == null)
				result = caseIfcProductSelect(ifcVibrationIsolatorType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcVibrationIsolatorType);
			if (result == null)
				result = caseIfcRoot(ifcVibrationIsolatorType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcVibrationIsolatorType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VIRTUAL_ELEMENT: {
			IfcVirtualElement ifcVirtualElement = (IfcVirtualElement) theEObject;
			T result = caseIfcVirtualElement(ifcVirtualElement);
			if (result == null)
				result = caseIfcElement(ifcVirtualElement);
			if (result == null)
				result = caseIfcProduct(ifcVirtualElement);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcVirtualElement);
			if (result == null)
				result = caseIfcObject(ifcVirtualElement);
			if (result == null)
				result = caseIfcProductSelect(ifcVirtualElement);
			if (result == null)
				result = caseIfcObjectDefinition(ifcVirtualElement);
			if (result == null)
				result = caseIfcRoot(ifcVirtualElement);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcVirtualElement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VIRTUAL_GRID_INTERSECTION: {
			IfcVirtualGridIntersection ifcVirtualGridIntersection = (IfcVirtualGridIntersection) theEObject;
			T result = caseIfcVirtualGridIntersection(ifcVirtualGridIntersection);
			if (result == null)
				result = caseIfcGridPlacementDirectionSelect(ifcVirtualGridIntersection);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VOIDING_FEATURE: {
			IfcVoidingFeature ifcVoidingFeature = (IfcVoidingFeature) theEObject;
			T result = caseIfcVoidingFeature(ifcVoidingFeature);
			if (result == null)
				result = caseIfcFeatureElementSubtraction(ifcVoidingFeature);
			if (result == null)
				result = caseIfcFeatureElement(ifcVoidingFeature);
			if (result == null)
				result = caseIfcElement(ifcVoidingFeature);
			if (result == null)
				result = caseIfcProduct(ifcVoidingFeature);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcVoidingFeature);
			if (result == null)
				result = caseIfcObject(ifcVoidingFeature);
			if (result == null)
				result = caseIfcProductSelect(ifcVoidingFeature);
			if (result == null)
				result = caseIfcObjectDefinition(ifcVoidingFeature);
			if (result == null)
				result = caseIfcRoot(ifcVoidingFeature);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcVoidingFeature);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WALL: {
			IfcWall ifcWall = (IfcWall) theEObject;
			T result = caseIfcWall(ifcWall);
			if (result == null)
				result = caseIfcBuildingElement(ifcWall);
			if (result == null)
				result = caseIfcElement(ifcWall);
			if (result == null)
				result = caseIfcProduct(ifcWall);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcWall);
			if (result == null)
				result = caseIfcObject(ifcWall);
			if (result == null)
				result = caseIfcProductSelect(ifcWall);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWall);
			if (result == null)
				result = caseIfcRoot(ifcWall);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWall);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WALL_ELEMENTED_CASE: {
			IfcWallElementedCase ifcWallElementedCase = (IfcWallElementedCase) theEObject;
			T result = caseIfcWallElementedCase(ifcWallElementedCase);
			if (result == null)
				result = caseIfcWall(ifcWallElementedCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcWallElementedCase);
			if (result == null)
				result = caseIfcElement(ifcWallElementedCase);
			if (result == null)
				result = caseIfcProduct(ifcWallElementedCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcWallElementedCase);
			if (result == null)
				result = caseIfcObject(ifcWallElementedCase);
			if (result == null)
				result = caseIfcProductSelect(ifcWallElementedCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWallElementedCase);
			if (result == null)
				result = caseIfcRoot(ifcWallElementedCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWallElementedCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WALL_STANDARD_CASE: {
			IfcWallStandardCase ifcWallStandardCase = (IfcWallStandardCase) theEObject;
			T result = caseIfcWallStandardCase(ifcWallStandardCase);
			if (result == null)
				result = caseIfcWall(ifcWallStandardCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcWallStandardCase);
			if (result == null)
				result = caseIfcElement(ifcWallStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcWallStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcWallStandardCase);
			if (result == null)
				result = caseIfcObject(ifcWallStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcWallStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWallStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcWallStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWallStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WALL_TYPE: {
			IfcWallType ifcWallType = (IfcWallType) theEObject;
			T result = caseIfcWallType(ifcWallType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcWallType);
			if (result == null)
				result = caseIfcElementType(ifcWallType);
			if (result == null)
				result = caseIfcTypeProduct(ifcWallType);
			if (result == null)
				result = caseIfcTypeObject(ifcWallType);
			if (result == null)
				result = caseIfcProductSelect(ifcWallType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWallType);
			if (result == null)
				result = caseIfcRoot(ifcWallType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWallType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WASTE_TERMINAL: {
			IfcWasteTerminal ifcWasteTerminal = (IfcWasteTerminal) theEObject;
			T result = caseIfcWasteTerminal(ifcWasteTerminal);
			if (result == null)
				result = caseIfcFlowTerminal(ifcWasteTerminal);
			if (result == null)
				result = caseIfcDistributionFlowElement(ifcWasteTerminal);
			if (result == null)
				result = caseIfcDistributionElement(ifcWasteTerminal);
			if (result == null)
				result = caseIfcElement(ifcWasteTerminal);
			if (result == null)
				result = caseIfcProduct(ifcWasteTerminal);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcWasteTerminal);
			if (result == null)
				result = caseIfcObject(ifcWasteTerminal);
			if (result == null)
				result = caseIfcProductSelect(ifcWasteTerminal);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWasteTerminal);
			if (result == null)
				result = caseIfcRoot(ifcWasteTerminal);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWasteTerminal);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WASTE_TERMINAL_TYPE: {
			IfcWasteTerminalType ifcWasteTerminalType = (IfcWasteTerminalType) theEObject;
			T result = caseIfcWasteTerminalType(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcFlowTerminalType(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcDistributionFlowElementType(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcDistributionElementType(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcElementType(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcTypeProduct(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcTypeObject(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcProductSelect(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcRoot(ifcWasteTerminalType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWasteTerminalType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WINDOW: {
			IfcWindow ifcWindow = (IfcWindow) theEObject;
			T result = caseIfcWindow(ifcWindow);
			if (result == null)
				result = caseIfcBuildingElement(ifcWindow);
			if (result == null)
				result = caseIfcElement(ifcWindow);
			if (result == null)
				result = caseIfcProduct(ifcWindow);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcWindow);
			if (result == null)
				result = caseIfcObject(ifcWindow);
			if (result == null)
				result = caseIfcProductSelect(ifcWindow);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWindow);
			if (result == null)
				result = caseIfcRoot(ifcWindow);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWindow);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WINDOW_LINING_PROPERTIES: {
			IfcWindowLiningProperties ifcWindowLiningProperties = (IfcWindowLiningProperties) theEObject;
			T result = caseIfcWindowLiningProperties(ifcWindowLiningProperties);
			if (result == null)
				result = caseIfcPreDefinedPropertySet(ifcWindowLiningProperties);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcWindowLiningProperties);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcWindowLiningProperties);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcWindowLiningProperties);
			if (result == null)
				result = caseIfcRoot(ifcWindowLiningProperties);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWindowLiningProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WINDOW_PANEL_PROPERTIES: {
			IfcWindowPanelProperties ifcWindowPanelProperties = (IfcWindowPanelProperties) theEObject;
			T result = caseIfcWindowPanelProperties(ifcWindowPanelProperties);
			if (result == null)
				result = caseIfcPreDefinedPropertySet(ifcWindowPanelProperties);
			if (result == null)
				result = caseIfcPropertySetDefinition(ifcWindowPanelProperties);
			if (result == null)
				result = caseIfcPropertyDefinition(ifcWindowPanelProperties);
			if (result == null)
				result = caseIfcPropertySetDefinitionSelect(ifcWindowPanelProperties);
			if (result == null)
				result = caseIfcRoot(ifcWindowPanelProperties);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWindowPanelProperties);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WINDOW_STANDARD_CASE: {
			IfcWindowStandardCase ifcWindowStandardCase = (IfcWindowStandardCase) theEObject;
			T result = caseIfcWindowStandardCase(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcWindow(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcBuildingElement(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcElement(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcProduct(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcStructuralActivityAssignmentSelect(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcObject(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcProductSelect(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcRoot(ifcWindowStandardCase);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWindowStandardCase);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WINDOW_STYLE: {
			IfcWindowStyle ifcWindowStyle = (IfcWindowStyle) theEObject;
			T result = caseIfcWindowStyle(ifcWindowStyle);
			if (result == null)
				result = caseIfcTypeProduct(ifcWindowStyle);
			if (result == null)
				result = caseIfcTypeObject(ifcWindowStyle);
			if (result == null)
				result = caseIfcProductSelect(ifcWindowStyle);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWindowStyle);
			if (result == null)
				result = caseIfcRoot(ifcWindowStyle);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWindowStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WINDOW_TYPE: {
			IfcWindowType ifcWindowType = (IfcWindowType) theEObject;
			T result = caseIfcWindowType(ifcWindowType);
			if (result == null)
				result = caseIfcBuildingElementType(ifcWindowType);
			if (result == null)
				result = caseIfcElementType(ifcWindowType);
			if (result == null)
				result = caseIfcTypeProduct(ifcWindowType);
			if (result == null)
				result = caseIfcTypeObject(ifcWindowType);
			if (result == null)
				result = caseIfcProductSelect(ifcWindowType);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWindowType);
			if (result == null)
				result = caseIfcRoot(ifcWindowType);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWindowType);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WORK_CALENDAR: {
			IfcWorkCalendar ifcWorkCalendar = (IfcWorkCalendar) theEObject;
			T result = caseIfcWorkCalendar(ifcWorkCalendar);
			if (result == null)
				result = caseIfcControl(ifcWorkCalendar);
			if (result == null)
				result = caseIfcObject(ifcWorkCalendar);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWorkCalendar);
			if (result == null)
				result = caseIfcRoot(ifcWorkCalendar);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWorkCalendar);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WORK_CONTROL: {
			IfcWorkControl ifcWorkControl = (IfcWorkControl) theEObject;
			T result = caseIfcWorkControl(ifcWorkControl);
			if (result == null)
				result = caseIfcControl(ifcWorkControl);
			if (result == null)
				result = caseIfcObject(ifcWorkControl);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWorkControl);
			if (result == null)
				result = caseIfcRoot(ifcWorkControl);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWorkControl);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WORK_PLAN: {
			IfcWorkPlan ifcWorkPlan = (IfcWorkPlan) theEObject;
			T result = caseIfcWorkPlan(ifcWorkPlan);
			if (result == null)
				result = caseIfcWorkControl(ifcWorkPlan);
			if (result == null)
				result = caseIfcControl(ifcWorkPlan);
			if (result == null)
				result = caseIfcObject(ifcWorkPlan);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWorkPlan);
			if (result == null)
				result = caseIfcRoot(ifcWorkPlan);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWorkPlan);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WORK_SCHEDULE: {
			IfcWorkSchedule ifcWorkSchedule = (IfcWorkSchedule) theEObject;
			T result = caseIfcWorkSchedule(ifcWorkSchedule);
			if (result == null)
				result = caseIfcWorkControl(ifcWorkSchedule);
			if (result == null)
				result = caseIfcControl(ifcWorkSchedule);
			if (result == null)
				result = caseIfcObject(ifcWorkSchedule);
			if (result == null)
				result = caseIfcObjectDefinition(ifcWorkSchedule);
			if (result == null)
				result = caseIfcRoot(ifcWorkSchedule);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcWorkSchedule);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WORK_TIME: {
			IfcWorkTime ifcWorkTime = (IfcWorkTime) theEObject;
			T result = caseIfcWorkTime(ifcWorkTime);
			if (result == null)
				result = caseIfcSchedulingTime(ifcWorkTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ZSHAPE_PROFILE_DEF: {
			IfcZShapeProfileDef ifcZShapeProfileDef = (IfcZShapeProfileDef) theEObject;
			T result = caseIfcZShapeProfileDef(ifcZShapeProfileDef);
			if (result == null)
				result = caseIfcParameterizedProfileDef(ifcZShapeProfileDef);
			if (result == null)
				result = caseIfcProfileDef(ifcZShapeProfileDef);
			if (result == null)
				result = caseIfcResourceObjectSelect(ifcZShapeProfileDef);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ZONE: {
			IfcZone ifcZone = (IfcZone) theEObject;
			T result = caseIfcZone(ifcZone);
			if (result == null)
				result = caseIfcSystem(ifcZone);
			if (result == null)
				result = caseIfcGroup(ifcZone);
			if (result == null)
				result = caseIfcObject(ifcZone);
			if (result == null)
				result = caseIfcObjectDefinition(ifcZone);
			if (result == null)
				result = caseIfcRoot(ifcZone);
			if (result == null)
				result = caseIfcDefinitionSelect(ifcZone);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRIPPED_OPTIONAL: {
			IfcStrippedOptional ifcStrippedOptional = (IfcStrippedOptional) theEObject;
			T result = caseIfcStrippedOptional(ifcStrippedOptional);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ABSORBED_DOSE_MEASURE: {
			IfcAbsorbedDoseMeasure ifcAbsorbedDoseMeasure = (IfcAbsorbedDoseMeasure) theEObject;
			T result = caseIfcAbsorbedDoseMeasure(ifcAbsorbedDoseMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcAbsorbedDoseMeasure);
			if (result == null)
				result = caseIfcValue(ifcAbsorbedDoseMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcAbsorbedDoseMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcAbsorbedDoseMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ACCELERATION_MEASURE: {
			IfcAccelerationMeasure ifcAccelerationMeasure = (IfcAccelerationMeasure) theEObject;
			T result = caseIfcAccelerationMeasure(ifcAccelerationMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcAccelerationMeasure);
			if (result == null)
				result = caseIfcValue(ifcAccelerationMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcAccelerationMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcAccelerationMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AMOUNT_OF_SUBSTANCE_MEASURE: {
			IfcAmountOfSubstanceMeasure ifcAmountOfSubstanceMeasure = (IfcAmountOfSubstanceMeasure) theEObject;
			T result = caseIfcAmountOfSubstanceMeasure(ifcAmountOfSubstanceMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcAmountOfSubstanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcAmountOfSubstanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcAmountOfSubstanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcAmountOfSubstanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ANGULAR_VELOCITY_MEASURE: {
			IfcAngularVelocityMeasure ifcAngularVelocityMeasure = (IfcAngularVelocityMeasure) theEObject;
			T result = caseIfcAngularVelocityMeasure(ifcAngularVelocityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcAngularVelocityMeasure);
			if (result == null)
				result = caseIfcValue(ifcAngularVelocityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcAngularVelocityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcAngularVelocityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AREA_DENSITY_MEASURE: {
			IfcAreaDensityMeasure ifcAreaDensityMeasure = (IfcAreaDensityMeasure) theEObject;
			T result = caseIfcAreaDensityMeasure(ifcAreaDensityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcAreaDensityMeasure);
			if (result == null)
				result = caseIfcValue(ifcAreaDensityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcAreaDensityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcAreaDensityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AREA_MEASURE: {
			IfcAreaMeasure ifcAreaMeasure = (IfcAreaMeasure) theEObject;
			T result = caseIfcAreaMeasure(ifcAreaMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcAreaMeasure);
			if (result == null)
				result = caseIfcValue(ifcAreaMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcAreaMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcAreaMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BINARY: {
			IfcBinary ifcBinary = (IfcBinary) theEObject;
			T result = caseIfcBinary(ifcBinary);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOOLEAN: {
			IfcBoolean ifcBoolean = (IfcBoolean) theEObject;
			T result = caseIfcBoolean(ifcBoolean);
			if (result == null)
				result = caseIfcModulusOfRotationalSubgradeReactionSelect(ifcBoolean);
			if (result == null)
				result = caseIfcModulusOfSubgradeReactionSelect(ifcBoolean);
			if (result == null)
				result = caseIfcModulusOfTranslationalSubgradeReactionSelect(ifcBoolean);
			if (result == null)
				result = caseIfcRotationalStiffnessSelect(ifcBoolean);
			if (result == null)
				result = caseIfcSimpleValue(ifcBoolean);
			if (result == null)
				result = caseIfcTranslationalStiffnessSelect(ifcBoolean);
			if (result == null)
				result = caseIfcWarpingStiffnessSelect(ifcBoolean);
			if (result == null)
				result = caseIfcValue(ifcBoolean);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcBoolean);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcBoolean);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CARDINAL_POINT_REFERENCE: {
			IfcCardinalPointReference ifcCardinalPointReference = (IfcCardinalPointReference) theEObject;
			T result = caseIfcCardinalPointReference(ifcCardinalPointReference);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CONTEXT_DEPENDENT_MEASURE: {
			IfcContextDependentMeasure ifcContextDependentMeasure = (IfcContextDependentMeasure) theEObject;
			T result = caseIfcContextDependentMeasure(ifcContextDependentMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcContextDependentMeasure);
			if (result == null)
				result = caseIfcValue(ifcContextDependentMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcContextDependentMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcContextDependentMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COUNT_MEASURE: {
			IfcCountMeasure ifcCountMeasure = (IfcCountMeasure) theEObject;
			T result = caseIfcCountMeasure(ifcCountMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcCountMeasure);
			if (result == null)
				result = caseIfcValue(ifcCountMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcCountMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcCountMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVATURE_MEASURE: {
			IfcCurvatureMeasure ifcCurvatureMeasure = (IfcCurvatureMeasure) theEObject;
			T result = caseIfcCurvatureMeasure(ifcCurvatureMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcCurvatureMeasure);
			if (result == null)
				result = caseIfcValue(ifcCurvatureMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcCurvatureMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcCurvatureMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DATE: {
			IfcDate ifcDate = (IfcDate) theEObject;
			T result = caseIfcDate(ifcDate);
			if (result == null)
				result = caseIfcSimpleValue(ifcDate);
			if (result == null)
				result = caseIfcValue(ifcDate);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcDate);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcDate);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DATE_TIME: {
			IfcDateTime ifcDateTime = (IfcDateTime) theEObject;
			T result = caseIfcDateTime(ifcDateTime);
			if (result == null)
				result = caseIfcSimpleValue(ifcDateTime);
			if (result == null)
				result = caseIfcValue(ifcDateTime);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcDateTime);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcDateTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DAY_IN_MONTH_NUMBER: {
			IfcDayInMonthNumber ifcDayInMonthNumber = (IfcDayInMonthNumber) theEObject;
			T result = caseIfcDayInMonthNumber(ifcDayInMonthNumber);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DAY_IN_WEEK_NUMBER: {
			IfcDayInWeekNumber ifcDayInWeekNumber = (IfcDayInWeekNumber) theEObject;
			T result = caseIfcDayInWeekNumber(ifcDayInWeekNumber);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DESCRIPTIVE_MEASURE: {
			IfcDescriptiveMeasure ifcDescriptiveMeasure = (IfcDescriptiveMeasure) theEObject;
			T result = caseIfcDescriptiveMeasure(ifcDescriptiveMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcDescriptiveMeasure);
			if (result == null)
				result = caseIfcSizeSelect(ifcDescriptiveMeasure);
			if (result == null)
				result = caseIfcValue(ifcDescriptiveMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcDescriptiveMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcDescriptiveMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DIMENSION_COUNT: {
			IfcDimensionCount ifcDimensionCount = (IfcDimensionCount) theEObject;
			T result = caseIfcDimensionCount(ifcDimensionCount);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOSE_EQUIVALENT_MEASURE: {
			IfcDoseEquivalentMeasure ifcDoseEquivalentMeasure = (IfcDoseEquivalentMeasure) theEObject;
			T result = caseIfcDoseEquivalentMeasure(ifcDoseEquivalentMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcDoseEquivalentMeasure);
			if (result == null)
				result = caseIfcValue(ifcDoseEquivalentMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcDoseEquivalentMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcDoseEquivalentMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DURATION: {
			IfcDuration ifcDuration = (IfcDuration) theEObject;
			T result = caseIfcDuration(ifcDuration);
			if (result == null)
				result = caseIfcSimpleValue(ifcDuration);
			if (result == null)
				result = caseIfcTimeOrRatioSelect(ifcDuration);
			if (result == null)
				result = caseIfcValue(ifcDuration);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcDuration);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcDuration);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DYNAMIC_VISCOSITY_MEASURE: {
			IfcDynamicViscosityMeasure ifcDynamicViscosityMeasure = (IfcDynamicViscosityMeasure) theEObject;
			T result = caseIfcDynamicViscosityMeasure(ifcDynamicViscosityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcDynamicViscosityMeasure);
			if (result == null)
				result = caseIfcValue(ifcDynamicViscosityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcDynamicViscosityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcDynamicViscosityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_CAPACITANCE_MEASURE: {
			IfcElectricCapacitanceMeasure ifcElectricCapacitanceMeasure = (IfcElectricCapacitanceMeasure) theEObject;
			T result = caseIfcElectricCapacitanceMeasure(ifcElectricCapacitanceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcElectricCapacitanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcElectricCapacitanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcElectricCapacitanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcElectricCapacitanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_CHARGE_MEASURE: {
			IfcElectricChargeMeasure ifcElectricChargeMeasure = (IfcElectricChargeMeasure) theEObject;
			T result = caseIfcElectricChargeMeasure(ifcElectricChargeMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcElectricChargeMeasure);
			if (result == null)
				result = caseIfcValue(ifcElectricChargeMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcElectricChargeMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcElectricChargeMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_CONDUCTANCE_MEASURE: {
			IfcElectricConductanceMeasure ifcElectricConductanceMeasure = (IfcElectricConductanceMeasure) theEObject;
			T result = caseIfcElectricConductanceMeasure(ifcElectricConductanceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcElectricConductanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcElectricConductanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcElectricConductanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcElectricConductanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_CURRENT_MEASURE: {
			IfcElectricCurrentMeasure ifcElectricCurrentMeasure = (IfcElectricCurrentMeasure) theEObject;
			T result = caseIfcElectricCurrentMeasure(ifcElectricCurrentMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcElectricCurrentMeasure);
			if (result == null)
				result = caseIfcValue(ifcElectricCurrentMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcElectricCurrentMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcElectricCurrentMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_RESISTANCE_MEASURE: {
			IfcElectricResistanceMeasure ifcElectricResistanceMeasure = (IfcElectricResistanceMeasure) theEObject;
			T result = caseIfcElectricResistanceMeasure(ifcElectricResistanceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcElectricResistanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcElectricResistanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcElectricResistanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcElectricResistanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ELECTRIC_VOLTAGE_MEASURE: {
			IfcElectricVoltageMeasure ifcElectricVoltageMeasure = (IfcElectricVoltageMeasure) theEObject;
			T result = caseIfcElectricVoltageMeasure(ifcElectricVoltageMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcElectricVoltageMeasure);
			if (result == null)
				result = caseIfcValue(ifcElectricVoltageMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcElectricVoltageMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcElectricVoltageMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ENERGY_MEASURE: {
			IfcEnergyMeasure ifcEnergyMeasure = (IfcEnergyMeasure) theEObject;
			T result = caseIfcEnergyMeasure(ifcEnergyMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcEnergyMeasure);
			if (result == null)
				result = caseIfcValue(ifcEnergyMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcEnergyMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcEnergyMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FONT_STYLE: {
			IfcFontStyle ifcFontStyle = (IfcFontStyle) theEObject;
			T result = caseIfcFontStyle(ifcFontStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FONT_VARIANT: {
			IfcFontVariant ifcFontVariant = (IfcFontVariant) theEObject;
			T result = caseIfcFontVariant(ifcFontVariant);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FONT_WEIGHT: {
			IfcFontWeight ifcFontWeight = (IfcFontWeight) theEObject;
			T result = caseIfcFontWeight(ifcFontWeight);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FORCE_MEASURE: {
			IfcForceMeasure ifcForceMeasure = (IfcForceMeasure) theEObject;
			T result = caseIfcForceMeasure(ifcForceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcForceMeasure);
			if (result == null)
				result = caseIfcValue(ifcForceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcForceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcForceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FREQUENCY_MEASURE: {
			IfcFrequencyMeasure ifcFrequencyMeasure = (IfcFrequencyMeasure) theEObject;
			T result = caseIfcFrequencyMeasure(ifcFrequencyMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcFrequencyMeasure);
			if (result == null)
				result = caseIfcValue(ifcFrequencyMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcFrequencyMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcFrequencyMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GLOBALLY_UNIQUE_ID: {
			IfcGloballyUniqueId ifcGloballyUniqueId = (IfcGloballyUniqueId) theEObject;
			T result = caseIfcGloballyUniqueId(ifcGloballyUniqueId);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_HEAT_FLUX_DENSITY_MEASURE: {
			IfcHeatFluxDensityMeasure ifcHeatFluxDensityMeasure = (IfcHeatFluxDensityMeasure) theEObject;
			T result = caseIfcHeatFluxDensityMeasure(ifcHeatFluxDensityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcHeatFluxDensityMeasure);
			if (result == null)
				result = caseIfcValue(ifcHeatFluxDensityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcHeatFluxDensityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcHeatFluxDensityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_HEATING_VALUE_MEASURE: {
			IfcHeatingValueMeasure ifcHeatingValueMeasure = (IfcHeatingValueMeasure) theEObject;
			T result = caseIfcHeatingValueMeasure(ifcHeatingValueMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcHeatingValueMeasure);
			if (result == null)
				result = caseIfcValue(ifcHeatingValueMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcHeatingValueMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcHeatingValueMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_IDENTIFIER: {
			IfcIdentifier ifcIdentifier = (IfcIdentifier) theEObject;
			T result = caseIfcIdentifier(ifcIdentifier);
			if (result == null)
				result = caseIfcSimpleValue(ifcIdentifier);
			if (result == null)
				result = caseIfcValue(ifcIdentifier);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcIdentifier);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcIdentifier);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ILLUMINANCE_MEASURE: {
			IfcIlluminanceMeasure ifcIlluminanceMeasure = (IfcIlluminanceMeasure) theEObject;
			T result = caseIfcIlluminanceMeasure(ifcIlluminanceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcIlluminanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcIlluminanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcIlluminanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcIlluminanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INDUCTANCE_MEASURE: {
			IfcInductanceMeasure ifcInductanceMeasure = (IfcInductanceMeasure) theEObject;
			T result = caseIfcInductanceMeasure(ifcInductanceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcInductanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcInductanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcInductanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcInductanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INTEGER: {
			IfcInteger ifcInteger = (IfcInteger) theEObject;
			T result = caseIfcInteger(ifcInteger);
			if (result == null)
				result = caseIfcSimpleValue(ifcInteger);
			if (result == null)
				result = caseIfcValue(ifcInteger);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcInteger);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcInteger);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_INTEGER_COUNT_RATE_MEASURE: {
			IfcIntegerCountRateMeasure ifcIntegerCountRateMeasure = (IfcIntegerCountRateMeasure) theEObject;
			T result = caseIfcIntegerCountRateMeasure(ifcIntegerCountRateMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcIntegerCountRateMeasure);
			if (result == null)
				result = caseIfcValue(ifcIntegerCountRateMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcIntegerCountRateMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcIntegerCountRateMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ION_CONCENTRATION_MEASURE: {
			IfcIonConcentrationMeasure ifcIonConcentrationMeasure = (IfcIonConcentrationMeasure) theEObject;
			T result = caseIfcIonConcentrationMeasure(ifcIonConcentrationMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcIonConcentrationMeasure);
			if (result == null)
				result = caseIfcValue(ifcIonConcentrationMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcIonConcentrationMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcIonConcentrationMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ISOTHERMAL_MOISTURE_CAPACITY_MEASURE: {
			IfcIsothermalMoistureCapacityMeasure ifcIsothermalMoistureCapacityMeasure = (IfcIsothermalMoistureCapacityMeasure) theEObject;
			T result = caseIfcIsothermalMoistureCapacityMeasure(ifcIsothermalMoistureCapacityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcIsothermalMoistureCapacityMeasure);
			if (result == null)
				result = caseIfcValue(ifcIsothermalMoistureCapacityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcIsothermalMoistureCapacityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcIsothermalMoistureCapacityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_KINEMATIC_VISCOSITY_MEASURE: {
			IfcKinematicViscosityMeasure ifcKinematicViscosityMeasure = (IfcKinematicViscosityMeasure) theEObject;
			T result = caseIfcKinematicViscosityMeasure(ifcKinematicViscosityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcKinematicViscosityMeasure);
			if (result == null)
				result = caseIfcValue(ifcKinematicViscosityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcKinematicViscosityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcKinematicViscosityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LABEL: {
			IfcLabel ifcLabel = (IfcLabel) theEObject;
			T result = caseIfcLabel(ifcLabel);
			if (result == null)
				result = caseIfcSimpleValue(ifcLabel);
			if (result == null)
				result = caseIfcValue(ifcLabel);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLabel);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLabel);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LENGTH_MEASURE: {
			IfcLengthMeasure ifcLengthMeasure = (IfcLengthMeasure) theEObject;
			T result = caseIfcLengthMeasure(ifcLengthMeasure);
			if (result == null)
				result = caseIfcBendingParameterSelect(ifcLengthMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcLengthMeasure);
			if (result == null)
				result = caseIfcSizeSelect(ifcLengthMeasure);
			if (result == null)
				result = caseIfcValue(ifcLengthMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLengthMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLengthMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LINEAR_FORCE_MEASURE: {
			IfcLinearForceMeasure ifcLinearForceMeasure = (IfcLinearForceMeasure) theEObject;
			T result = caseIfcLinearForceMeasure(ifcLinearForceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcLinearForceMeasure);
			if (result == null)
				result = caseIfcValue(ifcLinearForceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLinearForceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLinearForceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LINEAR_MOMENT_MEASURE: {
			IfcLinearMomentMeasure ifcLinearMomentMeasure = (IfcLinearMomentMeasure) theEObject;
			T result = caseIfcLinearMomentMeasure(ifcLinearMomentMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcLinearMomentMeasure);
			if (result == null)
				result = caseIfcValue(ifcLinearMomentMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLinearMomentMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLinearMomentMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LINEAR_STIFFNESS_MEASURE: {
			IfcLinearStiffnessMeasure ifcLinearStiffnessMeasure = (IfcLinearStiffnessMeasure) theEObject;
			T result = caseIfcLinearStiffnessMeasure(ifcLinearStiffnessMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcLinearStiffnessMeasure);
			if (result == null)
				result = caseIfcTranslationalStiffnessSelect(ifcLinearStiffnessMeasure);
			if (result == null)
				result = caseIfcValue(ifcLinearStiffnessMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLinearStiffnessMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLinearStiffnessMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LINEAR_VELOCITY_MEASURE: {
			IfcLinearVelocityMeasure ifcLinearVelocityMeasure = (IfcLinearVelocityMeasure) theEObject;
			T result = caseIfcLinearVelocityMeasure(ifcLinearVelocityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcLinearVelocityMeasure);
			if (result == null)
				result = caseIfcValue(ifcLinearVelocityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLinearVelocityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLinearVelocityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LOGICAL: {
			IfcLogical ifcLogical = (IfcLogical) theEObject;
			T result = caseIfcLogical(ifcLogical);
			if (result == null)
				result = caseIfcSimpleValue(ifcLogical);
			if (result == null)
				result = caseIfcValue(ifcLogical);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLogical);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLogical);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LUMINOUS_FLUX_MEASURE: {
			IfcLuminousFluxMeasure ifcLuminousFluxMeasure = (IfcLuminousFluxMeasure) theEObject;
			T result = caseIfcLuminousFluxMeasure(ifcLuminousFluxMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcLuminousFluxMeasure);
			if (result == null)
				result = caseIfcValue(ifcLuminousFluxMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLuminousFluxMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLuminousFluxMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LUMINOUS_INTENSITY_DISTRIBUTION_MEASURE: {
			IfcLuminousIntensityDistributionMeasure ifcLuminousIntensityDistributionMeasure = (IfcLuminousIntensityDistributionMeasure) theEObject;
			T result = caseIfcLuminousIntensityDistributionMeasure(ifcLuminousIntensityDistributionMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcLuminousIntensityDistributionMeasure);
			if (result == null)
				result = caseIfcValue(ifcLuminousIntensityDistributionMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLuminousIntensityDistributionMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLuminousIntensityDistributionMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LUMINOUS_INTENSITY_MEASURE: {
			IfcLuminousIntensityMeasure ifcLuminousIntensityMeasure = (IfcLuminousIntensityMeasure) theEObject;
			T result = caseIfcLuminousIntensityMeasure(ifcLuminousIntensityMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcLuminousIntensityMeasure);
			if (result == null)
				result = caseIfcValue(ifcLuminousIntensityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLuminousIntensityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLuminousIntensityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MAGNETIC_FLUX_DENSITY_MEASURE: {
			IfcMagneticFluxDensityMeasure ifcMagneticFluxDensityMeasure = (IfcMagneticFluxDensityMeasure) theEObject;
			T result = caseIfcMagneticFluxDensityMeasure(ifcMagneticFluxDensityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMagneticFluxDensityMeasure);
			if (result == null)
				result = caseIfcValue(ifcMagneticFluxDensityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMagneticFluxDensityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMagneticFluxDensityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MAGNETIC_FLUX_MEASURE: {
			IfcMagneticFluxMeasure ifcMagneticFluxMeasure = (IfcMagneticFluxMeasure) theEObject;
			T result = caseIfcMagneticFluxMeasure(ifcMagneticFluxMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMagneticFluxMeasure);
			if (result == null)
				result = caseIfcValue(ifcMagneticFluxMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMagneticFluxMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMagneticFluxMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MASS_DENSITY_MEASURE: {
			IfcMassDensityMeasure ifcMassDensityMeasure = (IfcMassDensityMeasure) theEObject;
			T result = caseIfcMassDensityMeasure(ifcMassDensityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMassDensityMeasure);
			if (result == null)
				result = caseIfcValue(ifcMassDensityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMassDensityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMassDensityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MASS_FLOW_RATE_MEASURE: {
			IfcMassFlowRateMeasure ifcMassFlowRateMeasure = (IfcMassFlowRateMeasure) theEObject;
			T result = caseIfcMassFlowRateMeasure(ifcMassFlowRateMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMassFlowRateMeasure);
			if (result == null)
				result = caseIfcValue(ifcMassFlowRateMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMassFlowRateMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMassFlowRateMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MASS_MEASURE: {
			IfcMassMeasure ifcMassMeasure = (IfcMassMeasure) theEObject;
			T result = caseIfcMassMeasure(ifcMassMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcMassMeasure);
			if (result == null)
				result = caseIfcValue(ifcMassMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMassMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMassMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MASS_PER_LENGTH_MEASURE: {
			IfcMassPerLengthMeasure ifcMassPerLengthMeasure = (IfcMassPerLengthMeasure) theEObject;
			T result = caseIfcMassPerLengthMeasure(ifcMassPerLengthMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMassPerLengthMeasure);
			if (result == null)
				result = caseIfcValue(ifcMassPerLengthMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMassPerLengthMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMassPerLengthMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MODULUS_OF_ELASTICITY_MEASURE: {
			IfcModulusOfElasticityMeasure ifcModulusOfElasticityMeasure = (IfcModulusOfElasticityMeasure) theEObject;
			T result = caseIfcModulusOfElasticityMeasure(ifcModulusOfElasticityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcModulusOfElasticityMeasure);
			if (result == null)
				result = caseIfcValue(ifcModulusOfElasticityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcModulusOfElasticityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcModulusOfElasticityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MODULUS_OF_LINEAR_SUBGRADE_REACTION_MEASURE: {
			IfcModulusOfLinearSubgradeReactionMeasure ifcModulusOfLinearSubgradeReactionMeasure = (IfcModulusOfLinearSubgradeReactionMeasure) theEObject;
			T result = caseIfcModulusOfLinearSubgradeReactionMeasure(ifcModulusOfLinearSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcModulusOfLinearSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcModulusOfTranslationalSubgradeReactionSelect(ifcModulusOfLinearSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcValue(ifcModulusOfLinearSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcModulusOfLinearSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcModulusOfLinearSubgradeReactionMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MODULUS_OF_ROTATIONAL_SUBGRADE_REACTION_MEASURE: {
			IfcModulusOfRotationalSubgradeReactionMeasure ifcModulusOfRotationalSubgradeReactionMeasure = (IfcModulusOfRotationalSubgradeReactionMeasure) theEObject;
			T result = caseIfcModulusOfRotationalSubgradeReactionMeasure(ifcModulusOfRotationalSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcModulusOfRotationalSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcModulusOfRotationalSubgradeReactionSelect(ifcModulusOfRotationalSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcValue(ifcModulusOfRotationalSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcModulusOfRotationalSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcModulusOfRotationalSubgradeReactionMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MODULUS_OF_SUBGRADE_REACTION_MEASURE: {
			IfcModulusOfSubgradeReactionMeasure ifcModulusOfSubgradeReactionMeasure = (IfcModulusOfSubgradeReactionMeasure) theEObject;
			T result = caseIfcModulusOfSubgradeReactionMeasure(ifcModulusOfSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcModulusOfSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcModulusOfSubgradeReactionSelect(ifcModulusOfSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcValue(ifcModulusOfSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcModulusOfSubgradeReactionMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcModulusOfSubgradeReactionMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MOISTURE_DIFFUSIVITY_MEASURE: {
			IfcMoistureDiffusivityMeasure ifcMoistureDiffusivityMeasure = (IfcMoistureDiffusivityMeasure) theEObject;
			T result = caseIfcMoistureDiffusivityMeasure(ifcMoistureDiffusivityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMoistureDiffusivityMeasure);
			if (result == null)
				result = caseIfcValue(ifcMoistureDiffusivityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMoistureDiffusivityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMoistureDiffusivityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MOLECULAR_WEIGHT_MEASURE: {
			IfcMolecularWeightMeasure ifcMolecularWeightMeasure = (IfcMolecularWeightMeasure) theEObject;
			T result = caseIfcMolecularWeightMeasure(ifcMolecularWeightMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMolecularWeightMeasure);
			if (result == null)
				result = caseIfcValue(ifcMolecularWeightMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMolecularWeightMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMolecularWeightMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MOMENT_OF_INERTIA_MEASURE: {
			IfcMomentOfInertiaMeasure ifcMomentOfInertiaMeasure = (IfcMomentOfInertiaMeasure) theEObject;
			T result = caseIfcMomentOfInertiaMeasure(ifcMomentOfInertiaMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMomentOfInertiaMeasure);
			if (result == null)
				result = caseIfcValue(ifcMomentOfInertiaMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMomentOfInertiaMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMomentOfInertiaMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MONETARY_MEASURE: {
			IfcMonetaryMeasure ifcMonetaryMeasure = (IfcMonetaryMeasure) theEObject;
			T result = caseIfcMonetaryMeasure(ifcMonetaryMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcMonetaryMeasure);
			if (result == null)
				result = caseIfcValue(ifcMonetaryMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMonetaryMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMonetaryMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MONTH_IN_YEAR_NUMBER: {
			IfcMonthInYearNumber ifcMonthInYearNumber = (IfcMonthInYearNumber) theEObject;
			T result = caseIfcMonthInYearNumber(ifcMonthInYearNumber);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_NUMERIC_MEASURE: {
			IfcNumericMeasure ifcNumericMeasure = (IfcNumericMeasure) theEObject;
			T result = caseIfcNumericMeasure(ifcNumericMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcNumericMeasure);
			if (result == null)
				result = caseIfcValue(ifcNumericMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcNumericMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcNumericMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PH_MEASURE: {
			IfcPHMeasure ifcPHMeasure = (IfcPHMeasure) theEObject;
			T result = caseIfcPHMeasure(ifcPHMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcPHMeasure);
			if (result == null)
				result = caseIfcValue(ifcPHMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPHMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPHMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PARAMETER_VALUE: {
			IfcParameterValue ifcParameterValue = (IfcParameterValue) theEObject;
			T result = caseIfcParameterValue(ifcParameterValue);
			if (result == null)
				result = caseIfcMeasureValue(ifcParameterValue);
			if (result == null)
				result = caseIfcTrimmingSelect(ifcParameterValue);
			if (result == null)
				result = caseIfcValue(ifcParameterValue);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcParameterValue);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcParameterValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLANAR_FORCE_MEASURE: {
			IfcPlanarForceMeasure ifcPlanarForceMeasure = (IfcPlanarForceMeasure) theEObject;
			T result = caseIfcPlanarForceMeasure(ifcPlanarForceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcPlanarForceMeasure);
			if (result == null)
				result = caseIfcValue(ifcPlanarForceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPlanarForceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPlanarForceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PLANE_ANGLE_MEASURE: {
			IfcPlaneAngleMeasure ifcPlaneAngleMeasure = (IfcPlaneAngleMeasure) theEObject;
			T result = caseIfcPlaneAngleMeasure(ifcPlaneAngleMeasure);
			if (result == null)
				result = caseIfcBendingParameterSelect(ifcPlaneAngleMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcPlaneAngleMeasure);
			if (result == null)
				result = caseIfcValue(ifcPlaneAngleMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPlaneAngleMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPlaneAngleMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POWER_MEASURE: {
			IfcPowerMeasure ifcPowerMeasure = (IfcPowerMeasure) theEObject;
			T result = caseIfcPowerMeasure(ifcPowerMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcPowerMeasure);
			if (result == null)
				result = caseIfcValue(ifcPowerMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPowerMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPowerMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRESENTABLE_TEXT: {
			IfcPresentableText ifcPresentableText = (IfcPresentableText) theEObject;
			T result = caseIfcPresentableText(ifcPresentableText);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRESSURE_MEASURE: {
			IfcPressureMeasure ifcPressureMeasure = (IfcPressureMeasure) theEObject;
			T result = caseIfcPressureMeasure(ifcPressureMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcPressureMeasure);
			if (result == null)
				result = caseIfcValue(ifcPressureMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPressureMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPressureMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RADIO_ACTIVITY_MEASURE: {
			IfcRadioActivityMeasure ifcRadioActivityMeasure = (IfcRadioActivityMeasure) theEObject;
			T result = caseIfcRadioActivityMeasure(ifcRadioActivityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcRadioActivityMeasure);
			if (result == null)
				result = caseIfcValue(ifcRadioActivityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcRadioActivityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcRadioActivityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RATIO_MEASURE: {
			IfcRatioMeasure ifcRatioMeasure = (IfcRatioMeasure) theEObject;
			T result = caseIfcRatioMeasure(ifcRatioMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcRatioMeasure);
			if (result == null)
				result = caseIfcSizeSelect(ifcRatioMeasure);
			if (result == null)
				result = caseIfcTimeOrRatioSelect(ifcRatioMeasure);
			if (result == null)
				result = caseIfcValue(ifcRatioMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcRatioMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcRatioMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_REAL: {
			IfcReal ifcReal = (IfcReal) theEObject;
			T result = caseIfcReal(ifcReal);
			if (result == null)
				result = caseIfcSimpleValue(ifcReal);
			if (result == null)
				result = caseIfcValue(ifcReal);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcReal);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcReal);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ROTATIONAL_FREQUENCY_MEASURE: {
			IfcRotationalFrequencyMeasure ifcRotationalFrequencyMeasure = (IfcRotationalFrequencyMeasure) theEObject;
			T result = caseIfcRotationalFrequencyMeasure(ifcRotationalFrequencyMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcRotationalFrequencyMeasure);
			if (result == null)
				result = caseIfcValue(ifcRotationalFrequencyMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcRotationalFrequencyMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcRotationalFrequencyMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ROTATIONAL_MASS_MEASURE: {
			IfcRotationalMassMeasure ifcRotationalMassMeasure = (IfcRotationalMassMeasure) theEObject;
			T result = caseIfcRotationalMassMeasure(ifcRotationalMassMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcRotationalMassMeasure);
			if (result == null)
				result = caseIfcValue(ifcRotationalMassMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcRotationalMassMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcRotationalMassMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ROTATIONAL_STIFFNESS_MEASURE: {
			IfcRotationalStiffnessMeasure ifcRotationalStiffnessMeasure = (IfcRotationalStiffnessMeasure) theEObject;
			T result = caseIfcRotationalStiffnessMeasure(ifcRotationalStiffnessMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcRotationalStiffnessMeasure);
			if (result == null)
				result = caseIfcRotationalStiffnessSelect(ifcRotationalStiffnessMeasure);
			if (result == null)
				result = caseIfcValue(ifcRotationalStiffnessMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcRotationalStiffnessMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcRotationalStiffnessMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SECTION_MODULUS_MEASURE: {
			IfcSectionModulusMeasure ifcSectionModulusMeasure = (IfcSectionModulusMeasure) theEObject;
			T result = caseIfcSectionModulusMeasure(ifcSectionModulusMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcSectionModulusMeasure);
			if (result == null)
				result = caseIfcValue(ifcSectionModulusMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSectionModulusMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSectionModulusMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SECTIONAL_AREA_INTEGRAL_MEASURE: {
			IfcSectionalAreaIntegralMeasure ifcSectionalAreaIntegralMeasure = (IfcSectionalAreaIntegralMeasure) theEObject;
			T result = caseIfcSectionalAreaIntegralMeasure(ifcSectionalAreaIntegralMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcSectionalAreaIntegralMeasure);
			if (result == null)
				result = caseIfcValue(ifcSectionalAreaIntegralMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSectionalAreaIntegralMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSectionalAreaIntegralMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SHEAR_MODULUS_MEASURE: {
			IfcShearModulusMeasure ifcShearModulusMeasure = (IfcShearModulusMeasure) theEObject;
			T result = caseIfcShearModulusMeasure(ifcShearModulusMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcShearModulusMeasure);
			if (result == null)
				result = caseIfcValue(ifcShearModulusMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcShearModulusMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcShearModulusMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOLID_ANGLE_MEASURE: {
			IfcSolidAngleMeasure ifcSolidAngleMeasure = (IfcSolidAngleMeasure) theEObject;
			T result = caseIfcSolidAngleMeasure(ifcSolidAngleMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcSolidAngleMeasure);
			if (result == null)
				result = caseIfcValue(ifcSolidAngleMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSolidAngleMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSolidAngleMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOUND_POWER_LEVEL_MEASURE: {
			IfcSoundPowerLevelMeasure ifcSoundPowerLevelMeasure = (IfcSoundPowerLevelMeasure) theEObject;
			T result = caseIfcSoundPowerLevelMeasure(ifcSoundPowerLevelMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcSoundPowerLevelMeasure);
			if (result == null)
				result = caseIfcValue(ifcSoundPowerLevelMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSoundPowerLevelMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSoundPowerLevelMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOUND_POWER_MEASURE: {
			IfcSoundPowerMeasure ifcSoundPowerMeasure = (IfcSoundPowerMeasure) theEObject;
			T result = caseIfcSoundPowerMeasure(ifcSoundPowerMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcSoundPowerMeasure);
			if (result == null)
				result = caseIfcValue(ifcSoundPowerMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSoundPowerMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSoundPowerMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOUND_PRESSURE_LEVEL_MEASURE: {
			IfcSoundPressureLevelMeasure ifcSoundPressureLevelMeasure = (IfcSoundPressureLevelMeasure) theEObject;
			T result = caseIfcSoundPressureLevelMeasure(ifcSoundPressureLevelMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcSoundPressureLevelMeasure);
			if (result == null)
				result = caseIfcValue(ifcSoundPressureLevelMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSoundPressureLevelMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSoundPressureLevelMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOUND_PRESSURE_MEASURE: {
			IfcSoundPressureMeasure ifcSoundPressureMeasure = (IfcSoundPressureMeasure) theEObject;
			T result = caseIfcSoundPressureMeasure(ifcSoundPressureMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcSoundPressureMeasure);
			if (result == null)
				result = caseIfcValue(ifcSoundPressureMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSoundPressureMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSoundPressureMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPECIFIC_HEAT_CAPACITY_MEASURE: {
			IfcSpecificHeatCapacityMeasure ifcSpecificHeatCapacityMeasure = (IfcSpecificHeatCapacityMeasure) theEObject;
			T result = caseIfcSpecificHeatCapacityMeasure(ifcSpecificHeatCapacityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcSpecificHeatCapacityMeasure);
			if (result == null)
				result = caseIfcValue(ifcSpecificHeatCapacityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSpecificHeatCapacityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSpecificHeatCapacityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPECULAR_EXPONENT: {
			IfcSpecularExponent ifcSpecularExponent = (IfcSpecularExponent) theEObject;
			T result = caseIfcSpecularExponent(ifcSpecularExponent);
			if (result == null)
				result = caseIfcSpecularHighlightSelect(ifcSpecularExponent);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPECULAR_ROUGHNESS: {
			IfcSpecularRoughness ifcSpecularRoughness = (IfcSpecularRoughness) theEObject;
			T result = caseIfcSpecularRoughness(ifcSpecularRoughness);
			if (result == null)
				result = caseIfcSpecularHighlightSelect(ifcSpecularRoughness);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEMPERATURE_GRADIENT_MEASURE: {
			IfcTemperatureGradientMeasure ifcTemperatureGradientMeasure = (IfcTemperatureGradientMeasure) theEObject;
			T result = caseIfcTemperatureGradientMeasure(ifcTemperatureGradientMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcTemperatureGradientMeasure);
			if (result == null)
				result = caseIfcValue(ifcTemperatureGradientMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcTemperatureGradientMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcTemperatureGradientMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEMPERATURE_RATE_OF_CHANGE_MEASURE: {
			IfcTemperatureRateOfChangeMeasure ifcTemperatureRateOfChangeMeasure = (IfcTemperatureRateOfChangeMeasure) theEObject;
			T result = caseIfcTemperatureRateOfChangeMeasure(ifcTemperatureRateOfChangeMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcTemperatureRateOfChangeMeasure);
			if (result == null)
				result = caseIfcValue(ifcTemperatureRateOfChangeMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcTemperatureRateOfChangeMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcTemperatureRateOfChangeMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT: {
			IfcText ifcText = (IfcText) theEObject;
			T result = caseIfcText(ifcText);
			if (result == null)
				result = caseIfcSimpleValue(ifcText);
			if (result == null)
				result = caseIfcValue(ifcText);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcText);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcText);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_ALIGNMENT: {
			IfcTextAlignment ifcTextAlignment = (IfcTextAlignment) theEObject;
			T result = caseIfcTextAlignment(ifcTextAlignment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_DECORATION: {
			IfcTextDecoration ifcTextDecoration = (IfcTextDecoration) theEObject;
			T result = caseIfcTextDecoration(ifcTextDecoration);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_FONT_NAME: {
			IfcTextFontName ifcTextFontName = (IfcTextFontName) theEObject;
			T result = caseIfcTextFontName(ifcTextFontName);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_TRANSFORMATION: {
			IfcTextTransformation ifcTextTransformation = (IfcTextTransformation) theEObject;
			T result = caseIfcTextTransformation(ifcTextTransformation);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_THERMAL_ADMITTANCE_MEASURE: {
			IfcThermalAdmittanceMeasure ifcThermalAdmittanceMeasure = (IfcThermalAdmittanceMeasure) theEObject;
			T result = caseIfcThermalAdmittanceMeasure(ifcThermalAdmittanceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcThermalAdmittanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcThermalAdmittanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcThermalAdmittanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcThermalAdmittanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_THERMAL_CONDUCTIVITY_MEASURE: {
			IfcThermalConductivityMeasure ifcThermalConductivityMeasure = (IfcThermalConductivityMeasure) theEObject;
			T result = caseIfcThermalConductivityMeasure(ifcThermalConductivityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcThermalConductivityMeasure);
			if (result == null)
				result = caseIfcValue(ifcThermalConductivityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcThermalConductivityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcThermalConductivityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_THERMAL_EXPANSION_COEFFICIENT_MEASURE: {
			IfcThermalExpansionCoefficientMeasure ifcThermalExpansionCoefficientMeasure = (IfcThermalExpansionCoefficientMeasure) theEObject;
			T result = caseIfcThermalExpansionCoefficientMeasure(ifcThermalExpansionCoefficientMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcThermalExpansionCoefficientMeasure);
			if (result == null)
				result = caseIfcValue(ifcThermalExpansionCoefficientMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcThermalExpansionCoefficientMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcThermalExpansionCoefficientMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_THERMAL_RESISTANCE_MEASURE: {
			IfcThermalResistanceMeasure ifcThermalResistanceMeasure = (IfcThermalResistanceMeasure) theEObject;
			T result = caseIfcThermalResistanceMeasure(ifcThermalResistanceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcThermalResistanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcThermalResistanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcThermalResistanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcThermalResistanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_THERMAL_TRANSMITTANCE_MEASURE: {
			IfcThermalTransmittanceMeasure ifcThermalTransmittanceMeasure = (IfcThermalTransmittanceMeasure) theEObject;
			T result = caseIfcThermalTransmittanceMeasure(ifcThermalTransmittanceMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcThermalTransmittanceMeasure);
			if (result == null)
				result = caseIfcValue(ifcThermalTransmittanceMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcThermalTransmittanceMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcThermalTransmittanceMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_THERMODYNAMIC_TEMPERATURE_MEASURE: {
			IfcThermodynamicTemperatureMeasure ifcThermodynamicTemperatureMeasure = (IfcThermodynamicTemperatureMeasure) theEObject;
			T result = caseIfcThermodynamicTemperatureMeasure(ifcThermodynamicTemperatureMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcThermodynamicTemperatureMeasure);
			if (result == null)
				result = caseIfcValue(ifcThermodynamicTemperatureMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcThermodynamicTemperatureMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcThermodynamicTemperatureMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TIME: {
			IfcTime ifcTime = (IfcTime) theEObject;
			T result = caseIfcTime(ifcTime);
			if (result == null)
				result = caseIfcSimpleValue(ifcTime);
			if (result == null)
				result = caseIfcValue(ifcTime);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcTime);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcTime);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TIME_MEASURE: {
			IfcTimeMeasure ifcTimeMeasure = (IfcTimeMeasure) theEObject;
			T result = caseIfcTimeMeasure(ifcTimeMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcTimeMeasure);
			if (result == null)
				result = caseIfcValue(ifcTimeMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcTimeMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcTimeMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TIME_STAMP: {
			IfcTimeStamp ifcTimeStamp = (IfcTimeStamp) theEObject;
			T result = caseIfcTimeStamp(ifcTimeStamp);
			if (result == null)
				result = caseIfcSimpleValue(ifcTimeStamp);
			if (result == null)
				result = caseIfcValue(ifcTimeStamp);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcTimeStamp);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcTimeStamp);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TORQUE_MEASURE: {
			IfcTorqueMeasure ifcTorqueMeasure = (IfcTorqueMeasure) theEObject;
			T result = caseIfcTorqueMeasure(ifcTorqueMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcTorqueMeasure);
			if (result == null)
				result = caseIfcValue(ifcTorqueMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcTorqueMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcTorqueMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_URI_REFERENCE: {
			IfcURIReference ifcURIReference = (IfcURIReference) theEObject;
			T result = caseIfcURIReference(ifcURIReference);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VAPOR_PERMEABILITY_MEASURE: {
			IfcVaporPermeabilityMeasure ifcVaporPermeabilityMeasure = (IfcVaporPermeabilityMeasure) theEObject;
			T result = caseIfcVaporPermeabilityMeasure(ifcVaporPermeabilityMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcVaporPermeabilityMeasure);
			if (result == null)
				result = caseIfcValue(ifcVaporPermeabilityMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcVaporPermeabilityMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcVaporPermeabilityMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VOLUME_MEASURE: {
			IfcVolumeMeasure ifcVolumeMeasure = (IfcVolumeMeasure) theEObject;
			T result = caseIfcVolumeMeasure(ifcVolumeMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcVolumeMeasure);
			if (result == null)
				result = caseIfcValue(ifcVolumeMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcVolumeMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcVolumeMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VOLUMETRIC_FLOW_RATE_MEASURE: {
			IfcVolumetricFlowRateMeasure ifcVolumetricFlowRateMeasure = (IfcVolumetricFlowRateMeasure) theEObject;
			T result = caseIfcVolumetricFlowRateMeasure(ifcVolumetricFlowRateMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcVolumetricFlowRateMeasure);
			if (result == null)
				result = caseIfcValue(ifcVolumetricFlowRateMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcVolumetricFlowRateMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcVolumetricFlowRateMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WARPING_CONSTANT_MEASURE: {
			IfcWarpingConstantMeasure ifcWarpingConstantMeasure = (IfcWarpingConstantMeasure) theEObject;
			T result = caseIfcWarpingConstantMeasure(ifcWarpingConstantMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcWarpingConstantMeasure);
			if (result == null)
				result = caseIfcValue(ifcWarpingConstantMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcWarpingConstantMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcWarpingConstantMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WARPING_MOMENT_MEASURE: {
			IfcWarpingMomentMeasure ifcWarpingMomentMeasure = (IfcWarpingMomentMeasure) theEObject;
			T result = caseIfcWarpingMomentMeasure(ifcWarpingMomentMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcWarpingMomentMeasure);
			if (result == null)
				result = caseIfcWarpingStiffnessSelect(ifcWarpingMomentMeasure);
			if (result == null)
				result = caseIfcValue(ifcWarpingMomentMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcWarpingMomentMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcWarpingMomentMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOX_ALIGNMENT: {
			IfcBoxAlignment ifcBoxAlignment = (IfcBoxAlignment) theEObject;
			T result = caseIfcBoxAlignment(ifcBoxAlignment);
			if (result == null)
				result = caseIfcLabel(ifcBoxAlignment);
			if (result == null)
				result = caseIfcSimpleValue(ifcBoxAlignment);
			if (result == null)
				result = caseIfcValue(ifcBoxAlignment);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcBoxAlignment);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcBoxAlignment);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPOUND_PLANE_ANGLE_MEASURE: {
			IfcCompoundPlaneAngleMeasure ifcCompoundPlaneAngleMeasure = (IfcCompoundPlaneAngleMeasure) theEObject;
			T result = caseIfcCompoundPlaneAngleMeasure(ifcCompoundPlaneAngleMeasure);
			if (result == null)
				result = caseIfcDerivedMeasureValue(ifcCompoundPlaneAngleMeasure);
			if (result == null)
				result = caseIfcValue(ifcCompoundPlaneAngleMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcCompoundPlaneAngleMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcCompoundPlaneAngleMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LANGUAGE_ID: {
			IfcLanguageId ifcLanguageId = (IfcLanguageId) theEObject;
			T result = caseIfcLanguageId(ifcLanguageId);
			if (result == null)
				result = caseIfcIdentifier(ifcLanguageId);
			if (result == null)
				result = caseIfcSimpleValue(ifcLanguageId);
			if (result == null)
				result = caseIfcValue(ifcLanguageId);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcLanguageId);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcLanguageId);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_NON_NEGATIVE_LENGTH_MEASURE: {
			IfcNonNegativeLengthMeasure ifcNonNegativeLengthMeasure = (IfcNonNegativeLengthMeasure) theEObject;
			T result = caseIfcNonNegativeLengthMeasure(ifcNonNegativeLengthMeasure);
			if (result == null)
				result = caseIfcLengthMeasure(ifcNonNegativeLengthMeasure);
			if (result == null)
				result = caseIfcBendingParameterSelect(ifcNonNegativeLengthMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcNonNegativeLengthMeasure);
			if (result == null)
				result = caseIfcSizeSelect(ifcNonNegativeLengthMeasure);
			if (result == null)
				result = caseIfcValue(ifcNonNegativeLengthMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcNonNegativeLengthMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcNonNegativeLengthMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_NORMALISED_RATIO_MEASURE: {
			IfcNormalisedRatioMeasure ifcNormalisedRatioMeasure = (IfcNormalisedRatioMeasure) theEObject;
			T result = caseIfcNormalisedRatioMeasure(ifcNormalisedRatioMeasure);
			if (result == null)
				result = caseIfcRatioMeasure(ifcNormalisedRatioMeasure);
			if (result == null)
				result = caseIfcColourOrFactor(ifcNormalisedRatioMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcNormalisedRatioMeasure);
			if (result == null)
				result = caseIfcSizeSelect(ifcNormalisedRatioMeasure);
			if (result == null)
				result = caseIfcTimeOrRatioSelect(ifcNormalisedRatioMeasure);
			if (result == null)
				result = caseIfcValue(ifcNormalisedRatioMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcNormalisedRatioMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcNormalisedRatioMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POSITIVE_INTEGER: {
			IfcPositiveInteger ifcPositiveInteger = (IfcPositiveInteger) theEObject;
			T result = caseIfcPositiveInteger(ifcPositiveInteger);
			if (result == null)
				result = caseIfcInteger(ifcPositiveInteger);
			if (result == null)
				result = caseIfcSimpleValue(ifcPositiveInteger);
			if (result == null)
				result = caseIfcValue(ifcPositiveInteger);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPositiveInteger);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPositiveInteger);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POSITIVE_LENGTH_MEASURE: {
			IfcPositiveLengthMeasure ifcPositiveLengthMeasure = (IfcPositiveLengthMeasure) theEObject;
			T result = caseIfcPositiveLengthMeasure(ifcPositiveLengthMeasure);
			if (result == null)
				result = caseIfcLengthMeasure(ifcPositiveLengthMeasure);
			if (result == null)
				result = caseIfcHatchLineDistanceSelect(ifcPositiveLengthMeasure);
			if (result == null)
				result = caseIfcBendingParameterSelect(ifcPositiveLengthMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcPositiveLengthMeasure);
			if (result == null)
				result = caseIfcSizeSelect(ifcPositiveLengthMeasure);
			if (result == null)
				result = caseIfcValue(ifcPositiveLengthMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPositiveLengthMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPositiveLengthMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POSITIVE_PLANE_ANGLE_MEASURE: {
			IfcPositivePlaneAngleMeasure ifcPositivePlaneAngleMeasure = (IfcPositivePlaneAngleMeasure) theEObject;
			T result = caseIfcPositivePlaneAngleMeasure(ifcPositivePlaneAngleMeasure);
			if (result == null)
				result = caseIfcPlaneAngleMeasure(ifcPositivePlaneAngleMeasure);
			if (result == null)
				result = caseIfcBendingParameterSelect(ifcPositivePlaneAngleMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcPositivePlaneAngleMeasure);
			if (result == null)
				result = caseIfcValue(ifcPositivePlaneAngleMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPositivePlaneAngleMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPositivePlaneAngleMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POSITIVE_RATIO_MEASURE: {
			IfcPositiveRatioMeasure ifcPositiveRatioMeasure = (IfcPositiveRatioMeasure) theEObject;
			T result = caseIfcPositiveRatioMeasure(ifcPositiveRatioMeasure);
			if (result == null)
				result = caseIfcRatioMeasure(ifcPositiveRatioMeasure);
			if (result == null)
				result = caseIfcMeasureValue(ifcPositiveRatioMeasure);
			if (result == null)
				result = caseIfcSizeSelect(ifcPositiveRatioMeasure);
			if (result == null)
				result = caseIfcTimeOrRatioSelect(ifcPositiveRatioMeasure);
			if (result == null)
				result = caseIfcValue(ifcPositiveRatioMeasure);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcPositiveRatioMeasure);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcPositiveRatioMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COMPLEX_NUMBER: {
			IfcComplexNumber ifcComplexNumber = (IfcComplexNumber) theEObject;
			T result = caseIfcComplexNumber(ifcComplexNumber);
			if (result == null)
				result = caseIfcMeasureValue(ifcComplexNumber);
			if (result == null)
				result = caseIfcValue(ifcComplexNumber);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcComplexNumber);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcComplexNumber);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_NULL_STYLE: {
			IfcNullStyle ifcNullStyle = (IfcNullStyle) theEObject;
			T result = caseIfcNullStyle(ifcNullStyle);
			if (result == null)
				result = caseIfcPresentationStyleSelect(ifcNullStyle);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ACTOR_SELECT: {
			IfcActorSelect ifcActorSelect = (IfcActorSelect) theEObject;
			T result = caseIfcActorSelect(ifcActorSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_APPLIED_VALUE_SELECT: {
			IfcAppliedValueSelect ifcAppliedValueSelect = (IfcAppliedValueSelect) theEObject;
			T result = caseIfcAppliedValueSelect(ifcAppliedValueSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_AXIS2_PLACEMENT: {
			IfcAxis2Placement ifcAxis2Placement = (IfcAxis2Placement) theEObject;
			T result = caseIfcAxis2Placement(ifcAxis2Placement);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BENDING_PARAMETER_SELECT: {
			IfcBendingParameterSelect ifcBendingParameterSelect = (IfcBendingParameterSelect) theEObject;
			T result = caseIfcBendingParameterSelect(ifcBendingParameterSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_BOOLEAN_OPERAND: {
			IfcBooleanOperand ifcBooleanOperand = (IfcBooleanOperand) theEObject;
			T result = caseIfcBooleanOperand(ifcBooleanOperand);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CLASSIFICATION_REFERENCE_SELECT: {
			IfcClassificationReferenceSelect ifcClassificationReferenceSelect = (IfcClassificationReferenceSelect) theEObject;
			T result = caseIfcClassificationReferenceSelect(ifcClassificationReferenceSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CLASSIFICATION_SELECT: {
			IfcClassificationSelect ifcClassificationSelect = (IfcClassificationSelect) theEObject;
			T result = caseIfcClassificationSelect(ifcClassificationSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COLOUR: {
			IfcColour ifcColour = (IfcColour) theEObject;
			T result = caseIfcColour(ifcColour);
			if (result == null)
				result = caseIfcFillStyleSelect(ifcColour);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COLOUR_OR_FACTOR: {
			IfcColourOrFactor ifcColourOrFactor = (IfcColourOrFactor) theEObject;
			T result = caseIfcColourOrFactor(ifcColourOrFactor);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_COORDINATE_REFERENCE_SYSTEM_SELECT: {
			IfcCoordinateReferenceSystemSelect ifcCoordinateReferenceSystemSelect = (IfcCoordinateReferenceSystemSelect) theEObject;
			T result = caseIfcCoordinateReferenceSystemSelect(ifcCoordinateReferenceSystemSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CSG_SELECT: {
			IfcCsgSelect ifcCsgSelect = (IfcCsgSelect) theEObject;
			T result = caseIfcCsgSelect(ifcCsgSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_FONT_OR_SCALED_CURVE_FONT_SELECT: {
			IfcCurveFontOrScaledCurveFontSelect ifcCurveFontOrScaledCurveFontSelect = (IfcCurveFontOrScaledCurveFontSelect) theEObject;
			T result = caseIfcCurveFontOrScaledCurveFontSelect(ifcCurveFontOrScaledCurveFontSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_ON_SURFACE: {
			IfcCurveOnSurface ifcCurveOnSurface = (IfcCurveOnSurface) theEObject;
			T result = caseIfcCurveOnSurface(ifcCurveOnSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_OR_EDGE_CURVE: {
			IfcCurveOrEdgeCurve ifcCurveOrEdgeCurve = (IfcCurveOrEdgeCurve) theEObject;
			T result = caseIfcCurveOrEdgeCurve(ifcCurveOrEdgeCurve);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_CURVE_STYLE_FONT_SELECT: {
			IfcCurveStyleFontSelect ifcCurveStyleFontSelect = (IfcCurveStyleFontSelect) theEObject;
			T result = caseIfcCurveStyleFontSelect(ifcCurveStyleFontSelect);
			if (result == null)
				result = caseIfcCurveFontOrScaledCurveFontSelect(ifcCurveStyleFontSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DEFINITION_SELECT: {
			IfcDefinitionSelect ifcDefinitionSelect = (IfcDefinitionSelect) theEObject;
			T result = caseIfcDefinitionSelect(ifcDefinitionSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DERIVED_MEASURE_VALUE: {
			IfcDerivedMeasureValue ifcDerivedMeasureValue = (IfcDerivedMeasureValue) theEObject;
			T result = caseIfcDerivedMeasureValue(ifcDerivedMeasureValue);
			if (result == null)
				result = caseIfcValue(ifcDerivedMeasureValue);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcDerivedMeasureValue);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcDerivedMeasureValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_DOCUMENT_SELECT: {
			IfcDocumentSelect ifcDocumentSelect = (IfcDocumentSelect) theEObject;
			T result = caseIfcDocumentSelect(ifcDocumentSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_FILL_STYLE_SELECT: {
			IfcFillStyleSelect ifcFillStyleSelect = (IfcFillStyleSelect) theEObject;
			T result = caseIfcFillStyleSelect(ifcFillStyleSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GEOMETRIC_SET_SELECT: {
			IfcGeometricSetSelect ifcGeometricSetSelect = (IfcGeometricSetSelect) theEObject;
			T result = caseIfcGeometricSetSelect(ifcGeometricSetSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_GRID_PLACEMENT_DIRECTION_SELECT: {
			IfcGridPlacementDirectionSelect ifcGridPlacementDirectionSelect = (IfcGridPlacementDirectionSelect) theEObject;
			T result = caseIfcGridPlacementDirectionSelect(ifcGridPlacementDirectionSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_HATCH_LINE_DISTANCE_SELECT: {
			IfcHatchLineDistanceSelect ifcHatchLineDistanceSelect = (IfcHatchLineDistanceSelect) theEObject;
			T result = caseIfcHatchLineDistanceSelect(ifcHatchLineDistanceSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LAYERED_ITEM: {
			IfcLayeredItem ifcLayeredItem = (IfcLayeredItem) theEObject;
			T result = caseIfcLayeredItem(ifcLayeredItem);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIBRARY_SELECT: {
			IfcLibrarySelect ifcLibrarySelect = (IfcLibrarySelect) theEObject;
			T result = caseIfcLibrarySelect(ifcLibrarySelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT: {
			IfcLightDistributionDataSourceSelect ifcLightDistributionDataSourceSelect = (IfcLightDistributionDataSourceSelect) theEObject;
			T result = caseIfcLightDistributionDataSourceSelect(ifcLightDistributionDataSourceSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MATERIAL_SELECT: {
			IfcMaterialSelect ifcMaterialSelect = (IfcMaterialSelect) theEObject;
			T result = caseIfcMaterialSelect(ifcMaterialSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MEASURE_VALUE: {
			IfcMeasureValue ifcMeasureValue = (IfcMeasureValue) theEObject;
			T result = caseIfcMeasureValue(ifcMeasureValue);
			if (result == null)
				result = caseIfcValue(ifcMeasureValue);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcMeasureValue);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcMeasureValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_METRIC_VALUE_SELECT: {
			IfcMetricValueSelect ifcMetricValueSelect = (IfcMetricValueSelect) theEObject;
			T result = caseIfcMetricValueSelect(ifcMetricValueSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MODULUS_OF_ROTATIONAL_SUBGRADE_REACTION_SELECT: {
			IfcModulusOfRotationalSubgradeReactionSelect ifcModulusOfRotationalSubgradeReactionSelect = (IfcModulusOfRotationalSubgradeReactionSelect) theEObject;
			T result = caseIfcModulusOfRotationalSubgradeReactionSelect(ifcModulusOfRotationalSubgradeReactionSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MODULUS_OF_SUBGRADE_REACTION_SELECT: {
			IfcModulusOfSubgradeReactionSelect ifcModulusOfSubgradeReactionSelect = (IfcModulusOfSubgradeReactionSelect) theEObject;
			T result = caseIfcModulusOfSubgradeReactionSelect(ifcModulusOfSubgradeReactionSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_MODULUS_OF_TRANSLATIONAL_SUBGRADE_REACTION_SELECT: {
			IfcModulusOfTranslationalSubgradeReactionSelect ifcModulusOfTranslationalSubgradeReactionSelect = (IfcModulusOfTranslationalSubgradeReactionSelect) theEObject;
			T result = caseIfcModulusOfTranslationalSubgradeReactionSelect(ifcModulusOfTranslationalSubgradeReactionSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_OBJECT_REFERENCE_SELECT: {
			IfcObjectReferenceSelect ifcObjectReferenceSelect = (IfcObjectReferenceSelect) theEObject;
			T result = caseIfcObjectReferenceSelect(ifcObjectReferenceSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_POINT_OR_VERTEX_POINT: {
			IfcPointOrVertexPoint ifcPointOrVertexPoint = (IfcPointOrVertexPoint) theEObject;
			T result = caseIfcPointOrVertexPoint(ifcPointOrVertexPoint);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRESENTATION_STYLE_SELECT: {
			IfcPresentationStyleSelect ifcPresentationStyleSelect = (IfcPresentationStyleSelect) theEObject;
			T result = caseIfcPresentationStyleSelect(ifcPresentationStyleSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROCESS_SELECT: {
			IfcProcessSelect ifcProcessSelect = (IfcProcessSelect) theEObject;
			T result = caseIfcProcessSelect(ifcProcessSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRODUCT_REPRESENTATION_SELECT: {
			IfcProductRepresentationSelect ifcProductRepresentationSelect = (IfcProductRepresentationSelect) theEObject;
			T result = caseIfcProductRepresentationSelect(ifcProductRepresentationSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PRODUCT_SELECT: {
			IfcProductSelect ifcProductSelect = (IfcProductSelect) theEObject;
			T result = caseIfcProductSelect(ifcProductSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_PROPERTY_SET_DEFINITION_SELECT: {
			IfcPropertySetDefinitionSelect ifcPropertySetDefinitionSelect = (IfcPropertySetDefinitionSelect) theEObject;
			T result = caseIfcPropertySetDefinitionSelect(ifcPropertySetDefinitionSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RESOURCE_OBJECT_SELECT: {
			IfcResourceObjectSelect ifcResourceObjectSelect = (IfcResourceObjectSelect) theEObject;
			T result = caseIfcResourceObjectSelect(ifcResourceObjectSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_RESOURCE_SELECT: {
			IfcResourceSelect ifcResourceSelect = (IfcResourceSelect) theEObject;
			T result = caseIfcResourceSelect(ifcResourceSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_ROTATIONAL_STIFFNESS_SELECT: {
			IfcRotationalStiffnessSelect ifcRotationalStiffnessSelect = (IfcRotationalStiffnessSelect) theEObject;
			T result = caseIfcRotationalStiffnessSelect(ifcRotationalStiffnessSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SEGMENT_INDEX_SELECT: {
			IfcSegmentIndexSelect ifcSegmentIndexSelect = (IfcSegmentIndexSelect) theEObject;
			T result = caseIfcSegmentIndexSelect(ifcSegmentIndexSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SHELL: {
			IfcShell ifcShell = (IfcShell) theEObject;
			T result = caseIfcShell(ifcShell);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SIMPLE_VALUE: {
			IfcSimpleValue ifcSimpleValue = (IfcSimpleValue) theEObject;
			T result = caseIfcSimpleValue(ifcSimpleValue);
			if (result == null)
				result = caseIfcValue(ifcSimpleValue);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcSimpleValue);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcSimpleValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SIZE_SELECT: {
			IfcSizeSelect ifcSizeSelect = (IfcSizeSelect) theEObject;
			T result = caseIfcSizeSelect(ifcSizeSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SOLID_OR_SHELL: {
			IfcSolidOrShell ifcSolidOrShell = (IfcSolidOrShell) theEObject;
			T result = caseIfcSolidOrShell(ifcSolidOrShell);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPACE_BOUNDARY_SELECT: {
			IfcSpaceBoundarySelect ifcSpaceBoundarySelect = (IfcSpaceBoundarySelect) theEObject;
			T result = caseIfcSpaceBoundarySelect(ifcSpaceBoundarySelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SPECULAR_HIGHLIGHT_SELECT: {
			IfcSpecularHighlightSelect ifcSpecularHighlightSelect = (IfcSpecularHighlightSelect) theEObject;
			T result = caseIfcSpecularHighlightSelect(ifcSpecularHighlightSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STRUCTURAL_ACTIVITY_ASSIGNMENT_SELECT: {
			IfcStructuralActivityAssignmentSelect ifcStructuralActivityAssignmentSelect = (IfcStructuralActivityAssignmentSelect) theEObject;
			T result = caseIfcStructuralActivityAssignmentSelect(ifcStructuralActivityAssignmentSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_STYLE_ASSIGNMENT_SELECT: {
			IfcStyleAssignmentSelect ifcStyleAssignmentSelect = (IfcStyleAssignmentSelect) theEObject;
			T result = caseIfcStyleAssignmentSelect(ifcStyleAssignmentSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_OR_FACE_SURFACE: {
			IfcSurfaceOrFaceSurface ifcSurfaceOrFaceSurface = (IfcSurfaceOrFaceSurface) theEObject;
			T result = caseIfcSurfaceOrFaceSurface(ifcSurfaceOrFaceSurface);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_SURFACE_STYLE_ELEMENT_SELECT: {
			IfcSurfaceStyleElementSelect ifcSurfaceStyleElementSelect = (IfcSurfaceStyleElementSelect) theEObject;
			T result = caseIfcSurfaceStyleElementSelect(ifcSurfaceStyleElementSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TEXT_FONT_SELECT: {
			IfcTextFontSelect ifcTextFontSelect = (IfcTextFontSelect) theEObject;
			T result = caseIfcTextFontSelect(ifcTextFontSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TIME_OR_RATIO_SELECT: {
			IfcTimeOrRatioSelect ifcTimeOrRatioSelect = (IfcTimeOrRatioSelect) theEObject;
			T result = caseIfcTimeOrRatioSelect(ifcTimeOrRatioSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRANSLATIONAL_STIFFNESS_SELECT: {
			IfcTranslationalStiffnessSelect ifcTranslationalStiffnessSelect = (IfcTranslationalStiffnessSelect) theEObject;
			T result = caseIfcTranslationalStiffnessSelect(ifcTranslationalStiffnessSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_TRIMMING_SELECT: {
			IfcTrimmingSelect ifcTrimmingSelect = (IfcTrimmingSelect) theEObject;
			T result = caseIfcTrimmingSelect(ifcTrimmingSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_UNIT: {
			IfcUnit ifcUnit = (IfcUnit) theEObject;
			T result = caseIfcUnit(ifcUnit);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VALUE: {
			IfcValue ifcValue = (IfcValue) theEObject;
			T result = caseIfcValue(ifcValue);
			if (result == null)
				result = caseIfcAppliedValueSelect(ifcValue);
			if (result == null)
				result = caseIfcMetricValueSelect(ifcValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_VECTOR_OR_DIRECTION: {
			IfcVectorOrDirection ifcVectorOrDirection = (IfcVectorOrDirection) theEObject;
			T result = caseIfcVectorOrDirection(ifcVectorOrDirection);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.IFC_WARPING_STIFFNESS_SELECT: {
			IfcWarpingStiffnessSelect ifcWarpingStiffnessSelect = (IfcWarpingStiffnessSelect) theEObject;
			T result = caseIfcWarpingStiffnessSelect(ifcWarpingStiffnessSelect);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.LIST_OF_IFC_CARTESIAN_POINT: {
			ListOfIfcCartesianPoint listOfIfcCartesianPoint = (ListOfIfcCartesianPoint) theEObject;
			T result = caseListOfIfcCartesianPoint(listOfIfcCartesianPoint);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.LIST_OF_IFC_LENGTH_MEASURE: {
			ListOfIfcLengthMeasure listOfIfcLengthMeasure = (ListOfIfcLengthMeasure) theEObject;
			T result = caseListOfIfcLengthMeasure(listOfIfcLengthMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.LIST_OF_IFC_NORMALISED_RATIO_MEASURE: {
			ListOfIfcNormalisedRatioMeasure listOfIfcNormalisedRatioMeasure = (ListOfIfcNormalisedRatioMeasure) theEObject;
			T result = caseListOfIfcNormalisedRatioMeasure(listOfIfcNormalisedRatioMeasure);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.LIST_OF_ELONG: {
			ListOfELong listOfELong = (ListOfELong) theEObject;
			T result = caseListOfELong(listOfELong);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.LIST_OF_EDOUBLE: {
			ListOfEDouble listOfEDouble = (ListOfEDouble) theEObject;
			T result = caseListOfEDouble(listOfEDouble);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		case Ifc4Package.LIST_OF_IFC_PARAMETER_VALUE: {
			ListOfIfcParameterValue listOfIfcParameterValue = (ListOfIfcParameterValue) theEObject;
			T result = caseListOfIfcParameterValue(listOfIfcParameterValue);
			if (result == null)
				result = defaultCase(theEObject);
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Action Request</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Action Request</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcActionRequest(IfcActionRequest object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Actor</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Actor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcActor(IfcActor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Actor Role</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Actor Role</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcActorRole(IfcActorRole object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Actuator</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Actuator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcActuator(IfcActuator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Actuator Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Actuator Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcActuatorType(IfcActuatorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Address</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Address</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAddress(IfcAddress object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Advanced Brep</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Advanced Brep</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAdvancedBrep(IfcAdvancedBrep object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Advanced Brep With Voids</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Advanced Brep With Voids</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAdvancedBrepWithVoids(IfcAdvancedBrepWithVoids object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Advanced Face</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Advanced Face</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAdvancedFace(IfcAdvancedFace object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Air Terminal</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Air Terminal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAirTerminal(IfcAirTerminal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Air Terminal Box</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Air Terminal Box</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAirTerminalBox(IfcAirTerminalBox object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Air Terminal Box Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Air Terminal Box Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAirTerminalBoxType(IfcAirTerminalBoxType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Air Terminal Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Air Terminal Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAirTerminalType(IfcAirTerminalType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Air To Air Heat Recovery</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Air To Air Heat Recovery</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAirToAirHeatRecovery(IfcAirToAirHeatRecovery object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Air To Air Heat Recovery Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Air To Air Heat Recovery Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAirToAirHeatRecoveryType(IfcAirToAirHeatRecoveryType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Alarm</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Alarm</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAlarm(IfcAlarm object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Alarm Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Alarm Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAlarmType(IfcAlarmType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Annotation</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Annotation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAnnotation(IfcAnnotation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Annotation Fill Area</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Annotation Fill Area</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAnnotationFillArea(IfcAnnotationFillArea object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Application</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Application</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcApplication(IfcApplication object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Applied Value</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Applied Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAppliedValue(IfcAppliedValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Approval</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Approval</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcApproval(IfcApproval object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Approval Relationship</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Approval Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcApprovalRelationship(IfcApprovalRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Arbitrary Closed Profile Def</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Arbitrary Closed Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcArbitraryClosedProfileDef(IfcArbitraryClosedProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Arbitrary Open Profile Def</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Arbitrary Open Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcArbitraryOpenProfileDef(IfcArbitraryOpenProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Arbitrary Profile Def With Voids</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Arbitrary Profile Def With Voids</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcArbitraryProfileDefWithVoids(IfcArbitraryProfileDefWithVoids object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Asset</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Asset</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAsset(IfcAsset object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Asymmetric IShape Profile Def</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Asymmetric IShape Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAsymmetricIShapeProfileDef(IfcAsymmetricIShapeProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Audio Visual Appliance</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Audio Visual Appliance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAudioVisualAppliance(IfcAudioVisualAppliance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Audio Visual Appliance Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Audio Visual Appliance Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAudioVisualApplianceType(IfcAudioVisualApplianceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Axis1 Placement</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Axis1 Placement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAxis1Placement(IfcAxis1Placement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Axis2 Placement2 D</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Axis2 Placement2 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAxis2Placement2D(IfcAxis2Placement2D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Axis2 Placement3 D</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Axis2 Placement3 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcAxis2Placement3D(IfcAxis2Placement3D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc BSpline Curve</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc BSpline Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBSplineCurve(IfcBSplineCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc BSpline Curve With Knots</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc BSpline Curve With Knots</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBSplineCurveWithKnots(IfcBSplineCurveWithKnots object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc BSpline Surface</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc BSpline Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBSplineSurface(IfcBSplineSurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc BSpline Surface With Knots</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc BSpline Surface With Knots</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBSplineSurfaceWithKnots(IfcBSplineSurfaceWithKnots object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Beam</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Beam</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBeam(IfcBeam object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Beam Standard Case</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Beam Standard Case</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBeamStandardCase(IfcBeamStandardCase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Beam Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Beam Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBeamType(IfcBeamType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Blob Texture</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Blob Texture</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBlobTexture(IfcBlobTexture object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Block</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Block</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBlock(IfcBlock object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Boiler</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Boiler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoiler(IfcBoiler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boiler Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boiler Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoilerType(IfcBoilerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boolean Clipping Result</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boolean Clipping Result</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBooleanClippingResult(IfcBooleanClippingResult object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boolean Result</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boolean Result</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBooleanResult(IfcBooleanResult object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boundary Condition</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boundary Condition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundaryCondition(IfcBoundaryCondition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boundary Curve</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boundary Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundaryCurve(IfcBoundaryCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boundary Edge Condition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boundary Edge Condition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundaryEdgeCondition(IfcBoundaryEdgeCondition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boundary Face Condition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boundary Face Condition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundaryFaceCondition(IfcBoundaryFaceCondition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boundary Node Condition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boundary Node Condition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundaryNodeCondition(IfcBoundaryNodeCondition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boundary Node Condition Warping</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boundary Node Condition Warping</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundaryNodeConditionWarping(IfcBoundaryNodeConditionWarping object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Bounded Curve</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Bounded Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundedCurve(IfcBoundedCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Bounded Surface</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Bounded Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundedSurface(IfcBoundedSurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Bounding Box</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Bounding Box</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoundingBox(IfcBoundingBox object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Boxed Half Space</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Boxed Half Space</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBoxedHalfSpace(IfcBoxedHalfSpace object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Building</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Building</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuilding(IfcBuilding object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Building Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Building Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuildingElement(IfcBuildingElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Building Element Part</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Building Element Part</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuildingElementPart(IfcBuildingElementPart object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Building Element Part Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Building Element Part Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuildingElementPartType(IfcBuildingElementPartType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Building Element Proxy</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Building Element Proxy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuildingElementProxy(IfcBuildingElementProxy object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Building Element Proxy Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Building Element Proxy Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuildingElementProxyType(IfcBuildingElementProxyType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Building Element Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Building Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuildingElementType(IfcBuildingElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Building Storey</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Building Storey</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuildingStorey(IfcBuildingStorey object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Building System</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Building System</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBuildingSystem(IfcBuildingSystem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Burner</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Burner</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBurner(IfcBurner object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Burner Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Burner Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcBurnerType(IfcBurnerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc CShape Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc CShape Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCShapeProfileDef(IfcCShapeProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cable Carrier Fitting</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cable Carrier Fitting</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCableCarrierFitting(IfcCableCarrierFitting object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cable Carrier Fitting Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cable Carrier Fitting Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCableCarrierFittingType(IfcCableCarrierFittingType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cable Carrier Segment</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cable Carrier Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCableCarrierSegment(IfcCableCarrierSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cable Carrier Segment Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cable Carrier Segment Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCableCarrierSegmentType(IfcCableCarrierSegmentType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cable Fitting</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cable Fitting</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCableFitting(IfcCableFitting object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cable Fitting Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cable Fitting Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCableFittingType(IfcCableFittingType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cable Segment</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cable Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCableSegment(IfcCableSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cable Segment Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cable Segment Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCableSegmentType(IfcCableSegmentType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cartesian Point</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cartesian Point</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianPoint(IfcCartesianPoint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cartesian Point List</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cartesian Point List</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianPointList(IfcCartesianPointList object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cartesian Point List2 D</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cartesian Point List2 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianPointList2D(IfcCartesianPointList2D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cartesian Point List3 D</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cartesian Point List3 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianPointList3D(IfcCartesianPointList3D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cartesian Transformation Operator</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cartesian Transformation Operator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianTransformationOperator(IfcCartesianTransformationOperator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cartesian Transformation Operator2 D</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cartesian Transformation Operator2 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianTransformationOperator2D(IfcCartesianTransformationOperator2D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Cartesian Transformation Operator2 Dnon Uniform</em>'. <!--
	 * begin-user-doc --> This implementation returns null; returning a non-null
	 * result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Cartesian Transformation Operator2 Dnon Uniform</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianTransformationOperator2DnonUniform(IfcCartesianTransformationOperator2DnonUniform object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cartesian Transformation Operator3 D</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cartesian Transformation Operator3 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianTransformationOperator3D(IfcCartesianTransformationOperator3D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Cartesian Transformation Operator3 Dnon Uniform</em>'. <!--
	 * begin-user-doc --> This implementation returns null; returning a non-null
	 * result will terminate the switch. <!-- end-user-doc -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Cartesian Transformation Operator3 Dnon Uniform</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCartesianTransformationOperator3DnonUniform(IfcCartesianTransformationOperator3DnonUniform object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Center Line Profile Def</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Center Line Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCenterLineProfileDef(IfcCenterLineProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Chiller</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Chiller</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcChiller(IfcChiller object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Chiller Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Chiller Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcChillerType(IfcChillerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Chimney</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Chimney</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcChimney(IfcChimney object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Chimney Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Chimney Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcChimneyType(IfcChimneyType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Circle</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Circle</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCircle(IfcCircle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Circle Hollow Profile Def</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Circle Hollow Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCircleHollowProfileDef(IfcCircleHollowProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Circle Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Circle Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCircleProfileDef(IfcCircleProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Civil Element</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Civil Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCivilElement(IfcCivilElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Civil Element Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Civil Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCivilElementType(IfcCivilElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Classification</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Classification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcClassification(IfcClassification object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Classification Reference</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Classification Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcClassificationReference(IfcClassificationReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Closed Shell</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Closed Shell</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcClosedShell(IfcClosedShell object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Coil</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Coil</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCoil(IfcCoil object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Coil Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Coil Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCoilType(IfcCoilType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Colour Rgb</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Colour Rgb</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcColourRgb(IfcColourRgb object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Colour Rgb List</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Colour Rgb List</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcColourRgbList(IfcColourRgbList object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Colour Specification</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Colour Specification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcColourSpecification(IfcColourSpecification object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Column</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Column</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcColumn(IfcColumn object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Column Standard Case</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Column Standard Case</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcColumnStandardCase(IfcColumnStandardCase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Column Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Column Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcColumnType(IfcColumnType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Communications Appliance</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Communications Appliance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCommunicationsAppliance(IfcCommunicationsAppliance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Communications Appliance Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Communications Appliance Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCommunicationsApplianceType(IfcCommunicationsApplianceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Complex Property</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Complex Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcComplexProperty(IfcComplexProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Complex Property Template</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Complex Property Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcComplexPropertyTemplate(IfcComplexPropertyTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Composite Curve</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Composite Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCompositeCurve(IfcCompositeCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Composite Curve On Surface</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Composite Curve On Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCompositeCurveOnSurface(IfcCompositeCurveOnSurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Composite Curve Segment</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Composite Curve Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCompositeCurveSegment(IfcCompositeCurveSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Composite Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Composite Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCompositeProfileDef(IfcCompositeProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Compressor</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Compressor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCompressor(IfcCompressor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Compressor Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Compressor Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCompressorType(IfcCompressorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Condenser</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Condenser</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCondenser(IfcCondenser object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Condenser Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Condenser Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCondenserType(IfcCondenserType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Conic</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Conic</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConic(IfcConic object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Connected Face Set</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Connected Face Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConnectedFaceSet(IfcConnectedFaceSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Connection Curve Geometry</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Connection Curve Geometry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConnectionCurveGeometry(IfcConnectionCurveGeometry object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Connection Geometry</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Connection Geometry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConnectionGeometry(IfcConnectionGeometry object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Connection Point Eccentricity</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Connection Point Eccentricity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConnectionPointEccentricity(IfcConnectionPointEccentricity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Connection Point Geometry</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Connection Point Geometry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConnectionPointGeometry(IfcConnectionPointGeometry object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Connection Surface Geometry</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Connection Surface Geometry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConnectionSurfaceGeometry(IfcConnectionSurfaceGeometry object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Connection Volume Geometry</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Connection Volume Geometry</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConnectionVolumeGeometry(IfcConnectionVolumeGeometry object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Constraint</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstraint(IfcConstraint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Construction Equipment Resource</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Construction Equipment Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstructionEquipmentResource(IfcConstructionEquipmentResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Construction Equipment Resource Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Construction Equipment Resource Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstructionEquipmentResourceType(IfcConstructionEquipmentResourceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Construction Material Resource</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Construction Material Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstructionMaterialResource(IfcConstructionMaterialResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Construction Material Resource Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Construction Material Resource Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstructionMaterialResourceType(IfcConstructionMaterialResourceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Construction Product Resource</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Construction Product Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstructionProductResource(IfcConstructionProductResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Construction Product Resource Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Construction Product Resource Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstructionProductResourceType(IfcConstructionProductResourceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Construction Resource</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Construction Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstructionResource(IfcConstructionResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Construction Resource Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Construction Resource Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConstructionResourceType(IfcConstructionResourceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Context</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Context</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcContext(IfcContext object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Context Dependent Unit</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Context Dependent Unit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcContextDependentUnit(IfcContextDependentUnit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Control</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Control</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcControl(IfcControl object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Controller</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Controller</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcController(IfcController object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Controller Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Controller Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcControllerType(IfcControllerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Conversion Based Unit</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Conversion Based Unit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConversionBasedUnit(IfcConversionBasedUnit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Conversion Based Unit With Offset</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Conversion Based Unit With Offset</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcConversionBasedUnitWithOffset(IfcConversionBasedUnitWithOffset object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cooled Beam</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cooled Beam</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCooledBeam(IfcCooledBeam object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cooled Beam Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cooled Beam Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCooledBeamType(IfcCooledBeamType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cooling Tower</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cooling Tower</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCoolingTower(IfcCoolingTower object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cooling Tower Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cooling Tower Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCoolingTowerType(IfcCoolingTowerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Coordinate Operation</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Coordinate Operation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCoordinateOperation(IfcCoordinateOperation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Coordinate Reference System</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Coordinate Reference System</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCoordinateReferenceSystem(IfcCoordinateReferenceSystem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cost Item</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cost Item</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCostItem(IfcCostItem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cost Schedule</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cost Schedule</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCostSchedule(IfcCostSchedule object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cost Value</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cost Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCostValue(IfcCostValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Covering</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Covering</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCovering(IfcCovering object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Covering Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Covering Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCoveringType(IfcCoveringType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Crew Resource</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Crew Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCrewResource(IfcCrewResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Crew Resource Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Crew Resource Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCrewResourceType(IfcCrewResourceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Csg Primitive3 D</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Csg Primitive3 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCsgPrimitive3D(IfcCsgPrimitive3D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Csg Solid</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Csg Solid</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCsgSolid(IfcCsgSolid object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Currency Relationship</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Currency Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurrencyRelationship(IfcCurrencyRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Curtain Wall</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Curtain Wall</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurtainWall(IfcCurtainWall object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Curtain Wall Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Curtain Wall Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurtainWallType(IfcCurtainWallType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Curve</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurve(IfcCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Curve Bounded Plane</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Curve Bounded Plane</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurveBoundedPlane(IfcCurveBoundedPlane object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Curve Bounded Surface</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Curve Bounded Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurveBoundedSurface(IfcCurveBoundedSurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Curve Style</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Curve Style</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurveStyle(IfcCurveStyle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Curve Style Font</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Curve Style Font</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurveStyleFont(IfcCurveStyleFont object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Curve Style Font And Scaling</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Curve Style Font And Scaling</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurveStyleFontAndScaling(IfcCurveStyleFontAndScaling object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Curve Style Font Pattern</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Curve Style Font Pattern</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCurveStyleFontPattern(IfcCurveStyleFontPattern object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Cylindrical Surface</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Cylindrical Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcCylindricalSurface(IfcCylindricalSurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Damper</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Damper</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDamper(IfcDamper object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Damper Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Damper Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDamperType(IfcDamperType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Derived Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Derived Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDerivedProfileDef(IfcDerivedProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Derived Unit</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Derived Unit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDerivedUnit(IfcDerivedUnit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Derived Unit Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Derived Unit Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDerivedUnitElement(IfcDerivedUnitElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Dimensional Exponents</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Dimensional Exponents</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDimensionalExponents(IfcDimensionalExponents object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Direction</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Direction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDirection(IfcDirection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Discrete Accessory</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Discrete Accessory</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDiscreteAccessory(IfcDiscreteAccessory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Discrete Accessory Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Discrete Accessory Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDiscreteAccessoryType(IfcDiscreteAccessoryType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Chamber Element</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Chamber Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionChamberElement(IfcDistributionChamberElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Chamber Element Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Chamber Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionChamberElementType(IfcDistributionChamberElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Circuit</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Circuit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionCircuit(IfcDistributionCircuit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Control Element</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Control Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionControlElement(IfcDistributionControlElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Control Element Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Control Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionControlElementType(IfcDistributionControlElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionElement(IfcDistributionElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Element Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionElementType(IfcDistributionElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Flow Element</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Flow Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionFlowElement(IfcDistributionFlowElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Flow Element Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Flow Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionFlowElementType(IfcDistributionFlowElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution Port</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution Port</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionPort(IfcDistributionPort object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Distribution System</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Distribution System</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDistributionSystem(IfcDistributionSystem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Document Information</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Document Information</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDocumentInformation(IfcDocumentInformation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Document Information Relationship</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Document Information Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDocumentInformationRelationship(IfcDocumentInformationRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Document Reference</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Document Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDocumentReference(IfcDocumentReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Door</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Door</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDoor(IfcDoor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Door Lining Properties</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Door Lining Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDoorLiningProperties(IfcDoorLiningProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Door Panel Properties</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Door Panel Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDoorPanelProperties(IfcDoorPanelProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Door Standard Case</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Door Standard Case</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDoorStandardCase(IfcDoorStandardCase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Door Style</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Door Style</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDoorStyle(IfcDoorStyle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Door Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Door Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDoorType(IfcDoorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Draughting Pre Defined Colour</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Draughting Pre Defined Colour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDraughtingPreDefinedColour(IfcDraughtingPreDefinedColour object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Draughting Pre Defined Curve Font</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Draughting Pre Defined Curve Font</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDraughtingPreDefinedCurveFont(IfcDraughtingPreDefinedCurveFont object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Duct Fitting</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Duct Fitting</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDuctFitting(IfcDuctFitting object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Duct Fitting Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Duct Fitting Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDuctFittingType(IfcDuctFittingType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Duct Segment</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Duct Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDuctSegment(IfcDuctSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Duct Segment Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Duct Segment Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDuctSegmentType(IfcDuctSegmentType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Duct Silencer</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Duct Silencer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDuctSilencer(IfcDuctSilencer object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Duct Silencer Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Duct Silencer Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcDuctSilencerType(IfcDuctSilencerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Edge</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Edge</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEdge(IfcEdge object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Edge Curve</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Edge Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEdgeCurve(IfcEdgeCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Edge Loop</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Edge Loop</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEdgeLoop(IfcEdgeLoop object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Appliance</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Appliance</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricAppliance(IfcElectricAppliance object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Appliance Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Appliance Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricApplianceType(IfcElectricApplianceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Distribution Board</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Distribution Board</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricDistributionBoard(IfcElectricDistributionBoard object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Distribution Board Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Distribution Board Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricDistributionBoardType(IfcElectricDistributionBoardType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Flow Storage Device</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Flow Storage Device</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricFlowStorageDevice(IfcElectricFlowStorageDevice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Flow Storage Device Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Flow Storage Device Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricFlowStorageDeviceType(IfcElectricFlowStorageDeviceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Generator</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Generator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricGenerator(IfcElectricGenerator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Generator Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Generator Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricGeneratorType(IfcElectricGeneratorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Motor</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Motor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricMotor(IfcElectricMotor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Motor Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Motor Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricMotorType(IfcElectricMotorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Time Control</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Time Control</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricTimeControl(IfcElectricTimeControl object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Electric Time Control Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Electric Time Control Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElectricTimeControlType(IfcElectricTimeControlType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Element</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElement(IfcElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Element Assembly</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Element Assembly</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElementAssembly(IfcElementAssembly object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Element Assembly Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Element Assembly Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElementAssemblyType(IfcElementAssemblyType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Element Component</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Element Component</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElementComponent(IfcElementComponent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Element Component Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Element Component Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElementComponentType(IfcElementComponentType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Element Quantity</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Element Quantity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElementQuantity(IfcElementQuantity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Element Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElementType(IfcElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Elementary Surface</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Elementary Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcElementarySurface(IfcElementarySurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Ellipse</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Ellipse</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEllipse(IfcEllipse object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Ellipse Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Ellipse Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEllipseProfileDef(IfcEllipseProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Energy Conversion Device</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Energy Conversion Device</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEnergyConversionDevice(IfcEnergyConversionDevice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Energy Conversion Device Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Energy Conversion Device Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEnergyConversionDeviceType(IfcEnergyConversionDeviceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Engine</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Engine</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEngine(IfcEngine object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Engine Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Engine Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEngineType(IfcEngineType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Evaporative Cooler</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Evaporative Cooler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEvaporativeCooler(IfcEvaporativeCooler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Evaporative Cooler Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Evaporative Cooler Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEvaporativeCoolerType(IfcEvaporativeCoolerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Evaporator</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Evaporator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEvaporator(IfcEvaporator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Evaporator Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Evaporator Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEvaporatorType(IfcEvaporatorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Event</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEvent(IfcEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Event Time</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Event Time</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEventTime(IfcEventTime object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Event Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Event Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcEventType(IfcEventType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Extended Properties</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Extended Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExtendedProperties(IfcExtendedProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc External Information</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc External Information</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExternalInformation(IfcExternalInformation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc External Reference</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc External Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExternalReference(IfcExternalReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc External Reference Relationship</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc External Reference Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExternalReferenceRelationship(IfcExternalReferenceRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc External Spatial Element</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc External Spatial Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExternalSpatialElement(IfcExternalSpatialElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc External Spatial Structure Element</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc External Spatial Structure Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExternalSpatialStructureElement(IfcExternalSpatialStructureElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Externally Defined Hatch Style</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Externally Defined Hatch Style</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExternallyDefinedHatchStyle(IfcExternallyDefinedHatchStyle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Externally Defined Surface Style</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Externally Defined Surface Style</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExternallyDefinedSurfaceStyle(IfcExternallyDefinedSurfaceStyle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Externally Defined Text Font</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Externally Defined Text Font</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExternallyDefinedTextFont(IfcExternallyDefinedTextFont object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Extruded Area Solid</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Extruded Area Solid</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExtrudedAreaSolid(IfcExtrudedAreaSolid object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Extruded Area Solid Tapered</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Extruded Area Solid Tapered</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcExtrudedAreaSolidTapered(IfcExtrudedAreaSolidTapered object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Face</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Face</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFace(IfcFace object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Face Based Surface Model</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Face Based Surface Model</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFaceBasedSurfaceModel(IfcFaceBasedSurfaceModel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Face Bound</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Face Bound</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFaceBound(IfcFaceBound object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Face Outer Bound</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Face Outer Bound</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFaceOuterBound(IfcFaceOuterBound object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Face Surface</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Face Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFaceSurface(IfcFaceSurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Faceted Brep</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Faceted Brep</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFacetedBrep(IfcFacetedBrep object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Faceted Brep With Voids</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Faceted Brep With Voids</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFacetedBrepWithVoids(IfcFacetedBrepWithVoids object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Failure Connection Condition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Failure Connection Condition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFailureConnectionCondition(IfcFailureConnectionCondition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Fan</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Fan</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFan(IfcFan object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Fan Type</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Fan Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFanType(IfcFanType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Fastener</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Fastener</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFastener(IfcFastener object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Fastener Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Fastener Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFastenerType(IfcFastenerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Feature Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Feature Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFeatureElement(IfcFeatureElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Feature Element Addition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Feature Element Addition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFeatureElementAddition(IfcFeatureElementAddition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Feature Element Subtraction</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Feature Element Subtraction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFeatureElementSubtraction(IfcFeatureElementSubtraction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Fill Area Style</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Fill Area Style</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFillAreaStyle(IfcFillAreaStyle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Fill Area Style Hatching</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Fill Area Style Hatching</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFillAreaStyleHatching(IfcFillAreaStyleHatching object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Fill Area Style Tiles</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Fill Area Style Tiles</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFillAreaStyleTiles(IfcFillAreaStyleTiles object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Filter</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Filter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFilter(IfcFilter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Filter Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Filter Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFilterType(IfcFilterType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Fire Suppression Terminal</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Fire Suppression Terminal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFireSuppressionTerminal(IfcFireSuppressionTerminal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Fire Suppression Terminal Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Fire Suppression Terminal Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFireSuppressionTerminalType(IfcFireSuppressionTerminalType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Fixed Reference Swept Area Solid</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Fixed Reference Swept Area Solid</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFixedReferenceSweptAreaSolid(IfcFixedReferenceSweptAreaSolid object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Controller</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Controller</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowController(IfcFlowController object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Controller Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Controller Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowControllerType(IfcFlowControllerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Fitting</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Fitting</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowFitting(IfcFlowFitting object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Fitting Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Fitting Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowFittingType(IfcFlowFittingType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Instrument</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Instrument</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowInstrument(IfcFlowInstrument object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Instrument Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Instrument Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowInstrumentType(IfcFlowInstrumentType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Meter</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Meter</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowMeter(IfcFlowMeter object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Meter Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Meter Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowMeterType(IfcFlowMeterType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Moving Device</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Moving Device</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowMovingDevice(IfcFlowMovingDevice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Moving Device Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Moving Device Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowMovingDeviceType(IfcFlowMovingDeviceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Segment</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowSegment(IfcFlowSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Segment Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Segment Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowSegmentType(IfcFlowSegmentType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Storage Device</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Storage Device</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowStorageDevice(IfcFlowStorageDevice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Storage Device Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Storage Device Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowStorageDeviceType(IfcFlowStorageDeviceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Terminal</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Terminal</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowTerminal(IfcFlowTerminal object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Terminal Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Terminal Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowTerminalType(IfcFlowTerminalType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Treatment Device</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Treatment Device</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowTreatmentDevice(IfcFlowTreatmentDevice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Flow Treatment Device Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Flow Treatment Device Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFlowTreatmentDeviceType(IfcFlowTreatmentDeviceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Footing</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Footing</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFooting(IfcFooting object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Footing Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Footing Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFootingType(IfcFootingType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Furnishing Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Furnishing Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFurnishingElement(IfcFurnishingElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Furnishing Element Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Furnishing Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFurnishingElementType(IfcFurnishingElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Furniture</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Furniture</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFurniture(IfcFurniture object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Furniture Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Furniture Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcFurnitureType(IfcFurnitureType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Geographic Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Geographic Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGeographicElement(IfcGeographicElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Geographic Element Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Geographic Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGeographicElementType(IfcGeographicElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Geometric Curve Set</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Geometric Curve Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGeometricCurveSet(IfcGeometricCurveSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Geometric Representation Context</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Geometric Representation Context</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGeometricRepresentationContext(IfcGeometricRepresentationContext object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Geometric Representation Item</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Geometric Representation Item</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGeometricRepresentationItem(IfcGeometricRepresentationItem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Geometric Representation Sub Context</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Geometric Representation Sub Context</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGeometricRepresentationSubContext(IfcGeometricRepresentationSubContext object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Geometric Set</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Geometric Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGeometricSet(IfcGeometricSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Grid</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Grid</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGrid(IfcGrid object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Grid Axis</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Grid Axis</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGridAxis(IfcGridAxis object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Grid Placement</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Grid Placement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGridPlacement(IfcGridPlacement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Group</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Group</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcGroup(IfcGroup object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Half Space Solid</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Half Space Solid</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcHalfSpaceSolid(IfcHalfSpaceSolid object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Heat Exchanger</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Heat Exchanger</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcHeatExchanger(IfcHeatExchanger object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Heat Exchanger Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Heat Exchanger Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcHeatExchangerType(IfcHeatExchangerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Humidifier</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Humidifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcHumidifier(IfcHumidifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Humidifier Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Humidifier Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcHumidifierType(IfcHumidifierType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc IShape Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc IShape Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIShapeProfileDef(IfcIShapeProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Image Texture</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Image Texture</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcImageTexture(IfcImageTexture object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Indexed Colour Map</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Indexed Colour Map</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIndexedColourMap(IfcIndexedColourMap object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Indexed Poly Curve</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Indexed Poly Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIndexedPolyCurve(IfcIndexedPolyCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Indexed Polygonal Face</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Indexed Polygonal Face</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIndexedPolygonalFace(IfcIndexedPolygonalFace object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Indexed Polygonal Face With Voids</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Indexed Polygonal Face With Voids</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIndexedPolygonalFaceWithVoids(IfcIndexedPolygonalFaceWithVoids object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Indexed Texture Map</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Indexed Texture Map</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIndexedTextureMap(IfcIndexedTextureMap object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Indexed Triangle Texture Map</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Indexed Triangle Texture Map</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIndexedTriangleTextureMap(IfcIndexedTriangleTextureMap object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Interceptor</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Interceptor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcInterceptor(IfcInterceptor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Interceptor Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Interceptor Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcInterceptorType(IfcInterceptorType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Intersection Curve</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Intersection Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIntersectionCurve(IfcIntersectionCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Inventory</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Inventory</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcInventory(IfcInventory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Irregular Time Series</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Irregular Time Series</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIrregularTimeSeries(IfcIrregularTimeSeries object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Irregular Time Series Value</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Irregular Time Series Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcIrregularTimeSeriesValue(IfcIrregularTimeSeriesValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Junction Box</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Junction Box</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcJunctionBox(IfcJunctionBox object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Junction Box Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Junction Box Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcJunctionBoxType(IfcJunctionBoxType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc LShape Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc LShape Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLShapeProfileDef(IfcLShapeProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Labor Resource</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Labor Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLaborResource(IfcLaborResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Labor Resource Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Labor Resource Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLaborResourceType(IfcLaborResourceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Lag Time</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Lag Time</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLagTime(IfcLagTime object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Lamp</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Lamp</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLamp(IfcLamp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Lamp Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Lamp Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLampType(IfcLampType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Library Information</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Library Information</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLibraryInformation(IfcLibraryInformation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Library Reference</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Library Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLibraryReference(IfcLibraryReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Distribution Data</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Distribution Data</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightDistributionData(IfcLightDistributionData object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Fixture</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Fixture</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightFixture(IfcLightFixture object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Fixture Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Fixture Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightFixtureType(IfcLightFixtureType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Intensity Distribution</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Intensity Distribution</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightIntensityDistribution(IfcLightIntensityDistribution object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Source</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Source</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightSource(IfcLightSource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Source Ambient</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Source Ambient</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightSourceAmbient(IfcLightSourceAmbient object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Source Directional</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Source Directional</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightSourceDirectional(IfcLightSourceDirectional object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Source Goniometric</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Source Goniometric</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightSourceGoniometric(IfcLightSourceGoniometric object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Source Positional</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Source Positional</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightSourcePositional(IfcLightSourcePositional object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Light Source Spot</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Light Source Spot</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLightSourceSpot(IfcLightSourceSpot object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Line</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Line</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLine(IfcLine object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Local Placement</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Local Placement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLocalPlacement(IfcLocalPlacement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Loop</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Loop</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcLoop(IfcLoop object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Manifold Solid Brep</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Manifold Solid Brep</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcManifoldSolidBrep(IfcManifoldSolidBrep object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Map Conversion</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Map Conversion</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMapConversion(IfcMapConversion object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Mapped Item</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Mapped Item</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMappedItem(IfcMappedItem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Material</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Material</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterial(IfcMaterial object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Classification Relationship</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Classification Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialClassificationRelationship(IfcMaterialClassificationRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Constituent</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Constituent</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialConstituent(IfcMaterialConstituent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Constituent Set</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Constituent Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialConstituentSet(IfcMaterialConstituentSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Definition</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialDefinition(IfcMaterialDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Definition Representation</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Definition Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialDefinitionRepresentation(IfcMaterialDefinitionRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Layer</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Layer</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialLayer(IfcMaterialLayer object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Layer Set</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Layer Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialLayerSet(IfcMaterialLayerSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Layer Set Usage</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Layer Set Usage</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialLayerSetUsage(IfcMaterialLayerSetUsage object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Layer With Offsets</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Layer With Offsets</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialLayerWithOffsets(IfcMaterialLayerWithOffsets object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material List</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material List</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialList(IfcMaterialList object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Profile</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Profile</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialProfile(IfcMaterialProfile object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Profile Set</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Profile Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialProfileSet(IfcMaterialProfileSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Profile Set Usage</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Profile Set Usage</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialProfileSetUsage(IfcMaterialProfileSetUsage object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Profile Set Usage Tapering</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Profile Set Usage Tapering</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialProfileSetUsageTapering(IfcMaterialProfileSetUsageTapering object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Profile With Offsets</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Profile With Offsets</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialProfileWithOffsets(IfcMaterialProfileWithOffsets object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Properties</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialProperties(IfcMaterialProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Relationship</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialRelationship(IfcMaterialRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Material Usage Definition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Material Usage Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMaterialUsageDefinition(IfcMaterialUsageDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Measure With Unit</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Measure With Unit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMeasureWithUnit(IfcMeasureWithUnit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Mechanical Fastener</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Mechanical Fastener</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMechanicalFastener(IfcMechanicalFastener object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Mechanical Fastener Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Mechanical Fastener Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMechanicalFastenerType(IfcMechanicalFastenerType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Medical Device</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Medical Device</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMedicalDevice(IfcMedicalDevice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Medical Device Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Medical Device Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMedicalDeviceType(IfcMedicalDeviceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Member</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Member</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMember(IfcMember object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Member Standard Case</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Member Standard Case</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMemberStandardCase(IfcMemberStandardCase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Member Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Member Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMemberType(IfcMemberType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Metric</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Metric</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMetric(IfcMetric object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Mirrored Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Mirrored Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMirroredProfileDef(IfcMirroredProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Monetary Unit</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Monetary Unit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMonetaryUnit(IfcMonetaryUnit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Motor Connection</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Motor Connection</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMotorConnection(IfcMotorConnection object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Motor Connection Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Motor Connection Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcMotorConnectionType(IfcMotorConnectionType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Named Unit</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Named Unit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcNamedUnit(IfcNamedUnit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Object</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcObject(IfcObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Object Definition</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Object Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcObjectDefinition(IfcObjectDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Object Placement</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Object Placement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcObjectPlacement(IfcObjectPlacement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Objective</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Objective</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcObjective(IfcObjective object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Occupant</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Occupant</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOccupant(IfcOccupant object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Offset Curve2 D</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Offset Curve2 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOffsetCurve2D(IfcOffsetCurve2D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Offset Curve3 D</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Offset Curve3 D</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOffsetCurve3D(IfcOffsetCurve3D object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Open Shell</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Open Shell</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOpenShell(IfcOpenShell object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Opening Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Opening Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOpeningElement(IfcOpeningElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Opening Standard Case</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Opening Standard Case</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOpeningStandardCase(IfcOpeningStandardCase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Organization</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Organization</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOrganization(IfcOrganization object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Organization Relationship</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Organization Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOrganizationRelationship(IfcOrganizationRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Oriented Edge</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Oriented Edge</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOrientedEdge(IfcOrientedEdge object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Outer Boundary Curve</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Outer Boundary Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOuterBoundaryCurve(IfcOuterBoundaryCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Outlet</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Outlet</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOutlet(IfcOutlet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Outlet Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Outlet Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOutletType(IfcOutletType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Owner History</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Owner History</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcOwnerHistory(IfcOwnerHistory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Parameterized Profile Def</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Parameterized Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcParameterizedProfileDef(IfcParameterizedProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Path</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Path</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPath(IfcPath object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Pcurve</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Pcurve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPcurve(IfcPcurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Performance History</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Performance History</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPerformanceHistory(IfcPerformanceHistory object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Permeable Covering Properties</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Permeable Covering Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPermeableCoveringProperties(IfcPermeableCoveringProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Permit</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Permit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPermit(IfcPermit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Person</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Person</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPerson(IfcPerson object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Person And Organization</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Person And Organization</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPersonAndOrganization(IfcPersonAndOrganization object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Physical Complex Quantity</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Physical Complex Quantity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPhysicalComplexQuantity(IfcPhysicalComplexQuantity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Physical Quantity</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Physical Quantity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPhysicalQuantity(IfcPhysicalQuantity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Physical Simple Quantity</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Physical Simple Quantity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPhysicalSimpleQuantity(IfcPhysicalSimpleQuantity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Pile</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Pile</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPile(IfcPile object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pile Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pile Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPileType(IfcPileType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pipe Fitting</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pipe Fitting</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPipeFitting(IfcPipeFitting object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pipe Fitting Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pipe Fitting Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPipeFittingType(IfcPipeFittingType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pipe Segment</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pipe Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPipeSegment(IfcPipeSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pipe Segment Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pipe Segment Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPipeSegmentType(IfcPipeSegmentType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pixel Texture</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pixel Texture</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPixelTexture(IfcPixelTexture object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Placement</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Placement</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPlacement(IfcPlacement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Planar Box</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Planar Box</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPlanarBox(IfcPlanarBox object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Planar Extent</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Planar Extent</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPlanarExtent(IfcPlanarExtent object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Plane</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Plane</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPlane(IfcPlane object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Plate</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Plate</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPlate(IfcPlate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Plate Standard Case</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Plate Standard Case</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPlateStandardCase(IfcPlateStandardCase object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Plate Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Plate Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPlateType(IfcPlateType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Point</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Point</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPoint(IfcPoint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Point On Curve</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Point On Curve</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPointOnCurve(IfcPointOnCurve object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Point On Surface</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Point On Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPointOnSurface(IfcPointOnSurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Poly Loop</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Poly Loop</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPolyLoop(IfcPolyLoop object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Polygonal Bounded Half Space</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Polygonal Bounded Half Space</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPolygonalBoundedHalfSpace(IfcPolygonalBoundedHalfSpace object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Polygonal Face Set</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Polygonal Face Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPolygonalFaceSet(IfcPolygonalFaceSet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Polyline</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Polyline</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPolyline(IfcPolyline object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Port</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Port</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPort(IfcPort object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Postal Address</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Postal Address</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPostalAddress(IfcPostalAddress object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pre Defined Colour</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pre Defined Colour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPreDefinedColour(IfcPreDefinedColour object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pre Defined Curve Font</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pre Defined Curve Font</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPreDefinedCurveFont(IfcPreDefinedCurveFont object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pre Defined Item</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pre Defined Item</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPreDefinedItem(IfcPreDefinedItem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pre Defined Properties</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pre Defined Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPreDefinedProperties(IfcPreDefinedProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pre Defined Property Set</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pre Defined Property Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPreDefinedPropertySet(IfcPreDefinedPropertySet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pre Defined Text Font</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pre Defined Text Font</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPreDefinedTextFont(IfcPreDefinedTextFont object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Presentation Item</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Presentation Item</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPresentationItem(IfcPresentationItem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Presentation Layer Assignment</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Presentation Layer Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPresentationLayerAssignment(IfcPresentationLayerAssignment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Presentation Layer With Style</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Presentation Layer With Style</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPresentationLayerWithStyle(IfcPresentationLayerWithStyle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Presentation Style</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Presentation Style</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPresentationStyle(IfcPresentationStyle object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Presentation Style Assignment</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Presentation Style Assignment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPresentationStyleAssignment(IfcPresentationStyleAssignment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Procedure</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Procedure</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProcedure(IfcProcedure object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Procedure Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Procedure Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProcedureType(IfcProcedureType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Process</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProcess(IfcProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Product</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Product</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProduct(IfcProduct object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Product Definition Shape</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Product Definition Shape</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProductDefinitionShape(IfcProductDefinitionShape object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Product Representation</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Product Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProductRepresentation(IfcProductRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProfileDef(IfcProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Profile Properties</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Profile Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProfileProperties(IfcProfileProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Project</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Project</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProject(IfcProject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Project Library</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Project Library</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProjectLibrary(IfcProjectLibrary object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Project Order</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Project Order</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProjectOrder(IfcProjectOrder object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Projected CRS</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Projected CRS</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProjectedCRS(IfcProjectedCRS object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Projection Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Projection Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProjectionElement(IfcProjectionElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Property</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Property</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProperty(IfcProperty object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Abstraction</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Abstraction</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyAbstraction(IfcPropertyAbstraction object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Bounded Value</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Bounded Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyBoundedValue(IfcPropertyBoundedValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Definition</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyDefinition(IfcPropertyDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Dependency Relationship</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Dependency Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyDependencyRelationship(IfcPropertyDependencyRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Enumerated Value</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Enumerated Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyEnumeratedValue(IfcPropertyEnumeratedValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Enumeration</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyEnumeration(IfcPropertyEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property List Value</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property List Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyListValue(IfcPropertyListValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Reference Value</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Reference Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyReferenceValue(IfcPropertyReferenceValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Set</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertySet(IfcPropertySet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Set Definition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Set Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertySetDefinition(IfcPropertySetDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Set Template</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Set Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertySetTemplate(IfcPropertySetTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Single Value</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Single Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertySingleValue(IfcPropertySingleValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Table Value</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Table Value</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyTableValue(IfcPropertyTableValue object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Template</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyTemplate(IfcPropertyTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Property Template Definition</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Property Template Definition</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPropertyTemplateDefinition(IfcPropertyTemplateDefinition object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Protective Device</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Protective Device</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProtectiveDevice(IfcProtectiveDevice object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Protective Device Tripping Unit</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Protective Device Tripping Unit</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProtectiveDeviceTrippingUnit(IfcProtectiveDeviceTrippingUnit object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Protective Device Tripping Unit Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Protective Device Tripping Unit Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProtectiveDeviceTrippingUnitType(IfcProtectiveDeviceTrippingUnitType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Protective Device Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Protective Device Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProtectiveDeviceType(IfcProtectiveDeviceType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Proxy</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Proxy</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcProxy(IfcProxy object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Pump</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Pump</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPump(IfcPump object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Pump Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Pump Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcPumpType(IfcPumpType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Quantity Area</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Quantity Area</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcQuantityArea(IfcQuantityArea object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Quantity Count</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Quantity Count</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcQuantityCount(IfcQuantityCount object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Quantity Length</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Quantity Length</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcQuantityLength(IfcQuantityLength object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Quantity Set</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Quantity Set</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcQuantitySet(IfcQuantitySet object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Quantity Time</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Quantity Time</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcQuantityTime(IfcQuantityTime object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Quantity Volume</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Quantity Volume</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcQuantityVolume(IfcQuantityVolume object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Quantity Weight</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Quantity Weight</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcQuantityWeight(IfcQuantityWeight object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Railing</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Railing</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRailing(IfcRailing object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Railing Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Railing Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRailingType(IfcRailingType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Ramp</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Ramp</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRamp(IfcRamp object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Ramp Flight</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Ramp Flight</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRampFlight(IfcRampFlight object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Ramp Flight Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Ramp Flight Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRampFlightType(IfcRampFlightType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Ramp Type</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Ramp Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRampType(IfcRampType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rational BSpline Curve With Knots</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rational BSpline Curve With Knots</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRationalBSplineCurveWithKnots(IfcRationalBSplineCurveWithKnots object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rational BSpline Surface With Knots</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rational BSpline Surface With Knots</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRationalBSplineSurfaceWithKnots(IfcRationalBSplineSurfaceWithKnots object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rectangle Hollow Profile Def</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rectangle Hollow Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRectangleHollowProfileDef(IfcRectangleHollowProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rectangle Profile Def</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rectangle Profile Def</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRectangleProfileDef(IfcRectangleProfileDef object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rectangular Pyramid</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rectangular Pyramid</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRectangularPyramid(IfcRectangularPyramid object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rectangular Trimmed Surface</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rectangular Trimmed Surface</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRectangularTrimmedSurface(IfcRectangularTrimmedSurface object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Recurrence Pattern</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Recurrence Pattern</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRecurrencePattern(IfcRecurrencePattern object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reference</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReference(IfcReference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Regular Time Series</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Regular Time Series</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRegularTimeSeries(IfcRegularTimeSeries object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reinforcement Bar Properties</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reinforcement Bar Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReinforcementBarProperties(IfcReinforcementBarProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reinforcement Definition Properties</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reinforcement Definition Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReinforcementDefinitionProperties(IfcReinforcementDefinitionProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reinforcing Bar</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reinforcing Bar</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReinforcingBar(IfcReinforcingBar object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reinforcing Bar Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reinforcing Bar Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReinforcingBarType(IfcReinforcingBarType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reinforcing Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reinforcing Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReinforcingElement(IfcReinforcingElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reinforcing Element Type</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reinforcing Element Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReinforcingElementType(IfcReinforcingElementType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reinforcing Mesh</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reinforcing Mesh</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReinforcingMesh(IfcReinforcingMesh object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reinforcing Mesh Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reinforcing Mesh Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReinforcingMeshType(IfcReinforcingMeshType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Aggregates</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Aggregates</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAggregates(IfcRelAggregates object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Assigns</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Assigns</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssigns(IfcRelAssigns object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Actor</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Actor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssignsToActor(IfcRelAssignsToActor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Control</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Control</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssignsToControl(IfcRelAssignsToControl object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Group</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Group</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssignsToGroup(IfcRelAssignsToGroup object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Group By Factor</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Group By Factor</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssignsToGroupByFactor(IfcRelAssignsToGroupByFactor object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Process</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Process</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssignsToProcess(IfcRelAssignsToProcess object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Product</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Product</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssignsToProduct(IfcRelAssignsToProduct object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Resource</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Assigns To Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssignsToResource(IfcRelAssignsToResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Associates</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Associates</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssociates(IfcRelAssociates object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Associates Approval</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Associates Approval</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssociatesApproval(IfcRelAssociatesApproval object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Associates Classification</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Associates Classification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssociatesClassification(IfcRelAssociatesClassification object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Associates Constraint</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Associates Constraint</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssociatesConstraint(IfcRelAssociatesConstraint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Associates Document</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Associates Document</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssociatesDocument(IfcRelAssociatesDocument object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Associates Library</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Associates Library</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssociatesLibrary(IfcRelAssociatesLibrary object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Associates Material</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Associates Material</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelAssociatesMaterial(IfcRelAssociatesMaterial object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnects(IfcRelConnects object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects Elements</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects Elements</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnectsElements(IfcRelConnectsElements object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects Path Elements</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects Path Elements</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnectsPathElements(IfcRelConnectsPathElements object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects Port To Element</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects Port To Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnectsPortToElement(IfcRelConnectsPortToElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects Ports</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects Ports</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnectsPorts(IfcRelConnectsPorts object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects Structural Activity</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects Structural Activity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnectsStructuralActivity(IfcRelConnectsStructuralActivity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects Structural Member</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects Structural Member</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnectsStructuralMember(IfcRelConnectsStructuralMember object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects With Eccentricity</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects With Eccentricity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnectsWithEccentricity(IfcRelConnectsWithEccentricity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Connects With Realizing Elements</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Connects With Realizing Elements</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelConnectsWithRealizingElements(IfcRelConnectsWithRealizingElements object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Contained In Spatial Structure</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Contained In Spatial Structure</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelContainedInSpatialStructure(IfcRelContainedInSpatialStructure object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Covers Bldg Elements</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Covers Bldg Elements</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelCoversBldgElements(IfcRelCoversBldgElements object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Covers Spaces</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Covers Spaces</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelCoversSpaces(IfcRelCoversSpaces object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Declares</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Declares</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelDeclares(IfcRelDeclares object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Decomposes</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Decomposes</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelDecomposes(IfcRelDecomposes object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Defines</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Defines</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelDefines(IfcRelDefines object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Defines By Object</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Defines By Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelDefinesByObject(IfcRelDefinesByObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Defines By Properties</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Defines By Properties</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelDefinesByProperties(IfcRelDefinesByProperties object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Defines By Template</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Defines By Template</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelDefinesByTemplate(IfcRelDefinesByTemplate object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Defines By Type</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Defines By Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelDefinesByType(IfcRelDefinesByType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Fills Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Fills Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelFillsElement(IfcRelFillsElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Flow Control Elements</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Flow Control Elements</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelFlowControlElements(IfcRelFlowControlElements object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Interferes Elements</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Interferes Elements</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelInterferesElements(IfcRelInterferesElements object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Nests</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Nests</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelNests(IfcRelNests object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Projects Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Projects Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelProjectsElement(IfcRelProjectsElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Referenced In Spatial Structure</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Referenced In Spatial Structure</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelReferencedInSpatialStructure(IfcRelReferencedInSpatialStructure object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Sequence</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Sequence</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelSequence(IfcRelSequence object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Services Buildings</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Services Buildings</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelServicesBuildings(IfcRelServicesBuildings object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Space Boundary</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Space Boundary</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelSpaceBoundary(IfcRelSpaceBoundary object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Space Boundary1st Level</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Space Boundary1st Level</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelSpaceBoundary1stLevel(IfcRelSpaceBoundary1stLevel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Space Boundary2nd Level</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Space Boundary2nd Level</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelSpaceBoundary2ndLevel(IfcRelSpaceBoundary2ndLevel object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Rel Voids Element</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Rel Voids Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelVoidsElement(IfcRelVoidsElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Relationship</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRelationship(IfcRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Reparametrised Composite Curve Segment</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null; returning a non-null result will
	 * terminate the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Reparametrised Composite Curve Segment</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcReparametrisedCompositeCurveSegment(IfcReparametrisedCompositeCurveSegment object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Representation</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Representation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRepresentation(IfcRepresentation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Representation Context</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Representation Context</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRepresentationContext(IfcRepresentationContext object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Representation Item</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Representation Item</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRepresentationItem(IfcRepresentationItem object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Representation Map</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Representation Map</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRepresentationMap(IfcRepresentationMap object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc
	 * Resource</em>'. <!-- begin-user-doc --> This implementation returns null;
	 * returning a non-null result will terminate the switch. <!-- end-user-doc
	 * -->
	 * 
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc
	 *         Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcResource(IfcResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Resource Approval Relationship</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Resource Approval Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcResourceApprovalRelationship(IfcResourceApprovalRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Resource Constraint Relationship</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Resource Constraint Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcResourceConstraintRelationship(IfcResourceConstraintRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Resource Level Relationship</em>'.
	 * <!-- begin-user-doc --> This
	 * implementation returns null; returning a non-null result will terminate
	 * the switch. <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Resource Level Relationship</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcResourceLevelRelationship(IfcResourceLevelRelationship object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Resource Time</em>'.
	 * <!-- begin-user-doc --> This implementation returns
	 * null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Resource Time</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcResourceTime(IfcResourceTime object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Ifc Revolved Area Solid</em>'.
	 * <!-- begin-user-doc --> This implementation
	 * returns null; returning a non-null result will terminate the switch. <!--
	 * end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Ifc Revolved Area Solid</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIfcRevolvedAreaSolid(IfcRevolvedAreaSolid object) {
		return null;
	}

	/**
	 * Returns the result o