package org.bimserver.interfaces.objects;

/******************************************************************************
 * Copyright (C) 2009-2019  BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see {@literal<http://www.gnu.org/licenses/>}.
 *****************************************************************************/
import java.util.Date;
import javax.xml.bind.annotation.XmlTransient;
import org.bimserver.shared.meta.*;
import javax.xml.bind.annotation.XmlRootElement;


@XmlRootElement
public class SOAuthAuthorizationCode implements SDataBase
{
	private long oid = -1;
	private int rid = 0;

	@XmlTransient
	private static SClass sClass;
	private long oauthServerId = -1;
	private java.lang.String code;
	private long authorizationId = -1;
	private long userId = -1;
	private java.util.Date issued;

	public long getOid() {
		return this.oid;
	}

	public void setOid(long oid) {
		this.oid = oid;
	}

	public int getRid() {
		return rid;
	}
	
	public void setRid(int rid) {
		this.rid = rid;
	}
	
	@XmlTransient
	public SClass getSClass() {
		return sClass;
	}
	
	public static void setSClass(SClass sClass) {
		SOAuthAuthorizationCode.sClass = sClass;
	}

	public Object sGet(SField sField) {
		if (sField.getName().equals("oauthServerId")) {
			return getOauthServerId();
		}
		if (sField.getName().equals("code")) {
			return getCode();
		}
		if (sField.getName().equals("authorizationId")) {
			return getAuthorizationId();
		}
		if (sField.getName().equals("userId")) {
			return getUserId();
		}
		if (sField.getName().equals("issued")) {
			return getIssued();
		}
		if (sField.getName().equals("oid")) {
			return getOid();
		}
		if (sField.getName().equals("rid")) {
			return getRid();
		}
		throw new RuntimeException("Field " + sField.getName() + " not found");
	}

	public void sSet(SField sField, Object val) {
		if (sField.getName().equals("oauthServerId")) {
			setOauthServerId((Long)val);
			return;
		}
		if (sField.getName().equals("code")) {
			setCode((String)val);
			return;
		}
		if (sField.getName().equals("authorizationId")) {
			setAuthorizationId((Long)val);
			return;
		}
		if (sField.getName().equals("userId")) {
			setUserId((Long)val);
			return;
		}
		if (sField.getName().equals("issued")) {
			setIssued((Date)val);
			return;
		}
		if (sField.getName().equals("oid")) {
			setOid((Long)val);
			return;
		}
		if (sField.getName().equals("rid")) {
			setRid((Integer)val);
			return;
		}
		throw new RuntimeException("Field " + sField.getName() + " not found");
	}
	
	public long getOauthServerId() {
		return oauthServerId;
	}

	public void setOauthServerId(long oauthServerId) {
		this.oauthServerId = oauthServerId;
	}
	
	public java.lang.String getCode() {
		return code;
	}

	public void setCode(java.lang.String code) {
		this.code = code;
	}
	
	public long getAuthorizationId() {
		return authorizationId;
	}

	public void setAuthorizationId(long authorizationId) {
		this.authorizationId = authorizationId;
	}
	
	public long getUserId() {
		return userId;
	}

	public void setUserId(long userId) {
		this.userId = userId;
	}
	
	public java.util.Date getIssued() {
		return issued;
	}

	public void setIssued(java.util.Date issued) {
		this.issued = issued;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + (int) (oid ^ (oid >>> 32));
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SOAuthAuthorizationCode other = (SOAuthAuthorizationCode) obj;
		if (oid != other.oid)
			return false;
		return true;
	}
}