/**
 * Copyright (C) 2009-2014 BIMserver.org
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.bimserver.models.ifc4;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.bimserver.models.ifc4.Ifc4Factory
 * @model kind="package"
 * @generated
 */
public interface Ifc4Package extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "ifc4";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://buildingsmart.ifc4.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "iai";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	Ifc4Package eINSTANCE = org.bimserver.models.ifc4.impl.Ifc4PackageImpl.init();

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcRootImpl <em>Ifc Root</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcRootImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcRoot()
	 * @generated
	 */
	int IFC_ROOT = 574;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT__GLOBAL_ID = 0;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT__OWNER_HISTORY = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT__NAME = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT__DESCRIPTION = 3;

	/**
	 * The number of structural features of the '<em>Ifc Root</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ROOT_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcObjectDefinitionImpl <em>Ifc Object Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcObjectDefinitionImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcObjectDefinition()
	 * @generated
	 */
	int IFC_OBJECT_DEFINITION = 384;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__GLOBAL_ID = IFC_ROOT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__OWNER_HISTORY = IFC_ROOT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__NAME = IFC_ROOT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__DESCRIPTION = IFC_ROOT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__HAS_ASSIGNMENTS = IFC_ROOT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__NESTS = IFC_ROOT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__IS_NESTED_BY = IFC_ROOT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__HAS_CONTEXT = IFC_ROOT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__IS_DECOMPOSED_BY = IFC_ROOT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__DECOMPOSES = IFC_ROOT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION__HAS_ASSOCIATIONS = IFC_ROOT_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Ifc Object Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_DEFINITION_FEATURE_COUNT = IFC_ROOT_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcObjectImpl <em>Ifc Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcObjectImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcObject()
	 * @generated
	 */
	int IFC_OBJECT = 383;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__GLOBAL_ID = IFC_OBJECT_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__OWNER_HISTORY = IFC_OBJECT_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__NAME = IFC_OBJECT_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__DESCRIPTION = IFC_OBJECT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__HAS_ASSIGNMENTS = IFC_OBJECT_DEFINITION__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__NESTS = IFC_OBJECT_DEFINITION__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__IS_NESTED_BY = IFC_OBJECT_DEFINITION__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__HAS_CONTEXT = IFC_OBJECT_DEFINITION__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__IS_DECOMPOSED_BY = IFC_OBJECT_DEFINITION__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__DECOMPOSES = IFC_OBJECT_DEFINITION__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__HAS_ASSOCIATIONS = IFC_OBJECT_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__OBJECT_TYPE = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__IS_DECLARED_BY = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__DECLARES = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__IS_TYPED_BY = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT__IS_DEFINED_BY = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_FEATURE_COUNT = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcControlImpl <em>Ifc Control</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcControlImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcControl()
	 * @generated
	 */
	int IFC_CONTROL = 136;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__NESTS = IFC_OBJECT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__IS_NESTED_BY = IFC_OBJECT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__HAS_CONTEXT = IFC_OBJECT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__IS_DECLARED_BY = IFC_OBJECT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__DECLARES = IFC_OBJECT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__IS_TYPED_BY = IFC_OBJECT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__IDENTIFICATION = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL__CONTROLS = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Control</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROL_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcActionRequestImpl <em>Ifc Action Request</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcActionRequestImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcActionRequest()
	 * @generated
	 */
	int IFC_ACTION_REQUEST = 0;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__GLOBAL_ID = IFC_CONTROL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__OWNER_HISTORY = IFC_CONTROL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__NAME = IFC_CONTROL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__DESCRIPTION = IFC_CONTROL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__HAS_ASSIGNMENTS = IFC_CONTROL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__NESTS = IFC_CONTROL__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__IS_NESTED_BY = IFC_CONTROL__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__HAS_CONTEXT = IFC_CONTROL__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__IS_DECOMPOSED_BY = IFC_CONTROL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__DECOMPOSES = IFC_CONTROL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__HAS_ASSOCIATIONS = IFC_CONTROL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__OBJECT_TYPE = IFC_CONTROL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__IS_DECLARED_BY = IFC_CONTROL__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__DECLARES = IFC_CONTROL__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__IS_TYPED_BY = IFC_CONTROL__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__IS_DEFINED_BY = IFC_CONTROL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__IDENTIFICATION = IFC_CONTROL__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__CONTROLS = IFC_CONTROL__CONTROLS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__PREDEFINED_TYPE = IFC_CONTROL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__STATUS = IFC_CONTROL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST__LONG_DESCRIPTION = IFC_CONTROL_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Action Request</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTION_REQUEST_FEATURE_COUNT = IFC_CONTROL_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcActorImpl <em>Ifc Actor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcActorImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcActor()
	 * @generated
	 */
	int IFC_ACTOR = 1;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__NESTS = IFC_OBJECT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_NESTED_BY = IFC_OBJECT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__HAS_CONTEXT = IFC_OBJECT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_DECLARED_BY = IFC_OBJECT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__DECLARES = IFC_OBJECT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_TYPED_BY = IFC_OBJECT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>The Actor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__THE_ACTOR = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Is Acting Upon</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR__IS_ACTING_UPON = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Actor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.IfcResourceObjectSelect <em>Ifc Resource Object Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.IfcResourceObjectSelect
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcResourceObjectSelect()
	 * @generated
	 */
	int IFC_RESOURCE_OBJECT_SELECT = 930;

	/**
	 * The number of structural features of the '<em>Ifc Resource Object Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcActorRoleImpl <em>Ifc Actor Role</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcActorRoleImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcActorRole()
	 * @generated
	 */
	int IFC_ACTOR_ROLE = 2;

	/**
	 * The feature id for the '<em><b>Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE__ROLE = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>User Defined Role</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE__USER_DEFINED_ROLE = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE__DESCRIPTION = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE__HAS_EXTERNAL_REFERENCE = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Actor Role</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTOR_ROLE_FEATURE_COUNT = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcProductImpl <em>Ifc Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcProductImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcProduct()
	 * @generated
	 */
	int IFC_PRODUCT = 447;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__NESTS = IFC_OBJECT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__IS_NESTED_BY = IFC_OBJECT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__HAS_CONTEXT = IFC_OBJECT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__IS_DECLARED_BY = IFC_OBJECT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__DECLARES = IFC_OBJECT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__IS_TYPED_BY = IFC_OBJECT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__OBJECT_PLACEMENT = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__REPRESENTATION = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__REFERENCED_BY = IFC_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT__GEOMETRY = IFC_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRODUCT_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcElementImpl <em>Ifc Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcElementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcElement()
	 * @generated
	 */
	int IFC_ELEMENT = 219;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__GLOBAL_ID = IFC_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__OWNER_HISTORY = IFC_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__NAME = IFC_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__DESCRIPTION = IFC_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_ASSIGNMENTS = IFC_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__NESTS = IFC_PRODUCT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_NESTED_BY = IFC_PRODUCT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_CONTEXT = IFC_PRODUCT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_DECOMPOSED_BY = IFC_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__DECOMPOSES = IFC_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_ASSOCIATIONS = IFC_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__OBJECT_TYPE = IFC_PRODUCT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_DECLARED_BY = IFC_PRODUCT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__DECLARES = IFC_PRODUCT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_TYPED_BY = IFC_PRODUCT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_DEFINED_BY = IFC_PRODUCT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__OBJECT_PLACEMENT = IFC_PRODUCT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__REPRESENTATION = IFC_PRODUCT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__REFERENCED_BY = IFC_PRODUCT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__GEOMETRY = IFC_PRODUCT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__TAG = IFC_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__FILLS_VOIDS = IFC_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__CONNECTED_TO = IFC_PRODUCT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_INTERFERED_BY_ELEMENTS = IFC_PRODUCT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__INTERFERES_ELEMENTS = IFC_PRODUCT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_PROJECTIONS = IFC_PRODUCT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_PRODUCT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__HAS_OPENINGS = IFC_PRODUCT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__IS_CONNECTION_REALIZATION = IFC_PRODUCT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__PROVIDES_BOUNDARIES = IFC_PRODUCT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__CONNECTED_FROM = IFC_PRODUCT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_PRODUCT_FEATURE_COUNT + 11;

	/**
	 * The number of structural features of the '<em>Ifc Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_FEATURE_COUNT = IFC_PRODUCT_FEATURE_COUNT + 12;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcDistributionElementImpl <em>Ifc Distribution Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcDistributionElementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcDistributionElement()
	 * @generated
	 */
	int IFC_DISTRIBUTION_ELEMENT = 181;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__NESTS = IFC_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_NESTED_BY = IFC_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_CONTEXT = IFC_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_DECLARED_BY = IFC_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__DECLARES = IFC_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_TYPED_BY = IFC_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_INTERFERED_BY_ELEMENTS = IFC_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__INTERFERES_ELEMENTS = IFC_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT__HAS_PORTS = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcDistributionControlElementImpl <em>Ifc Distribution Control Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcDistributionControlElementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcDistributionControlElement()
	 * @generated
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT = 179;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__GLOBAL_ID = IFC_DISTRIBUTION_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__OWNER_HISTORY = IFC_DISTRIBUTION_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__NAME = IFC_DISTRIBUTION_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__DESCRIPTION = IFC_DISTRIBUTION_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__NESTS = IFC_DISTRIBUTION_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_NESTED_BY = IFC_DISTRIBUTION_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_CONTEXT = IFC_DISTRIBUTION_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__DECOMPOSES = IFC_DISTRIBUTION_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_TYPE = IFC_DISTRIBUTION_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECLARED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__DECLARES = IFC_DISTRIBUTION_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_TYPED_BY = IFC_DISTRIBUTION_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DEFINED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_PLACEMENT = IFC_DISTRIBUTION_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__REPRESENTATION = IFC_DISTRIBUTION_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_BY = IFC_DISTRIBUTION_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__GEOMETRY = IFC_DISTRIBUTION_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__TAG = IFC_DISTRIBUTION_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__FILLS_VOIDS = IFC_DISTRIBUTION_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_TO = IFC_DISTRIBUTION_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PROJECTIONS = IFC_DISTRIBUTION_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_OPENINGS = IFC_DISTRIBUTION_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_FROM = IFC_DISTRIBUTION_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PORTS = IFC_DISTRIBUTION_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Assigned To Flow Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT__ASSIGNED_TO_FLOW_ELEMENT = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Control Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_FEATURE_COUNT = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcActuatorImpl <em>Ifc Actuator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcActuatorImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcActuator()
	 * @generated
	 */
	int IFC_ACTUATOR = 3;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__NESTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__IS_NESTED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__HAS_CONTEXT = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__OBJECT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__IS_DECLARED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__DECLARES = IFC_DISTRIBUTION_CONTROL_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__IS_TYPED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__IS_DEFINED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__OBJECT_PLACEMENT = IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__REPRESENTATION = IFC_DISTRIBUTION_CONTROL_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__REFERENCED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__GEOMETRY = IFC_DISTRIBUTION_CONTROL_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__FILLS_VOIDS = IFC_DISTRIBUTION_CONTROL_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__CONNECTED_TO = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__HAS_PROJECTIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__HAS_OPENINGS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_CONTROL_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__CONNECTED_FROM = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__HAS_PORTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Assigned To Flow Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__ASSIGNED_TO_FLOW_ELEMENT = IFC_DISTRIBUTION_CONTROL_ELEMENT__ASSIGNED_TO_FLOW_ELEMENT;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Actuator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcTypeObjectImpl <em>Ifc Type Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcTypeObjectImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcTypeObject()
	 * @generated
	 */
	int IFC_TYPE_OBJECT = 726;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__GLOBAL_ID = IFC_OBJECT_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__OWNER_HISTORY = IFC_OBJECT_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__NAME = IFC_OBJECT_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__DESCRIPTION = IFC_OBJECT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__HAS_ASSIGNMENTS = IFC_OBJECT_DEFINITION__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__NESTS = IFC_OBJECT_DEFINITION__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__IS_NESTED_BY = IFC_OBJECT_DEFINITION__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__HAS_CONTEXT = IFC_OBJECT_DEFINITION__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__IS_DECOMPOSED_BY = IFC_OBJECT_DEFINITION__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__DECOMPOSES = IFC_OBJECT_DEFINITION__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__HAS_ASSOCIATIONS = IFC_OBJECT_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__APPLICABLE_OCCURRENCE = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__HAS_PROPERTY_SETS = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT__TYPES = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Type Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_OBJECT_FEATURE_COUNT = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcTypeProductImpl <em>Ifc Type Product</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcTypeProductImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcTypeProduct()
	 * @generated
	 */
	int IFC_TYPE_PRODUCT = 728;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__GLOBAL_ID = IFC_TYPE_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__OWNER_HISTORY = IFC_TYPE_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__NAME = IFC_TYPE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__DESCRIPTION = IFC_TYPE_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__HAS_ASSIGNMENTS = IFC_TYPE_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__NESTS = IFC_TYPE_OBJECT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__IS_NESTED_BY = IFC_TYPE_OBJECT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__HAS_CONTEXT = IFC_TYPE_OBJECT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__IS_DECOMPOSED_BY = IFC_TYPE_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__DECOMPOSES = IFC_TYPE_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__HAS_ASSOCIATIONS = IFC_TYPE_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__APPLICABLE_OCCURRENCE = IFC_TYPE_OBJECT__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__HAS_PROPERTY_SETS = IFC_TYPE_OBJECT__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__TYPES = IFC_TYPE_OBJECT__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__REPRESENTATION_MAPS = IFC_TYPE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__TAG = IFC_TYPE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT__REFERENCED_BY = IFC_TYPE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Type Product</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_PRODUCT_FEATURE_COUNT = IFC_TYPE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcElementTypeImpl <em>Ifc Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcElementTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcElementType()
	 * @generated
	 */
	int IFC_ELEMENT_TYPE = 225;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__GLOBAL_ID = IFC_TYPE_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__OWNER_HISTORY = IFC_TYPE_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__NAME = IFC_TYPE_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__DESCRIPTION = IFC_TYPE_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_TYPE_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__NESTS = IFC_TYPE_PRODUCT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__IS_NESTED_BY = IFC_TYPE_PRODUCT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__HAS_CONTEXT = IFC_TYPE_PRODUCT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_TYPE_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__DECOMPOSES = IFC_TYPE_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_TYPE_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_TYPE_PRODUCT__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_TYPE_PRODUCT__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__TYPES = IFC_TYPE_PRODUCT__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_TYPE_PRODUCT__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__TAG = IFC_TYPE_PRODUCT__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__REFERENCED_BY = IFC_TYPE_PRODUCT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE__ELEMENT_TYPE = IFC_TYPE_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_TYPE_FEATURE_COUNT = IFC_TYPE_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcDistributionElementTypeImpl <em>Ifc Distribution Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcDistributionElementTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcDistributionElementType()
	 * @generated
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE = 182;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__GLOBAL_ID = IFC_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__OWNER_HISTORY = IFC_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__NAME = IFC_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__DESCRIPTION = IFC_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__NESTS = IFC_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__IS_NESTED_BY = IFC_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_CONTEXT = IFC_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__DECOMPOSES = IFC_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__TYPES = IFC_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__TAG = IFC_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__REFERENCED_BY = IFC_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE__ELEMENT_TYPE = IFC_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_ELEMENT_TYPE_FEATURE_COUNT = IFC_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcDistributionControlElementTypeImpl <em>Ifc Distribution Control Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcDistributionControlElementTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcDistributionControlElementType()
	 * @generated
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE = 180;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME = IFC_DISTRIBUTION_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION = IFC_DISTRIBUTION_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NESTS = IFC_DISTRIBUTION_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES = IFC_DISTRIBUTION_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TYPES = IFC_DISTRIBUTION_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG = IFC_DISTRIBUTION_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Control Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcActuatorTypeImpl <em>Ifc Actuator Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcActuatorTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcActuatorType()
	 * @generated
	 */
	int IFC_ACTUATOR_TYPE = 4;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__NESTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__TYPES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Actuator Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ACTUATOR_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.IfcObjectReferenceSelect <em>Ifc Object Reference Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.IfcObjectReferenceSelect
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcObjectReferenceSelect()
	 * @generated
	 */
	int IFC_OBJECT_REFERENCE_SELECT = 923;

	/**
	 * The number of structural features of the '<em>Ifc Object Reference Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAddressImpl <em>Ifc Address</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAddressImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAddress()
	 * @generated
	 */
	int IFC_ADDRESS = 5;

	/**
	 * The feature id for the '<em><b>Purpose</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__PURPOSE = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__DESCRIPTION = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>User Defined Purpose</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__USER_DEFINED_PURPOSE = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Of Person</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__OF_PERSON = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Of Organization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS__OF_ORGANIZATION = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Address</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADDRESS_FEATURE_COUNT = IFC_OBJECT_REFERENCE_SELECT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.IfcLayeredItem <em>Ifc Layered Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.IfcLayeredItem
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcLayeredItem()
	 * @generated
	 */
	int IFC_LAYERED_ITEM = 914;

	/**
	 * The number of structural features of the '<em>Ifc Layered Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_LAYERED_ITEM_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcRepresentationItemImpl <em>Ifc Representation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcRepresentationItemImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcRepresentationItem()
	 * @generated
	 */
	int IFC_REPRESENTATION_ITEM = 561;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT = IFC_LAYERED_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_REPRESENTATION_ITEM__STYLED_BY_ITEM = IFC_LAYERED_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Representation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_REPRESENTATION_ITEM_FEATURE_COUNT = IFC_LAYERED_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcGeometricRepresentationItemImpl <em>Ifc Geometric Representation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcGeometricRepresentationItemImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcGeometricRepresentationItem()
	 * @generated
	 */
	int IFC_GEOMETRIC_REPRESENTATION_ITEM = 302;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT = IFC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM = IFC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Geometric Representation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT = IFC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcSolidModelImpl <em>Ifc Solid Model</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcSolidModelImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcSolidModel()
	 * @generated
	 */
	int IFC_SOLID_MODEL = 601;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SOLID_MODEL__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SOLID_MODEL__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SOLID_MODEL__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Solid Model</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SOLID_MODEL_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcManifoldSolidBrepImpl <em>Ifc Manifold Solid Brep</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcManifoldSolidBrepImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcManifoldSolidBrep()
	 * @generated
	 */
	int IFC_MANIFOLD_SOLID_BREP = 347;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP__LAYER_ASSIGNMENT = IFC_SOLID_MODEL__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP__STYLED_BY_ITEM = IFC_SOLID_MODEL__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP__DIM = IFC_SOLID_MODEL__DIM;

	/**
	 * The feature id for the '<em><b>Outer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP__OUTER = IFC_SOLID_MODEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Manifold Solid Brep</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_MANIFOLD_SOLID_BREP_FEATURE_COUNT = IFC_SOLID_MODEL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAdvancedBrepImpl <em>Ifc Advanced Brep</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAdvancedBrepImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAdvancedBrep()
	 * @generated
	 */
	int IFC_ADVANCED_BREP = 6;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP__LAYER_ASSIGNMENT = IFC_MANIFOLD_SOLID_BREP__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP__STYLED_BY_ITEM = IFC_MANIFOLD_SOLID_BREP__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP__DIM = IFC_MANIFOLD_SOLID_BREP__DIM;

	/**
	 * The feature id for the '<em><b>Outer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP__OUTER = IFC_MANIFOLD_SOLID_BREP__OUTER;

	/**
	 * The number of structural features of the '<em>Ifc Advanced Brep</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP_FEATURE_COUNT = IFC_MANIFOLD_SOLID_BREP_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAdvancedBrepWithVoidsImpl <em>Ifc Advanced Brep With Voids</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAdvancedBrepWithVoidsImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAdvancedBrepWithVoids()
	 * @generated
	 */
	int IFC_ADVANCED_BREP_WITH_VOIDS = 7;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP_WITH_VOIDS__LAYER_ASSIGNMENT = IFC_ADVANCED_BREP__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP_WITH_VOIDS__STYLED_BY_ITEM = IFC_ADVANCED_BREP__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP_WITH_VOIDS__DIM = IFC_ADVANCED_BREP__DIM;

	/**
	 * The feature id for the '<em><b>Outer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP_WITH_VOIDS__OUTER = IFC_ADVANCED_BREP__OUTER;

	/**
	 * The feature id for the '<em><b>Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP_WITH_VOIDS__VOIDS = IFC_ADVANCED_BREP_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Advanced Brep With Voids</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_BREP_WITH_VOIDS_FEATURE_COUNT = IFC_ADVANCED_BREP_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcTopologicalRepresentationItemImpl <em>Ifc Topological Representation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcTopologicalRepresentationItemImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcTopologicalRepresentationItem()
	 * @generated
	 */
	int IFC_TOPOLOGICAL_REPRESENTATION_ITEM = 715;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENT = IFC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM = IFC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Topological Representation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT = IFC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFaceImpl <em>Ifc Face</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFaceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFace()
	 * @generated
	 */
	int IFC_FACE = 251;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE__LAYER_ASSIGNMENT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE__STYLED_BY_ITEM = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE__BOUNDS = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Texture Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE__HAS_TEXTURE_MAPS = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Face</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_FEATURE_COUNT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFaceSurfaceImpl <em>Ifc Face Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFaceSurfaceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFaceSurface()
	 * @generated
	 */
	int IFC_FACE_SURFACE = 255;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__LAYER_ASSIGNMENT = IFC_FACE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__STYLED_BY_ITEM = IFC_FACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__BOUNDS = IFC_FACE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Has Texture Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__HAS_TEXTURE_MAPS = IFC_FACE__HAS_TEXTURE_MAPS;

	/**
	 * The feature id for the '<em><b>Face Surface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__FACE_SURFACE = IFC_FACE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Same Sense</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE__SAME_SENSE = IFC_FACE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Face Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FACE_SURFACE_FEATURE_COUNT = IFC_FACE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAdvancedFaceImpl <em>Ifc Advanced Face</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAdvancedFaceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAdvancedFace()
	 * @generated
	 */
	int IFC_ADVANCED_FACE = 8;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_FACE__LAYER_ASSIGNMENT = IFC_FACE_SURFACE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_FACE__STYLED_BY_ITEM = IFC_FACE_SURFACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Bounds</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_FACE__BOUNDS = IFC_FACE_SURFACE__BOUNDS;

	/**
	 * The feature id for the '<em><b>Has Texture Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_FACE__HAS_TEXTURE_MAPS = IFC_FACE_SURFACE__HAS_TEXTURE_MAPS;

	/**
	 * The feature id for the '<em><b>Face Surface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_FACE__FACE_SURFACE = IFC_FACE_SURFACE__FACE_SURFACE;

	/**
	 * The feature id for the '<em><b>Same Sense</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_FACE__SAME_SENSE = IFC_FACE_SURFACE__SAME_SENSE;

	/**
	 * The number of structural features of the '<em>Ifc Advanced Face</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ADVANCED_FACE_FEATURE_COUNT = IFC_FACE_SURFACE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcDistributionFlowElementImpl <em>Ifc Distribution Flow Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcDistributionFlowElementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcDistributionFlowElement()
	 * @generated
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT = 183;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID = IFC_DISTRIBUTION_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY = IFC_DISTRIBUTION_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__NAME = IFC_DISTRIBUTION_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION = IFC_DISTRIBUTION_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__NESTS = IFC_DISTRIBUTION_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_NESTED_BY = IFC_DISTRIBUTION_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTEXT = IFC_DISTRIBUTION_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES = IFC_DISTRIBUTION_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE = IFC_DISTRIBUTION_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECLARED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__DECLARES = IFC_DISTRIBUTION_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_TYPED_BY = IFC_DISTRIBUTION_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY = IFC_DISTRIBUTION_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT = IFC_DISTRIBUTION_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION = IFC_DISTRIBUTION_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY = IFC_DISTRIBUTION_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY = IFC_DISTRIBUTION_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__TAG = IFC_DISTRIBUTION_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS = IFC_DISTRIBUTION_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO = IFC_DISTRIBUTION_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS = IFC_DISTRIBUTION_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS = IFC_DISTRIBUTION_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM = IFC_DISTRIBUTION_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS = IFC_DISTRIBUTION_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Flow Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT = IFC_DISTRIBUTION_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowTerminalImpl <em>Ifc Flow Terminal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowTerminalImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowTerminal()
	 * @generated
	 */
	int IFC_FLOW_TERMINAL = 288;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_DECLARED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__DECLARES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_TYPED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Terminal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAirTerminalImpl <em>Ifc Air Terminal</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAirTerminalImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAirTerminal()
	 * @generated
	 */
	int IFC_AIR_TERMINAL = 9;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__GLOBAL_ID = IFC_FLOW_TERMINAL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__OWNER_HISTORY = IFC_FLOW_TERMINAL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__NAME = IFC_FLOW_TERMINAL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__DESCRIPTION = IFC_FLOW_TERMINAL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__NESTS = IFC_FLOW_TERMINAL__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__IS_NESTED_BY = IFC_FLOW_TERMINAL__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__HAS_CONTEXT = IFC_FLOW_TERMINAL__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__DECOMPOSES = IFC_FLOW_TERMINAL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__OBJECT_TYPE = IFC_FLOW_TERMINAL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__IS_DECLARED_BY = IFC_FLOW_TERMINAL__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__DECLARES = IFC_FLOW_TERMINAL__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__IS_TYPED_BY = IFC_FLOW_TERMINAL__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__IS_DEFINED_BY = IFC_FLOW_TERMINAL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__OBJECT_PLACEMENT = IFC_FLOW_TERMINAL__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__REPRESENTATION = IFC_FLOW_TERMINAL__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__REFERENCED_BY = IFC_FLOW_TERMINAL__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__GEOMETRY = IFC_FLOW_TERMINAL__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__TAG = IFC_FLOW_TERMINAL__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__FILLS_VOIDS = IFC_FLOW_TERMINAL__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__CONNECTED_TO = IFC_FLOW_TERMINAL__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_TERMINAL__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__INTERFERES_ELEMENTS = IFC_FLOW_TERMINAL__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__HAS_PROJECTIONS = IFC_FLOW_TERMINAL__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__REFERENCED_IN_STRUCTURES = IFC_FLOW_TERMINAL__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__HAS_OPENINGS = IFC_FLOW_TERMINAL__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__IS_CONNECTION_REALIZATION = IFC_FLOW_TERMINAL__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__PROVIDES_BOUNDARIES = IFC_FLOW_TERMINAL__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__CONNECTED_FROM = IFC_FLOW_TERMINAL__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__CONTAINED_IN_STRUCTURE = IFC_FLOW_TERMINAL__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__HAS_PORTS = IFC_FLOW_TERMINAL__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__HAS_CONTROL_ELEMENTS = IFC_FLOW_TERMINAL__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air Terminal</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_FEATURE_COUNT = IFC_FLOW_TERMINAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowControllerImpl <em>Ifc Flow Controller</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowControllerImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowController()
	 * @generated
	 */
	int IFC_FLOW_CONTROLLER = 274;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_DECLARED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__DECLARES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_TYPED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Controller</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAirTerminalBoxImpl <em>Ifc Air Terminal Box</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAirTerminalBoxImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAirTerminalBox()
	 * @generated
	 */
	int IFC_AIR_TERMINAL_BOX = 10;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__GLOBAL_ID = IFC_FLOW_CONTROLLER__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__OWNER_HISTORY = IFC_FLOW_CONTROLLER__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__NAME = IFC_FLOW_CONTROLLER__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__DESCRIPTION = IFC_FLOW_CONTROLLER__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__HAS_ASSIGNMENTS = IFC_FLOW_CONTROLLER__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__NESTS = IFC_FLOW_CONTROLLER__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__IS_NESTED_BY = IFC_FLOW_CONTROLLER__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__HAS_CONTEXT = IFC_FLOW_CONTROLLER__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__IS_DECOMPOSED_BY = IFC_FLOW_CONTROLLER__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__DECOMPOSES = IFC_FLOW_CONTROLLER__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__HAS_ASSOCIATIONS = IFC_FLOW_CONTROLLER__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__OBJECT_TYPE = IFC_FLOW_CONTROLLER__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__IS_DECLARED_BY = IFC_FLOW_CONTROLLER__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__DECLARES = IFC_FLOW_CONTROLLER__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__IS_TYPED_BY = IFC_FLOW_CONTROLLER__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__IS_DEFINED_BY = IFC_FLOW_CONTROLLER__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__OBJECT_PLACEMENT = IFC_FLOW_CONTROLLER__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__REPRESENTATION = IFC_FLOW_CONTROLLER__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__REFERENCED_BY = IFC_FLOW_CONTROLLER__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__GEOMETRY = IFC_FLOW_CONTROLLER__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__TAG = IFC_FLOW_CONTROLLER__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__FILLS_VOIDS = IFC_FLOW_CONTROLLER__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__CONNECTED_TO = IFC_FLOW_CONTROLLER__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_CONTROLLER__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__INTERFERES_ELEMENTS = IFC_FLOW_CONTROLLER__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__HAS_PROJECTIONS = IFC_FLOW_CONTROLLER__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__REFERENCED_IN_STRUCTURES = IFC_FLOW_CONTROLLER__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__HAS_OPENINGS = IFC_FLOW_CONTROLLER__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__IS_CONNECTION_REALIZATION = IFC_FLOW_CONTROLLER__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__PROVIDES_BOUNDARIES = IFC_FLOW_CONTROLLER__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__CONNECTED_FROM = IFC_FLOW_CONTROLLER__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__CONTAINED_IN_STRUCTURE = IFC_FLOW_CONTROLLER__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__HAS_PORTS = IFC_FLOW_CONTROLLER__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__HAS_CONTROL_ELEMENTS = IFC_FLOW_CONTROLLER__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX__PREDEFINED_TYPE = IFC_FLOW_CONTROLLER_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air Terminal Box</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_FEATURE_COUNT = IFC_FLOW_CONTROLLER_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcDistributionFlowElementTypeImpl <em>Ifc Distribution Flow Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcDistributionFlowElementTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcDistributionFlowElementType()
	 * @generated
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE = 184;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME = IFC_DISTRIBUTION_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION = IFC_DISTRIBUTION_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NESTS = IFC_DISTRIBUTION_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES = IFC_DISTRIBUTION_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TYPES = IFC_DISTRIBUTION_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG = IFC_DISTRIBUTION_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Distribution Flow Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowControllerTypeImpl <em>Ifc Flow Controller Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowControllerTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowControllerType()
	 * @generated
	 */
	int IFC_FLOW_CONTROLLER_TYPE = 275;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__TYPES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Controller Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAirTerminalBoxTypeImpl <em>Ifc Air Terminal Box Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAirTerminalBoxTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAirTerminalBoxType()
	 * @generated
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE = 11;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__GLOBAL_ID = IFC_FLOW_CONTROLLER_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__OWNER_HISTORY = IFC_FLOW_CONTROLLER_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__NAME = IFC_FLOW_CONTROLLER_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__DESCRIPTION = IFC_FLOW_CONTROLLER_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__NESTS = IFC_FLOW_CONTROLLER_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__IS_NESTED_BY = IFC_FLOW_CONTROLLER_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__HAS_CONTEXT = IFC_FLOW_CONTROLLER_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_CONTROLLER_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__DECOMPOSES = IFC_FLOW_CONTROLLER_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_CONTROLLER_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_CONTROLLER_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__TYPES = IFC_FLOW_CONTROLLER_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__REPRESENTATION_MAPS = IFC_FLOW_CONTROLLER_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__TAG = IFC_FLOW_CONTROLLER_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__REFERENCED_BY = IFC_FLOW_CONTROLLER_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__ELEMENT_TYPE = IFC_FLOW_CONTROLLER_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE__PREDEFINED_TYPE = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air Terminal Box Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_BOX_TYPE_FEATURE_COUNT = IFC_FLOW_CONTROLLER_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowTerminalTypeImpl <em>Ifc Flow Terminal Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowTerminalTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowTerminalType()
	 * @generated
	 */
	int IFC_FLOW_TERMINAL_TYPE = 289;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__TYPES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Terminal Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAirTerminalTypeImpl <em>Ifc Air Terminal Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAirTerminalTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAirTerminalType()
	 * @generated
	 */
	int IFC_AIR_TERMINAL_TYPE = 12;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__GLOBAL_ID = IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__OWNER_HISTORY = IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__NAME = IFC_FLOW_TERMINAL_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__DESCRIPTION = IFC_FLOW_TERMINAL_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__NESTS = IFC_FLOW_TERMINAL_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__IS_NESTED_BY = IFC_FLOW_TERMINAL_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__HAS_CONTEXT = IFC_FLOW_TERMINAL_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__DECOMPOSES = IFC_FLOW_TERMINAL_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__TYPES = IFC_FLOW_TERMINAL_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__TAG = IFC_FLOW_TERMINAL_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__REFERENCED_BY = IFC_FLOW_TERMINAL_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__ELEMENT_TYPE = IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air Terminal Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TERMINAL_TYPE_FEATURE_COUNT = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcEnergyConversionDeviceImpl <em>Ifc Energy Conversion Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcEnergyConversionDeviceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcEnergyConversionDevice()
	 * @generated
	 */
	int IFC_ENERGY_CONVERSION_DEVICE = 229;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__DECLARES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Energy Conversion Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAirToAirHeatRecoveryImpl <em>Ifc Air To Air Heat Recovery</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAirToAirHeatRecoveryImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAirToAirHeatRecovery()
	 * @generated
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY = 13;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__NAME = IFC_ENERGY_CONVERSION_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__NESTS = IFC_ENERGY_CONVERSION_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__OBJECT_TYPE = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__IS_DECLARED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__DECLARES = IFC_ENERGY_CONVERSION_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__IS_TYPED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__IS_DEFINED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__OBJECT_PLACEMENT = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__REPRESENTATION = IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__GEOMETRY = IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__TAG = IFC_ENERGY_CONVERSION_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__FILLS_VOIDS = IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__CONNECTED_TO = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__IS_INTERFERED_BY_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__INTERFERES_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__HAS_PROJECTIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__REFERENCED_IN_STRUCTURES = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__HAS_OPENINGS = IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__IS_CONNECTION_REALIZATION = IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__PROVIDES_BOUNDARIES = IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__CONNECTED_FROM = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__CONTAINED_IN_STRUCTURE = IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__HAS_PORTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__HAS_CONTROL_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air To Air Heat Recovery</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcEnergyConversionDeviceTypeImpl <em>Ifc Energy Conversion Device Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcEnergyConversionDeviceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcEnergyConversionDeviceType()
	 * @generated
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE = 230;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Energy Conversion Device Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAirToAirHeatRecoveryTypeImpl <em>Ifc Air To Air Heat Recovery Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAirToAirHeatRecoveryTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAirToAirHeatRecoveryType()
	 * @generated
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE = 14;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__NESTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__TYPES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Air To Air Heat Recovery Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AIR_TO_AIR_HEAT_RECOVERY_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAlarmImpl <em>Ifc Alarm</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAlarmImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAlarm()
	 * @generated
	 */
	int IFC_ALARM = 15;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__NESTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__IS_NESTED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__HAS_CONTEXT = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__OBJECT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__IS_DECLARED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__DECLARES = IFC_DISTRIBUTION_CONTROL_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__IS_TYPED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__IS_DEFINED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__OBJECT_PLACEMENT = IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__REPRESENTATION = IFC_DISTRIBUTION_CONTROL_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__REFERENCED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__GEOMETRY = IFC_DISTRIBUTION_CONTROL_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__FILLS_VOIDS = IFC_DISTRIBUTION_CONTROL_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__CONNECTED_TO = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__HAS_PROJECTIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__HAS_OPENINGS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_CONTROL_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__CONNECTED_FROM = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__HAS_PORTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Assigned To Flow Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__ASSIGNED_TO_FLOW_ELEMENT = IFC_DISTRIBUTION_CONTROL_ELEMENT__ASSIGNED_TO_FLOW_ELEMENT;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Alarm</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAlarmTypeImpl <em>Ifc Alarm Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAlarmTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAlarmType()
	 * @generated
	 */
	int IFC_ALARM_TYPE = 16;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__NESTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__TYPES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Alarm Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ALARM_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAnnotationImpl <em>Ifc Annotation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAnnotationImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAnnotation()
	 * @generated
	 */
	int IFC_ANNOTATION = 17;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__GLOBAL_ID = IFC_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__OWNER_HISTORY = IFC_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__NAME = IFC_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__DESCRIPTION = IFC_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__HAS_ASSIGNMENTS = IFC_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__NESTS = IFC_PRODUCT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__IS_NESTED_BY = IFC_PRODUCT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__HAS_CONTEXT = IFC_PRODUCT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__IS_DECOMPOSED_BY = IFC_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__DECOMPOSES = IFC_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__HAS_ASSOCIATIONS = IFC_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__OBJECT_TYPE = IFC_PRODUCT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__IS_DECLARED_BY = IFC_PRODUCT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__DECLARES = IFC_PRODUCT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__IS_TYPED_BY = IFC_PRODUCT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__IS_DEFINED_BY = IFC_PRODUCT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__OBJECT_PLACEMENT = IFC_PRODUCT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__REPRESENTATION = IFC_PRODUCT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__REFERENCED_BY = IFC_PRODUCT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__GEOMETRY = IFC_PRODUCT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION__CONTAINED_IN_STRUCTURE = IFC_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Annotation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FEATURE_COUNT = IFC_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAnnotationFillAreaImpl <em>Ifc Annotation Fill Area</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAnnotationFillAreaImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAnnotationFillArea()
	 * @generated
	 */
	int IFC_ANNOTATION_FILL_AREA = 18;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Outer Boundary</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA__OUTER_BOUNDARY = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Inner Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA__INNER_BOUNDARIES = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Annotation Fill Area</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ANNOTATION_FILL_AREA_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcApplicationImpl <em>Ifc Application</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcApplicationImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcApplication()
	 * @generated
	 */
	int IFC_APPLICATION = 19;

	/**
	 * The feature id for the '<em><b>Application Developer</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION__APPLICATION_DEVELOPER = 0;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION__VERSION = 1;

	/**
	 * The feature id for the '<em><b>Application Full Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION__APPLICATION_FULL_NAME = 2;

	/**
	 * The feature id for the '<em><b>Application Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION__APPLICATION_IDENTIFIER = 3;

	/**
	 * The number of structural features of the '<em>Ifc Application</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLICATION_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.IfcMetricValueSelect <em>Ifc Metric Value Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.IfcMetricValueSelect
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcMetricValueSelect()
	 * @generated
	 */
	int IFC_METRIC_VALUE_SELECT = 919;

	/**
	 * The number of structural features of the '<em>Ifc Metric Value Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_METRIC_VALUE_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAppliedValueImpl <em>Ifc Applied Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAppliedValueImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAppliedValue()
	 * @generated
	 */
	int IFC_APPLIED_VALUE = 20;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__NAME = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__DESCRIPTION = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Applied Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__APPLIED_VALUE = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Unit Basis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__UNIT_BASIS = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Applicable Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__APPLICABLE_DATE = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Fixed Until Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__FIXED_UNTIL_DATE = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Category</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__CATEGORY = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__CONDITION = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Arithmetic Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__ARITHMETIC_OPERATOR = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__COMPONENTS = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE__HAS_EXTERNAL_REFERENCE = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>Ifc Applied Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPLIED_VALUE_FEATURE_COUNT = IFC_METRIC_VALUE_SELECT_FEATURE_COUNT + 11;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcApprovalImpl <em>Ifc Approval</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcApprovalImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcApproval()
	 * @generated
	 */
	int IFC_APPROVAL = 21;

	/**
	 * The feature id for the '<em><b>Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__IDENTIFIER = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__NAME = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__DESCRIPTION = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Time Of Approval</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__TIME_OF_APPROVAL = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__STATUS = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__LEVEL = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Qualifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__QUALIFIER = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Requesting Approval</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__REQUESTING_APPROVAL = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Giving Approval</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__GIVING_APPROVAL = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Has External References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__HAS_EXTERNAL_REFERENCES = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Approved Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__APPROVED_OBJECTS = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Approved Resources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__APPROVED_RESOURCES = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Is Related With</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__IS_RELATED_WITH = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Relates</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL__RELATES = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 13;

	/**
	 * The number of structural features of the '<em>Ifc Approval</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_FEATURE_COUNT = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 14;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcResourceLevelRelationshipImpl <em>Ifc Resource Level Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcResourceLevelRelationshipImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcResourceLevelRelationship()
	 * @generated
	 */
	int IFC_RESOURCE_LEVEL_RELATIONSHIP = 566;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE_LEVEL_RELATIONSHIP__NAME = 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE_LEVEL_RELATIONSHIP__DESCRIPTION = 1;

	/**
	 * The number of structural features of the '<em>Ifc Resource Level Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcApprovalRelationshipImpl <em>Ifc Approval Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcApprovalRelationshipImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcApprovalRelationship()
	 * @generated
	 */
	int IFC_APPROVAL_RELATIONSHIP = 22;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP__NAME = IFC_RESOURCE_LEVEL_RELATIONSHIP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP__DESCRIPTION = IFC_RESOURCE_LEVEL_RELATIONSHIP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Relating Approval</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP__RELATING_APPROVAL = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Related Approvals</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP__RELATED_APPROVALS = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Approval Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_APPROVAL_RELATIONSHIP_FEATURE_COUNT = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcProfileDefImpl <em>Ifc Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcProfileDef()
	 * @generated
	 */
	int IFC_PROFILE_DEF = 450;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROFILE_DEF__PROFILE_TYPE = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROFILE_DEF__PROFILE_NAME = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROFILE_DEF__HAS_PROPERTIES = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROFILE_DEF_FEATURE_COUNT = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcArbitraryClosedProfileDefImpl <em>Ifc Arbitrary Closed Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcArbitraryClosedProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcArbitraryClosedProfileDef()
	 * @generated
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF = 23;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF__HAS_PROPERTIES = IFC_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Outer Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF__OUTER_CURVE = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Arbitrary Closed Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_CLOSED_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcArbitraryOpenProfileDefImpl <em>Ifc Arbitrary Open Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcArbitraryOpenProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcArbitraryOpenProfileDef()
	 * @generated
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF = 24;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF__HAS_PROPERTIES = IFC_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF__CURVE = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Arbitrary Open Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_OPEN_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcArbitraryProfileDefWithVoidsImpl <em>Ifc Arbitrary Profile Def With Voids</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcArbitraryProfileDefWithVoidsImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcArbitraryProfileDefWithVoids()
	 * @generated
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS = 25;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__PROFILE_TYPE = IFC_ARBITRARY_CLOSED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__PROFILE_NAME = IFC_ARBITRARY_CLOSED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__HAS_EXTERNAL_REFERENCE = IFC_ARBITRARY_CLOSED_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__HAS_PROPERTIES = IFC_ARBITRARY_CLOSED_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Outer Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__OUTER_CURVE = IFC_ARBITRARY_CLOSED_PROFILE_DEF__OUTER_CURVE;

	/**
	 * The feature id for the '<em><b>Inner Curves</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS__INNER_CURVES = IFC_ARBITRARY_CLOSED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Arbitrary Profile Def With Voids</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ARBITRARY_PROFILE_DEF_WITH_VOIDS_FEATURE_COUNT = IFC_ARBITRARY_CLOSED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcGroupImpl <em>Ifc Group</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcGroupImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcGroup()
	 * @generated
	 */
	int IFC_GROUP = 308;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__NESTS = IFC_OBJECT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_NESTED_BY = IFC_OBJECT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__HAS_CONTEXT = IFC_OBJECT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_DECLARED_BY = IFC_OBJECT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__DECLARES = IFC_OBJECT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_TYPED_BY = IFC_OBJECT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP__IS_GROUPED_BY = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Group</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_GROUP_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAssetImpl <em>Ifc Asset</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAssetImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAsset()
	 * @generated
	 */
	int IFC_ASSET = 26;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__GLOBAL_ID = IFC_GROUP__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__OWNER_HISTORY = IFC_GROUP__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__NAME = IFC_GROUP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__DESCRIPTION = IFC_GROUP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__HAS_ASSIGNMENTS = IFC_GROUP__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__NESTS = IFC_GROUP__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_NESTED_BY = IFC_GROUP__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__HAS_CONTEXT = IFC_GROUP__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_DECOMPOSED_BY = IFC_GROUP__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__DECOMPOSES = IFC_GROUP__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__HAS_ASSOCIATIONS = IFC_GROUP__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__OBJECT_TYPE = IFC_GROUP__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_DECLARED_BY = IFC_GROUP__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__DECLARES = IFC_GROUP__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_TYPED_BY = IFC_GROUP__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_DEFINED_BY = IFC_GROUP__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IS_GROUPED_BY = IFC_GROUP__IS_GROUPED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__IDENTIFICATION = IFC_GROUP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Original Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__ORIGINAL_VALUE = IFC_GROUP_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Current Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__CURRENT_VALUE = IFC_GROUP_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Total Replacement Cost</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__TOTAL_REPLACEMENT_COST = IFC_GROUP_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__OWNER = IFC_GROUP_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>User</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__USER = IFC_GROUP_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Responsible Person</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__RESPONSIBLE_PERSON = IFC_GROUP_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Incorporation Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__INCORPORATION_DATE = IFC_GROUP_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Depreciated Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET__DEPRECIATED_VALUE = IFC_GROUP_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Ifc Asset</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASSET_FEATURE_COUNT = IFC_GROUP_FEATURE_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcParameterizedProfileDefImpl <em>Ifc Parameterized Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcParameterizedProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcParameterizedProfileDef()
	 * @generated
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF = 400;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF__HAS_PROPERTIES = IFC_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF__POSITION = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Parameterized Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAsymmetricIShapeProfileDefImpl <em>Ifc Asymmetric IShape Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAsymmetricIShapeProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAsymmetricIShapeProfileDef()
	 * @generated
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF = 27;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_PARAMETERIZED_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__HAS_PROPERTIES = IFC_PARAMETERIZED_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Bottom Flange Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_WIDTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Bottom Flange Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_WIDTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Overall Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__OVERALL_DEPTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Overall Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__OVERALL_DEPTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Web Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__WEB_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Web Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__WEB_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Bottom Flange Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Bottom Flange Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Bottom Flange Fillet Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_FILLET_RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Bottom Flange Fillet Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_FILLET_RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Top Flange Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_WIDTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Top Flange Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_WIDTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Top Flange Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Top Flange Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Top Flange Fillet Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_FILLET_RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Top Flange Fillet Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_FILLET_RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Bottom Flange Edge Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_EDGE_RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Bottom Flange Edge Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_EDGE_RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Bottom Flange Slope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_SLOPE = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Bottom Flange Slope As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__BOTTOM_FLANGE_SLOPE_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Top Flange Edge Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_EDGE_RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Top Flange Edge Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_EDGE_RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Top Flange Slope</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_SLOPE = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Top Flange Slope As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF__TOP_FLANGE_SLOPE_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 23;

	/**
	 * The number of structural features of the '<em>Ifc Asymmetric IShape Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ASYMMETRIC_ISHAPE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 24;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAudioVisualApplianceImpl <em>Ifc Audio Visual Appliance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAudioVisualApplianceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAudioVisualAppliance()
	 * @generated
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE = 28;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__GLOBAL_ID = IFC_FLOW_TERMINAL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__OWNER_HISTORY = IFC_FLOW_TERMINAL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__NAME = IFC_FLOW_TERMINAL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__DESCRIPTION = IFC_FLOW_TERMINAL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__NESTS = IFC_FLOW_TERMINAL__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__IS_NESTED_BY = IFC_FLOW_TERMINAL__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__HAS_CONTEXT = IFC_FLOW_TERMINAL__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__DECOMPOSES = IFC_FLOW_TERMINAL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__OBJECT_TYPE = IFC_FLOW_TERMINAL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__IS_DECLARED_BY = IFC_FLOW_TERMINAL__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__DECLARES = IFC_FLOW_TERMINAL__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__IS_TYPED_BY = IFC_FLOW_TERMINAL__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__IS_DEFINED_BY = IFC_FLOW_TERMINAL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__OBJECT_PLACEMENT = IFC_FLOW_TERMINAL__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__REPRESENTATION = IFC_FLOW_TERMINAL__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__REFERENCED_BY = IFC_FLOW_TERMINAL__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__GEOMETRY = IFC_FLOW_TERMINAL__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__TAG = IFC_FLOW_TERMINAL__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__FILLS_VOIDS = IFC_FLOW_TERMINAL__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__CONNECTED_TO = IFC_FLOW_TERMINAL__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_TERMINAL__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__INTERFERES_ELEMENTS = IFC_FLOW_TERMINAL__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__HAS_PROJECTIONS = IFC_FLOW_TERMINAL__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__REFERENCED_IN_STRUCTURES = IFC_FLOW_TERMINAL__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__HAS_OPENINGS = IFC_FLOW_TERMINAL__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__IS_CONNECTION_REALIZATION = IFC_FLOW_TERMINAL__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__PROVIDES_BOUNDARIES = IFC_FLOW_TERMINAL__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__CONNECTED_FROM = IFC_FLOW_TERMINAL__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__CONTAINED_IN_STRUCTURE = IFC_FLOW_TERMINAL__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__HAS_PORTS = IFC_FLOW_TERMINAL__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__HAS_CONTROL_ELEMENTS = IFC_FLOW_TERMINAL__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Audio Visual Appliance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_FEATURE_COUNT = IFC_FLOW_TERMINAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAudioVisualApplianceTypeImpl <em>Ifc Audio Visual Appliance Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAudioVisualApplianceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAudioVisualApplianceType()
	 * @generated
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE = 29;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__GLOBAL_ID = IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__OWNER_HISTORY = IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__NAME = IFC_FLOW_TERMINAL_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__DESCRIPTION = IFC_FLOW_TERMINAL_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__NESTS = IFC_FLOW_TERMINAL_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__IS_NESTED_BY = IFC_FLOW_TERMINAL_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__HAS_CONTEXT = IFC_FLOW_TERMINAL_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__DECOMPOSES = IFC_FLOW_TERMINAL_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__TYPES = IFC_FLOW_TERMINAL_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__TAG = IFC_FLOW_TERMINAL_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__REFERENCED_BY = IFC_FLOW_TERMINAL_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__ELEMENT_TYPE = IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Audio Visual Appliance Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AUDIO_VISUAL_APPLIANCE_TYPE_FEATURE_COUNT = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcPlacementImpl <em>Ifc Placement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcPlacementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcPlacement()
	 * @generated
	 */
	int IFC_PLACEMENT = 418;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Location</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT__LOCATION = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Placement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PLACEMENT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAxis1PlacementImpl <em>Ifc Axis1 Placement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAxis1PlacementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAxis1Placement()
	 * @generated
	 */
	int IFC_AXIS1_PLACEMENT = 30;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__LAYER_ASSIGNMENT = IFC_PLACEMENT__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__STYLED_BY_ITEM = IFC_PLACEMENT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Location</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__LOCATION = IFC_PLACEMENT__LOCATION;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__DIM = IFC_PLACEMENT__DIM;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT__AXIS = IFC_PLACEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Axis1 Placement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS1_PLACEMENT_FEATURE_COUNT = IFC_PLACEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAxis2Placement2DImpl <em>Ifc Axis2 Placement2 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAxis2Placement2DImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAxis2Placement2D()
	 * @generated
	 */
	int IFC_AXIS2_PLACEMENT2_D = 31;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__LAYER_ASSIGNMENT = IFC_PLACEMENT__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__STYLED_BY_ITEM = IFC_PLACEMENT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Location</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__LOCATION = IFC_PLACEMENT__LOCATION;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__DIM = IFC_PLACEMENT__DIM;

	/**
	 * The feature id for the '<em><b>Ref Direction</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D__REF_DIRECTION = IFC_PLACEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Axis2 Placement2 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT2_D_FEATURE_COUNT = IFC_PLACEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcAxis2Placement3DImpl <em>Ifc Axis2 Placement3 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcAxis2Placement3DImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcAxis2Placement3D()
	 * @generated
	 */
	int IFC_AXIS2_PLACEMENT3_D = 32;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__LAYER_ASSIGNMENT = IFC_PLACEMENT__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__STYLED_BY_ITEM = IFC_PLACEMENT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Location</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__LOCATION = IFC_PLACEMENT__LOCATION;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__DIM = IFC_PLACEMENT__DIM;

	/**
	 * The feature id for the '<em><b>Axis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__AXIS = IFC_PLACEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Ref Direction</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D__REF_DIRECTION = IFC_PLACEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Axis2 Placement3 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_AXIS2_PLACEMENT3_D_FEATURE_COUNT = IFC_PLACEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCurveImpl <em>Ifc Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCurveImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCurve()
	 * @generated
	 */
	int IFC_CURVE = 159;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURVE_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundedCurveImpl <em>Ifc Bounded Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundedCurveImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundedCurve()
	 * @generated
	 */
	int IFC_BOUNDED_CURVE = 52;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_CURVE__LAYER_ASSIGNMENT = IFC_CURVE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_CURVE__STYLED_BY_ITEM = IFC_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_CURVE__DIM = IFC_CURVE__DIM;

	/**
	 * The number of structural features of the '<em>Ifc Bounded Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_CURVE_FEATURE_COUNT = IFC_CURVE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBSplineCurveImpl <em>Ifc BSpline Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBSplineCurveImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBSplineCurve()
	 * @generated
	 */
	int IFC_BSPLINE_CURVE = 33;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__LAYER_ASSIGNMENT = IFC_BOUNDED_CURVE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__STYLED_BY_ITEM = IFC_BOUNDED_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__DIM = IFC_BOUNDED_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Degree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__DEGREE = IFC_BOUNDED_CURVE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Control Points List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__CONTROL_POINTS_LIST = IFC_BOUNDED_CURVE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Curve Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__CURVE_FORM = IFC_BOUNDED_CURVE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Closed Curve</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__CLOSED_CURVE = IFC_BOUNDED_CURVE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE__SELF_INTERSECT = IFC_BOUNDED_CURVE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc BSpline Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_FEATURE_COUNT = IFC_BOUNDED_CURVE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBSplineCurveWithKnotsImpl <em>Ifc BSpline Curve With Knots</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBSplineCurveWithKnotsImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBSplineCurveWithKnots()
	 * @generated
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS = 34;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__LAYER_ASSIGNMENT = IFC_BSPLINE_CURVE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__STYLED_BY_ITEM = IFC_BSPLINE_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__DIM = IFC_BSPLINE_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Degree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__DEGREE = IFC_BSPLINE_CURVE__DEGREE;

	/**
	 * The feature id for the '<em><b>Control Points List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__CONTROL_POINTS_LIST = IFC_BSPLINE_CURVE__CONTROL_POINTS_LIST;

	/**
	 * The feature id for the '<em><b>Curve Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__CURVE_FORM = IFC_BSPLINE_CURVE__CURVE_FORM;

	/**
	 * The feature id for the '<em><b>Closed Curve</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__CLOSED_CURVE = IFC_BSPLINE_CURVE__CLOSED_CURVE;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__SELF_INTERSECT = IFC_BSPLINE_CURVE__SELF_INTERSECT;

	/**
	 * The feature id for the '<em><b>Knot Multiplicities</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__KNOT_MULTIPLICITIES = IFC_BSPLINE_CURVE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Knots</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__KNOTS = IFC_BSPLINE_CURVE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Knots As String</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__KNOTS_AS_STRING = IFC_BSPLINE_CURVE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Knot Spec</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS__KNOT_SPEC = IFC_BSPLINE_CURVE_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc BSpline Curve With Knots</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_CURVE_WITH_KNOTS_FEATURE_COUNT = IFC_BSPLINE_CURVE_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcSurfaceImpl <em>Ifc Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcSurfaceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcSurface()
	 * @generated
	 */
	int IFC_SURFACE = 662;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundedSurfaceImpl <em>Ifc Bounded Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundedSurfaceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundedSurface()
	 * @generated
	 */
	int IFC_BOUNDED_SURFACE = 53;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_SURFACE__LAYER_ASSIGNMENT = IFC_SURFACE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_SURFACE__STYLED_BY_ITEM = IFC_SURFACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_SURFACE__DIM = IFC_SURFACE__DIM;

	/**
	 * The number of structural features of the '<em>Ifc Bounded Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDED_SURFACE_FEATURE_COUNT = IFC_SURFACE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBSplineSurfaceImpl <em>Ifc BSpline Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBSplineSurfaceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBSplineSurface()
	 * @generated
	 */
	int IFC_BSPLINE_SURFACE = 35;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__LAYER_ASSIGNMENT = IFC_BOUNDED_SURFACE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__STYLED_BY_ITEM = IFC_BOUNDED_SURFACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__DIM = IFC_BOUNDED_SURFACE__DIM;

	/**
	 * The feature id for the '<em><b>UDegree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__UDEGREE = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>VDegree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__VDEGREE = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Control Points List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__CONTROL_POINTS_LIST = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Surface Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__SURFACE_FORM = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>UClosed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__UCLOSED = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>VClosed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__VCLOSED = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE__SELF_INTERSECT = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Ifc BSpline Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_FEATURE_COUNT = IFC_BOUNDED_SURFACE_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBSplineSurfaceWithKnotsImpl <em>Ifc BSpline Surface With Knots</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBSplineSurfaceWithKnotsImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBSplineSurfaceWithKnots()
	 * @generated
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS = 36;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__LAYER_ASSIGNMENT = IFC_BSPLINE_SURFACE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__STYLED_BY_ITEM = IFC_BSPLINE_SURFACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__DIM = IFC_BSPLINE_SURFACE__DIM;

	/**
	 * The feature id for the '<em><b>UDegree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__UDEGREE = IFC_BSPLINE_SURFACE__UDEGREE;

	/**
	 * The feature id for the '<em><b>VDegree</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__VDEGREE = IFC_BSPLINE_SURFACE__VDEGREE;

	/**
	 * The feature id for the '<em><b>Control Points List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__CONTROL_POINTS_LIST = IFC_BSPLINE_SURFACE__CONTROL_POINTS_LIST;

	/**
	 * The feature id for the '<em><b>Surface Form</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__SURFACE_FORM = IFC_BSPLINE_SURFACE__SURFACE_FORM;

	/**
	 * The feature id for the '<em><b>UClosed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__UCLOSED = IFC_BSPLINE_SURFACE__UCLOSED;

	/**
	 * The feature id for the '<em><b>VClosed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__VCLOSED = IFC_BSPLINE_SURFACE__VCLOSED;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__SELF_INTERSECT = IFC_BSPLINE_SURFACE__SELF_INTERSECT;

	/**
	 * The feature id for the '<em><b>UMultiplicities</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__UMULTIPLICITIES = IFC_BSPLINE_SURFACE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>VMultiplicities</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__VMULTIPLICITIES = IFC_BSPLINE_SURFACE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>UKnots</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__UKNOTS = IFC_BSPLINE_SURFACE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>UKnots As String</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__UKNOTS_AS_STRING = IFC_BSPLINE_SURFACE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>VKnots</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__VKNOTS = IFC_BSPLINE_SURFACE_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>VKnots As String</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__VKNOTS_AS_STRING = IFC_BSPLINE_SURFACE_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Knot Spec</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS__KNOT_SPEC = IFC_BSPLINE_SURFACE_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Ifc BSpline Surface With Knots</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BSPLINE_SURFACE_WITH_KNOTS_FEATURE_COUNT = IFC_BSPLINE_SURFACE_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingElementImpl <em>Ifc Building Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingElementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuildingElement()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT = 57;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__NESTS = IFC_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_NESTED_BY = IFC_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_CONTEXT = IFC_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_DECLARED_BY = IFC_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__DECLARES = IFC_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_TYPED_BY = IFC_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_INTERFERED_BY_ELEMENTS = IFC_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__INTERFERES_ELEMENTS = IFC_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT__HAS_COVERINGS = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Building Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBeamImpl <em>Ifc Beam</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBeamImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBeam()
	 * @generated
	 */
	int IFC_BEAM = 37;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__NESTS = IFC_BUILDING_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_NESTED_BY = IFC_BUILDING_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_CONTEXT = IFC_BUILDING_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_DECLARED_BY = IFC_BUILDING_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__DECLARES = IFC_BUILDING_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_TYPED_BY = IFC_BUILDING_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_INTERFERED_BY_ELEMENTS = IFC_BUILDING_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__INTERFERES_ELEMENTS = IFC_BUILDING_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Beam</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBeamStandardCaseImpl <em>Ifc Beam Standard Case</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBeamStandardCaseImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBeamStandardCase()
	 * @generated
	 */
	int IFC_BEAM_STANDARD_CASE = 38;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__GLOBAL_ID = IFC_BEAM__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__OWNER_HISTORY = IFC_BEAM__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__NAME = IFC_BEAM__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__DESCRIPTION = IFC_BEAM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__HAS_ASSIGNMENTS = IFC_BEAM__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__NESTS = IFC_BEAM__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__IS_NESTED_BY = IFC_BEAM__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__HAS_CONTEXT = IFC_BEAM__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__IS_DECOMPOSED_BY = IFC_BEAM__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__DECOMPOSES = IFC_BEAM__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__HAS_ASSOCIATIONS = IFC_BEAM__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__OBJECT_TYPE = IFC_BEAM__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__IS_DECLARED_BY = IFC_BEAM__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__DECLARES = IFC_BEAM__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__IS_TYPED_BY = IFC_BEAM__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__IS_DEFINED_BY = IFC_BEAM__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__OBJECT_PLACEMENT = IFC_BEAM__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__REPRESENTATION = IFC_BEAM__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__REFERENCED_BY = IFC_BEAM__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__GEOMETRY = IFC_BEAM__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__TAG = IFC_BEAM__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__FILLS_VOIDS = IFC_BEAM__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__CONNECTED_TO = IFC_BEAM__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__IS_INTERFERED_BY_ELEMENTS = IFC_BEAM__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__INTERFERES_ELEMENTS = IFC_BEAM__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__HAS_PROJECTIONS = IFC_BEAM__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__REFERENCED_IN_STRUCTURES = IFC_BEAM__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__HAS_OPENINGS = IFC_BEAM__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__IS_CONNECTION_REALIZATION = IFC_BEAM__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__PROVIDES_BOUNDARIES = IFC_BEAM__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__CONNECTED_FROM = IFC_BEAM__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__CONTAINED_IN_STRUCTURE = IFC_BEAM__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__HAS_COVERINGS = IFC_BEAM__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE__PREDEFINED_TYPE = IFC_BEAM__PREDEFINED_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Beam Standard Case</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_STANDARD_CASE_FEATURE_COUNT = IFC_BEAM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingElementTypeImpl <em>Ifc Building Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingElementTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuildingElementType()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_TYPE = 62;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID = IFC_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY = IFC_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__NAME = IFC_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION = IFC_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__NESTS = IFC_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__IS_NESTED_BY = IFC_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__HAS_CONTEXT = IFC_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES = IFC_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__TYPES = IFC_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__TAG = IFC_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__REFERENCED_BY = IFC_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE = IFC_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT = IFC_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBeamTypeImpl <em>Ifc Beam Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBeamTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBeamType()
	 * @generated
	 */
	int IFC_BEAM_TYPE = 39;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__NESTS = IFC_BUILDING_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__IS_NESTED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__HAS_CONTEXT = IFC_BUILDING_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__TYPES = IFC_BUILDING_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__REFERENCED_BY = IFC_BUILDING_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Beam Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BEAM_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcPresentationItemImpl <em>Ifc Presentation Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcPresentationItemImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcPresentationItem()
	 * @generated
	 */
	int IFC_PRESENTATION_ITEM = 439;

	/**
	 * The number of structural features of the '<em>Ifc Presentation Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PRESENTATION_ITEM_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcSurfaceTextureImpl <em>Ifc Surface Texture</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcSurfaceTextureImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcSurfaceTexture()
	 * @generated
	 */
	int IFC_SURFACE_TEXTURE = 674;

	/**
	 * The feature id for the '<em><b>Repeat S</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__REPEAT_S = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Repeat T</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__REPEAT_T = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__MODE = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Texture Transform</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__TEXTURE_TRANSFORM = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__PARAMETER = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Is Mapped By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__IS_MAPPED_BY = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Used In Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE__USED_IN_STYLES = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Ifc Surface Texture</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SURFACE_TEXTURE_FEATURE_COUNT = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBlobTextureImpl <em>Ifc Blob Texture</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBlobTextureImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBlobTexture()
	 * @generated
	 */
	int IFC_BLOB_TEXTURE = 40;

	/**
	 * The feature id for the '<em><b>Repeat S</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__REPEAT_S = IFC_SURFACE_TEXTURE__REPEAT_S;

	/**
	 * The feature id for the '<em><b>Repeat T</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__REPEAT_T = IFC_SURFACE_TEXTURE__REPEAT_T;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__MODE = IFC_SURFACE_TEXTURE__MODE;

	/**
	 * The feature id for the '<em><b>Texture Transform</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__TEXTURE_TRANSFORM = IFC_SURFACE_TEXTURE__TEXTURE_TRANSFORM;

	/**
	 * The feature id for the '<em><b>Parameter</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__PARAMETER = IFC_SURFACE_TEXTURE__PARAMETER;

	/**
	 * The feature id for the '<em><b>Is Mapped By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__IS_MAPPED_BY = IFC_SURFACE_TEXTURE__IS_MAPPED_BY;

	/**
	 * The feature id for the '<em><b>Used In Styles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__USED_IN_STYLES = IFC_SURFACE_TEXTURE__USED_IN_STYLES;

	/**
	 * The feature id for the '<em><b>Raster Format</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__RASTER_FORMAT = IFC_SURFACE_TEXTURE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Raster Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE__RASTER_CODE = IFC_SURFACE_TEXTURE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Blob Texture</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOB_TEXTURE_FEATURE_COUNT = IFC_SURFACE_TEXTURE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCsgPrimitive3DImpl <em>Ifc Csg Primitive3 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCsgPrimitive3DImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCsgPrimitive3D()
	 * @generated
	 */
	int IFC_CSG_PRIMITIVE3_D = 154;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D__POSITION = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Csg Primitive3 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBlockImpl <em>Ifc Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBlockImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBlock()
	 * @generated
	 */
	int IFC_BLOCK = 41;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__LAYER_ASSIGNMENT = IFC_CSG_PRIMITIVE3_D__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__STYLED_BY_ITEM = IFC_CSG_PRIMITIVE3_D__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__POSITION = IFC_CSG_PRIMITIVE3_D__POSITION;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__DIM = IFC_CSG_PRIMITIVE3_D__DIM;

	/**
	 * The feature id for the '<em><b>XLength</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__XLENGTH = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>XLength As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__XLENGTH_AS_STRING = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>YLength</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__YLENGTH = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>YLength As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__YLENGTH_AS_STRING = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>ZLength</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__ZLENGTH = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>ZLength As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK__ZLENGTH_AS_STRING = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BLOCK_FEATURE_COUNT = IFC_CSG_PRIMITIVE3_D_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoilerImpl <em>Ifc Boiler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoilerImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoiler()
	 * @generated
	 */
	int IFC_BOILER = 42;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__NAME = IFC_ENERGY_CONVERSION_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__NESTS = IFC_ENERGY_CONVERSION_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__OBJECT_TYPE = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__IS_DECLARED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__DECLARES = IFC_ENERGY_CONVERSION_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__IS_TYPED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__IS_DEFINED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__OBJECT_PLACEMENT = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__REPRESENTATION = IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__GEOMETRY = IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__TAG = IFC_ENERGY_CONVERSION_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__FILLS_VOIDS = IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__CONNECTED_TO = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__IS_INTERFERED_BY_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__INTERFERES_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__HAS_PROJECTIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__REFERENCED_IN_STRUCTURES = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__HAS_OPENINGS = IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__IS_CONNECTION_REALIZATION = IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__PROVIDES_BOUNDARIES = IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__CONNECTED_FROM = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__CONTAINED_IN_STRUCTURE = IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__HAS_PORTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__HAS_CONTROL_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Boiler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoilerTypeImpl <em>Ifc Boiler Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoilerTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoilerType()
	 * @generated
	 */
	int IFC_BOILER_TYPE = 43;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__NESTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__TYPES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Boiler Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOILER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBooleanResultImpl <em>Ifc Boolean Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBooleanResultImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBooleanResult()
	 * @generated
	 */
	int IFC_BOOLEAN_RESULT = 45;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__OPERATOR = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>First Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__FIRST_OPERAND = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Second Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__SECOND_OPERAND = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Boolean Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_RESULT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBooleanClippingResultImpl <em>Ifc Boolean Clipping Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBooleanClippingResultImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBooleanClippingResult()
	 * @generated
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT = 44;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__LAYER_ASSIGNMENT = IFC_BOOLEAN_RESULT__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__STYLED_BY_ITEM = IFC_BOOLEAN_RESULT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__OPERATOR = IFC_BOOLEAN_RESULT__OPERATOR;

	/**
	 * The feature id for the '<em><b>First Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__FIRST_OPERAND = IFC_BOOLEAN_RESULT__FIRST_OPERAND;

	/**
	 * The feature id for the '<em><b>Second Operand</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__SECOND_OPERAND = IFC_BOOLEAN_RESULT__SECOND_OPERAND;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT__DIM = IFC_BOOLEAN_RESULT__DIM;

	/**
	 * The number of structural features of the '<em>Ifc Boolean Clipping Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOOLEAN_CLIPPING_RESULT_FEATURE_COUNT = IFC_BOOLEAN_RESULT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundaryConditionImpl <em>Ifc Boundary Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundaryConditionImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundaryCondition()
	 * @generated
	 */
	int IFC_BOUNDARY_CONDITION = 46;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CONDITION__NAME = 0;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CONDITION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCompositeCurveImpl <em>Ifc Composite Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCompositeCurveImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCompositeCurve()
	 * @generated
	 */
	int IFC_COMPOSITE_CURVE = 109;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__LAYER_ASSIGNMENT = IFC_BOUNDED_CURVE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__STYLED_BY_ITEM = IFC_BOUNDED_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__DIM = IFC_BOUNDED_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__SEGMENTS = IFC_BOUNDED_CURVE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE__SELF_INTERSECT = IFC_BOUNDED_CURVE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Composite Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_FEATURE_COUNT = IFC_BOUNDED_CURVE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCompositeCurveOnSurfaceImpl <em>Ifc Composite Curve On Surface</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCompositeCurveOnSurfaceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCompositeCurveOnSurface()
	 * @generated
	 */
	int IFC_COMPOSITE_CURVE_ON_SURFACE = 110;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_ON_SURFACE__LAYER_ASSIGNMENT = IFC_COMPOSITE_CURVE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_ON_SURFACE__STYLED_BY_ITEM = IFC_COMPOSITE_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_ON_SURFACE__DIM = IFC_COMPOSITE_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_ON_SURFACE__SEGMENTS = IFC_COMPOSITE_CURVE__SEGMENTS;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_ON_SURFACE__SELF_INTERSECT = IFC_COMPOSITE_CURVE__SELF_INTERSECT;

	/**
	 * The number of structural features of the '<em>Ifc Composite Curve On Surface</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_ON_SURFACE_FEATURE_COUNT = IFC_COMPOSITE_CURVE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundaryCurveImpl <em>Ifc Boundary Curve</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundaryCurveImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundaryCurve()
	 * @generated
	 */
	int IFC_BOUNDARY_CURVE = 47;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CURVE__LAYER_ASSIGNMENT = IFC_COMPOSITE_CURVE_ON_SURFACE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CURVE__STYLED_BY_ITEM = IFC_COMPOSITE_CURVE_ON_SURFACE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CURVE__DIM = IFC_COMPOSITE_CURVE_ON_SURFACE__DIM;

	/**
	 * The feature id for the '<em><b>Segments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CURVE__SEGMENTS = IFC_COMPOSITE_CURVE_ON_SURFACE__SEGMENTS;

	/**
	 * The feature id for the '<em><b>Self Intersect</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CURVE__SELF_INTERSECT = IFC_COMPOSITE_CURVE_ON_SURFACE__SELF_INTERSECT;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Curve</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_CURVE_FEATURE_COUNT = IFC_COMPOSITE_CURVE_ON_SURFACE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundaryEdgeConditionImpl <em>Ifc Boundary Edge Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundaryEdgeConditionImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundaryEdgeCondition()
	 * @generated
	 */
	int IFC_BOUNDARY_EDGE_CONDITION = 48;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__NAME = IFC_BOUNDARY_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Translational Stiffness By Length X</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__TRANSLATIONAL_STIFFNESS_BY_LENGTH_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Translational Stiffness By Length Y</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__TRANSLATIONAL_STIFFNESS_BY_LENGTH_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Translational Stiffness By Length Z</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__TRANSLATIONAL_STIFFNESS_BY_LENGTH_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length X</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length Y</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness By Length Z</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION__ROTATIONAL_STIFFNESS_BY_LENGTH_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Edge Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_EDGE_CONDITION_FEATURE_COUNT = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundaryFaceConditionImpl <em>Ifc Boundary Face Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundaryFaceConditionImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundaryFaceCondition()
	 * @generated
	 */
	int IFC_BOUNDARY_FACE_CONDITION = 49;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__NAME = IFC_BOUNDARY_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Translational Stiffness By Area X</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__TRANSLATIONAL_STIFFNESS_BY_AREA_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Translational Stiffness By Area Y</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__TRANSLATIONAL_STIFFNESS_BY_AREA_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Translational Stiffness By Area Z</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION__TRANSLATIONAL_STIFFNESS_BY_AREA_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Face Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_FACE_CONDITION_FEATURE_COUNT = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundaryNodeConditionImpl <em>Ifc Boundary Node Condition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundaryNodeConditionImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundaryNodeCondition()
	 * @generated
	 */
	int IFC_BOUNDARY_NODE_CONDITION = 50;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__NAME = IFC_BOUNDARY_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Translational Stiffness X</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__TRANSLATIONAL_STIFFNESS_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Translational Stiffness Y</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__TRANSLATIONAL_STIFFNESS_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Translational Stiffness Z</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__TRANSLATIONAL_STIFFNESS_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness X</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_X = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness Y</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_Y = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness Z</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_Z = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Node Condition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_FEATURE_COUNT = IFC_BOUNDARY_CONDITION_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundaryNodeConditionWarpingImpl <em>Ifc Boundary Node Condition Warping</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundaryNodeConditionWarpingImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundaryNodeConditionWarping()
	 * @generated
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING = 51;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__NAME = IFC_BOUNDARY_NODE_CONDITION__NAME;

	/**
	 * The feature id for the '<em><b>Translational Stiffness X</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__TRANSLATIONAL_STIFFNESS_X = IFC_BOUNDARY_NODE_CONDITION__TRANSLATIONAL_STIFFNESS_X;

	/**
	 * The feature id for the '<em><b>Translational Stiffness Y</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__TRANSLATIONAL_STIFFNESS_Y = IFC_BOUNDARY_NODE_CONDITION__TRANSLATIONAL_STIFFNESS_Y;

	/**
	 * The feature id for the '<em><b>Translational Stiffness Z</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__TRANSLATIONAL_STIFFNESS_Z = IFC_BOUNDARY_NODE_CONDITION__TRANSLATIONAL_STIFFNESS_Z;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness X</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_X = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_X;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness Y</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_Y = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_Y;

	/**
	 * The feature id for the '<em><b>Rotational Stiffness Z</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__ROTATIONAL_STIFFNESS_Z = IFC_BOUNDARY_NODE_CONDITION__ROTATIONAL_STIFFNESS_Z;

	/**
	 * The feature id for the '<em><b>Warping Stiffness</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING__WARPING_STIFFNESS = IFC_BOUNDARY_NODE_CONDITION_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Boundary Node Condition Warping</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDARY_NODE_CONDITION_WARPING_FEATURE_COUNT = IFC_BOUNDARY_NODE_CONDITION_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoundingBoxImpl <em>Ifc Bounding Box</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoundingBoxImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoundingBox()
	 * @generated
	 */
	int IFC_BOUNDING_BOX = 54;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Corner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__CORNER = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>XDim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__XDIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>XDim As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__XDIM_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>YDim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__YDIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>YDim As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__YDIM_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>ZDim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__ZDIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>ZDim As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__ZDIM_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 7;

	/**
	 * The number of structural features of the '<em>Ifc Bounding Box</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOUNDING_BOX_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 8;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcHalfSpaceSolidImpl <em>Ifc Half Space Solid</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcHalfSpaceSolidImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcHalfSpaceSolid()
	 * @generated
	 */
	int IFC_HALF_SPACE_SOLID = 309;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Base Surface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__BASE_SURFACE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Agreement Flag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__AGREEMENT_FLAG = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Half Space Solid</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_HALF_SPACE_SOLID_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBoxedHalfSpaceImpl <em>Ifc Boxed Half Space</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBoxedHalfSpaceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBoxedHalfSpace()
	 * @generated
	 */
	int IFC_BOXED_HALF_SPACE = 55;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__LAYER_ASSIGNMENT = IFC_HALF_SPACE_SOLID__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__STYLED_BY_ITEM = IFC_HALF_SPACE_SOLID__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Base Surface</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__BASE_SURFACE = IFC_HALF_SPACE_SOLID__BASE_SURFACE;

	/**
	 * The feature id for the '<em><b>Agreement Flag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__AGREEMENT_FLAG = IFC_HALF_SPACE_SOLID__AGREEMENT_FLAG;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__DIM = IFC_HALF_SPACE_SOLID__DIM;

	/**
	 * The feature id for the '<em><b>Enclosure</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE__ENCLOSURE = IFC_HALF_SPACE_SOLID_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Boxed Half Space</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BOXED_HALF_SPACE_FEATURE_COUNT = IFC_HALF_SPACE_SOLID_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcSpatialElementImpl <em>Ifc Spatial Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcSpatialElementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcSpatialElement()
	 * @generated
	 */
	int IFC_SPATIAL_ELEMENT = 606;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__GLOBAL_ID = IFC_PRODUCT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__OWNER_HISTORY = IFC_PRODUCT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__NAME = IFC_PRODUCT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__DESCRIPTION = IFC_PRODUCT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__HAS_ASSIGNMENTS = IFC_PRODUCT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__NESTS = IFC_PRODUCT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__IS_NESTED_BY = IFC_PRODUCT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__HAS_CONTEXT = IFC_PRODUCT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__IS_DECOMPOSED_BY = IFC_PRODUCT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__DECOMPOSES = IFC_PRODUCT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__HAS_ASSOCIATIONS = IFC_PRODUCT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__OBJECT_TYPE = IFC_PRODUCT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__IS_DECLARED_BY = IFC_PRODUCT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__DECLARES = IFC_PRODUCT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__IS_TYPED_BY = IFC_PRODUCT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__IS_DEFINED_BY = IFC_PRODUCT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__OBJECT_PLACEMENT = IFC_PRODUCT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__REPRESENTATION = IFC_PRODUCT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__REFERENCED_BY = IFC_PRODUCT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__GEOMETRY = IFC_PRODUCT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Long Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__LONG_NAME = IFC_PRODUCT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Contains Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__CONTAINS_ELEMENTS = IFC_PRODUCT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Serviced By Systems</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__SERVICED_BY_SYSTEMS = IFC_PRODUCT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>References Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT__REFERENCES_ELEMENTS = IFC_PRODUCT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Spatial Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_ELEMENT_FEATURE_COUNT = IFC_PRODUCT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcSpatialStructureElementImpl <em>Ifc Spatial Structure Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcSpatialStructureElementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcSpatialStructureElement()
	 * @generated
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT = 608;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__GLOBAL_ID = IFC_SPATIAL_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__OWNER_HISTORY = IFC_SPATIAL_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__NAME = IFC_SPATIAL_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__DESCRIPTION = IFC_SPATIAL_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSIGNMENTS = IFC_SPATIAL_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__NESTS = IFC_SPATIAL_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__IS_NESTED_BY = IFC_SPATIAL_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_CONTEXT = IFC_SPATIAL_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECOMPOSED_BY = IFC_SPATIAL_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__DECOMPOSES = IFC_SPATIAL_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSOCIATIONS = IFC_SPATIAL_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_TYPE = IFC_SPATIAL_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECLARED_BY = IFC_SPATIAL_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__DECLARES = IFC_SPATIAL_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__IS_TYPED_BY = IFC_SPATIAL_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DEFINED_BY = IFC_SPATIAL_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_PLACEMENT = IFC_SPATIAL_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__REPRESENTATION = IFC_SPATIAL_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCED_BY = IFC_SPATIAL_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__GEOMETRY = IFC_SPATIAL_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Long Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__LONG_NAME = IFC_SPATIAL_ELEMENT__LONG_NAME;

	/**
	 * The feature id for the '<em><b>Contains Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__CONTAINS_ELEMENTS = IFC_SPATIAL_ELEMENT__CONTAINS_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Serviced By Systems</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__SERVICED_BY_SYSTEMS = IFC_SPATIAL_ELEMENT__SERVICED_BY_SYSTEMS;

	/**
	 * The feature id for the '<em><b>References Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCES_ELEMENTS = IFC_SPATIAL_ELEMENT__REFERENCES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Composition Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT__COMPOSITION_TYPE = IFC_SPATIAL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Spatial Structure Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT = IFC_SPATIAL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingImpl <em>Ifc Building</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuilding()
	 * @generated
	 */
	int IFC_BUILDING = 56;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__GLOBAL_ID = IFC_SPATIAL_STRUCTURE_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__OWNER_HISTORY = IFC_SPATIAL_STRUCTURE_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__NAME = IFC_SPATIAL_STRUCTURE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__DESCRIPTION = IFC_SPATIAL_STRUCTURE_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__HAS_ASSIGNMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__NESTS = IFC_SPATIAL_STRUCTURE_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__IS_NESTED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__HAS_CONTEXT = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__IS_DECOMPOSED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__DECOMPOSES = IFC_SPATIAL_STRUCTURE_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__HAS_ASSOCIATIONS = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__OBJECT_TYPE = IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__IS_DECLARED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__DECLARES = IFC_SPATIAL_STRUCTURE_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__IS_TYPED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__IS_DEFINED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__OBJECT_PLACEMENT = IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__REPRESENTATION = IFC_SPATIAL_STRUCTURE_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__REFERENCED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__GEOMETRY = IFC_SPATIAL_STRUCTURE_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Long Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__LONG_NAME = IFC_SPATIAL_STRUCTURE_ELEMENT__LONG_NAME;

	/**
	 * The feature id for the '<em><b>Contains Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__CONTAINS_ELEMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__CONTAINS_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Serviced By Systems</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__SERVICED_BY_SYSTEMS = IFC_SPATIAL_STRUCTURE_ELEMENT__SERVICED_BY_SYSTEMS;

	/**
	 * The feature id for the '<em><b>References Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__REFERENCES_ELEMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Composition Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__COMPOSITION_TYPE = IFC_SPATIAL_STRUCTURE_ELEMENT__COMPOSITION_TYPE;

	/**
	 * The feature id for the '<em><b>Elevation Of Ref Height</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__ELEVATION_OF_REF_HEIGHT = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Elevation Of Ref Height As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__ELEVATION_OF_REF_HEIGHT_AS_STRING = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Elevation Of Terrain</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__ELEVATION_OF_TERRAIN = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Elevation Of Terrain As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__ELEVATION_OF_TERRAIN_AS_STRING = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Building Address</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING__BUILDING_ADDRESS = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Building</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_FEATURE_COUNT = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcElementComponentImpl <em>Ifc Element Component</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcElementComponentImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcElementComponent()
	 * @generated
	 */
	int IFC_ELEMENT_COMPONENT = 222;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__NESTS = IFC_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_NESTED_BY = IFC_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_CONTEXT = IFC_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_DECLARED_BY = IFC_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__DECLARES = IFC_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_TYPED_BY = IFC_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_INTERFERED_BY_ELEMENTS = IFC_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__INTERFERES_ELEMENTS = IFC_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Element Component</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingElementPartImpl <em>Ifc Building Element Part</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingElementPartImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuildingElementPart()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_PART = 58;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__GLOBAL_ID = IFC_ELEMENT_COMPONENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__OWNER_HISTORY = IFC_ELEMENT_COMPONENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__NAME = IFC_ELEMENT_COMPONENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__DESCRIPTION = IFC_ELEMENT_COMPONENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_ASSIGNMENTS = IFC_ELEMENT_COMPONENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__NESTS = IFC_ELEMENT_COMPONENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_NESTED_BY = IFC_ELEMENT_COMPONENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_CONTEXT = IFC_ELEMENT_COMPONENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_DECOMPOSED_BY = IFC_ELEMENT_COMPONENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__DECOMPOSES = IFC_ELEMENT_COMPONENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_ASSOCIATIONS = IFC_ELEMENT_COMPONENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__OBJECT_TYPE = IFC_ELEMENT_COMPONENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_DECLARED_BY = IFC_ELEMENT_COMPONENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__DECLARES = IFC_ELEMENT_COMPONENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_TYPED_BY = IFC_ELEMENT_COMPONENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_DEFINED_BY = IFC_ELEMENT_COMPONENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__OBJECT_PLACEMENT = IFC_ELEMENT_COMPONENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__REPRESENTATION = IFC_ELEMENT_COMPONENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__REFERENCED_BY = IFC_ELEMENT_COMPONENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__GEOMETRY = IFC_ELEMENT_COMPONENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__TAG = IFC_ELEMENT_COMPONENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__FILLS_VOIDS = IFC_ELEMENT_COMPONENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__CONNECTED_TO = IFC_ELEMENT_COMPONENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_INTERFERED_BY_ELEMENTS = IFC_ELEMENT_COMPONENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__INTERFERES_ELEMENTS = IFC_ELEMENT_COMPONENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_PROJECTIONS = IFC_ELEMENT_COMPONENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__REFERENCED_IN_STRUCTURES = IFC_ELEMENT_COMPONENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__HAS_OPENINGS = IFC_ELEMENT_COMPONENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__IS_CONNECTION_REALIZATION = IFC_ELEMENT_COMPONENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__PROVIDES_BOUNDARIES = IFC_ELEMENT_COMPONENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__CONNECTED_FROM = IFC_ELEMENT_COMPONENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__CONTAINED_IN_STRUCTURE = IFC_ELEMENT_COMPONENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART__PREDEFINED_TYPE = IFC_ELEMENT_COMPONENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Part</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_FEATURE_COUNT = IFC_ELEMENT_COMPONENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcElementComponentTypeImpl <em>Ifc Element Component Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcElementComponentTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcElementComponentType()
	 * @generated
	 */
	int IFC_ELEMENT_COMPONENT_TYPE = 223;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__GLOBAL_ID = IFC_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__OWNER_HISTORY = IFC_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__NAME = IFC_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__DESCRIPTION = IFC_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__NESTS = IFC_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__IS_NESTED_BY = IFC_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__HAS_CONTEXT = IFC_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__DECOMPOSES = IFC_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__TYPES = IFC_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__TAG = IFC_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__REFERENCED_BY = IFC_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE__ELEMENT_TYPE = IFC_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Element Component Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_ELEMENT_COMPONENT_TYPE_FEATURE_COUNT = IFC_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingElementPartTypeImpl <em>Ifc Building Element Part Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingElementPartTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuildingElementPartType()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE = 59;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__GLOBAL_ID = IFC_ELEMENT_COMPONENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__OWNER_HISTORY = IFC_ELEMENT_COMPONENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__NAME = IFC_ELEMENT_COMPONENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__DESCRIPTION = IFC_ELEMENT_COMPONENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__NESTS = IFC_ELEMENT_COMPONENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__IS_NESTED_BY = IFC_ELEMENT_COMPONENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__HAS_CONTEXT = IFC_ELEMENT_COMPONENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_COMPONENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__DECOMPOSES = IFC_ELEMENT_COMPONENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_COMPONENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_COMPONENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_COMPONENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__TYPES = IFC_ELEMENT_COMPONENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_COMPONENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__TAG = IFC_ELEMENT_COMPONENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__REFERENCED_BY = IFC_ELEMENT_COMPONENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__ELEMENT_TYPE = IFC_ELEMENT_COMPONENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE__PREDEFINED_TYPE = IFC_ELEMENT_COMPONENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Part Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PART_TYPE_FEATURE_COUNT = IFC_ELEMENT_COMPONENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingElementProxyImpl <em>Ifc Building Element Proxy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingElementProxyImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuildingElementProxy()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_PROXY = 60;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__NESTS = IFC_BUILDING_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_NESTED_BY = IFC_BUILDING_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_CONTEXT = IFC_BUILDING_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_DECLARED_BY = IFC_BUILDING_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__DECLARES = IFC_BUILDING_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_TYPED_BY = IFC_BUILDING_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_INTERFERED_BY_ELEMENTS = IFC_BUILDING_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__INTERFERES_ELEMENTS = IFC_BUILDING_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Proxy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingElementProxyTypeImpl <em>Ifc Building Element Proxy Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingElementProxyTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuildingElementProxyType()
	 * @generated
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE = 61;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__NESTS = IFC_BUILDING_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__IS_NESTED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__HAS_CONTEXT = IFC_BUILDING_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__TYPES = IFC_BUILDING_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__REFERENCED_BY = IFC_BUILDING_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Building Element Proxy Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_ELEMENT_PROXY_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingStoreyImpl <em>Ifc Building Storey</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingStoreyImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuildingStorey()
	 * @generated
	 */
	int IFC_BUILDING_STOREY = 63;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__GLOBAL_ID = IFC_SPATIAL_STRUCTURE_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__OWNER_HISTORY = IFC_SPATIAL_STRUCTURE_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__NAME = IFC_SPATIAL_STRUCTURE_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__DESCRIPTION = IFC_SPATIAL_STRUCTURE_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__HAS_ASSIGNMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__NESTS = IFC_SPATIAL_STRUCTURE_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__IS_NESTED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__HAS_CONTEXT = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__IS_DECOMPOSED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__DECOMPOSES = IFC_SPATIAL_STRUCTURE_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__HAS_ASSOCIATIONS = IFC_SPATIAL_STRUCTURE_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__OBJECT_TYPE = IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__IS_DECLARED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__DECLARES = IFC_SPATIAL_STRUCTURE_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__IS_TYPED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__IS_DEFINED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__OBJECT_PLACEMENT = IFC_SPATIAL_STRUCTURE_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__REPRESENTATION = IFC_SPATIAL_STRUCTURE_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__REFERENCED_BY = IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__GEOMETRY = IFC_SPATIAL_STRUCTURE_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Long Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__LONG_NAME = IFC_SPATIAL_STRUCTURE_ELEMENT__LONG_NAME;

	/**
	 * The feature id for the '<em><b>Contains Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__CONTAINS_ELEMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__CONTAINS_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Serviced By Systems</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__SERVICED_BY_SYSTEMS = IFC_SPATIAL_STRUCTURE_ELEMENT__SERVICED_BY_SYSTEMS;

	/**
	 * The feature id for the '<em><b>References Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__REFERENCES_ELEMENTS = IFC_SPATIAL_STRUCTURE_ELEMENT__REFERENCES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Composition Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__COMPOSITION_TYPE = IFC_SPATIAL_STRUCTURE_ELEMENT__COMPOSITION_TYPE;

	/**
	 * The feature id for the '<em><b>Elevation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__ELEVATION = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Elevation As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY__ELEVATION_AS_STRING = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Building Storey</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_STOREY_FEATURE_COUNT = IFC_SPATIAL_STRUCTURE_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcSystemImpl <em>Ifc System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcSystemImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcSystem()
	 * @generated
	 */
	int IFC_SYSTEM = 681;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__GLOBAL_ID = IFC_GROUP__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__OWNER_HISTORY = IFC_GROUP__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__NAME = IFC_GROUP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__DESCRIPTION = IFC_GROUP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__HAS_ASSIGNMENTS = IFC_GROUP__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__NESTS = IFC_GROUP__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_NESTED_BY = IFC_GROUP__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__HAS_CONTEXT = IFC_GROUP__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_DECOMPOSED_BY = IFC_GROUP__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__DECOMPOSES = IFC_GROUP__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__HAS_ASSOCIATIONS = IFC_GROUP__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__OBJECT_TYPE = IFC_GROUP__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_DECLARED_BY = IFC_GROUP__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__DECLARES = IFC_GROUP__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_TYPED_BY = IFC_GROUP__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_DEFINED_BY = IFC_GROUP__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__IS_GROUPED_BY = IFC_GROUP__IS_GROUPED_BY;

	/**
	 * The feature id for the '<em><b>Services Buildings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM__SERVICES_BUILDINGS = IFC_GROUP_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_SYSTEM_FEATURE_COUNT = IFC_GROUP_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBuildingSystemImpl <em>Ifc Building System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBuildingSystemImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBuildingSystem()
	 * @generated
	 */
	int IFC_BUILDING_SYSTEM = 64;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__GLOBAL_ID = IFC_SYSTEM__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__OWNER_HISTORY = IFC_SYSTEM__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__NAME = IFC_SYSTEM__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__DESCRIPTION = IFC_SYSTEM__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__HAS_ASSIGNMENTS = IFC_SYSTEM__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__NESTS = IFC_SYSTEM__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__IS_NESTED_BY = IFC_SYSTEM__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__HAS_CONTEXT = IFC_SYSTEM__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__IS_DECOMPOSED_BY = IFC_SYSTEM__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__DECOMPOSES = IFC_SYSTEM__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__HAS_ASSOCIATIONS = IFC_SYSTEM__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__OBJECT_TYPE = IFC_SYSTEM__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__IS_DECLARED_BY = IFC_SYSTEM__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__DECLARES = IFC_SYSTEM__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__IS_TYPED_BY = IFC_SYSTEM__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__IS_DEFINED_BY = IFC_SYSTEM__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Is Grouped By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__IS_GROUPED_BY = IFC_SYSTEM__IS_GROUPED_BY;

	/**
	 * The feature id for the '<em><b>Services Buildings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__SERVICES_BUILDINGS = IFC_SYSTEM__SERVICES_BUILDINGS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM__PREDEFINED_TYPE = IFC_SYSTEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Building System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BUILDING_SYSTEM_FEATURE_COUNT = IFC_SYSTEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBurnerImpl <em>Ifc Burner</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBurnerImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBurner()
	 * @generated
	 */
	int IFC_BURNER = 65;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__NAME = IFC_ENERGY_CONVERSION_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__NESTS = IFC_ENERGY_CONVERSION_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__OBJECT_TYPE = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__IS_DECLARED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__DECLARES = IFC_ENERGY_CONVERSION_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__IS_TYPED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__IS_DEFINED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__OBJECT_PLACEMENT = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__REPRESENTATION = IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__GEOMETRY = IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__TAG = IFC_ENERGY_CONVERSION_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__FILLS_VOIDS = IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__CONNECTED_TO = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__IS_INTERFERED_BY_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__INTERFERES_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__HAS_PROJECTIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__REFERENCED_IN_STRUCTURES = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__HAS_OPENINGS = IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__IS_CONNECTION_REALIZATION = IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__PROVIDES_BOUNDARIES = IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__CONNECTED_FROM = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__CONTAINED_IN_STRUCTURE = IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__HAS_PORTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__HAS_CONTROL_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Burner</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcBurnerTypeImpl <em>Ifc Burner Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcBurnerTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcBurnerType()
	 * @generated
	 */
	int IFC_BURNER_TYPE = 66;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__NESTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__TYPES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Burner Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_BURNER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCShapeProfileDefImpl <em>Ifc CShape Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCShapeProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCShapeProfileDef()
	 * @generated
	 */
	int IFC_CSHAPE_PROFILE_DEF = 67;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_PARAMETERIZED_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__HAS_PROPERTIES = IFC_PARAMETERIZED_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Depth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__DEPTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Depth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__DEPTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Width</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__WIDTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Width As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__WIDTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Wall Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__WALL_THICKNESS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Wall Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__WALL_THICKNESS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Girth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__GIRTH = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Girth As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__GIRTH_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Internal Fillet Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__INTERNAL_FILLET_RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Internal Fillet Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF__INTERNAL_FILLET_RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 9;

	/**
	 * The number of structural features of the '<em>Ifc CShape Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSHAPE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 10;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowFittingImpl <em>Ifc Flow Fitting</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowFittingImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowFitting()
	 * @generated
	 */
	int IFC_FLOW_FITTING = 276;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_DECLARED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__DECLARES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_TYPED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Fitting</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCableCarrierFittingImpl <em>Ifc Cable Carrier Fitting</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCableCarrierFittingImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCableCarrierFitting()
	 * @generated
	 */
	int IFC_CABLE_CARRIER_FITTING = 68;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__GLOBAL_ID = IFC_FLOW_FITTING__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__OWNER_HISTORY = IFC_FLOW_FITTING__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__NAME = IFC_FLOW_FITTING__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__DESCRIPTION = IFC_FLOW_FITTING__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__HAS_ASSIGNMENTS = IFC_FLOW_FITTING__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__NESTS = IFC_FLOW_FITTING__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__IS_NESTED_BY = IFC_FLOW_FITTING__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__HAS_CONTEXT = IFC_FLOW_FITTING__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__IS_DECOMPOSED_BY = IFC_FLOW_FITTING__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__DECOMPOSES = IFC_FLOW_FITTING__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__HAS_ASSOCIATIONS = IFC_FLOW_FITTING__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__OBJECT_TYPE = IFC_FLOW_FITTING__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__IS_DECLARED_BY = IFC_FLOW_FITTING__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__DECLARES = IFC_FLOW_FITTING__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__IS_TYPED_BY = IFC_FLOW_FITTING__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__IS_DEFINED_BY = IFC_FLOW_FITTING__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__OBJECT_PLACEMENT = IFC_FLOW_FITTING__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__REPRESENTATION = IFC_FLOW_FITTING__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__REFERENCED_BY = IFC_FLOW_FITTING__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__GEOMETRY = IFC_FLOW_FITTING__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__TAG = IFC_FLOW_FITTING__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__FILLS_VOIDS = IFC_FLOW_FITTING__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__CONNECTED_TO = IFC_FLOW_FITTING__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_FITTING__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__INTERFERES_ELEMENTS = IFC_FLOW_FITTING__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__HAS_PROJECTIONS = IFC_FLOW_FITTING__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__REFERENCED_IN_STRUCTURES = IFC_FLOW_FITTING__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__HAS_OPENINGS = IFC_FLOW_FITTING__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__IS_CONNECTION_REALIZATION = IFC_FLOW_FITTING__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__PROVIDES_BOUNDARIES = IFC_FLOW_FITTING__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__CONNECTED_FROM = IFC_FLOW_FITTING__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__CONTAINED_IN_STRUCTURE = IFC_FLOW_FITTING__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__HAS_PORTS = IFC_FLOW_FITTING__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__HAS_CONTROL_ELEMENTS = IFC_FLOW_FITTING__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING__PREDEFINED_TYPE = IFC_FLOW_FITTING_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Carrier Fitting</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_FEATURE_COUNT = IFC_FLOW_FITTING_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowFittingTypeImpl <em>Ifc Flow Fitting Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowFittingTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowFittingType()
	 * @generated
	 */
	int IFC_FLOW_FITTING_TYPE = 277;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__TYPES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Fitting Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_FITTING_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCableCarrierFittingTypeImpl <em>Ifc Cable Carrier Fitting Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCableCarrierFittingTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCableCarrierFittingType()
	 * @generated
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE = 69;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__GLOBAL_ID = IFC_FLOW_FITTING_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__OWNER_HISTORY = IFC_FLOW_FITTING_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__NAME = IFC_FLOW_FITTING_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__DESCRIPTION = IFC_FLOW_FITTING_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_FITTING_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__NESTS = IFC_FLOW_FITTING_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__IS_NESTED_BY = IFC_FLOW_FITTING_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__HAS_CONTEXT = IFC_FLOW_FITTING_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_FITTING_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__DECOMPOSES = IFC_FLOW_FITTING_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_FITTING_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_FITTING_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_FITTING_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__TYPES = IFC_FLOW_FITTING_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__REPRESENTATION_MAPS = IFC_FLOW_FITTING_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__TAG = IFC_FLOW_FITTING_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__REFERENCED_BY = IFC_FLOW_FITTING_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__ELEMENT_TYPE = IFC_FLOW_FITTING_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE__PREDEFINED_TYPE = IFC_FLOW_FITTING_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Carrier Fitting Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_FITTING_TYPE_FEATURE_COUNT = IFC_FLOW_FITTING_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowSegmentImpl <em>Ifc Flow Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowSegmentImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowSegment()
	 * @generated
	 */
	int IFC_FLOW_SEGMENT = 284;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_DECLARED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__DECLARES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_TYPED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCableCarrierSegmentImpl <em>Ifc Cable Carrier Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCableCarrierSegmentImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCableCarrierSegment()
	 * @generated
	 */
	int IFC_CABLE_CARRIER_SEGMENT = 70;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__GLOBAL_ID = IFC_FLOW_SEGMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__OWNER_HISTORY = IFC_FLOW_SEGMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__NAME = IFC_FLOW_SEGMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__DESCRIPTION = IFC_FLOW_SEGMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__HAS_ASSIGNMENTS = IFC_FLOW_SEGMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__NESTS = IFC_FLOW_SEGMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__IS_NESTED_BY = IFC_FLOW_SEGMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__HAS_CONTEXT = IFC_FLOW_SEGMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__IS_DECOMPOSED_BY = IFC_FLOW_SEGMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__DECOMPOSES = IFC_FLOW_SEGMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__HAS_ASSOCIATIONS = IFC_FLOW_SEGMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__OBJECT_TYPE = IFC_FLOW_SEGMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__IS_DECLARED_BY = IFC_FLOW_SEGMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__DECLARES = IFC_FLOW_SEGMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__IS_TYPED_BY = IFC_FLOW_SEGMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__IS_DEFINED_BY = IFC_FLOW_SEGMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__OBJECT_PLACEMENT = IFC_FLOW_SEGMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__REPRESENTATION = IFC_FLOW_SEGMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__REFERENCED_BY = IFC_FLOW_SEGMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__GEOMETRY = IFC_FLOW_SEGMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__TAG = IFC_FLOW_SEGMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__FILLS_VOIDS = IFC_FLOW_SEGMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__CONNECTED_TO = IFC_FLOW_SEGMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_SEGMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__INTERFERES_ELEMENTS = IFC_FLOW_SEGMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__HAS_PROJECTIONS = IFC_FLOW_SEGMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__REFERENCED_IN_STRUCTURES = IFC_FLOW_SEGMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__HAS_OPENINGS = IFC_FLOW_SEGMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__IS_CONNECTION_REALIZATION = IFC_FLOW_SEGMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__PROVIDES_BOUNDARIES = IFC_FLOW_SEGMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__CONNECTED_FROM = IFC_FLOW_SEGMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__CONTAINED_IN_STRUCTURE = IFC_FLOW_SEGMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__HAS_PORTS = IFC_FLOW_SEGMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__HAS_CONTROL_ELEMENTS = IFC_FLOW_SEGMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT__PREDEFINED_TYPE = IFC_FLOW_SEGMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Carrier Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_FEATURE_COUNT = IFC_FLOW_SEGMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowSegmentTypeImpl <em>Ifc Flow Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowSegmentTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowSegmentType()
	 * @generated
	 */
	int IFC_FLOW_SEGMENT_TYPE = 285;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__TYPES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCableCarrierSegmentTypeImpl <em>Ifc Cable Carrier Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCableCarrierSegmentTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCableCarrierSegmentType()
	 * @generated
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE = 71;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__GLOBAL_ID = IFC_FLOW_SEGMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__OWNER_HISTORY = IFC_FLOW_SEGMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__NAME = IFC_FLOW_SEGMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__DESCRIPTION = IFC_FLOW_SEGMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__NESTS = IFC_FLOW_SEGMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__IS_NESTED_BY = IFC_FLOW_SEGMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__HAS_CONTEXT = IFC_FLOW_SEGMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_SEGMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__DECOMPOSES = IFC_FLOW_SEGMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_SEGMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_SEGMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__TYPES = IFC_FLOW_SEGMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__REPRESENTATION_MAPS = IFC_FLOW_SEGMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__TAG = IFC_FLOW_SEGMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__REFERENCED_BY = IFC_FLOW_SEGMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__ELEMENT_TYPE = IFC_FLOW_SEGMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE__PREDEFINED_TYPE = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Carrier Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_CARRIER_SEGMENT_TYPE_FEATURE_COUNT = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCableFittingImpl <em>Ifc Cable Fitting</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCableFittingImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCableFitting()
	 * @generated
	 */
	int IFC_CABLE_FITTING = 72;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__GLOBAL_ID = IFC_FLOW_FITTING__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__OWNER_HISTORY = IFC_FLOW_FITTING__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__NAME = IFC_FLOW_FITTING__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__DESCRIPTION = IFC_FLOW_FITTING__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__HAS_ASSIGNMENTS = IFC_FLOW_FITTING__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__NESTS = IFC_FLOW_FITTING__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__IS_NESTED_BY = IFC_FLOW_FITTING__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__HAS_CONTEXT = IFC_FLOW_FITTING__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__IS_DECOMPOSED_BY = IFC_FLOW_FITTING__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__DECOMPOSES = IFC_FLOW_FITTING__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__HAS_ASSOCIATIONS = IFC_FLOW_FITTING__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__OBJECT_TYPE = IFC_FLOW_FITTING__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__IS_DECLARED_BY = IFC_FLOW_FITTING__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__DECLARES = IFC_FLOW_FITTING__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__IS_TYPED_BY = IFC_FLOW_FITTING__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__IS_DEFINED_BY = IFC_FLOW_FITTING__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__OBJECT_PLACEMENT = IFC_FLOW_FITTING__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__REPRESENTATION = IFC_FLOW_FITTING__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__REFERENCED_BY = IFC_FLOW_FITTING__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__GEOMETRY = IFC_FLOW_FITTING__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__TAG = IFC_FLOW_FITTING__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__FILLS_VOIDS = IFC_FLOW_FITTING__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__CONNECTED_TO = IFC_FLOW_FITTING__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_FITTING__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__INTERFERES_ELEMENTS = IFC_FLOW_FITTING__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__HAS_PROJECTIONS = IFC_FLOW_FITTING__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__REFERENCED_IN_STRUCTURES = IFC_FLOW_FITTING__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__HAS_OPENINGS = IFC_FLOW_FITTING__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__IS_CONNECTION_REALIZATION = IFC_FLOW_FITTING__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__PROVIDES_BOUNDARIES = IFC_FLOW_FITTING__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__CONNECTED_FROM = IFC_FLOW_FITTING__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__CONTAINED_IN_STRUCTURE = IFC_FLOW_FITTING__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__HAS_PORTS = IFC_FLOW_FITTING__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__HAS_CONTROL_ELEMENTS = IFC_FLOW_FITTING__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING__PREDEFINED_TYPE = IFC_FLOW_FITTING_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Fitting</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_FEATURE_COUNT = IFC_FLOW_FITTING_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCableFittingTypeImpl <em>Ifc Cable Fitting Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCableFittingTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCableFittingType()
	 * @generated
	 */
	int IFC_CABLE_FITTING_TYPE = 73;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__GLOBAL_ID = IFC_FLOW_FITTING_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__OWNER_HISTORY = IFC_FLOW_FITTING_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__NAME = IFC_FLOW_FITTING_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__DESCRIPTION = IFC_FLOW_FITTING_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_FITTING_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__NESTS = IFC_FLOW_FITTING_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__IS_NESTED_BY = IFC_FLOW_FITTING_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__HAS_CONTEXT = IFC_FLOW_FITTING_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_FITTING_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__DECOMPOSES = IFC_FLOW_FITTING_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_FITTING_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_FITTING_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_FITTING_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__TYPES = IFC_FLOW_FITTING_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__REPRESENTATION_MAPS = IFC_FLOW_FITTING_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__TAG = IFC_FLOW_FITTING_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__REFERENCED_BY = IFC_FLOW_FITTING_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__ELEMENT_TYPE = IFC_FLOW_FITTING_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE__PREDEFINED_TYPE = IFC_FLOW_FITTING_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Fitting Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_FITTING_TYPE_FEATURE_COUNT = IFC_FLOW_FITTING_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCableSegmentImpl <em>Ifc Cable Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCableSegmentImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCableSegment()
	 * @generated
	 */
	int IFC_CABLE_SEGMENT = 74;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__GLOBAL_ID = IFC_FLOW_SEGMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__OWNER_HISTORY = IFC_FLOW_SEGMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__NAME = IFC_FLOW_SEGMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__DESCRIPTION = IFC_FLOW_SEGMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__HAS_ASSIGNMENTS = IFC_FLOW_SEGMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__NESTS = IFC_FLOW_SEGMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__IS_NESTED_BY = IFC_FLOW_SEGMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__HAS_CONTEXT = IFC_FLOW_SEGMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__IS_DECOMPOSED_BY = IFC_FLOW_SEGMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__DECOMPOSES = IFC_FLOW_SEGMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__HAS_ASSOCIATIONS = IFC_FLOW_SEGMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__OBJECT_TYPE = IFC_FLOW_SEGMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__IS_DECLARED_BY = IFC_FLOW_SEGMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__DECLARES = IFC_FLOW_SEGMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__IS_TYPED_BY = IFC_FLOW_SEGMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__IS_DEFINED_BY = IFC_FLOW_SEGMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__OBJECT_PLACEMENT = IFC_FLOW_SEGMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__REPRESENTATION = IFC_FLOW_SEGMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__REFERENCED_BY = IFC_FLOW_SEGMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__GEOMETRY = IFC_FLOW_SEGMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__TAG = IFC_FLOW_SEGMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__FILLS_VOIDS = IFC_FLOW_SEGMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__CONNECTED_TO = IFC_FLOW_SEGMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_SEGMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__INTERFERES_ELEMENTS = IFC_FLOW_SEGMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__HAS_PROJECTIONS = IFC_FLOW_SEGMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__REFERENCED_IN_STRUCTURES = IFC_FLOW_SEGMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__HAS_OPENINGS = IFC_FLOW_SEGMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__IS_CONNECTION_REALIZATION = IFC_FLOW_SEGMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__PROVIDES_BOUNDARIES = IFC_FLOW_SEGMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__CONNECTED_FROM = IFC_FLOW_SEGMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__CONTAINED_IN_STRUCTURE = IFC_FLOW_SEGMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__HAS_PORTS = IFC_FLOW_SEGMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__HAS_CONTROL_ELEMENTS = IFC_FLOW_SEGMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT__PREDEFINED_TYPE = IFC_FLOW_SEGMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_FEATURE_COUNT = IFC_FLOW_SEGMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCableSegmentTypeImpl <em>Ifc Cable Segment Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCableSegmentTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCableSegmentType()
	 * @generated
	 */
	int IFC_CABLE_SEGMENT_TYPE = 75;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__GLOBAL_ID = IFC_FLOW_SEGMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__OWNER_HISTORY = IFC_FLOW_SEGMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__NAME = IFC_FLOW_SEGMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__DESCRIPTION = IFC_FLOW_SEGMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__NESTS = IFC_FLOW_SEGMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__IS_NESTED_BY = IFC_FLOW_SEGMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__HAS_CONTEXT = IFC_FLOW_SEGMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_SEGMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__DECOMPOSES = IFC_FLOW_SEGMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_SEGMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_SEGMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_SEGMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__TYPES = IFC_FLOW_SEGMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__REPRESENTATION_MAPS = IFC_FLOW_SEGMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__TAG = IFC_FLOW_SEGMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__REFERENCED_BY = IFC_FLOW_SEGMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__ELEMENT_TYPE = IFC_FLOW_SEGMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE__PREDEFINED_TYPE = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cable Segment Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CABLE_SEGMENT_TYPE_FEATURE_COUNT = IFC_FLOW_SEGMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcPointImpl <em>Ifc Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcPointImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcPoint()
	 * @generated
	 */
	int IFC_POINT = 425;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_POINT__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_POINT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_POINT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCartesianPointImpl <em>Ifc Cartesian Point</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCartesianPointImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCartesianPoint()
	 * @generated
	 */
	int IFC_CARTESIAN_POINT = 76;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__LAYER_ASSIGNMENT = IFC_POINT__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__STYLED_BY_ITEM = IFC_POINT__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Coordinates</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__COORDINATES = IFC_POINT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Coordinates As String</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__COORDINATES_AS_STRING = IFC_POINT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT__DIM = IFC_POINT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Point</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_FEATURE_COUNT = IFC_POINT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCartesianPointListImpl <em>Ifc Cartesian Point List</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCartesianPointListImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCartesianPointList()
	 * @generated
	 */
	int IFC_CARTESIAN_POINT_LIST = 77;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_LIST__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_LIST__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Point List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_LIST_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCartesianPointList3DImpl <em>Ifc Cartesian Point List3 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCartesianPointList3DImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCartesianPointList3D()
	 * @generated
	 */
	int IFC_CARTESIAN_POINT_LIST3_D = 78;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_LIST3_D__LAYER_ASSIGNMENT = IFC_CARTESIAN_POINT_LIST__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_LIST3_D__STYLED_BY_ITEM = IFC_CARTESIAN_POINT_LIST__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Coord List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_LIST3_D__COORD_LIST = IFC_CARTESIAN_POINT_LIST_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Point List3 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_POINT_LIST3_D_FEATURE_COUNT = IFC_CARTESIAN_POINT_LIST_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperatorImpl <em>Ifc Cartesian Transformation Operator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperatorImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCartesianTransformationOperator()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR = 79;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS1 = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS2 = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LOCAL_ORIGIN = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE_AS_STRING = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperator2DImpl <em>Ifc Cartesian Transformation Operator2 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperator2DImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCartesianTransformationOperator2D()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D = 80;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__LAYER_ASSIGNMENT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__STYLED_BY_ITEM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__AXIS1 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS1;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__AXIS2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS2;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__LOCAL_ORIGIN = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LOCAL_ORIGIN;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__SCALE = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__SCALE_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE_AS_STRING;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__DIM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__DIM;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator2 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D_FEATURE_COUNT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperator2DnonUniformImpl <em>Ifc Cartesian Transformation Operator2 Dnon Uniform</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperator2DnonUniformImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCartesianTransformationOperator2DnonUniform()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM = 81;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__LAYER_ASSIGNMENT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__STYLED_BY_ITEM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__AXIS1 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__AXIS1;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__AXIS2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__AXIS2;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__LOCAL_ORIGIN = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__LOCAL_ORIGIN;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__SCALE = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__SCALE;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__SCALE_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__SCALE_AS_STRING;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__DIM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D__DIM;

	/**
	 * The feature id for the '<em><b>Scale2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__SCALE2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scale2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM__SCALE2_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator2 Dnon Uniform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_DNON_UNIFORM_FEATURE_COUNT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR2_D_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperator3DImpl <em>Ifc Cartesian Transformation Operator3 D</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperator3DImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCartesianTransformationOperator3D()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D = 82;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__LAYER_ASSIGNMENT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__STYLED_BY_ITEM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS1 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS1;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__AXIS2;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__LOCAL_ORIGIN = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__LOCAL_ORIGIN;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__SCALE = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__SCALE_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__SCALE_AS_STRING;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__DIM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR__DIM;

	/**
	 * The feature id for the '<em><b>Axis3</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS3 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator3 D</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperator3DnonUniformImpl <em>Ifc Cartesian Transformation Operator3 Dnon Uniform</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCartesianTransformationOperator3DnonUniformImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCartesianTransformationOperator3DnonUniform()
	 * @generated
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM = 83;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__LAYER_ASSIGNMENT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__STYLED_BY_ITEM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Axis1</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__AXIS1 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS1;

	/**
	 * The feature id for the '<em><b>Axis2</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__AXIS2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS2;

	/**
	 * The feature id for the '<em><b>Local Origin</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__LOCAL_ORIGIN = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__LOCAL_ORIGIN;

	/**
	 * The feature id for the '<em><b>Scale</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__SCALE;

	/**
	 * The feature id for the '<em><b>Scale As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__SCALE_AS_STRING;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__DIM = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__DIM;

	/**
	 * The feature id for the '<em><b>Axis3</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__AXIS3 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D__AXIS3;

	/**
	 * The feature id for the '<em><b>Scale2</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE2 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Scale2 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE2_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Scale3</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE3 = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Scale3 As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM__SCALE3_AS_STRING = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Cartesian Transformation Operator3 Dnon Uniform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_DNON_UNIFORM_FEATURE_COUNT = IFC_CARTESIAN_TRANSFORMATION_OPERATOR3_D_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCenterLineProfileDefImpl <em>Ifc Center Line Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCenterLineProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCenterLineProfileDef()
	 * @generated
	 */
	int IFC_CENTER_LINE_PROFILE_DEF = 84;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__PROFILE_TYPE = IFC_ARBITRARY_OPEN_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__PROFILE_NAME = IFC_ARBITRARY_OPEN_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_ARBITRARY_OPEN_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__HAS_PROPERTIES = IFC_ARBITRARY_OPEN_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__CURVE = IFC_ARBITRARY_OPEN_PROFILE_DEF__CURVE;

	/**
	 * The feature id for the '<em><b>Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__THICKNESS = IFC_ARBITRARY_OPEN_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF__THICKNESS_AS_STRING = IFC_ARBITRARY_OPEN_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Center Line Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CENTER_LINE_PROFILE_DEF_FEATURE_COUNT = IFC_ARBITRARY_OPEN_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcChillerImpl <em>Ifc Chiller</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcChillerImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcChiller()
	 * @generated
	 */
	int IFC_CHILLER = 85;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__NAME = IFC_ENERGY_CONVERSION_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__NESTS = IFC_ENERGY_CONVERSION_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__OBJECT_TYPE = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__IS_DECLARED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__DECLARES = IFC_ENERGY_CONVERSION_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__IS_TYPED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__IS_DEFINED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__OBJECT_PLACEMENT = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__REPRESENTATION = IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__GEOMETRY = IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__TAG = IFC_ENERGY_CONVERSION_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__FILLS_VOIDS = IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__CONNECTED_TO = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__IS_INTERFERED_BY_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__INTERFERES_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__HAS_PROJECTIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__REFERENCED_IN_STRUCTURES = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__HAS_OPENINGS = IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__IS_CONNECTION_REALIZATION = IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__PROVIDES_BOUNDARIES = IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__CONNECTED_FROM = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__CONTAINED_IN_STRUCTURE = IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__HAS_PORTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__HAS_CONTROL_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Chiller</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcChillerTypeImpl <em>Ifc Chiller Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcChillerTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcChillerType()
	 * @generated
	 */
	int IFC_CHILLER_TYPE = 86;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__NESTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__TYPES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Chiller Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHILLER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcChimneyImpl <em>Ifc Chimney</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcChimneyImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcChimney()
	 * @generated
	 */
	int IFC_CHIMNEY = 87;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__NESTS = IFC_BUILDING_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__IS_NESTED_BY = IFC_BUILDING_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__HAS_CONTEXT = IFC_BUILDING_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__IS_DECLARED_BY = IFC_BUILDING_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__DECLARES = IFC_BUILDING_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__IS_TYPED_BY = IFC_BUILDING_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__IS_INTERFERED_BY_ELEMENTS = IFC_BUILDING_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__INTERFERES_ELEMENTS = IFC_BUILDING_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Chimney</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcChimneyTypeImpl <em>Ifc Chimney Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcChimneyTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcChimneyType()
	 * @generated
	 */
	int IFC_CHIMNEY_TYPE = 88;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__NESTS = IFC_BUILDING_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__IS_NESTED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__HAS_CONTEXT = IFC_BUILDING_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__TYPES = IFC_BUILDING_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__REFERENCED_BY = IFC_BUILDING_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Chimney Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CHIMNEY_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConicImpl <em>Ifc Conic</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConicImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConic()
	 * @generated
	 */
	int IFC_CONIC = 117;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC__LAYER_ASSIGNMENT = IFC_CURVE__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC__STYLED_BY_ITEM = IFC_CURVE__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC__DIM = IFC_CURVE__DIM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC__POSITION = IFC_CURVE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Conic</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONIC_FEATURE_COUNT = IFC_CURVE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCircleImpl <em>Ifc Circle</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCircleImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCircle()
	 * @generated
	 */
	int IFC_CIRCLE = 89;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__LAYER_ASSIGNMENT = IFC_CONIC__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__STYLED_BY_ITEM = IFC_CONIC__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__DIM = IFC_CONIC__DIM;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__POSITION = IFC_CONIC__POSITION;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__RADIUS = IFC_CONIC_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE__RADIUS_AS_STRING = IFC_CONIC_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Circle</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_FEATURE_COUNT = IFC_CONIC_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCircleProfileDefImpl <em>Ifc Circle Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCircleProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCircleProfileDef()
	 * @generated
	 */
	int IFC_CIRCLE_PROFILE_DEF = 91;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__PROFILE_TYPE = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__PROFILE_NAME = IFC_PARAMETERIZED_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_PARAMETERIZED_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__HAS_PROPERTIES = IFC_PARAMETERIZED_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__POSITION = IFC_PARAMETERIZED_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__RADIUS = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF__RADIUS_AS_STRING = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Circle Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_PROFILE_DEF_FEATURE_COUNT = IFC_PARAMETERIZED_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCircleHollowProfileDefImpl <em>Ifc Circle Hollow Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCircleHollowProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCircleHollowProfileDef()
	 * @generated
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF = 90;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__PROFILE_TYPE = IFC_CIRCLE_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__PROFILE_NAME = IFC_CIRCLE_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_CIRCLE_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__HAS_PROPERTIES = IFC_CIRCLE_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Position</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__POSITION = IFC_CIRCLE_PROFILE_DEF__POSITION;

	/**
	 * The feature id for the '<em><b>Radius</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__RADIUS = IFC_CIRCLE_PROFILE_DEF__RADIUS;

	/**
	 * The feature id for the '<em><b>Radius As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__RADIUS_AS_STRING = IFC_CIRCLE_PROFILE_DEF__RADIUS_AS_STRING;

	/**
	 * The feature id for the '<em><b>Wall Thickness</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__WALL_THICKNESS = IFC_CIRCLE_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Wall Thickness As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF__WALL_THICKNESS_AS_STRING = IFC_CIRCLE_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Circle Hollow Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIRCLE_HOLLOW_PROFILE_DEF_FEATURE_COUNT = IFC_CIRCLE_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCivilElementImpl <em>Ifc Civil Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCivilElementImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCivilElement()
	 * @generated
	 */
	int IFC_CIVIL_ELEMENT = 92;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__GLOBAL_ID = IFC_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__OWNER_HISTORY = IFC_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__NAME = IFC_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__DESCRIPTION = IFC_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__HAS_ASSIGNMENTS = IFC_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__NESTS = IFC_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__IS_NESTED_BY = IFC_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__HAS_CONTEXT = IFC_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__IS_DECOMPOSED_BY = IFC_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__DECOMPOSES = IFC_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__HAS_ASSOCIATIONS = IFC_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__OBJECT_TYPE = IFC_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__IS_DECLARED_BY = IFC_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__DECLARES = IFC_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__IS_TYPED_BY = IFC_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__IS_DEFINED_BY = IFC_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__OBJECT_PLACEMENT = IFC_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__REPRESENTATION = IFC_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__REFERENCED_BY = IFC_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__GEOMETRY = IFC_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__TAG = IFC_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__FILLS_VOIDS = IFC_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__CONNECTED_TO = IFC_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__IS_INTERFERED_BY_ELEMENTS = IFC_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__INTERFERES_ELEMENTS = IFC_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__HAS_PROJECTIONS = IFC_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__REFERENCED_IN_STRUCTURES = IFC_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__HAS_OPENINGS = IFC_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__IS_CONNECTION_REALIZATION = IFC_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__PROVIDES_BOUNDARIES = IFC_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__CONNECTED_FROM = IFC_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT__CONTAINED_IN_STRUCTURE = IFC_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The number of structural features of the '<em>Ifc Civil Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_FEATURE_COUNT = IFC_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCivilElementTypeImpl <em>Ifc Civil Element Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCivilElementTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCivilElementType()
	 * @generated
	 */
	int IFC_CIVIL_ELEMENT_TYPE = 93;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__GLOBAL_ID = IFC_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__OWNER_HISTORY = IFC_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__NAME = IFC_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__DESCRIPTION = IFC_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__HAS_ASSIGNMENTS = IFC_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__NESTS = IFC_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__IS_NESTED_BY = IFC_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__HAS_CONTEXT = IFC_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__IS_DECOMPOSED_BY = IFC_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__DECOMPOSES = IFC_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__HAS_ASSOCIATIONS = IFC_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE = IFC_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__HAS_PROPERTY_SETS = IFC_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__TYPES = IFC_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__REPRESENTATION_MAPS = IFC_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__TAG = IFC_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__REFERENCED_BY = IFC_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE__ELEMENT_TYPE = IFC_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Civil Element Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CIVIL_ELEMENT_TYPE_FEATURE_COUNT = IFC_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcExternalInformationImpl <em>Ifc External Information</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcExternalInformationImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcExternalInformation()
	 * @generated
	 */
	int IFC_EXTERNAL_INFORMATION = 241;

	/**
	 * The number of structural features of the '<em>Ifc External Information</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_INFORMATION_FEATURE_COUNT = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcClassificationImpl <em>Ifc Classification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcClassificationImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcClassification()
	 * @generated
	 */
	int IFC_CLASSIFICATION = 94;

	/**
	 * The feature id for the '<em><b>Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__SOURCE = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Edition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__EDITION = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Edition Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__EDITION_DATE = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__NAME = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__DESCRIPTION = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__LOCATION = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Reference Tokens</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__REFERENCE_TOKENS = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Classification For Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__CLASSIFICATION_FOR_OBJECTS = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Has References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION__HAS_REFERENCES = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Ifc Classification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_FEATURE_COUNT = IFC_EXTERNAL_INFORMATION_FEATURE_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.IfcLightDistributionDataSourceSelect <em>Ifc Light Distribution Data Source Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.IfcLightDistributionDataSourceSelect
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcLightDistributionDataSourceSelect()
	 * @generated
	 */
	int IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT = 916;

	/**
	 * The number of structural features of the '<em>Ifc Light Distribution Data Source Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcExternalReferenceImpl <em>Ifc External Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcExternalReferenceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcExternalReference()
	 * @generated
	 */
	int IFC_EXTERNAL_REFERENCE = 242;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE__LOCATION = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE__IDENTIFICATION = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE__NAME = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>External Reference For Resources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE__EXTERNAL_REFERENCE_FOR_RESOURCES = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc External Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_EXTERNAL_REFERENCE_FEATURE_COUNT = IFC_LIGHT_DISTRIBUTION_DATA_SOURCE_SELECT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcClassificationReferenceImpl <em>Ifc Classification Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcClassificationReferenceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcClassificationReference()
	 * @generated
	 */
	int IFC_CLASSIFICATION_REFERENCE = 95;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__LOCATION = IFC_EXTERNAL_REFERENCE__LOCATION;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__IDENTIFICATION = IFC_EXTERNAL_REFERENCE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__NAME = IFC_EXTERNAL_REFERENCE__NAME;

	/**
	 * The feature id for the '<em><b>External Reference For Resources</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__EXTERNAL_REFERENCE_FOR_RESOURCES = IFC_EXTERNAL_REFERENCE__EXTERNAL_REFERENCE_FOR_RESOURCES;

	/**
	 * The feature id for the '<em><b>Referenced Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__REFERENCED_SOURCE = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__DESCRIPTION = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Sort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__SORT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Classification Ref For Objects</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__CLASSIFICATION_REF_FOR_OBJECTS = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Has References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE__HAS_REFERENCES = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Classification Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLASSIFICATION_REFERENCE_FEATURE_COUNT = IFC_EXTERNAL_REFERENCE_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConnectedFaceSetImpl <em>Ifc Connected Face Set</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConnectedFaceSetImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConnectedFaceSet()
	 * @generated
	 */
	int IFC_CONNECTED_FACE_SET = 118;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTED_FACE_SET__LAYER_ASSIGNMENT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTED_FACE_SET__STYLED_BY_ITEM = IFC_TOPOLOGICAL_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Cfs Faces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTED_FACE_SET__CFS_FACES = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Connected Face Set</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTED_FACE_SET_FEATURE_COUNT = IFC_TOPOLOGICAL_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcClosedShellImpl <em>Ifc Closed Shell</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcClosedShellImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcClosedShell()
	 * @generated
	 */
	int IFC_CLOSED_SHELL = 96;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLOSED_SHELL__LAYER_ASSIGNMENT = IFC_CONNECTED_FACE_SET__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLOSED_SHELL__STYLED_BY_ITEM = IFC_CONNECTED_FACE_SET__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Cfs Faces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLOSED_SHELL__CFS_FACES = IFC_CONNECTED_FACE_SET__CFS_FACES;

	/**
	 * The number of structural features of the '<em>Ifc Closed Shell</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CLOSED_SHELL_FEATURE_COUNT = IFC_CONNECTED_FACE_SET_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCoilImpl <em>Ifc Coil</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCoilImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCoil()
	 * @generated
	 */
	int IFC_COIL = 97;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__NAME = IFC_ENERGY_CONVERSION_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__NESTS = IFC_ENERGY_CONVERSION_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__OBJECT_TYPE = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__IS_DECLARED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__DECLARES = IFC_ENERGY_CONVERSION_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__IS_TYPED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__IS_DEFINED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__OBJECT_PLACEMENT = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__REPRESENTATION = IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__GEOMETRY = IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__TAG = IFC_ENERGY_CONVERSION_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__FILLS_VOIDS = IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__CONNECTED_TO = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__IS_INTERFERED_BY_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__INTERFERES_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__HAS_PROJECTIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__REFERENCED_IN_STRUCTURES = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__HAS_OPENINGS = IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__IS_CONNECTION_REALIZATION = IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__PROVIDES_BOUNDARIES = IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__CONNECTED_FROM = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__CONTAINED_IN_STRUCTURE = IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__HAS_PORTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__HAS_CONTROL_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Coil</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCoilTypeImpl <em>Ifc Coil Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCoilTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCoilType()
	 * @generated
	 */
	int IFC_COIL_TYPE = 98;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__NESTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__TYPES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Coil Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COIL_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcColourSpecificationImpl <em>Ifc Colour Specification</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcColourSpecificationImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcColourSpecification()
	 * @generated
	 */
	int IFC_COLOUR_SPECIFICATION = 101;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_SPECIFICATION__NAME = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Colour Specification</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_SPECIFICATION_FEATURE_COUNT = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcColourRgbImpl <em>Ifc Colour Rgb</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcColourRgbImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcColourRgb()
	 * @generated
	 */
	int IFC_COLOUR_RGB = 99;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__NAME = IFC_COLOUR_SPECIFICATION__NAME;

	/**
	 * The feature id for the '<em><b>Red</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__RED = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Red As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__RED_AS_STRING = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Green</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__GREEN = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Green As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__GREEN_AS_STRING = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Blue</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__BLUE = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Blue As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB__BLUE_AS_STRING = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Colour Rgb</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB_FEATURE_COUNT = IFC_COLOUR_SPECIFICATION_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcColourRgbListImpl <em>Ifc Colour Rgb List</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcColourRgbListImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcColourRgbList()
	 * @generated
	 */
	int IFC_COLOUR_RGB_LIST = 100;

	/**
	 * The feature id for the '<em><b>Colour List</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB_LIST__COLOUR_LIST = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Colour Rgb List</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLOUR_RGB_LIST_FEATURE_COUNT = IFC_PRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcColumnImpl <em>Ifc Column</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcColumnImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcColumn()
	 * @generated
	 */
	int IFC_COLUMN = 102;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__NESTS = IFC_BUILDING_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_NESTED_BY = IFC_BUILDING_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_CONTEXT = IFC_BUILDING_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_DECLARED_BY = IFC_BUILDING_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__DECLARES = IFC_BUILDING_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_TYPED_BY = IFC_BUILDING_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_INTERFERED_BY_ELEMENTS = IFC_BUILDING_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__INTERFERES_ELEMENTS = IFC_BUILDING_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Column</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcColumnStandardCaseImpl <em>Ifc Column Standard Case</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcColumnStandardCaseImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcColumnStandardCase()
	 * @generated
	 */
	int IFC_COLUMN_STANDARD_CASE = 103;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__GLOBAL_ID = IFC_COLUMN__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__OWNER_HISTORY = IFC_COLUMN__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__NAME = IFC_COLUMN__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__DESCRIPTION = IFC_COLUMN__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__HAS_ASSIGNMENTS = IFC_COLUMN__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__NESTS = IFC_COLUMN__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__IS_NESTED_BY = IFC_COLUMN__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__HAS_CONTEXT = IFC_COLUMN__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__IS_DECOMPOSED_BY = IFC_COLUMN__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__DECOMPOSES = IFC_COLUMN__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__HAS_ASSOCIATIONS = IFC_COLUMN__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__OBJECT_TYPE = IFC_COLUMN__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__IS_DECLARED_BY = IFC_COLUMN__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__DECLARES = IFC_COLUMN__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__IS_TYPED_BY = IFC_COLUMN__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__IS_DEFINED_BY = IFC_COLUMN__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__OBJECT_PLACEMENT = IFC_COLUMN__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__REPRESENTATION = IFC_COLUMN__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__REFERENCED_BY = IFC_COLUMN__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__GEOMETRY = IFC_COLUMN__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__TAG = IFC_COLUMN__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__FILLS_VOIDS = IFC_COLUMN__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__CONNECTED_TO = IFC_COLUMN__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__IS_INTERFERED_BY_ELEMENTS = IFC_COLUMN__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__INTERFERES_ELEMENTS = IFC_COLUMN__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__HAS_PROJECTIONS = IFC_COLUMN__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__REFERENCED_IN_STRUCTURES = IFC_COLUMN__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__HAS_OPENINGS = IFC_COLUMN__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__IS_CONNECTION_REALIZATION = IFC_COLUMN__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__PROVIDES_BOUNDARIES = IFC_COLUMN__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__CONNECTED_FROM = IFC_COLUMN__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__CONTAINED_IN_STRUCTURE = IFC_COLUMN__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__HAS_COVERINGS = IFC_COLUMN__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE__PREDEFINED_TYPE = IFC_COLUMN__PREDEFINED_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Column Standard Case</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_STANDARD_CASE_FEATURE_COUNT = IFC_COLUMN_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcColumnTypeImpl <em>Ifc Column Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcColumnTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcColumnType()
	 * @generated
	 */
	int IFC_COLUMN_TYPE = 104;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__NESTS = IFC_BUILDING_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__IS_NESTED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__HAS_CONTEXT = IFC_BUILDING_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__TYPES = IFC_BUILDING_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__REFERENCED_BY = IFC_BUILDING_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Column Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COLUMN_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCommunicationsApplianceImpl <em>Ifc Communications Appliance</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCommunicationsApplianceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCommunicationsAppliance()
	 * @generated
	 */
	int IFC_COMMUNICATIONS_APPLIANCE = 105;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__GLOBAL_ID = IFC_FLOW_TERMINAL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__OWNER_HISTORY = IFC_FLOW_TERMINAL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__NAME = IFC_FLOW_TERMINAL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__DESCRIPTION = IFC_FLOW_TERMINAL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__NESTS = IFC_FLOW_TERMINAL__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__IS_NESTED_BY = IFC_FLOW_TERMINAL__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__HAS_CONTEXT = IFC_FLOW_TERMINAL__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__DECOMPOSES = IFC_FLOW_TERMINAL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__OBJECT_TYPE = IFC_FLOW_TERMINAL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__IS_DECLARED_BY = IFC_FLOW_TERMINAL__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__DECLARES = IFC_FLOW_TERMINAL__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__IS_TYPED_BY = IFC_FLOW_TERMINAL__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__IS_DEFINED_BY = IFC_FLOW_TERMINAL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__OBJECT_PLACEMENT = IFC_FLOW_TERMINAL__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__REPRESENTATION = IFC_FLOW_TERMINAL__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__REFERENCED_BY = IFC_FLOW_TERMINAL__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__GEOMETRY = IFC_FLOW_TERMINAL__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__TAG = IFC_FLOW_TERMINAL__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__FILLS_VOIDS = IFC_FLOW_TERMINAL__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__CONNECTED_TO = IFC_FLOW_TERMINAL__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_TERMINAL__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__INTERFERES_ELEMENTS = IFC_FLOW_TERMINAL__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__HAS_PROJECTIONS = IFC_FLOW_TERMINAL__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__REFERENCED_IN_STRUCTURES = IFC_FLOW_TERMINAL__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__HAS_OPENINGS = IFC_FLOW_TERMINAL__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__IS_CONNECTION_REALIZATION = IFC_FLOW_TERMINAL__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__PROVIDES_BOUNDARIES = IFC_FLOW_TERMINAL__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__CONNECTED_FROM = IFC_FLOW_TERMINAL__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__CONTAINED_IN_STRUCTURE = IFC_FLOW_TERMINAL__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__HAS_PORTS = IFC_FLOW_TERMINAL__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__HAS_CONTROL_ELEMENTS = IFC_FLOW_TERMINAL__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Communications Appliance</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_FEATURE_COUNT = IFC_FLOW_TERMINAL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCommunicationsApplianceTypeImpl <em>Ifc Communications Appliance Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCommunicationsApplianceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCommunicationsApplianceType()
	 * @generated
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE = 106;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__GLOBAL_ID = IFC_FLOW_TERMINAL_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__OWNER_HISTORY = IFC_FLOW_TERMINAL_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__NAME = IFC_FLOW_TERMINAL_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__DESCRIPTION = IFC_FLOW_TERMINAL_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__NESTS = IFC_FLOW_TERMINAL_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__IS_NESTED_BY = IFC_FLOW_TERMINAL_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__HAS_CONTEXT = IFC_FLOW_TERMINAL_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_TERMINAL_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__DECOMPOSES = IFC_FLOW_TERMINAL_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_TERMINAL_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_TERMINAL_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_TERMINAL_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__TYPES = IFC_FLOW_TERMINAL_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__REPRESENTATION_MAPS = IFC_FLOW_TERMINAL_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__TAG = IFC_FLOW_TERMINAL_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__REFERENCED_BY = IFC_FLOW_TERMINAL_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__ELEMENT_TYPE = IFC_FLOW_TERMINAL_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE__PREDEFINED_TYPE = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Communications Appliance Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMMUNICATIONS_APPLIANCE_TYPE_FEATURE_COUNT = IFC_FLOW_TERMINAL_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcPropertyAbstractionImpl <em>Ifc Property Abstraction</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcPropertyAbstractionImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcPropertyAbstraction()
	 * @generated
	 */
	int IFC_PROPERTY_ABSTRACTION = 458;

	/**
	 * The feature id for the '<em><b>Has External References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_ABSTRACTION__HAS_EXTERNAL_REFERENCES = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Property Abstraction</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_ABSTRACTION_FEATURE_COUNT = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcPropertyImpl <em>Ifc Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcPropertyImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcProperty()
	 * @generated
	 */
	int IFC_PROPERTY = 457;

	/**
	 * The feature id for the '<em><b>Has External References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__HAS_EXTERNAL_REFERENCES = IFC_PROPERTY_ABSTRACTION__HAS_EXTERNAL_REFERENCES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__NAME = IFC_PROPERTY_ABSTRACTION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__DESCRIPTION = IFC_PROPERTY_ABSTRACTION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Part Of Pset</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__PART_OF_PSET = IFC_PROPERTY_ABSTRACTION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Property For Dependance</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__PROPERTY_FOR_DEPENDANCE = IFC_PROPERTY_ABSTRACTION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Property Depends On</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__PROPERTY_DEPENDS_ON = IFC_PROPERTY_ABSTRACTION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Part Of Complex</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY__PART_OF_COMPLEX = IFC_PROPERTY_ABSTRACTION_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_FEATURE_COUNT = IFC_PROPERTY_ABSTRACTION_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcComplexPropertyImpl <em>Ifc Complex Property</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcComplexPropertyImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcComplexProperty()
	 * @generated
	 */
	int IFC_COMPLEX_PROPERTY = 107;

	/**
	 * The feature id for the '<em><b>Has External References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__HAS_EXTERNAL_REFERENCES = IFC_PROPERTY__HAS_EXTERNAL_REFERENCES;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__NAME = IFC_PROPERTY__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__DESCRIPTION = IFC_PROPERTY__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Part Of Pset</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__PART_OF_PSET = IFC_PROPERTY__PART_OF_PSET;

	/**
	 * The feature id for the '<em><b>Property For Dependance</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__PROPERTY_FOR_DEPENDANCE = IFC_PROPERTY__PROPERTY_FOR_DEPENDANCE;

	/**
	 * The feature id for the '<em><b>Property Depends On</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__PROPERTY_DEPENDS_ON = IFC_PROPERTY__PROPERTY_DEPENDS_ON;

	/**
	 * The feature id for the '<em><b>Part Of Complex</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__PART_OF_COMPLEX = IFC_PROPERTY__PART_OF_COMPLEX;

	/**
	 * The feature id for the '<em><b>Usage Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__USAGE_NAME = IFC_PROPERTY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY__HAS_PROPERTIES = IFC_PROPERTY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Complex Property</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_FEATURE_COUNT = IFC_PROPERTY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcPropertyDefinitionImpl <em>Ifc Property Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcPropertyDefinitionImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcPropertyDefinition()
	 * @generated
	 */
	int IFC_PROPERTY_DEFINITION = 460;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__GLOBAL_ID = IFC_ROOT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__OWNER_HISTORY = IFC_ROOT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__NAME = IFC_ROOT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__DESCRIPTION = IFC_ROOT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__HAS_CONTEXT = IFC_ROOT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION__HAS_ASSOCIATIONS = IFC_ROOT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Property Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_DEFINITION_FEATURE_COUNT = IFC_ROOT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcPropertyTemplateDefinitionImpl <em>Ifc Property Template Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcPropertyTemplateDefinitionImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcPropertyTemplateDefinition()
	 * @generated
	 */
	int IFC_PROPERTY_TEMPLATE_DEFINITION = 472;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE_DEFINITION__GLOBAL_ID = IFC_PROPERTY_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE_DEFINITION__OWNER_HISTORY = IFC_PROPERTY_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE_DEFINITION__NAME = IFC_PROPERTY_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE_DEFINITION__DESCRIPTION = IFC_PROPERTY_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE_DEFINITION__HAS_CONTEXT = IFC_PROPERTY_DEFINITION__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE_DEFINITION__HAS_ASSOCIATIONS = IFC_PROPERTY_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The number of structural features of the '<em>Ifc Property Template Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE_DEFINITION_FEATURE_COUNT = IFC_PROPERTY_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcPropertyTemplateImpl <em>Ifc Property Template</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcPropertyTemplateImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcPropertyTemplate()
	 * @generated
	 */
	int IFC_PROPERTY_TEMPLATE = 471;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE__GLOBAL_ID = IFC_PROPERTY_TEMPLATE_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE__OWNER_HISTORY = IFC_PROPERTY_TEMPLATE_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE__NAME = IFC_PROPERTY_TEMPLATE_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE__DESCRIPTION = IFC_PROPERTY_TEMPLATE_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE__HAS_CONTEXT = IFC_PROPERTY_TEMPLATE_DEFINITION__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE__HAS_ASSOCIATIONS = IFC_PROPERTY_TEMPLATE_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Part Of Complex Template</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE__PART_OF_COMPLEX_TEMPLATE = IFC_PROPERTY_TEMPLATE_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Part Of Pset Template</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE__PART_OF_PSET_TEMPLATE = IFC_PROPERTY_TEMPLATE_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Property Template</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_PROPERTY_TEMPLATE_FEATURE_COUNT = IFC_PROPERTY_TEMPLATE_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcComplexPropertyTemplateImpl <em>Ifc Complex Property Template</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcComplexPropertyTemplateImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcComplexPropertyTemplate()
	 * @generated
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE = 108;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__GLOBAL_ID = IFC_PROPERTY_TEMPLATE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__OWNER_HISTORY = IFC_PROPERTY_TEMPLATE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__NAME = IFC_PROPERTY_TEMPLATE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__DESCRIPTION = IFC_PROPERTY_TEMPLATE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__HAS_CONTEXT = IFC_PROPERTY_TEMPLATE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__HAS_ASSOCIATIONS = IFC_PROPERTY_TEMPLATE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Part Of Complex Template</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__PART_OF_COMPLEX_TEMPLATE = IFC_PROPERTY_TEMPLATE__PART_OF_COMPLEX_TEMPLATE;

	/**
	 * The feature id for the '<em><b>Part Of Pset Template</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__PART_OF_PSET_TEMPLATE = IFC_PROPERTY_TEMPLATE__PART_OF_PSET_TEMPLATE;

	/**
	 * The feature id for the '<em><b>Usage Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__USAGE_NAME = IFC_PROPERTY_TEMPLATE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Template Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__TEMPLATE_TYPE = IFC_PROPERTY_TEMPLATE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Has Property Templates</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE__HAS_PROPERTY_TEMPLATES = IFC_PROPERTY_TEMPLATE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Complex Property Template</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPLEX_PROPERTY_TEMPLATE_FEATURE_COUNT = IFC_PROPERTY_TEMPLATE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCompositeCurveSegmentImpl <em>Ifc Composite Curve Segment</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCompositeCurveSegmentImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCompositeCurveSegment()
	 * @generated
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT = 111;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__LAYER_ASSIGNMENT = IFC_GEOMETRIC_REPRESENTATION_ITEM__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__STYLED_BY_ITEM = IFC_GEOMETRIC_REPRESENTATION_ITEM__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Transition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__TRANSITION = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Same Sense</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__SAME_SENSE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Parent Curve</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__PARENT_CURVE = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Using Curves</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__USING_CURVES = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT__DIM = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Ifc Composite Curve Segment</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_CURVE_SEGMENT_FEATURE_COUNT = IFC_GEOMETRIC_REPRESENTATION_ITEM_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCompositeProfileDefImpl <em>Ifc Composite Profile Def</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCompositeProfileDefImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCompositeProfileDef()
	 * @generated
	 */
	int IFC_COMPOSITE_PROFILE_DEF = 112;

	/**
	 * The feature id for the '<em><b>Profile Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__PROFILE_TYPE = IFC_PROFILE_DEF__PROFILE_TYPE;

	/**
	 * The feature id for the '<em><b>Profile Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__PROFILE_NAME = IFC_PROFILE_DEF__PROFILE_NAME;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__HAS_EXTERNAL_REFERENCE = IFC_PROFILE_DEF__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Has Properties</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__HAS_PROPERTIES = IFC_PROFILE_DEF__HAS_PROPERTIES;

	/**
	 * The feature id for the '<em><b>Profiles</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__PROFILES = IFC_PROFILE_DEF_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Label</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF__LABEL = IFC_PROFILE_DEF_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Composite Profile Def</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPOSITE_PROFILE_DEF_FEATURE_COUNT = IFC_PROFILE_DEF_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowMovingDeviceImpl <em>Ifc Flow Moving Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowMovingDeviceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowMovingDevice()
	 * @generated
	 */
	int IFC_FLOW_MOVING_DEVICE = 282;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__OBJECT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_DECLARED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__DECLARES = IFC_DISTRIBUTION_FLOW_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_TYPED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_DEFINED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__OBJECT_PLACEMENT = IFC_DISTRIBUTION_FLOW_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__REPRESENTATION = IFC_DISTRIBUTION_FLOW_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__GEOMETRY = IFC_DISTRIBUTION_FLOW_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__FILLS_VOIDS = IFC_DISTRIBUTION_FLOW_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__CONNECTED_TO = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_PROJECTIONS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_FLOW_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_OPENINGS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_FLOW_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_FLOW_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__CONNECTED_FROM = IFC_DISTRIBUTION_FLOW_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_FLOW_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_PORTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE__HAS_CONTROL_ELEMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT__HAS_CONTROL_ELEMENTS;

	/**
	 * The number of structural features of the '<em>Ifc Flow Moving Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCompressorImpl <em>Ifc Compressor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCompressorImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCompressor()
	 * @generated
	 */
	int IFC_COMPRESSOR = 113;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__GLOBAL_ID = IFC_FLOW_MOVING_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__OWNER_HISTORY = IFC_FLOW_MOVING_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__NAME = IFC_FLOW_MOVING_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__DESCRIPTION = IFC_FLOW_MOVING_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__HAS_ASSIGNMENTS = IFC_FLOW_MOVING_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__NESTS = IFC_FLOW_MOVING_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__IS_NESTED_BY = IFC_FLOW_MOVING_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__HAS_CONTEXT = IFC_FLOW_MOVING_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__IS_DECOMPOSED_BY = IFC_FLOW_MOVING_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__DECOMPOSES = IFC_FLOW_MOVING_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__HAS_ASSOCIATIONS = IFC_FLOW_MOVING_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__OBJECT_TYPE = IFC_FLOW_MOVING_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__IS_DECLARED_BY = IFC_FLOW_MOVING_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__DECLARES = IFC_FLOW_MOVING_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__IS_TYPED_BY = IFC_FLOW_MOVING_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__IS_DEFINED_BY = IFC_FLOW_MOVING_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__OBJECT_PLACEMENT = IFC_FLOW_MOVING_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__REPRESENTATION = IFC_FLOW_MOVING_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__REFERENCED_BY = IFC_FLOW_MOVING_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__GEOMETRY = IFC_FLOW_MOVING_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__TAG = IFC_FLOW_MOVING_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__FILLS_VOIDS = IFC_FLOW_MOVING_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__CONNECTED_TO = IFC_FLOW_MOVING_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__IS_INTERFERED_BY_ELEMENTS = IFC_FLOW_MOVING_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__INTERFERES_ELEMENTS = IFC_FLOW_MOVING_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__HAS_PROJECTIONS = IFC_FLOW_MOVING_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__REFERENCED_IN_STRUCTURES = IFC_FLOW_MOVING_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__HAS_OPENINGS = IFC_FLOW_MOVING_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__IS_CONNECTION_REALIZATION = IFC_FLOW_MOVING_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__PROVIDES_BOUNDARIES = IFC_FLOW_MOVING_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__CONNECTED_FROM = IFC_FLOW_MOVING_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__CONTAINED_IN_STRUCTURE = IFC_FLOW_MOVING_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__HAS_PORTS = IFC_FLOW_MOVING_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__HAS_CONTROL_ELEMENTS = IFC_FLOW_MOVING_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR__PREDEFINED_TYPE = IFC_FLOW_MOVING_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Compressor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_FEATURE_COUNT = IFC_FLOW_MOVING_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcFlowMovingDeviceTypeImpl <em>Ifc Flow Moving Device Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcFlowMovingDeviceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcFlowMovingDeviceType()
	 * @generated
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE = 283;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__NAME = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__DESCRIPTION = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__NESTS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__DECOMPOSES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__TYPES = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__TAG = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The number of structural features of the '<em>Ifc Flow Moving Device Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_FLOW_MOVING_DEVICE_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_FLOW_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCompressorTypeImpl <em>Ifc Compressor Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCompressorTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCompressorType()
	 * @generated
	 */
	int IFC_COMPRESSOR_TYPE = 114;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__GLOBAL_ID = IFC_FLOW_MOVING_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__OWNER_HISTORY = IFC_FLOW_MOVING_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__NAME = IFC_FLOW_MOVING_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__DESCRIPTION = IFC_FLOW_MOVING_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__HAS_ASSIGNMENTS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__NESTS = IFC_FLOW_MOVING_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__IS_NESTED_BY = IFC_FLOW_MOVING_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__HAS_CONTEXT = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__IS_DECOMPOSED_BY = IFC_FLOW_MOVING_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__DECOMPOSES = IFC_FLOW_MOVING_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__HAS_ASSOCIATIONS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__APPLICABLE_OCCURRENCE = IFC_FLOW_MOVING_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__HAS_PROPERTY_SETS = IFC_FLOW_MOVING_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__TYPES = IFC_FLOW_MOVING_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__REPRESENTATION_MAPS = IFC_FLOW_MOVING_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__TAG = IFC_FLOW_MOVING_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__REFERENCED_BY = IFC_FLOW_MOVING_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__ELEMENT_TYPE = IFC_FLOW_MOVING_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE__PREDEFINED_TYPE = IFC_FLOW_MOVING_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Compressor Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COMPRESSOR_TYPE_FEATURE_COUNT = IFC_FLOW_MOVING_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCondenserImpl <em>Ifc Condenser</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCondenserImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCondenser()
	 * @generated
	 */
	int IFC_CONDENSER = 115;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__NAME = IFC_ENERGY_CONVERSION_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__NESTS = IFC_ENERGY_CONVERSION_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__OBJECT_TYPE = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__IS_DECLARED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__DECLARES = IFC_ENERGY_CONVERSION_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__IS_TYPED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__IS_DEFINED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__OBJECT_PLACEMENT = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__REPRESENTATION = IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__GEOMETRY = IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__TAG = IFC_ENERGY_CONVERSION_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__FILLS_VOIDS = IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__CONNECTED_TO = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__IS_INTERFERED_BY_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__INTERFERES_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__HAS_PROJECTIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__REFERENCED_IN_STRUCTURES = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__HAS_OPENINGS = IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__IS_CONNECTION_REALIZATION = IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__PROVIDES_BOUNDARIES = IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__CONNECTED_FROM = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__CONTAINED_IN_STRUCTURE = IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__HAS_PORTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__HAS_CONTROL_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Condenser</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCondenserTypeImpl <em>Ifc Condenser Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCondenserTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCondenserType()
	 * @generated
	 */
	int IFC_CONDENSER_TYPE = 116;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__NESTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__TYPES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Condenser Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONDENSER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConnectionGeometryImpl <em>Ifc Connection Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConnectionGeometryImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConnectionGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_GEOMETRY = 120;

	/**
	 * The number of structural features of the '<em>Ifc Connection Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_GEOMETRY_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConnectionCurveGeometryImpl <em>Ifc Connection Curve Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConnectionCurveGeometryImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConnectionCurveGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_CURVE_GEOMETRY = 119;

	/**
	 * The feature id for the '<em><b>Curve On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_CURVE_GEOMETRY__CURVE_ON_RELATING_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Curve On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_CURVE_GEOMETRY__CURVE_ON_RELATED_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Connection Curve Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_CURVE_GEOMETRY_FEATURE_COUNT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConnectionPointGeometryImpl <em>Ifc Connection Point Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConnectionPointGeometryImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConnectionPointGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_POINT_GEOMETRY = 122;

	/**
	 * The feature id for the '<em><b>Point On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_GEOMETRY__POINT_ON_RELATING_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Point On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_GEOMETRY__POINT_ON_RELATED_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Connection Point Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConnectionPointEccentricityImpl <em>Ifc Connection Point Eccentricity</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConnectionPointEccentricityImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConnectionPointEccentricity()
	 * @generated
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY = 121;

	/**
	 * The feature id for the '<em><b>Point On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__POINT_ON_RELATING_ELEMENT = IFC_CONNECTION_POINT_GEOMETRY__POINT_ON_RELATING_ELEMENT;

	/**
	 * The feature id for the '<em><b>Point On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__POINT_ON_RELATED_ELEMENT = IFC_CONNECTION_POINT_GEOMETRY__POINT_ON_RELATED_ELEMENT;

	/**
	 * The feature id for the '<em><b>Eccentricity In X</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_X = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Eccentricity In XAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_XAS_STRING = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Eccentricity In Y</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_Y = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Eccentricity In YAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_YAS_STRING = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Eccentricity In Z</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_Z = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Eccentricity In ZAs String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY__ECCENTRICITY_IN_ZAS_STRING = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Connection Point Eccentricity</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_POINT_ECCENTRICITY_FEATURE_COUNT = IFC_CONNECTION_POINT_GEOMETRY_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConnectionSurfaceGeometryImpl <em>Ifc Connection Surface Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConnectionSurfaceGeometryImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConnectionSurfaceGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_SURFACE_GEOMETRY = 123;

	/**
	 * The feature id for the '<em><b>Surface On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_SURFACE_GEOMETRY__SURFACE_ON_RELATING_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Surface On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_SURFACE_GEOMETRY__SURFACE_ON_RELATED_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Connection Surface Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_SURFACE_GEOMETRY_FEATURE_COUNT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConnectionVolumeGeometryImpl <em>Ifc Connection Volume Geometry</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConnectionVolumeGeometryImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConnectionVolumeGeometry()
	 * @generated
	 */
	int IFC_CONNECTION_VOLUME_GEOMETRY = 124;

	/**
	 * The feature id for the '<em><b>Volume On Relating Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_VOLUME_GEOMETRY__VOLUME_ON_RELATING_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Volume On Related Element</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_VOLUME_GEOMETRY__VOLUME_ON_RELATED_ELEMENT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Connection Volume Geometry</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONNECTION_VOLUME_GEOMETRY_FEATURE_COUNT = IFC_CONNECTION_GEOMETRY_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstraintImpl <em>Ifc Constraint</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstraintImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstraint()
	 * @generated
	 */
	int IFC_CONSTRAINT = 125;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__NAME = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__DESCRIPTION = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Constraint Grade</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CONSTRAINT_GRADE = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Constraint Source</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CONSTRAINT_SOURCE = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Creating Actor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CREATING_ACTOR = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Creation Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__CREATION_TIME = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>User Defined Grade</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__USER_DEFINED_GRADE = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Has External References</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__HAS_EXTERNAL_REFERENCES = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Properties For Constraint</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT__PROPERTIES_FOR_CONSTRAINT = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Ifc Constraint</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRAINT_FEATURE_COUNT = IFC_RESOURCE_OBJECT_SELECT_FEATURE_COUNT + 9;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcResourceImpl <em>Ifc Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcResourceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcResource()
	 * @generated
	 */
	int IFC_RESOURCE = 563;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__GLOBAL_ID = IFC_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__OWNER_HISTORY = IFC_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__NAME = IFC_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__DESCRIPTION = IFC_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__HAS_ASSIGNMENTS = IFC_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__NESTS = IFC_OBJECT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__IS_NESTED_BY = IFC_OBJECT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__HAS_CONTEXT = IFC_OBJECT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__IS_DECOMPOSED_BY = IFC_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__DECOMPOSES = IFC_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__HAS_ASSOCIATIONS = IFC_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__OBJECT_TYPE = IFC_OBJECT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__IS_DECLARED_BY = IFC_OBJECT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__DECLARES = IFC_OBJECT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__IS_TYPED_BY = IFC_OBJECT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__IS_DEFINED_BY = IFC_OBJECT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__IDENTIFICATION = IFC_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__LONG_DESCRIPTION = IFC_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE__RESOURCE_OF = IFC_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_RESOURCE_FEATURE_COUNT = IFC_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstructionResourceImpl <em>Ifc Construction Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstructionResourceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstructionResource()
	 * @generated
	 */
	int IFC_CONSTRUCTION_RESOURCE = 132;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID = IFC_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY = IFC_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__NAME = IFC_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__DESCRIPTION = IFC_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS = IFC_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__NESTS = IFC_RESOURCE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__IS_NESTED_BY = IFC_RESOURCE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__HAS_CONTEXT = IFC_RESOURCE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY = IFC_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__DECOMPOSES = IFC_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS = IFC_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE = IFC_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__IS_DECLARED_BY = IFC_RESOURCE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__DECLARES = IFC_RESOURCE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__IS_TYPED_BY = IFC_RESOURCE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY = IFC_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__IDENTIFICATION = IFC_RESOURCE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__LONG_DESCRIPTION = IFC_RESOURCE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF = IFC_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Usage</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__USAGE = IFC_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__BASE_COSTS = IFC_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY = IFC_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Construction Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT = IFC_RESOURCE_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstructionEquipmentResourceImpl <em>Ifc Construction Equipment Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstructionEquipmentResourceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstructionEquipmentResource()
	 * @generated
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE = 126;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__NAME = IFC_CONSTRUCTION_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__NESTS = IFC_CONSTRUCTION_RESOURCE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__IS_NESTED_BY = IFC_CONSTRUCTION_RESOURCE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__HAS_CONTEXT = IFC_CONSTRUCTION_RESOURCE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__OBJECT_TYPE = IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__IS_DECLARED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__DECLARES = IFC_CONSTRUCTION_RESOURCE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__IS_TYPED_BY = IFC_CONSTRUCTION_RESOURCE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__IS_DEFINED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__IDENTIFICATION = IFC_CONSTRUCTION_RESOURCE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__LONG_DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Usage</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__USAGE = IFC_CONSTRUCTION_RESOURCE__USAGE;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__BASE_COSTS = IFC_CONSTRUCTION_RESOURCE__BASE_COSTS;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE__PREDEFINED_TYPE = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Construction Equipment Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcTypeResourceImpl <em>Ifc Type Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcTypeResourceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcTypeResource()
	 * @generated
	 */
	int IFC_TYPE_RESOURCE = 729;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__GLOBAL_ID = IFC_TYPE_OBJECT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__OWNER_HISTORY = IFC_TYPE_OBJECT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__NAME = IFC_TYPE_OBJECT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__DESCRIPTION = IFC_TYPE_OBJECT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__HAS_ASSIGNMENTS = IFC_TYPE_OBJECT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__NESTS = IFC_TYPE_OBJECT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__IS_NESTED_BY = IFC_TYPE_OBJECT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__HAS_CONTEXT = IFC_TYPE_OBJECT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__IS_DECOMPOSED_BY = IFC_TYPE_OBJECT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__DECOMPOSES = IFC_TYPE_OBJECT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__HAS_ASSOCIATIONS = IFC_TYPE_OBJECT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__APPLICABLE_OCCURRENCE = IFC_TYPE_OBJECT__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__HAS_PROPERTY_SETS = IFC_TYPE_OBJECT__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__TYPES = IFC_TYPE_OBJECT__TYPES;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__IDENTIFICATION = IFC_TYPE_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__LONG_DESCRIPTION = IFC_TYPE_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Resource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__RESOURCE_TYPE = IFC_TYPE_OBJECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE__RESOURCE_OF = IFC_TYPE_OBJECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Type Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_TYPE_RESOURCE_FEATURE_COUNT = IFC_TYPE_OBJECT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstructionResourceTypeImpl <em>Ifc Construction Resource Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstructionResourceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstructionResourceType()
	 * @generated
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE = 133;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__GLOBAL_ID = IFC_TYPE_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__OWNER_HISTORY = IFC_TYPE_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__NAME = IFC_TYPE_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__DESCRIPTION = IFC_TYPE_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSIGNMENTS = IFC_TYPE_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__NESTS = IFC_TYPE_RESOURCE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__IS_NESTED_BY = IFC_TYPE_RESOURCE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_CONTEXT = IFC_TYPE_RESOURCE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__IS_DECOMPOSED_BY = IFC_TYPE_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__DECOMPOSES = IFC_TYPE_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSOCIATIONS = IFC_TYPE_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__APPLICABLE_OCCURRENCE = IFC_TYPE_RESOURCE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_PROPERTY_SETS = IFC_TYPE_RESOURCE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__TYPES = IFC_TYPE_RESOURCE__TYPES;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__IDENTIFICATION = IFC_TYPE_RESOURCE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__LONG_DESCRIPTION = IFC_TYPE_RESOURCE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_TYPE = IFC_TYPE_RESOURCE__RESOURCE_TYPE;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_OF = IFC_TYPE_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_COSTS = IFC_TYPE_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_QUANTITY = IFC_TYPE_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Construction Resource Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT = IFC_TYPE_RESOURCE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstructionEquipmentResourceTypeImpl <em>Ifc Construction Equipment Resource Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstructionEquipmentResourceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstructionEquipmentResourceType()
	 * @generated
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE = 127;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__NAME = IFC_CONSTRUCTION_RESOURCE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__NESTS = IFC_CONSTRUCTION_RESOURCE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__IS_NESTED_BY = IFC_CONSTRUCTION_RESOURCE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__HAS_CONTEXT = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__APPLICABLE_OCCURRENCE = IFC_CONSTRUCTION_RESOURCE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__HAS_PROPERTY_SETS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__TYPES = IFC_CONSTRUCTION_RESOURCE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__IDENTIFICATION = IFC_CONSTRUCTION_RESOURCE_TYPE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__LONG_DESCRIPTION = IFC_CONSTRUCTION_RESOURCE_TYPE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__RESOURCE_TYPE = IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_TYPE;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__BASE_COSTS = IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_COSTS;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE__PREDEFINED_TYPE = IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Construction Equipment Resource Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_EQUIPMENT_RESOURCE_TYPE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstructionMaterialResourceImpl <em>Ifc Construction Material Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstructionMaterialResourceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstructionMaterialResource()
	 * @generated
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE = 128;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__NAME = IFC_CONSTRUCTION_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__NESTS = IFC_CONSTRUCTION_RESOURCE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__IS_NESTED_BY = IFC_CONSTRUCTION_RESOURCE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__HAS_CONTEXT = IFC_CONSTRUCTION_RESOURCE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__OBJECT_TYPE = IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__IS_DECLARED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__DECLARES = IFC_CONSTRUCTION_RESOURCE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__IS_TYPED_BY = IFC_CONSTRUCTION_RESOURCE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__IS_DEFINED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__IDENTIFICATION = IFC_CONSTRUCTION_RESOURCE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__LONG_DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Usage</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__USAGE = IFC_CONSTRUCTION_RESOURCE__USAGE;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__BASE_COSTS = IFC_CONSTRUCTION_RESOURCE__BASE_COSTS;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE__PREDEFINED_TYPE = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Construction Material Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstructionMaterialResourceTypeImpl <em>Ifc Construction Material Resource Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstructionMaterialResourceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstructionMaterialResourceType()
	 * @generated
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE = 129;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__NAME = IFC_CONSTRUCTION_RESOURCE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__NESTS = IFC_CONSTRUCTION_RESOURCE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__IS_NESTED_BY = IFC_CONSTRUCTION_RESOURCE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__HAS_CONTEXT = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__APPLICABLE_OCCURRENCE = IFC_CONSTRUCTION_RESOURCE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__HAS_PROPERTY_SETS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__TYPES = IFC_CONSTRUCTION_RESOURCE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__IDENTIFICATION = IFC_CONSTRUCTION_RESOURCE_TYPE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__LONG_DESCRIPTION = IFC_CONSTRUCTION_RESOURCE_TYPE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__RESOURCE_TYPE = IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_TYPE;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__BASE_COSTS = IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_COSTS;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE__PREDEFINED_TYPE = IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Construction Material Resource Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_MATERIAL_RESOURCE_TYPE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstructionProductResourceImpl <em>Ifc Construction Product Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstructionProductResourceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstructionProductResource()
	 * @generated
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE = 130;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__NAME = IFC_CONSTRUCTION_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__NESTS = IFC_CONSTRUCTION_RESOURCE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__IS_NESTED_BY = IFC_CONSTRUCTION_RESOURCE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__HAS_CONTEXT = IFC_CONSTRUCTION_RESOURCE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__OBJECT_TYPE = IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__IS_DECLARED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__DECLARES = IFC_CONSTRUCTION_RESOURCE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__IS_TYPED_BY = IFC_CONSTRUCTION_RESOURCE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__IS_DEFINED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__IDENTIFICATION = IFC_CONSTRUCTION_RESOURCE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__LONG_DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Usage</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__USAGE = IFC_CONSTRUCTION_RESOURCE__USAGE;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__BASE_COSTS = IFC_CONSTRUCTION_RESOURCE__BASE_COSTS;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE__PREDEFINED_TYPE = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Construction Product Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConstructionProductResourceTypeImpl <em>Ifc Construction Product Resource Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConstructionProductResourceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConstructionProductResourceType()
	 * @generated
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE = 131;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__NAME = IFC_CONSTRUCTION_RESOURCE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__NESTS = IFC_CONSTRUCTION_RESOURCE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__IS_NESTED_BY = IFC_CONSTRUCTION_RESOURCE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__HAS_CONTEXT = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__APPLICABLE_OCCURRENCE = IFC_CONSTRUCTION_RESOURCE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__HAS_PROPERTY_SETS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__TYPES = IFC_CONSTRUCTION_RESOURCE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__IDENTIFICATION = IFC_CONSTRUCTION_RESOURCE_TYPE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__LONG_DESCRIPTION = IFC_CONSTRUCTION_RESOURCE_TYPE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__RESOURCE_TYPE = IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_TYPE;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__BASE_COSTS = IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_COSTS;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE__PREDEFINED_TYPE = IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Construction Product Resource Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONSTRUCTION_PRODUCT_RESOURCE_TYPE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcContextImpl <em>Ifc Context</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcContextImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcContext()
	 * @generated
	 */
	int IFC_CONTEXT = 134;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__GLOBAL_ID = IFC_OBJECT_DEFINITION__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__OWNER_HISTORY = IFC_OBJECT_DEFINITION__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__NAME = IFC_OBJECT_DEFINITION__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__DESCRIPTION = IFC_OBJECT_DEFINITION__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__HAS_ASSIGNMENTS = IFC_OBJECT_DEFINITION__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__NESTS = IFC_OBJECT_DEFINITION__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__IS_NESTED_BY = IFC_OBJECT_DEFINITION__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__HAS_CONTEXT = IFC_OBJECT_DEFINITION__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__IS_DECOMPOSED_BY = IFC_OBJECT_DEFINITION__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__DECOMPOSES = IFC_OBJECT_DEFINITION__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__HAS_ASSOCIATIONS = IFC_OBJECT_DEFINITION__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__OBJECT_TYPE = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Long Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__LONG_NAME = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Phase</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__PHASE = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Representation Contexts</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__REPRESENTATION_CONTEXTS = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Units In Context</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__UNITS_IN_CONTEXT = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__IS_DEFINED_BY = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT__DECLARES = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 6;

	/**
	 * The number of structural features of the '<em>Ifc Context</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_FEATURE_COUNT = IFC_OBJECT_DEFINITION_FEATURE_COUNT + 7;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.IfcUnit <em>Ifc Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.IfcUnit
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcUnit()
	 * @generated
	 */
	int IFC_UNIT = 947;

	/**
	 * The number of structural features of the '<em>Ifc Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_UNIT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcNamedUnitImpl <em>Ifc Named Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcNamedUnitImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcNamedUnit()
	 * @generated
	 */
	int IFC_NAMED_UNIT = 382;

	/**
	 * The feature id for the '<em><b>Dimensions</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_NAMED_UNIT__DIMENSIONS = IFC_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Unit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_NAMED_UNIT__UNIT_TYPE = IFC_UNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Named Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_NAMED_UNIT_FEATURE_COUNT = IFC_UNIT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcContextDependentUnitImpl <em>Ifc Context Dependent Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcContextDependentUnitImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcContextDependentUnit()
	 * @generated
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT = 135;

	/**
	 * The feature id for the '<em><b>Dimensions</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT__DIMENSIONS = IFC_NAMED_UNIT__DIMENSIONS;

	/**
	 * The feature id for the '<em><b>Unit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT__UNIT_TYPE = IFC_NAMED_UNIT__UNIT_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT__NAME = IFC_NAMED_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT__HAS_EXTERNAL_REFERENCE = IFC_NAMED_UNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Context Dependent Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTEXT_DEPENDENT_UNIT_FEATURE_COUNT = IFC_NAMED_UNIT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcControllerImpl <em>Ifc Controller</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcControllerImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcController()
	 * @generated
	 */
	int IFC_CONTROLLER = 137;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__NESTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__IS_NESTED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__HAS_CONTEXT = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__OBJECT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__IS_DECLARED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__DECLARES = IFC_DISTRIBUTION_CONTROL_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__IS_TYPED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__IS_DEFINED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__OBJECT_PLACEMENT = IFC_DISTRIBUTION_CONTROL_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__REPRESENTATION = IFC_DISTRIBUTION_CONTROL_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__REFERENCED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__GEOMETRY = IFC_DISTRIBUTION_CONTROL_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__FILLS_VOIDS = IFC_DISTRIBUTION_CONTROL_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__CONNECTED_TO = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__IS_INTERFERED_BY_ELEMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__INTERFERES_ELEMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__HAS_PROJECTIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__REFERENCED_IN_STRUCTURES = IFC_DISTRIBUTION_CONTROL_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__HAS_OPENINGS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__IS_CONNECTION_REALIZATION = IFC_DISTRIBUTION_CONTROL_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__PROVIDES_BOUNDARIES = IFC_DISTRIBUTION_CONTROL_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__CONNECTED_FROM = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__CONTAINED_IN_STRUCTURE = IFC_DISTRIBUTION_CONTROL_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__HAS_PORTS = IFC_DISTRIBUTION_CONTROL_ELEMENT__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Assigned To Flow Element</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__ASSIGNED_TO_FLOW_ELEMENT = IFC_DISTRIBUTION_CONTROL_ELEMENT__ASSIGNED_TO_FLOW_ELEMENT;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Controller</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcControllerTypeImpl <em>Ifc Controller Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcControllerTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcControllerType()
	 * @generated
	 */
	int IFC_CONTROLLER_TYPE = 138;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__GLOBAL_ID = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__OWNER_HISTORY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__NAME = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__DESCRIPTION = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__HAS_ASSIGNMENTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__NESTS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__IS_NESTED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__HAS_CONTEXT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__IS_DECOMPOSED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__DECOMPOSES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__HAS_ASSOCIATIONS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__APPLICABLE_OCCURRENCE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__HAS_PROPERTY_SETS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__TYPES = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__REPRESENTATION_MAPS = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__TAG = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__REFERENCED_BY = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__ELEMENT_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE__PREDEFINED_TYPE = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Controller Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONTROLLER_TYPE_FEATURE_COUNT = IFC_DISTRIBUTION_CONTROL_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConversionBasedUnitImpl <em>Ifc Conversion Based Unit</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConversionBasedUnitImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConversionBasedUnit()
	 * @generated
	 */
	int IFC_CONVERSION_BASED_UNIT = 139;

	/**
	 * The feature id for the '<em><b>Dimensions</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__DIMENSIONS = IFC_NAMED_UNIT__DIMENSIONS;

	/**
	 * The feature id for the '<em><b>Unit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__UNIT_TYPE = IFC_NAMED_UNIT__UNIT_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__NAME = IFC_NAMED_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Conversion Factor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__CONVERSION_FACTOR = IFC_NAMED_UNIT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT__HAS_EXTERNAL_REFERENCE = IFC_NAMED_UNIT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Conversion Based Unit</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_FEATURE_COUNT = IFC_NAMED_UNIT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcConversionBasedUnitWithOffsetImpl <em>Ifc Conversion Based Unit With Offset</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcConversionBasedUnitWithOffsetImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcConversionBasedUnitWithOffset()
	 * @generated
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET = 140;

	/**
	 * The feature id for the '<em><b>Dimensions</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET__DIMENSIONS = IFC_CONVERSION_BASED_UNIT__DIMENSIONS;

	/**
	 * The feature id for the '<em><b>Unit Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET__UNIT_TYPE = IFC_CONVERSION_BASED_UNIT__UNIT_TYPE;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET__NAME = IFC_CONVERSION_BASED_UNIT__NAME;

	/**
	 * The feature id for the '<em><b>Conversion Factor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET__CONVERSION_FACTOR = IFC_CONVERSION_BASED_UNIT__CONVERSION_FACTOR;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET__HAS_EXTERNAL_REFERENCE = IFC_CONVERSION_BASED_UNIT__HAS_EXTERNAL_REFERENCE;

	/**
	 * The feature id for the '<em><b>Conversion Offset</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET__CONVERSION_OFFSET = IFC_CONVERSION_BASED_UNIT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Conversion Offset As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET__CONVERSION_OFFSET_AS_STRING = IFC_CONVERSION_BASED_UNIT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Ifc Conversion Based Unit With Offset</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CONVERSION_BASED_UNIT_WITH_OFFSET_FEATURE_COUNT = IFC_CONVERSION_BASED_UNIT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCooledBeamImpl <em>Ifc Cooled Beam</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCooledBeamImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCooledBeam()
	 * @generated
	 */
	int IFC_COOLED_BEAM = 141;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__NAME = IFC_ENERGY_CONVERSION_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__NESTS = IFC_ENERGY_CONVERSION_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__OBJECT_TYPE = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__IS_DECLARED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__DECLARES = IFC_ENERGY_CONVERSION_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__IS_TYPED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__IS_DEFINED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__OBJECT_PLACEMENT = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__REPRESENTATION = IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__GEOMETRY = IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__TAG = IFC_ENERGY_CONVERSION_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__FILLS_VOIDS = IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__CONNECTED_TO = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__IS_INTERFERED_BY_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__INTERFERES_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__HAS_PROJECTIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__REFERENCED_IN_STRUCTURES = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__HAS_OPENINGS = IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__IS_CONNECTION_REALIZATION = IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__PROVIDES_BOUNDARIES = IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__CONNECTED_FROM = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__CONTAINED_IN_STRUCTURE = IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__HAS_PORTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__HAS_CONTROL_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cooled Beam</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCooledBeamTypeImpl <em>Ifc Cooled Beam Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCooledBeamTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCooledBeamType()
	 * @generated
	 */
	int IFC_COOLED_BEAM_TYPE = 142;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__NESTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__TYPES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cooled Beam Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLED_BEAM_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCoolingTowerImpl <em>Ifc Cooling Tower</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCoolingTowerImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCoolingTower()
	 * @generated
	 */
	int IFC_COOLING_TOWER = 143;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__NAME = IFC_ENERGY_CONVERSION_DEVICE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__NESTS = IFC_ENERGY_CONVERSION_DEVICE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__OBJECT_TYPE = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__IS_DECLARED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__DECLARES = IFC_ENERGY_CONVERSION_DEVICE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__IS_TYPED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__IS_DEFINED_BY = IFC_ENERGY_CONVERSION_DEVICE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__OBJECT_PLACEMENT = IFC_ENERGY_CONVERSION_DEVICE__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__REPRESENTATION = IFC_ENERGY_CONVERSION_DEVICE__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__GEOMETRY = IFC_ENERGY_CONVERSION_DEVICE__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__TAG = IFC_ENERGY_CONVERSION_DEVICE__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__FILLS_VOIDS = IFC_ENERGY_CONVERSION_DEVICE__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__CONNECTED_TO = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__IS_INTERFERED_BY_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__INTERFERES_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__HAS_PROJECTIONS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__REFERENCED_IN_STRUCTURES = IFC_ENERGY_CONVERSION_DEVICE__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__HAS_OPENINGS = IFC_ENERGY_CONVERSION_DEVICE__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__IS_CONNECTION_REALIZATION = IFC_ENERGY_CONVERSION_DEVICE__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__PROVIDES_BOUNDARIES = IFC_ENERGY_CONVERSION_DEVICE__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__CONNECTED_FROM = IFC_ENERGY_CONVERSION_DEVICE__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__CONTAINED_IN_STRUCTURE = IFC_ENERGY_CONVERSION_DEVICE__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Ports</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__HAS_PORTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_PORTS;

	/**
	 * The feature id for the '<em><b>Has Control Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__HAS_CONTROL_ELEMENTS = IFC_ENERGY_CONVERSION_DEVICE__HAS_CONTROL_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cooling Tower</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCoolingTowerTypeImpl <em>Ifc Cooling Tower Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCoolingTowerTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCoolingTowerType()
	 * @generated
	 */
	int IFC_COOLING_TOWER_TYPE = 144;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__GLOBAL_ID = IFC_ENERGY_CONVERSION_DEVICE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__OWNER_HISTORY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__NAME = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__DESCRIPTION = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__HAS_ASSIGNMENTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__NESTS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__IS_NESTED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__HAS_CONTEXT = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__IS_DECOMPOSED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__DECOMPOSES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__HAS_ASSOCIATIONS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__APPLICABLE_OCCURRENCE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__HAS_PROPERTY_SETS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__TYPES = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__REPRESENTATION_MAPS = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__TAG = IFC_ENERGY_CONVERSION_DEVICE_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__REFERENCED_BY = IFC_ENERGY_CONVERSION_DEVICE_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__ELEMENT_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE__PREDEFINED_TYPE = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Cooling Tower Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COOLING_TOWER_TYPE_FEATURE_COUNT = IFC_ENERGY_CONVERSION_DEVICE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCoordinateOperationImpl <em>Ifc Coordinate Operation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCoordinateOperationImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCoordinateOperation()
	 * @generated
	 */
	int IFC_COORDINATE_OPERATION = 145;

	/**
	 * The feature id for the '<em><b>Source CRS</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_OPERATION__SOURCE_CRS = 0;

	/**
	 * The feature id for the '<em><b>Target CRS</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_OPERATION__TARGET_CRS = 1;

	/**
	 * The number of structural features of the '<em>Ifc Coordinate Operation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_OPERATION_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.IfcCoordinateReferenceSystemSelect <em>Ifc Coordinate Reference System Select</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.IfcCoordinateReferenceSystemSelect
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCoordinateReferenceSystemSelect()
	 * @generated
	 */
	int IFC_COORDINATE_REFERENCE_SYSTEM_SELECT = 901;

	/**
	 * The number of structural features of the '<em>Ifc Coordinate Reference System Select</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_REFERENCE_SYSTEM_SELECT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCoordinateReferenceSystemImpl <em>Ifc Coordinate Reference System</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCoordinateReferenceSystemImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCoordinateReferenceSystem()
	 * @generated
	 */
	int IFC_COORDINATE_REFERENCE_SYSTEM = 146;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_REFERENCE_SYSTEM__NAME = IFC_COORDINATE_REFERENCE_SYSTEM_SELECT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_REFERENCE_SYSTEM__DESCRIPTION = IFC_COORDINATE_REFERENCE_SYSTEM_SELECT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Geodetic Datum</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_REFERENCE_SYSTEM__GEODETIC_DATUM = IFC_COORDINATE_REFERENCE_SYSTEM_SELECT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Vertical Datum</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_REFERENCE_SYSTEM__VERTICAL_DATUM = IFC_COORDINATE_REFERENCE_SYSTEM_SELECT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Coordinate Reference System</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COORDINATE_REFERENCE_SYSTEM_FEATURE_COUNT = IFC_COORDINATE_REFERENCE_SYSTEM_SELECT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCostItemImpl <em>Ifc Cost Item</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCostItemImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCostItem()
	 * @generated
	 */
	int IFC_COST_ITEM = 147;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__GLOBAL_ID = IFC_CONTROL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__OWNER_HISTORY = IFC_CONTROL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__NAME = IFC_CONTROL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__DESCRIPTION = IFC_CONTROL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__HAS_ASSIGNMENTS = IFC_CONTROL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__NESTS = IFC_CONTROL__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__IS_NESTED_BY = IFC_CONTROL__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__HAS_CONTEXT = IFC_CONTROL__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__IS_DECOMPOSED_BY = IFC_CONTROL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__DECOMPOSES = IFC_CONTROL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__HAS_ASSOCIATIONS = IFC_CONTROL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__OBJECT_TYPE = IFC_CONTROL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__IS_DECLARED_BY = IFC_CONTROL__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__DECLARES = IFC_CONTROL__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__IS_TYPED_BY = IFC_CONTROL__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__IS_DEFINED_BY = IFC_CONTROL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__IDENTIFICATION = IFC_CONTROL__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__CONTROLS = IFC_CONTROL__CONTROLS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__PREDEFINED_TYPE = IFC_CONTROL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Cost Values</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__COST_VALUES = IFC_CONTROL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cost Quantities</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM__COST_QUANTITIES = IFC_CONTROL_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Cost Item</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_ITEM_FEATURE_COUNT = IFC_CONTROL_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCostScheduleImpl <em>Ifc Cost Schedule</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCostScheduleImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCostSchedule()
	 * @generated
	 */
	int IFC_COST_SCHEDULE = 148;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__GLOBAL_ID = IFC_CONTROL__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__OWNER_HISTORY = IFC_CONTROL__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__NAME = IFC_CONTROL__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__DESCRIPTION = IFC_CONTROL__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__HAS_ASSIGNMENTS = IFC_CONTROL__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__NESTS = IFC_CONTROL__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__IS_NESTED_BY = IFC_CONTROL__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__HAS_CONTEXT = IFC_CONTROL__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__IS_DECOMPOSED_BY = IFC_CONTROL__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__DECOMPOSES = IFC_CONTROL__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__HAS_ASSOCIATIONS = IFC_CONTROL__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__OBJECT_TYPE = IFC_CONTROL__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__IS_DECLARED_BY = IFC_CONTROL__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__DECLARES = IFC_CONTROL__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__IS_TYPED_BY = IFC_CONTROL__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__IS_DEFINED_BY = IFC_CONTROL__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__IDENTIFICATION = IFC_CONTROL__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Controls</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__CONTROLS = IFC_CONTROL__CONTROLS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__PREDEFINED_TYPE = IFC_CONTROL_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__STATUS = IFC_CONTROL_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Submitted On</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__SUBMITTED_ON = IFC_CONTROL_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Update Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE__UPDATE_DATE = IFC_CONTROL_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Ifc Cost Schedule</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_SCHEDULE_FEATURE_COUNT = IFC_CONTROL_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCostValueImpl <em>Ifc Cost Value</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCostValueImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCostValue()
	 * @generated
	 */
	int IFC_COST_VALUE = 149;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__NAME = IFC_APPLIED_VALUE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__DESCRIPTION = IFC_APPLIED_VALUE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Applied Value</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__APPLIED_VALUE = IFC_APPLIED_VALUE__APPLIED_VALUE;

	/**
	 * The feature id for the '<em><b>Unit Basis</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__UNIT_BASIS = IFC_APPLIED_VALUE__UNIT_BASIS;

	/**
	 * The feature id for the '<em><b>Applicable Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__APPLICABLE_DATE = IFC_APPLIED_VALUE__APPLICABLE_DATE;

	/**
	 * The feature id for the '<em><b>Fixed Until Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__FIXED_UNTIL_DATE = IFC_APPLIED_VALUE__FIXED_UNTIL_DATE;

	/**
	 * The feature id for the '<em><b>Category</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__CATEGORY = IFC_APPLIED_VALUE__CATEGORY;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__CONDITION = IFC_APPLIED_VALUE__CONDITION;

	/**
	 * The feature id for the '<em><b>Arithmetic Operator</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__ARITHMETIC_OPERATOR = IFC_APPLIED_VALUE__ARITHMETIC_OPERATOR;

	/**
	 * The feature id for the '<em><b>Components</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__COMPONENTS = IFC_APPLIED_VALUE__COMPONENTS;

	/**
	 * The feature id for the '<em><b>Has External Reference</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE__HAS_EXTERNAL_REFERENCE = IFC_APPLIED_VALUE__HAS_EXTERNAL_REFERENCE;

	/**
	 * The number of structural features of the '<em>Ifc Cost Value</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COST_VALUE_FEATURE_COUNT = IFC_APPLIED_VALUE_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCoveringImpl <em>Ifc Covering</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCoveringImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCovering()
	 * @generated
	 */
	int IFC_COVERING = 150;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__NESTS = IFC_BUILDING_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_NESTED_BY = IFC_BUILDING_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_CONTEXT = IFC_BUILDING_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_DECLARED_BY = IFC_BUILDING_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__DECLARES = IFC_BUILDING_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_TYPED_BY = IFC_BUILDING_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNECTED_TO;

	/**
	 * The feature id for the '<em><b>Is Interfered By Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_INTERFERED_BY_ELEMENTS = IFC_BUILDING_ELEMENT__IS_INTERFERED_BY_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Interferes Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__INTERFERES_ELEMENTS = IFC_BUILDING_ELEMENT__INTERFERES_ELEMENTS;

	/**
	 * The feature id for the '<em><b>Has Projections</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_PROJECTIONS = IFC_BUILDING_ELEMENT__HAS_PROJECTIONS;

	/**
	 * The feature id for the '<em><b>Referenced In Structures</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__REFERENCED_IN_STRUCTURES = IFC_BUILDING_ELEMENT__REFERENCED_IN_STRUCTURES;

	/**
	 * The feature id for the '<em><b>Has Openings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_OPENINGS = IFC_BUILDING_ELEMENT__HAS_OPENINGS;

	/**
	 * The feature id for the '<em><b>Is Connection Realization</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__IS_CONNECTION_REALIZATION = IFC_BUILDING_ELEMENT__IS_CONNECTION_REALIZATION;

	/**
	 * The feature id for the '<em><b>Provides Boundaries</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__PROVIDES_BOUNDARIES = IFC_BUILDING_ELEMENT__PROVIDES_BOUNDARIES;

	/**
	 * The feature id for the '<em><b>Connected From</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__CONNECTED_FROM = IFC_BUILDING_ELEMENT__CONNECTED_FROM;

	/**
	 * The feature id for the '<em><b>Contained In Structure</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__CONTAINED_IN_STRUCTURE = IFC_BUILDING_ELEMENT__CONTAINED_IN_STRUCTURE;

	/**
	 * The feature id for the '<em><b>Has Coverings</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__HAS_COVERINGS = IFC_BUILDING_ELEMENT__HAS_COVERINGS;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Covers Spaces</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__COVERS_SPACES = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Covers Elements</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING__COVERS_ELEMENTS = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Ifc Covering</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_FEATURE_COUNT = IFC_BUILDING_ELEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCoveringTypeImpl <em>Ifc Covering Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCoveringTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCoveringType()
	 * @generated
	 */
	int IFC_COVERING_TYPE = 151;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__GLOBAL_ID = IFC_BUILDING_ELEMENT_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__OWNER_HISTORY = IFC_BUILDING_ELEMENT_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__NAME = IFC_BUILDING_ELEMENT_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__DESCRIPTION = IFC_BUILDING_ELEMENT_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__NESTS = IFC_BUILDING_ELEMENT_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__IS_NESTED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__HAS_CONTEXT = IFC_BUILDING_ELEMENT_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__DECOMPOSES = IFC_BUILDING_ELEMENT_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__APPLICABLE_OCCURRENCE = IFC_BUILDING_ELEMENT_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__HAS_PROPERTY_SETS = IFC_BUILDING_ELEMENT_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__TYPES = IFC_BUILDING_ELEMENT_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Representation Maps</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__REPRESENTATION_MAPS = IFC_BUILDING_ELEMENT_TYPE__REPRESENTATION_MAPS;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__TAG = IFC_BUILDING_ELEMENT_TYPE__TAG;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__REFERENCED_BY = IFC_BUILDING_ELEMENT_TYPE__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Element Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__ELEMENT_TYPE = IFC_BUILDING_ELEMENT_TYPE__ELEMENT_TYPE;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE__PREDEFINED_TYPE = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Covering Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_COVERING_TYPE_FEATURE_COUNT = IFC_BUILDING_ELEMENT_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCrewResourceImpl <em>Ifc Crew Resource</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCrewResourceImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCrewResource()
	 * @generated
	 */
	int IFC_CREW_RESOURCE = 152;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__NAME = IFC_CONSTRUCTION_RESOURCE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__NESTS = IFC_CONSTRUCTION_RESOURCE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__IS_NESTED_BY = IFC_CONSTRUCTION_RESOURCE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__HAS_CONTEXT = IFC_CONSTRUCTION_RESOURCE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__OBJECT_TYPE = IFC_CONSTRUCTION_RESOURCE__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__IS_DECLARED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__DECLARES = IFC_CONSTRUCTION_RESOURCE__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__IS_TYPED_BY = IFC_CONSTRUCTION_RESOURCE__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__IS_DEFINED_BY = IFC_CONSTRUCTION_RESOURCE__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__IDENTIFICATION = IFC_CONSTRUCTION_RESOURCE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__LONG_DESCRIPTION = IFC_CONSTRUCTION_RESOURCE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Usage</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__USAGE = IFC_CONSTRUCTION_RESOURCE__USAGE;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__BASE_COSTS = IFC_CONSTRUCTION_RESOURCE__BASE_COSTS;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE__PREDEFINED_TYPE = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Crew Resource</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCrewResourceTypeImpl <em>Ifc Crew Resource Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCrewResourceTypeImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCrewResourceType()
	 * @generated
	 */
	int IFC_CREW_RESOURCE_TYPE = 153;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__GLOBAL_ID = IFC_CONSTRUCTION_RESOURCE_TYPE__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__OWNER_HISTORY = IFC_CONSTRUCTION_RESOURCE_TYPE__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__NAME = IFC_CONSTRUCTION_RESOURCE_TYPE__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__DESCRIPTION = IFC_CONSTRUCTION_RESOURCE_TYPE__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__HAS_ASSIGNMENTS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__NESTS = IFC_CONSTRUCTION_RESOURCE_TYPE__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__IS_NESTED_BY = IFC_CONSTRUCTION_RESOURCE_TYPE__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__HAS_CONTEXT = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__IS_DECOMPOSED_BY = IFC_CONSTRUCTION_RESOURCE_TYPE__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__DECOMPOSES = IFC_CONSTRUCTION_RESOURCE_TYPE__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__HAS_ASSOCIATIONS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Applicable Occurrence</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__APPLICABLE_OCCURRENCE = IFC_CONSTRUCTION_RESOURCE_TYPE__APPLICABLE_OCCURRENCE;

	/**
	 * The feature id for the '<em><b>Has Property Sets</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__HAS_PROPERTY_SETS = IFC_CONSTRUCTION_RESOURCE_TYPE__HAS_PROPERTY_SETS;

	/**
	 * The feature id for the '<em><b>Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__TYPES = IFC_CONSTRUCTION_RESOURCE_TYPE__TYPES;

	/**
	 * The feature id for the '<em><b>Identification</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__IDENTIFICATION = IFC_CONSTRUCTION_RESOURCE_TYPE__IDENTIFICATION;

	/**
	 * The feature id for the '<em><b>Long Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__LONG_DESCRIPTION = IFC_CONSTRUCTION_RESOURCE_TYPE__LONG_DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Resource Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__RESOURCE_TYPE = IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_TYPE;

	/**
	 * The feature id for the '<em><b>Resource Of</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__RESOURCE_OF = IFC_CONSTRUCTION_RESOURCE_TYPE__RESOURCE_OF;

	/**
	 * The feature id for the '<em><b>Base Costs</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__BASE_COSTS = IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_COSTS;

	/**
	 * The feature id for the '<em><b>Base Quantity</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__BASE_QUANTITY = IFC_CONSTRUCTION_RESOURCE_TYPE__BASE_QUANTITY;

	/**
	 * The feature id for the '<em><b>Predefined Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE__PREDEFINED_TYPE = IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Crew Resource Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CREW_RESOURCE_TYPE_FEATURE_COUNT = IFC_CONSTRUCTION_RESOURCE_TYPE_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCsgSolidImpl <em>Ifc Csg Solid</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCsgSolidImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCsgSolid()
	 * @generated
	 */
	int IFC_CSG_SOLID = 155;

	/**
	 * The feature id for the '<em><b>Layer Assignment</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID__LAYER_ASSIGNMENT = IFC_SOLID_MODEL__LAYER_ASSIGNMENT;

	/**
	 * The feature id for the '<em><b>Styled By Item</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID__STYLED_BY_ITEM = IFC_SOLID_MODEL__STYLED_BY_ITEM;

	/**
	 * The feature id for the '<em><b>Dim</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID__DIM = IFC_SOLID_MODEL__DIM;

	/**
	 * The feature id for the '<em><b>Tree Root Expression</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID__TREE_ROOT_EXPRESSION = IFC_SOLID_MODEL_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Ifc Csg Solid</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CSG_SOLID_FEATURE_COUNT = IFC_SOLID_MODEL_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCurrencyRelationshipImpl <em>Ifc Currency Relationship</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCurrencyRelationshipImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCurrencyRelationship()
	 * @generated
	 */
	int IFC_CURRENCY_RELATIONSHIP = 156;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__NAME = IFC_RESOURCE_LEVEL_RELATIONSHIP__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__DESCRIPTION = IFC_RESOURCE_LEVEL_RELATIONSHIP__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Relating Monetary Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__RELATING_MONETARY_UNIT = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Related Monetary Unit</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__RELATED_MONETARY_UNIT = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Exchange Rate</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__EXCHANGE_RATE = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Exchange Rate As String</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__EXCHANGE_RATE_AS_STRING = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Rate Date Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__RATE_DATE_TIME = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Rate Source</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP__RATE_SOURCE = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 5;

	/**
	 * The number of structural features of the '<em>Ifc Currency Relationship</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURRENCY_RELATIONSHIP_FEATURE_COUNT = IFC_RESOURCE_LEVEL_RELATIONSHIP_FEATURE_COUNT + 6;

	/**
	 * The meta object id for the '{@link org.bimserver.models.ifc4.impl.IfcCurtainWallImpl <em>Ifc Curtain Wall</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.bimserver.models.ifc4.impl.IfcCurtainWallImpl
	 * @see org.bimserver.models.ifc4.impl.Ifc4PackageImpl#getIfcCurtainWall()
	 * @generated
	 */
	int IFC_CURTAIN_WALL = 157;

	/**
	 * The feature id for the '<em><b>Global Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__GLOBAL_ID = IFC_BUILDING_ELEMENT__GLOBAL_ID;

	/**
	 * The feature id for the '<em><b>Owner History</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__OWNER_HISTORY = IFC_BUILDING_ELEMENT__OWNER_HISTORY;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__NAME = IFC_BUILDING_ELEMENT__NAME;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__DESCRIPTION = IFC_BUILDING_ELEMENT__DESCRIPTION;

	/**
	 * The feature id for the '<em><b>Has Assignments</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_ASSIGNMENTS = IFC_BUILDING_ELEMENT__HAS_ASSIGNMENTS;

	/**
	 * The feature id for the '<em><b>Nests</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__NESTS = IFC_BUILDING_ELEMENT__NESTS;

	/**
	 * The feature id for the '<em><b>Is Nested By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__IS_NESTED_BY = IFC_BUILDING_ELEMENT__IS_NESTED_BY;

	/**
	 * The feature id for the '<em><b>Has Context</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_CONTEXT = IFC_BUILDING_ELEMENT__HAS_CONTEXT;

	/**
	 * The feature id for the '<em><b>Is Decomposed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__IS_DECOMPOSED_BY = IFC_BUILDING_ELEMENT__IS_DECOMPOSED_BY;

	/**
	 * The feature id for the '<em><b>Decomposes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__DECOMPOSES = IFC_BUILDING_ELEMENT__DECOMPOSES;

	/**
	 * The feature id for the '<em><b>Has Associations</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__HAS_ASSOCIATIONS = IFC_BUILDING_ELEMENT__HAS_ASSOCIATIONS;

	/**
	 * The feature id for the '<em><b>Object Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__OBJECT_TYPE = IFC_BUILDING_ELEMENT__OBJECT_TYPE;

	/**
	 * The feature id for the '<em><b>Is Declared By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__IS_DECLARED_BY = IFC_BUILDING_ELEMENT__IS_DECLARED_BY;

	/**
	 * The feature id for the '<em><b>Declares</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__DECLARES = IFC_BUILDING_ELEMENT__DECLARES;

	/**
	 * The feature id for the '<em><b>Is Typed By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__IS_TYPED_BY = IFC_BUILDING_ELEMENT__IS_TYPED_BY;

	/**
	 * The feature id for the '<em><b>Is Defined By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__IS_DEFINED_BY = IFC_BUILDING_ELEMENT__IS_DEFINED_BY;

	/**
	 * The feature id for the '<em><b>Object Placement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__OBJECT_PLACEMENT = IFC_BUILDING_ELEMENT__OBJECT_PLACEMENT;

	/**
	 * The feature id for the '<em><b>Representation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__REPRESENTATION = IFC_BUILDING_ELEMENT__REPRESENTATION;

	/**
	 * The feature id for the '<em><b>Referenced By</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__REFERENCED_BY = IFC_BUILDING_ELEMENT__REFERENCED_BY;

	/**
	 * The feature id for the '<em><b>Geometry</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__GEOMETRY = IFC_BUILDING_ELEMENT__GEOMETRY;

	/**
	 * The feature id for the '<em><b>Tag</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__TAG = IFC_BUILDING_ELEMENT__TAG;

	/**
	 * The feature id for the '<em><b>Fills Voids</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__FILLS_VOIDS = IFC_BUILDING_ELEMENT__FILLS_VOIDS;

	/**
	 * The feature id for the '<em><b>Connected To</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IFC_CURTAIN_WALL__CONNECTED_TO = IFC_BUILDING_ELEMENT__CONNEC