/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import org.bimserver.emf.IdEObject;
import org.bimserver.emf.IdEObjectImpl;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.emf.ModelMetaData;
import org.bimserver.emf.OidProvider;
import org.bimserver.emf.PackageMetaData;
import org.bimserver.emf.Schema;
import org.bimserver.ifc.IfcModelChangeListener;
import org.bimserver.models.ifc2x3tc1.Ifc2x3tc1Package;
import org.bimserver.models.ifc4.Ifc4Package;
import org.bimserver.plugins.ObjectAlreadyExistsException;
import org.bimserver.shared.exceptions.PublicInterfaceNotFoundException;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IfcModel
implements IfcModelInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(IfcModel.class);
    protected ModelMetaData modelMetaData = null;
    private final Set<IfcModelChangeListener> changeListeners = new LinkedHashSet<IfcModelChangeListener>();
    private BiMap<Long, IdEObject> objects;
    private final Set<IdEObject> unidentifiedObjects = new HashSet<IdEObject>();
    private Map<String, IdEObject> guidIndexed;
    private Map<EClass, List<? extends IdEObject>> indexPerClass;
    private Map<EClass, List<? extends IdEObject>> indexPerClassWithSubTypes;
    private Map<EClass, Map<String, IdEObject>> guidIndex;
    private Map<EClass, Map<String, IdEObject>> nameIndex;
    private long oidCounter = 1L;
    private boolean useDoubleStrings = true;
    private PackageMetaData packageMetaData;
    private Map<Integer, Long> pidRoidMap;

    public IfcModel(PackageMetaData packageMetaData, Map<Integer, Long> pidRoidMap, int size) {
        this.pidRoidMap = pidRoidMap;
        if (packageMetaData == null) {
            throw new IllegalArgumentException("PackageMetaData is required");
        }
        this.packageMetaData = packageMetaData;
        this.objects = HashBiMap.create((int)size);
    }

    public IfcModel(PackageMetaData packageMetaData, Map<Integer, Long> pidRoidMap) {
        this(packageMetaData, pidRoidMap, 16);
    }

    protected void buildIndex() {
        this.indexPerClass = new HashMap<EClass, List<? extends IdEObject>>();
        for (Long key : this.objects.keySet()) {
            IdEObject value = (IdEObject)this.objects.get((Object)key);
            if (value == null) continue;
            List<? extends IdEObject> list = this.indexPerClass.get(value.eClass());
            if (list == null) {
                list = new ArrayList<IdEObject>();
                this.indexPerClass.put(value.eClass(), list);
            }
            list.add((IdEObject)value);
        }
    }

    public void rebuildIndexPerClass(EClass eClass) {
        if (this.indexPerClass == null) {
            this.indexPerClass = new HashMap<EClass, List<? extends IdEObject>>();
        }
        ArrayList<IdEObject> list = new ArrayList<IdEObject>();
        this.indexPerClass.put(eClass, list);
        for (Long key : this.objects.keySet()) {
            IdEObject value = (IdEObject)this.objects.get((Object)key);
            if (eClass != value.eClass()) continue;
            list.add(value);
        }
    }

    private void buildIndexWithSubTypes() {
        this.indexPerClassWithSubTypes = new HashMap<EClass, List<? extends IdEObject>>();
        for (Long key : this.objects.keySet()) {
            IdEObject idEObject = (IdEObject)this.objects.get((Object)key);
            if (idEObject == null) continue;
            this.buildIndexWithSuperTypes(idEObject, idEObject.eClass());
        }
    }

    private void buildIndexWithSuperTypes(IdEObject eObject, EClass eClass) {
        if (!this.indexPerClassWithSubTypes.containsKey(eClass)) {
            this.indexPerClassWithSubTypes.put(eClass, new ArrayList());
        }
        this.indexPerClassWithSubTypes.get(eClass).add((IdEObject)eObject);
        for (EClass superClass : eClass.getESuperTypes()) {
            this.buildIndexWithSuperTypes(eObject, superClass);
        }
    }

    public void buildGuidIndex() {
        this.guidIndex = new HashMap<EClass, Map<String, IdEObject>>();
        if (this.objects.isEmpty()) {
            return;
        }
        for (EClassifier classifier : ((IdEObject)this.objects.values().iterator().next()).eClass().getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            TreeMap map = new TreeMap();
            this.guidIndex.put((EClass)classifier, map);
        }
        EClass ifcRootEclass = this.packageMetaData.getEClass("IfcRoot");
        EStructuralFeature guidFeature = ifcRootEclass.getEStructuralFeature("GlobalId");
        for (Long key : this.objects.keySet()) {
            Object guid;
            IdEObject value = (IdEObject)this.objects.get((Object)key);
            if (!ifcRootEclass.isSuperTypeOf(value.eClass()) || (guid = value.eGet(guidFeature)) == null) continue;
            this.guidIndex.get(value.eClass()).put((String)guid, value);
        }
    }

    public void buildNameIndex() {
        this.nameIndex = new HashMap<EClass, Map<String, IdEObject>>();
        for (EClassifier classifier : ((IdEObject)this.objects.values().iterator().next()).eClass().getEPackage().getEClassifiers()) {
            if (!(classifier instanceof EClass)) continue;
            TreeMap map = new TreeMap();
            this.nameIndex.put((EClass)classifier, map);
        }
        EClass ifcRootEclass = this.packageMetaData.getEClass("IfcRoot");
        EStructuralFeature nameFeature = ifcRootEclass.getEStructuralFeature("Name");
        for (Long key : this.objects.keySet()) {
            Object name;
            IdEObject value = (IdEObject)this.objects.get((Object)key);
            if (!ifcRootEclass.isSuperTypeOf(value.eClass()) || (name = value.eGet(nameFeature)) == null) continue;
            this.nameIndex.get(value.eClass()).put((String)name, value);
        }
    }

    private void sortPrimitiveList(EList<IdEObject> list) {
        ECollections.sort(list, (Comparator)new Comparator<IdEObject>(){

            @Override
            public int compare(IdEObject o1, IdEObject o2) {
                return IfcModel.this.comparePrimitives(o1, o2);
            }
        });
    }

    private int comparePrimitives(IdEObject o1, IdEObject o2) {
        EClass eClass = o1.eClass();
        EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature("wrappedValue");
        Object val1 = o1.eGet(eStructuralFeature);
        Object val2 = o2.eGet(eStructuralFeature);
        if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEString()) {
            return ((String)val1).compareTo((String)val2);
        }
        if (eStructuralFeature.getEType() == EcorePackage.eINSTANCE.getEInt()) {
            return ((Integer)val1).compareTo((Integer)val2);
        }
        throw new RuntimeException("ni");
    }

    public <T extends IdEObject> List<T> getAll(EClass eClass) {
        List<? extends IdEObject> list;
        if (this.indexPerClass == null) {
            this.buildIndex();
        }
        if ((list = this.indexPerClass.get(eClass)) == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public <T extends IdEObject> List<T> getAll(Class<T> interfaceClass) {
        return this.getAll(this.packageMetaData.getEClassIncludingDependencies(interfaceClass));
    }

    public <T extends IdEObject> List<T> getAllWithSubTypes(EClass eClass) {
        List<? extends IdEObject> list;
        if (this.indexPerClassWithSubTypes == null) {
            this.buildIndexWithSubTypes();
        }
        if ((list = this.indexPerClassWithSubTypes.get(eClass)) == null) {
            return Collections.EMPTY_LIST;
        }
        return list;
    }

    public <T extends IdEObject> List<T> getAllWithSubTypes(Class<T> interfaceClass) {
        return this.getAllWithSubTypes(this.packageMetaData.getEClass(interfaceClass));
    }

    public Set<String> getGuids(EClass eClass) {
        Map<String, IdEObject> map;
        if (this.guidIndex == null) {
            this.buildGuidIndex();
        }
        if ((map = this.guidIndex.get(eClass)) == null) {
            return new HashSet<String>();
        }
        return map.keySet();
    }

    public Set<String> getNames(EClass eClass) {
        Map<String, IdEObject> map;
        if (this.nameIndex == null) {
            this.buildNameIndex();
        }
        if ((map = this.nameIndex.get(eClass)) == null) {
            return new HashSet<String>();
        }
        return map.keySet();
    }

    public IdEObject getByName(EClass eClass, String name) {
        if (this.nameIndex == null) {
            this.buildNameIndex();
        }
        return this.nameIndex.get(eClass).get(name);
    }

    public long size() {
        return this.objects.size() + this.unidentifiedObjects.size();
    }

    public Set<Long> keySet() {
        return this.objects.keySet();
    }

    public IdEObject get(long oid) {
        return (IdEObject)this.objects.get((Object)oid);
    }

    public Collection<IdEObject> getValues() {
        return this.objects.values();
    }

    public Collection<IdEObject> getUnidentifiedValues() {
        return this.unidentifiedObjects;
    }

    public void add(long oid, IdEObject eObject) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        this.add(oid, eObject, false, false);
    }

    public void addAllowMultiModel(long oid, IdEObject eObject) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        this.add(oid, eObject, false, true);
    }

    private void add(long oid, IdEObject eObject, boolean ignoreDuplicateOids, boolean allowMultiModel) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        if (((IdEObjectImpl)eObject).hasModel() && !allowMultiModel && ((IdEObjectImpl)eObject).getModel() != this) {
            throw new IfcModelInterfaceException("This object (" + eObject + ") already belongs to a Model: " + ((IdEObjectImpl)eObject).getModel() + ", not this " + this);
        }
        if (oid == -1L || eObject.eClass().getEAnnotation("wrapped") != null) {
            this.unidentifiedObjects.add(eObject);
        } else {
            if (this.objects.containsKey((Object)oid)) {
                if (!ignoreDuplicateOids && this.objects.get((Object)oid) != eObject) {
                    // empty if block
                }
            } else {
                this.objects.put((Object)oid, (Object)eObject);
                if (!((IdEObjectImpl)eObject).hasModel() || !allowMultiModel) {
                    ((IdEObjectImpl)eObject).setModel((IfcModelInterface)this);
                }
                if (this.guidIndexed != null) {
                    this.indexGuid(eObject);
                }
                if (this.indexPerClassWithSubTypes != null) {
                    this.buildIndexWithSuperTypes(eObject, eObject.eClass());
                }
                if (this.indexPerClass != null) {
                    List<? extends IdEObject> list = this.indexPerClass.get(eObject.eClass());
                    if (list == null) {
                        list = new ArrayList<IdEObject>();
                        this.indexPerClass.put(eObject.eClass(), list);
                    }
                    list.add((IdEObject)eObject);
                }
            }
            for (IfcModelChangeListener ifcModelChangeListener : this.changeListeners) {
                ifcModelChangeListener.objectAdded(eObject);
            }
        }
    }

    public BiMap<Long, IdEObject> getObjects() {
        return this.objects;
    }

    public boolean contains(long oid) {
        return this.objects.containsKey((Object)oid);
    }

    public boolean contains(IdEObject eObject) {
        return this.objects.containsValue((Object)eObject);
    }

    public void indexGuids() {
        this.guidIndexed = new HashMap<String, IdEObject>();
        for (IdEObject idEObject : this.objects.values()) {
            this.indexGuid(idEObject);
        }
    }

    private void indexGuid(IdEObject idEObject) {
        Object guid;
        EClass ifcRootEclass = this.packageMetaData.getEClass("IfcRoot");
        EStructuralFeature guidFeature = ifcRootEclass.getEStructuralFeature("GlobalId");
        if (ifcRootEclass.isSuperTypeOf(idEObject.eClass()) && (guid = idEObject.eGet(guidFeature)) != null) {
            this.guidIndexed.put((String)guid, idEObject);
        }
    }

    public boolean isValid() {
        return true;
    }

    public void dumpObject(IdEObject idEObject) {
        this.dumpObject(idEObject, 0, new HashSet<IdEObject>());
    }

    private void dumpObject(IdEObject idEObject, int indention, Set<IdEObject> printed) {
        if (printed.contains(idEObject)) {
            this.printIndention(indention);
            System.out.println("[REFERENCE: " + idEObject.getOid() + "]");
            return;
        }
        printed.add(idEObject);
        this.printIndention(indention);
        System.out.println(idEObject.eClass().getName() + " (" + idEObject.getOid() + ")");
        for (EAttribute eAttribute : idEObject.eClass().getEAllAttributes()) {
            Object val = idEObject.eGet((EStructuralFeature)eAttribute);
            if (val == null) continue;
            this.printIndention(indention + 1);
            System.out.println(eAttribute.getName() + ": " + val);
        }
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            Object referencedObject = idEObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List list = (List)referencedObject;
                if (list.size() <= 0) continue;
                this.printIndention(indention + 1);
                System.out.println(eReference.getName() + ": ");
                for (Object o : list) {
                    this.dumpObject((IdEObject)o, indention + 2, printed);
                }
                continue;
            }
            if (referencedObject == null) continue;
            this.printIndention(indention + 1);
            System.out.println(eReference.getName() + ": ");
            this.dumpObject((IdEObject)referencedObject, indention + 2, printed);
        }
    }

    private void printIndention(int indention) {
        for (int i = 0; i < indention; ++i) {
            System.out.print("  ");
        }
    }

    public void dumpSummary() {
        TreeMap<EClass, Integer> counts = new TreeMap<EClass, Integer>(new Comparator<EClass>(){

            @Override
            public int compare(EClass o1, EClass o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (IdEObject idEObject : this.objects.values()) {
            if (!counts.containsKey(idEObject.eClass())) {
                counts.put(idEObject.eClass(), 1);
                continue;
            }
            counts.put(idEObject.eClass(), (Integer)counts.get(idEObject.eClass()) + 1);
        }
        for (EClass eClass : counts.keySet()) {
            System.out.println(eClass.getName() + ": " + counts.get(eClass));
        }
    }

    public void dump() {
        System.out.println("Dumping IFC Model");
        for (Long key : this.objects.keySet()) {
            System.out.println(key + ": " + ((IdEObject)this.objects.get((Object)key)).eClass().getName());
        }
    }

    public void dumpPlusReferences() {
        System.out.println("Dumping IFC Model + References");
        HashSet<IdEObject> done = new HashSet<IdEObject>();
        for (Long key : this.objects.keySet()) {
            this.dumpPlusReferences(done, (IdEObject)this.objects.get((Object)key));
        }
    }

    private void dumpPlusReferences(Set<IdEObject> done, IdEObject idEObject) {
        if (idEObject == null) {
            return;
        }
        if (done.contains(idEObject)) {
            return;
        }
        done.add(idEObject);
        System.out.println(idEObject.getOid() + ": " + idEObject.eClass().getName());
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            Object val = idEObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List list = (List)val;
                for (Object o : list) {
                    this.dumpPlusReferences(done, (IdEObject)o);
                }
                continue;
            }
            this.dumpPlusReferences(done, (IdEObject)val);
        }
    }

    public void remove(IdEObject idEObject) {
        this.unidentifiedObjects.remove(idEObject);
        this.objects.inverse().remove((Object)idEObject);
        if (this.indexPerClass != null) {
            this.indexPerClass.get(idEObject.eClass()).remove(idEObject);
        }
        if (this.indexPerClassWithSubTypes != null) {
            this.indexPerClassWithSubTypes.get(idEObject.eClass()).remove(idEObject);
        }
    }

    public void setOid(IdEObject object, Long oid) {
        this.objects.forcePut((Object)oid, (Object)object);
    }

    public void fixOids(OidProvider oidProvider) {
        HashBiMap temp = HashBiMap.create();
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            long oid = (Long)iterator.next();
            this.fixOids((IdEObject)this.objects.get((Object)oid), oidProvider, (BiMap<Long, IdEObject>)temp);
        }
        this.objects = temp;
    }

    public void fixOidsFlat(OidProvider oidProvider) {
        HashBiMap temp = HashBiMap.create();
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            long oid = (Long)iterator.next();
            this.fixOidsFlat((IdEObject)this.objects.get((Object)oid), oidProvider, (BiMap<Long, IdEObject>)temp);
        }
        this.objects = temp;
    }

    public void fixOids() {
        HashBiMap temp = HashBiMap.create();
        for (IdEObject object : this.objects.values()) {
            temp.put((Object)object.getOid(), (Object)object);
        }
        this.objects = temp;
    }

    private void fixOids(IdEObject idEObject, OidProvider oidProvider, BiMap<Long, IdEObject> temp) {
        if (idEObject == null) {
            return;
        }
        if (temp.containsValue((Object)idEObject)) {
            return;
        }
        ((IdEObjectImpl)idEObject).setOid(oidProvider.newOid(idEObject.eClass()));
        if (this.objects.containsValue((Object)idEObject)) {
            temp.put((Object)idEObject.getOid(), (Object)idEObject);
        }
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            Object val = idEObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List list = (List)val;
                for (Object o : list) {
                    this.fixOids((IdEObject)o, oidProvider, temp);
                }
                continue;
            }
            this.fixOids((IdEObject)val, oidProvider, temp);
        }
    }

    private void fixOidsFlat(IdEObject idEObject, OidProvider oidProvider, BiMap<Long, IdEObject> temp) {
        if (idEObject == null) {
            return;
        }
        if (temp.containsValue((Object)idEObject)) {
            return;
        }
        ((IdEObjectImpl)idEObject).setOid(oidProvider.newOid(idEObject.eClass()));
        if (this.objects.containsValue((Object)idEObject)) {
            temp.put((Object)idEObject.getOid(), (Object)idEObject);
        }
    }

    public void setObjectOids() {
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            long oid = (Long)iterator.next();
            ((IdEObjectImpl)this.objects.get((Object)oid)).setOid(oid);
        }
    }

    public long getHighestOid() {
        long max = 0L;
        Iterator iterator = this.objects.keySet().iterator();
        while (iterator.hasNext()) {
            long oid = (Long)iterator.next();
            if (oid <= max) continue;
            max = oid;
        }
        return max;
    }

    public void changeOid(IdEObject object) {
        this.objects.inverse().remove((Object)object);
        this.objects.put((Object)object.getOid(), (Object)object);
    }

    public IdEObject getByGuid(String guid) {
        if (this.guidIndexed == null) {
            this.indexGuids();
        }
        return this.guidIndexed.get(guid);
    }

    public boolean containsGuid(String guid) {
        if (this.guidIndexed == null) {
            this.indexGuids();
        }
        return this.guidIndexed.containsKey(guid);
    }

    public void checkDoubleOids() {
        HashSet<Long> oids = new HashSet<Long>();
        for (IdEObject idEObject : this.objects.values()) {
            if (oids.contains(idEObject.getOid())) {
                throw new RuntimeException("Double oid: " + idEObject.getOid());
            }
            oids.add(idEObject.getOid());
        }
    }

    public void fixOidCounter() {
        this.oidCounter = this.getHighestOid() + 1L;
    }

    private void checkDoubleOidsPlusReferences(BiMap<IdEObject, Long> done, IdEObject idEObject) {
        if (idEObject == null) {
            return;
        }
        if (idEObject.eClass().getEAnnotation("wrapped") != null) {
            return;
        }
        if (done.containsKey((Object)idEObject)) {
            return;
        }
        if (done.containsValue((Object)idEObject.getOid())) {
            this.showBackReferences(idEObject);
            IdEObject existing = (IdEObject)done.inverse().get((Object)idEObject.getOid());
            this.showBackReferences(existing);
            throw new RuntimeException("Double oid: " + idEObject.getOid() + " " + idEObject + ", " + existing);
        }
        done.put((Object)idEObject, (Object)idEObject.getOid());
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            if (eReference.isMany()) {
                List list = (List)idEObject.eGet((EStructuralFeature)eReference);
                for (Object o : list) {
                    this.checkDoubleOidsPlusReferences(done, (IdEObject)o);
                }
                continue;
            }
            this.checkDoubleOidsPlusReferences(done, (IdEObject)idEObject.eGet((EStructuralFeature)eReference));
        }
    }

    public void showBackReferences(IdEObject idEObject) {
        System.out.println("Showing back references to: " + idEObject);
        for (IdEObject object : this.getValues()) {
            for (EReference eReference : object.eClass().getEAllReferences()) {
                if (eReference.isMany()) {
                    List list = (List)object.eGet((EStructuralFeature)eReference);
                    for (Object o : list) {
                        if (o != idEObject) continue;
                        System.out.println(object.eClass().getName() + "." + eReference.getName() + " " + object);
                    }
                    continue;
                }
                Object o = object.eGet((EStructuralFeature)eReference);
                if (o != idEObject) continue;
                System.out.println(object.eClass().getName() + "." + eReference.getName() + " " + object);
            }
        }
    }

    public void checkDoubleOidsPlusReferences() {
        HashBiMap done = HashBiMap.create();
        for (IdEObject idEObject : this.objects.values()) {
            this.checkDoubleOidsPlusReferences((BiMap<IdEObject, Long>)done, idEObject);
        }
    }

    public void resetOidsFlat() {
        for (IdEObject idEObject : this.objects.values()) {
            ((IdEObjectImpl)idEObject).setOid(-1L);
        }
    }

    public void resetOids() {
        HashSet<IdEObject> done = new HashSet<IdEObject>();
        for (IdEObject idEObject : this.objects.values()) {
            this.resetOids(idEObject, done);
        }
    }

    public void resetOids(IdEObject idEObject, Set<IdEObject> done) {
        if (idEObject == null) {
            return;
        }
        if (done.contains(idEObject)) {
            return;
        }
        ((IdEObjectImpl)idEObject).setOid(-1L);
        done.add(idEObject);
        for (EReference eReference : idEObject.eClass().getEAllReferences()) {
            Object val = idEObject.eGet((EStructuralFeature)eReference);
            if (eReference.isMany()) {
                List list = (List)val;
                for (Object o : list) {
                    this.resetOids((IdEObject)o, done);
                }
                continue;
            }
            this.resetOids((IdEObject)val, done);
        }
    }

    public void addChangeListener(IfcModelChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(IfcModelChangeListener ifcModelChangeListener) {
        this.changeListeners.remove(ifcModelChangeListener);
    }

    public void setUseDoubleStrings(boolean useDoubleStrings) {
        this.useDoubleStrings = useDoubleStrings;
    }

    public boolean isUseDoubleStrings() {
        return this.useDoubleStrings;
    }

    public Iterator<IdEObject> iterator() {
        return this.objects.values().iterator();
    }

    public int countWithSubtypes(EClass eClass) {
        List list = this.getAllWithSubTypes(eClass);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public int count(EClass eClass) {
        List list = this.getAll(eClass);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public Iterator<IdEObject> iterateAllObjects() {
        return new Iterator<IdEObject>(){
            private final Queue<IdEObject> todo;
            private final Set<IdEObject> done;
            {
                this.todo = new LinkedBlockingQueue<IdEObject>(IfcModel.this.getValues());
                this.done = new HashSet<IdEObject>();
            }

            @Override
            public boolean hasNext() {
                return !this.todo.isEmpty();
            }

            @Override
            public IdEObject next() {
                IdEObject idEObject = this.todo.poll();
                this.done.add(idEObject);
                for (EReference eReference : idEObject.eClass().getEAllReferences()) {
                    Object val = idEObject.eGet((EStructuralFeature)eReference);
                    if (eReference.isMany()) {
                        List list = (List)val;
                        for (Object o : list) {
                            if (this.done.contains(o)) continue;
                            this.todo.add((IdEObject)o);
                        }
                        continue;
                    }
                    if (val == null || this.done.contains(val)) continue;
                    this.todo.add((IdEObject)val);
                }
                return idEObject;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void generateMinimalExpressIds() {
        int expressId = 1;
        Iterator<IdEObject> iterateAllObjects = this.iterateAllObjects();
        while (iterateAllObjects.hasNext()) {
            IdEObject idEObject = iterateAllObjects.next();
            ((IdEObjectImpl)idEObject).setExpressId((long)expressId++);
        }
    }

    public ModelMetaData getModelMetaData() {
        if (this.modelMetaData == null) {
            this.modelMetaData = new ModelMetaData();
        }
        return this.modelMetaData;
    }

    public <T extends IdEObject> T create(EClass eClass) throws IfcModelInterfaceException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        long oid = this.oidCounter++;
        object.setOid(oid);
        return (T)object;
    }

    public <T extends IdEObject> T createAndAdd(Class<T> clazz) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        EClass eClass = this.packageMetaData.getEClass(clazz);
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setLoadingState(IdEObjectImpl.State.LOADED);
        long oid = this.oidCounter++;
        this.add(oid, (IdEObject)object);
        return (T)object;
    }

    public <T extends IdEObject> T createAndAdd(EClass eClass) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setLoadingState(IdEObjectImpl.State.LOADED);
        long oid = this.oidCounter++;
        this.add(oid, (IdEObject)object);
        return (T)object;
    }

    public <T extends IdEObject> T create(EClass eClass, long oid) throws IfcModelInterfaceException {
        if (eClass == null) {
            throw new IllegalArgumentException("eClass cannot be null");
        }
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setModel((IfcModelInterface)this);
        object.setOid(oid);
        return (T)object;
    }

    public <T extends IdEObject> T createAndAdd(EClass eClass, long oid) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        object.setModel((IfcModelInterface)this);
        object.setOid(oid);
        this.add(oid, (IdEObject)object);
        return (T)object;
    }

    public <T extends IdEObject> T create(EClass eClass, OidProvider oidProvider) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        IdEObjectImpl object = (IdEObjectImpl)eClass.getEPackage().getEFactoryInstance().create(eClass);
        long oid = oidProvider.newOid(eClass);
        object.setOid(oid);
        object.setLoadingState(IdEObjectImpl.State.LOADED);
        this.add(oid, (IdEObject)object, false, false);
        return (T)object;
    }

    public <T extends IdEObject> T create(Class<T> clazz) throws IfcModelInterfaceException {
        return this.create(this.packageMetaData.getEClassIncludingDependencies(clazz));
    }

    public <T extends IdEObject> T create(Class<T> clazz, OidProvider oidProvider) throws IfcModelInterfaceException, ObjectAlreadyExistsException {
        return this.create(this.packageMetaData.getEClass(clazz), oidProvider);
    }

    public void clear() {
        if (this.guidIndex != null) {
            this.guidIndex.clear();
        }
        if (this.guidIndexed != null) {
            this.guidIndexed.clear();
        }
        if (this.indexPerClass != null) {
            this.indexPerClass.clear();
        }
        if (this.nameIndex != null) {
            this.nameIndex.clear();
        }
        if (this.indexPerClassWithSubTypes != null) {
            this.indexPerClassWithSubTypes.clear();
        }
        if (this.objects != null) {
            this.objects.clear();
        }
    }

    public void resetExpressIds() {
        for (IdEObject idEObject : this.objects.values()) {
            ((IdEObjectImpl)idEObject).setExpressId(-1L);
        }
    }

    public IfcModelInterface branch(long poid, boolean recordChanges) {
        throw new UnsupportedOperationException();
    }

    public long commit(String comment) throws ServerException, UserException, PublicInterfaceNotFoundException {
        throw new UnsupportedOperationException();
    }

    public PackageMetaData getPackageMetaData() {
        return this.packageMetaData;
    }

    public void fixInverseMismatches() {
        Mismatch[] misMatches;
        Mismatch[] mismatchArray;
        int nrFixes = 0;
        Ifc4Package ifc4 = Ifc4Package.eINSTANCE;
        Ifc2x3tc1Package ifc2x3 = Ifc2x3tc1Package.eINSTANCE;
        if (this.packageMetaData.getSchema().equals((Object)Schema.IFC2X3TC1)) {
            Mismatch[] mismatchArray2 = new Mismatch[7];
            mismatchArray2[0] = new Mismatch(ifc2x3.getIfcRelContainedInSpatialStructure_RelatedElements(), new EReference[]{ifc2x3.getIfcElement_ContainedInStructure(), ifc2x3.getIfcGrid_ContainedInStructure(), ifc2x3.getIfcAnnotation_ContainedInStructure()});
            mismatchArray2[1] = new Mismatch(ifc2x3.getIfcPresentationLayerAssignment_AssignedItems(), new EReference[]{ifc2x3.getIfcRepresentation_LayerAssignments(), ifc2x3.getIfcRepresentationItem_LayerAssignments()});
            mismatchArray2[2] = new Mismatch(ifc2x3.getIfcRelAssociates_RelatedObjects(), new EReference[]{ifc2x3.getIfcObjectDefinition_HasAssociations(), ifc2x3.getIfcPropertyDefinition_HasAssociations()});
            mismatchArray2[3] = new Mismatch(ifc2x3.getIfcTerminatorSymbol_AnnotatedCurve(), new EReference[]{ifc2x3.getIfcDimensionCurve_AnnotatedBySymbols()});
            mismatchArray2[4] = new Mismatch(ifc2x3.getIfcRelReferencedInSpatialStructure_RelatedElements(), new EReference[]{ifc2x3.getIfcElement_ReferencedInStructures()});
            mismatchArray2[5] = new Mismatch(ifc2x3.getIfcProduct_Representation(), new EReference[]{ifc2x3.getIfcProductDefinitionShape_ShapeOfProduct()});
            mismatchArray = mismatchArray2;
            mismatchArray2[6] = new Mismatch(ifc2x3.getIfcRelConnectsElements_RelatingElement(), new EReference[]{ifc2x3.getIfcStructuralItem_AssignedStructuralActivity()});
        } else {
            Mismatch[] mismatchArray3 = new Mismatch[23];
            mismatchArray3[0] = new Mismatch(ifc4.getIfcRelContainedInSpatialStructure_RelatedElements(), new EReference[]{ifc4.getIfcElement_ContainedInStructure(), ifc4.getIfcGrid_ContainedInStructure(), ifc4.getIfcAnnotation_ContainedInStructure()});
            mismatchArray3[1] = new Mismatch(ifc4.getIfcPresentationLayerAssignment_AssignedItems(), new EReference[]{ifc4.getIfcRepresentation_LayerAssignments(), ifc4.getIfcRepresentationItem_LayerAssignment()});
            mismatchArray3[2] = new Mismatch(ifc4.getIfcRelAssociates_RelatedObjects(), new EReference[]{ifc4.getIfcObjectDefinition_HasAssociations(), ifc4.getIfcPropertyDefinition_HasAssociations()});
            mismatchArray3[3] = new Mismatch(ifc4.getIfcRelReferencedInSpatialStructure_RelatedElements(), new EReference[]{ifc4.getIfcElement_ReferencedInStructures()});
            mismatchArray3[4] = new Mismatch(ifc4.getIfcProduct_Representation(), new EReference[]{ifc4.getIfcProductDefinitionShape_ShapeOfProduct()});
            mismatchArray3[5] = new Mismatch(ifc4.getIfcRelConnectsElements_RelatingElement(), new EReference[]{ifc4.getIfcStructuralItem_AssignedStructuralActivity()});
            mismatchArray3[6] = new Mismatch(ifc4.getIfcExternalReferenceRelationship_RelatedResourceObjects(), new EReference[]{ifc4.getIfcActorRole_HasExternalReference(), ifc4.getIfcAppliedValue_HasExternalReference(), ifc4.getIfcApproval_HasExternalReferences(), ifc4.getIfcConstraint_HasExternalReferences(), ifc4.getIfcContextDependentUnit_HasExternalReference(), ifc4.getIfcConversionBasedUnit_HasExternalReference(), ifc4.getIfcMaterialDefinition_HasExternalReferences(), ifc4.getIfcPhysicalQuantity_HasExternalReferences(), ifc4.getIfcProfileDef_HasExternalReference(), ifc4.getIfcPropertyAbstraction_HasExternalReferences(), ifc4.getIfcTimeSeries_HasExternalReference()});
            mismatchArray3[7] = new Mismatch(ifc4.getIfcRelAssociatesClassification_RelatingClassification(), new EReference[]{ifc4.getIfcClassification_ClassificationForObjects(), ifc4.getIfcClassificationReference_ClassificationRefForObjects()});
            mismatchArray3[8] = new Mismatch(ifc4.getIfcClassificationReference_ReferencedSource(), new EReference[]{ifc4.getIfcClassification_HasReferences(), ifc4.getIfcClassificationReference_HasReferences()});
            mismatchArray3[9] = new Mismatch(ifc4.getIfcRelDefinesByProperties_RelatedObjects(), new EReference[]{ifc4.getIfcContext_IsDefinedBy(), ifc4.getIfcObject_IsDefinedBy()});
            mismatchArray3[10] = new Mismatch(ifc4.getIfcRelAssociatesDocument_RelatingDocument(), new EReference[]{ifc4.getIfcDocumentInformation_DocumentInfoForObjects(), ifc4.getIfcDocumentReference_DocumentRefForObjects()});
            mismatchArray3[11] = new Mismatch(ifc4.getIfcRelSpaceBoundary_RelatingSpace(), new EReference[]{ifc4.getIfcExternalSpatialElement_BoundedBy(), ifc4.getIfcSpace_BoundedBy()});
            mismatchArray3[12] = new Mismatch(ifc4.getIfcRelAssociatesLibrary_RelatingLibrary(), new EReference[]{ifc4.getIfcLibraryInformation_LibraryInfoForObjects(), ifc4.getIfcLibraryReference_LibraryRefForObjects()});
            mismatchArray3[13] = new Mismatch(ifc4.getIfcRelAssociatesMaterial_RelatingMaterial(), new EReference[]{ifc4.getIfcMaterialDefinition_AssociatedTo(), ifc4.getIfcMaterialUsageDefinition_AssociatedTo()});
            mismatchArray3[14] = new Mismatch(ifc4.getIfcRelDeclares_RelatedDefinitions(), new EReference[]{ifc4.getIfcObjectDefinition_HasContext(), ifc4.getIfcPropertyDefinition_HasContext()});
            mismatchArray3[15] = new Mismatch(ifc4.getIfcRelAssignsToProcess_RelatingProcess(), new EReference[]{ifc4.getIfcProcess_OperatesOn(), ifc4.getIfcTypeProcess_OperatesOn()});
            mismatchArray3[16] = new Mismatch(ifc4.getIfcShapeAspect_PartOfProductDefinitionShape(), new EReference[]{ifc4.getIfcProductDefinitionShape_HasShapeAspects(), ifc4.getIfcRepresentationMap_HasShapeAspects()});
            mismatchArray3[17] = new Mismatch(ifc4.getIfcRelDefinesByProperties_RelatingPropertyDefinition(), new EReference[]{ifc4.getIfcPropertySetDefinition_DefinesOccurrence()});
            mismatchArray3[18] = new Mismatch(ifc4.getIfcRelAssignsToResource_RelatingResource(), new EReference[]{ifc4.getIfcResource_ResourceOf(), ifc4.getIfcTypeResource_ResourceOf()});
            mismatchArray3[19] = new Mismatch(ifc4.getIfcCoordinateOperation_SourceCRS(), new EReference[]{ifc4.getIfcCoordinateReferenceSystem_HasCoordinateOperation(), ifc4.getIfcGeometricRepresentationContext_HasCoordinateOperation()});
            mismatchArray3[20] = new Mismatch(ifc4.getIfcRelAssignsToProduct_RelatingProduct(), new EReference[]{ifc4.getIfcProduct_ReferencedBy()});
            mismatchArray3[21] = new Mismatch(ifc4.getIfcResourceConstraintRelationship_RelatedResourceObjects(), new EReference[]{ifc4.getIfcProperty_HasConstraints()});
            mismatchArray = mismatchArray3;
            mismatchArray3[22] = new Mismatch(ifc4.getIfcResourceApprovalRelationship_RelatedResourceObjects(), new EReference[]{ifc4.getIfcProperty_HasApprovals()});
        }
        for (Mismatch mismatch : misMatches = mismatchArray) {
            for (IdEObject entityToBeFixed : this.getAllWithSubTypes(mismatch.forward.getEContainingClass())) {
                Object referenced = entityToBeFixed.eGet((EStructuralFeature)mismatch.forward);
                if (referenced == null) continue;
                if (mismatch.forward.isMany()) {
                    for (IdEObject referencedInList : (EList)referenced) {
                        nrFixes += this.fixMisMatchInstance(mismatch, entityToBeFixed, referencedInList);
                    }
                    continue;
                }
                nrFixes += this.fixMisMatchInstance(mismatch, entityToBeFixed, (IdEObject)referenced);
            }
        }
        LOGGER.info("Nr inverse fixes: " + nrFixes);
    }

    private int fixMisMatchInstance(Mismatch mismatch, IdEObject entityToBeFixed, IdEObject referenced) {
        int nrFixes = 0;
        for (EReference inverse : mismatch.inverse) {
            if (!inverse.getEContainingClass().isInstance((Object)referenced)) continue;
            if (inverse.isMany()) {
                ((EList)referenced.eGet((EStructuralFeature)inverse)).add((Object)entityToBeFixed);
            } else {
                referenced.eSet((EStructuralFeature)inverse, (Object)entityToBeFixed);
            }
            ++nrFixes;
        }
        return nrFixes;
    }

    public Map<Integer, Long> getPidRoidMap() {
        return this.pidRoidMap;
    }

    public void set(IdEObject idEObject, EStructuralFeature eFeature, Object newValue) {
    }

    public void checkin(long poid, String comment) throws ServerException, UserException, PublicInterfaceNotFoundException {
    }

    public boolean containsNoFetch(long oid) {
        return this.contains(oid);
    }

    public IdEObject getNoFetch(long oid) {
        return this.get(oid);
    }

    public abstract void load(IdEObject var1);

    public Set<EClass> getUsedClasses() {
        if (this.indexPerClass == null) {
            this.buildIndex();
        }
        return this.indexPerClass.keySet();
    }

    public void query(ObjectNode query, boolean assumeCompletePreload) throws ServerException, UserException, PublicInterfaceNotFoundException, IfcModelInterfaceException, IOException {
    }

    public <T extends IdEObject> T getFirst(Class<T> class1) {
        return (T)((IdEObject)this.getAll(class1).iterator().next());
    }

    public <T extends IdEObject> T getFirst(EClass eClass) {
        return (T)((IdEObject)this.getAll(eClass).iterator().next());
    }

    public void dumpDebug() {
    }

    public void close() throws Exception {
    }

    class Mismatch {
        EReference forward;
        EReference[] inverse;

        Mismatch(EReference forward, EReference[] inverse) {
            this.forward = forward;
            this.inverse = inverse;
        }
    }
}

