/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class PhysicalJavaFileObject
implements JavaFileObject {
    private final File file;
    private byte[] data;

    public PhysicalJavaFileObject(File file) throws IOException {
        this.file = file;
        if (file.isFile()) {
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)fis, (OutputStream)byteArrayOutputStream);
            this.data = byteArrayOutputStream.toByteArray();
        }
    }

    @Override
    public URI toUri() {
        return this.file.toURI();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new ByteArrayInputStream(this.data);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new ByteArrayOutputStream(){

            public void close() throws IOException {
                super.close();
                PhysicalJavaFileObject.access$002(PhysicalJavaFileObject.this, this.toByteArray());
            }
        };
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new StringReader(new String(this.data, Charsets.UTF_8));
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return new String(this.data, Charsets.UTF_8);
    }

    @Override
    public Writer openWriter() throws IOException {
        return new StringWriter(){

            @Override
            public void close() throws IOException {
                super.close();
                PhysicalJavaFileObject.access$002(PhysicalJavaFileObject.this, this.toString().getBytes(Charsets.UTF_8));
            }
        };
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        if (this.file.getName().endsWith(".java")) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (this.file.getName().endsWith(".class")) {
            return JavaFileObject.Kind.CLASS;
        }
        if (this.file.getName().endsWith(".html")) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
        return true;
    }

    @Override
    public NestingKind getNestingKind() {
        return NestingKind.TOP_LEVEL;
    }

    @Override
    public Modifier getAccessLevel() {
        return Modifier.PUBLIC;
    }

    public String getCleanName() {
        String name = this.getName();
        if (name.contains(".")) {
            name = name.substring(0, name.indexOf("."));
        }
        return name.replace(File.separator, ".");
    }

    static /* synthetic */ byte[] access$002(PhysicalJavaFileObject x0, byte[] x1) {
        x0.data = x1;
        return x1;
    }
}

