/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.bimserver.interfaces.objects.SPluginBundle;
import org.bimserver.interfaces.objects.SPluginBundleType;
import org.bimserver.interfaces.objects.SPluginBundleVersion;
import org.bimserver.interfaces.objects.SPluginInformation;
import org.bimserver.models.store.ObjectDefinition;
import org.bimserver.plugins.AbstractPlugin;
import org.bimserver.plugins.Dependency;
import org.bimserver.plugins.JavaPlugin;
import org.bimserver.plugins.JsonWebModule;
import org.bimserver.plugins.MavenPluginBundle;
import org.bimserver.plugins.MavenPluginLocation;
import org.bimserver.plugins.MavenPluginRepository;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginBundleIdentifier;
import org.bimserver.plugins.PluginBundleImpl;
import org.bimserver.plugins.PluginBundleVersionIdentifier;
import org.bimserver.plugins.PluginConfiguration;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.PluginDescriptor;
import org.bimserver.plugins.PluginManager;
import org.bimserver.plugins.PluginSourceType;
import org.bimserver.plugins.ResourceLoader;
import org.bimserver.plugins.classloaders.DelegatingClassLoader;
import org.bimserver.plugins.classloaders.EclipsePluginClassloader;
import org.bimserver.plugins.classloaders.FileJarClassLoader;
import org.bimserver.plugins.classloaders.PublicFindClassClassLoader;
import org.bimserver.plugins.web.WebModulePlugin;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.utils.FakeClosingInputStream;
import org.bimserver.utils.PathUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginBundleManager
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginBundleManager.class);
    private final Map<PluginBundleIdentifier, PluginBundle> pluginBundleIdentifierToPluginBundle = new HashMap<PluginBundleIdentifier, PluginBundle>();
    private final Map<PluginBundleVersionIdentifier, PluginBundle> pluginBundleVersionIdentifierToPluginBundle = new HashMap<PluginBundleVersionIdentifier, PluginBundle>();
    private final Map<PluginBundleIdentifier, PluginBundleVersionIdentifier> pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier = new HashMap<PluginBundleIdentifier, PluginBundleVersionIdentifier>();
    private PluginManager pluginManager;
    private final Path pluginsDir;
    private MavenPluginRepository mavenPluginRepository;
    private final List<FileJarClassLoader> jarClassLoaders = new ArrayList<FileJarClassLoader>();

    public PluginBundleManager(PluginManager pluginManager, MavenPluginRepository mavenPluginRepository, Path pluginsDir) {
        this.pluginManager = pluginManager;
        this.mavenPluginRepository = mavenPluginRepository;
        this.pluginsDir = pluginsDir;
        if (pluginsDir != null && !Files.isDirectory(pluginsDir, new LinkOption[0])) {
            try {
                Files.createDirectories(pluginsDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public PluginBundle install(MavenPluginBundle mavenPluginBundle, boolean strictDependencyChecking) throws Exception {
        return this.install(mavenPluginBundle, null, strictDependencyChecking);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginBundle install(MavenPluginBundle mavenPluginBundle, List<SPluginInformation> plugins, boolean strictDependencyChecking) throws Exception {
        InputStream jarInputStream2;
        PluginBundleVersionIdentifier pluginBundleVersionIdentifier = mavenPluginBundle.getPluginVersionIdentifier();
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        Model model = null;
        try (InputStream pomInputStream = mavenPluginBundle.getPomInputStream();){
            model = mavenreader.read(pomInputStream);
        }
        if (plugins == null) {
            var8_8 = null;
            try (InputStream inputStream = mavenPluginBundle.getJarInputStream();){
                jarInputStream2 = new JarInputStream(inputStream);
                Throwable throwable = null;
                try {
                    JarEntry nextJarEntry = ((JarInputStream)jarInputStream2).getNextJarEntry();
                    while (nextJarEntry != null) {
                        if (nextJarEntry.getName().equals("plugin/plugin.xml")) {
                            PluginDescriptor pluginDescriptor = this.pluginManager.getPluginDescriptor((InputStream)new FakeClosingInputStream(jarInputStream2));
                            plugins = new ArrayList<SPluginInformation>();
                            this.pluginManager.processPluginDescriptor(pluginDescriptor, plugins);
                            for (SPluginInformation info : plugins) {
                                info.setInstallForAllUsers(true);
                                info.setInstallForNewUsers(true);
                            }
                            break;
                        }
                        nextJarEntry = ((JarInputStream)jarInputStream2).getNextJarEntry();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jarInputStream2 != null) {
                        if (throwable != null) {
                            try {
                                ((ZipInputStream)jarInputStream2).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((ZipInputStream)jarInputStream2).close();
                        }
                    }
                }
            }
            catch (Throwable jarInputStream2) {
                var8_8 = jarInputStream2;
                throw jarInputStream2;
            }
        }
        DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(this.getClass().getClassLoader());
        this.loadDependencies(mavenPluginBundle.getVersion(), strictDependencyChecking, model, delegatingClassLoader);
        Path target = this.pluginsDir.resolve(pluginBundleVersionIdentifier.getFileName());
        if (Files.exists(target, new LinkOption[0])) {
            throw new PluginException("This plugin has already been installed " + target.getFileName().toString());
        }
        jarInputStream2 = mavenPluginBundle.getJarInputStream();
        try {
            Files.copy(jarInputStream2, target, new CopyOption[0]);
        }
        finally {
            jarInputStream2.close();
        }
        return this.loadPlugin(pluginBundleVersionIdentifier, target, mavenPluginBundle.getPluginBundle(), mavenPluginBundle.getPluginBundleVersion(), plugins, delegatingClassLoader);
    }

    private void loadDependencies(String pluginBundleVersion, boolean strictDependencyChecking, Model model, DelegatingClassLoader delegatingClassLoader) throws DependencyCollectionException, InvalidVersionSpecificationException, Exception {
        if (model.getRepositories() != null) {
            for (Repository repository : model.getRepositories()) {
                this.mavenPluginRepository.addRepository(repository.getId(), "default", repository.getUrl());
            }
        }
        ArrayList<org.eclipse.aether.graph.Dependency> dependenciesToResolve = new ArrayList<org.eclipse.aether.graph.Dependency>();
        for (org.apache.maven.model.Dependency dependency2 : model.getDependencies()) {
            if (dependency2.getGroupId().contentEquals("org.opensourcebim") && (dependency2.getArtifactId().contentEquals("shared") || dependency2.getArtifactId().contentEquals("pluginbase"))) continue;
            dependenciesToResolve.add(new org.eclipse.aether.graph.Dependency((Artifact)new DefaultArtifact(dependency2.getGroupId(), dependency2.getArtifactId(), "pom", dependency2.getVersion()), dependency2.getScope()));
        }
        CollectRequest collectRequest = new CollectRequest(dependenciesToResolve, null, null);
        collectRequest.setRepositories(this.mavenPluginRepository.getRepositoriesAsList());
        CollectResult collectDependencies = this.mavenPluginRepository.getSystem().collectDependencies(this.mavenPluginRepository.getSession(), collectRequest);
        PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
        DependencyNode rootDep = collectDependencies.getRoot();
        rootDep.accept((DependencyVisitor)nlg);
        for (org.eclipse.aether.graph.Dependency dependency : nlg.getDependencies(true)) {
            Artifact dependencyArtifact = dependency.getArtifact();
            PluginBundleIdentifier pluginBundleIdentifier = new PluginBundleIdentifier(dependencyArtifact.getGroupId(), dependencyArtifact.getArtifactId());
            if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleIdentifier)) {
                if (strictDependencyChecking) {
                    DefaultArtifactVersion artifactVersion;
                    VersionRange versionRange;
                    String version = dependencyArtifact.getVersion();
                    if (!version.contains("[") && !version.contains("(")) {
                        version = "[" + version + "]";
                    }
                    if ((versionRange = VersionRange.createFromVersionSpec((String)version)).containsVersion((ArtifactVersion)(artifactVersion = new DefaultArtifactVersion(pluginBundleVersion)))) continue;
                    throw new Exception("Required dependency " + pluginBundleIdentifier + " is installed, but it's version (" + pluginBundleVersion + ") does not comply to the required version (" + dependencyArtifact.getVersion() + ")");
                }
                LOGGER.info("Skipping strict dependency checking for dependency " + dependencyArtifact.getArtifactId());
                continue;
            }
            try {
                MavenPluginLocation mavenPluginLocation = this.mavenPluginRepository.getPluginLocation(dependencyArtifact.getGroupId(), dependencyArtifact.getArtifactId());
                Path depJarFile = mavenPluginLocation.getVersionJar(dependencyArtifact.getVersion());
                FileJarClassLoader jarClassLoader = new FileJarClassLoader(this.pluginManager, delegatingClassLoader, depJarFile);
                this.jarClassLoaders.add(jarClassLoader);
                delegatingClassLoader.add(jarClassLoader);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("Required dependency " + pluginBundleIdentifier + " is not installed");
            }
        }
    }

    public PluginBundle loadFromPluginDir(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, SPluginBundleVersion pluginBundleVersion, List<SPluginInformation> plugins, boolean strictDependencyChecking) throws Exception {
        Path target = this.pluginsDir.resolve(pluginBundleVersionIdentifier.getFileName());
        if (!Files.exists(target, new LinkOption[0])) {
            throw new PluginException(target.toString() + " not found");
        }
        SPluginBundle sPluginBundle = new SPluginBundle();
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        Model model = null;
        JarFile jarFile = new JarFile(target.toFile());
        Object object = null;
        try {
            ZipEntry entry = jarFile.getEntry("META-INF/maven/" + pluginBundleVersion.getGroupId() + "/" + pluginBundleVersion.getArtifactId() + "/pom.xml");
            try (InputStream inputStream = jarFile.getInputStream(entry);){
                model = mavenreader.read(inputStream);
            }
        }
        catch (Throwable entry) {
            object = entry;
            throw entry;
        }
        finally {
            if (jarFile != null) {
                if (object != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable entry) {
                        ((Throwable)object).addSuppressed(entry);
                    }
                } else {
                    jarFile.close();
                }
            }
        }
        sPluginBundle.setOrganization(model.getOrganization().getName());
        sPluginBundle.setName(model.getName());
        DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(this.getClass().getClassLoader());
        this.loadDependencies(model.getVersion(), strictDependencyChecking, model, delegatingClassLoader);
        for (org.apache.maven.model.Dependency dependency : model.getDependencies()) {
            if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase") || dependency.getArtifactId().equals("ifcplugins"))) continue;
            PluginBundleIdentifier pluginBundleIdentifier = new PluginBundleIdentifier(dependency.getGroupId(), dependency.getArtifactId());
            if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleIdentifier)) {
                if (strictDependencyChecking) {
                    String version;
                    DefaultArtifactVersion artifactVersion;
                    VersionRange versionRange = VersionRange.createFromVersion((String)dependency.getVersion());
                    if (versionRange.containsVersion((ArtifactVersion)(artifactVersion = new DefaultArtifactVersion(version = this.pluginBundleIdentifierToPluginBundle.get(pluginBundleIdentifier).getPluginBundleVersion().getVersion())))) continue;
                    throw new Exception("Required dependency " + pluginBundleIdentifier + " is installed, but it's version (" + version + ") does not comply to the required version (" + dependency.getVersion() + ")");
                }
                LOGGER.info("Skipping strict dependency checking for dependency " + dependency.getArtifactId());
                continue;
            }
            if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase"))) continue;
            MavenPluginLocation mavenPluginLocation = this.mavenPluginRepository.getPluginLocation(dependency.getGroupId(), dependency.getArtifactId());
            try {
                Path depJarFile = mavenPluginLocation.getVersionJar(dependency.getVersion());
                FileJarClassLoader jarClassLoader = new FileJarClassLoader(this.pluginManager, delegatingClassLoader, depJarFile);
                this.jarClassLoaders.add(jarClassLoader);
                delegatingClassLoader.add(jarClassLoader);
            }
            catch (Exception exception) {}
        }
        return this.loadPlugin(pluginBundleVersionIdentifier, target, sPluginBundle, pluginBundleVersion, plugins, delegatingClassLoader);
    }

    private PluginBundle loadPlugins(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, ResourceLoader resourceLoader, ClassLoader classLoader, URI location, String classLocation, PluginDescriptor pluginDescriptor, PluginSourceType pluginType, Set<Dependency> dependencies, SPluginBundle sPluginBundle, SPluginBundleVersion sPluginBundleVersion) throws PluginException {
        sPluginBundle.setInstalledVersion(sPluginBundleVersion);
        PluginBundleImpl pluginBundle = new PluginBundleImpl(pluginBundleVersionIdentifier, sPluginBundle, sPluginBundleVersion, pluginDescriptor);
        if (classLoader != null && classLoader instanceof Closeable) {
            pluginBundle.addCloseable((Closeable)((Object)classLoader));
        }
        for (AbstractPlugin pluginImplementation : pluginDescriptor.getPlugins()) {
            if (pluginImplementation instanceof JavaPlugin) {
                JavaPlugin javaPlugin = (JavaPlugin)pluginImplementation;
                String interfaceClassName = javaPlugin.getInterfaceClass().trim().replace("\n", "");
                try {
                    Class<?> interfaceClass = this.getClass().getClassLoader().loadClass(interfaceClassName);
                    if (javaPlugin.getImplementationClass() == null) continue;
                    String implementationClassName = javaPlugin.getImplementationClass().trim().replace("\n", "");
                    try {
                        Class<?> implementationClass = classLoader.loadClass(implementationClassName);
                        Plugin plugin = (Plugin)implementationClass.newInstance();
                        pluginBundle.add(this.pluginManager.loadPlugin(pluginBundle, interfaceClass, location, classLocation, plugin, classLoader, pluginType, pluginImplementation, dependencies, plugin.getClass().getName()));
                        continue;
                    }
                    catch (NoClassDefFoundError e) {
                        throw new PluginException("Implementation class '" + implementationClassName + "' not found", (Throwable)e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PluginException("Implementation class '" + e.getMessage() + "' not found in " + location, (Throwable)e);
                    }
                    catch (InstantiationException e) {
                        throw new PluginException((Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PluginException((Throwable)e);
                    }
                }
                catch (ClassNotFoundException e) {
                    throw new PluginException("Interface class '" + interfaceClassName + "' not found", (Throwable)e);
                }
                catch (Error e) {
                    throw new PluginException((Throwable)e);
                }
            }
            if (!(pluginImplementation instanceof org.bimserver.plugins.WebModulePlugin)) continue;
            org.bimserver.plugins.WebModulePlugin webModulePlugin = (org.bimserver.plugins.WebModulePlugin)pluginImplementation;
            JsonWebModule jsonWebModule = new JsonWebModule(webModulePlugin);
            pluginBundle.add(this.pluginManager.loadPlugin(pluginBundle, WebModulePlugin.class, location, classLocation, jsonWebModule, classLoader, pluginType, pluginImplementation, dependencies, webModulePlugin.getIdentifier()));
        }
        this.pluginBundleIdentifierToPluginBundle.put(pluginBundleVersionIdentifier.getPluginBundleIdentifier(), pluginBundle);
        this.pluginBundleVersionIdentifierToPluginBundle.put(pluginBundleVersionIdentifier, pluginBundle);
        this.pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier.put(pluginBundleVersionIdentifier.getPluginBundleIdentifier(), pluginBundleVersionIdentifier);
        return pluginBundle;
    }

    public PluginBundle loadPluginsFromJar(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, Path file, SPluginBundle sPluginBundle, SPluginBundleVersion pluginBundleVersion, ClassLoader parentClassLoader) throws PluginException {
        PluginBundleIdentifier pluginBundleIdentifier = pluginBundleVersionIdentifier.getPluginBundleIdentifier();
        if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleIdentifier)) {
            throw new PluginException("Plugin " + pluginBundleIdentifier.getHumanReadable() + " already loaded (version " + this.pluginBundleIdentifierToPluginBundle.get(pluginBundleIdentifier).getPluginBundleVersion().getVersion() + ")");
        }
        LOGGER.debug("Loading plugins from " + file.toString());
        if (!Files.exists(file, new LinkOption[0])) {
            throw new PluginException("Not a file: " + file.toString());
        }
        FileJarClassLoader jarClassLoader = null;
        try {
            jarClassLoader = new FileJarClassLoader(this.pluginManager, parentClassLoader, file);
            this.jarClassLoaders.add(jarClassLoader);
            final FileJarClassLoader finalLoader = jarClassLoader;
            URL resource = jarClassLoader.findResource("plugin/plugin.xml");
            if (resource == null) {
                throw new PluginException("No plugin/plugin.xml found in " + file.getFileName().toString());
            }
            PluginDescriptor pluginDescriptor = null;
            try (InputStream pluginStream = resource.openStream();){
                pluginDescriptor = this.pluginManager.getPluginDescriptor(pluginStream);
                if (pluginDescriptor == null) {
                    jarClassLoader.close();
                    throw new PluginException("No plugin descriptor could be created");
                }
            }
            LOGGER.debug(pluginDescriptor.toString());
            URI fileUri = file.toAbsolutePath().toUri();
            URI jarUri = new URI("jar:" + fileUri.toString());
            ResourceLoader resourceLoader = new ResourceLoader(){

                @Override
                public InputStream load(String name) {
                    return finalLoader.getResourceAsStream(name);
                }
            };
            return this.loadPlugins(pluginBundleVersionIdentifier, resourceLoader, jarClassLoader, jarUri, file.toAbsolutePath().toString(), pluginDescriptor, PluginSourceType.JAR_FILE, new HashSet<Dependency>(), sPluginBundle, pluginBundleVersion);
        }
        catch (Exception e) {
            if (jarClassLoader != null) {
                try {
                    jarClassLoader.close();
                }
                catch (IOException e1) {
                    LOGGER.error("", (Throwable)e1);
                }
            }
            throw new PluginException((Throwable)e);
        }
    }

    public PluginBundle loadJavaProject(Path projectRoot, Path pomFile, final Path pluginFolder, PluginDescriptor pluginDescriptor, boolean resolveRemoteDependencies) throws PluginException, FileNotFoundException, IOException, XmlPullParserException {
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        Model model = null;
        try (FileReader reader = new FileReader(pomFile.toFile());){
            model = mavenreader.read((Reader)reader);
        }
        PluginBundleVersionIdentifier pluginBundleVersionIdentifier = new PluginBundleVersionIdentifier(model.getGroupId(), model.getArtifactId(), model.getVersion());
        if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleVersionIdentifier.getPluginBundleIdentifier())) {
            throw new PluginException("Plugin " + pluginBundleVersionIdentifier.getPluginBundleIdentifier().getHumanReadable() + " already loaded (version " + this.pluginBundleIdentifierToPluginBundle.get(pluginBundleVersionIdentifier.getPluginBundleIdentifier()).getPluginBundleVersion().getVersion() + ")");
        }
        DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(this.getClass().getClassLoader());
        PublicFindClassClassLoader previous = new PublicFindClassClassLoader(this.getClass().getClassLoader()){

            @Override
            public Class<?> findClass(String name) throws ClassNotFoundException {
                return null;
            }

            @Override
            public URL findResource(String name) {
                return null;
            }

            @Override
            public void dumpStructure(int indent) {
            }
        };
        HashSet<Dependency> bimServerDependencies = new HashSet<Dependency>();
        pluginBundleVersionIdentifier = new PluginBundleVersionIdentifier(new PluginBundleIdentifier(model.getGroupId(), model.getArtifactId()), model.getVersion());
        previous = this.loadDependencies(bimServerDependencies, model, previous, resolveRemoteDependencies);
        delegatingClassLoader.add(previous);
        EclipsePluginClassloader pluginClassloader = new EclipsePluginClassloader(delegatingClassLoader, projectRoot);
        ResourceLoader resourceLoader = new ResourceLoader(){

            @Override
            public InputStream load(String name) {
                try {
                    return Files.newInputStream(pluginFolder.resolve(name), new OpenOption[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        SPluginBundle sPluginBundle = new SPluginBundle();
        if (model.getOrganization() == null) {
            throw new PluginException("Plugis are required to have an organization in the pom.xml file");
        }
        sPluginBundle.setOrganization(model.getOrganization().getName());
        sPluginBundle.setName(model.getName());
        SPluginBundleVersion sPluginBundleVersion = this.createPluginBundleVersionFromMavenModel(model, true);
        Path icon = projectRoot.resolve("icon.png");
        if (Files.exists(icon, new LinkOption[0])) {
            byte[] iconBytes = Files.readAllBytes(icon);
            sPluginBundleVersion.setIcon(iconBytes);
        }
        sPluginBundle.setInstalledVersion(sPluginBundleVersion);
        return this.loadPlugins(pluginBundleVersionIdentifier, resourceLoader, pluginClassloader, projectRoot.toUri(), projectRoot.resolve("target/classes").toString(), pluginDescriptor, PluginSourceType.ECLIPSE_PROJECT, bimServerDependencies, sPluginBundle, sPluginBundleVersion);
    }

    public PluginBundle loadPluginsFromEclipseProject(Path projectRoot) throws PluginException {
        try {
            if (!Files.isDirectory(projectRoot, new LinkOption[0])) {
                throw new PluginException("No directory: " + projectRoot.toString());
            }
            Path pluginFolder = projectRoot.resolve("plugin");
            if (!Files.isDirectory(pluginFolder, new LinkOption[0])) {
                throw new PluginException("No 'plugin' directory found in " + projectRoot.toString());
            }
            Path pluginFile = pluginFolder.resolve("plugin.xml");
            if (!Files.exists(pluginFile, new LinkOption[0])) {
                throw new PluginException("No 'plugin.xml' found in " + pluginFolder.toString());
            }
            PluginDescriptor pluginDescriptor = null;
            try (InputStream newInputStream = Files.newInputStream(pluginFile, new OpenOption[0]);){
                pluginDescriptor = this.pluginManager.getPluginDescriptor(newInputStream);
            }
            Path pomFile = projectRoot.resolve("pom.xml");
            if (!Files.exists(pomFile, new LinkOption[0])) {
                throw new PluginException("No pom.xml found in " + projectRoot);
            }
            PluginBundle pluginBundle = this.loadJavaProject(projectRoot, pomFile, pluginFolder, pluginDescriptor, false);
            ArrayList<SPluginInformation> plugins = new ArrayList<SPluginInformation>();
            this.pluginManager.processPluginDescriptor(pluginDescriptor, plugins);
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                sPluginInformation.setInstallForAllUsers(true);
                sPluginInformation.setInstallForNewUsers(true);
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                if (pluginContext != null) continue;
                throw new PluginException("No plugin context found for " + sPluginInformation.getIdentifier());
            }
            try {
                long pluginBundleVersionId = this.pluginManager.pluginBundleInstalled(pluginBundle);
                for (SPluginInformation sPluginInformation : plugins) {
                    if (!sPluginInformation.isEnabled()) continue;
                    PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                    this.pluginManager.pluginInstalled(pluginBundleVersionId, pluginContext, sPluginInformation);
                }
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
                throw new PluginException((Throwable)e);
            }
            return pluginBundle;
        }
        catch (JAXBException e) {
            throw new PluginException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new PluginException((Throwable)e);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new PluginException((Throwable)e);
        }
    }

    private PublicFindClassClassLoader loadDependencies(Set<Dependency> bimServerDependencies, Model model, PublicFindClassClassLoader previous, boolean resolveRemoteDependencies) throws FileNotFoundException, IOException {
        List dependencies = model.getDependencies();
        Iterator it = dependencies.iterator();
        Path workspaceDir = Paths.get("..", new String[0]);
        bimServerDependencies.add(new Dependency(workspaceDir.resolve("PluginBase/target/classes")));
        bimServerDependencies.add(new Dependency(workspaceDir.resolve("Shared/target/classes")));
        while (it.hasNext()) {
            org.apache.maven.model.Dependency depend = (org.apache.maven.model.Dependency)it.next();
            try {
                ArtifactResult resolveArtifact;
                ArtifactRequest request;
                if (depend.getGroupId().equals("org.opensourcebim") && (depend.getArtifactId().equals("shared") || depend.getArtifactId().equals("pluginbase") || depend.getArtifactId().equals("ifcplugins")) || depend.isOptional() || "test".equals(depend.getScope())) continue;
                org.eclipse.aether.graph.Dependency dependency2 = new org.eclipse.aether.graph.Dependency((Artifact)new DefaultArtifact(depend.getGroupId() + ":" + depend.getArtifactId() + ":jar:" + depend.getVersion()), "compile");
                DelegatingClassLoader depDelLoader = new DelegatingClassLoader(previous);
                if (!dependency2.getArtifact().isSnapshot()) {
                    if (dependency2.getArtifact().getFile() != null) {
                        bimServerDependencies.add(new Dependency(dependency2.getArtifact().getFile().toPath()));
                        this.loadDependencies(dependency2.getArtifact().getFile().toPath(), depDelLoader);
                    } else {
                        request = new ArtifactRequest();
                        request.setArtifact(dependency2.getArtifact());
                        request.setRepositories(resolveRemoteDependencies ? this.mavenPluginRepository.getRepositoriesAsList() : this.mavenPluginRepository.getLocalRepositories());
                        try {
                            resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
                            if (resolveArtifact.getArtifact().getFile() != null) {
                                bimServerDependencies.add(new Dependency(resolveArtifact.getArtifact().getFile().toPath()));
                                this.loadDependencies(resolveArtifact.getArtifact().getFile().toPath(), depDelLoader);
                            }
                        }
                        catch (ArtifactResolutionException e) {
                            LOGGER.error(model.getGroupId() + "." + model.getArtifactId(), (Throwable)e);
                        }
                    }
                } else {
                    request = new ArtifactRequest();
                    if (!"test".equals(dependency2.getScope()) && !dependency2.getArtifact().isSnapshot()) {
                        request.setArtifact(dependency2.getArtifact());
                        request.setRepositories(this.mavenPluginRepository.getLocalRepositories());
                        try {
                            resolveArtifact = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), request);
                            if (resolveArtifact.getArtifact().getFile() != null) {
                                bimServerDependencies.add(new Dependency(resolveArtifact.getArtifact().getFile().toPath()));
                                this.loadDependencies(resolveArtifact.getArtifact().getFile().toPath(), depDelLoader);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.info(dependency2.getArtifact().toString());
                            e.printStackTrace();
                        }
                    }
                }
                ArtifactDescriptorRequest descriptorRequest = new ArtifactDescriptorRequest();
                descriptorRequest.setArtifact(dependency2.getArtifact());
                descriptorRequest.setRepositories(this.mavenPluginRepository.getRepositoriesAsList());
                ArtifactDescriptorResult descriptorResult = this.mavenPluginRepository.getSystem().readArtifactDescriptor(this.mavenPluginRepository.getSession(), descriptorRequest);
                CollectRequest collectRequest = new CollectRequest();
                collectRequest.setRootArtifact(descriptorResult.getArtifact());
                collectRequest.setDependencies(descriptorResult.getDependencies());
                collectRequest.setManagedDependencies(descriptorResult.getManagedDependencies());
                collectRequest.setRepositories(descriptorResult.getRepositories());
                DependencyNode node = this.mavenPluginRepository.getSystem().collectDependencies(this.mavenPluginRepository.getSession(), collectRequest).getRoot();
                DependencyRequest dependencyRequest = new DependencyRequest();
                dependencyRequest.setRoot(node);
                CollectResult collectResult = this.mavenPluginRepository.getSystem().collectDependencies(this.mavenPluginRepository.getSession(), collectRequest);
                PreorderNodeListGenerator nlg = new PreorderNodeListGenerator();
                collectResult.getRoot().accept((DependencyVisitor)nlg);
                try {
                    this.mavenPluginRepository.getSystem().resolveDependencies(this.mavenPluginRepository.getSession(), dependencyRequest);
                }
                catch (DependencyResolutionException dependencyResolutionException) {
                    // empty catch block
                }
                for (DependencyNode dependencyNode : nlg.getNodes()) {
                    ArtifactRequest newRequest = new ArtifactRequest(dependencyNode);
                    newRequest.setRepositories(this.mavenPluginRepository.getRepositoriesAsList());
                    ArtifactResult resolveArtifact2 = this.mavenPluginRepository.getSystem().resolveArtifact(this.mavenPluginRepository.getSession(), newRequest);
                    Artifact artifact = resolveArtifact2.getArtifact();
                    Path jarFile = Paths.get(artifact.getFile().getAbsolutePath(), new String[0]);
                    this.loadDependencies(jarFile, depDelLoader);
                    DefaultArtifact versionArtifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
                    ArtifactRequest request2 = new ArtifactRequest();
                    request2.setArtifact((Artifact)versionArtifact);
                    request2.setRepositories(this.mavenPluginRepository.getRepositoriesAsList());
                    bimServerDependencies.add(new Dependency(jarFile));
                }
                previous = depDelLoader;
            }
            catch (DependencyCollectionException e) {
                e.printStackTrace();
            }
            catch (ArtifactDescriptorException e2) {
                e2.printStackTrace();
            }
            catch (ArtifactResolutionException e) {
                e.printStackTrace();
            }
        }
        return previous;
    }

    private void loadDependencies(Path libFile, DelegatingClassLoader classLoader) throws FileNotFoundException, IOException {
        if (libFile.getFileName().toString().toLowerCase().endsWith(".jar")) {
            FileJarClassLoader jarClassLoader = new FileJarClassLoader(this.pluginManager, classLoader, libFile);
            this.jarClassLoaders.add(jarClassLoader);
            classLoader.add(jarClassLoader);
        }
    }

    public void loadPluginsFromEclipseProjectNoExceptions(Path projectRoot) {
        try {
            this.loadPluginsFromEclipseProject(projectRoot);
        }
        catch (PluginException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public void loadAllPluginsFromEclipseWorkspace(Path file, boolean showExceptions) throws PluginException, IOException {
        if (file != null && Files.isDirectory(file, new LinkOption[0])) {
            for (Path project : PathUtils.list((Path)file)) {
                Path pluginFile;
                Path pluginDir;
                if (!Files.isDirectory(project, new LinkOption[0]) || !Files.exists(pluginDir = project.resolve("plugin"), new LinkOption[0]) || !Files.exists(pluginFile = pluginDir.resolve("plugin.xml"), new LinkOption[0])) continue;
                if (showExceptions) {
                    this.loadPluginsFromEclipseProject(project);
                    continue;
                }
                this.loadPluginsFromEclipseProjectNoExceptions(project);
            }
        }
    }

    public void loadAllPluginsFromEclipseWorkspaces(Path directory, boolean showExceptions) throws PluginException, IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        if (Files.exists(directory.resolve("plugin/plugin.xml"), new LinkOption[0])) {
            if (showExceptions) {
                this.loadPluginsFromEclipseProject(directory);
            } else {
                this.loadPluginsFromEclipseProjectNoExceptions(directory);
            }
        }
        this.loadAllPluginsFromEclipseWorkspace(directory, showExceptions);
        for (Path workspace : PathUtils.list((Path)directory)) {
            if (!Files.isDirectory(workspace, new LinkOption[0])) continue;
            this.loadAllPluginsFromEclipseWorkspace(workspace, showExceptions);
        }
    }

    public PluginBundle loadPlugin(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, Path target, SPluginBundle sPluginBundle, SPluginBundleVersion pluginBundleVersion, List<SPluginInformation> plugins, ClassLoader parentClassLoader) throws Exception {
        PluginBundle pluginBundle = null;
        try {
            pluginBundle = this.loadPluginsFromJar(pluginBundleVersionIdentifier, target, sPluginBundle, pluginBundleVersion, parentClassLoader);
            if (plugins.isEmpty()) {
                LOGGER.warn("No plugins given to install for bundle " + sPluginBundle.getName());
            }
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                if (pluginContext == null) {
                    LOGGER.info("No plugin context found for " + sPluginInformation.getIdentifier());
                    continue;
                }
                PluginConfiguration pluginConfiguration = PluginConfiguration.fromDefaults((ObjectDefinition)pluginContext.getPlugin().getSystemSettingsDefinition());
                pluginContext.initialize(pluginConfiguration);
            }
        }
        catch (Exception e) {
            if (pluginBundle != null) {
                pluginBundle.close();
            }
            this.pluginBundleVersionIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier);
            this.pluginBundleIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
            Files.deleteIfExists(target);
            throw e;
        }
        try {
            long pluginBundleVersionId = this.pluginManager.pluginBundleInstalled(pluginBundle);
            for (SPluginInformation sPluginInformation : plugins) {
                PluginContext pluginContext;
                if (!sPluginInformation.isEnabled() || (pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier())) == null) continue;
                this.pluginManager.pluginInstalled(pluginBundleVersionId, pluginContext, sPluginInformation);
            }
            return pluginBundle;
        }
        catch (Exception e) {
            this.uninstall(pluginBundleVersionIdentifier);
            LOGGER.error("", (Throwable)e);
            throw e;
        }
    }

    public void uninstall(PluginBundleVersionIdentifier pluginBundleVersionIdentifier) {
        PluginBundle pluginBundle = this.pluginBundleVersionIdentifierToPluginBundle.get(pluginBundleVersionIdentifier);
        if (pluginBundle == null) {
            return;
        }
        try {
            pluginBundle.close();
            this.pluginBundleVersionIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier);
            this.pluginBundleIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
            this.pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
            for (PluginContext pluginContext : pluginBundle) {
                this.pluginManager.removeImplementation(pluginContext);
            }
            Path target = this.pluginsDir.resolve(pluginBundleVersionIdentifier.getFileName());
            Files.delete(target);
            for (PluginContext pluginContext : pluginBundle) {
                this.pluginManager.pluginUninstalled(pluginContext);
            }
            this.pluginManager.pluginBundleUninstalled(pluginBundle);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
    }

    public PluginBundle update(PluginBundleVersionIdentifier pluginBundleVersionIdentifier, SPluginBundle sPluginBundle, SPluginBundleVersion pluginBundleVersion, Path jarFile, Path pomFile, List<SPluginInformation> plugins) throws Exception {
        PluginBundle existingPluginBundle = this.pluginBundleIdentifierToPluginBundle.get(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
        if (existingPluginBundle == null) {
            throw new UserException("No previous version of plugin bundle " + pluginBundleVersionIdentifier.getPluginBundleIdentifier() + " found");
        }
        try {
            existingPluginBundle.close();
            if (this.pluginBundleIdentifierToPluginBundle.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier()) == null) {
                LOGGER.warn("Previous version of " + pluginBundleVersionIdentifier.getPluginBundleIdentifier() + " not found");
            }
            PluginBundleVersionIdentifier currentVersion = this.pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier.get(pluginBundleVersionIdentifier.getPluginBundleIdentifier());
            if (this.pluginBundleIdentifierToCurrentPluginBundleVersionIdentifier.remove(pluginBundleVersionIdentifier.getPluginBundleIdentifier()) == null) {
                LOGGER.warn("Previous version of " + pluginBundleVersionIdentifier.getPluginBundleIdentifier() + " not found");
            }
            if (this.pluginBundleVersionIdentifierToPluginBundle.remove(currentVersion) == null) {
                LOGGER.warn("Previous version (" + currentVersion + ") of " + pluginBundleVersionIdentifier.getPluginBundleIdentifier() + " not found");
            }
            for (PluginContext pluginContext : existingPluginBundle) {
                this.pluginManager.removeImplementation(pluginContext);
            }
            if (existingPluginBundle.getPluginBundle().getInstalledVersion().getType() == SPluginBundleType.MAVEN) {
                Path target = this.pluginsDir.resolve(currentVersion.getFileName());
                Files.delete(target);
            }
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        Path target = this.pluginsDir.resolve(pluginBundleVersionIdentifier.getFileName());
        if (Files.exists(target, new LinkOption[0])) {
            throw new PluginException("This plugin has already been installed " + target.getFileName().toString());
        }
        Files.copy(jarFile, target, new CopyOption[0]);
        MavenXpp3Reader mavenreader = new MavenXpp3Reader();
        Model model = null;
        FileReader fileReader = new FileReader(pomFile.toFile());
        Object object = null;
        try {
            model = mavenreader.read((Reader)fileReader);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fileReader != null) {
                if (object != null) {
                    try {
                        fileReader.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fileReader.close();
                }
            }
        }
        DelegatingClassLoader delegatingClassLoader = new DelegatingClassLoader(this.getClass().getClassLoader());
        for (Object dependency : model.getDependencies()) {
            if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase"))) continue;
            PluginBundleIdentifier pluginBundleIdentifier = new PluginBundleIdentifier(dependency.getGroupId(), dependency.getArtifactId());
            if (this.pluginBundleIdentifierToPluginBundle.containsKey(pluginBundleIdentifier)) {
                LOGGER.info("Skipping strict dependency checking for dependency " + dependency.getArtifactId());
                continue;
            }
            if (dependency.getGroupId().equals("org.opensourcebim") && (dependency.getArtifactId().equals("shared") || dependency.getArtifactId().equals("pluginbase"))) {
                throw new Exception("Required dependency " + pluginBundleIdentifier + " is not installed");
            }
            MavenPluginLocation mavenPluginLocation = this.mavenPluginRepository.getPluginLocation(((Repository)model.getRepositories().get(0)).getUrl(), dependency.getGroupId(), dependency.getArtifactId());
            try {
                Path depJarFile = mavenPluginLocation.getVersionJar(dependency.getVersion());
                FileJarClassLoader jarClassLoader = new FileJarClassLoader(this.pluginManager, delegatingClassLoader, depJarFile);
                this.jarClassLoaders.add(jarClassLoader);
                delegatingClassLoader.add(jarClassLoader);
            }
            catch (Exception depJarFile) {}
        }
        PluginBundle pluginBundle = null;
        try {
            pluginBundle = this.loadPluginsFromJar(pluginBundleVersionIdentifier, target, sPluginBundle, pluginBundleVersion, delegatingClassLoader);
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                PluginContext previousContext = existingPluginBundle.getPluginContext(pluginContext.getIdentifier());
                pluginContext.getPlugin().init(pluginContext, previousContext == null ? null : previousContext.getSystemSettings());
            }
        }
        catch (Exception e) {
            Files.delete(target);
            LOGGER.error("", (Throwable)e);
            throw e;
        }
        try {
            long pluginBundleVersionId = this.pluginManager.pluginBundleUpdated(pluginBundle);
            for (SPluginInformation sPluginInformation : plugins) {
                if (!sPluginInformation.isEnabled()) continue;
                PluginContext pluginContext = pluginBundle.getPluginContext(sPluginInformation.getIdentifier());
                this.pluginManager.pluginUpdated(pluginBundleVersionId, pluginContext, sPluginInformation);
            }
            return pluginBundle;
        }
        catch (Exception e) {
            this.uninstall(pluginBundleVersionIdentifier);
            LOGGER.error("", (Throwable)e);
            throw e;
        }
    }

    public PluginBundle getPluginBundle(PluginBundleIdentifier pluginIdentifier) {
        return this.pluginBundleIdentifierToPluginBundle.get(pluginIdentifier);
    }

    public Collection<PluginBundle> getPluginBundles() {
        return this.pluginBundleVersionIdentifierToPluginBundle.values();
    }

    @Override
    public void close() {
        for (FileJarClassLoader fileJarClassLoader : this.jarClassLoaders) {
            try {
                fileJarClassLoader.close();
            }
            catch (IOException e) {
                LOGGER.error("", (Throwable)e);
            }
        }
    }

    private SPluginBundleVersion createPluginBundleVersionFromMavenModel(Model model, boolean isLocalDev) {
        SPluginBundleVersion sPluginBundleVersion = new SPluginBundleVersion();
        sPluginBundleVersion.setType(isLocalDev ? SPluginBundleType.LOCAL_DEV : SPluginBundleType.MAVEN);
        sPluginBundleVersion.setGroupId(model.getGroupId());
        sPluginBundleVersion.setArtifactId(model.getArtifactId());
        sPluginBundleVersion.setVersion(model.getVersion());
        sPluginBundleVersion.setDescription(model.getDescription());
        sPluginBundleVersion.setRepository("local");
        sPluginBundleVersion.setMismatch(false);
        sPluginBundleVersion.setOrganization(model.getOrganization().getName());
        sPluginBundleVersion.setName(model.getName());
        return sPluginBundleVersion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SPluginBundle extractPluginBundleFromJar(Path jarFilePath) throws PluginException {
        String filename = jarFilePath.getFileName().toString();
        PluginBundleVersionIdentifier pluginBundleVersionIdentifier = PluginBundleVersionIdentifier.fromFileName((String)filename);
        try (JarFile jarFile = new JarFile(jarFilePath.toFile());){
            String pomLocation = "META-INF/maven/" + pluginBundleVersionIdentifier.getPluginBundleIdentifier().getGroupId() + "/" + pluginBundleVersionIdentifier.getPluginBundleIdentifier().getArtifactId() + "/pom.xml";
            ZipEntry pomEntry = jarFile.getEntry(pomLocation);
            if (pomEntry == null) {
                throw new PluginException("No pom.xml found in JAR file " + jarFilePath.toString() + ", " + pomLocation);
            }
            MavenXpp3Reader mavenreader = new MavenXpp3Reader();
            Model model = mavenreader.read(jarFile.getInputStream(pomEntry));
            SPluginBundle sPluginBundle = new SPluginBundle();
            sPluginBundle.setOrganization(model.getOrganization().getName());
            sPluginBundle.setName(model.getName());
            SPluginBundle sPluginBundle2 = sPluginBundle;
            return sPluginBundle2;
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
        catch (XmlPullParserException e) {
            throw new PluginException((Throwable)e);
        }
    }
}

