/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.plugins;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.bimserver.BimserverDatabaseException;
import org.bimserver.emf.MetaDataManager;
import org.bimserver.emf.Schema;
import org.bimserver.interfaces.objects.SPluginInformation;
import org.bimserver.interfaces.objects.SPluginType;
import org.bimserver.models.store.Parameter;
import org.bimserver.models.store.ServiceDescriptor;
import org.bimserver.plugins.AbstractPlugin;
import org.bimserver.plugins.BasicServerInfo;
import org.bimserver.plugins.BasicServerInfoProvider;
import org.bimserver.plugins.Dependency;
import org.bimserver.plugins.JavaPlugin;
import org.bimserver.plugins.NotificationsManagerInterface;
import org.bimserver.plugins.Plugin;
import org.bimserver.plugins.PluginBundle;
import org.bimserver.plugins.PluginChangeListener;
import org.bimserver.plugins.PluginContext;
import org.bimserver.plugins.PluginDescriptor;
import org.bimserver.plugins.PluginManagerInterface;
import org.bimserver.plugins.PluginSourceType;
import org.bimserver.plugins.deserializers.DeserializeException;
import org.bimserver.plugins.deserializers.DeserializerPlugin;
import org.bimserver.plugins.deserializers.StreamingDeserializerPlugin;
import org.bimserver.plugins.modelchecker.ModelCheckerPlugin;
import org.bimserver.plugins.modelcompare.ModelComparePlugin;
import org.bimserver.plugins.modelmerger.ModelMergerPlugin;
import org.bimserver.plugins.queryengine.QueryEnginePlugin;
import org.bimserver.plugins.renderengine.RenderEnginePlugin;
import org.bimserver.plugins.serializers.MessagingSerializerPlugin;
import org.bimserver.plugins.serializers.MessagingStreamingSerializerPlugin;
import org.bimserver.plugins.serializers.SerializerPlugin;
import org.bimserver.plugins.serializers.StreamingSerializerPlugin;
import org.bimserver.plugins.services.BimServerClientInterface;
import org.bimserver.plugins.services.NewExtendedDataOnProjectHandler;
import org.bimserver.plugins.services.NewExtendedDataOnRevisionHandler;
import org.bimserver.plugins.services.NewRevisionHandler;
import org.bimserver.plugins.services.ServicePlugin;
import org.bimserver.plugins.stillimagerenderer.StillImageRenderPlugin;
import org.bimserver.plugins.web.WebModulePlugin;
import org.bimserver.shared.AuthenticationInfo;
import org.bimserver.shared.BimServerClientFactory;
import org.bimserver.shared.ChannelConnectionException;
import org.bimserver.shared.PluginClassLoaderProvider;
import org.bimserver.shared.ServiceFactory;
import org.bimserver.shared.exceptions.PluginException;
import org.bimserver.shared.exceptions.ServiceException;
import org.bimserver.shared.meta.SServicesMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager
implements PluginManagerInterface,
PluginClassLoaderProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private static Unmarshaller PLUGIN_DESCRIPTOR_UNMARSHALLER;
    private final Map<Class<? extends Plugin>, Set<PluginContext>> implementations = new LinkedHashMap<Class<? extends Plugin>, Set<PluginContext>>();
    private final Map<Plugin, PluginContext> pluginToPluginContext = new HashMap<Plugin, PluginContext>();
    private final Path tempDir;
    private final String baseClassPath;
    private final ServiceFactory serviceFactory;
    private final NotificationsManagerInterface notificationsManagerInterface;
    private final SServicesMap servicesMap;
    private PluginChangeListener pluginChangeListener;
    private BimServerClientFactory bimServerClientFactory;
    private MetaDataManager metaDataManager;
    private BasicServerInfoProvider basicServerInfoProvider;

    public PluginManager(Path tempDir, String baseClassPath, ServiceFactory serviceFactory, NotificationsManagerInterface notificationsManagerInterface, SServicesMap servicesMap, BasicServerInfoProvider basicServerInfoProvider) {
        this.basicServerInfoProvider = basicServerInfoProvider;
        LOGGER.debug("Creating new PluginManager");
        this.tempDir = tempDir;
        this.baseClassPath = baseClassPath;
        this.serviceFactory = serviceFactory;
        this.notificationsManagerInterface = notificationsManagerInterface;
        this.servicesMap = servicesMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PluginDescriptor getPluginDescriptor(InputStream inputStream) throws JAXBException, IOException {
        try {
            PluginDescriptor pluginDescriptor;
            PluginDescriptor pluginDescriptor2 = pluginDescriptor = (PluginDescriptor)PLUGIN_DESCRIPTOR_UNMARSHALLER.unmarshal(inputStream);
            return pluginDescriptor2;
        }
        finally {
            inputStream.close();
        }
    }

    public PluginDescriptor getPluginDescriptor(byte[] bytes) throws JAXBException, IOException {
        return this.getPluginDescriptor(new ByteArrayInputStream(bytes));
    }

    private <T> Map<PluginContext, T> getPlugins(Class<T> requiredInterfaceClass, boolean onlyEnabled) {
        HashMap<PluginContext, Plugin> plugins = new HashMap<PluginContext, Plugin>();
        for (Class<? extends Plugin> interfaceClass : this.implementations.keySet()) {
            if (!requiredInterfaceClass.isAssignableFrom(interfaceClass)) continue;
            for (PluginContext pluginContext : this.implementations.get(interfaceClass)) {
                if (onlyEnabled && !pluginContext.isEnabled()) continue;
                plugins.put(pluginContext, pluginContext.getPlugin());
            }
        }
        return plugins;
    }

    public Map<PluginContext, RenderEnginePlugin> getAllRenderEnginePlugins(boolean onlyEnabled) {
        return this.getPlugins(RenderEnginePlugin.class, onlyEnabled);
    }

    public Map<PluginContext, StillImageRenderPlugin> getAllStillImageRenderPlugins(boolean onlyEnabled) {
        return this.getPlugins(StillImageRenderPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, QueryEnginePlugin> getAllQueryEnginePlugins(boolean onlyEnabled) {
        return this.getPlugins(QueryEnginePlugin.class, onlyEnabled);
    }

    public Map<PluginContext, SerializerPlugin> getAllSerializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(SerializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, MessagingSerializerPlugin> getAllMessagingSerializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(MessagingSerializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, MessagingStreamingSerializerPlugin> getAllMessagingStreamingSerializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(MessagingStreamingSerializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, DeserializerPlugin> getAllDeserializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(DeserializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, StreamingDeserializerPlugin> getAllStreamingDeserializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(StreamingDeserializerPlugin.class, onlyEnabled);
    }

    public Collection<StreamingDeserializerPlugin> getAllStreamingDeserializerPlugins(String extension, boolean onlyEnabled) {
        Collection<StreamingDeserializerPlugin> allDeserializerPlugins = this.getAllStreamingDeserializerPlugins(onlyEnabled).values();
        Iterator<StreamingDeserializerPlugin> iterator = allDeserializerPlugins.iterator();
        while (iterator.hasNext()) {
            StreamingDeserializerPlugin deserializerPlugin = iterator.next();
            if (deserializerPlugin.canHandleExtension(extension)) continue;
            iterator.remove();
        }
        return allDeserializerPlugins;
    }

    public Map<PluginContext, StreamingSerializerPlugin> getAllStreamingSeserializerPlugins(boolean onlyEnabled) {
        return this.getPlugins(StreamingSerializerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, Plugin> getAllPlugins(boolean onlyEnabled) {
        return this.getPlugins(Plugin.class, onlyEnabled);
    }

    public PluginContext getPluginContext(Plugin plugin) {
        PluginContext pluginContext = this.pluginToPluginContext.get(plugin);
        if (pluginContext == null) {
            throw new RuntimeException("No plugin context found for " + plugin);
        }
        return pluginContext;
    }

    public void enablePlugin(String name) {
        for (Set<PluginContext> pluginContexts : this.implementations.values()) {
            for (PluginContext pluginContext : pluginContexts) {
                if (!pluginContext.getPlugin().getClass().getName().equals(name)) continue;
                pluginContext.setEnabled(true, true);
            }
        }
    }

    public void disablePlugin(String name) {
        for (Set<PluginContext> pluginContexts : this.implementations.values()) {
            for (PluginContext pluginContext : pluginContexts) {
                if (!pluginContext.getPlugin().getClass().getName().equals(name)) continue;
                pluginContext.setEnabled(false, true);
            }
        }
    }

    public Plugin getPlugin(String identifier, boolean onlyEnabled) {
        for (Set<PluginContext> pluginContexts : this.implementations.values()) {
            for (PluginContext pluginContext : pluginContexts) {
                if (!pluginContext.getIdentifier().equals(identifier) || onlyEnabled && !pluginContext.isEnabled()) continue;
                return pluginContext.getPlugin();
            }
        }
        return null;
    }

    public boolean isEnabled(String className) {
        return this.getPlugin(className, true) != null;
    }

    public void setPluginChangeListener(PluginChangeListener pluginChangeListener) {
        this.pluginChangeListener = pluginChangeListener;
    }

    public Collection<DeserializerPlugin> getAllDeserializerPlugins(String extension, boolean onlyEnabled) {
        Collection<DeserializerPlugin> allDeserializerPlugins = this.getAllDeserializerPlugins(onlyEnabled).values();
        Iterator<DeserializerPlugin> iterator = allDeserializerPlugins.iterator();
        while (iterator.hasNext()) {
            DeserializerPlugin deserializerPlugin = iterator.next();
            if (deserializerPlugin.canHandleExtension(extension)) continue;
            iterator.remove();
        }
        return allDeserializerPlugins;
    }

    public DeserializerPlugin requireDeserializer(String extension) throws DeserializeException {
        Collection<DeserializerPlugin> allDeserializerPlugins = this.getAllDeserializerPlugins(extension, true);
        if (allDeserializerPlugins.size() == 0) {
            throw new DeserializeException("No deserializers found for type '" + extension + "'");
        }
        return allDeserializerPlugins.iterator().next();
    }

    public Path getTempDir() {
        if (!Files.isDirectory(this.tempDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.tempDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.tempDir;
    }

    public PluginContext loadPlugin(PluginBundle pluginBundle, Class<? extends Plugin> interfaceClass, URI location, String classLocation, Plugin plugin, ClassLoader classLoader, PluginSourceType pluginType, AbstractPlugin pluginImplementation, Set<Dependency> dependencies, String identifier) throws PluginException {
        LOGGER.debug("Loading plugin " + plugin.getClass().getSimpleName() + " of type " + interfaceClass.getSimpleName());
        if (!Plugin.class.isAssignableFrom(interfaceClass)) {
            throw new PluginException("Given interface class (" + interfaceClass.getName() + ") must be a subclass of " + Plugin.class.getName());
        }
        if (!this.implementations.containsKey(interfaceClass)) {
            this.implementations.put(interfaceClass, new LinkedHashSet());
        }
        Set<PluginContext> set = this.implementations.get(interfaceClass);
        try {
            PluginContext pluginContext = new PluginContext((PluginManagerInterface)this, pluginBundle, interfaceClass, classLoader, pluginType, pluginImplementation.getDescription(), location, plugin, classLocation, dependencies, identifier);
            this.pluginToPluginContext.put(plugin, pluginContext);
            set.add(pluginContext);
            return pluginContext;
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public void initAllLoadedPlugins() throws PluginException {
        LOGGER.debug("Initializig all loaded plugins");
        for (Class<? extends Plugin> pluginClass : this.implementations.keySet()) {
            Set<PluginContext> set = this.implementations.get(pluginClass);
            for (PluginContext pluginContext : set) {
                try {
                    pluginContext.initialize(pluginContext.getSystemSettings());
                }
                catch (Throwable e) {
                    LOGGER.error("", e);
                    pluginContext.setEnabled(false, false);
                }
            }
        }
    }

    public String getCompleteClassPath() {
        StringBuilder sb = new StringBuilder();
        if (this.baseClassPath != null) {
            sb.append(this.baseClassPath + File.pathSeparator);
        }
        for (Class<? extends Plugin> pluginClass : this.implementations.keySet()) {
            Set<PluginContext> set = this.implementations.get(pluginClass);
            for (PluginContext pluginContext : set) {
                sb.append(pluginContext.getClassLocation() + File.pathSeparator);
            }
        }
        return sb.toString();
    }

    public DeserializerPlugin getFirstDeserializer(String extension, Schema schema, boolean onlyEnabled) throws PluginException {
        Collection<DeserializerPlugin> allDeserializerPlugins = this.getAllDeserializerPlugins(extension, onlyEnabled);
        Iterator<DeserializerPlugin> iterator = allDeserializerPlugins.iterator();
        while (iterator.hasNext()) {
            DeserializerPlugin next = iterator.next();
            if (next.getSupportedSchemas().contains(schema)) continue;
            iterator.remove();
        }
        if (allDeserializerPlugins.size() == 0) {
            throw new PluginException("No deserializers with extension " + extension + " found");
        }
        return allDeserializerPlugins.iterator().next();
    }

    public StreamingDeserializerPlugin getFirstStreamingDeserializer(String extension, Schema schema, boolean onlyEnabled) throws PluginException {
        Collection<StreamingDeserializerPlugin> allDeserializerPlugins = this.getAllStreamingDeserializerPlugins(extension, onlyEnabled);
        Iterator<StreamingDeserializerPlugin> iterator = allDeserializerPlugins.iterator();
        while (iterator.hasNext()) {
            StreamingDeserializerPlugin next = iterator.next();
            if (next.getSupportedSchemas().contains(schema)) continue;
            iterator.remove();
        }
        if (allDeserializerPlugins.size() == 0) {
            throw new PluginException("No deserializers with extension " + extension + " found");
        }
        return allDeserializerPlugins.iterator().next();
    }

    public RenderEnginePlugin getRenderEnginePlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(RenderEnginePlugin.class, className, onlyEnabled);
    }

    private <T extends Plugin> T getPluginByClassName(Class<T> clazz, String className, boolean onlyEnabled) {
        Collection<T> allPlugins = this.getPlugins(clazz, onlyEnabled).values();
        for (Plugin t : allPlugins) {
            if (!t.getClass().getName().equals(className)) continue;
            return (T)t;
        }
        return null;
    }

    public QueryEnginePlugin getQueryEngine(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(QueryEnginePlugin.class, className, onlyEnabled);
    }

    public Map<PluginContext, ModelMergerPlugin> getAllModelMergerPlugins(boolean onlyEnabled) {
        return this.getPlugins(ModelMergerPlugin.class, onlyEnabled);
    }

    public Map<PluginContext, ModelComparePlugin> getAllModelComparePlugins(boolean onlyEnabled) {
        return this.getPlugins(ModelComparePlugin.class, onlyEnabled);
    }

    public ModelMergerPlugin getModelMergerPlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ModelMergerPlugin.class, className, onlyEnabled);
    }

    public ModelComparePlugin getModelComparePlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ModelComparePlugin.class, className, onlyEnabled);
    }

    public Map<PluginContext, ServicePlugin> getAllServicePlugins(boolean onlyEnabled) {
        return this.getPlugins(ServicePlugin.class, onlyEnabled);
    }

    public ServicePlugin getServicePlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ServicePlugin.class, className, onlyEnabled);
    }

    public ServiceFactory getServiceFactory() {
        return this.serviceFactory;
    }

    public void registerNewRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor, NewRevisionHandler newRevisionHandler) {
        if (this.notificationsManagerInterface != null) {
            this.notificationsManagerInterface.registerInternalNewRevisionHandler(uoid, serviceDescriptor, newRevisionHandler);
        }
    }

    public void unregisterNewRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor) {
        if (this.notificationsManagerInterface != null) {
            this.notificationsManagerInterface.unregisterInternalNewRevisionHandler(uoid, serviceDescriptor.getIdentifier());
        }
    }

    public SServicesMap getServicesMap() {
        return this.servicesMap;
    }

    public Parameter getParameter(PluginContext pluginContext, String name) {
        return null;
    }

    public SerializerPlugin getSerializerPlugin(String className, boolean onlyEnabled) {
        return (SerializerPlugin)this.getPlugin(className, onlyEnabled);
    }

    public MessagingSerializerPlugin getMessagingSerializerPlugin(String className, boolean onlyEnabled) {
        return (MessagingSerializerPlugin)this.getPlugin(className, onlyEnabled);
    }

    public WebModulePlugin getWebModulePlugin(String className, boolean onlyEnabled) {
        return (WebModulePlugin)this.getPlugin(className, onlyEnabled);
    }

    public Map<PluginContext, WebModulePlugin> getAllWebPlugins(boolean onlyEnabled) {
        return this.getPlugins(WebModulePlugin.class, onlyEnabled);
    }

    public Map<PluginContext, ModelCheckerPlugin> getAllModelCheckerPlugins(boolean onlyEnabled) {
        return this.getPlugins(ModelCheckerPlugin.class, onlyEnabled);
    }

    public ModelCheckerPlugin getModelCheckerPlugin(String className, boolean onlyEnabled) {
        return this.getPluginByClassName(ModelCheckerPlugin.class, className, onlyEnabled);
    }

    public BimServerClientInterface getLocalBimServerClientInterface(AuthenticationInfo tokenAuthentication) throws ServiceException, ChannelConnectionException {
        return this.bimServerClientFactory.create(tokenAuthentication);
    }

    public void setBimServerClientFactory(BimServerClientFactory bimServerClientFactory) {
        this.bimServerClientFactory = bimServerClientFactory;
    }

    public void registerNewExtendedDataOnProjectHandler(long uoid, ServiceDescriptor serviceDescriptor, NewExtendedDataOnProjectHandler newExtendedDataHandler) {
        if (this.notificationsManagerInterface != null) {
            this.notificationsManagerInterface.registerInternalNewExtendedDataOnProjectHandler(uoid, serviceDescriptor, newExtendedDataHandler);
        }
    }

    public void registerNewExtendedDataOnRevisionHandler(long uoid, ServiceDescriptor serviceDescriptor, NewExtendedDataOnRevisionHandler newExtendedDataHandler) {
        if (this.notificationsManagerInterface != null) {
            this.notificationsManagerInterface.registerInternalNewExtendedDataOnRevisionHandler(uoid, serviceDescriptor, newExtendedDataHandler);
        }
    }

    public DeserializerPlugin getDeserializerPlugin(String pluginClassName, boolean onlyEnabled) {
        return this.getPluginByClassName(DeserializerPlugin.class, pluginClassName, onlyEnabled);
    }

    public StreamingDeserializerPlugin getStreamingDeserializerPlugin(String pluginClassName, boolean onlyEnabled) {
        return this.getPluginByClassName(StreamingDeserializerPlugin.class, pluginClassName, onlyEnabled);
    }

    public StreamingSerializerPlugin getStreamingSerializerPlugin(String pluginClassName, boolean onlyEnabled) {
        return this.getPluginByClassName(StreamingSerializerPlugin.class, pluginClassName, onlyEnabled);
    }

    public MetaDataManager getMetaDataManager() {
        return this.metaDataManager;
    }

    public void setMetaDataManager(MetaDataManager metaDataManager) {
        this.metaDataManager = metaDataManager;
    }

    public FileSystem getOrCreateFileSystem(URI uri) throws IOException {
        FileSystem fileSystem = null;
        try {
            fileSystem = FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException e) {
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("create", "true");
            fileSystem = FileSystems.newFileSystem(uri, env, null);
            LOGGER.debug("Created VFS for " + uri);
        }
        return fileSystem;
    }

    public MessagingStreamingSerializerPlugin getMessagingStreamingSerializerPlugin(String className, boolean onlyEnabled) {
        return (MessagingStreamingSerializerPlugin)this.getPlugin(className, onlyEnabled);
    }

    public List<SPluginInformation> getPluginInformationFromJar(Path file) throws PluginException, FileNotFoundException, IOException, JAXBException {
        try (JarFile jarFile = new JarFile(file.toFile());){
            ZipEntry entry = jarFile.getEntry("plugin/plugin.xml");
            if (entry == null) {
                throw new PluginException("No plugin/plugin.xml found in " + file.getFileName().toString());
            }
            InputStream pluginStream = jarFile.getInputStream(entry);
            List<SPluginInformation> list = this.getPluginInformationFromPluginFile(pluginStream);
            return list;
        }
    }

    public List<SPluginInformation> getPluginInformationFromJar(InputStream jarInputStream) throws PluginException, FileNotFoundException, IOException, JAXBException {
        try (JarInputStream jarInputStream2 = new JarInputStream(jarInputStream);){
            JarEntry next = jarInputStream2.getNextJarEntry();
            while (next != null) {
                if (next.getName().equals("plugin/plugin.xml")) {
                    List<SPluginInformation> list = this.getPluginInformationFromPluginFile(jarInputStream2);
                    return list;
                }
                next = jarInputStream2.getNextJarEntry();
            }
        }
        return null;
    }

    public List<SPluginInformation> getPluginInformationFromPluginFile(InputStream inputStream) throws PluginException, FileNotFoundException, IOException, JAXBException {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor(inputStream);
        if (pluginDescriptor == null) {
            throw new PluginException("No plugin descriptor could be created");
        }
        ArrayList<SPluginInformation> list = new ArrayList<SPluginInformation>();
        this.processPluginDescriptor(pluginDescriptor, list);
        return list;
    }

    public void processPluginDescriptor(PluginDescriptor pluginDescriptor, List<SPluginInformation> list) {
        for (AbstractPlugin pluginImplementation : pluginDescriptor.getPlugins()) {
            SPluginInformation sPluginInformation;
            if (pluginImplementation instanceof JavaPlugin) {
                JavaPlugin javaPlugin = (JavaPlugin)pluginImplementation;
                sPluginInformation = new SPluginInformation();
                String name = javaPlugin.getName();
                if (name == null) {
                    name = javaPlugin.getImplementationClass();
                }
                sPluginInformation.setName(name);
                sPluginInformation.setDescription(javaPlugin.getDescription());
                sPluginInformation.setEnabled(true);
                sPluginInformation.setIdentifier(javaPlugin.getImplementationClass());
                sPluginInformation.setType(this.getPluginTypeFromClass(javaPlugin.getInterfaceClass()));
                list.add(sPluginInformation);
                continue;
            }
            if (!(pluginImplementation instanceof org.bimserver.plugins.WebModulePlugin)) continue;
            org.bimserver.plugins.WebModulePlugin webModulePlugin = (org.bimserver.plugins.WebModulePlugin)pluginImplementation;
            sPluginInformation = new SPluginInformation();
            sPluginInformation.setIdentifier(webModulePlugin.getIdentifier());
            sPluginInformation.setName(webModulePlugin.getName());
            sPluginInformation.setDescription(webModulePlugin.getDescription());
            sPluginInformation.setType(SPluginType.WEB_MODULE);
            sPluginInformation.setEnabled(true);
            list.add(sPluginInformation);
        }
    }

    public List<SPluginInformation> getPluginInformationFromPluginFile(Path file) throws PluginException, FileNotFoundException, IOException, JAXBException {
        ArrayList<SPluginInformation> list = new ArrayList<SPluginInformation>();
        try (InputStream pluginStream = Files.newInputStream(file, new OpenOption[0]);){
            PluginDescriptor pluginDescriptor = this.getPluginDescriptor(pluginStream);
            if (pluginDescriptor == null) {
                throw new PluginException("No plugin descriptor could be created");
            }
            this.processPluginDescriptor(pluginDescriptor, list);
        }
        return list;
    }

    public SPluginType getPluginTypeFromClass(String className) {
        switch (className) {
            case "org.bimserver.plugins.deserializers.DeserializerPlugin": {
                return SPluginType.DESERIALIZER;
            }
            case "org.bimserver.plugins.deserializers.StreamingDeserializerPlugin": {
                return SPluginType.DESERIALIZER;
            }
            case "org.bimserver.plugins.serializers.SerializerPlugin": {
                return SPluginType.SERIALIZER;
            }
            case "org.bimserver.plugins.serializers.StreamingSerializerPlugin": {
                return SPluginType.SERIALIZER;
            }
            case "org.bimserver.plugins.serializers.MessagingStreamingSerializerPlugin": {
                return SPluginType.SERIALIZER;
            }
            case "org.bimserver.plugins.serializers.MessagingSerializerPlugin": {
                return SPluginType.SERIALIZER;
            }
            case "org.bimserver.plugins.modelchecker.ModelCheckerPlugin": {
                return SPluginType.MODEL_CHECKER;
            }
            case "org.bimserver.plugins.modelmerger.ModelMergerPlugin": {
                return SPluginType.MODEL_MERGER;
            }
            case "org.bimserver.plugins.modelcompare.ModelComparePlugin": {
                return SPluginType.MODEL_COMPARE;
            }
            case "org.bimserver.plugins.objectidms.ObjectIDMPlugin": {
                return SPluginType.OBJECT_IDM;
            }
            case "org.bimserver.plugins.queryengine.QueryEnginePlugin": {
                return SPluginType.QUERY_ENGINE;
            }
            case "org.bimserver.plugins.services.ServicePlugin": {
                return SPluginType.SERVICE;
            }
            case "org.bimserver.plugins.renderengine.RenderEnginePlugin": {
                return SPluginType.RENDER_ENGINE;
            }
            case "org.bimserver.plugins.stillimagerenderer.StillImageRenderPlugin": {
                return SPluginType.STILL_IMAGE_RENDER;
            }
            case "org.bimserver.plugins.web.WebModulePlugin": {
                return SPluginType.WEB_MODULE;
            }
        }
        return null;
    }

    public void notifyPluginStateChange(PluginContext pluginContext, boolean enabled) {
        if (this.pluginChangeListener != null) {
            this.pluginChangeListener.pluginStateChanged(pluginContext, enabled);
        }
    }

    public SerializerPlugin getSerializerPlugin(String pluginClassName) {
        return this.getPluginByClassName(SerializerPlugin.class, pluginClassName, true);
    }

    public BasicServerInfo getBasicServerInfo() {
        return this.basicServerInfoProvider.getBasicServerInfo();
    }

    public long pluginBundleUpdated(PluginBundle pluginBundle) {
        if (this.pluginChangeListener != null) {
            return this.pluginChangeListener.pluginBundleUpdated(pluginBundle);
        }
        return -1L;
    }

    public void pluginUpdated(long pluginBundleVersionId, PluginContext pluginContext, SPluginInformation sPluginInformation) throws BimserverDatabaseException {
        if (this.pluginChangeListener != null) {
            this.pluginChangeListener.pluginUpdated(pluginBundleVersionId, pluginContext, sPluginInformation);
        }
    }

    public long pluginBundleInstalled(PluginBundle pluginBundle) {
        if (this.pluginChangeListener != null) {
            return this.pluginChangeListener.pluginBundleInstalled(pluginBundle);
        }
        return -1L;
    }

    public void pluginInstalled(long pluginBundleVersionId, PluginContext pluginContext, SPluginInformation sPluginInformation) throws BimserverDatabaseException {
        if (this.pluginChangeListener != null) {
            this.pluginChangeListener.pluginInstalled(pluginBundleVersionId, pluginContext, sPluginInformation);
        }
    }

    public void pluginUninstalled(PluginContext pluginContext) {
        if (this.pluginChangeListener != null) {
            this.pluginChangeListener.pluginUninstalled(pluginContext);
        }
    }

    public void pluginBundleUninstalled(PluginBundle pluginBundle) {
        if (this.pluginChangeListener != null) {
            this.pluginChangeListener.pluginBundleUninstalled(pluginBundle);
        }
    }

    public void removeImplementation(PluginContext pluginContext) {
        Set<PluginContext> set = this.implementations.get(pluginContext.getPluginInterface());
        set.remove(pluginContext);
    }

    public ClassLoader getClassLoaderFor(String pluginClassName) {
        for (Class<? extends Plugin> class1 : this.implementations.keySet()) {
            Set<PluginContext> set = this.implementations.get(class1);
            for (PluginContext pluginContext : set) {
                if (!pluginContext.getPlugin().getClass().getName().contentEquals(pluginClassName)) continue;
                return pluginContext.getPlugin().getClass().getClassLoader();
            }
        }
        return this.getClass().getClassLoader();
    }

    static {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PluginDescriptor.class});
            PLUGIN_DESCRIPTOR_UNMARSHALLER = jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

