/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bimserver.emf.IfcModelInterface;
import org.bimserver.emf.IfcModelInterfaceException;
import org.bimserver.models.ifc2x3tc1.IfcColourOrFactor;
import org.bimserver.models.ifc2x3tc1.IfcColourRgb;
import org.bimserver.models.ifc2x3tc1.IfcLayeredItem;
import org.bimserver.models.ifc2x3tc1.IfcMappedItem;
import org.bimserver.models.ifc2x3tc1.IfcPresentationLayerAssignment;
import org.bimserver.models.ifc2x3tc1.IfcPresentationStyleAssignment;
import org.bimserver.models.ifc2x3tc1.IfcProduct;
import org.bimserver.models.ifc2x3tc1.IfcProductDefinitionShape;
import org.bimserver.models.ifc2x3tc1.IfcProductRepresentation;
import org.bimserver.models.ifc2x3tc1.IfcRepresentation;
import org.bimserver.models.ifc2x3tc1.IfcRepresentationItem;
import org.bimserver.models.ifc2x3tc1.IfcRepresentationMap;
import org.bimserver.models.ifc2x3tc1.IfcShapeAspect;
import org.bimserver.models.ifc2x3tc1.IfcShapeModel;
import org.bimserver.models.ifc2x3tc1.IfcStyleModel;
import org.bimserver.models.ifc2x3tc1.IfcStyledItem;
import org.bimserver.models.ifc2x3tc1.IfcSurfaceStyle;
import org.bimserver.models.ifc2x3tc1.IfcSurfaceStyleRendering;
import org.bimserver.models.ifc2x3tc1.IfcTopologyRepresentation;

public class ModelColorizer {
    private static final float TRANSPARENCY = 0.98f;
    private IfcModelInterface model;
    private final Map<IfcStyledItem, Set<IfcProduct>> styledItemToProduct = new HashMap<IfcStyledItem, Set<IfcProduct>>();
    private final Map<IfcProduct, Set<IfcStyledItem>> productToStyledItem = new HashMap<IfcProduct, Set<IfcStyledItem>>();

    public ModelColorizer(IfcModelInterface model) {
        this.model = model;
        for (IfcProduct product : model.getAllWithSubTypes(IfcProduct.class)) {
            IfcProductRepresentation productRepresentation = product.getRepresentation();
            if (productRepresentation == null) continue;
            if (productRepresentation instanceof IfcProductDefinitionShape) {
                IfcProductDefinitionShape productDefinitionShape = (IfcProductDefinitionShape)productRepresentation;
                for (IfcRepresentation representation : productDefinitionShape.getRepresentations()) {
                    this.processRepresentation(product, representation);
                }
                for (IfcShapeAspect shapeAspect : productDefinitionShape.getHasShapeAspects()) {
                    for (IfcShapeModel shapeModel : shapeAspect.getShapeRepresentations()) {
                        this.processRepresentation(product, (IfcRepresentation)shapeModel);
                    }
                }
            }
            for (IfcRepresentation representation : productRepresentation.getRepresentations()) {
                this.processRepresentation(product, representation);
            }
        }
        for (IfcStyledItem styledItem : this.styledItemToProduct.keySet()) {
            System.out.println(styledItem);
            System.out.println();
            for (IfcProduct product : this.styledItemToProduct.get(styledItem)) {
                System.out.println("\t" + product);
            }
            System.out.println();
        }
    }

    private void link(IfcProduct product, IfcStyledItem styledItem) {
        if (!this.styledItemToProduct.containsKey(styledItem)) {
            this.styledItemToProduct.put(styledItem, new HashSet());
        }
        if (!this.productToStyledItem.containsKey(product)) {
            this.productToStyledItem.put(product, new HashSet());
        }
        this.styledItemToProduct.get(styledItem).add(product);
        this.productToStyledItem.get(product).add(styledItem);
    }

    private void processRepresentation(IfcProduct product, IfcRepresentation representation) {
        if (representation instanceof IfcPresentationLayerAssignment) {
            IfcPresentationLayerAssignment presentationLayerAssignment = (IfcPresentationLayerAssignment)representation;
            for (IfcLayeredItem layeredItem : presentationLayerAssignment.getAssignedItems()) {
                if (layeredItem instanceof IfcRepresentation) {
                    this.processRepresentation(product, (IfcRepresentation)layeredItem);
                    continue;
                }
                if (!(layeredItem instanceof IfcRepresentationItem)) continue;
                this.processRepresentationItem(product, representation, (IfcRepresentationItem)layeredItem);
            }
        } else if (representation instanceof IfcStyleModel || representation instanceof IfcShapeModel || representation instanceof IfcTopologyRepresentation) {
            // empty if block
        }
        for (IfcRepresentationMap representationMap : representation.getRepresentationMap()) {
            for (IfcMappedItem mappedItem : representationMap.getMapUsage()) {
                if (!(mappedItem instanceof IfcRepresentationItem)) continue;
                this.processRepresentationItem(product, representation, (IfcRepresentationItem)mappedItem);
            }
        }
        for (IfcRepresentationItem representationItem : representation.getItems()) {
            this.processRepresentationItem(product, representation, representationItem);
        }
    }

    private void processRepresentationItem(IfcProduct product, IfcRepresentation representation, IfcRepresentationItem representationItem) {
        if (representation instanceof IfcStyledItem) {
            this.link(product, (IfcStyledItem)representation);
        }
        for (IfcStyledItem styledItem : representationItem.getStyledByItem()) {
            this.link(product, styledItem);
        }
    }

    public void setColor(IfcProduct product, double[] color, float transparency) throws IfcModelInterfaceException {
        if (!this.productToStyledItem.containsKey(product) || this.productToStyledItem.get(product).isEmpty()) {
            System.out.println("No style for " + product + " " + product.getGlobalId());
            IfcProductRepresentation productRepresentation = product.getRepresentation();
            if (product.getRepresentation() == null) {
                productRepresentation = (IfcProductRepresentation)this.model.create(IfcProductRepresentation.class);
                product.setRepresentation(productRepresentation);
            }
            IfcRepresentation representation = null;
            if (productRepresentation.getRepresentations().isEmpty()) {
                representation = (IfcRepresentation)this.model.create(IfcRepresentation.class);
                productRepresentation.getRepresentations().add((Object)representation);
            } else {
                representation = (IfcRepresentation)productRepresentation.getRepresentations().get(0);
            }
            IfcRepresentationItem representationItem = null;
            if (representation.getItems().isEmpty()) {
                representationItem = (IfcRepresentationItem)this.model.create(IfcRepresentationItem.class);
                representation.getItems().add((Object)representationItem);
            } else {
                representationItem = (IfcRepresentationItem)representation.getItems().get(0);
            }
            IfcStyledItem styledItem = (IfcStyledItem)this.model.create(IfcStyledItem.class);
            representationItem.getStyledByItem().clear();
            representationItem.getStyledByItem().add((Object)styledItem);
            this.createStyle(color, transparency, styledItem);
        } else if (this.productToStyledItem.get(product).size() == 1) {
            IfcStyledItem styledItem = this.productToStyledItem.get(product).iterator().next();
            Set<IfcProduct> products = this.styledItemToProduct.get(styledItem);
            if (!products.isEmpty() && products.size() == 1) {
                this.createStyle(color, transparency, styledItem);
            }
        } else {
            System.out.println(this.productToStyledItem.get(product).size() + " styles for " + product);
        }
    }

    private void createStyle(double[] color, float transparency, IfcStyledItem styledItem) throws IfcModelInterfaceException {
        IfcPresentationStyleAssignment presentationStyleAssignment = null;
        if (styledItem.getStyles().isEmpty()) {
            presentationStyleAssignment = (IfcPresentationStyleAssignment)this.model.create(IfcPresentationStyleAssignment.class);
            styledItem.getStyles().add((Object)presentationStyleAssignment);
        } else {
            presentationStyleAssignment = (IfcPresentationStyleAssignment)styledItem.getStyles().get(0);
        }
        IfcSurfaceStyle surfaceStyle = null;
        if (presentationStyleAssignment.getStyles().isEmpty()) {
            surfaceStyle = (IfcSurfaceStyle)this.model.create(IfcSurfaceStyle.class);
            presentationStyleAssignment.getStyles().add((Object)surfaceStyle);
        } else if (presentationStyleAssignment.getStyles().get(0) instanceof IfcSurfaceStyle) {
            surfaceStyle = (IfcSurfaceStyle)presentationStyleAssignment.getStyles().get(0);
        } else {
            surfaceStyle = (IfcSurfaceStyle)this.model.create(IfcSurfaceStyle.class);
            presentationStyleAssignment.getStyles().set(0, (Object)surfaceStyle);
        }
        IfcSurfaceStyleRendering surfaceStyleRendering = null;
        if (surfaceStyle.getStyles().isEmpty()) {
            surfaceStyleRendering = (IfcSurfaceStyleRendering)this.model.create(IfcSurfaceStyleRendering.class);
            surfaceStyle.getStyles().add((Object)surfaceStyleRendering);
        } else if (surfaceStyle.getStyles().get(0) instanceof IfcSurfaceStyleRendering) {
            surfaceStyleRendering = (IfcSurfaceStyleRendering)surfaceStyle.getStyles().get(0);
        } else {
            surfaceStyleRendering = (IfcSurfaceStyleRendering)this.model.create(IfcSurfaceStyleRendering.class);
            surfaceStyle.getStyles().set(0, (Object)surfaceStyleRendering);
        }
        IfcColourRgb colourRgb = (IfcColourRgb)this.model.create(IfcColourRgb.class);
        colourRgb.setRed(color[0]);
        colourRgb.setGreen(color[1]);
        colourRgb.setBlue(color[2]);
        surfaceStyleRendering.setDiffuseColour((IfcColourOrFactor)colourRgb);
        surfaceStyleRendering.setReflectionColour((IfcColourOrFactor)colourRgb);
        surfaceStyleRendering.setSpecularColour((IfcColourOrFactor)colourRgb);
        surfaceStyleRendering.setSurfaceColour(colourRgb);
        surfaceStyleRendering.setTransmissionColour((IfcColourOrFactor)colourRgb);
        surfaceStyleRendering.setTransparency((double)transparency);
    }

    public void makeTransparent(IfcProduct ifcProduct) throws IfcModelInterfaceException {
        this.setColor(ifcProduct, null, 0.98f);
    }
}

