/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.bimserver.shared.exceptions.ErrorCode;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.json.JsonConverter;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.reflector.KeyValuePair;
import org.bimserver.shared.reflector.Reflector;
import org.bimserver.shared.reflector.ReflectorException;

public abstract class JsonReflector
implements Reflector {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final JsonConverter converter;
    private final SServicesMap servicesMap;

    public JsonReflector(SServicesMap servicesMap) {
        if (servicesMap == null) {
            throw new IllegalArgumentException("servicesMap cannot be null");
        }
        this.servicesMap = servicesMap;
        this.converter = new JsonConverter(servicesMap);
    }

    public Object callMethod(String interfaceName, String methodName, Class<?> definedReturnType, KeyValuePair ... args) throws ServerException, UserException, ReflectorException {
        try {
            ObjectNode request = OBJECT_MAPPER.createObjectNode();
            request.put("interface", interfaceName);
            request.put("method", methodName);
            ObjectNode parameters = OBJECT_MAPPER.createObjectNode();
            for (KeyValuePair arg : args) {
                parameters.set(arg.getFieldName(), this.converter.toJson(arg.getValue()));
            }
            request.set("parameters", (JsonNode)parameters);
            ObjectNode requestObject = OBJECT_MAPPER.createObjectNode();
            requestObject.set("request", (JsonNode)request);
            JsonNode jsonResult = this.call(requestObject);
            if (!this.isOneWay()) {
                if (jsonResult == null) {
                    return null;
                }
                ObjectNode response = (ObjectNode)jsonResult.get("response");
                if (response.has("exception")) {
                    String message;
                    ObjectNode exceptionJson = (ObjectNode)response.get("exception");
                    String exceptionType = exceptionJson.get("__type").asText();
                    String string = message = exceptionJson.has("message") ? exceptionJson.get("message").asText() : "unknown";
                    if (exceptionType.equals(UserException.class.getSimpleName())) {
                        if (exceptionJson.has("errorCode")) {
                            throw new UserException(message, ErrorCode.parse((int)exceptionJson.get("errorCode").asInt()));
                        }
                        throw new UserException(message);
                    }
                    if (exceptionType.equals(ServerException.class.getSimpleName())) {
                        if (exceptionJson.has("errorCode")) {
                            throw new ServerException(message, ErrorCode.parse((int)exceptionJson.get("errorCode").asInt()));
                        }
                        throw new ServerException(message);
                    }
                    if (exceptionJson.has("errorCode")) {
                        throw new ServerException(message, ErrorCode.parse((int)exceptionJson.get("errorCode").asInt()));
                    }
                    throw new ServerException(message);
                }
                if (response.has("result")) {
                    JsonNode result = response.get("result");
                    SMethod method = this.servicesMap.getBySimpleName(interfaceName).getSMethod(methodName);
                    return this.converter.fromJson(method.getReturnType(), method.getGenericReturnType(), result);
                }
                return null;
            }
            return null;
        }
        catch (ReflectorException e) {
            throw e;
        }
        catch (UserException e) {
            throw e;
        }
        catch (ServerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReflectorException(e);
        }
    }

    protected boolean isOneWay() {
        return false;
    }

    public abstract JsonNode call(ObjectNode var1) throws ReflectorException;

    public void close() {
    }

    public JsonConverter getConverter() {
        return this.converter;
    }
}

