/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.shared.pb;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.ServiceException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.DataHandler;
import org.apache.commons.io.IOUtils;
import org.bimserver.shared.exceptions.ServerException;
import org.bimserver.shared.exceptions.UserException;
import org.bimserver.shared.meta.SBase;
import org.bimserver.shared.meta.SMethod;
import org.bimserver.shared.meta.SServicesMap;
import org.bimserver.shared.pb.ConvertException;
import org.bimserver.shared.pb.ProtocolBuffersConverter;
import org.bimserver.shared.pb.ProtocolBuffersMetaData;
import org.bimserver.shared.pb.ServiceMethodNotFoundException;
import org.bimserver.shared.pb.ServiceNotFoundException;
import org.bimserver.shared.pb.SocketProtocolBuffersChannel;
import org.bimserver.shared.reflector.KeyValuePair;
import org.bimserver.shared.reflector.Reflector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolBuffersReflector
extends ProtocolBuffersConverter
implements Reflector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolBuffersReflector.class);
    private final ProtocolBuffersMetaData protocolBuffersMetaData;
    private final SocketProtocolBuffersChannel channel;
    private SServicesMap servicesMap;

    public ProtocolBuffersReflector(ProtocolBuffersMetaData protocolBuffersMetaData, SServicesMap servicesMap, SocketProtocolBuffersChannel channel) {
        super(protocolBuffersMetaData);
        this.protocolBuffersMetaData = protocolBuffersMetaData;
        this.servicesMap = servicesMap;
        this.channel = channel;
    }

    public Object callMethod(String interfaceName, String methodName, Class<?> definedReturnType, KeyValuePair ... args) throws ServerException, UserException {
        try {
            try {
                Descriptors.FieldDescriptor errorMessageField;
                ProtocolBuffersMetaData.MethodDescriptorContainer methodDescriptorContainer = this.protocolBuffersMetaData.getMethod(interfaceName, methodName);
                SMethod sMethod = this.servicesMap.getBySimpleName(interfaceName).getSMethod(methodName);
                Descriptors.Descriptor inputDescriptor = methodDescriptorContainer.getInputDescriptor();
                DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)methodDescriptorContainer.getInputDescriptor());
                int i = 0;
                for (Descriptors.FieldDescriptor field : inputDescriptor.getFields()) {
                    Object arg = args[i].getValue();
                    if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                        Descriptors.EnumDescriptor enumType = field.getEnumType();
                        builder.setField(field, (Object)enumType.findValueByName(arg.toString()));
                    } else if (arg instanceof SBase) {
                        builder.setField(field, (Object)this.convertSObjectToProtocolBuffersObject((SBase)arg, sMethod.getParameter(i).getType()));
                    } else if (arg instanceof DataHandler) {
                        DataHandler dataHandler = (DataHandler)arg;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            IOUtils.copy((InputStream)dataHandler.getInputStream(), (OutputStream)baos);
                        }
                        catch (IOException e) {
                            LOGGER.error("", (Throwable)e);
                        }
                        builder.setField(field, (Object)ByteString.copyFrom((byte[])baos.toByteArray()));
                    } else if (arg != null) {
                        if (arg instanceof Collection) {
                            Collection col = (Collection)arg;
                            for (Object o : col) {
                                builder.addRepeatedField(field, o);
                            }
                        } else {
                            builder.setField(field, arg);
                        }
                    }
                    ++i;
                }
                DynamicMessage message = builder.build();
                Message result = this.channel.callBlockingMethod(methodDescriptorContainer, (Message)message);
                String errorMessage = (String)result.getField(errorMessageField = methodDescriptorContainer.getOutputField("errorMessage"));
                if (errorMessage.equals("OKE")) {
                    if (result.getDescriptorForType().getName().equals("VoidResponse")) {
                        return null;
                    }
                    Descriptors.FieldDescriptor outputField = methodDescriptorContainer.getOutputField("value");
                    Object value = result.getField(outputField);
                    if (outputField.isRepeated()) {
                        if (value instanceof Collection) {
                            Collection collection = (Collection)value;
                            AbstractCollection x = null;
                            if (definedReturnType == List.class) {
                                x = new ArrayList();
                            } else if (definedReturnType == Set.class) {
                                x = new HashSet();
                            }
                            for (Object v : collection) {
                                if (v instanceof DynamicMessage) {
                                    x.add(this.convertProtocolBuffersMessageToSObject((Message)((DynamicMessage)v), null, sMethod.getBestReturnType()));
                                    continue;
                                }
                                x.add(v);
                            }
                            return x;
                        }
                        return new ArrayList();
                    }
                    if (outputField.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
                        Descriptors.EnumDescriptor enumType = outputField.getEnumType();
                        return enumType.findValueByName(value.toString());
                    }
                    if (value instanceof DynamicMessage) {
                        return this.convertProtocolBuffersMessageToSObject((Message)((DynamicMessage)value), null, sMethod.getBestReturnType());
                    }
                    if (definedReturnType == Date.class) {
                        return new Date((Long)value);
                    }
                    return value;
                }
                throw new UserException(errorMessage);
            }
            catch (ConvertException e) {
                throw new ServerException((Throwable)e);
            }
            catch (ServiceException e) {
                throw new ServerException(e.getMessage());
            }
        }
        catch (ServiceNotFoundException e) {
            throw new ServerException((Throwable)e);
        }
        catch (ServiceMethodNotFoundException e) {
            throw new ServerException((Throwable)e);
        }
    }
}

