/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.compare;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewIfcFileCompare {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewIfcFileCompare.class);
    private final File sourceFile;
    private final File destFile;
    private List<String> sortFile1;
    private List<String> sortFile2;

    public NewIfcFileCompare(File sourceFile, File destFile) {
        this.sourceFile = sourceFile;
        this.destFile = destFile;
    }

    public List<String> sortFile(File sourceFile) {
        LinkedList<String> lines = new LinkedList<String>();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(sourceFile));
            String line = reader.readLine();
            while (line != null) {
                line = line.replace(" ", "").trim();
                while (!line.endsWith(";")) {
                    line = line + reader.readLine();
                }
                if (!line.equals("") && line.startsWith("#") && line.endsWith(";") && line.contains("=")) {
                    lines.add(line);
                }
                line = reader.readLine();
            }
            reader.close();
            Collections.sort(lines, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1.startsWith("#") && o2.startsWith("#") && o1.indexOf("=") != -1 && o2.indexOf("=") != -1) {
                        int diff = o1.substring(o1.indexOf("=")).compareTo(o2.substring(o2.indexOf("=")));
                        return diff += 100 * (Integer.parseInt(o1.substring(1, o1.indexOf("="))) - Integer.parseInt(o2.substring(1, o2.indexOf("="))));
                    }
                    return o1.compareTo(o2);
                }
            });
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("", (Throwable)e);
        }
        return lines;
    }

    public boolean compare() {
        this.sortFile1 = this.sortFile(this.sourceFile);
        this.sortFile2 = this.sortFile(this.destFile);
        if (this.sortFile1.size() != this.sortFile2.size()) {
            return this.returnFalse();
        }
        for (int i = 0; i < this.sortFile1.size(); ++i) {
            if (this.sortFile1.get(i).equals(this.sortFile2.get(i))) continue;
            return this.returnFalse();
        }
        return true;
    }

    private boolean returnFalse() {
        return false;
    }

    public void dumpSource(File file) {
        this.dumpFile(this.sortFile1, file);
    }

    public void dumpGenerated(File file) {
        this.dumpFile(this.sortFile2, file);
    }

    private void dumpFile(List<String> lines, File file) {
        try {
            PrintWriter out = new PrintWriter(file);
            for (String line : lines) {
                out.println(line);
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

