/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;

public class ExtendedMetaModel {
    private final Random random = new Random();
    private final EPackage ePackage;
    private final Map<EClass, List<EClass>> directSubClasses = new HashMap<EClass, List<EClass>>();
    private final Map<EClass, List<EClass>> inheritedSubClasses = new HashMap<EClass, List<EClass>>();

    public ExtendedMetaModel(EPackage ePackage) {
        this.ePackage = ePackage;
        this.init();
    }

    private void init() {
        for (EClassifier eClassifier : this.ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            this.directSubClasses.put((EClass)eClassifier, new ArrayList());
            this.inheritedSubClasses.put((EClass)eClassifier, new ArrayList());
        }
        for (EClassifier eClassifier : this.ePackage.getEClassifiers()) {
            if (!(eClassifier instanceof EClass)) continue;
            EClass eClass = (EClass)eClassifier;
            for (EClass superClass : eClass.getESuperTypes()) {
                this.directSubClasses.get(superClass).add(eClass);
            }
        }
        for (EClass eClass : this.directSubClasses.keySet()) {
            this.addInheritedSubClasses(eClass, eClass);
        }
    }

    private void addInheritedSubClasses(EClass eClass, EClass currentEClass) {
        for (EClass e : this.directSubClasses.get(currentEClass)) {
            this.inheritedSubClasses.get(eClass).add(e);
            this.addInheritedSubClasses(eClass, e);
        }
    }

    public EClass getRandomInstantiableSubClassOrSelf(EClass eType) {
        List<EClass> list = this.inheritedSubClasses.get(eType);
        EClass result = null;
        result = this.random.nextInt(list.size() + 1) == 0 ? eType : list.get(this.random.nextInt(list.size()));
        if (result.isAbstract() || result.isInterface()) {
            return this.getRandomInstantiableSubClassOrSelf(eType);
        }
        return result;
    }
}

