/*
 * Decompiled with CFR 0.152.
 */
package org.bimserver.ifc.printer;

import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;

public class IfcPrinter {
    public void printMap(Map<Long, EObject> map) {
        for (Long key : map.keySet()) {
            EObject object = map.get(key);
            System.out.println("#" + key + " " + object.eClass().getName());
            for (EAttribute attribute : object.eClass().getEAllAttributes()) {
                System.out.println("\t" + attribute.getName() + "(" + attribute.getEType().getName() + "): " + object.eGet((EStructuralFeature)attribute));
            }
            for (EReference reference : object.eClass().getEAllReferences()) {
                System.out.println("\t" + reference.getName() + "(" + reference.getEReferenceType().getName() + "): ");
                if (object.eGet((EStructuralFeature)reference) instanceof EObjectResolvingEList) {
                    EObjectResolvingEList referencedObjectList = (EObjectResolvingEList)object.eGet((EStructuralFeature)reference);
                    if (referencedObjectList != null && referencedObjectList.size() > 0) {
                        if (reference.getEReferenceType().getEStructuralFeature("wrappedValue") != null) {
                            for (Object obj : referencedObjectList) {
                                Object wrappedValue = ((EObject)obj).eGet(reference.getEReferenceType().getEStructuralFeature("wrappedValue"));
                                System.out.println(wrappedValue.toString());
                                if (referencedObjectList.get(referencedObjectList.size() - 1) == obj) continue;
                                System.out.println();
                                System.out.println("\t" + reference.getName() + "(" + reference.getEReferenceType().getName() + "): ");
                            }
                        } else {
                            for (Object obj : referencedObjectList) {
                                if (obj == null) continue;
                                System.out.println("=> ");
                            }
                        }
                    }
                } else if (reference.getEReferenceType().getEStructuralFeature("wrappedValue") == null) {
                    if (object.eGet((EStructuralFeature)reference) != null) {
                        System.out.println("=>");
                    } else {
                        System.out.println("null");
                    }
                }
                System.out.println();
            }
        }
    }
}

